from django.contrib import admin
from django.urls import path, include
from django.contrib.auth import views as auth_views
from . import views
from django.contrib.auth.decorators import login_required


app_name = 'api'
urlpatterns = [    
    path('search_auto', views.search_auto, name='search'),
    path('tuplah', views.tuplah, name='tuplah'),
    path('building', views.building, name='building'),
    
    path('jalan', views.jalan, name='jalan'),
    path('sungai', views.sungai, name='sungai'),
    path('edit', views.editpoly, name='edit'),
    path('validatedit', views.validatedit, name='validatedit'),
    path('hapus', views.hapus, name='hapus'),
    path('hasilsearch', views.hasilsearch, name='ressearch'),
    
    path('editkependudukan/', views.editkependudukan, name='kependudukan'),
    
    path('valideditkependudukan', views.valideditkependudukan, name='valideditkependudukan'),
    path('editkantor', views.editpointka, name='editkantor'),
    path('editlakes', views.editpointlk, name='editlakes'),
    path('editpks', views.editpointpks, name='editpks'),
    path('editrs', views.editpointrs, name='editrs'),
    path('editsi', views.editpointsi, name='editsi'),
    path('editsp', views.editpointsp, name='editsp'),
    path('editpom', views.editpointspbu, name='editpom'),
    path('editst', views.editpointst, name='editst'),
    path('editgl', views.editpointgl, name='editgl'),
    path('edittr', views.editpointtr, name='edittr'),
    path('editcb', views.editpointcb, name='editcb'),
    
    path('rumahsakit', views.editrumahsakit, name='rumahsakit'),
    path('cagarbudaya', views.editcagarbudaya, name='cagarbudaya'),
    path('kantor', views.editkantoradmin, name='kantor'),
    path('layanankesehatan', views.editlayanankesehatan, name='layanankesehatan'),
    path('puskesmas', views.editpuskesmas, name='puskesmas'),
    path('ibadah', views.editibadah, name='ibadah'),
    path('sekolah', views.editsekolah, name='sekolah'),
    path('spbu', views.editspbu, name='spbu'),
    path('stasiun', views.editstasiun, name='stasiun'),
    path('terminal', views.editterminal, name='terminal'),
    path('gardu', views.editgardu, name='gardu'),
    
    path('hapus', views.hapus, name='hapus'),
    path('tampak', views.upload_tampak, name='tampak'),
    path('dkantor', views.deletekantoradmin, name='dkantor'),
    
    path('change-tipe', views.changetipe, name='change-tipe'),
    path('change-jenis', views.changejenis, name='change-jenis'),
    
    path('c_bangunan', views.createbang, name='c_bangunan'),
    path('create-jalan', views.createjalan, name='create-jalan'),
    path('create-point', views.createpoint, name='create-point'),
    
    path('edit-tuplah', login_required(views.edittuplah), name='edit-tuplah'),
    path('edit-tuplah-valid', views.edittuplahvalid, name='edit-tuplah-valid'),
    
    path('edit-jalan', views.editjalan, name='edit-jalan'),
    path('edit-jalan-valid', views.editjalanvalid, name='edit-jalan-valid'),
    path('3d-maps', views.maps3d, name='3d-maps'),

    path('deletejalan', views.deletejalan, name='hapus-jalan')
        
]