define(["exports","./Transforms-d5c6ad6e","./Matrix2-ccd5b911","./RuntimeError-346a3079","./when-4bbc8319","./AttributeCompression-1f045b73","./ComponentDatatype-93750d1a"],function(e,r,f,t,p,l,h){"use strict";function i(e,t){this._ellipsoid=e,this._cameraPosition=new f.Cartesian3,this._cameraPositionInScaledSpace=new f.Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,p.defined(t)&&(this.cameraPosition=t)}Object.defineProperties(i.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=f.Cartesian3.magnitudeSquared(t)-1;f.Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=i}}});var a=new f.Cartesian3;i.prototype.isPointVisible=function(e){return S(this._ellipsoid.transformPositionToScaledSpace(e,a),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},i.prototype.isScaledSpacePointVisible=function(e){return S(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var o=new f.Cartesian3;i.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){var i,a=this._ellipsoid,t=p.defined(t)&&t<0&&a.minimumRadius>-t?((i=o).x=this._cameraPosition.x/(a.radii.x+t),i.y=this._cameraPosition.y/(a.radii.y+t),i.z=this._cameraPosition.z/(a.radii.z+t),i.x*i.x+i.y*i.y+i.z*i.z-1):(i=this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared);return S(e,i,t)},i.prototype.computeHorizonCullingPoint=function(e,t,i){return u(this._ellipsoid,e,t,i)};var n=f.Ellipsoid.clone(f.Ellipsoid.UNIT_SPHERE);i.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,i,a){return u(d(this._ellipsoid,i,n),e,t,a)},i.prototype.computeHorizonCullingPointFromVertices=function(e,t,i,a,r){return x(this._ellipsoid,e,t,i,a,r)},i.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,i,a,r,o){return x(d(this._ellipsoid,r,n),e,t,i,a,o)};var s=[];i.prototype.computeHorizonCullingPointFromRectangle=function(e,t,i){var a=f.Rectangle.subsample(e,t,0,s),e=r.BoundingSphere.fromPoints(a);if(!(f.Cartesian3.magnitude(e.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(e.center,a,i)};var c=new f.Cartesian3;function d(e,t,i){return p.defined(t)&&t<0&&e.minimumRadius>-t&&(t=f.Cartesian3.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,c),e=f.Ellipsoid.fromCartesian3(t,i)),e}function u(e,t,i,a){p.defined(a)||(a=new f.Cartesian3);for(var r=T(e,t),o=0,n=0,s=i.length;n<s;++n){var c=y(e,i[n],r);if(c<0)return;o=Math.max(o,c)}return N(r,o,a)}var m=new f.Cartesian3;function x(e,t,i,a,r,o){p.defined(o)||(o=new f.Cartesian3),a=p.defaultValue(a,3),r=p.defaultValue(r,f.Cartesian3.ZERO);for(var n=T(e,t),s=0,c=0,d=i.length;c<d;c+=a){m.x=i[c]+r.x,m.y=i[c+1]+r.y,m.z=i[c+2]+r.z;var u=y(e,m,n);if(u<0)return;s=Math.max(s,u)}return N(n,s,o)}function S(e,t,i){e=f.Cartesian3.subtract(e,t,a),t=-f.Cartesian3.dot(e,t);return!(i<0?0<t:i<t&&t*t/f.Cartesian3.magnitudeSquared(e)>i)}var C=new f.Cartesian3,g=new f.Cartesian3;function y(e,t,i){var a=e.transformPositionToScaledSpace(t,C),e=f.Cartesian3.magnitudeSquared(a),t=Math.sqrt(e),a=f.Cartesian3.divideByScalar(a,t,g),e=Math.max(1,e),t=1/(t=Math.max(1,t));return 1/(f.Cartesian3.dot(a,i)*t-f.Cartesian3.magnitude(f.Cartesian3.cross(a,i,a))*(Math.sqrt(e-1)*t))}function N(e,t,i){if(!(t<=0||t===1/0||t!=t))return f.Cartesian3.multiplyByScalar(e,t,i)}var M=new f.Cartesian3;function T(e,t){return f.Cartesian3.equals(t,f.Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,M),f.Cartesian3.normalize(M,M))}var b={getHeight:function(e,t,i){return(e-i)*t+i}},P=new f.Cartesian3;b.getPosition=function(e,t,i,a,r){e=t.cartesianToCartographic(e,P),a=b.getHeight(e.height,i,a);return f.Cartesian3.fromRadians(e.longitude,e.latitude,a,t,r)};var v=Object.freeze({NONE:0,BITS12:1}),z=new f.Cartesian3,_=new f.Cartesian3,E=new f.Cartesian2,H=new f.Matrix4,w=new f.Matrix4,A=Math.pow(2,12);function I(e,t,i,a,r,o,n,s,c,d){var u,m,l,h=v.NONE;p.defined(t)&&p.defined(i)&&p.defined(a)&&p.defined(r)&&(l=t.minimum,u=t.maximum,t=f.Cartesian3.subtract(u,l,_),m=a-i,h=Math.max(f.Cartesian3.maximumComponent(t),m)<A-1?v.BITS12:v.NONE,u=f.Matrix4.inverseTransformation(r,new f.Matrix4),m=f.Cartesian3.negate(l,z),f.Matrix4.multiply(f.Matrix4.fromTranslation(m,H),u,u),(m=z).x=1/t.x,m.y=1/t.y,m.z=1/t.z,f.Matrix4.multiply(f.Matrix4.fromScale(m,H),u,u),m=f.Matrix4.clone(r),f.Matrix4.setTranslation(m,f.Cartesian3.ZERO,m),r=f.Matrix4.clone(r,new f.Matrix4),l=f.Matrix4.fromTranslation(l,H),t=f.Matrix4.fromScale(t,w),t=f.Matrix4.multiply(l,t,H),f.Matrix4.multiply(r,t,r),f.Matrix4.multiply(m,t,m)),this.quantization=h,this.minimumHeight=i,this.maximumHeight=a,this.center=f.Cartesian3.clone(e),this.toScaledENU=u,this.fromScaledENU=r,this.matrix=m,this.hasVertexNormals=o,this.hasWebMercatorT=p.defaultValue(n,!1),this.hasGeodeticSurfaceNormals=p.defaultValue(s,!1),this.exaggeration=p.defaultValue(c,1),this.exaggerationRelativeHeight=p.defaultValue(d,0),this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}I.prototype.encode=function(e,t,i,a,r,o,n,s){var c,d,u=a.x,m=a.y;return this.quantization===v.BITS12?((i=f.Matrix4.multiplyByPoint(this.toScaledENU,i,z)).x=h.CesiumMath.clamp(i.x,0,1),i.y=h.CesiumMath.clamp(i.y,0,1),i.z=h.CesiumMath.clamp(i.z,0,1),c=this.maximumHeight-this.minimumHeight,d=h.CesiumMath.clamp((r-this.minimumHeight)/c,0,1),f.Cartesian2.fromElements(i.x,i.y,E),a=l.AttributeCompression.compressTextureCoordinates(E),f.Cartesian2.fromElements(i.z,d,E),c=l.AttributeCompression.compressTextureCoordinates(E),f.Cartesian2.fromElements(u,m,E),d=l.AttributeCompression.compressTextureCoordinates(E),e[t++]=a,e[t++]=c,e[t++]=d,this.hasWebMercatorT&&(f.Cartesian2.fromElements(n,0,E),d=l.AttributeCompression.compressTextureCoordinates(E),e[t++]=d)):(f.Cartesian3.subtract(i,this.center,z),e[t++]=z.x,e[t++]=z.y,e[t++]=z.z,e[t++]=r,e[t++]=u,e[t++]=m,this.hasWebMercatorT&&(e[t++]=n)),this.hasVertexNormals&&(e[t++]=l.AttributeCompression.octPackFloat(o)),this.hasGeodeticSurfaceNormals&&(e[t++]=s.x,e[t++]=s.y,e[t++]=s.z),t};var q=new f.Cartesian3,V=new f.Cartesian3;I.prototype.addGeodeticSurfaceNormals=function(e,t,i){if(!this.hasGeodeticSurfaceNormals){var a=this.stride,r=e.length/a;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();for(var o=this.stride,n=0;n<r;n++){for(var s=0;s<a;s++)t[n*o+s]=e[n*a+s];var c=this.decodePosition(t,n,q),d=i.geodeticSurfaceNormal(c,V),c=n*o+this._offsetGeodeticSurfaceNormal;t[c]=d.x,t[c+1]=d.y,t[c+2]=d.z}}},I.prototype.removeGeodeticSurfaceNormals=function(e,t){if(this.hasGeodeticSurfaceNormals){var i=this.stride,a=e.length/i;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();for(var r=this.stride,o=0;o<a;o++)for(var n=0;n<r;n++)t[o*r+n]=e[o*i+n]}},I.prototype.decodePosition=function(e,t,i){if(p.defined(i)||(i=new f.Cartesian3),t*=this.stride,this.quantization!==v.BITS12)return i.x=e[t],i.y=e[t+1],i.z=e[t+2],f.Cartesian3.add(i,this.center,i);var a=l.AttributeCompression.decompressTextureCoordinates(e[t],E);i.x=a.x,i.y=a.y;t=l.AttributeCompression.decompressTextureCoordinates(e[t+1],E);return i.z=t.x,f.Matrix4.multiplyByPoint(this.fromScaledENU,i,i)},I.prototype.getExaggeratedPosition=function(e,t,i){i=this.decodePosition(e,t,i);var a,r=this.exaggeration,o=this.exaggerationRelativeHeight;return 1!==r&&this.hasGeodeticSurfaceNormals&&(a=this.decodeGeodeticSurfaceNormal(e,t,V),t=this.decodeHeight(e,t),t=b.getHeight(t,r,o)-t,i.x+=a.x*t,i.y+=a.y*t,i.z+=a.z*t),i},I.prototype.decodeTextureCoordinates=function(e,t,i){return p.defined(i)||(i=new f.Cartesian2),t*=this.stride,this.quantization===v.BITS12?l.AttributeCompression.decompressTextureCoordinates(e[t+2],i):f.Cartesian2.fromElements(e[t+4],e[t+5],i)},I.prototype.decodeHeight=function(e,t){return t*=this.stride,this.quantization!==v.BITS12?e[t+3]:l.AttributeCompression.decompressTextureCoordinates(e[t+1],E).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight},I.prototype.decodeWebMercatorT=function(e,t){return t*=this.stride,this.quantization===v.BITS12?l.AttributeCompression.decompressTextureCoordinates(e[t+3],E).x:e[t+6]},I.prototype.getOctEncodedNormal=function(e,t,i){e=e[t=t*this.stride+this._offsetVertexNormal]/256,t=Math.floor(e);return f.Cartesian2.fromElements(t,256*(e-t),i)},I.prototype.decodeGeodeticSurfaceNormal=function(e,t,i){return t=t*this.stride+this._offsetGeodeticSurfaceNormal,i.x=e[t],i.y=e[t+1],i.z=e[t+2],i},I.prototype._calculateStrideAndOffsets=function(){var e=0;this.quantization===v.BITS12?e+=3:e+=6,this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};var G={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},O={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};I.prototype.getAttributes=function(i){var e,t,a=h.ComponentDatatype.FLOAT,r=h.ComponentDatatype.getSizeInBytes(a),o=this.stride*r,n=0,s=[];function c(e,t){s.push({index:e,vertexBuffer:i,componentDatatype:a,componentsPerAttribute:t,offsetInBytes:n,strideInBytes:o}),n+=t*r}return this.quantization===v.NONE?(c(G.position3DAndHeight,4),t=2,t+=this.hasWebMercatorT?1:0,t+=this.hasVertexNormals?1:0,c(G.textureCoordAndEncodedNormals,t),this.hasGeodeticSurfaceNormals&&c(G.geodeticSurfaceNormal,3)):(e=this.hasWebMercatorT||this.hasVertexNormals,t=this.hasWebMercatorT&&this.hasVertexNormals,c(O.compressed0,e?4:3),t&&c(O.compressed1,1),this.hasGeodeticSurfaceNormals&&c(O.geodeticSurfaceNormal,3)),s},I.prototype.getAttributeLocations=function(){return this.quantization===v.NONE?G:O},I.clone=function(e,t){if(p.defined(e))return(t=!p.defined(t)?new I:t).quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=f.Cartesian3.clone(e.center),t.toScaledENU=f.Matrix4.clone(e.toScaledENU),t.fromScaledENU=f.Matrix4.clone(e.fromScaledENU),t.matrix=f.Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t},e.EllipsoidalOccluder=i,e.TerrainEncoding=I});
