from django.contrib import admin
from django.urls import path, include
from django.contrib.auth import views as auth_views
from . import views
from django.contrib.auth.decorators import login_required


app_name = 'api'
urlpatterns = [    
    path('search_auto', views.search_auto),
    
    path('kantor_administrasi', views.kantor_administrasi, name='kantor_administrasi'),
    path('layanan_kesehatan', views.layanan_kesehatan, name='layanan_kesehatan'),
    path('apiviewpuskesmas', views.apiviewpuskesmas, name='apiviewpuskesmas'),
    path('rumah_sakit', views.rumah_sakit, name='rumah_sakit'),
    path('sarana_ibadah', views.sarana_ibadah, name='sarana_ibadah'),
    path('sarana_pendidikan', views.sarana_pendidikan, name='sarana_pendidikan'),
    path('apiviewstasiun', views.apiviewstasiun, name='apiviewstasiun'),
    path('apiviewterminal', views.apiviewterminal, name='apiviewterminal'),
    path('apiviewcagarbudaya', views.apiviewcagarbudaya, name='apiviewcagarbudaya'),
    path('apiviewgardulistrik', views.apiviewgardulistrik, name='apiviewgardulistrik'),
    
    path('tuplah', views.tuplah, name='tuplah'),
    path('kecamatan', views.kecamatan, name='kecamatan'),
    path('desangab', views.desangab, name='desangab'),
    path('building', views.building, name='building'),
    
    path('edit_kec', views.editkec, name='edit_kec'),
    
    path('jalan', views.jalan, name='jalan'),
    path('sungai', views.sungai, name='sungai'),
    path('edit', views.editpoly, name='edit'),
    path('validatedit', views.validatedit, name='validatedit'),
    path('hapus', views.hapus, name='hapus'),
    path('ressearch', views.hasilsearch, name='ressearch'),
    
    path('editkependudukan/', views.editkependudukan, name='kependudukan'),
    
    path('valideditkependudukan', views.valideditkependudukan, name='valideditkependudukan'),
    
    path('editspo', views.editpointsearch, name='editspo'),
    
    path('editkantor', views.editpointka, name='editkantor'),
    path('editlakes', views.editpointlk, name='editlakes'),
    path('editpks', views.editpointpks, name='editpks'),
    path('editrs', views.editpointrs, name='editrs'),
    path('editsi', views.editpointsi, name='editsi'),
    path('editsp', views.editpointsp, name='editsp'),
    path('editpom', views.editpointspbu, name='editpom'),
    path('editst', views.editpointst, name='editst'),
    path('editgl', views.editpointgl, name='editgl'),
    path('edittr', views.editpointtr, name='edittr'),
    path('editcb', views.editpointcb, name='editcb'),
    
    path('saveeditspo', views.editsearchpoint, name='saveeditspo'),
    path('rumahsakit', views.editrumahsakit, name='rumahsakit'),
    path('cagarbudaya', views.editcagarbudaya, name='cagarbudaya'),
    path('kantor', views.editkantoradmin, name='kantor'),
    path('layanankesehatan', views.editlayanankesehatan, name='layanankesehatan'),
    path('puskesmas', views.editpuskesmas, name='puskesmas'),
    path('ibadah', views.editibadah, name='ibadah'),
    path('sekolah', views.editsekolah, name='sekolah'),
    path('spbu', views.editspbu, name='spbu'),
    path('stasiun', views.editstasiun, name='stasiun'),
    path('terminal', views.editterminal, name='terminal'),
    path('gardu', views.editgardu, name='gardu'),
    
    path('hapus', views.hapus, name='hapus'),
    path('tampak', views.upload_tampak, name='tampak'),
    path('dkantor', views.deletekantoradmin, name='dkantor'),
    
    path('change-tipe', views.changetipe, name='change-tipe'),
    path('change-jenis', views.changejenis, name='change-jenis'),
    
    path('c_bangunan', views.createbang, name='c_bangunan'),
    path('create-jalan', views.createjalan, name='create-jalan'),
    path('create-point', views.createpoint, name='create-point'),
    path('c_lahan', views.createlahan, name='c_lahan'),
    
    path('edit-tuplah', views.edittuplah, name='edit-tuplah'),
    path('edit-tuplah-valid', views.edittuplahvalid, name='edit-tuplah-valid'),
    
    path('edit-jalan', views.editjalan, name='edit-jalan'),
    path('edit-jalan-valid', views.editjalanvalid, name='edit-jalan-valid'),
    path('3d-maps', views.maps3d, name='3d-maps'),

    
    path('hapus-jalan', views.deletejalan, name='hapus-jalan'),
    
    path('filt_perbaikan_kecamatan', views.filt_perbaikan_kecamatan),
    path('filt_perbaikan_desa', views.filt_perbaikan_desa),
    
    path('user-data', views.user_data, name='user-data'),
    path('search_spes', views.search_spes, name='search_spes'),
    path('search_lanjut', views.search_lanjut, name='search_lanjut'),  
    path('load_point_id', views.load_point_id),
    path('edit_detail_poin', views.edit_detail_poin),
    path('dpoint', views.dpoint, name='dpoint'),
    path('reloadpoint', views.reload_point, name='reloadpoint'),
    
    path('download_perbaikan_data', views.download_perbaikan_data),
    path('search_list_perbaikan', views.search_list_perbaikan),
    path('dataperbaikan', views.data_perbaikan),
    
    path('pointBangunan', views.pointBangunan),
    path('pointBangunan_', views.pointBangunan_),
    
]