!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).Cesium={})}(this,function(exports){"use strict";function defined(e){return null!=e}function DeveloperError(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}defined(Object.create)&&(DeveloperError.prototype=Object.create(Error.prototype),DeveloperError.prototype.constructor=DeveloperError),DeveloperError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},DeveloperError.throwInstantiationError=function(){throw new DeveloperError("This function defines an interface and should not be called directly.")};var Check={};function getUndefinedErrorMessage(e){return e+" is required, actual value was undefined"}function getFailedTypeErrorMessage(e,t,i){return"Expected "+i+" to be typeof "+t+", actual typeof was "+e}function defaultValue(e,t){return null!=e?e:t}Check.typeOf={},Check.defined=function(e,t){if(!defined(t))throw new DeveloperError(getUndefinedErrorMessage(e))},Check.typeOf.func=function(e,t){if("function"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"function",e))},Check.typeOf.string=function(e,t){if("string"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"string",e))},Check.typeOf.number=function(e,t){if("number"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"number",e))},Check.typeOf.number.lessThan=function(e,t,i){if(Check.typeOf.number(e,t),i<=t)throw new DeveloperError("Expected "+e+" to be less than "+i+", actual value was "+t)},Check.typeOf.number.lessThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),i<t)throw new DeveloperError("Expected "+e+" to be less than or equal to "+i+", actual value was "+t)},Check.typeOf.number.greaterThan=function(e,t,i){if(Check.typeOf.number(e,t),t<=i)throw new DeveloperError("Expected "+e+" to be greater than "+i+", actual value was "+t)},Check.typeOf.number.greaterThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),t<i)throw new DeveloperError("Expected "+e+" to be greater than or equal to "+i+", actual value was "+t)},Check.typeOf.object=function(e,t){if("object"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"object",e))},Check.typeOf.bool=function(e,t){if("boolean"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"boolean",e))},Check.typeOf.bigint=function(e,t){if("bigint"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"bigint",e))},Check.typeOf.number.equals=function(e,t,i,r){if(Check.typeOf.number(e,i),Check.typeOf.number(t,r),i!==r)throw new DeveloperError(e+" must be equal to "+t+", the actual values are "+i+" and "+r)},defaultValue.EMPTY_OBJECT=Object.freeze({});var MersenneTwister=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,e.constructor==Array?this.init_by_array(e,e.length):this.init_seed(e)};MersenneTwister.prototype.init_seed=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},MersenneTwister.prototype.init_by_array=function(e,t){var i,r,n;for(this.init_seed(19650218),i=1,r=0,n=this.N>t?this.N:t;n;n--){var a=this.mt[i-1]^this.mt[i-1]>>>30;this.mt[i]=(this.mt[i]^(1664525*((4294901760&a)>>>16)<<16)+1664525*(65535&a))+e[r]+r,this.mt[i]>>>=0,r++,++i>=this.N&&(this.mt[0]=this.mt[this.N-1],i=1),t<=r&&(r=0)}for(n=this.N-1;n;n--){a=this.mt[i-1]^this.mt[i-1]>>>30;this.mt[i]=(this.mt[i]^(1566083941*((4294901760&a)>>>16)<<16)+1566083941*(65535&a))-i,this.mt[i]>>>=0,++i>=this.N&&(this.mt[0]=this.mt[this.N-1],i=1)}this.mt[0]=2147483648},MersenneTwister.prototype.random_int=function(){var e,t,i=new Array(0,this.MATRIX_A);if(this.mti>=this.N){for(this.mti==this.N+1&&this.init_seed(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^i[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^i[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^i[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},MersenneTwister.prototype.random_int31=function(){return this.random_int()>>>1},MersenneTwister.prototype.random_incl=function(){return this.random_int()*(1/4294967295)},MersenneTwister.prototype.random=function(){return this.random_int()*(1/4294967296)},MersenneTwister.prototype.random_excl=function(){return(this.random_int()+.5)*(1/4294967296)},MersenneTwister.prototype.random_long=function(){return 1/9007199254740992*(67108864*(this.random_int()>>>5)+(this.random_int()>>>6))};var mersenneTwister=MersenneTwister,CesiumMath={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};CesiumMath.sign=defaultValue(Math.sign,function(e){return 0===(e=+e)||e!=e?e:0<e?1:-1}),CesiumMath.signNotZero=function(e){return e<0?-1:1},CesiumMath.toSNorm=function(e,t){return t=defaultValue(t,255),Math.round((.5*CesiumMath.clamp(e,-1,1)+.5)*t)},CesiumMath.fromSNorm=function(e,t){return t=defaultValue(t,255),CesiumMath.clamp(e,0,t)/t*2-1},CesiumMath.normalize=function(e,t,i){return 0===(i=Math.max(i-t,0))?0:CesiumMath.clamp((e-t)/i,0,1)},CesiumMath.sinh=defaultValue(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),CesiumMath.cosh=defaultValue(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),CesiumMath.lerp=function(e,t,i){return(1-i)*e+i*t},CesiumMath.PI=Math.PI,CesiumMath.ONE_OVER_PI=1/Math.PI,CesiumMath.PI_OVER_TWO=Math.PI/2,CesiumMath.PI_OVER_THREE=Math.PI/3,CesiumMath.PI_OVER_FOUR=Math.PI/4,CesiumMath.PI_OVER_SIX=Math.PI/6,CesiumMath.THREE_PI_OVER_TWO=3*Math.PI/2,CesiumMath.TWO_PI=2*Math.PI,CesiumMath.ONE_OVER_TWO_PI=1/(2*Math.PI),CesiumMath.RADIANS_PER_DEGREE=Math.PI/180,CesiumMath.DEGREES_PER_RADIAN=180/Math.PI,CesiumMath.RADIANS_PER_ARCSECOND=CesiumMath.RADIANS_PER_DEGREE/3600,CesiumMath.toRadians=function(e){return e*CesiumMath.RADIANS_PER_DEGREE},CesiumMath.toDegrees=function(e){return e*CesiumMath.DEGREES_PER_RADIAN},CesiumMath.convertLongitudeRange=function(e){var t=CesiumMath.TWO_PI,e=e-Math.floor(e/t)*t;return e<-Math.PI?e+t:e>=Math.PI?e-t:e},CesiumMath.clampToLatitudeRange=function(e){return CesiumMath.clamp(e,-1*CesiumMath.PI_OVER_TWO,CesiumMath.PI_OVER_TWO)},CesiumMath.negativePiToPi=function(e){return e>=-CesiumMath.PI&&e<=CesiumMath.PI?e:CesiumMath.zeroToTwoPi(e+CesiumMath.PI)-CesiumMath.PI},CesiumMath.zeroToTwoPi=function(e){if(0<=e&&e<=CesiumMath.TWO_PI)return e;var t=CesiumMath.mod(e,CesiumMath.TWO_PI);return Math.abs(t)<CesiumMath.EPSILON14&&Math.abs(e)>CesiumMath.EPSILON14?CesiumMath.TWO_PI:t},CesiumMath.mod=function(e,t){return CesiumMath.sign(e)===CesiumMath.sign(t)&&Math.abs(e)<Math.abs(t)?e:(e%t+t)%t},CesiumMath.equalsEpsilon=function(e,t,i,r){i=defaultValue(i,0),r=defaultValue(r,i);var n=Math.abs(e-t);return n<=r||n<=i*Math.max(Math.abs(e),Math.abs(t))},CesiumMath.lessThan=function(e,t,i){return e-t<-i},CesiumMath.lessThanOrEquals=function(e,t,i){return e-t<i},CesiumMath.greaterThan=function(e,t,i){return i<e-t},CesiumMath.greaterThanOrEquals=function(e,t,i){return-i<e-t};var factorials=[1];CesiumMath.factorial=function(e){var t=factorials.length;if(t<=e)for(var i=factorials[t-1],r=t;r<=e;r++){var n=i*r;factorials.push(n),i=n}return factorials[e]},CesiumMath.incrementWrap=function(e,t,i){return i=defaultValue(i,0),e=t<++e?i:e},CesiumMath.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},CesiumMath.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},CesiumMath.previousPowerOfTwo=function(e){return e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,e=((e|=e>>32)>>>0)-(e>>>1)},CesiumMath.clamp=function(e,t,i){return e<t?t:i<e?i:e};var randomNumberGenerator=new mersenneTwister;function Cartesian3(e,t,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0)}CesiumMath.setRandomNumberSeed=function(e){randomNumberGenerator=new mersenneTwister(e)},CesiumMath.nextRandomNumber=function(){return randomNumberGenerator.random()},CesiumMath.randomBetween=function(e,t){return CesiumMath.nextRandomNumber()*(t-e)+e},CesiumMath.acosClamped=function(e){return Math.acos(CesiumMath.clamp(e,-1,1))},CesiumMath.asinClamped=function(e){return Math.asin(CesiumMath.clamp(e,-1,1))},CesiumMath.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},CesiumMath.logBase=function(e,t){return Math.log(e)/Math.log(t)},CesiumMath.cbrt=defaultValue(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),CesiumMath.log2=defaultValue(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),CesiumMath.fog=function(e,t){t*=e;return 1-Math.exp(-t*t)},CesiumMath.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},CesiumMath.fastApproximateAtan2=function(e,t){var i=Math.abs(e),r=Math.abs(t),n=Math.max(i,r);r=Math.min(i,r);i=CesiumMath.fastApproximateAtan(r/n);return i=Math.abs(t)>Math.abs(e)?CesiumMath.PI_OVER_TWO-i:i,i=e<0?CesiumMath.PI-i:i,i=t<0?-i:i},Cartesian3.fromSpherical=function(e,t){defined(t)||(t=new Cartesian3);var i=e.clock,r=e.cone,n=defaultValue(e.magnitude,1),e=n*Math.sin(r);return t.x=e*Math.cos(i),t.y=e*Math.sin(i),t.z=n*Math.cos(r),t},Cartesian3.fromElements=function(e,t,i,r){return defined(r)?(r.x=e,r.y=t,r.z=i,r):new Cartesian3(e,t,i)},Cartesian3.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Cartesian3(e.x,e.y,e.z)},Cartesian3.fromCartesian4=Cartesian3.clone,Cartesian3.packedLength=3,Cartesian3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i]=e.z,t},Cartesian3.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Cartesian3:i).x=e[t++],i.y=e[t++],i.z=e[t],i},Cartesian3.packArray=function(e,t){var i=e.length,r=3*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 3 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian3.pack(e[n],t,3*n);return t},Cartesian3.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/3:t=new Array(i/3);for(var r=0;r<i;r+=3){var n=r/3;t[n]=Cartesian3.unpack(e,r,t[n])}return t},Cartesian3.fromArray=Cartesian3.unpack,Cartesian3.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},Cartesian3.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},Cartesian3.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i},Cartesian3.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i},Cartesian3.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},Cartesian3.magnitude=function(e){return Math.sqrt(Cartesian3.magnitudeSquared(e))};var distanceScratch$3=new Cartesian3;Cartesian3.distance=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitude(distanceScratch$3)},Cartesian3.distanceSquared=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitudeSquared(distanceScratch$3)},Cartesian3.normalize=function(e,t){var i=Cartesian3.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t},Cartesian3.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},Cartesian3.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i},Cartesian3.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},Cartesian3.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i},Cartesian3.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i},Cartesian3.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i},Cartesian3.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i},Cartesian3.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},Cartesian3.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var lerpScratch$3=new Cartesian3;Cartesian3.lerp=function(e,t,i,r){return Cartesian3.multiplyByScalar(t,i,lerpScratch$3),r=Cartesian3.multiplyByScalar(e,1-i,r),Cartesian3.add(lerpScratch$3,r,r)};var angleBetweenScratch$1=new Cartesian3,angleBetweenScratch2$1=new Cartesian3;Cartesian3.angleBetween=function(e,t){Cartesian3.normalize(e,angleBetweenScratch$1),Cartesian3.normalize(t,angleBetweenScratch2$1);e=Cartesian3.dot(angleBetweenScratch$1,angleBetweenScratch2$1),t=Cartesian3.magnitude(Cartesian3.cross(angleBetweenScratch$1,angleBetweenScratch2$1,angleBetweenScratch$1));return Math.atan2(t,e)};var mostOrthogonalAxisScratch$2=new Cartesian3;Cartesian3.mostOrthogonalAxis=function(e,t){e=Cartesian3.normalize(e,mostOrthogonalAxisScratch$2);return Cartesian3.abs(e,e),t=e.x<=e.y?e.x<=e.z?Cartesian3.clone(Cartesian3.UNIT_X,t):Cartesian3.clone(Cartesian3.UNIT_Z,t):e.y<=e.z?Cartesian3.clone(Cartesian3.UNIT_Y,t):Cartesian3.clone(Cartesian3.UNIT_Z,t)},Cartesian3.projectVector=function(e,t,i){e=Cartesian3.dot(e,t)/Cartesian3.dot(t,t);return Cartesian3.multiplyByScalar(t,e,i)},Cartesian3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},Cartesian3.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]},Cartesian3.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)},Cartesian3.cross=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=t.x,s=t.y,e=t.z,t=a*o-r*e,o=r*s-n*o;return i.x=n*e-a*s,i.y=t,i.z=o,i},Cartesian3.midpoint=function(e,t,i){return i.x=.5*(e.x+t.x),i.y=.5*(e.y+t.y),i.z=.5*(e.z+t.z),i},Cartesian3.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartesian3.fromRadians(e,t,i,r,n)};var scratchN=new Cartesian3,scratchK=new Cartesian3,wgs84RadiiSquared=new Cartesian3(40680631590769,40680631590769,40408299984661.445);Cartesian3.fromRadians=function(e,t,i,r,n){i=defaultValue(i,0);var a=defined(r)?r.radiiSquared:wgs84RadiiSquared,r=Math.cos(t);scratchN.x=r*Math.cos(e),scratchN.y=r*Math.sin(e),scratchN.z=Math.sin(t),scratchN=Cartesian3.normalize(scratchN,scratchN),Cartesian3.multiplyComponents(a,scratchN,scratchK);a=Math.sqrt(Cartesian3.dot(scratchN,scratchK));return scratchK=Cartesian3.divideByScalar(scratchK,a,scratchK),scratchN=Cartesian3.multiplyByScalar(scratchN,i,scratchN),defined(n)||(n=new Cartesian3),Cartesian3.add(scratchK,scratchN,n)},Cartesian3.fromDegreesArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromDegrees(a,o,0,t,i[s])}return i},Cartesian3.fromRadiansArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromRadians(a,o,0,t,i[s])}return i},Cartesian3.fromDegreesArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromDegrees(a,o,s,t,i[l])}return i},Cartesian3.fromRadiansArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromRadians(a,o,s,t,i[l])}return i},Cartesian3.ZERO=Object.freeze(new Cartesian3(0,0,0)),Cartesian3.ONE=Object.freeze(new Cartesian3(1,1,1)),Cartesian3.UNIT_X=Object.freeze(new Cartesian3(1,0,0)),Cartesian3.UNIT_Y=Object.freeze(new Cartesian3(0,1,0)),Cartesian3.UNIT_Z=Object.freeze(new Cartesian3(0,0,1)),Cartesian3.prototype.clone=function(e){return Cartesian3.clone(this,e)},Cartesian3.prototype.equals=function(e){return Cartesian3.equals(this,e)},Cartesian3.prototype.equalsEpsilon=function(e,t,i){return Cartesian3.equalsEpsilon(this,e,t,i)},Cartesian3.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};var scaleToGeodeticSurfaceIntersection=new Cartesian3,scaleToGeodeticSurfaceGradient=new Cartesian3;function scaleToGeodeticSurface(e,t,i,r,n){var a=e.x,o=e.y,s=e.z,l=t.x,c=t.y,t=t.z,u=a*a*l*l,d=o*o*c*c,h=s*s*t*t,l=u+d+h,c=Math.sqrt(1/l),t=Cartesian3.multiplyByScalar(e,c,scaleToGeodeticSurfaceIntersection);if(l<r)return isFinite(c)?Cartesian3.clone(t,n):void 0;var p=i.x,f=i.y,m=i.z,i=scaleToGeodeticSurfaceGradient;i.x=t.x*p*2,i.y=t.y*f*2,i.z=t.z*m*2;var g=(1-c)*Cartesian3.magnitude(e)/(.5*Cartesian3.magnitude(i)),_=0;do{var y,C,v,T,S,A,x,_=(x=u*(T=(y=1/(1+(g-=_)*p))*y)+d*(S=(C=1/(1+g*f))*C)+h*(A=(v=1/(1+g*m))*v)-1)/(-2*(u*(T*y)*p+d*(S*C)*f+h*(A*v)*m))}while(Math.abs(x)>CesiumMath.EPSILON12);return defined(n)?(n.x=a*y,n.y=o*C,n.z=s*v,n):new Cartesian3(a*y,o*C,s*v)}function Cartographic(e,t,i){this.longitude=defaultValue(e,0),this.latitude=defaultValue(t,0),this.height=defaultValue(i,0)}Cartographic.fromRadians=function(e,t,i,r){return i=defaultValue(i,0),defined(r)?(r.longitude=e,r.latitude=t,r.height=i,r):new Cartographic(e,t,i)},Cartographic.fromDegrees=function(e,t,i,r){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartographic.fromRadians(e,t,i,r)};var cartesianToCartographicN$1=new Cartesian3,cartesianToCartographicP$1=new Cartesian3,cartesianToCartographicH$1=new Cartesian3,wgs84OneOverRadii=new Cartesian3(1/6378137,1/6378137,1/6356752.314245179),wgs84OneOverRadiiSquared=new Cartesian3(1/40680631590769,1/40680631590769,1/40408299984661.445),wgs84CenterToleranceSquared=CesiumMath.EPSILON1;function initialize$g(e,t,i,r){t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),e._radii=new Cartesian3(t,i,r),e._radiiSquared=new Cartesian3(t*t,i*i,r*r),e._radiiToTheFourth=new Cartesian3(t*t*t*t,i*i*i*i,r*r*r*r),e._oneOverRadii=new Cartesian3(0===t?0:1/t,0===i?0:1/i,0===r?0:1/r),e._oneOverRadiiSquared=new Cartesian3(0===t?0:1/(t*t),0===i?0:1/(i*i),0===r?0:1/(r*r)),e._minimumRadius=Math.min(t,i,r),e._maximumRadius=Math.max(t,i,r),e._centerToleranceSquared=CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function Ellipsoid(e,t,i){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,initialize$g(this,e,t,i)}Cartographic.fromCartesian=function(e,t,i){var r=defined(t)?t.oneOverRadii:wgs84OneOverRadii,n=defined(t)?t.oneOverRadiiSquared:wgs84OneOverRadiiSquared,r=scaleToGeodeticSurface(e,r,n,defined(t)?t._centerToleranceSquared:wgs84CenterToleranceSquared,cartesianToCartographicP$1);if(defined(r)){t=Cartesian3.multiplyComponents(r,n,cartesianToCartographicN$1),t=Cartesian3.normalize(t,t),n=Cartesian3.subtract(e,r,cartesianToCartographicH$1),r=Math.atan2(t.y,t.x),t=Math.asin(t.z),n=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(i)?(i.longitude=r,i.latitude=t,i.height=n,i):new Cartographic(r,t,n)}},Cartographic.toCartesian=function(e,t,i){return Cartesian3.fromRadians(e.longitude,e.latitude,e.height,t,i)},Cartographic.clone=function(e,t){if(defined(e))return defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Cartographic(e.longitude,e.latitude,e.height)},Cartographic.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},Cartographic.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},Cartographic.ZERO=Object.freeze(new Cartographic(0,0,0)),Cartographic.prototype.clone=function(e){return Cartographic.clone(this,e)},Cartographic.prototype.equals=function(e){return Cartographic.equals(this,e)},Cartographic.prototype.equalsEpsilon=function(e,t){return Cartographic.equalsEpsilon(this,e,t)},Cartographic.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},Object.defineProperties(Ellipsoid.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),Ellipsoid.clone=function(e,t){if(defined(e)){var i=e._radii;return defined(t)?(Cartesian3.clone(i,t._radii),Cartesian3.clone(e._radiiSquared,t._radiiSquared),Cartesian3.clone(e._radiiToTheFourth,t._radiiToTheFourth),Cartesian3.clone(e._oneOverRadii,t._oneOverRadii),Cartesian3.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new Ellipsoid(i.x,i.y,i.z)}},Ellipsoid.fromCartesian3=function(e,t){return defined(t)||(t=new Ellipsoid),defined(e)&&initialize$g(t,e.x,e.y,e.z),t},Ellipsoid.WGS84=Object.freeze(new Ellipsoid(6378137,6378137,6356752.314245179)),Ellipsoid.UNIT_SPHERE=Object.freeze(new Ellipsoid(1,1,1)),Ellipsoid.MOON=Object.freeze(new Ellipsoid(CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS)),Ellipsoid.prototype.clone=function(e){return Ellipsoid.clone(this,e)},Ellipsoid.packedLength=Cartesian3.packedLength,Ellipsoid.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),t},Ellipsoid.unpack=function(e,t,i){t=defaultValue(t,0);t=Cartesian3.unpack(e,t);return Ellipsoid.fromCartesian3(t,i)},Ellipsoid.prototype.geocentricSurfaceNormal=Cartesian3.normalize,Ellipsoid.prototype.geodeticSurfaceNormalCartographic=function(e,t){var i=e.longitude,r=e.latitude,n=Math.cos(r),e=n*Math.cos(i),i=n*Math.sin(i),r=Math.sin(r);return(t=!defined(t)?new Cartesian3:t).x=e,t.y=i,t.z=r,Cartesian3.normalize(t,t)},Ellipsoid.prototype.geodeticSurfaceNormal=function(e,t){if(!Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14))return defined(t)||(t=new Cartesian3),t=Cartesian3.multiplyComponents(e,this._oneOverRadiiSquared,t),Cartesian3.normalize(t,t)};var cartographicToCartesianNormal=new Cartesian3,cartographicToCartesianK=new Cartesian3;Ellipsoid.prototype.cartographicToCartesian=function(e,t){var i=cartographicToCartesianNormal,r=cartographicToCartesianK;this.geodeticSurfaceNormalCartographic(e,i),Cartesian3.multiplyComponents(this._radiiSquared,i,r);var n=Math.sqrt(Cartesian3.dot(i,r));return Cartesian3.divideByScalar(r,n,r),Cartesian3.multiplyByScalar(i,e.height,i),defined(t)||(t=new Cartesian3),Cartesian3.add(r,i,t)},Ellipsoid.prototype.cartographicArrayToCartesianArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var cartesianToCartographicN=new Cartesian3,cartesianToCartographicP=new Cartesian3,cartesianToCartographicH=new Cartesian3;Ellipsoid.prototype.cartesianToCartographic=function(e,t){var i=this.scaleToGeodeticSurface(e,cartesianToCartographicP);if(defined(i)){var r=this.geodeticSurfaceNormal(i,cartesianToCartographicN),n=Cartesian3.subtract(e,i,cartesianToCartographicH),i=Math.atan2(r.y,r.x),r=Math.asin(r.z),n=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(t)?(t.longitude=i,t.latitude=r,t.height=n,t):new Cartographic(i,r,n)}},Ellipsoid.prototype.cartesianArrayToCartographicArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t},Ellipsoid.prototype.scaleToGeodeticSurface=function(e,t){return scaleToGeodeticSurface(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},Ellipsoid.prototype.scaleToGeocentricSurface=function(e,t){defined(t)||(t=new Cartesian3);var i=e.x,r=e.y,n=e.z,a=this._oneOverRadiiSquared,a=1/Math.sqrt(i*i*a.x+r*r*a.y+n*n*a.z);return Cartesian3.multiplyByScalar(e,a,t)},Ellipsoid.prototype.transformPositionToScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._oneOverRadii,t)},Ellipsoid.prototype.transformPositionFromScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._radii,t)},Ellipsoid.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this._radii,e._radii)},Ellipsoid.prototype.toString=function(){return this._radii.toString()},Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,i){t=defaultValue(t,0);var r=this._squaredXOverSquaredZ;if((i=!defined(i)?new Cartesian3:i).x=0,i.y=0,i.z=e.z*(1-r),!(Math.abs(i.z)>=this._radii.z-t))return i};var abscissas=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],weights=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function gaussLegendreQuadrature(e,t,i){for(var r=.5*(t+e),n=.5*(t-e),a=0,o=0;o<5;o++){var s=n*abscissas[o];a+=weights[o]*(i(r+s)+i(r-s))}return a*=n}function GeographicProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Ellipsoid.prototype.surfaceArea=function(e){for(var t=e.west,n=e.east,i=e.south,r=e.north;n<t;)n+=CesiumMath.TWO_PI;var e=this._radiiSquared,a=e.x,o=e.y,s=e.z,l=a*o;return gaussLegendreQuadrature(i,r,function(e){var i=Math.cos(e),r=Math.sin(e);return Math.cos(e)*gaussLegendreQuadrature(t,n,function(e){var t=Math.cos(e),e=Math.sin(e);return Math.sqrt(l*r*r+s*(o*t*t+a*e*e)*i*i)})})},Object.defineProperties(GeographicProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),GeographicProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,i=e.latitude*i,e=e.height;return defined(t)?(t.x=r,t.y=i,t.z=e,t):new Cartesian3(r,i,e)},GeographicProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,i=e.y*i,e=e.z;return defined(t)?(t.longitude=r,t.latitude=i,t.height=e,t):new Cartographic(r,i,e)};var Intersect={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},Intersect$1=Object.freeze(Intersect);function Interval(e,t){this.start=defaultValue(e,0),this.stop=defaultValue(t,0)}function Matrix3(e,t,i,r,n,a,o,s,l){this[0]=defaultValue(e,0),this[1]=defaultValue(r,0),this[2]=defaultValue(o,0),this[3]=defaultValue(t,0),this[4]=defaultValue(n,0),this[5]=defaultValue(s,0),this[6]=defaultValue(i,0),this[7]=defaultValue(a,0),this[8]=defaultValue(l,0)}Matrix3.packedLength=9,Matrix3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t},Matrix3.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Matrix3:i)[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i},Matrix3.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new Matrix3(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},Matrix3.fromArray=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Matrix3:i)[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i},Matrix3.fromColumnMajorArray=function(e,t){return Matrix3.clone(e,t)},Matrix3.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new Matrix3(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},Matrix3.fromQuaternion=function(e,t){var i=e.x*e.x,r=e.x*e.y,n=e.x*e.z,a=e.x*e.w,o=e.y*e.y,s=e.y*e.z,l=e.y*e.w,c=e.z*e.z,u=e.z*e.w,d=e.w*e.w,h=i-o-c+d,p=2*(r-u),f=2*(n+l),e=2*(r+u),r=o-i-c+d,u=2*(s-a),l=2*(n-l),a=2*(s+a),d=-i-o+c+d;return defined(t)?(t[0]=h,t[1]=e,t[2]=l,t[3]=p,t[4]=r,t[5]=a,t[6]=f,t[7]=u,t[8]=d,t):new Matrix3(h,p,f,e,r,u,l,a,d)},Matrix3.fromHeadingPitchRoll=function(e,t){var i=Math.cos(-e.pitch),r=Math.cos(-e.heading),n=Math.cos(e.roll),a=Math.sin(-e.pitch),o=Math.sin(-e.heading),s=Math.sin(e.roll),l=i*r,c=-n*o+s*a*r,u=s*o+n*a*r,d=i*o,e=n*r+s*a*o,o=-s*r+n*a*o,a=-a,s=s*i,i=n*i;return defined(t)?(t[0]=l,t[1]=d,t[2]=a,t[3]=c,t[4]=e,t[5]=s,t[6]=u,t[7]=o,t[8]=i,t):new Matrix3(l,c,u,d,e,o,a,s,i)},Matrix3.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new Matrix3(e.x,0,0,0,e.y,0,0,0,e.z)},Matrix3.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new Matrix3(e,0,0,0,e,0,0,0,e)},Matrix3.fromCrossProduct=function(e,t){return defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new Matrix3(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},Matrix3.fromRotationX=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=e,t[6]=0,t[7]=-e,t[8]=i,t):new Matrix3(1,0,0,0,i,-e,0,e,i)},Matrix3.fromRotationY=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=0,t[2]=-e,t[3]=0,t[4]=1,t[5]=0,t[6]=e,t[7]=0,t[8]=i,t):new Matrix3(i,0,e,0,1,0,-e,0,i)},Matrix3.fromRotationZ=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=e,t[2]=0,t[3]=-e,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(i,-e,0,e,i,0,0,0,1)},Matrix3.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},Matrix3.getElementIndex=function(e,t){return 3*e+t},Matrix3.getColumn=function(e,t,i){var r=3*t,n=e[r],t=e[1+r],r=e[2+r];return i.x=n,i.y=t,i.z=r,i},Matrix3.setColumn=function(e,t,i,r){t*=3;return(r=Matrix3.clone(e,r))[t]=i.x,r[1+t]=i.y,r[2+t]=i.z,r},Matrix3.getRow=function(e,t,i){var r=e[t],n=e[t+3],t=e[t+6];return i.x=r,i.y=n,i.z=t,i},Matrix3.setRow=function(e,t,i,r){return(r=Matrix3.clone(e,r))[t]=i.x,r[t+3]=i.y,r[t+6]=i.z,r};var scratchColumn$2=new Cartesian3;Matrix3.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$2)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[3],e[4],e[5],scratchColumn$2)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[6],e[7],e[8],scratchColumn$2)),t};var scratchScale$8=new Cartesian3;Matrix3.getMaximumScale=function(e){return Matrix3.getScale(e,scratchScale$8),Cartesian3.maximumComponent(scratchScale$8)},Matrix3.multiply=function(e,t,i){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],n=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],u=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],t=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return i[0]=r,i[1]=n,i[2]=a,i[3]=o,i[4]=s,i[5]=l,i[6]=c,i[7]=u,i[8]=t,i},Matrix3.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i},Matrix3.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i},Matrix3.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[3]*n+e[6]*a,t=e[1]*r+e[4]*n+e[7]*a,a=e[2]*r+e[5]*n+e[8]*a;return i.x=o,i.y=t,i.z=a,i},Matrix3.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i},Matrix3.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.x,i[3]=e[3]*t.y,i[4]=e[4]*t.y,i[5]=e[5]*t.y,i[6]=e[6]*t.z,i[7]=e[7]*t.z,i[8]=e[8]*t.z,i},Matrix3.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},Matrix3.transpose=function(e,t){var i=e[0],r=e[3],n=e[6],a=e[1],o=e[4],s=e[7],l=e[2],c=e[5],e=e[8];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t[4]=o,t[5]=s,t[6]=l,t[7]=c,t[8]=e,t};var UNIT=new Cartesian3(1,1,1);function computeFrobeniusNorm(e){for(var t=0,i=0;i<9;++i){var r=e[i];t+=r*r}return Math.sqrt(t)}Matrix3.getRotation=function(e,t){var i=Cartesian3.divideComponents(UNIT,Matrix3.getScale(e,scratchScale$8),scratchScale$8);return t=Matrix3.multiplyByScale(e,i,t)};var rowVal=[1,0,0],colVal=[2,2,1];function offDiagonalFrobeniusNorm(e){for(var t=0,i=0;i<3;++i){var r=e[Matrix3.getElementIndex(colVal[i],rowVal[i])];t+=2*r*r}return Math.sqrt(t)}function shurDecomposition(e,t){for(var i=CesiumMath.EPSILON15,r=0,n=1,a=0;a<3;++a){var o=Math.abs(e[Matrix3.getElementIndex(colVal[a],rowVal[a])]);r<o&&(n=a,r=o)}var s=1,l=0,c=rowVal[n],u=colVal[n];return Math.abs(e[Matrix3.getElementIndex(u,c)])>i&&(l=(i=(i=(e[Matrix3.getElementIndex(u,u)]-e[Matrix3.getElementIndex(c,c)])/2/e[Matrix3.getElementIndex(u,c)])<0?-1/(-i+Math.sqrt(1+i*i)):1/(i+Math.sqrt(1+i*i)))*(s=1/Math.sqrt(1+i*i))),(t=Matrix3.clone(Matrix3.IDENTITY,t))[Matrix3.getElementIndex(c,c)]=t[Matrix3.getElementIndex(u,u)]=s,t[Matrix3.getElementIndex(u,c)]=l,t[Matrix3.getElementIndex(c,u)]=-l,t}var jMatrix=new Matrix3,jMatrixTranspose=new Matrix3;Matrix3.computeEigenDecomposition=function(e,t){for(var i=CesiumMath.EPSILON20,r=0,n=0,a=(t=!defined(t)?{}:t).unitary=Matrix3.clone(Matrix3.IDENTITY,t.unitary),o=t.diagonal=Matrix3.clone(e,t.diagonal),s=i*computeFrobeniusNorm(o);n<10&&offDiagonalFrobeniusNorm(o)>s;)shurDecomposition(o,jMatrix),Matrix3.transpose(jMatrix,jMatrixTranspose),Matrix3.multiply(o,jMatrix,o),Matrix3.multiply(jMatrixTranspose,o,o),Matrix3.multiply(a,jMatrix,a),2<++r&&(++n,r=0);return t},Matrix3.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},Matrix3.determinant=function(e){var t=e[0],i=e[3],r=e[6],n=e[1],a=e[4],o=e[7],s=e[2],l=e[5],e=e[8];return t*(a*e-l*o)+n*(l*r-i*e)+s*(i*o-a*r)},Matrix3.inverse=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[3],o=e[4],s=e[5],l=e[6],c=e[7],u=e[8],e=Matrix3.determinant(e);return t[0]=o*u-c*s,t[1]=c*n-r*u,t[2]=r*s-o*n,t[3]=l*s-a*u,t[4]=i*u-l*n,t[5]=a*n-i*s,t[6]=a*c-l*o,t[7]=l*r-i*c,t[8]=i*o-a*r,Matrix3.multiplyByScalar(t,1/e,t)};var scratchTransposeMatrix$1=new Matrix3;function Cartesian4(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}Matrix3.inverseTranspose=function(e,t){return Matrix3.inverse(Matrix3.transpose(e,scratchTransposeMatrix$1),t)},Matrix3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},Matrix3.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},Matrix3.IDENTITY=Object.freeze(new Matrix3(1,0,0,0,1,0,0,0,1)),Matrix3.ZERO=Object.freeze(new Matrix3(0,0,0,0,0,0,0,0,0)),Matrix3.COLUMN0ROW0=0,Matrix3.COLUMN0ROW1=1,Matrix3.COLUMN0ROW2=2,Matrix3.COLUMN1ROW0=3,Matrix3.COLUMN1ROW1=4,Matrix3.COLUMN1ROW2=5,Matrix3.COLUMN2ROW0=6,Matrix3.COLUMN2ROW1=7,Matrix3.COLUMN2ROW2=8,Object.defineProperties(Matrix3.prototype,{length:{get:function(){return Matrix3.packedLength}}}),Matrix3.prototype.clone=function(e){return Matrix3.clone(this,e)},Matrix3.prototype.equals=function(e){return Matrix3.equals(this,e)},Matrix3.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]},Matrix3.prototype.equalsEpsilon=function(e,t){return Matrix3.equalsEpsilon(this,e,t)},Matrix3.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},Cartesian4.fromElements=function(e,t,i,r,n){return defined(n)?(n.x=e,n.y=t,n.z=i,n.w=r,n):new Cartesian4(e,t,i,r)},Cartesian4.fromColor=function(e,t){return defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new Cartesian4(e.red,e.green,e.blue,e.alpha)},Cartesian4.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Cartesian4(e.x,e.y,e.z,e.w)},Cartesian4.packedLength=4,Cartesian4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Cartesian4.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Cartesian4:i).x=e[t++],i.y=e[t++],i.z=e[t++],i.w=e[t],i},Cartesian4.packArray=function(e,t){var i=e.length,r=4*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 4 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian4.pack(e[n],t,4*n);return t},Cartesian4.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/4:t=new Array(i/4);for(var r=0;r<i;r+=4){var n=r/4;t[n]=Cartesian4.unpack(e,r,t[n])}return t},Cartesian4.fromArray=Cartesian4.unpack,Cartesian4.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},Cartesian4.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},Cartesian4.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i.w=Math.min(e.w,t.w),i},Cartesian4.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i.w=Math.max(e.w,t.w),i},Cartesian4.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Cartesian4.magnitude=function(e){return Math.sqrt(Cartesian4.magnitudeSquared(e))};var distanceScratch$2=new Cartesian4;Cartesian4.distance=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitude(distanceScratch$2)},Cartesian4.distanceSquared=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitudeSquared(distanceScratch$2)},Cartesian4.normalize=function(e,t){var i=Cartesian4.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t.w=e.w/i,t},Cartesian4.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Cartesian4.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i.w=e.w*t.w,i},Cartesian4.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i.w=e.w/t.w,i},Cartesian4.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Cartesian4.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Cartesian4.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Cartesian4.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Cartesian4.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Cartesian4.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var lerpScratch$2=new Cartesian4;Cartesian4.lerp=function(e,t,i,r){return Cartesian4.multiplyByScalar(t,i,lerpScratch$2),r=Cartesian4.multiplyByScalar(e,1-i,r),Cartesian4.add(lerpScratch$2,r,r)};var mostOrthogonalAxisScratch$1=new Cartesian4;Cartesian4.mostOrthogonalAxis=function(e,t){e=Cartesian4.normalize(e,mostOrthogonalAxisScratch$1);return Cartesian4.abs(e,e),t=e.x<=e.y?e.x<=e.z?e.x<=e.w?Cartesian4.clone(Cartesian4.UNIT_X,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.z<=e.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.y<=e.z?e.y<=e.w?Cartesian4.clone(Cartesian4.UNIT_Y,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.z<=e.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t)},Cartesian4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Cartesian4.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]&&e.w===t[i+3]},Cartesian4.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)&&CesiumMath.equalsEpsilon(e.w,t.w,i,r)},Cartesian4.ZERO=Object.freeze(new Cartesian4(0,0,0,0)),Cartesian4.ONE=Object.freeze(new Cartesian4(1,1,1,1)),Cartesian4.UNIT_X=Object.freeze(new Cartesian4(1,0,0,0)),Cartesian4.UNIT_Y=Object.freeze(new Cartesian4(0,1,0,0)),Cartesian4.UNIT_Z=Object.freeze(new Cartesian4(0,0,1,0)),Cartesian4.UNIT_W=Object.freeze(new Cartesian4(0,0,0,1)),Cartesian4.prototype.clone=function(e){return Cartesian4.clone(this,e)},Cartesian4.prototype.equals=function(e){return Cartesian4.equals(this,e)},Cartesian4.prototype.equalsEpsilon=function(e,t,i){return Cartesian4.equalsEpsilon(this,e,t,i)},Cartesian4.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var scratchF32Array=new Float32Array(1),scratchU8Array=new Uint8Array(scratchF32Array.buffer),testU32=new Uint32Array([287454020]),testU8=new Uint8Array(testU32.buffer),littleEndian=68===testU8[0];function RuntimeError(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}function Matrix4(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){this[0]=defaultValue(e,0),this[1]=defaultValue(n,0),this[2]=defaultValue(l,0),this[3]=defaultValue(h,0),this[4]=defaultValue(t,0),this[5]=defaultValue(a,0),this[6]=defaultValue(c,0),this[7]=defaultValue(p,0),this[8]=defaultValue(i,0),this[9]=defaultValue(o,0),this[10]=defaultValue(u,0),this[11]=defaultValue(f,0),this[12]=defaultValue(r,0),this[13]=defaultValue(s,0),this[14]=defaultValue(d,0),this[15]=defaultValue(m,0)}Cartesian4.packFloat=function(e,t){return defined(t)||(t=new Cartesian4),scratchF32Array[0]=e,littleEndian?(t.x=scratchU8Array[0],t.y=scratchU8Array[1],t.z=scratchU8Array[2],t.w=scratchU8Array[3]):(t.x=scratchU8Array[3],t.y=scratchU8Array[2],t.z=scratchU8Array[1],t.w=scratchU8Array[0]),t},Cartesian4.unpackFloat=function(e){return littleEndian?(scratchU8Array[0]=e.x,scratchU8Array[1]=e.y,scratchU8Array[2]=e.z,scratchU8Array[3]=e.w):(scratchU8Array[0]=e.w,scratchU8Array[1]=e.z,scratchU8Array[2]=e.y,scratchU8Array[3]=e.x),scratchF32Array[0]},defined(Object.create)&&(RuntimeError.prototype=Object.create(Error.prototype),RuntimeError.prototype.constructor=RuntimeError),RuntimeError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},Matrix4.packedLength=16,Matrix4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},Matrix4.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Matrix4:i)[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},Matrix4.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Matrix4(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Matrix4.fromArray=Matrix4.unpack,Matrix4.fromColumnMajorArray=function(e,t){return Matrix4.clone(e,t)},Matrix4.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Matrix4(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Matrix4.fromRotationTranslation=function(e,t,i){return t=defaultValue(t,Cartesian3.ZERO),defined(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i):new Matrix4(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Matrix4.fromTranslationQuaternionRotationScale=function(e,t,i,r){defined(r)||(r=new Matrix4);var n=i.x,a=i.y,o=i.z,s=t.x*t.x,l=t.x*t.y,c=t.x*t.z,u=t.x*t.w,d=t.y*t.y,h=t.y*t.z,p=t.y*t.w,f=t.z*t.z,m=t.z*t.w,g=t.w*t.w,_=2*(l-m),i=2*(c+p),t=2*(l+m),l=d-s-f+g,m=2*(h-u),p=2*(c-p),h=2*(h+u),u=-s-d+f+g;return r[0]=(s-d-f+g)*n,r[1]=t*n,r[2]=p*n,r[3]=0,r[4]=_*a,r[5]=l*a,r[6]=h*a,r[7]=0,r[8]=i*o,r[9]=m*o,r[10]=u*o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},Matrix4.fromTranslationRotationScale=function(e,t){return Matrix4.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Matrix4.fromTranslation=function(e,t){return Matrix4.fromRotationTranslation(Matrix3.IDENTITY,e,t)},Matrix4.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Matrix4.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var fromCameraF=new Cartesian3,fromCameraR=new Cartesian3,fromCameraU=new Cartesian3;Matrix4.fromCamera=function(e,t){var i=e.position,r=e.direction,n=e.up;Cartesian3.normalize(r,fromCameraF),Cartesian3.normalize(Cartesian3.cross(fromCameraF,n,fromCameraR),fromCameraR),Cartesian3.normalize(Cartesian3.cross(fromCameraR,fromCameraF,fromCameraU),fromCameraU);var a=fromCameraR.x,o=fromCameraR.y,s=fromCameraR.z,l=fromCameraF.x,c=fromCameraF.y,u=fromCameraF.z,d=fromCameraU.x,h=fromCameraU.y,p=fromCameraU.z,f=i.x,e=i.y,r=i.z,n=a*-f+o*-e+s*-r,i=d*-f+h*-e+p*-r,r=l*f+c*e+u*r;return defined(t)?(t[0]=a,t[1]=d,t[2]=-l,t[3]=0,t[4]=o,t[5]=h,t[6]=-c,t[7]=0,t[8]=s,t[9]=p,t[10]=-u,t[11]=0,t[12]=n,t[13]=i,t[14]=r,t[15]=1,t):new Matrix4(a,o,s,n,d,h,p,i,-l,-c,-u,r,0,0,0,1)},Matrix4.computePerspectiveFieldOfView=function(e,t,i,r,n){var a=1/Math.tan(.5*e),e=(r+i)/(i-r),r=2*r*i/(i-r);return n[0]=a/t,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=a,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=e,n[11]=-1,n[12]=0,n[13]=0,n[14]=r,n[15]=0,n},Matrix4.computeOrthographicOffCenter=function(e,t,i,r,n,a,o){var s=1/(t-e),l=1/(r-i),c=1/(a-n),e=-(t+e)*s,i=-(r+i)*l,n=-(a+n)*c;return l*=2,c*=-2,o[0]=s*=2,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=e,o[13]=i,o[14]=n,o[15]=1,o},Matrix4.computePerspectiveOffCenter=function(e,t,i,r,n,a,o){var s=2*n/(r-i),l=(t+e)/(t-e),r=(r+i)/(r-i),i=-(a+n)/(a-n),a=-2*a*n/(a-n);return o[0]=2*n/(t-e),o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=l,o[9]=r,o[10]=i,o[11]=-1,o[12]=0,o[13]=0,o[14]=a,o[15]=0,o},Matrix4.computeInfinitePerspectiveOffCenter=function(e,t,i,r,n,a){var o=2*n/(r-i),s=(t+e)/(t-e),r=(r+i)/(r-i),i=-2*n;return a[0]=2*n/(t-e),a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=s,a[9]=r,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=i,a[15]=0,a},Matrix4.computeViewportTransformation=function(e,t,i,r){defined(r)||(r=new Matrix4),e=defaultValue(e,defaultValue.EMPTY_OBJECT);var n=defaultValue(e.x,0),a=defaultValue(e.y,0),o=defaultValue(e.width,0),s=defaultValue(e.height,0);t=defaultValue(t,0);var l=.5*o,e=.5*s,o=.5*((i=defaultValue(i,1))-t),s=e,i=o,n=n+l,e=a+e,o=t+o;return r[0]=l,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=s,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=i,r[11]=0,r[12]=n,r[13]=e,r[14]=o,r[15]=1,r},Matrix4.computeView=function(e,t,i,r,n){return n[0]=r.x,n[1]=i.x,n[2]=-t.x,n[3]=0,n[4]=r.y,n[5]=i.y,n[6]=-t.y,n[7]=0,n[8]=r.z,n[9]=i.z,n[10]=-t.z,n[11]=0,n[12]=-Cartesian3.dot(r,e),n[13]=-Cartesian3.dot(i,e),n[14]=Cartesian3.dot(t,e),n[15]=1,n},Matrix4.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Matrix4.getElementIndex=function(e,t){return 4*e+t},Matrix4.getColumn=function(e,t,i){var r=4*t,n=e[r],a=e[1+r],t=e[2+r],r=e[3+r];return i.x=n,i.y=a,i.z=t,i.w=r,i},Matrix4.setColumn=function(e,t,i,r){t*=4;return(r=Matrix4.clone(e,r))[t]=i.x,r[1+t]=i.y,r[2+t]=i.z,r[3+t]=i.w,r},Matrix4.setTranslation=function(e,t,i){return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=e[15],i};var scaleScratch$1=new Cartesian3;Matrix4.setScale=function(e,t,i){var r=Matrix4.getScale(e,scaleScratch$1),r=Cartesian3.divideComponents(t,r,scaleScratch$1);return Matrix4.multiplyByScale(e,r,i)},Matrix4.getRow=function(e,t,i){var r=e[t],n=e[t+4],a=e[t+8],t=e[t+12];return i.x=r,i.y=n,i.z=a,i.w=t,i},Matrix4.setRow=function(e,t,i,r){return(r=Matrix4.clone(e,r))[t]=i.x,r[t+4]=i.y,r[t+8]=i.z,r[t+12]=i.w,r};var scratchColumn$1=new Cartesian3;Matrix4.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$1)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[4],e[5],e[6],scratchColumn$1)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[8],e[9],e[10],scratchColumn$1)),t};var scratchScale$7=new Cartesian3;Matrix4.getMaximumScale=function(e){return Matrix4.getScale(e,scratchScale$7),Cartesian3.maximumComponent(scratchScale$7)},Matrix4.multiply=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[3],s=e[4],l=e[5],c=e[6],u=e[7],d=e[8],h=e[9],p=e[10],f=e[11],m=e[12],g=e[13],_=e[14],y=e[15],C=t[0],v=t[1],T=t[2],S=t[3],A=t[4],x=t[5],b=t[6],E=t[7],P=t[8],D=t[9],w=t[10],M=t[11],I=t[12],R=t[13],O=t[14],B=t[15],L=n*C+l*v+h*T+g*S,F=a*C+c*v+p*T+_*S,N=o*C+u*v+f*T+y*S,V=r*A+s*x+d*b+m*E,e=n*A+l*x+h*b+g*E,t=a*A+c*x+p*b+_*E,A=o*A+u*x+f*b+y*E,x=r*P+s*D+d*w+m*M,b=n*P+l*D+h*w+g*M,E=a*P+c*D+p*w+_*M,w=o*P+u*D+f*w+y*M,M=r*I+s*R+d*O+m*B,g=n*I+l*R+h*O+g*B,_=a*I+c*R+p*O+_*B,B=o*I+u*R+f*O+y*B;return i[0]=r*C+s*v+d*T+m*S,i[1]=L,i[2]=F,i[3]=N,i[4]=V,i[5]=e,i[6]=t,i[7]=A,i[8]=x,i[9]=b,i[10]=E,i[11]=w,i[12]=M,i[13]=g,i[14]=_,i[15]=B,i},Matrix4.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i[9]=e[9]+t[9],i[10]=e[10]+t[10],i[11]=e[11]+t[11],i[12]=e[12]+t[12],i[13]=e[13]+t[13],i[14]=e[14]+t[14],i[15]=e[15]+t[15],i},Matrix4.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i[9]=e[9]-t[9],i[10]=e[10]-t[10],i[11]=e[11]-t[11],i[12]=e[12]-t[12],i[13]=e[13]-t[13],i[14]=e[14]-t[14],i[15]=e[15]-t[15],i},Matrix4.multiplyTransformation=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=e[12],p=e[13],f=e[14],m=t[0],g=t[1],_=t[2],y=t[4],C=t[5],v=t[6],T=t[8],S=t[9],A=t[10],x=t[12],b=t[13],E=t[14],P=n*m+s*g+u*_,D=a*m+l*g+d*_,e=r*y+o*C+c*v,t=n*y+s*C+u*v,y=a*y+l*C+d*v,C=r*T+o*S+c*A,v=n*T+s*S+u*A,A=a*T+l*S+d*A,h=r*x+o*b+c*E+h,p=n*x+s*b+u*E+p,f=a*x+l*b+d*E+f;return i[0]=r*m+o*g+c*_,i[1]=P,i[2]=D,i[3]=0,i[4]=e,i[5]=t,i[6]=y,i[7]=0,i[8]=C,i[9]=v,i[10]=A,i[11]=0,i[12]=h,i[13]=p,i[14]=f,i[15]=1,i},Matrix4.multiplyByMatrix3=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=t[0],p=t[1],f=t[2],m=t[3],g=t[4],_=t[5],y=t[6],C=t[7],v=t[8],T=n*h+s*p+u*f,S=a*h+l*p+d*f,A=r*m+o*g+c*_,t=n*m+s*g+u*_,g=a*m+l*g+d*_,_=r*y+o*C+c*v,u=n*y+s*C+u*v,v=a*y+l*C+d*v;return i[0]=r*h+o*p+c*f,i[1]=T,i[2]=S,i[3]=0,i[4]=A,i[5]=t,i[6]=g,i[7]=0,i[8]=_,i[9]=u,i[10]=v,i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=e[15],i},Matrix4.multiplyByTranslation=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=r*e[0]+n*e[4]+a*e[8]+e[12],t=r*e[1]+n*e[5]+a*e[9]+e[13],a=r*e[2]+n*e[6]+a*e[10]+e[14];return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=o,i[13]=t,i[14]=a,i[15]=e[15],i};var uniformScaleScratch=new Cartesian3;Matrix4.multiplyByUniformScale=function(e,t,i){return uniformScaleScratch.x=t,uniformScaleScratch.y=t,uniformScaleScratch.z=t,Matrix4.multiplyByScale(e,uniformScaleScratch,i)},Matrix4.multiplyByScale=function(e,t,i){var r=t.x,n=t.y,t=t.z;return 1===r&&1===n&&1===t?Matrix4.clone(e,i):(i[0]=r*e[0],i[1]=r*e[1],i[2]=r*e[2],i[3]=0,i[4]=n*e[4],i[5]=n*e[5],i[6]=n*e[6],i[7]=0,i[8]=t*e[8],i[9]=t*e[9],i[10]=t*e[10],i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=1,i)},Matrix4.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=t.w,s=e[0]*r+e[4]*n+e[8]*a+e[12]*o,l=e[1]*r+e[5]*n+e[9]*a+e[13]*o,t=e[2]*r+e[6]*n+e[10]*a+e[14]*o,o=e[3]*r+e[7]*n+e[11]*a+e[15]*o;return i.x=s,i.y=l,i.z=t,i.w=o,i},Matrix4.multiplyByPointAsVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a,t=e[1]*r+e[5]*n+e[9]*a,a=e[2]*r+e[6]*n+e[10]*a;return i.x=o,i.y=t,i.z=a,i},Matrix4.multiplyByPoint=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a+e[12],t=e[1]*r+e[5]*n+e[9]*a+e[13],e=e[2]*r+e[6]*n+e[10]*a+e[14];return i.x=o,i.y=t,i.z=e,i},Matrix4.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i[9]=e[9]*t,i[10]=e[10]*t,i[11]=e[11]*t,i[12]=e[12]*t,i[13]=e[13]*t,i[14]=e[14]*t,i[15]=e[15]*t,i},Matrix4.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Matrix4.transpose=function(e,t){var i=e[1],r=e[2],n=e[3],a=e[6],o=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=i,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=n,t[13]=o,t[14]=s,t[15]=e[15],t},Matrix4.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Matrix4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Matrix4.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i&&Math.abs(e[9]-t[9])<=i&&Math.abs(e[10]-t[10])<=i&&Math.abs(e[11]-t[11])<=i&&Math.abs(e[12]-t[12])<=i&&Math.abs(e[13]-t[13])<=i&&Math.abs(e[14]-t[14])<=i&&Math.abs(e[15]-t[15])<=i},Matrix4.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Matrix4.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var scratchInverseRotation=new Matrix3,scratchMatrix3Zero=new Matrix3,scratchBottomRow=new Cartesian4,scratchExpectedBottomRow=new Cartesian4(0,0,0,1);Matrix4.inverse=function(e,t){var i=e[0],r=e[4],n=e[8],a=e[12],o=e[1],s=e[5],l=e[9],c=e[13],u=e[2],d=e[6],h=e[10],p=e[14],f=e[3],m=e[7],g=e[11],_=e[15],y=h*_,C=p*g,v=d*_,T=p*m,S=d*g,A=h*m,x=u*_,b=p*f,E=u*g,P=h*f,D=u*m,w=d*f,M=y*s+T*l+S*c-(C*s+v*l+A*c),I=C*o+x*l+P*c-(y*o+b*l+E*c),R=v*o+b*s+D*c-(T*o+x*s+w*c),O=A*o+E*s+w*l-(S*o+P*s+D*l),B=C*r+v*n+A*a-(y*r+T*n+S*a),L=y*i+b*n+E*a-(C*i+x*n+P*a),F=T*i+x*r+w*a-(v*i+b*r+D*a),N=S*i+P*r+D*n-(A*i+E*r+w*n),V=(y=n*c)*m+(T=a*s)*g+(S=r*l)*_-((C=a*l)*m+(v=r*c)*g+(A=n*s)*_),l=C*f+(x=i*c)*g+(P=n*o)*_-(y*f+(b=a*o)*g+(E=i*l)*_),_=v*f+b*m+(D=i*s)*_-(T*f+x*m+(w=r*o)*_),m=A*f+E*m+w*g-(S*f+P*m+D*g),g=v*h+A*p+C*d-(S*p+y*d+T*h),C=E*p+y*u+b*h-(x*h+P*p+C*u),b=x*d+w*p+T*u-(D*p+v*u+b*d),u=D*h+S*u+P*d-(E*d+w*h+A*u),a=i*M+r*I+n*R+a*O;if(Math.abs(a)<CesiumMath.EPSILON21){if(Matrix3.equalsEpsilon(Matrix4.getMatrix3(e,scratchInverseRotation),scratchMatrix3Zero,CesiumMath.EPSILON7)&&Cartesian4.equals(Matrix4.getRow(e,3,scratchBottomRow),scratchExpectedBottomRow))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new RuntimeError("matrix is not invertible because its determinate is zero.")}return t[0]=M*(a=1/a),t[1]=I*a,t[2]=R*a,t[3]=O*a,t[4]=B*a,t[5]=L*a,t[6]=F*a,t[7]=N*a,t[8]=V*a,t[9]=l*a,t[10]=_*a,t[11]=m*a,t[12]=g*a,t[13]=C*a,t[14]=b*a,t[15]=u*a,t},Matrix4.inverseTransformation=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[4],o=e[5],s=e[6],l=e[8],c=e[9],u=e[10],d=e[12],h=e[13],p=e[14],f=-i*d-r*h-n*p,e=-a*d-o*h-s*p,p=-l*d-c*h-u*p;return t[0]=i,t[1]=a,t[2]=l,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=n,t[9]=s,t[10]=u,t[11]=0,t[12]=f,t[13]=e,t[14]=p,t[15]=1,t};var scratchTransposeMatrix=new Matrix4;function Rectangle(e,t,i,r){this.west=defaultValue(e,0),this.south=defaultValue(t,0),this.east=defaultValue(i,0),this.north=defaultValue(r,0)}Matrix4.inverseTranspose=function(e,t){return Matrix4.inverse(Matrix4.transpose(e,scratchTransposeMatrix),t)},Matrix4.IDENTITY=Object.freeze(new Matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Matrix4.ZERO=Object.freeze(new Matrix4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Matrix4.COLUMN0ROW0=0,Matrix4.COLUMN0ROW1=1,Matrix4.COLUMN0ROW2=2,Matrix4.COLUMN0ROW3=3,Matrix4.COLUMN1ROW0=4,Matrix4.COLUMN1ROW1=5,Matrix4.COLUMN1ROW2=6,Matrix4.COLUMN1ROW3=7,Matrix4.COLUMN2ROW0=8,Matrix4.COLUMN2ROW1=9,Matrix4.COLUMN2ROW2=10,Matrix4.COLUMN2ROW3=11,Matrix4.COLUMN3ROW0=12,Matrix4.COLUMN3ROW1=13,Matrix4.COLUMN3ROW2=14,Matrix4.COLUMN3ROW3=15,Object.defineProperties(Matrix4.prototype,{length:{get:function(){return Matrix4.packedLength}}}),Matrix4.prototype.clone=function(e){return Matrix4.clone(this,e)},Matrix4.prototype.equals=function(e){return Matrix4.equals(this,e)},Matrix4.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]&&e[9]===t[i+9]&&e[10]===t[i+10]&&e[11]===t[i+11]&&e[12]===t[i+12]&&e[13]===t[i+13]&&e[14]===t[i+14]&&e[15]===t[i+15]},Matrix4.prototype.equalsEpsilon=function(e,t){return Matrix4.equalsEpsilon(this,e,t)},Matrix4.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},Object.defineProperties(Rectangle.prototype,{width:{get:function(){return Rectangle.computeWidth(this)}},height:{get:function(){return Rectangle.computeHeight(this)}}}),Rectangle.packedLength=4,Rectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.west,t[i++]=e.south,t[i++]=e.east,t[i]=e.north,t},Rectangle.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Rectangle:i).west=e[t++],i.south=e[t++],i.east=e[t++],i.north=e[t],i},Rectangle.computeWidth=function(e){var t=e.east,e=e.west;return t<e&&(t+=CesiumMath.TWO_PI),t-e},Rectangle.computeHeight=function(e){return e.north-e.south},Rectangle.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(defaultValue(e,0)),t=CesiumMath.toRadians(defaultValue(t,0)),i=CesiumMath.toRadians(defaultValue(i,0)),r=CesiumMath.toRadians(defaultValue(r,0)),defined(n)?(n.west=e,n.south=t,n.east=i,n.north=r,n):new Rectangle(e,t,i,r)},Rectangle.fromRadians=function(e,t,i,r,n){return defined(n)?(n.west=defaultValue(e,0),n.south=defaultValue(t,0),n.east=defaultValue(i,0),n.north=defaultValue(r,0),n):new Rectangle(e,t,i,r)},Rectangle.fromCartographicArray=function(e,t){for(var i=Number.MAX_VALUE,r=-Number.MAX_VALUE,n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=0,c=e.length;l<c;l++)var u=e[l],i=Math.min(i,u.longitude),r=Math.max(r,u.longitude),o=Math.min(o,u.latitude),s=Math.max(s,u.latitude),u=0<=u.longitude?u.longitude:u.longitude+CesiumMath.TWO_PI,n=Math.min(n,u),a=Math.max(a,u);return a-n<r-i&&(i=n,(r=a)>CesiumMath.PI&&(r-=CesiumMath.TWO_PI),i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI)),defined(t)?(t.west=i,t.south=o,t.east=r,t.north=s,t):new Rectangle(i,o,r,s)},Rectangle.fromCartesianArray=function(e,t,i){t=defaultValue(t,Ellipsoid.WGS84);for(var r=Number.MAX_VALUE,n=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,s=Number.MAX_VALUE,l=-Number.MAX_VALUE,c=0,u=e.length;c<u;c++)var d=t.cartesianToCartographic(e[c]),r=Math.min(r,d.longitude),n=Math.max(n,d.longitude),s=Math.min(s,d.latitude),l=Math.max(l,d.latitude),d=0<=d.longitude?d.longitude:d.longitude+CesiumMath.TWO_PI,a=Math.min(a,d),o=Math.max(o,d);return o-a<n-r&&(r=a,(n=o)>CesiumMath.PI&&(n-=CesiumMath.TWO_PI),r>CesiumMath.PI&&(r-=CesiumMath.TWO_PI)),defined(i)?(i.west=r,i.south=s,i.east=n,i.north=l,i):new Rectangle(r,s,n,l)},Rectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new Rectangle(e.west,e.south,e.east,e.north)},Rectangle.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.west-t.west)<=i&&Math.abs(e.south-t.south)<=i&&Math.abs(e.east-t.east)<=i&&Math.abs(e.north-t.north)<=i},Rectangle.prototype.clone=function(e){return Rectangle.clone(this,e)},Rectangle.prototype.equals=function(e){return Rectangle.equals(this,e)},Rectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},Rectangle.prototype.equalsEpsilon=function(e,t){return Rectangle.equalsEpsilon(this,e,t)},Rectangle.validate=function(e){},Rectangle.southwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new Cartographic(e.west,e.south)},Rectangle.northwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new Cartographic(e.west,e.north)},Rectangle.northeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new Cartographic(e.east,e.north)},Rectangle.southeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new Cartographic(e.east,e.south)},Rectangle.center=function(e,t){var i=e.east,r=e.west;i<r&&(i+=CesiumMath.TWO_PI);i=CesiumMath.negativePiToPi(.5*(r+i)),e=.5*(e.south+e.north);return defined(t)?(t.longitude=i,t.latitude=e,t.height=0,t):new Cartographic(i,e)},Rectangle.intersection=function(e,t,i){var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);o=CesiumMath.negativePiToPi(Math.max(n,o)),r=CesiumMath.negativePiToPi(Math.min(r,a));if(!((e.west<e.east||t.west<t.east)&&r<=o)){a=Math.max(e.south,t.south),t=Math.min(e.north,t.north);if(!(t<=a))return defined(i)?(i.west=o,i.south=a,i.east=r,i.north=t,i):new Rectangle(o,a,r,t)}},Rectangle.simpleIntersection=function(e,t,i){var r=Math.max(e.west,t.west),n=Math.max(e.south,t.south),a=Math.min(e.east,t.east),t=Math.min(e.north,t.north);if(!(t<=n||a<=r))return defined(i)?(i.west=r,i.south=n,i.east=a,i.north=t,i):new Rectangle(r,n,a,t)},Rectangle.union=function(e,t,i){defined(i)||(i=new Rectangle);var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);o=CesiumMath.convertLongitudeRange(Math.min(n,o)),a=CesiumMath.convertLongitudeRange(Math.max(r,a));return i.west=o,i.south=Math.min(e.south,t.south),i.east=a,i.north=Math.max(e.north,t.north),i},Rectangle.expand=function(e,t,i){return(i=!defined(i)?new Rectangle:i).west=Math.min(e.west,t.longitude),i.south=Math.min(e.south,t.latitude),i.east=Math.max(e.east,t.longitude),i.north=Math.max(e.north,t.latitude),i},Rectangle.contains=function(e,t){var i=t.longitude,r=t.latitude,n=e.west,t=e.east;return t<n&&(t+=CesiumMath.TWO_PI,i<0&&(i+=CesiumMath.TWO_PI)),(n<i||CesiumMath.equalsEpsilon(i,n,CesiumMath.EPSILON14))&&(i<t||CesiumMath.equalsEpsilon(i,t,CesiumMath.EPSILON14))&&r>=e.south&&r<=e.north};var subsampleLlaScratch=new Cartographic;function BoundingSphere(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.radius=defaultValue(t,0)}Rectangle.subsample=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=[]);var n=0,a=e.north,o=e.south,s=e.east,l=e.west,c=subsampleLlaScratch;c.height=i,c.longitude=l,c.latitude=a,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=o,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=a<0?a:0<o?o:0;for(var u=1;u<8;++u)c.longitude=-Math.PI+u*CesiumMath.PI_OVER_TWO,Rectangle.contains(e,c)&&(r[n]=t.cartographicToCartesian(c,r[n]),n++);return 0===c.latitude&&(c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++),r.length=n,r},Rectangle.MAX_VALUE=Object.freeze(new Rectangle(-Math.PI,-CesiumMath.PI_OVER_TWO,Math.PI,CesiumMath.PI_OVER_TWO));var fromPointsXMin=new Cartesian3,fromPointsYMin=new Cartesian3,fromPointsZMin=new Cartesian3,fromPointsXMax=new Cartesian3,fromPointsYMax=new Cartesian3,fromPointsZMax=new Cartesian3,fromPointsCurrentPos=new Cartesian3,fromPointsScratch=new Cartesian3,fromPointsRitterCenter=new Cartesian3,fromPointsMinBoxPt=new Cartesian3,fromPointsMaxBoxPt=new Cartesian3,fromPointsNaiveCenterScratch=new Cartesian3,volumeConstant=4/3*CesiumMath.PI;BoundingSphere.fromPoints=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;for(var i=Cartesian3.clone(e[0],fromPointsCurrentPos),r=Cartesian3.clone(i,fromPointsXMin),n=Cartesian3.clone(i,fromPointsYMin),a=Cartesian3.clone(i,fromPointsZMin),o=Cartesian3.clone(i,fromPointsXMax),s=Cartesian3.clone(i,fromPointsYMax),l=Cartesian3.clone(i,fromPointsZMax),c=e.length,u=1;u<c;u++){Cartesian3.clone(e[u],i);var d=i.x,h=i.y,p=i.z;d<r.x&&Cartesian3.clone(i,r),d>o.x&&Cartesian3.clone(i,o),h<n.y&&Cartesian3.clone(i,n),h>s.y&&Cartesian3.clone(i,s),p<a.z&&Cartesian3.clone(i,a),p>l.z&&Cartesian3.clone(i,l)}var f=Cartesian3.magnitudeSquared(Cartesian3.subtract(o,r,fromPointsScratch)),m=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=r,y=o,C=f;f<m&&(C=m,_=n,y=s),C<g&&(C=g,_=a,y=l);var v=fromPointsRitterCenter;v.x=.5*(_.x+y.x),v.y=.5*(_.y+y.y),v.z=.5*(_.z+y.z);var T=Cartesian3.magnitudeSquared(Cartesian3.subtract(y,v,fromPointsScratch)),S=Math.sqrt(T),_=fromPointsMinBoxPt;_.x=r.x,_.y=n.y,_.z=a.z;y=fromPointsMaxBoxPt;y.x=o.x,y.y=s.y,y.z=l.z;var A=Cartesian3.midpoint(_,y,fromPointsNaiveCenterScratch),x=0;for(u=0;u<c;u++){Cartesian3.clone(e[u],i);var b=Cartesian3.magnitude(Cartesian3.subtract(i,A,fromPointsScratch));x<b&&(x=b);var E=Cartesian3.magnitudeSquared(Cartesian3.subtract(i,v,fromPointsScratch));T<E&&(T=(S=.5*(S+(b=Math.sqrt(E))))*S,v.x=(S*v.x+(E=b-S)*i.x)/b,v.y=(S*v.y+E*i.y)/b,v.z=(S*v.z+E*i.z)/b)}return S<x?(Cartesian3.clone(v,t.center),t.radius=S):(Cartesian3.clone(A,t.center),t.radius=x),t};var defaultProjection$1=new GeographicProjection,fromRectangle2DLowerLeft=new Cartesian3,fromRectangle2DUpperRight=new Cartesian3,fromRectangle2DSouthwest=new Cartographic,fromRectangle2DNortheast=new Cartographic;BoundingSphere.fromRectangle2D=function(e,t,i){return BoundingSphere.fromRectangleWithHeights2D(e,t,0,0,i)},BoundingSphere.fromRectangleWithHeights2D=function(e,t,i,r,n){if(defined(n)||(n=new BoundingSphere),!defined(e))return n.center=Cartesian3.clone(Cartesian3.ZERO,n.center),n.radius=0,n;t=defaultValue(t,defaultProjection$1),Rectangle.southwest(e,fromRectangle2DSouthwest),fromRectangle2DSouthwest.height=i,Rectangle.northeast(e,fromRectangle2DNortheast),fromRectangle2DNortheast.height=r;var a=t.project(fromRectangle2DSouthwest,fromRectangle2DLowerLeft),i=t.project(fromRectangle2DNortheast,fromRectangle2DUpperRight),e=i.x-a.x,r=i.y-a.y,t=i.z-a.z;n.radius=.5*Math.sqrt(e*e+r*r+t*t);i=n.center;return i.x=a.x+.5*e,i.y=a.y+.5*r,i.z=a.z+.5*t,n};var fromRectangle3DScratch=[];BoundingSphere.fromRectangle3D=function(e,t,i,r){if(t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=new BoundingSphere),!defined(e))return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;i=Rectangle.subsample(e,t,i,fromRectangle3DScratch);return BoundingSphere.fromPoints(i,r)},BoundingSphere.fromVertices=function(e,t,i,r){if(defined(r)||(r=new BoundingSphere),!defined(e)||0===e.length)return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;t=defaultValue(t,Cartesian3.ZERO),i=defaultValue(i,3);var n=fromPointsCurrentPos;n.x=e[0]+t.x,n.y=e[1]+t.y,n.z=e[2]+t.z;for(var a=Cartesian3.clone(n,fromPointsXMin),o=Cartesian3.clone(n,fromPointsYMin),s=Cartesian3.clone(n,fromPointsZMin),l=Cartesian3.clone(n,fromPointsXMax),c=Cartesian3.clone(n,fromPointsYMax),u=Cartesian3.clone(n,fromPointsZMax),d=e.length,h=0;h<d;h+=i){var p=e[h]+t.x,f=e[h+1]+t.y,m=e[h+2]+t.z;n.x=p,n.y=f,n.z=m,p<a.x&&Cartesian3.clone(n,a),p>l.x&&Cartesian3.clone(n,l),f<o.y&&Cartesian3.clone(n,o),f>c.y&&Cartesian3.clone(n,c),m<s.z&&Cartesian3.clone(n,s),m>u.z&&Cartesian3.clone(n,u)}var g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),y=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),C=a,v=l,T=g;g<_&&(T=_,C=o,v=c),T<y&&(T=y,C=s,v=u);var S=fromPointsRitterCenter;S.x=.5*(C.x+v.x),S.y=.5*(C.y+v.y),S.z=.5*(C.z+v.z);var A=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,S,fromPointsScratch)),x=Math.sqrt(A),C=fromPointsMinBoxPt;C.x=a.x,C.y=o.y,C.z=s.z;v=fromPointsMaxBoxPt;v.x=l.x,v.y=c.y,v.z=u.z;var b=Cartesian3.midpoint(C,v,fromPointsNaiveCenterScratch),E=0;for(h=0;h<d;h+=i){n.x=e[h]+t.x,n.y=e[h+1]+t.y,n.z=e[h+2]+t.z;var P=Cartesian3.magnitude(Cartesian3.subtract(n,b,fromPointsScratch));E<P&&(E=P);var D=Cartesian3.magnitudeSquared(Cartesian3.subtract(n,S,fromPointsScratch));A<D&&(A=(x=.5*(x+(P=Math.sqrt(D))))*x,S.x=(x*S.x+(D=P-x)*n.x)/P,S.y=(x*S.y+D*n.y)/P,S.z=(x*S.z+D*n.z)/P)}return x<E?(Cartesian3.clone(S,r.center),r.radius=x):(Cartesian3.clone(b,r.center),r.radius=E),r},BoundingSphere.fromEncodedCartesianVertices=function(e,t,i){if(defined(i)||(i=new BoundingSphere),!defined(e)||!defined(t)||e.length!==t.length||0===e.length)return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;var r=fromPointsCurrentPos;r.x=e[0]+t[0],r.y=e[1]+t[1],r.z=e[2]+t[2];for(var n=Cartesian3.clone(r,fromPointsXMin),a=Cartesian3.clone(r,fromPointsYMin),o=Cartesian3.clone(r,fromPointsZMin),s=Cartesian3.clone(r,fromPointsXMax),l=Cartesian3.clone(r,fromPointsYMax),c=Cartesian3.clone(r,fromPointsZMax),u=e.length,d=0;d<u;d+=3){var h=e[d]+t[d],p=e[d+1]+t[d+1],f=e[d+2]+t[d+2];r.x=h,r.y=p,r.z=f,h<n.x&&Cartesian3.clone(r,n),h>s.x&&Cartesian3.clone(r,s),p<a.y&&Cartesian3.clone(r,a),p>l.y&&Cartesian3.clone(r,l),f<o.z&&Cartesian3.clone(r,o),f>c.z&&Cartesian3.clone(r,c)}var m=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),y=n,C=s,v=m;m<g&&(v=g,y=a,C=l),v<_&&(v=_,y=o,C=c);var T=fromPointsRitterCenter;T.x=.5*(y.x+C.x),T.y=.5*(y.y+C.y),T.z=.5*(y.z+C.z);var S=Cartesian3.magnitudeSquared(Cartesian3.subtract(C,T,fromPointsScratch)),A=Math.sqrt(S),y=fromPointsMinBoxPt;y.x=n.x,y.y=a.y,y.z=o.z;C=fromPointsMaxBoxPt;C.x=s.x,C.y=l.y,C.z=c.z;var x=Cartesian3.midpoint(y,C,fromPointsNaiveCenterScratch),b=0;for(d=0;d<u;d+=3){r.x=e[d]+t[d],r.y=e[d+1]+t[d+1],r.z=e[d+2]+t[d+2];var E=Cartesian3.magnitude(Cartesian3.subtract(r,x,fromPointsScratch));b<E&&(b=E);var P=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,T,fromPointsScratch));S<P&&(S=(A=.5*(A+(E=Math.sqrt(P))))*A,T.x=(A*T.x+(P=E-A)*r.x)/E,T.y=(A*T.y+P*r.y)/E,T.z=(A*T.z+P*r.z)/E)}return A<b?(Cartesian3.clone(T,i.center),i.radius=A):(Cartesian3.clone(x,i.center),i.radius=b),i},BoundingSphere.fromCornerPoints=function(e,t,i){defined(i)||(i=new BoundingSphere);e=Cartesian3.midpoint(e,t,i.center);return i.radius=Cartesian3.distance(e,t),i},BoundingSphere.fromEllipsoid=function(e,t){return defined(t)||(t=new BoundingSphere),Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};var fromBoundingSpheresScratch=new Cartesian3;BoundingSphere.fromBoundingSpheres=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i=e.length;if(1===i)return BoundingSphere.clone(e[0],t);if(2===i)return BoundingSphere.union(e[0],e[1],t);for(var r=[],n=0;n<i;n++)r.push(e[n].center);var a=(t=BoundingSphere.fromPoints(r,t)).center,o=t.radius;for(n=0;n<i;n++)var s=e[n],o=Math.max(o,Cartesian3.distance(a,s.center,fromBoundingSpheresScratch)+s.radius);return t.radius=o,t};var fromOrientedBoundingBoxScratchU=new Cartesian3,fromOrientedBoundingBoxScratchV=new Cartesian3,fromOrientedBoundingBoxScratchW=new Cartesian3;BoundingSphere.fromOrientedBoundingBox=function(e,t){defined(t)||(t=new BoundingSphere);var i=e.halfAxes,r=Matrix3.getColumn(i,0,fromOrientedBoundingBoxScratchU),n=Matrix3.getColumn(i,1,fromOrientedBoundingBoxScratchV),i=Matrix3.getColumn(i,2,fromOrientedBoundingBoxScratchW);return Cartesian3.add(r,n,r),Cartesian3.add(r,i,r),t.center=Cartesian3.clone(e.center,t.center),t.radius=Cartesian3.magnitude(r),t},BoundingSphere.clone=function(e,t){if(defined(e))return defined(t)?(t.center=Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new BoundingSphere(e.center,e.radius)},BoundingSphere.packedLength=4,BoundingSphere.pack=function(e,t,i){i=defaultValue(i,0);var r=e.center;return t[i++]=r.x,t[i++]=r.y,t[i++]=r.z,t[i]=e.radius,t},BoundingSphere.unpack=function(e,t,i){t=defaultValue(t,0);var r=(i=!defined(i)?new BoundingSphere:i).center;return r.x=e[t++],r.y=e[t++],r.z=e[t++],i.radius=e[t],i};var unionScratch=new Cartesian3,unionScratchCenter=new Cartesian3;BoundingSphere.union=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=e.center,n=e.radius,a=t.center,o=t.radius,s=Cartesian3.subtract(a,r,unionScratch),a=Cartesian3.magnitude(s);if(a+o<=n)return e.clone(i),i;if(a+n<=o)return t.clone(i),i;o=.5*(n+a+o),a=Cartesian3.multiplyByScalar(s,(o-n)/a,unionScratchCenter);return Cartesian3.add(a,r,a),Cartesian3.clone(a,i.center),i.radius=o,i};var expandScratch=new Cartesian3;BoundingSphere.expand=function(e,t,i){i=BoundingSphere.clone(e,i);t=Cartesian3.magnitude(Cartesian3.subtract(t,i.center,expandScratch));return t>i.radius&&(i.radius=t),i},BoundingSphere.intersectPlane=function(e,t){var i=e.center,r=e.radius,e=t.normal,t=Cartesian3.dot(e,i)+t.distance;return t<-r?Intersect$1.OUTSIDE:t<r?Intersect$1.INTERSECTING:Intersect$1.INSIDE},BoundingSphere.transform=function(e,t,i){return(i=!defined(i)?new BoundingSphere:i).center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=Matrix4.getMaximumScale(t)*e.radius,i};var distanceSquaredToScratch=new Cartesian3;BoundingSphere.distanceSquaredTo=function(e,t){t=Cartesian3.subtract(e.center,t,distanceSquaredToScratch),e=Cartesian3.magnitude(t)-e.radius;return e<=0?0:e*e},BoundingSphere.transformWithoutScale=function(e,t,i){return(i=!defined(i)?new BoundingSphere:i).center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=e.radius,i};var scratchCartesian3$d=new Cartesian3;BoundingSphere.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);t=Cartesian3.subtract(e.center,t,scratchCartesian3$d),t=Cartesian3.dot(i,t);return r.start=t-e.radius,r.stop=t+e.radius,r};for(var projectTo2DNormalScratch=new Cartesian3,projectTo2DEastScratch=new Cartesian3,projectTo2DNorthScratch=new Cartesian3,projectTo2DWestScratch=new Cartesian3,projectTo2DSouthScratch=new Cartesian3,projectTo2DCartographicScratch=new Cartographic,projectTo2DPositionsScratch=new Array(8),n$1=0;n$1<8;++n$1)projectTo2DPositionsScratch[n$1]=new Cartesian3;var projectTo2DProjection=new GeographicProjection;BoundingSphere.projectTo2D=function(e,t,i){var r=(t=defaultValue(t,projectTo2DProjection)).ellipsoid,n=e.center,a=e.radius,o=Cartesian3.equals(n,Cartesian3.ZERO)?Cartesian3.clone(Cartesian3.UNIT_X,projectTo2DNormalScratch):r.geodeticSurfaceNormal(n,projectTo2DNormalScratch),s=Cartesian3.cross(Cartesian3.UNIT_Z,o,projectTo2DEastScratch);Cartesian3.normalize(s,s);var l=Cartesian3.cross(o,s,projectTo2DNorthScratch);Cartesian3.normalize(l,l),Cartesian3.multiplyByScalar(o,a,o),Cartesian3.multiplyByScalar(l,a,l),Cartesian3.multiplyByScalar(s,a,s);var c=Cartesian3.negate(l,projectTo2DSouthScratch),e=Cartesian3.negate(s,projectTo2DWestScratch),u=projectTo2DPositionsScratch,a=u[0];Cartesian3.add(o,l,a),Cartesian3.add(a,s,a),a=u[1],Cartesian3.add(o,l,a),Cartesian3.add(a,e,a),a=u[2],Cartesian3.add(o,c,a),Cartesian3.add(a,e,a),a=u[3],Cartesian3.add(o,c,a),Cartesian3.add(a,s,a),Cartesian3.negate(o,o),a=u[4],Cartesian3.add(o,l,a),Cartesian3.add(a,s,a),a=u[5],Cartesian3.add(o,l,a),Cartesian3.add(a,e,a),a=u[6],Cartesian3.add(o,c,a),Cartesian3.add(a,e,a),a=u[7],Cartesian3.add(o,c,a),Cartesian3.add(a,s,a);for(var d=u.length,h=0;h<d;++h){var p=u[h];Cartesian3.add(n,p,p);var f=r.cartesianToCartographic(p,projectTo2DCartographicScratch);t.project(f,p)}c=(n=(i=BoundingSphere.fromPoints(u,i)).center).x,s=n.y,a=n.z;return n.x=a,n.y=c,n.z=s,i},BoundingSphere.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},BoundingSphere.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},BoundingSphere.prototype.intersectPlane=function(e){return BoundingSphere.intersectPlane(this,e)},BoundingSphere.prototype.distanceSquaredTo=function(e){return BoundingSphere.distanceSquaredTo(this,e)},BoundingSphere.prototype.computePlaneDistances=function(e,t,i){return BoundingSphere.computePlaneDistances(this,e,t,i)},BoundingSphere.prototype.isOccluded=function(e){return BoundingSphere.isOccluded(this,e)},BoundingSphere.prototype.equals=function(e){return BoundingSphere.equals(this,e)},BoundingSphere.prototype.clone=function(e){return BoundingSphere.clone(this,e)},BoundingSphere.prototype.volume=function(){var e=this.radius;return volumeConstant*e*e*e};var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function createCommonjsModule(e,t,i){return e(i={path:t,exports:{},require:function(e,t){return commonjsRequire(e,null==t?i.path:t)}},i.exports),i.exports}function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}var punycode=createCommonjsModule(function(P,D){!function(e){var t=D&&!D.nodeType&&D,i=P&&!P.nodeType&&P,r="object"==typeof commonjsGlobal&&commonjsGlobal;r.global!==r&&r.window!==r&&r.self!==r||(e=r);var n,a,g=2147483647,_=36,y=26,o=38,s=700,l=/^xn--/,c=/[^\x20-\x7E]/,u=/[\x2E\u3002\uFF0E\uFF61]/g,d={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},h=_-1,C=Math.floor,v=String.fromCharCode;function T(e){throw new RangeError(d[e])}function p(e,t){for(var i=e.length,r=[];i--;)r[i]=t(e[i]);return r}function f(e,t){var i=e.split("@"),r="";return 1<i.length&&(r=i[0]+"@",e=i[1]),r+p((e=e.replace(u,".")).split("."),t).join(".")}function S(e){for(var t,i,r=[],n=0,a=e.length;n<a;)55296<=(t=e.charCodeAt(n++))&&t<=56319&&n<a?56320==(64512&(i=e.charCodeAt(n++)))?r.push(((1023&t)<<10)+(1023&i)+65536):(r.push(t),n--):r.push(t);return r}function m(e){return p(e,function(e){var t="";return 65535<e&&(t+=v((e-=65536)>>>10&1023|55296),e=56320|1023&e),t+=v(e)}).join("")}function A(e,t){return e+22+75*(e<26)-((0!=t)<<5)}function x(e,t,i){var r=0;for(e=i?C(e/s):e>>1,e+=C(e/t);h*y>>1<e;r+=_)e=C(e/h);return C(r+(h+1)*e/(e+o))}function b(e){var t,i,r,n,a,o,s,l=[],c=e.length,u=0,d=128,h=72,p=e.lastIndexOf("-");for(p<0&&(p=0),i=0;i<p;++i)128<=e.charCodeAt(i)&&T("not-basic"),l.push(e.charCodeAt(i));for(r=0<p?p+1:0;r<c;){for(n=u,a=1,o=_;c<=r&&T("invalid-input"),s=e.charCodeAt(r++),(_<=(s=s-48<10?s-22:s-65<26?s-65:s-97<26?s-97:_)||s>C((g-u)/a))&&T("overflow"),u+=s*a,!(s<(s=o<=h?1:h+y<=o?y:o-h));o+=_)a>C(g/(s=_-s))&&T("overflow"),a*=s;h=x(u-n,t=l.length+1,0==n),C(u/t)>g-d&&T("overflow"),d+=C(u/t),u%=t,l.splice(u++,0,d)}return m(l)}function E(e){for(var t,i,r,n,a,o,s,l,c,u,d=[],h=(e=S(e)).length,p=128,f=72,m=t=0;m<h;++m)(s=e[m])<128&&d.push(v(s));for(i=r=d.length,r&&d.push("-");i<h;){for(n=g,m=0;m<h;++m)p<=(s=e[m])&&s<n&&(n=s);for(n-p>C((g-t)/(l=i+1))&&T("overflow"),t+=(n-p)*l,p=n,m=0;m<h;++m)if((s=e[m])<p&&++t>g&&T("overflow"),s==p){for(a=t,o=_;!(a<(c=o<=f?1:f+y<=o?y:o-f));o+=_)d.push(v(A(c+(u=a-c)%(c=_-c),0))),a=C(u/c);d.push(v(A(a,0))),f=x(t,l,i==r),t=0,++i}++t,++p}return d.join("")}if(n={version:"1.3.2",ucs2:{decode:S,encode:m},decode:b,encode:E,toASCII:function(e){return f(e,function(e){return c.test(e)?"xn--"+E(e):e})},toUnicode:function(e){return f(e,function(e){return l.test(e)?b(e.slice(4).toLowerCase()):e})}},t&&i)if(P.exports==t)i.exports=n;else for(a in n)n.hasOwnProperty(a)&&(t[a]=n[a]);else e.punycode=n}(commonjsGlobal)}),IPv6=createCommonjsModule(function(e){var t,i;t=commonjsGlobal,i=function(e){var t=e&&e.IPv6;return{best:function(e){var t,i=e.toLowerCase().split(":"),r=i.length,n=8;for(""===i[0]&&""===i[1]&&""===i[2]?(i.shift(),i.shift()):""===i[0]&&""===i[1]?i.shift():""===i[r-1]&&""===i[r-2]&&i.pop(),-1!==i[(r=i.length)-1].indexOf(".")&&(n=7),t=0;t<r&&""!==i[t];t++);if(t<n)for(i.splice(t,1,"0000");i.length<n;)i.splice(t,0,"0000");for(var a=0;a<n;a++){for(var o=i[a].split(""),s=0;s<3&&("0"===o[0]&&1<o.length);s++)o.splice(0,1);i[a]=o.join("")}for(var l=-1,c=0,u=0,d=-1,h=!1,a=0;a<n;a++)h?"0"===i[a]?u+=1:(h=!1,c<u&&(l=d,c=u)):"0"===i[a]&&(h=!0,d=a,u=1);c<u&&(l=d,c=u),1<c&&i.splice(l,c,"");var r=i.length,p="";for(""===i[0]&&(p=":"),a=0;a<r&&(p+=i[a],a!==r-1);a++)p+=":";return""===i[r-1]&&(p+=":"),p},noConflict:function(){return e.IPv6===this&&(e.IPv6=t),this}}},e.exports?e.exports=i():t.IPv6=i(t)}),SecondLevelDomains=createCommonjsModule(function(e){var t,i;t=commonjsGlobal,i=function(e){var t=e&&e.SecondLevelDomains,n={list:{ac:" com gov mil net org ",ae:" ac co gov mil name net org pro sch ",af:" com edu gov net org ",al:" com edu gov mil net org ",ao:" co ed gv it og pb ",ar:" com edu gob gov int mil net org tur ",at:" ac co gv or ",au:" asn com csiro edu gov id net org ",ba:" co com edu gov mil net org rs unbi unmo unsa untz unze ",bb:" biz co com edu gov info net org store tv ",bh:" biz cc com edu gov info net org ",bn:" com edu gov net org ",bo:" com edu gob gov int mil net org tv ",br:" adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",bs:" com edu gov net org ",bz:" du et om ov rg ",ca:" ab bc mb nb nf nl ns nt nu on pe qc sk yk ",ck:" biz co edu gen gov info net org ",cn:" ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",co:" com edu gov mil net nom org ",cr:" ac c co ed fi go or sa ",cy:" ac biz com ekloges gov ltd name net org parliament press pro tm ",do:" art com edu gob gov mil net org sld web ",dz:" art asso com edu gov net org pol ",ec:" com edu fin gov info med mil net org pro ",eg:" com edu eun gov mil name net org sci ",er:" com edu gov ind mil net org rochest w ",es:" com edu gob nom org ",et:" biz com edu gov info name net org ",fj:" ac biz com info mil name net org pro ",fk:" ac co gov net nom org ",fr:" asso com f gouv nom prd presse tm ",gg:" co net org ",gh:" com edu gov mil org ",gn:" ac com gov net org ",gr:" com edu gov mil net org ",gt:" com edu gob ind mil net org ",gu:" com edu gov net org ",hk:" com edu gov idv net org ",hu:" 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",id:" ac co go mil net or sch web ",il:" ac co gov idf k12 muni net org ",in:" ac co edu ernet firm gen gov i ind mil net nic org res ",iq:" com edu gov i mil net org ",ir:" ac co dnssec gov i id net org sch ",it:" edu gov ",je:" co net org ",jo:" com edu gov mil name net org sch ",jp:" ac ad co ed go gr lg ne or ",ke:" ac co go info me mobi ne or sc ",kh:" com edu gov mil net org per ",ki:" biz com de edu gov info mob net org tel ",km:" asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",kn:" edu gov net org ",kr:" ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",kw:" com edu gov net org ",ky:" com edu gov net org ",kz:" com edu gov mil net org ",lb:" com edu gov net org ",lk:" assn com edu gov grp hotel int ltd net ngo org sch soc web ",lr:" com edu gov net org ",lv:" asn com conf edu gov id mil net org ",ly:" com edu gov id med net org plc sch ",ma:" ac co gov m net org press ",mc:" asso tm ",me:" ac co edu gov its net org priv ",mg:" com edu gov mil nom org prd tm ",mk:" com edu gov inf name net org pro ",ml:" com edu gov net org presse ",mn:" edu gov org ",mo:" com edu gov net org ",mt:" com edu gov net org ",mv:" aero biz com coop edu gov info int mil museum name net org pro ",mw:" ac co com coop edu gov int museum net org ",mx:" com edu gob net org ",my:" com edu gov mil name net org sch ",nf:" arts com firm info net other per rec store web ",ng:" biz com edu gov mil mobi name net org sch ",ni:" ac co com edu gob mil net nom org ",np:" com edu gov mil net org ",nr:" biz com edu gov info net org ",om:" ac biz co com edu gov med mil museum net org pro sch ",pe:" com edu gob mil net nom org sld ",ph:" com edu gov i mil net ngo org ",pk:" biz com edu fam gob gok gon gop gos gov net org web ",pl:" art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",pr:" ac biz com edu est gov info isla name net org pro prof ",ps:" com edu gov net org plo sec ",pw:" belau co ed go ne or ",ro:" arts com firm info nom nt org rec store tm www ",rs:" ac co edu gov in org ",sb:" com edu gov net org ",sc:" com edu gov net org ",sh:" co com edu gov net nom org ",sl:" com edu gov net org ",st:" co com consulado edu embaixada gov mil net org principe saotome store ",sv:" com edu gob org red ",sz:" ac co org ",tr:" av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",tt:" aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",tw:" club com ebiz edu game gov idv mil net org ",mu:" ac co com gov net or org ",mz:" ac co edu gov org ",na:" co com ",nz:" ac co cri geek gen govt health iwi maori mil net org parliament school ",pa:" abo ac com edu gob ing med net nom org sld ",pt:" com edu gov int net nome org publ ",py:" com edu gov mil net org ",qa:" com edu gov mil net org ",re:" asso com nom ",ru:" ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",rw:" ac co com edu gouv gov int mil net ",sa:" com edu gov med net org pub sch ",sd:" com edu gov info med net org tv ",se:" a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",sg:" com edu gov idn net org per ",sn:" art com edu gouv org perso univ ",sy:" com edu gov mil net news org ",th:" ac co go in mi net or ",tj:" ac biz co com edu go gov info int mil name net nic org test web ",tn:" agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",tz:" ac co go ne or ",ua:" biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",ug:" ac co go ne or org sc ",uk:" ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",us:" dni fed isa kids nsn ",uy:" com edu gub mil net org ",ve:" co com edu gob info mil net org web ",vi:" co com k12 net org ",vn:" ac biz com edu gov health info int name net org pro ",ye:" co com gov ltd me net org plc ",yu:" ac co edu gov org ",za:" ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",zm:" ac co com edu gov net org sch ",com:"ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",net:"gb jp se uk ",org:"ae",de:"com "},has:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;var i=e.lastIndexOf(".",t-1);if(i<=0||t-1<=i)return!1;var r=n.list[e.slice(t+1)];return!!r&&0<=r.indexOf(" "+e.slice(i+1,t)+" ")},is:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;if(0<=e.lastIndexOf(".",t-1))return!1;var i=n.list[e.slice(t+1)];return!!i&&0<=i.indexOf(" "+e.slice(0,t)+" ")},get:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return null;var i=e.lastIndexOf(".",t-1);if(i<=0||t-1<=i)return null;var r=n.list[e.slice(t+1)];return!r||r.indexOf(" "+e.slice(i+1,t)+" ")<0?null:e.slice(i+1)},noConflict:function(){return e.SecondLevelDomains===this&&(e.SecondLevelDomains=t),this}};return n},e.exports?e.exports=i():t.SecondLevelDomains=i(t)}),URI=createCommonjsModule(function(e){var t,i;t=commonjsGlobal,i=function(s,t,c,i){var r=i&&i.URI;function f(e,t){var i=1<=arguments.length;if(!(this instanceof f))return i?2<=arguments.length?new f(e,t):new f(e):new f;if(void 0===e){if(i)throw new TypeError("undefined is not a valid argument for URI");e="undefined"!=typeof location?location.href+"":""}if(null===e&&i)throw new TypeError("null is not a valid argument for URI");return this.href(e),void 0!==t?this.absoluteTo(t):this}f.version="1.19.7";var e=f.prototype,l=Object.prototype.hasOwnProperty;function o(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function u(e){return void 0===e?"Undefined":String(Object.prototype.toString.call(e)).slice(8,-1)}function d(e){return"Array"===u(e)}function h(e,t){var i,r,n={};if("RegExp"===u(t))n=null;else if(d(t))for(i=0,r=t.length;i<r;i++)n[t[i]]=!0;else n[t]=!0;for(i=0,r=e.length;i<r;i++)(n&&void 0!==n[e[i]]||!n&&t.test(e[i]))&&(e.splice(i,1),r--,i--);return e}function p(e,t){if(d(t)){for(r=0,n=t.length;r<n;r++)if(!p(e,t[r]))return!1;return!0}for(var i=u(t),r=0,n=e.length;r<n;r++)if("RegExp"===i){if("string"==typeof e[r]&&e[r].match(t))return!0}else if(e[r]===t)return!0;return!1}function m(e,t){if(!d(e)||!d(t))return!1;if(e.length!==t.length)return!1;e.sort(),t.sort();for(var i=0,r=e.length;i<r;i++)if(e[i]!==t[i])return!1;return!0}function g(e){return e.replace(/^\/+|\/+$/g,"")}function n(e){return escape(e)}function a(e){return encodeURIComponent(e).replace(/[!'()*]/g,n).replace(/\*/g,"%2A")}f._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:f.preventInvalidHostname,duplicateQueryParameters:f.duplicateQueryParameters,escapeQuerySpace:f.escapeQuerySpace}},f.preventInvalidHostname=!1,f.duplicateQueryParameters=!1,f.escapeQuerySpace=!0,f.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,f.idn_expression=/[^a-z0-9\._-]/i,f.punycode_expression=/(xn--)/i,f.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,f.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,f.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi,f.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g},f.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},f.hostProtocols=["http","https"],f.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/,f.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},f.getDomAttribute=function(e){if(e&&e.nodeName){var t=e.nodeName.toLowerCase();if("input"!==t||"image"===e.type)return f.domAttributes[t]}},f.encode=a,f.decode=decodeURIComponent,f.iso8859=function(){f.encode=escape,f.decode=unescape},f.unicode=function(){f.encode=a,f.decode=decodeURIComponent},f.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},f.encodeQuery=function(e,t){e=f.encode(e+"");return(t=void 0===t?f.escapeQuerySpace:t)?e.replace(/%20/g,"+"):e},f.decodeQuery=function(t,e){t+="",void 0===e&&(e=f.escapeQuerySpace);try{return f.decode(e?t.replace(/\+/g,"%20"):t)}catch(e){return t}};function _(i,r){return function(t){try{return f[r](t+"").replace(f.characters[i][r].expression,function(e){return f.characters[i][r].map[e]})}catch(e){return t}}}var y,C={encode:"encode",decode:"decode"};for(y in C)f[y+"PathSegment"]=_("pathname",C[y]),f[y+"UrnPathSegment"]=_("urnpath",C[y]);function v(a,o,s){return function(e){for(var t=s?function(e){return f[o](f[s](e))}:f[o],i=(e+"").split(a),r=0,n=i.length;r<n;r++)i[r]=t(i[r]);return i.join(a)}}function T(i){return function(e,t){return void 0===e?this._parts[i]||"":(this._parts[i]=e||null,this.build(!t),this)}}function S(i,r){return function(e,t){return void 0===e?this._parts[i]||"":(null!==e&&(e+="").charAt(0)===r&&(e=e.substring(1)),this._parts[i]=e,this.build(!t),this)}}f.decodePath=v("/","decodePathSegment"),f.decodeUrnPath=v(":","decodeUrnPathSegment"),f.recodePath=v("/","encodePathSegment","decode"),f.recodeUrnPath=v(":","encodeUrnPathSegment","decode"),f.encodeReserved=_("reserved","encode"),f.parse=function(e,t){var i;return t=t||{preventInvalidHostname:f.preventInvalidHostname},-1<(i=e.indexOf("#"))&&(t.fragment=e.substring(i+1)||null,e=e.substring(0,i)),-1<(i=e.indexOf("?"))&&(t.query=e.substring(i+1)||null,e=e.substring(0,i)),"//"===(e=e.replace(/^(https?|ftp|wss?)?:[/\\]*/,"$1://")).substring(0,2)?(t.protocol=null,e=e.substring(2),e=f.parseAuthority(e,t)):-1<(i=e.indexOf(":"))&&(t.protocol=e.substring(0,i)||null,t.protocol&&!t.protocol.match(f.protocol_expression)?t.protocol=void 0:"//"===e.substring(i+1,i+3).replace(/\\/g,"/")?(e=e.substring(i+3),e=f.parseAuthority(e,t)):(e=e.substring(i+1),t.urn=!0)),t.path=e,t},f.parseHost=function(e,t){var i,r,n=(e=(e=e||"").replace(/\\/g,"/")).indexOf("/");return-1===n&&(n=e.length),"["===e.charAt(0)?(i=e.indexOf("]"),t.hostname=e.substring(1,i)||null,t.port=e.substring(i+2,n)||null,"/"===t.port&&(t.port=null)):(r=e.indexOf(":"),i=e.indexOf("/"),-1!==(r=e.indexOf(":",r+1))&&(-1===i||r<i)?(t.hostname=e.substring(0,n)||null,t.port=null):(i=e.substring(0,n).split(":"),t.hostname=i[0]||null,t.port=i[1]||null)),t.hostname&&"/"!==e.substring(n).charAt(0)&&(n++,e="/"+e),t.preventInvalidHostname&&f.ensureValidHostname(t.hostname,t.protocol),t.port&&f.ensureValidPort(t.port),e.substring(n)||"/"},f.parseAuthority=function(e,t){return e=f.parseUserinfo(e,t),f.parseHost(e,t)},f.parseUserinfo=function(e,t){var i=e,r=(e=-1!==e.indexOf("\\")?e.replace(/\\/g,"/"):e).indexOf("/"),n=e.lastIndexOf("@",-1<r?r:e.length-1);return-1<n&&(-1===r||n<r)?(r=e.substring(0,n).split(":"),t.username=r[0]?f.decode(r[0]):null,r.shift(),t.password=r[0]?f.decode(r.join(":")):null,e=i.substring(n+1)):(t.username=null,t.password=null),e},f.parseQuery=function(e,t){if(!e)return{};if(!(e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"")))return{};for(var i,r,n={},a=e.split("&"),o=a.length,s=0;s<o;s++)r=a[s].split("="),i=f.decodeQuery(r.shift(),t),r=r.length?f.decodeQuery(r.join("="),t):null,"__proto__"!==i&&(l.call(n,i)?("string"!=typeof n[i]&&null!==n[i]||(n[i]=[n[i]]),n[i].push(r)):n[i]=r);return n},f.build=function(e){var t="",i=!1;return e.protocol&&(t+=e.protocol+":"),e.urn||!t&&!e.hostname||(t+="//",i=!0),t+=f.buildAuthority(e)||"","string"==typeof e.path&&("/"!==e.path.charAt(0)&&i&&(t+="/"),t+=e.path),"string"==typeof e.query&&e.query&&(t+="?"+e.query),"string"==typeof e.fragment&&e.fragment&&(t+="#"+e.fragment),t},f.buildHost=function(e){var t="";return e.hostname?(f.ip6_expression.test(e.hostname)?t+="["+e.hostname+"]":t+=e.hostname,e.port&&(t+=":"+e.port),t):""},f.buildAuthority=function(e){return f.buildUserinfo(e)+f.buildHost(e)},f.buildUserinfo=function(e){var t="";return e.username&&(t+=f.encode(e.username)),e.password&&(t+=":"+f.encode(e.password)),t&&(t+="@"),t},f.buildQuery=function(e,t,i){var r,n,a,o,s="";for(n in e)if("__proto__"!==n&&l.call(e,n))if(d(e[n]))for(r={},a=0,o=e[n].length;a<o;a++)void 0!==e[n][a]&&void 0===r[e[n][a]+""]&&(s+="&"+f.buildQueryParameter(n,e[n][a],i),!0!==t&&(r[e[n][a]+""]=!0));else void 0!==e[n]&&(s+="&"+f.buildQueryParameter(n,e[n],i));return s.substring(1)},f.buildQueryParameter=function(e,t,i){return f.encodeQuery(e,i)+(null!==t?"="+f.encodeQuery(t,i):"")},f.addQuery=function(e,t,i){if("object"==typeof t)for(var r in t)l.call(t,r)&&f.addQuery(e,r,t[r]);else{if("string"!=typeof t)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");void 0!==e[t]?("string"==typeof e[t]&&(e[t]=[e[t]]),d(i)||(i=[i]),e[t]=(e[t]||[]).concat(i)):e[t]=i}},f.setQuery=function(e,t,i){if("object"==typeof t)for(var r in t)l.call(t,r)&&f.setQuery(e,r,t[r]);else{if("string"!=typeof t)throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");e[t]=void 0===i?null:i}},f.removeQuery=function(e,t,i){var r,n,a;if(d(t))for(r=0,n=t.length;r<n;r++)e[t[r]]=void 0;else if("RegExp"===u(t))for(a in e)t.test(a)&&(e[a]=void 0);else if("object"==typeof t)for(a in t)l.call(t,a)&&f.removeQuery(e,a,t[a]);else{if("string"!=typeof t)throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");void 0!==i?"RegExp"===u(i)?!d(e[t])&&i.test(e[t])?e[t]=void 0:e[t]=h(e[t],i):e[t]!==String(i)||d(i)&&1!==i.length?d(e[t])&&(e[t]=h(e[t],i)):e[t]=void 0:e[t]=void 0}},f.hasQuery=function(e,t,i,r){switch(u(t)){case"String":break;case"RegExp":for(var n in e)if(l.call(e,n)&&t.test(n)&&(void 0===i||f.hasQuery(e,n,i)))return!0;return!1;case"Object":for(var a in t)if(l.call(t,a)&&!f.hasQuery(e,a,t[a]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(u(i)){case"Undefined":return t in e;case"Boolean":return i===Boolean(d(e[t])?e[t].length:e[t]);case"Function":return!!i(e[t],t,e);case"Array":return d(e[t])?(r?p:m)(e[t],i):!1;case"RegExp":return d(e[t])?!!r&&p(e[t],i):Boolean(e[t]&&e[t].match(i));case"Number":i=String(i);case"String":return d(e[t])?!!r&&p(e[t],i):e[t]===i;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},f.joinPaths=function(){for(var e=[],t=[],i=0,r=0;r<arguments.length;r++){var n=new f(arguments[r]);e.push(n);for(var a=n.segment(),o=0;o<a.length;o++)"string"==typeof a[o]&&t.push(a[o]),a[o]&&i++}if(!t.length||!i)return new f("");var s=new f("").segment(t);return""!==e[0].path()&&"/"!==e[0].path().slice(0,1)||s.path("/"+s.path()),s.normalize()},f.commonPath=function(e,t){for(var i=Math.min(e.length,t.length),r=0;r<i;r++)if(e.charAt(r)!==t.charAt(r)){r--;break}return r<1?e.charAt(0)===t.charAt(0)&&"/"===e.charAt(0)?"/":"":("/"===e.charAt(r)&&"/"===t.charAt(r)||(r=e.substring(0,r).lastIndexOf("/")),e.substring(0,r+1))},f.withinString=function(e,t,i){var r=(i=i||{}).start||f.findUri.start,n=i.end||f.findUri.end,a=i.trim||f.findUri.trim,o=i.parens||f.findUri.parens,s=/[a-z0-9-]=["']?$/i;for(r.lastIndex=0;;){var l=r.exec(e);if(!l)break;var c=l.index;if(i.ignoreHtml){var u=e.slice(Math.max(c-3,0),c);if(u&&s.test(u))continue}for(var u=c+e.slice(c).search(n),d=e.slice(c,u),h=-1;;){var p=o.exec(d);if(!p)break;p=p.index+p[0].length,h=Math.max(h,p)}(d=-1<h?d.slice(0,h)+d.slice(h).replace(a,""):d.replace(a,"")).length<=l[0].length||i.ignore&&i.ignore.test(d)||(void 0!==(l=t(d,c,u=c+d.length,e))?(l=String(l),e=e.slice(0,c)+l+e.slice(u),r.lastIndex=c+l.length):r.lastIndex=u)}return r.lastIndex=0,e},f.ensureValidHostname=function(e,t){var i=!!e,r=!1;if((r=!!t?p(f.hostProtocols,t):r)&&!i)throw new TypeError("Hostname cannot be empty, if protocol is "+t);if(e&&e.match(f.invalid_hostname_characters)){if(!s)throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(s.toASCII(e).match(f.invalid_hostname_characters))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-:_]')}},f.ensureValidPort=function(e){if(e){var t=Number(e);if(!(/^[0-9]+$/.test(t)&&0<t&&t<65536))throw new TypeError('Port "'+e+'" is not a valid port')}},f.noConflict=function(e){if(e){e={URI:this.noConflict()};return i.URITemplate&&"function"==typeof i.URITemplate.noConflict&&(e.URITemplate=i.URITemplate.noConflict()),i.IPv6&&"function"==typeof i.IPv6.noConflict&&(e.IPv6=i.IPv6.noConflict()),i.SecondLevelDomains&&"function"==typeof i.SecondLevelDomains.noConflict&&(e.SecondLevelDomains=i.SecondLevelDomains.noConflict()),e}return i.URI===this&&(i.URI=r),this},e.build=function(e){return!0===e?this._deferred_build=!0:void 0!==e&&!this._deferred_build||(this._string=f.build(this._parts),this._deferred_build=!1),this},e.clone=function(){return new f(this)},e.valueOf=e.toString=function(){return this.build(!1)._string},e.protocol=T("protocol"),e.username=T("username"),e.password=T("password"),e.hostname=T("hostname"),e.port=T("port"),e.query=S("query","?"),e.fragment=S("fragment","#"),e.search=function(e,t){t=this.query(e,t);return"string"==typeof t&&t.length?"?"+t:t},e.hash=function(e,t){t=this.fragment(e,t);return"string"==typeof t&&t.length?"#"+t:t},e.pathname=function(e,t){if(void 0!==e&&!0!==e)return this._parts.urn?this._parts.path=e?f.recodeUrnPath(e):"":this._parts.path=e?f.recodePath(e):"/",this.build(!t),this;t=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?f.decodeUrnPath:f.decodePath)(t):t},e.path=e.pathname,e.href=function(e,t){if(void 0===e)return this.toString();this._string="",this._parts=f._parts();var i=e instanceof f,r="object"==typeof e&&(e.hostname||e.path||e.pathname);if(e.nodeName&&(e=e[f.getDomAttribute(e)]||"",r=!1),"string"==typeof(e=!i&&r&&void 0!==e.pathname?e.toString():e)||e instanceof String)this._parts=f.parse(String(e),this._parts);else{if(!i&&!r)throw new TypeError("invalid input");var n=i?e._parts:e;for(var a in n)"query"!==a&&l.call(this._parts,a)&&(this._parts[a]=n[a]);n.query&&this.query(n.query,!1)}return this.build(!t),this},e.is=function(e){var t=!1,i=!1,r=!1,n=!1,a=!1,o=!1,s=!1,l=!this._parts.urn;switch(this._parts.hostname&&(l=!1,i=f.ip4_expression.test(this._parts.hostname),r=f.ip6_expression.test(this._parts.hostname),a=(n=!(t=i||r))&&c&&c.has(this._parts.hostname),o=n&&f.idn_expression.test(this._parts.hostname),s=n&&f.punycode_expression.test(this._parts.hostname)),e.toLowerCase()){case"relative":return l;case"absolute":return!l;case"domain":case"name":return n;case"sld":return a;case"ip":return t;case"ip4":case"ipv4":case"inet4":return i;case"ip6":case"ipv6":case"inet6":return r;case"idn":return o;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return s}return null};var A=e.protocol,x=e.port,b=e.hostname;e.protocol=function(e,t){if(e&&!(e=e.replace(/:(\/\/)?$/,"")).match(f.protocol_expression))throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]");return A.call(this,e,t)},e.scheme=e.protocol,e.port=function(e,t){return this._parts.urn?void 0===e?"":this:(void 0!==e&&(e=0===e?null:e)&&(":"===(e+="").charAt(0)&&(e=e.substring(1)),f.ensureValidPort(e)),x.call(this,e,t))},e.hostname=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0!==e){var i={preventInvalidHostname:this._parts.preventInvalidHostname};if("/"!==f.parseHost(e,i))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');e=i.hostname,this._parts.preventInvalidHostname&&f.ensureValidHostname(e,this._parts.protocol)}return b.call(this,e,t)},e.origin=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){var i=this.protocol();return this.authority()?(i?i+"://":"")+this.authority():""}e=f(e);return this.protocol(e.protocol()).authority(e.authority()).build(!t),this},e.host=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?f.buildHost(this._parts):"";if("/"!==f.parseHost(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},e.authority=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?f.buildAuthority(this._parts):"";if("/"!==f.parseAuthority(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},e.userinfo=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0!==e)return"@"!==e[e.length-1]&&(e+="@"),f.parseUserinfo(e,this._parts),this.build(!t),this;t=f.buildUserinfo(this._parts);return t&&t.substring(0,t.length-1)},e.resource=function(e,t){return void 0===e?this.path()+this.search()+this.hash():(e=f.parse(e),this._parts.path=e.path,this._parts.query=e.query,this._parts.fragment=e.fragment,this.build(!t),this)},e.subdomain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,i)||""}i=this._parts.hostname.length-this.domain().length,i=this._parts.hostname.substring(0,i),i=new RegExp("^"+o(i));if(e&&"."!==e.charAt(e.length-1)&&(e+="."),-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");return e&&f.ensureValidHostname(e,this._parts.protocol),this._parts.hostname=this._parts.hostname.replace(i,e),this.build(!t),this},e.domain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.match(/\./g);if(i&&i.length<2)return this._parts.hostname;i=this._parts.hostname.length-this.tld(t).length-1,i=this._parts.hostname.lastIndexOf(".",i-1)+1;return this._parts.hostname.substring(i)||""}if(!e)throw new TypeError("cannot set domain empty");if(-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");return f.ensureValidHostname(e,this._parts.protocol),!this._parts.hostname||this.is("IP")?this._parts.hostname=e:(i=new RegExp(o(this.domain())+"$"),this._parts.hostname=this._parts.hostname.replace(i,e)),this.build(!t),this},e.tld=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.lastIndexOf("."),i=this._parts.hostname.substring(i+1);return!0!==t&&c&&c.list[i.toLowerCase()]?c.get(this._parts.hostname)||i:i}var r;if(!e)throw new TypeError("cannot set TLD empty");if(e.match(/[^a-zA-Z0-9-]/)){if(!c||!c.is(e))throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]');r=new RegExp(o(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(r,e)}else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");r=new RegExp(o(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(r,e)}return this.build(!t),this},e.directory=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var i=this._parts.path.length-this.filename().length-1,i=this._parts.path.substring(0,i)||(this._parts.hostname?"/":"");return e?f.decodePath(i):i}i=this._parts.path.length-this.filename().length,i=this._parts.path.substring(0,i),i=new RegExp("^"+o(i));return this.is("relative")||"/"!==(e=e||"/").charAt(0)&&(e="/"+e),e&&"/"!==e.charAt(e.length-1)&&(e+="/"),e=f.recodePath(e),this._parts.path=this._parts.path.replace(i,e),this.build(!t),this},e.filename=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("string"!=typeof e){if(!this._parts.path||"/"===this._parts.path)return"";var i=this._parts.path.lastIndexOf("/"),r=this._parts.path.substring(i+1);return e?f.decodePathSegment(r):r}i=!1;(e="/"===e.charAt(0)?e.substring(1):e).match(/\.?\//)&&(i=!0);r=new RegExp(o(this.filename())+"$");return e=f.recodePath(e),this._parts.path=this._parts.path.replace(r,e),i?this.normalizePath(t):this.build(!t),this},e.suffix=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path||"/"===this._parts.path)return"";var i=this.filename(),r=i.lastIndexOf(".");return-1===r?"":(a=i.substring(r+1),a=/^[a-z0-9%]+$/i.test(a)?a:"",e?f.decodePathSegment(a):a)}"."===e.charAt(0)&&(e=e.substring(1));var n,a=this.suffix();if(a)n=e?new RegExp(o(a)+"$"):new RegExp(o("."+a)+"$");else{if(!e)return this;this._parts.path+="."+f.recodePath(e)}return n&&(e=f.recodePath(e),this._parts.path=this._parts.path.replace(n,e)),this.build(!t),this},e.segment=function(e,t,i){var r=this._parts.urn?":":"/",n=this.path(),a="/"===n.substring(0,1),o=n.split(r);if(void 0!==e&&"number"!=typeof e&&(i=t,t=e,e=void 0),void 0!==e&&"number"!=typeof e)throw new Error('Bad segment "'+e+'", must be 0-based integer');if(a&&o.shift(),e<0&&(e=Math.max(o.length+e,0)),void 0===t)return void 0===e?o:o[e];if(null===e||void 0===o[e])if(d(t))for(var o=[],s=0,l=t.length;s<l;s++)(t[s].length||o.length&&o[o.length-1].length)&&(o.length&&!o[o.length-1].length&&o.pop(),o.push(g(t[s])));else!t&&"string"!=typeof t||(t=g(t),""===o[o.length-1]?o[o.length-1]=t:o.push(t));else t?o[e]=g(t):o.splice(e,1);return a&&o.unshift(""),this.path(o.join(r),i)},e.segmentCoded=function(e,t,i){var r,n,a;if("number"!=typeof e&&(i=t,t=e,e=void 0),void 0===t){if(d(r=this.segment(e,t,i)))for(n=0,a=r.length;n<a;n++)r[n]=f.decode(r[n]);else r=void 0!==r?f.decode(r):void 0;return r}if(d(t))for(n=0,a=t.length;n<a;n++)t[n]=f.encode(t[n]);else t="string"==typeof t||t instanceof String?f.encode(t):t;return this.segment(e,t,i)};var E=e.query;return e.query=function(e,t){if(!0===e)return f.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("function"!=typeof e)return void 0!==e&&"string"!=typeof e?(this._parts.query=f.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this):E.call(this,e,t);var i=f.parseQuery(this._parts.query,this._parts.escapeQuerySpace),e=e.call(this,i);return this._parts.query=f.buildQuery(e||i,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this},e.setQuery=function(e,t,i){var r=f.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"==typeof e||e instanceof String)r[e]=void 0!==t?t:null;else{if("object"!=typeof e)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");for(var n in e)l.call(e,n)&&(r[n]=e[n])}return this._parts.query=f.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!(i="string"!=typeof e?t:i)),this},e.addQuery=function(e,t,i){var r=f.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return f.addQuery(r,e,void 0===t?null:t),this._parts.query=f.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!(i="string"!=typeof e?t:i)),this},e.removeQuery=function(e,t,i){var r=f.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return f.removeQuery(r,e,t),this._parts.query=f.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!(i="string"!=typeof e?t:i)),this},e.hasQuery=function(e,t,i){var r=f.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return f.hasQuery(r,e,t,i)},e.setSearch=e.setQuery,e.addSearch=e.addQuery,e.removeSearch=e.removeQuery,e.hasSearch=e.hasQuery,e.normalize=function(){return(this._parts.urn?this.normalizeProtocol(!1):this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1)).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},e.normalizeProtocol=function(e){return"string"==typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!e)),this},e.normalizeHostname=function(e){return this._parts.hostname&&(this.is("IDN")&&s?this._parts.hostname=s.toASCII(this._parts.hostname):this.is("IPv6")&&t&&(this._parts.hostname=t.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!e)),this},e.normalizePort=function(e){return"string"==typeof this._parts.protocol&&this._parts.port===f.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!e)),this},e.normalizePath=function(e){var t,i=this._parts.path;if(!i)return this;if(this._parts.urn)return this._parts.path=f.recodeUrnPath(this._parts.path),this.build(!e),this;if("/"===this._parts.path)return this;var r,n,a="";for("/"!==(i=f.recodePath(i)).charAt(0)&&(t=!0,i="/"+i),"/.."!==i.slice(-3)&&"/."!==i.slice(-2)||(i+="/"),i=i.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),t&&(a=(a=i.substring(1).match(/^(\.\.\/)+/)||"")&&a[0]);;){if(-1===(r=i.search(/\/\.\.(\/|$)/)))break;0!==r?(-1===(n=i.substring(0,r).lastIndexOf("/"))&&(n=r),i=i.substring(0,n)+i.substring(r+3)):i=i.substring(3)}return t&&this.is("relative")&&(i=a+i.substring(1)),this._parts.path=i,this.build(!e),this},e.normalizePathname=e.normalizePath,e.normalizeQuery=function(e){return"string"==typeof this._parts.query&&(this._parts.query.length?this.query(f.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!e)),this},e.normalizeFragment=function(e){return this._parts.fragment||(this._parts.fragment=null,this.build(!e)),this},e.normalizeSearch=e.normalizeQuery,e.normalizeHash=e.normalizeFragment,e.iso8859=function(){var e=f.encode,t=f.decode;f.encode=escape,f.decode=decodeURIComponent;try{this.normalize()}finally{f.encode=e,f.decode=t}return this},e.unicode=function(){var e=f.encode,t=f.decode;f.encode=a,f.decode=unescape;try{this.normalize()}finally{f.encode=e,f.decode=t}return this},e.readable=function(){var e=this.clone();e.username("").password("").normalize();var t="";if(e._parts.protocol&&(t+=e._parts.protocol+"://"),e._parts.hostname&&(e.is("punycode")&&s?(t+=s.toUnicode(e._parts.hostname),e._parts.port&&(t+=":"+e._parts.port)):t+=e.host()),e._parts.hostname&&e._parts.path&&"/"!==e._parts.path.charAt(0)&&(t+="/"),t+=e.path(!0),e._parts.query){for(var i="",r=0,n=e._parts.query.split("&"),a=n.length;r<a;r++){var o=(n[r]||"").split("=");i+="&"+f.decodeQuery(o[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),void 0!==o[1]&&(i+="="+f.decodeQuery(o[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}t+="?"+i.substring(1)}return t+=f.decodeQuery(e.hash(),!0)},e.absoluteTo=function(e){var t,i,r,n=this.clone(),a=["protocol","username","password","hostname","port"];if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e instanceof f||(e=new f(e)),n._parts.protocol)return n;if(n._parts.protocol=e._parts.protocol,this._parts.hostname)return n;for(i=0;r=a[i];i++)n._parts[r]=e._parts[r];return n._parts.path?(".."===n._parts.path.substring(-2)&&(n._parts.path+="/"),"/"!==n.path().charAt(0)&&(t=(t=e.directory())||(0===e.path().indexOf("/")?"/":""),n._parts.path=(t?t+"/":"")+n._parts.path,n.normalizePath())):(n._parts.path=e._parts.path,n._parts.query||(n._parts.query=e._parts.query)),n.build(),n},e.relativeTo=function(e){var t,i,r=this.clone().normalize();if(r._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e=new f(e).normalize(),t=r._parts,n=e._parts,i=r.path(),e=e.path(),"/"!==i.charAt(0))throw new Error("URI is already relative");if("/"!==e.charAt(0))throw new Error("Cannot calculate a URI relative to another relative URI");if(t.protocol===n.protocol&&(t.protocol=null),t.username!==n.username||t.password!==n.password)return r.build();if(null!==t.protocol||null!==t.username||null!==t.password)return r.build();if(t.hostname!==n.hostname||t.port!==n.port)return r.build();if(t.hostname=null,t.port=null,i===e)return t.path="",r.build();if(!(e=f.commonPath(i,e)))return r.build();var n=n.path.substring(e.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return t.path=n+t.path.substring(e.length)||"./",r.build()},e.equals=function(e){var t,i,r,n,a=this.clone(),o=new f(e),s={};if(a.normalize(),o.normalize(),a.toString()===o.toString())return!0;if(r=a.query(),e=o.query(),a.query(""),o.query(""),a.toString()!==o.toString())return!1;if(r.length!==e.length)return!1;for(n in t=f.parseQuery(r,this._parts.escapeQuerySpace),i=f.parseQuery(e,this._parts.escapeQuerySpace),t)if(l.call(t,n)){if(d(t[n])){if(!m(t[n],i[n]))return!1}else if(t[n]!==i[n])return!1;s[n]=!0}for(n in i)if(l.call(i,n)&&!s[n])return!1;return!0},e.preventInvalidHostname=function(e){return this._parts.preventInvalidHostname=!!e,this},e.duplicateQueryParameters=function(e){return this._parts.duplicateQueryParameters=!!e,this},e.escapeQuerySpace=function(e){return this._parts.escapeQuerySpace=!!e,this},f},e.exports?e.exports=i(punycode,IPv6,SecondLevelDomains):t.URI=i(t.punycode,t.IPv6,t.SecondLevelDomains,t)});function getAbsoluteUri(e,t){var i;return"undefined"!=typeof document&&(i=document),getAbsoluteUri._implementation(e,t,i)}getAbsoluteUri._implementation=function(e,t,i){if(!defined(t)){if(void 0===i)return e;t=defaultValue(i.baseURI,i.location.href)}e=new URI(e);return(""!==e.scheme()?e:e.absoluteTo(t)).toString()};var when=createCommonjsModule(function(e,t){var i;i=function(){var i,r,u;function _(e,t,i,r){return d(e).then(t,i,r)}function d(e){var t,i,e=e instanceof h?e:n(e)?(t=y(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),t.promise):(i=e,new h(function(e){try{return d(e?e(i):i)}catch(e){return p(e)}}));return e}function h(e){this.then=e}function p(i){return new h(function(e,t){try{return t?d(t(i)):p(i)}catch(e){return p(e)}})}function y(){var e=new h(n),o=[],s=[],r=function(t,i,r){var n=y(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)};return o.push(function(e){e.then(t,i).then(n.resolve,n.reject,a)}),s.push(a),n.promise},t=function(e){return f(s,e),e},i=function(e){return e=d(e),r=e.then,i=d,t=C,f(o,e),s=o=u,e};return{then:n,resolve:a,reject:l,progress:c,promise:e,resolver:{resolve:a,reject:l,progress:c}};function n(e,t,i){return r(e,t,i)}function a(e){return i(e)}function l(e){return i(p(e))}function c(e){return t(e)}}function n(e){return e&&"function"==typeof e.then}function a(e,p,f,m,g){return l(2,arguments),_(e,function(e){var t,i,r,n,a=e.length>>>0,o=Math.max(0,Math.min(p,a)),s=[],l=a-o+1,c=[],u=y();if(o)for(r=u.progress,i=function(e){c.push(e),--l||(t=i=C,u.reject(c))},t=function(e){s.push(e),--o||(t=i=C,u.resolve(s))},n=0;n<a;++n)n in e&&_(e[n],h,d,r);else u.resolve(s);return u.then(f,m,g);function d(e){i(e)}function h(e){t(e)}})}function o(e,t,i,r){return l(1,arguments),s(e,c).then(t,i,r)}function s(e,s){return _(e,function(e){var t,i,r,n=t=e.length>>>0,a=[],o=y();if(n)for(i=function(e,t){_(e,s).then(function(e){a[t]=e,--n||o.resolve(a)},o.reject)},r=0;r<t;r++)r in e?i(e[r],r):--n;else o.resolve(a);return o.promise})}function f(e,t){for(var i,r=0;i=e[r++];)i(t)}function l(e,t){for(var i,r=t.length;e<r;)if(null!=(i=t[--r])&&"function"!=typeof i)throw new Error("arg "+r+" must be a function")}function C(){}function c(e){return e}return _.defer=y,_.resolve=d,_.reject=function(e){return _(e,p)},_.join=function(){return s(arguments,c)},_.all=o,_.map=s,_.reduce=function(e,a){var t=r.call(arguments,1);return _(e,function(e){var n=e.length;return t[0]=function(e,i,r){return _(e,function(t){return _(i,function(e){return a(t,e,r,n)})})},i.apply(e,t)})},_.any=function(e,t,i,r){return a(e,1,function(e){return t?t(e[0]):e[0]},i,r)},_.some=a,_.chain=function(e,t,i){var r=2<arguments.length;return _(e,function(e){return t.resolve(e=r?i:e),e},function(e){return t.reject(e),p(e)},t.progress)},_.isPromise=n,h.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(u,e)},yield:function(e){return this.then(function(){return e})},spread:function(t){return this.then(function(e){return o(e,function(e){return t.apply(u,e)})})}},r=[].slice,i=[].reduce||function(e){var t,i=0,r=Object(this),n=r.length>>>0,a=arguments;if(a.length<=1)for(;;){if(i in r){t=r[i++];break}if(++i>=n)throw new TypeError}else t=a[1];for(;i<n;++i)i in r&&(t=e(t,r[i],i,r));return t},_},e.exports=i()});function appendForwardSlash(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}function clone$1(e,t){if(null===e||"object"!=typeof e)return e;t=defaultValue(t,!1);var i,r,n=new e.constructor;for(i in e)e.hasOwnProperty(i)&&(r=e[i],t&&(r=clone$1(r,t)),n[i]=r);return n}function combine$2(e,t,i){i=defaultValue(i,!1);var r,n,a,o={},s=defined(e),l=defined(t);if(s)for(r in e)e.hasOwnProperty(r)&&(n=e[r],l&&i&&"object"==typeof n&&t.hasOwnProperty(r)?(a=t[r],o[r]="object"==typeof a?combine$2(n,a,i):n):o[r]=n);if(l)for(r in t)t.hasOwnProperty(r)&&!o.hasOwnProperty(r)&&(a=t[r],o[r]=a);return o}function getBaseUri(e,t){var i="",r=e.lastIndexOf("/");return-1!==r&&(i=e.substring(0,r+1)),t&&(0!==(e=new URI(e)).query().length&&(i+="?"+e.query()),0!==e.fragment().length&&(i+="#"+e.fragment())),i}function getExtensionFromUri(e){var t=new URI(e);t.normalize();e=t.path(),t=e.lastIndexOf("/");return e=-1===(t=(e=-1!==t?e.substr(t+1):e).lastIndexOf("."))?"":e.substr(t+1)}var blobUriRegex=/^blob:/i,a$2;function isBlobUri(e){return blobUriRegex.test(e)}function isCrossOriginUrl(e){(a$2=!defined(a$2)?document.createElement("a"):a$2).href=window.location.href;var t=a$2.host,i=a$2.protocol;return a$2.href=e,a$2.href=a$2.href,i!==a$2.protocol||t!==a$2.host}var dataUriRegex$2=/^data:/i;function isDataUri(e){return dataUriRegex$2.test(e)}function loadAndExecuteScript(e){var t=when.defer(),i=document.createElement("script");i.async=!0,i.src=e;var r=document.getElementsByTagName("head")[0];return i.onload=function(){i.onload=void 0,r.removeChild(i),t.resolve()},i.onerror=function(e){t.reject(e)},r.appendChild(i),t.promise}function objectToQuery(e){var t,i="";for(t in e)if(e.hasOwnProperty(t)){var r=e[t],n=encodeURIComponent(t)+"=";if(Array.isArray(r))for(var a=0,o=r.length;a<o;++a)i+=n+encodeURIComponent(r[a])+"&";else i+=n+encodeURIComponent(r)+"&"}return i=i.slice(0,-1)}function queryToObject(e){var t={};if(""===e)return t;for(var i=e.replace(/\+/g,"%20").split(/[&;]/),r=0,n=i.length;r<n;++r){var a=i[r].split("="),o=decodeURIComponent(a[0]),s=defined(s=a[1])?decodeURIComponent(s):"",a=t[o];"string"==typeof a?t[o]=[a,s]:Array.isArray(a)?a.push(s):t[o]=s}return t}var RequestState={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},RequestState$1=Object.freeze(RequestState),RequestType={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3},RequestType$1=Object.freeze(RequestType);function Request(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.throttleByServer,!1),i=defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=defaultValue(e.priority,0),this.throttle=i,this.throttleByServer=t,this.type=defaultValue(e.type,RequestType$1.OTHER),this.serverKey=void 0,this.state=RequestState$1.UNISSUED,this.deferred=void 0,this.cancelled=!1}function parseResponseHeaders(e){var t={};if(!e)return t;for(var i=e.split("\r\n"),r=0;r<i.length;++r){var n,a=i[r],o=a.indexOf(": ");0<o&&(n=a.substring(0,o),o=a.substring(o+2),t[n]=o)}return t}function RequestErrorEvent(e,t,i){this.statusCode=e,this.response=t,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=parseResponseHeaders(this.responseHeaders))}function Event(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function compareNumber(e,t){return t-e}function Heap(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function swap$3(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function sortRequests(e,t){return e.priority-t.priority}Request.prototype.cancel=function(){this.cancelled=!0},Request.prototype.clone=function(e){return defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Request(this)},RequestErrorEvent.prototype.toString=function(){var e="Request has failed.";return defined(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e},Object.defineProperties(Event.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Event.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},Event.prototype.removeEventListener=function(e,t){for(var i=this._listeners,r=this._scopes,n=-1,a=0;a<i.length;a++)if(i[a]===e&&r[a]===t){n=a;break}return-1!==n&&(this._insideRaiseEvent?(this._toRemove.push(n),i[n]=void 0,r[n]=void 0):(i.splice(n,1),r.splice(n,1)),!0)},Event.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;for(var e=this._listeners,t=this._scopes,i=e.length,r=0;r<i;r++)defined(e[r])&&e[r].apply(t[r],arguments);var n=this._toRemove;if(0<(i=n.length)){for(n.sort(compareNumber),r=0;r<i;r++){var a=n[r];e.splice(a,1),t.splice(a,1)}n.length=0}this._insideRaiseEvent=!1},Object.defineProperties(Heap.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){var t=this._length;if(e<t){for(var i=this._array,r=e;r<t;++r)i[r]=void 0;this._length=e,i.length=e}this._maximumLength=e}},comparator:{get:function(){return this._comparator}}}),Heap.prototype.reserve=function(e){e=defaultValue(e,this._length),this._array.length=e},Heap.prototype.heapify=function(e){e=defaultValue(e,0);for(var t=this._length,i=this._comparator,r=this._array,n=-1,a=!0;a;){var o=2*(e+1),s=o-1,n=s<t&&i(r[s],r[e])<0?s:e;(n=o<t&&i(r[o],r[n])<0?o:n)!==e?(swap$3(r,n,e),e=n):a=!1}},Heap.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);0<=t;--t)this.heapify(t)},Heap.prototype.insert=function(e){var t,i=this._array,r=this._comparator,n=this._maximumLength,a=this._length++;for(a<i.length?i[a]=e:i.push(e);0!==a;){var o=Math.floor((a-1)/2);if(!(r(i[a],i[o])<0))break;swap$3(i,a,o),a=o}return defined(n)&&this._length>n&&(t=i[n],this._length=n),t},Heap.prototype.pop=function(e){if(e=defaultValue(e,0),0!==this._length){var t=this._array,i=t[e];return swap$3(t,e,--this._length),this.heapify(e),t[this._length]=void 0,i}};var statistics={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},priorityHeapLength=20,requestHeap=new Heap({comparator:sortRequests});requestHeap.maximumLength=priorityHeapLength,requestHeap.reserve(priorityHeapLength);var activeRequests=[],numberOfActiveRequestsByServer={},pageUri="undefined"!=typeof document?new URI(document.location.href):new URI,requestCompletedEvent=new Event;function RequestScheduler(){}function updatePriority(e){defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function issueRequest(e){return e.state===RequestState$1.UNISSUED&&(e.state=RequestState$1.ISSUED,e.deferred=when.defer()),e.deferred.promise}function getRequestReceivedFunction(i){return function(e){var t;i.state!==RequestState$1.CANCELLED&&(t=i.deferred,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[i.serverKey],requestCompletedEvent.raiseEvent(),i.state=RequestState$1.RECEIVED,i.deferred=void 0,t.resolve(e))}}function getRequestFailedFunction(t){return function(e){t.state!==RequestState$1.CANCELLED&&(++statistics.numberOfFailedRequests,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[t.serverKey],requestCompletedEvent.raiseEvent(e),t.state=RequestState$1.FAILED,t.deferred.reject(e))}}function startRequest(e){var t=issueRequest(e);return e.state=RequestState$1.ACTIVE,activeRequests.push(e),++statistics.numberOfActiveRequests,++statistics.numberOfActiveRequestsEver,++numberOfActiveRequestsByServer[e.serverKey],e.requestFunction().then(getRequestReceivedFunction(e)).otherwise(getRequestFailedFunction(e)),t}function cancelRequest(e){var t,i=e.state===RequestState$1.ACTIVE;e.state=RequestState$1.CANCELLED,++statistics.numberOfCancelledRequests,defined(e.deferred)&&(t=e.deferred,e.deferred=void 0,t.reject()),i&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],++statistics.numberOfCancelledActiveRequests),defined(e.cancelFunction)&&e.cancelFunction()}function updateStatistics(){RequestScheduler.debugShowStatistics&&(0===statistics.numberOfActiveRequests&&0<statistics.lastNumberOfActiveRequests&&(0<statistics.numberOfAttemptedRequests&&(console.log("Number of attempted requests: "+statistics.numberOfAttemptedRequests),statistics.numberOfAttemptedRequests=0),0<statistics.numberOfCancelledRequests&&(console.log("Number of cancelled requests: "+statistics.numberOfCancelledRequests),statistics.numberOfCancelledRequests=0),0<statistics.numberOfCancelledActiveRequests&&(console.log("Number of cancelled active requests: "+statistics.numberOfCancelledActiveRequests),statistics.numberOfCancelledActiveRequests=0),0<statistics.numberOfFailedRequests&&(console.log("Number of failed requests: "+statistics.numberOfFailedRequests),statistics.numberOfFailedRequests=0)),statistics.lastNumberOfActiveRequests=statistics.numberOfActiveRequests)}RequestScheduler.maximumRequests=50,RequestScheduler.maximumRequestsPerServer=6,RequestScheduler.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},RequestScheduler.throttleRequests=!0,RequestScheduler.debugShowStatistics=!1,RequestScheduler.requestCompletedEvent=requestCompletedEvent,Object.defineProperties(RequestScheduler,{statistics:{get:function(){return statistics}},priorityHeapLength:{get:function(){return priorityHeapLength},set:function(e){if(e<priorityHeapLength)for(;requestHeap.length>e;)cancelRequest(requestHeap.pop());priorityHeapLength=e,requestHeap.maximumLength=e,requestHeap.reserve(e)}}}),RequestScheduler.serverHasOpenSlots=function(e,t){t=defaultValue(t,1);var i=defaultValue(RequestScheduler.requestsByServer[e],RequestScheduler.maximumRequestsPerServer);return numberOfActiveRequestsByServer[e]+t<=i},RequestScheduler.heapHasOpenSlots=function(e){return requestHeap.length+e<=priorityHeapLength},RequestScheduler.update=function(){for(var e,t=0,i=activeRequests.length,r=0;r<i;++r)(e=activeRequests[r]).cancelled&&cancelRequest(e),e.state===RequestState$1.ACTIVE?0<t&&(activeRequests[r-t]=e):++t;activeRequests.length-=t;var n=requestHeap.internalArray,a=requestHeap.length;for(r=0;r<a;++r)updatePriority(n[r]);requestHeap.resort();for(var o=Math.max(RequestScheduler.maximumRequests-activeRequests.length,0),s=0;s<o&&0<requestHeap.length;)!(e=requestHeap.pop()).cancelled&&(!e.throttleByServer||RequestScheduler.serverHasOpenSlots(e.serverKey))?(startRequest(e),++s):cancelRequest(e);updateStatistics()},RequestScheduler.getServerKey=function(e){var t=new URI(e);""===t.scheme()&&(t=new URI(e).absoluteTo(pageUri)).normalize();e=t.authority();return/:/.test(e)||(e=e+":"+("https"===t.scheme()?"443":"80")),defined(numberOfActiveRequestsByServer[e])||(numberOfActiveRequestsByServer[e]=0),e},RequestScheduler.request=function(e){if(isDataUri(e.url)||isBlobUri(e.url))return requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.requestFunction();if(++statistics.numberOfAttemptedRequests,defined(e.serverKey)||(e.serverKey=RequestScheduler.getServerKey(e.url)),!RequestScheduler.throttleRequests||!e.throttleByServer||RequestScheduler.serverHasOpenSlots(e.serverKey)){if(!RequestScheduler.throttleRequests||!e.throttle)return startRequest(e);if(!(activeRequests.length>=RequestScheduler.maximumRequests)){updatePriority(e);var t=requestHeap.insert(e);if(defined(t)){if(t===e)return;cancelRequest(t)}return issueRequest(e)}}},RequestScheduler.clearForSpecs=function(){for(;0<requestHeap.length;)cancelRequest(requestHeap.pop());for(var e=activeRequests.length,t=0;t<e;++t)cancelRequest(activeRequests[t]);activeRequests.length=0,numberOfActiveRequestsByServer={},statistics.numberOfAttemptedRequests=0,statistics.numberOfActiveRequests=0,statistics.numberOfCancelledRequests=0,statistics.numberOfCancelledActiveRequests=0,statistics.numberOfFailedRequests=0,statistics.numberOfActiveRequestsEver=0,statistics.lastNumberOfActiveRequests=0},RequestScheduler.numberOfActiveRequestsByServer=function(e){return numberOfActiveRequestsByServer[e]},RequestScheduler.requestHeap=requestHeap;var TrustedServers={},_servers={};function getAuthority(e){var t=new URI(e);t.normalize();e=t.authority();if(0!==e.length){if(t.authority(e),-1===(e=-1!==e.indexOf("@")?e.split("@")[1]:e).indexOf(":")){t=t.scheme();if("http"===(t=0===t.length?(t=window.location.protocol).substring(0,t.length-1):t))e+=":80";else{if("https"!==t)return;e+=":443"}}return e}}TrustedServers.add=function(e,t){t=e.toLowerCase()+":"+t;defined(_servers[t])||(_servers[t]=!0)},TrustedServers.remove=function(e,t){t=e.toLowerCase()+":"+t;defined(_servers[t])&&delete _servers[t]},TrustedServers.contains=function(e){e=getAuthority(e);return!(!defined(e)||!defined(_servers[e]))},TrustedServers.clear=function(){_servers={}};var xhrBlobSupported=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),(e.responseType="blob")===e.responseType}catch(e){return!1}}(),supportsImageBitmapOptionsPromise;function parseQuery(e,t,i,r){var n,a=e.query();if(0===a.length)return 1;a=-1===a.indexOf("=")?((n={})[a]=void 0,n):queryToObject(a),t._queryParameters=i?combineQueryParameters(a,t._queryParameters,r):a,e.search("")}function stringifyQuery(e,t){var i=t._queryParameters,t=Object.keys(i);1!==t.length||defined(i[t[0]])?e.search(objectToQuery(i)):e.search(t[0])}function defaultClone(e,t){return defined(e)?defined(e.clone)?e.clone():clone$1(e):t}function checkAndResetRequest(e){if(e.state===RequestState$1.ISSUED||e.state===RequestState$1.ACTIVE)throw new RuntimeError("The Resource is already being fetched.");e.state=RequestState$1.UNISSUED,e.deferred=void 0}function combineQueryParameters(e,t,i){if(!i)return combine$2(e,t);var r,n,a,o=clone$1(e,!0);for(r in t)t.hasOwnProperty(r)&&(n=o[r],a=t[r],defined(n)?(Array.isArray(n)||(n=o[r]=[n]),o[r]=n.concat(a)):o[r]=Array.isArray(a)?a.slice():a);return o}function Resource(e){"string"==typeof(e=defaultValue(e,defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=defaultClone(e.templateValues,{}),this._queryParameters=defaultClone(e.queryParameters,{}),this.headers=defaultClone(e.headers,{}),this.request=defaultValue(e.request,new Request),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=defaultValue(e.retryAttempts,0),this._retryCount=0;e=new URI(e.url);parseQuery(e,this,!0,!0),e.fragment(""),this._url=e.toString()}function fetchImage(e){var i=e.resource,r=e.flipY,n=e.skipColorSpaceConversion,a=e.preferImageBitmap,o=i.request;o.url=i.url,o.requestFunction=function(){var e=!1;i.isDataUri||i.isBlobUri||(e=i.isCrossOriginUrl);var t=when.defer();return Resource._Implementations.createImage(o,e,t,r,n,a),t.promise};e=RequestScheduler.request(o);if(defined(e))return e.otherwise(function(t){return o.state!==RequestState$1.FAILED?when.reject(t):i.retryOnError(t).then(function(e){return e?(o.state=RequestState$1.UNISSUED,o.deferred=void 0,fetchImage({resource:i,flipY:r,skipColorSpaceConversion:n,preferImageBitmap:a})):when.reject(t)})})}function fetchJsonp(i,r,n){var e={};e[r]=n,i.setQueryParameters(e);var a=i.request;a.url=i.url,a.requestFunction=function(){var t=when.defer();return window[n]=function(e){t.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},Resource._Implementations.loadAndExecuteScript(i.url,n,t),t.promise};e=RequestScheduler.request(a);if(defined(e))return e.otherwise(function(t){return a.state!==RequestState$1.FAILED?when.reject(t):i.retryOnError(t).then(function(e){return e?(a.state=RequestState$1.UNISSUED,a.deferred=void 0,fetchJsonp(i,r,n)):when.reject(t)})})}Resource.createIfNeeded=function(e){return e instanceof Resource?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new Resource({url:e})},Resource.supportsImageBitmapOptions=function(){if(defined(supportsImageBitmapOptionsPromise))return supportsImageBitmapOptionsPromise;if("function"!=typeof createImageBitmap)return supportsImageBitmapOptionsPromise=when.resolve(!1);return supportsImageBitmapOptionsPromise=Resource.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg=="}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none",colorSpaceConversion:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},Object.defineProperties(Resource,{isBlobSupported:{get:function(){return xhrBlobSupported}}}),Object.defineProperties(Resource.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){e=new URI(e);parseQuery(e,this,!1),e.fragment(""),this._url=e.toString()}},extension:{get:function(){return getExtensionFromUri(this._url)}},isDataUri:{get:function(){return isDataUri(this._url)}},isBlobUri:{get:function(){return isBlobUri(this._url)}},isCrossOriginUrl:{get:function(){return isCrossOriginUrl(this._url)}},hasHeaders:{get:function(){return 0<Object.keys(this.headers).length}}}),Resource.prototype.toString=function(){return this.getUrlComponent(!0,!0)},Resource.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;var i=new URI(this._url);e&&stringifyQuery(i,this);var i=i.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),r=this._templateValues,i=i.replace(/{(.*?)}/g,function(e,t){t=r[t];return defined(t)?encodeURIComponent(t):e});return i=t&&defined(this.proxy)?this.proxy.getURL(i):i},Resource.prototype.setQueryParameters=function(e,t){this._queryParameters=t?combineQueryParameters(this._queryParameters,e,!1):combineQueryParameters(e,this._queryParameters,!1)},Resource.prototype.appendQueryParameters=function(e){this._queryParameters=combineQueryParameters(e,this._queryParameters,!0)},Resource.prototype.setTemplateValues=function(e,t){this._templateValues=t?combine$2(this._templateValues,e):combine$2(e,this._templateValues)},Resource.prototype.getDerivedResource=function(e){var t,i=this.clone();return i._retryCount=0,defined(e.url)&&(parseQuery(t=new URI(e.url),i,!0,defaultValue(e.preserveQueryParameters,!1)),t.fragment(""),""!==t.scheme()?i._url=t.toString():i._url=t.absoluteTo(new URI(getAbsoluteUri(this._url))).toString()),defined(e.queryParameters)&&(i._queryParameters=combine$2(e.queryParameters,i._queryParameters)),defined(e.templateValues)&&(i._templateValues=combine$2(e.templateValues,i.templateValues)),defined(e.headers)&&(i.headers=combine$2(e.headers,i.headers)),defined(e.proxy)&&(i.proxy=e.proxy),defined(e.request)&&(i.request=e.request),defined(e.retryCallback)&&(i.retryCallback=e.retryCallback),defined(e.retryAttempts)&&(i.retryAttempts=e.retryAttempts),i},Resource.prototype.retryOnError=function(e){var t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return when(!1);var i=this;return when(t(this,e)).then(function(e){return++i._retryCount,e})},Resource.prototype.clone=function(e){return(e=!defined(e)?new Resource({url:this._url}):e)._url=this._url,e._queryParameters=clone$1(this._queryParameters),e._templateValues=clone$1(this._templateValues),e.headers=clone$1(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},Resource.prototype.getBaseUri=function(e){return getBaseUri(this.getUrlComponent(e),e)},Resource.prototype.appendForwardSlash=function(){this._url=appendForwardSlash(this._url)},Resource.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},Resource.fetchArrayBuffer=function(e){return new Resource(e).fetchArrayBuffer()},Resource.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},Resource.fetchBlob=function(e){return new Resource(e).fetchBlob()},Resource.prototype.fetchImage=function(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.preferImageBitmap,!1),i=defaultValue(e.preferBlob,!1),r=defaultValue(e.flipY,!1),n=defaultValue(e.skipColorSpaceConversion,!1);if(checkAndResetRequest(this.request),!xhrBlobSupported||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!i)return fetchImage({resource:this,flipY:r,skipColorSpaceConversion:n,preferImageBitmap:t});var a,o,s,l=this.fetchBlob();return defined(l)?Resource.supportsImageBitmapOptions().then(function(e){return a=e&&t,l}).then(function(e){if(defined(e)){if(s=e,a)return Resource.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1,skipColorSpaceConversion:n});e=window.URL.createObjectURL(e);return fetchImage({resource:o=new Resource({url:e}),flipY:r,skipColorSpaceConversion:n,preferImageBitmap:!1})}}).then(function(e){if(defined(e))return e.blob=s,a||window.URL.revokeObjectURL(o.url),e}).otherwise(function(e){return defined(o)&&window.URL.revokeObjectURL(o.url),e.blob=s,when.reject(e)}):void 0},Resource.fetchImage=function(e){return new Resource(e).fetchImage({flipY:e.flipY,skipColorSpaceConversion:e.skipColorSpaceConversion,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},Resource.prototype.fetchText=function(){return this.fetch({responseType:"text"})},Resource.fetchText=function(e){return new Resource(e).fetchText()},Resource.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(defined(e))return e.then(function(e){if(defined(e))return JSON.parse(e)})},Resource.fetchJson=function(e){return new Resource(e).fetchJson()},Resource.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},Resource.fetchXML=function(e){return new Resource(e).fetchXML()},Resource.prototype.fetchJsonp=function(e){var t;for(e=defaultValue(e,"callback"),checkAndResetRequest(this.request);t="loadJsonp"+CesiumMath.nextRandomNumber().toString().substring(2,8),defined(window[t]););return fetchJsonp(this,e,t)},Resource.fetchJsonp=function(e){return new Resource(e).fetchJsonp(e.callbackParameterName)},Resource.prototype._makeRequest=function(s){var l=this;checkAndResetRequest(l.request);var c=l.request;c.url=l.url,c.requestFunction=function(){var e=s.responseType,t=combine$2(s.headers,l.headers),i=s.overrideMimeType,r=s.method,n=s.data,a=when.defer(),o=Resource._Implementations.loadWithXhr(l.url,e,r,n,t,a,i);return defined(o)&&defined(o.abort)&&(c.cancelFunction=function(){o.abort()}),a.promise};var e=RequestScheduler.request(c);if(defined(e))return e.then(function(e){return c.cancelFunction=void 0,e}).otherwise(function(t){return c.cancelFunction=void 0,c.state!==RequestState$1.FAILED?when.reject(t):l.retryOnError(t).then(function(e){return e?(c.state=RequestState$1.UNISSUED,c.deferred=void 0,l.fetch(s)):when.reject(t)})})};var dataUriRegex$1=/^data:(.*?)(;base64)?,(.*)$/;function decodeDataUriText(e,t){t=decodeURIComponent(t);return e?atob(t):t}function decodeDataUriArrayBuffer(e,t){for(var i=decodeDataUriText(e,t),t=new ArrayBuffer(i.length),r=new Uint8Array(t),n=0;n<i.length;n++)r[n]=i.charCodeAt(n);return t}function decodeDataUri(e,t){t=defaultValue(t,"");var i=e[1],r=!!e[2],n=e[3];switch(t){case"":case"text":return decodeDataUriText(r,n);case"arraybuffer":return decodeDataUriArrayBuffer(r,n);case"blob":var a=decodeDataUriArrayBuffer(r,n);return new Blob([a],{type:i});case"document":return(new DOMParser).parseFromString(decodeDataUriText(r,n),i);case"json":return JSON.parse(decodeDataUriText(r,n))}}function loadImageElement(e,t,i){var r=new Image;r.onload=function(){i.resolve(r)},r.onerror=function(e){i.reject(e)},t&&(TrustedServers.contains(e)?r.crossOrigin="use-credentials":r.crossOrigin=""),r.src=e}function decodeResponse(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function loadWithHttpRequest(e,r,t,i,n,a,o){var s=require("url").parse(e),e="https:"===s.protocol?require("https"):require("http"),l=require("zlib"),n={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:t,headers:n};e.request(n).on("response",function(t){var i;t.statusCode<200||300<=t.statusCode?a.reject(new RequestErrorEvent(t.statusCode,t,t.headers)):(i=[],t.on("data",function(e){i.push(e)}),t.on("end",function(){var e=Buffer.concat(i);"gzip"===t.headers["content-encoding"]?l.gunzip(e,function(e,t){e?a.reject(new RuntimeError("Error decompressing response.")):a.resolve(decodeResponse(t,r))}):a.resolve(decodeResponse(e,r))}))}).on("error",function(e){a.reject(new RequestErrorEvent)}).end()}Resource.prototype.fetch=function(e){return(e=defaultClone(e,{})).method="GET",this._makeRequest(e)},Resource.fetch=function(e){return new Resource(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.delete=function(e){return(e=defaultClone(e,{})).method="DELETE",this._makeRequest(e)},Resource.delete=function(e){return new Resource(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},Resource.prototype.head=function(e){return(e=defaultClone(e,{})).method="HEAD",this._makeRequest(e)},Resource.head=function(e){return new Resource(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.options=function(e){return(e=defaultClone(e,{})).method="OPTIONS",this._makeRequest(e)},Resource.options=function(e){return new Resource(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.post=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="POST",t.data=e,this._makeRequest(t)},Resource.post=function(e){return new Resource(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.put=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PUT",t.data=e,this._makeRequest(t)},Resource.put=function(e){return new Resource(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.patch=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},Resource.patch=function(e){return new Resource(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource._Implementations={},Resource._Implementations.createImage=function(i,r,n,a,o,s){var l=i.url;Resource.supportsImageBitmapOptions().then(function(e){if(e&&s){var e=when.defer(),t=Resource._Implementations.loadWithXhr(l,"blob","GET",void 0,void 0,e,void 0,void 0,void 0);return defined(t)&&defined(t.abort)&&(i.cancelFunction=function(){t.abort()}),e.promise.then(function(e){return defined(e)?Resource.createImageBitmapFromBlob(e,{flipY:a,premultiplyAlpha:!1,skipColorSpaceConversion:o}):void n.reject(new RuntimeError("Successfully retrieved "+l+" but it contained no content."))}).then(n.resolve)}loadImageElement(l,r,n)}).otherwise(n.reject)},Resource.createImageBitmapFromBlob=function(e,t){return Check.defined("options",t),Check.typeOf.bool("options.flipY",t.flipY),Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),Check.typeOf.bool("options.skipColorSpaceConversion",t.skipColorSpaceConversion),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none",colorSpaceConversion:t.skipColorSpaceConversion?"none":"default"})};var noXMLHttpRequest="undefined"==typeof XMLHttpRequest;Resource._Implementations.loadWithXhr=function(e,n,a,t,i,o,r){var s=dataUriRegex$1.exec(e);if(null===s){if(!noXMLHttpRequest){var l=new XMLHttpRequest;if(TrustedServers.contains(e)&&(l.withCredentials=!0),l.open(a,e,!0),defined(r)&&defined(l.overrideMimeType)&&l.overrideMimeType(r),defined(i))for(var c in i)i.hasOwnProperty(c)&&l.setRequestHeader(c,i[c]);defined(n)&&(l.responseType=n);var u=!1;return"string"==typeof e&&(u=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||300<=l.status)||u&&0===l.status){var e=l.response,t=l.responseType;if("HEAD"===a||"OPTIONS"===a){var i=l.getAllResponseHeaders().trim().split(/[\r\n]+/),r={};return i.forEach(function(e){var t=e.split(": "),e=t.shift();r[e]=t.join(": ")}),void o.resolve(r)}if(204===l.status)o.resolve();else if(!defined(e)||defined(n)&&t!==n)if("json"===n&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===t||"document"===t)&&defined(l.responseXML)&&l.responseXML.hasChildNodes()?o.resolve(l.responseXML):""!==t&&"text"!==t||!defined(l.responseText)?o.reject(new RuntimeError("Invalid XMLHttpRequest response type.")):o.resolve(l.responseText);else o.resolve(e)}else o.reject(new RequestErrorEvent(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){o.reject(new RequestErrorEvent)},l.send(t),l}loadWithHttpRequest(e,n,a,t,i,o)}else o.resolve(decodeDataUri(s,n))},Resource._Implementations.loadAndExecuteScript=function(e,t,i){return loadAndExecuteScript(e).otherwise(i.reject)},Resource._DefaultImplementations={},Resource._DefaultImplementations.createImage=Resource._Implementations.createImage,Resource._DefaultImplementations.loadWithXhr=Resource._Implementations.loadWithXhr,Resource._DefaultImplementations.loadAndExecuteScript=Resource._Implementations.loadAndExecuteScript,Resource.DEFAULT=Object.freeze(new Resource({url:"undefined"==typeof document?"":document.location.href.split("?")[0]}));var cesiumScriptRegex=/((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/,a$1,baseResource,implementation$2;function getBaseUrlFromCesiumScript(){for(var e=document.getElementsByTagName("script"),t=0,i=e.length;t<i;++t){var r=e[t].getAttribute("src"),r=cesiumScriptRegex.exec(r);if(null!==r)return r[1]}}function tryMakeAbsolute(e){return"undefined"==typeof document?e:((a$1=!defined(a$1)?document.createElement("a"):a$1).href=e,a$1.href=a$1.href,a$1.href)}function getCesiumBaseUrl(){if(defined(baseResource))return baseResource;var e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?getAbsoluteUri("..",buildModuleUrl("Core/buildModuleUrl.js")):getBaseUrlFromCesiumScript();return(baseResource=new Resource({url:tryMakeAbsolute(e)})).appendForwardSlash(),baseResource}function buildModuleUrlFromRequireToUrl(e){return tryMakeAbsolute(require.toUrl("../"+e))}function buildModuleUrlFromBaseUrl(e){return getCesiumBaseUrl().getDerivedResource({url:e}).url}function buildModuleUrl(e){return(implementation$2=!defined(implementation$2)?"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?buildModuleUrlFromRequireToUrl:buildModuleUrlFromBaseUrl:implementation$2)(e)}function Cartesian2(e,t){this.x=defaultValue(e,0),this.y=defaultValue(t,0)}buildModuleUrl._cesiumScriptRegex=cesiumScriptRegex,buildModuleUrl._buildModuleUrlFromBaseUrl=buildModuleUrlFromBaseUrl,buildModuleUrl._clearBaseResource=function(){baseResource=void 0},buildModuleUrl.setBaseUrl=function(e){baseResource=Resource.DEFAULT.getDerivedResource({url:e})},buildModuleUrl.getCesiumBaseUrl=getCesiumBaseUrl,Cartesian2.fromElements=function(e,t,i){return defined(i)?(i.x=e,i.y=t,i):new Cartesian2(e,t)},Cartesian2.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t):new Cartesian2(e.x,e.y)},Cartesian2.fromCartesian3=Cartesian2.clone,Cartesian2.fromCartesian4=Cartesian2.clone,Cartesian2.packedLength=2,Cartesian2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i]=e.y,t},Cartesian2.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Cartesian2:i).x=e[t++],i.y=e[t],i},Cartesian2.packArray=function(e,t){var i=e.length,r=2*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 2 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian2.pack(e[n],t,2*n);return t},Cartesian2.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/2:t=new Array(i/2);for(var r=0;r<i;r+=2){var n=r/2;t[n]=Cartesian2.unpack(e,r,t[n])}return t},Cartesian2.fromArray=Cartesian2.unpack,Cartesian2.maximumComponent=function(e){return Math.max(e.x,e.y)},Cartesian2.minimumComponent=function(e){return Math.min(e.x,e.y)},Cartesian2.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i},Cartesian2.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i},Cartesian2.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},Cartesian2.magnitude=function(e){return Math.sqrt(Cartesian2.magnitudeSquared(e))};var distanceScratch$1=new Cartesian2;Cartesian2.distance=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitude(distanceScratch$1)},Cartesian2.distanceSquared=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitudeSquared(distanceScratch$1)},Cartesian2.normalize=function(e,t){var i=Cartesian2.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t},Cartesian2.dot=function(e,t){return e.x*t.x+e.y*t.y},Cartesian2.cross=function(e,t){return e.x*t.y-e.y*t.x},Cartesian2.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i},Cartesian2.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i},Cartesian2.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i},Cartesian2.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i},Cartesian2.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i},Cartesian2.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i},Cartesian2.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},Cartesian2.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var lerpScratch$1=new Cartesian2;Cartesian2.lerp=function(e,t,i,r){return Cartesian2.multiplyByScalar(t,i,lerpScratch$1),r=Cartesian2.multiplyByScalar(e,1-i,r),Cartesian2.add(lerpScratch$1,r,r)};var angleBetweenScratch=new Cartesian2,angleBetweenScratch2=new Cartesian2;Cartesian2.angleBetween=function(e,t){return Cartesian2.normalize(e,angleBetweenScratch),Cartesian2.normalize(t,angleBetweenScratch2),CesiumMath.acosClamped(Cartesian2.dot(angleBetweenScratch,angleBetweenScratch2))};var mostOrthogonalAxisScratch=new Cartesian2;function GeographicTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._rectangle=defaultValue(e.rectangle,Rectangle.MAX_VALUE),this._projection=new GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1)}Cartesian2.mostOrthogonalAxis=function(e,t){e=Cartesian2.normalize(e,mostOrthogonalAxisScratch);return Cartesian2.abs(e,e),t=e.x<=e.y?Cartesian2.clone(Cartesian2.UNIT_X,t):Cartesian2.clone(Cartesian2.UNIT_Y,t)},Cartesian2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y},Cartesian2.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]},Cartesian2.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)},Cartesian2.ZERO=Object.freeze(new Cartesian2(0,0)),Cartesian2.ONE=Object.freeze(new Cartesian2(1,1)),Cartesian2.UNIT_X=Object.freeze(new Cartesian2(1,0)),Cartesian2.UNIT_Y=Object.freeze(new Cartesian2(0,1)),Cartesian2.prototype.clone=function(e){return Cartesian2.clone(this,e)},Cartesian2.prototype.equals=function(e){return Cartesian2.equals(this,e)},Cartesian2.prototype.equalsEpsilon=function(e,t,i){return Cartesian2.equalsEpsilon(this,e,t,i)},Cartesian2.prototype.toString=function(){return"("+this.x+", "+this.y+")"},Object.defineProperties(GeographicTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},GeographicTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=CesiumMath.toDegrees(e.west),r=CesiumMath.toDegrees(e.south),n=CesiumMath.toDegrees(e.east),e=CesiumMath.toDegrees(e.north);return defined(t)?(t.west=i,t.south=r,t.east=n,t.north=e,t):new Rectangle(i,r,n,e)},GeographicTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){r=this.tileXYToRectangle(e,t,i,r);return r.west=CesiumMath.toDegrees(r.west),r.south=CesiumMath.toDegrees(r.south),r.east=CesiumMath.toDegrees(r.east),r.north=CesiumMath.toDegrees(r.north),r},GeographicTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),o=this.getNumberOfYTilesAtLevel(i),i=n.width/a,a=e*i+n.west,e=(e+1)*i+n.west,i=n.height/o,o=n.north-t*i,i=n.north-(t+1)*i;return(r=!defined(r)?new Rectangle(a,i,e,o):r).west=a,r.south=i,r.east=e,r.north=o,r},GeographicTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=r.width/n,s=r.height/a,t=e.longitude;r.east<r.west&&(t+=CesiumMath.TWO_PI);o=(t-r.west)/o|0;n<=o&&(o=n-1);s=(r.north-e.latitude)/s|0;return(a<=s&&(s=a-1),defined(i))?(i.x=o,i.y=s,i):new Cartesian2(o,s)}};var scratchDiagonalCartesianNE=new Cartesian3,scratchDiagonalCartesianSW=new Cartesian3,scratchDiagonalCartographic=new Cartographic,scratchCenterCartesian=new Cartesian3,scratchSurfaceCartesian=new Cartesian3,scratchBoundingSphere$4=new BoundingSphere,tilingScheme=new GeographicTilingScheme,scratchCorners=[new Cartographic,new Cartographic,new Cartographic,new Cartographic],scratchTileXY=new Cartesian2,ApproximateTerrainHeights={};function getTileXYLevel(e){Cartographic.fromRadians(e.east,e.north,0,scratchCorners[0]),Cartographic.fromRadians(e.west,e.north,0,scratchCorners[1]),Cartographic.fromRadians(e.east,e.south,0,scratchCorners[2]),Cartographic.fromRadians(e.west,e.south,0,scratchCorners[3]);for(var t=0,i=0,r=0,n=0,a=ApproximateTerrainHeights._terrainHeightsMaxLevel,o=0;o<=a;++o){for(var s=!1,l=0;l<4;++l){var c=scratchCorners[l];if(tilingScheme.positionToTileXY(c,o,scratchTileXY),0===l)r=scratchTileXY.x,n=scratchTileXY.y;else if(r!==scratchTileXY.x||n!==scratchTileXY.y){s=!0;break}}if(s)break;t=r,i=n}if(0!==o)return{x:t,y:i,level:a<o?a:o-1}}function _toConsumableArray(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}ApproximateTerrainHeights.initialize=function(){var e=ApproximateTerrainHeights._initPromise;return defined(e)?e:(e=Resource.fetchJson(buildModuleUrl("Assets/approximateTerrainHeights.json")).then(function(e){ApproximateTerrainHeights._terrainHeights=e}),ApproximateTerrainHeights._initPromise=e)},ApproximateTerrainHeights.getMinimumMaximumHeights=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMinTerrainHeight,n=ApproximateTerrainHeights._defaultMaxTerrainHeight;return defined(i)&&(i=i.level+"-"+i.x+"-"+i.y,defined(i=ApproximateTerrainHeights._terrainHeights[i])&&(r=i[0],n=i[1]),t.cartographicToCartesian(Rectangle.northeast(e,scratchDiagonalCartographic),scratchDiagonalCartesianNE),t.cartographicToCartesian(Rectangle.southwest(e,scratchDiagonalCartographic),scratchDiagonalCartesianSW),Cartesian3.midpoint(scratchDiagonalCartesianSW,scratchDiagonalCartesianNE,scratchCenterCartesian),r=defined(t=t.scaleToGeodeticSurface(scratchCenterCartesian,scratchSurfaceCartesian))?(t=Cartesian3.distance(scratchCenterCartesian,t),Math.min(r,-t)):ApproximateTerrainHeights._defaultMinTerrainHeight),{minimumTerrainHeight:r=Math.max(ApproximateTerrainHeights._defaultMinTerrainHeight,r),maximumTerrainHeight:n}},ApproximateTerrainHeights.getBoundingSphere=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMaxTerrainHeight;defined(i)&&(n=i.level+"-"+i.x+"-"+i.y,defined(n=ApproximateTerrainHeights._terrainHeights[n])&&(r=n[1]));var n=BoundingSphere.fromRectangle3D(e,t,0);return BoundingSphere.fromRectangle3D(e,t,r,scratchBoundingSphere$4),BoundingSphere.union(n,scratchBoundingSphere$4,n)},ApproximateTerrainHeights._terrainHeightsMaxLevel=6,ApproximateTerrainHeights._defaultMaxTerrainHeight=9e3,ApproximateTerrainHeights._defaultMinTerrainHeight=-1e5,ApproximateTerrainHeights._terrainHeights=void 0,ApproximateTerrainHeights._initPromise=void 0,Object.defineProperties(ApproximateTerrainHeights,{initialized:{get:function(){return defined(ApproximateTerrainHeights._terrainHeights)}}});var hasOwnProperty=Object.hasOwnProperty,setPrototypeOf=Object.setPrototypeOf,isFrozen=Object.isFrozen,getPrototypeOf=Object.getPrototypeOf,getOwnPropertyDescriptor=Object.getOwnPropertyDescriptor,freeze=Object.freeze,seal=Object.seal,create=Object.create,_ref="undefined"!=typeof Reflect&&Reflect,apply=_ref.apply,construct=_ref.construct,apply=apply||function(e,t,i){return e.apply(t,i)},freeze=freeze||function(e){return e},seal=seal||function(e){return e},construct=construct||function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(_toConsumableArray(t))))},arrayForEach=unapply(Array.prototype.forEach),arrayPop=unapply(Array.prototype.pop),arrayPush=unapply(Array.prototype.push),stringToLowerCase=unapply(String.prototype.toLowerCase),stringMatch=unapply(String.prototype.match),stringReplace=unapply(String.prototype.replace),stringIndexOf=unapply(String.prototype.indexOf),stringTrim=unapply(String.prototype.trim),regExpTest=unapply(RegExp.prototype.test),typeErrorCreate=unconstruct(TypeError);function unapply(n){return function(e){for(var t=arguments.length,i=Array(1<t?t-1:0),r=1;r<t;r++)i[r-1]=arguments[r];return apply(n,e,i)}}function unconstruct(r){return function(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];return construct(r,t)}}function addToSet(e,t){setPrototypeOf&&setPrototypeOf(e,null);for(var i=t.length;i--;){var r,n=t[i];"string"!=typeof n||(r=stringToLowerCase(n))!==n&&(isFrozen(t)||(t[i]=r),n=r),e[n]=!0}return e}function clone(e){var t=create(null),i=void 0;for(i in e)apply(hasOwnProperty,e,[i])&&(t[i]=e[i]);return t}function lookupGetter(e,t){for(;null!==e;){var i=getOwnPropertyDescriptor(e,t);if(i){if(i.get)return unapply(i.get);if("function"==typeof i.value)return unapply(i.value)}e=getPrototypeOf(e)}return function(e){return console.warn("fallback value for",e),null}}var html=freeze(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),svg=freeze(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),svgFilters=freeze(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),svgDisallowed=freeze(["animate","color-profile","cursor","discard","fedropshadow","feimage","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),mathMl=freeze(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),mathMlDisallowed=freeze(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),text=freeze(["#text"]),html$1=freeze(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),svg$1=freeze(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),mathMl$1=freeze(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),xml=freeze(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),MUSTACHE_EXPR=seal(/\{\{[\s\S]*|[\s\S]*\}\}/gm),ERB_EXPR=seal(/<%[\s\S]*|[\s\S]*%>/gm),DATA_ATTR=seal(/^data-[\-\w.\u00B7-\uFFFF]/),ARIA_ATTR=seal(/^aria-[\-\w]+$/),IS_ALLOWED_URI=seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),IS_SCRIPT_OR_DATA=seal(/^(?:\w+script|data):/i),ATTR_WHITESPACE=seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function _toConsumableArray$1(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var getGlobal=function(){return"undefined"==typeof window?null:window},_createTrustedTypesPolicy=function(e,t){if("object"!==(void 0===e?"undefined":_typeof(e))||"function"!=typeof e.createPolicy)return null;var i=null,r="data-tt-policy-suffix",i="dompurify"+((i=t.currentScript&&t.currentScript.hasAttribute(r)?t.currentScript.getAttribute(r):i)?"#"+i:"");try{return e.createPolicy(i,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+i+" could not be created."),null}};function createDOMPurify(){var l=0<arguments.length&&void 0!==arguments[0]?arguments[0]:getGlobal(),u=function(e){return createDOMPurify(e)};if(u.version="2.3.1",u.removed=[],!l||!l.document||9!==l.document.nodeType)return u.isSupported=!1,u;var c=l.document,n=l.document,d=l.DocumentFragment,e=l.HTMLTemplateElement,h=l.Node,o=l.Element,t=l.NodeFilter,i=l.NamedNodeMap,s=void 0===i?l.NamedNodeMap||l.MozNamedAttrMap:i,p=l.Text,f=l.Comment,a=l.DOMParser,r=l.trustedTypes,i=o.prototype,m=lookupGetter(i,"cloneNode"),g=lookupGetter(i,"nextSibling"),_=lookupGetter(i,"childNodes"),y=lookupGetter(i,"parentNode");"function"!=typeof e||(e=n.createElement("template")).content&&e.content.ownerDocument&&(n=e.content.ownerDocument);var C=_createTrustedTypesPolicy(r,c),v=C&&Q?C.createHTML(""):"",r=n,T=r.implementation,S=r.createNodeIterator,A=r.createDocumentFragment,x=r.getElementsByTagName,b=c.importNode,r={};try{r=clone(n).documentMode?n.documentMode:{}}catch(e){}var E={};u.isSupported="function"==typeof y&&T&&void 0!==T.createHTMLDocument&&9!==r;function P(e){pe&&pe===e||(e=clone(e=!e||"object"!==(void 0===e?"undefined":_typeof(e))?{}:e),F="ALLOWED_TAGS"in e?addToSet({},e.ALLOWED_TAGS):N,V="ALLOWED_ATTR"in e?addToSet({},e.ALLOWED_ATTR):k,se="ADD_URI_SAFE_ATTR"in e?addToSet(clone(le),e.ADD_URI_SAFE_ATTR):le,ae="ADD_DATA_URI_TAGS"in e?addToSet(clone(oe),e.ADD_DATA_URI_TAGS):oe,re="FORBID_CONTENTS"in e?addToSet({},e.FORBID_CONTENTS):ne,G="FORBID_TAGS"in e?addToSet({},e.FORBID_TAGS):{},U="FORBID_ATTR"in e?addToSet({},e.FORBID_ATTR):{},ie="USE_PROFILES"in e&&e.USE_PROFILES,$=!1!==e.ALLOW_ARIA_ATTR,z=!1!==e.ALLOW_DATA_ATTR,H=e.ALLOW_UNKNOWN_PROTOCOLS||!1,W=e.SAFE_FOR_TEMPLATES||!1,q=e.WHOLE_DOCUMENT||!1,K=e.RETURN_DOM||!1,Y=e.RETURN_DOM_FRAGMENT||!1,J=!1!==e.RETURN_DOM_IMPORT,Q=e.RETURN_TRUSTED_TYPE||!1,X=e.FORCE_BODY||!1,Z=!1!==e.SANITIZE_DOM,ee=!1!==e.KEEP_CONTENT,te=e.IN_PLACE||!1,L=e.ALLOWED_URI_REGEXP||L,he=e.NAMESPACE||de,W&&(z=!1),Y&&(K=!0),ie&&(F=addToSet({},[].concat(_toConsumableArray$1(text))),V=[],!0===ie.html&&(addToSet(F,html),addToSet(V,html$1)),!0===ie.svg&&(addToSet(F,svg),addToSet(V,svg$1),addToSet(V,xml)),!0===ie.svgFilters&&(addToSet(F,svgFilters),addToSet(V,svg$1),addToSet(V,xml)),!0===ie.mathMl&&(addToSet(F,mathMl),addToSet(V,mathMl$1),addToSet(V,xml))),e.ADD_TAGS&&addToSet(F=F===N?clone(F):F,e.ADD_TAGS),e.ADD_ATTR&&addToSet(V=V===k?clone(V):V,e.ADD_ATTR),e.ADD_URI_SAFE_ATTR&&addToSet(se,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&addToSet(re=re===ne?clone(re):re,e.FORBID_CONTENTS),ee&&(F["#text"]=!0),q&&addToSet(F,["html","head","body"]),F.table&&(addToSet(F,["tbody"]),delete G.tbody),freeze&&freeze(e),pe=e)}var D,w=MUSTACHE_EXPR,M=ERB_EXPR,I=DATA_ATTR,R=ARIA_ATTR,O=IS_SCRIPT_OR_DATA,B=ATTR_WHITESPACE,L=IS_ALLOWED_URI,F=null,N=addToSet({},[].concat(_toConsumableArray$1(html),_toConsumableArray$1(svg),_toConsumableArray$1(svgFilters),_toConsumableArray$1(mathMl),_toConsumableArray$1(text))),V=null,k=addToSet({},[].concat(_toConsumableArray$1(html$1),_toConsumableArray$1(svg$1),_toConsumableArray$1(mathMl$1),_toConsumableArray$1(xml))),G=null,U=null,$=!0,z=!0,H=!1,W=!1,q=!1,j=!1,X=!1,K=!1,Y=!1,J=!0,Q=!1,Z=!0,ee=!0,te=!1,ie={},re=null,ne=addToSet({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),ae=null,oe=addToSet({},["audio","video","img","source","image","track"]),se=null,le=addToSet({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),ce="http://www.w3.org/1998/Math/MathML",ue="http://www.w3.org/2000/svg",de="http://www.w3.org/1999/xhtml",he=de,pe=null,fe=n.createElement("form"),me=addToSet({},["mi","mo","mn","ms","mtext"]),ge=addToSet({},["foreignobject","desc","title","annotation-xml"]),_e=addToSet({},svg);addToSet(_e,svgFilters),addToSet(_e,svgDisallowed);var ye=addToSet({},mathMl);addToSet(ye,mathMlDisallowed);function Ce(t){arrayPush(u.removed,{element:t});try{t.parentNode.removeChild(t)}catch(e){try{t.outerHTML=v}catch(e){t.remove()}}}function ve(e){var t=void 0,i=void 0;X?e="<remove></remove>"+e:i=(r=stringMatch(e,/^[\r\n\t ]+/))&&r[0];var r=C?C.createHTML(e):e;if(he===de)try{t=(new a).parseFromString(r,"text/html")}catch(e){}if(!t||!t.documentElement){t=T.createDocument(he,"template",null);try{t.documentElement.innerHTML=D?"":r}catch(e){}}return r=t.body||t.documentElement,e&&i&&r.insertBefore(n.createTextNode(i),r.childNodes[0]||null),he===de?x.call(t,q?"html":"body")[0]:q?t.documentElement:r}function Te(e){return S.call(e.ownerDocument||e,e,t.SHOW_ELEMENT|t.SHOW_COMMENT|t.SHOW_TEXT,null,!1)}function Se(e){return"object"===(void 0===h?"undefined":_typeof(h))?e instanceof h:e&&"object"===(void 0===e?"undefined":_typeof(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName}function Ae(e){var t;if(Pe("beforeSanitizeElements",e,null),!((i=e)instanceof p||i instanceof f)&&!("string"==typeof i.nodeName&&"string"==typeof i.textContent&&"function"==typeof i.removeChild&&i.attributes instanceof s&&"function"==typeof i.removeAttribute&&"function"==typeof i.setAttribute&&"string"==typeof i.namespaceURI&&"function"==typeof i.insertBefore))return Ce(e),1;if(stringMatch(e.nodeName,/[\u0080-\uFFFF]/))return Ce(e),1;var i=stringToLowerCase(e.nodeName);if(Pe("uponSanitizeElement",e,{tagName:i,allowedTags:F}),!Se(e.firstElementChild)&&(!Se(e.content)||!Se(e.content.firstElementChild))&&regExpTest(/<[/\w]/g,e.innerHTML)&&regExpTest(/<[/\w]/g,e.textContent))return Ce(e),1;if("select"===i&&regExpTest(/<template/i,e.innerHTML))return Ce(e),1;if(F[i]&&!G[i])return(!(e instanceof o)||function(e){var t=y(e);t&&t.tagName||(t={namespaceURI:de,tagName:"template"});var i=stringToLowerCase(e.tagName),r=stringToLowerCase(t.tagName);if(e.namespaceURI===ue)return t.namespaceURI===de?"svg"===i:t.namespaceURI===ce?"svg"===i&&("annotation-xml"===r||me[r]):Boolean(_e[i]);if(e.namespaceURI===ce)return t.namespaceURI===de?"math"===i:t.namespaceURI===ue?"math"===i&&ge[r]:Boolean(ye[i]);if(e.namespaceURI!==de)return!1;if(t.namespaceURI===ue&&!ge[r])return!1;if(t.namespaceURI===ce&&!me[r])return!1;r=addToSet({},["title","style","font","a","script"]);return!ye[i]&&(r[i]||!_e[i])}(e))&&("noscript"!==i&&"noembed"!==i||!regExpTest(/<\/no(script|embed)/i,e.innerHTML))?(W&&3===e.nodeType&&(t=e.textContent,t=stringReplace(t,w," "),t=stringReplace(t,M," "),e.textContent!==t&&(arrayPush(u.removed,{element:e.cloneNode()}),e.textContent=t)),Pe("afterSanitizeElements",e,null),!1):(Ce(e),!0);if(ee&&!re[i]){var r=y(e)||e.parentNode,n=_(e)||e.childNodes;if(n&&r)for(var a=n.length-1;0<=a;--a)r.insertBefore(m(n[a],!0),g(e))}return Ce(e),1}function xe(e){var t=void 0,i=void 0,r=void 0;Pe("beforeSanitizeAttributes",e,null);var n=e.attributes;if(n){for(var a={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:V},r=n.length;r--;){var o=(t=n[r]).name,s=t.namespaceURI,i=stringTrim(t.value),l=stringToLowerCase(o);if(a.attrName=l,a.attrValue=i,a.keepAttr=!0,a.forceKeepAttr=void 0,Pe("uponSanitizeAttribute",e,a),i=a.attrValue,!a.forceKeepAttr&&(Ee(o,e),a.keepAttr))if(regExpTest(/\/>/i,i))Ee(o,e);else{W&&(i=stringReplace(i,w," "),i=stringReplace(i,M," "));var c=e.nodeName.toLowerCase();if(De(c,l,i))try{s?e.setAttributeNS(s,o,i):e.setAttribute(o,i),arrayPop(u.removed)}catch(e){}}}Pe("afterSanitizeAttributes",e,null)}}function be(e){var t,i=Te(e);for(Pe("beforeSanitizeShadowDOM",e,null);t=i.nextNode();)Pe("uponSanitizeShadowNode",t,null),Ae(t)||(t.content instanceof d&&be(t.content),xe(t));Pe("afterSanitizeShadowDOM",e,null)}var Ee=function(e,t){try{arrayPush(u.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){arrayPush(u.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!V[e])if(K||Y)try{Ce(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},Pe=function(e,t,i){E[e]&&arrayForEach(E[e],function(e){e.call(u,t,i,pe)})},De=function(e,t,i){if(Z&&("id"===t||"name"===t)&&(i in n||i in fe))return!1;if((!z||U[t]||!regExpTest(I,t))&&(!$||!regExpTest(R,t))){if(!V[t]||U[t])return!1;if(!se[t]&&!regExpTest(L,stringReplace(i,B,"")))if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==stringIndexOf(i,"data:")||!ae[e]){if((!H||regExpTest(O,stringReplace(i,B,"")))&&i)return!1}else;}return!0};return u.sanitize=function(e,t){var i,r,n=void 0,a=void 0,o=void 0;if("string"!=typeof(e=(D=!e)?"\x3c!--\x3e":e)&&!Se(e)){if("function"!=typeof e.toString)throw typeErrorCreate("toString is not a function");if("string"!=typeof(e=e.toString()))throw typeErrorCreate("dirty is not a string, aborting")}if(!u.isSupported){if("object"===_typeof(l.toStaticHTML)||"function"==typeof l.toStaticHTML){if("string"==typeof e)return l.toStaticHTML(e);if(Se(e))return l.toStaticHTML(e.outerHTML)}return e}if(j||P(t),u.removed=[],!(te="string"==typeof e?!1:te))if(e instanceof h)1===(i=(n=ve("\x3c!----\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===i.nodeName||"HTML"===i.nodeName?n=i:n.appendChild(i);else{if(!K&&!W&&!q&&-1===e.indexOf("<"))return C&&Q?C.createHTML(e):e;if(!(n=ve(e)))return K?null:v}n&&X&&Ce(n.firstChild);for(var s=Te(te?e:n);r=s.nextNode();)3===r.nodeType&&r===a||Ae(r)||(r.content instanceof d&&be(r.content),xe(r),a=r);if(a=null,te)return e;if(K){if(Y)for(o=A.call(n.ownerDocument);n.firstChild;)o.appendChild(n.firstChild);else o=n;return o=J?b.call(c,o,!0):o}e=q?n.outerHTML:n.innerHTML;return W&&(e=stringReplace(e,w," "),e=stringReplace(e,M," ")),C&&Q?C.createHTML(e):e},u.setConfig=function(e){P(e),j=!0},u.clearConfig=function(){pe=null,j=!1},u.isValidAttribute=function(e,t,i){pe||P({});e=stringToLowerCase(e),t=stringToLowerCase(t);return De(e,t,i)},u.addHook=function(e,t){"function"==typeof t&&(E[e]=E[e]||[],arrayPush(E[e],t))},u.removeHook=function(e){E[e]&&arrayPop(E[e])},u.removeHooks=function(e){E[e]&&(E[e]=[])},u.removeAllHooks=function(){E={}},u}var purify=createDOMPurify(),nextCreditId=0,creditToId={};function Credit(e,t){var i,r=e;defined(creditToId[r])?i=creditToId[r]:(i=nextCreditId++,creditToId[r]=i),t=defaultValue(t,!1),this._id=i,this._html=e,this._showOnScreen=t,this._element=void 0}Object.defineProperties(Credit.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen}},element:{get:function(){if(!defined(this._element)){var e=purify.sanitize(this._html),t=document.createElement("div");t._creditId=this._id,t.style.display="inline",t.innerHTML=e;for(var i=t.querySelectorAll("a"),r=0;r<i.length;r++)i[r].setAttribute("target","_blank");this._element=t}return this._element}}}),Credit.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._id===t._id},Credit.prototype.equals=function(e){return Credit.equals(this,e)},Credit.getIonCredit=function(e){var t=defined(e.collapsible)&&!e.collapsible,t=new Credit(e.html,t);return t._isIon=-1!==t.html.indexOf("ion-credit.png"),t},Credit.clone=function(e){if(defined(e))return new Credit(e.html,e.showOnScreen)};var HeightmapEncoding={NONE:0,LERC:1},HeightmapEncoding$1=Object.freeze(HeightmapEncoding);function AxisAlignedBoundingBox(e,t,i){this.minimum=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.maximum=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),i=defined(i)?Cartesian3.clone(i):Cartesian3.midpoint(this.minimum,this.maximum,new Cartesian3),this.center=i}AxisAlignedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new AxisAlignedBoundingBox),!defined(e)||0===e.length)return t.minimum=Cartesian3.clone(Cartesian3.ZERO,t.minimum),t.maximum=Cartesian3.clone(Cartesian3.ZERO,t.maximum),t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t;for(var i=e[0].x,r=e[0].y,n=e[0].z,a=e[0].x,o=e[0].y,s=e[0].z,l=e.length,c=1;c<l;c++)var u=e[c],d=u.x,h=u.y,u=u.z,i=Math.min(d,i),a=Math.max(d,a),r=Math.min(h,r),o=Math.max(h,o),n=Math.min(u,n),s=Math.max(u,s);var p=t.minimum;p.x=i,p.y=r,p.z=n;var f=t.maximum;return f.x=a,f.y=o,f.z=s,t.center=Cartesian3.midpoint(p,f,t.center),t},AxisAlignedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(t.minimum=Cartesian3.clone(e.minimum,t.minimum),t.maximum=Cartesian3.clone(e.maximum,t.maximum),t.center=Cartesian3.clone(e.center,t.center),t):new AxisAlignedBoundingBox(e.minimum,e.maximum,e.center)},AxisAlignedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Cartesian3.equals(e.minimum,t.minimum)&&Cartesian3.equals(e.maximum,t.maximum)};var intersectScratch=new Cartesian3;function EllipsoidalOccluder(e,t){this._ellipsoid=e,this._cameraPosition=new Cartesian3,this._cameraPositionInScaledSpace=new Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,defined(t)&&(this.cameraPosition=t)}AxisAlignedBoundingBox.intersectPlane=function(e,t){intersectScratch=Cartesian3.subtract(e.maximum,e.minimum,intersectScratch);var i=Cartesian3.multiplyByScalar(intersectScratch,.5,intersectScratch),r=t.normal,i=i.x*Math.abs(r.x)+i.y*Math.abs(r.y)+i.z*Math.abs(r.z),t=Cartesian3.dot(e.center,r)+t.distance;return 0<t-i?Intersect$1.INSIDE:t+i<0?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},AxisAlignedBoundingBox.prototype.clone=function(e){return AxisAlignedBoundingBox.clone(this,e)},AxisAlignedBoundingBox.prototype.intersectPlane=function(e){return AxisAlignedBoundingBox.intersectPlane(this,e)},AxisAlignedBoundingBox.prototype.equals=function(e){return AxisAlignedBoundingBox.equals(this,e)},Object.defineProperties(EllipsoidalOccluder.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=Cartesian3.magnitudeSquared(t)-1;Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=i}}});var scratchCartesian$9=new Cartesian3;EllipsoidalOccluder.prototype.isPointVisible=function(e){return isScaledSpacePointVisible(this._ellipsoid.transformPositionToScaledSpace(e,scratchCartesian$9),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},EllipsoidalOccluder.prototype.isScaledSpacePointVisible=function(e){return isScaledSpacePointVisible(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var scratchCameraPositionInScaledSpaceShrunk=new Cartesian3;EllipsoidalOccluder.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){var i,r=this._ellipsoid,t=defined(t)&&t<0&&r.minimumRadius>-t?((i=scratchCameraPositionInScaledSpaceShrunk).x=this._cameraPosition.x/(r.radii.x+t),i.y=this._cameraPosition.y/(r.radii.y+t),i.z=this._cameraPosition.z/(r.radii.z+t),i.x*i.x+i.y*i.y+i.z*i.z-1):(i=this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared);return isScaledSpacePointVisible(e,i,t)},EllipsoidalOccluder.prototype.computeHorizonCullingPoint=function(e,t,i){return computeHorizonCullingPointFromPositions(this._ellipsoid,e,t,i)};var scratchEllipsoidShrunk=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE);EllipsoidalOccluder.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,i,r){return computeHorizonCullingPointFromPositions(getPossiblyShrunkEllipsoid(this._ellipsoid,i,scratchEllipsoidShrunk),e,t,r)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices=function(e,t,i,r,n){return computeHorizonCullingPointFromVertices(this._ellipsoid,e,t,i,r,n)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,i,r,n,a){return computeHorizonCullingPointFromVertices(getPossiblyShrunkEllipsoid(this._ellipsoid,n,scratchEllipsoidShrunk),e,t,i,r,a)};var subsampleScratch=[];EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle=function(e,t,i){var r=Rectangle.subsample(e,t,0,subsampleScratch),e=BoundingSphere.fromPoints(r);if(!(Cartesian3.magnitude(e.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(e.center,r,i)};var scratchEllipsoidShrunkRadii=new Cartesian3;function getPossiblyShrunkEllipsoid(e,t,i){return defined(t)&&t<0&&e.minimumRadius>-t&&(t=Cartesian3.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,scratchEllipsoidShrunkRadii),e=Ellipsoid.fromCartesian3(t,i)),e}function computeHorizonCullingPointFromPositions(e,t,i,r){defined(r)||(r=new Cartesian3);for(var n=computeScaledSpaceDirectionToPoint(e,t),a=0,o=0,s=i.length;o<s;++o){var l=computeMagnitude(e,i[o],n);if(l<0)return;a=Math.max(a,l)}return magnitudeToPoint(n,a,r)}var positionScratch$b=new Cartesian3;function computeHorizonCullingPointFromVertices(e,t,i,r,n,a){defined(a)||(a=new Cartesian3),r=defaultValue(r,3),n=defaultValue(n,Cartesian3.ZERO);for(var o=computeScaledSpaceDirectionToPoint(e,t),s=0,l=0,c=i.length;l<c;l+=r){positionScratch$b.x=i[l]+n.x,positionScratch$b.y=i[l+1]+n.y,positionScratch$b.z=i[l+2]+n.z;var u=computeMagnitude(e,positionScratch$b,o);if(u<0)return;s=Math.max(s,u)}return magnitudeToPoint(o,s,a)}function isScaledSpacePointVisible(e,t,i){e=Cartesian3.subtract(e,t,scratchCartesian$9),t=-Cartesian3.dot(e,t);return!(i<0?0<t:i<t&&t*t/Cartesian3.magnitudeSquared(e)>i)}var scaledSpaceScratch=new Cartesian3,directionScratch=new Cartesian3;function computeMagnitude(e,t,i){var r=e.transformPositionToScaledSpace(t,scaledSpaceScratch),e=Cartesian3.magnitudeSquared(r),t=Math.sqrt(e),r=Cartesian3.divideByScalar(r,t,directionScratch),e=Math.max(1,e),t=1/(t=Math.max(1,t));return 1/(Cartesian3.dot(r,i)*t-Cartesian3.magnitude(Cartesian3.cross(r,i,r))*(Math.sqrt(e-1)*t))}function magnitudeToPoint(e,t,i){if(!(t<=0||t===1/0||t!=t))return Cartesian3.multiplyByScalar(e,t,i)}var directionToPointScratch=new Cartesian3;function computeScaledSpaceDirectionToPoint(e,t){return Cartesian3.equals(t,Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,directionToPointScratch),Cartesian3.normalize(directionToPointScratch,directionToPointScratch))}var QuadraticRealPolynomial={};function addWithCancellationCheck$1(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}QuadraticRealPolynomial.computeDiscriminant=function(e,t,i){return t*t-4*e*i},QuadraticRealPolynomial.computeRealRoots=function(e,t,i){if(0===e)return 0===t?[]:[-i/t];if(0===t){if(0===i)return[0,0];var r=Math.abs(i),n=Math.abs(e);if(r<n&&r/n<CesiumMath.EPSILON14)return[0,0];if(n<r&&n/r<CesiumMath.EPSILON14)return[];if((n=-i/e)<0)return[];r=Math.sqrt(n);return[-r,r]}if(0===i)return(n=-t/e)<0?[n,0]:[0,n];n=addWithCancellationCheck$1(t*t,-(4*e*i),CesiumMath.EPSILON14);if(n<0)return[];n=-.5*addWithCancellationCheck$1(t,CesiumMath.sign(t)*Math.sqrt(n),CesiumMath.EPSILON14);return 0<t?[n/e,i/n]:[i/n,n/e]};var CubicRealPolynomial={};function computeRealRoots(e,t,i,r){var n=e,a=t/3,o=i/3,s=r,l=n*o,c=a*s,u=a*a,d=o*o,h=n*o-u,e=n*s-a*o,t=a*s-d,i=4*h*t-e*e;if(i<0){var r=l*d<=u*c?-2*a*(m=h)+(f=n)*e:-(f=s)*e+2*o*(m=t),p=-(r<0?-1:1)*Math.abs(f)*Math.sqrt(-i),f=(g=p-r)/2,f=f<0?-Math.pow(-f,1/3):Math.pow(f,1/3),p=g===p?-f:-m/f,p=m<=0?f+p:-r/(f*f+p*p+m);return l*d<=u*c?[(p-a)/n]:[-s/(p+o)]}var m=h,l=-2*a*h+n*e,d=t,u=-s*e+2*o*t,c=Math.sqrt(i),h=Math.sqrt(3)/2,e=Math.abs(Math.atan2(n*c,-l)/3);p=2*Math.sqrt(-m);t=Math.cos(e);g=p*t;var i=p*(-t/2-h*Math.sin(e)),l=2*a<g+i?g-a:i-a,m=n,n=l/m,e=Math.abs(Math.atan2(s*c,-u)/3),s=-s,e=(g=(p=2*Math.sqrt(-d))*(t=Math.cos(e)))+(i=p*(-t/2-h*Math.sin(e)))<2*o?g+o:i+o,g=s/e,i=-l*e-m*s,e=(o*i-a*(l*s))/(-a*i+o*(m*e));return n<=e?n<=g?e<=g?[n,e,g]:[n,g,e]:[g,n,e]:n<=g?[e,n,g]:e<=g?[e,g,n]:[g,e,n]}CubicRealPolynomial.computeDiscriminant=function(e,t,i,r){var n=t*t,a=i*i;return 18*e*t*i*r+n*a-27*(e*e)*(r*r)-4*(e*a*i+n*t*r)},CubicRealPolynomial.computeRealRoots=function(e,t,i,r){var n;if(0===e)return QuadraticRealPolynomial.computeRealRoots(t,i,r);if(0!==t)return 0===i?0===r?(a=-t/e)<0?[a,0,0]:[0,0,a]:computeRealRoots(e,t,0,r):0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,t,i)).length?[0]:n[1]<=0?[n[0],n[1],0]:0<=n[0]?[0,n[0],n[1]]:[n[0],0,n[1]]:computeRealRoots(e,t,i,r);if(0!==i)return 0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,0,i)).Length?[0]:[n[0],0,n[1]]:computeRealRoots(e,0,i,r);if(0===r)return[0,0,0];var a=(a=-r/e)<0?-Math.pow(-a,1/3):Math.pow(a,1/3);return[a,a,a]};var QuarticRealPolynomial={};function original(e,t,i,r){var n=e*e,a=t-3*n/8,o=i-t*e/2+n*e/8,r=r-i*e/4+t*n/16-3*n*n/256,i=CubicRealPolynomial.computeRealRoots(1,2*a,a*a-4*r,-o*o);if(0<i.length){t=-e/4,n=i[i.length-1];if(Math.abs(n)<CesiumMath.EPSILON14){e=QuadraticRealPolynomial.computeRealRoots(1,a,r);if(2===e.length){var i=e[0],s=e[1];if(0<=i&&0<=s){r=Math.sqrt(i),e=Math.sqrt(s);return[t-e,t-r,t+r,t+e]}if(0<=i&&s<0)return[t-(l=Math.sqrt(i)),t+l];if(i<0&&0<=s)return[t-(l=Math.sqrt(s)),t+l]}return[]}if(0<n){var s=Math.sqrt(n),l=(a+n+o/s)/2,o=QuadraticRealPolynomial.computeRealRoots(1,s,(a+n-o/s)/2),l=QuadraticRealPolynomial.computeRealRoots(1,-s,l);return 0!==o.length?(o[0]+=t,o[1]+=t,0!==l.length?(l[0]+=t,l[1]+=t,o[1]<=l[0]?[o[0],o[1],l[0],l[1]]:l[1]<=o[0]?[l[0],l[1],o[0],o[1]]:o[0]>=l[0]&&o[1]<=l[1]?[l[0],o[0],o[1],l[1]]:l[0]>=o[0]&&l[1]<=o[1]?[o[0],l[0],l[1],o[1]]:o[0]>l[0]&&o[0]<l[1]?[l[0],o[0],l[1],o[1]]:[o[0],l[0],o[1],l[1]]):o):0!==l.length?(l[0]+=t,l[1]+=t,l):[]}}return[]}function neumark(e,t,i,r){var n=e*e,a=CubicRealPolynomial.computeRealRoots(1,-2*t,i*e+t*t-4*r,n*r-i*t*e+i*i);if(0<a.length){var o,s,l,c,u=a[0],d=t-u,h=d*d,p=e/2,a=d/2,t=h-4*r,d=h+4*Math.abs(r),h=n-4*u,n=n+4*Math.abs(u);s=u<0||t*n<h*d?(o=(h=Math.sqrt(h))/2,0===h?0:(e*a-i)/h):(o=0===(s=Math.sqrt(t))?0:(e*a-i)/s,s/2),0==p&&0===o?c=l=0:CesiumMath.sign(p)===CesiumMath.sign(o)?c=u/(l=p+o):l=u/(c=p-o),0==a&&0===s?m=f=0:CesiumMath.sign(a)===CesiumMath.sign(s)?m=r/(f=a+s):f=r/(m=a-s);var f=QuadraticRealPolynomial.computeRealRoots(1,l,f),m=QuadraticRealPolynomial.computeRealRoots(1,c,m);if(0!==f.length)return 0!==m.length?f[1]<=m[0]?[f[0],f[1],m[0],m[1]]:m[1]<=f[0]?[m[0],m[1],f[0],f[1]]:f[0]>=m[0]&&f[1]<=m[1]?[m[0],f[0],f[1],m[1]]:m[0]>=f[0]&&m[1]<=f[1]?[f[0],m[0],m[1],f[1]]:f[0]>m[0]&&f[0]<m[1]?[m[0],f[0],m[1],f[1]]:[f[0],m[0],f[1],m[1]]:f;if(0!==m.length)return m}return[]}function Ray(e,t){t=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),Cartesian3.equals(t,Cartesian3.ZERO)||Cartesian3.normalize(t,t),this.origin=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.direction=t}QuarticRealPolynomial.computeDiscriminant=function(e,t,i,r,n){var a=e*e,o=t*t,s=o*t,l=i*i,c=l*i,u=r*r,d=u*r,h=n*n;return o*l*u-4*s*d-4*e*c*u+18*e*t*i*d-27*a*u*u+256*(a*e)*(h*n)+n*(18*s*i*r-4*o*c+16*e*l*l-80*e*t*l*r-6*e*o*u+144*a*i*u)+h*(144*e*o*i-27*o*o-128*a*l-192*a*t*r)},QuarticRealPolynomial.computeRealRoots=function(e,t,i,r,n){if(Math.abs(e)<CesiumMath.EPSILON15)return CubicRealPolynomial.computeRealRoots(t,i,r,n);var a=t/e,o=i/e,s=r/e,l=n/e,e=a<0?1:0;switch(e+=o<0?e+1:e,e+=s<0?e+1:e,e+=l<0?e+1:e){case 0:return original(a,o,s,l);case 1:case 2:return neumark(a,o,s,l);case 3:case 4:return original(a,o,s,l);case 5:return neumark(a,o,s,l);case 6:case 7:return original(a,o,s,l);case 8:return neumark(a,o,s,l);case 9:case 10:return original(a,o,s,l);case 11:return neumark(a,o,s,l);case 12:case 13:case 14:case 15:return original(a,o,s,l);default:return}},Ray.clone=function(e,t){if(defined(e))return defined(t)?(t.origin=Cartesian3.clone(e.origin),t.direction=Cartesian3.clone(e.direction),t):new Ray(e.origin,e.direction)},Ray.getPoint=function(e,t,i){return defined(i)||(i=new Cartesian3),i=Cartesian3.multiplyByScalar(e.direction,t,i),Cartesian3.add(e.origin,i,i)};var IntersectionTests={rayPlane:function(e,t,i){defined(i)||(i=new Cartesian3);var r=e.origin,n=e.direction,a=t.normal,e=Cartesian3.dot(a,n);if(!(Math.abs(e)<CesiumMath.EPSILON15)){e=(-t.distance-Cartesian3.dot(a,r))/e;if(!(e<0))return i=Cartesian3.multiplyByScalar(n,e,i),Cartesian3.add(r,i,i)}}},scratchEdge0=new Cartesian3,scratchEdge1=new Cartesian3,scratchPVec=new Cartesian3,scratchTVec=new Cartesian3,scratchQVec=new Cartesian3;IntersectionTests.rayTriangleParametric=function(e,t,i,r,n){n=defaultValue(n,!1);var a,o,s,l=e.origin,c=e.direction,u=Cartesian3.subtract(i,t,scratchEdge0),e=Cartesian3.subtract(r,t,scratchEdge1),i=Cartesian3.cross(c,e,scratchPVec),r=Cartesian3.dot(u,i);if(n){if(r<CesiumMath.EPSILON6)return;if(h=Cartesian3.subtract(l,t,scratchTVec),(d=Cartesian3.dot(h,i))<0||r<d)return;if(a=Cartesian3.cross(h,u,scratchQVec),(o=Cartesian3.dot(c,a))<0||r<d+o)return;s=Cartesian3.dot(e,a)/r}else{if(Math.abs(r)<CesiumMath.EPSILON6)return;var d,r=1/r,h=Cartesian3.subtract(l,t,scratchTVec);if((d=Cartesian3.dot(h,i)*r)<0||1<d)return;if(a=Cartesian3.cross(h,u,scratchQVec),(o=Cartesian3.dot(c,a)*r)<0||1<d+o)return;s=Cartesian3.dot(e,a)*r}return s},IntersectionTests.rayTriangle=function(e,t,i,r,n,a){n=IntersectionTests.rayTriangleParametric(e,t,i,r,n);if(defined(n)&&!(n<0))return defined(a)||(a=new Cartesian3),Cartesian3.multiplyByScalar(e.direction,n,a),Cartesian3.add(e.origin,a,a)};var scratchLineSegmentTriangleRay=new Ray;function solveQuadratic(e,t,i,r){var n=t*t-4*e*i;if(!(n<0)){if(0<n){var a=1/(2*e),i=Math.sqrt(n),n=(-t+i)*a,a=(-t-i)*a;return n<a?(r.root0=n,r.root1=a):(r.root0=a,r.root1=n),r}e=-t/(2*e);if(0!=e)return r.root0=r.root1=e,r}}IntersectionTests.lineSegmentTriangle=function(e,t,i,r,n,a,o){var s=scratchLineSegmentTriangleRay;Cartesian3.clone(e,s.origin),Cartesian3.subtract(t,e,s.direction),Cartesian3.normalize(s.direction,s.direction);a=IntersectionTests.rayTriangleParametric(s,i,r,n,a);if(!(!defined(a)||a<0||a>Cartesian3.distance(e,t)))return defined(o)||(o=new Cartesian3),Cartesian3.multiplyByScalar(s.direction,a,o),Cartesian3.add(s.origin,o,o)};var raySphereRoots={root0:0,root1:0};function raySphere(e,t,i){defined(i)||(i=new Interval);var r=e.origin,n=e.direction,e=t.center,t=t.radius*t.radius,e=Cartesian3.subtract(r,e,scratchPVec),t=solveQuadratic(Cartesian3.dot(n,n),2*Cartesian3.dot(n,e),Cartesian3.magnitudeSquared(e)-t,raySphereRoots);if(defined(t))return i.start=t.root0,i.stop=t.root1,i}IntersectionTests.raySphere=function(e,t,i){if(defined(i=raySphere(e,t,i))&&!(i.stop<0))return i.start=Math.max(i.start,0),i};var scratchLineSegmentRay=new Ray;IntersectionTests.lineSegmentSphere=function(e,t,i,r){var n=scratchLineSegmentRay;Cartesian3.clone(e,n.origin);t=Cartesian3.subtract(t,e,n.direction),e=Cartesian3.magnitude(t);if(Cartesian3.normalize(t,t),!(!defined(r=raySphere(n,i,r))||r.stop<0||r.start>e))return r.start=Math.max(r.start,0),r.stop=Math.min(r.stop,e),r};var scratchQ=new Cartesian3,scratchW$1=new Cartesian3;function addWithCancellationCheck(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}function quadraticVectorExpression(e,t,i,r,n){var a=r*r,o=n*n,s=(e[Matrix3.COLUMN1ROW1]-e[Matrix3.COLUMN2ROW2])*o,l=n*(r*addWithCancellationCheck(e[Matrix3.COLUMN1ROW0],e[Matrix3.COLUMN0ROW1],CesiumMath.EPSILON15)+t.y),c=e[Matrix3.COLUMN0ROW0]*a+e[Matrix3.COLUMN2ROW2]*o+r*t.x+i,u=o*addWithCancellationCheck(e[Matrix3.COLUMN2ROW1],e[Matrix3.COLUMN1ROW2],CesiumMath.EPSILON15),d=n*(r*addWithCancellationCheck(e[Matrix3.COLUMN2ROW0],e[Matrix3.COLUMN0ROW2])+t.z),h=[];if(0==d&&0==u){if(0===(_=QuadraticRealPolynomial.computeRealRoots(s,l,c)).length)return h;var p=_[0],f=Math.sqrt(Math.max(1-p*p,0));return h.push(new Cartesian3(r,n*p,n*-f)),h.push(new Cartesian3(r,n*p,n*f)),2===_.length&&(m=_[1],g=Math.sqrt(Math.max(1-m*m,0)),h.push(new Cartesian3(r,n*m,n*-g)),h.push(new Cartesian3(r,n*m,n*g))),h}var t=d*d,p=u*u,f=d*u,m=s*s+p,g=2*(l*s+f),p=2*c*s+l*l-p+t,f=2*(c*l-f);if(0==m&&0==g&&0==p&&0==f)return h;var _,y=(_=QuarticRealPolynomial.computeRealRoots(m,g,p,f,c*c-t)).length;if(0===y)return h;for(var C=0;C<y;++C){var v=_[C],T=v*v,S=Math.max(1-T,0),S=Math.sqrt(S),T=CesiumMath.sign(s)===CesiumMath.sign(c)?addWithCancellationCheck(s*T+c,l*v,CesiumMath.EPSILON12):CesiumMath.sign(c)===CesiumMath.sign(l*v)?addWithCancellationCheck(s*T,l*v+c,CesiumMath.EPSILON12):addWithCancellationCheck(s*T+l*v,c,CesiumMath.EPSILON12),T=T*addWithCancellationCheck(u*v,d,CesiumMath.EPSILON15);T<0?h.push(new Cartesian3(r,n*v,n*S)):0<T?h.push(new Cartesian3(r,n*v,n*-S)):0!==S?(h.push(new Cartesian3(r,n*v,n*-S)),h.push(new Cartesian3(r,n*v,n*S)),++C):h.push(new Cartesian3(r,n*v,n*S))}return h}IntersectionTests.rayEllipsoid=function(e,t){var i=t.oneOverRadii,r=Cartesian3.multiplyComponents(i,e.origin,scratchQ),t=Cartesian3.multiplyComponents(i,e.direction,scratchW$1),i=Cartesian3.magnitudeSquared(r),e=Cartesian3.dot(r,t);if(1<i){if(0<=e)return;var n,a,r=e*e,o=i-1;if(r<(a=(n=Cartesian3.magnitudeSquared(t))*o))return;if(a<r){var s,l=e*e-a,c=(s=-e+Math.sqrt(l))/n,r=o/s;return c<r?new Interval(c,r):{start:r,stop:c}}c=Math.sqrt(o/n);return new Interval(c,c)}return i<1?(o=i-1,l=e*e-(a=(n=Cartesian3.magnitudeSquared(t))*o),new Interval(0,(s=-e+Math.sqrt(l))/n)):e<0?new Interval(0,-e/(n=Cartesian3.magnitudeSquared(t))):void 0};var firstAxisScratch=new Cartesian3,secondAxisScratch=new Cartesian3,thirdAxisScratch=new Cartesian3,referenceScratch=new Cartesian3,bCart=new Cartesian3,bScratch=new Matrix3,btScratch=new Matrix3,diScratch=new Matrix3,dScratch$1=new Matrix3,cScratch=new Matrix3,tempMatrix=new Matrix3,aScratch=new Matrix3,sScratch$1=new Cartesian3,closestScratch=new Cartesian3,surfPointScratch=new Cartographic;IntersectionTests.grazingAltitudeLocation=function(e,t){var i=e.origin,r=e.direction;if(!Cartesian3.equals(i,Cartesian3.ZERO)){var n=t.geodeticSurfaceNormal(i,firstAxisScratch);if(0<=Cartesian3.dot(r,n))return i}var a=defined(this.rayEllipsoid(e,t)),o=t.transformPositionToScaledSpace(r,firstAxisScratch),n=Cartesian3.normalize(o,o),e=Cartesian3.mostOrthogonalAxis(o,referenceScratch),o=Cartesian3.normalize(Cartesian3.cross(e,n,secondAxisScratch),secondAxisScratch),e=Cartesian3.normalize(Cartesian3.cross(n,o,thirdAxisScratch),thirdAxisScratch),s=bScratch;s[0]=n.x,s[1]=n.y,s[2]=n.z,s[3]=o.x,s[4]=o.y,s[5]=o.z,s[6]=e.x,s[7]=e.y,s[8]=e.z;var n=Matrix3.transpose(s,btScratch),l=Matrix3.fromScale(t.radii,diScratch),o=Matrix3.fromScale(t.oneOverRadii,dScratch$1),e=cScratch;e[0]=0,e[1]=-r.z,e[2]=r.y,e[3]=r.z,e[4]=0,e[5]=-r.x,e[6]=-r.y,e[7]=r.x,e[8]=0;var o=Matrix3.multiply(Matrix3.multiply(n,o,tempMatrix),e,tempMatrix),e=Matrix3.multiply(Matrix3.multiply(o,l,aScratch),s,aScratch),o=Matrix3.multiplyByVector(o,i,bCart),c=quadraticVectorExpression(e,Cartesian3.negate(o,firstAxisScratch),0,0,1),u=c.length;if(0<u){for(var d=Cartesian3.clone(Cartesian3.ZERO,closestScratch),h=Number.NEGATIVE_INFINITY,p=0;p<u;++p){var f=Matrix3.multiplyByVector(l,Matrix3.multiplyByVector(s,c[p],sScratch$1),sScratch$1),m=Cartesian3.normalize(Cartesian3.subtract(f,i,referenceScratch),referenceScratch),m=Cartesian3.dot(m,r);h<m&&(h=m,d=Cartesian3.clone(f,d))}e=t.cartesianToCartographic(d,surfPointScratch),h=CesiumMath.clamp(h,0,1),o=Cartesian3.magnitude(Cartesian3.subtract(d,i,referenceScratch))*Math.sqrt(1-h*h);return e.height=o=a?-o:o,t.cartographicToCartesian(e,new Cartesian3)}};var lineSegmentPlaneDifference=new Cartesian3;function Plane(e,t){this.normal=Cartesian3.clone(e),this.distance=t}IntersectionTests.lineSegmentPlane=function(e,t,i,r){defined(r)||(r=new Cartesian3);var n=Cartesian3.subtract(t,e,lineSegmentPlaneDifference),a=i.normal,t=Cartesian3.dot(a,n);if(!(Math.abs(t)<CesiumMath.EPSILON6)){a=Cartesian3.dot(a,e),t=-(i.distance+a)/t;if(!(t<0||1<t))return Cartesian3.multiplyByScalar(n,t,r),Cartesian3.add(e,r,r),r}},IntersectionTests.trianglePlaneIntersection=function(e,t,i,r){var n,a,o=r.normal,s=r.distance,l=Cartesian3.dot(o,e)+s<0,c=Cartesian3.dot(o,t)+s<0,o=Cartesian3.dot(o,i)+s<0,s=0;if(s+=l?1:0,s+=c?1:0,1!=(s+=o?1:0)&&2!=s||(n=new Cartesian3,a=new Cartesian3),1==s){if(l)return IntersectionTests.lineSegmentPlane(e,t,r,n),IntersectionTests.lineSegmentPlane(e,i,r,a),{positions:[e,t,i,n,a],indices:[0,3,4,1,2,4,1,4,3]};if(c)return IntersectionTests.lineSegmentPlane(t,i,r,n),IntersectionTests.lineSegmentPlane(t,e,r,a),{positions:[e,t,i,n,a],indices:[1,3,4,2,0,4,2,4,3]};if(o)return IntersectionTests.lineSegmentPlane(i,e,r,n),IntersectionTests.lineSegmentPlane(i,t,r,a),{positions:[e,t,i,n,a],indices:[2,3,4,0,1,4,0,4,3]}}else if(2==s){if(!l)return IntersectionTests.lineSegmentPlane(t,e,r,n),IntersectionTests.lineSegmentPlane(i,e,r,a),{positions:[e,t,i,n,a],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return IntersectionTests.lineSegmentPlane(i,t,r,n),IntersectionTests.lineSegmentPlane(e,t,r,a),{positions:[e,t,i,n,a],indices:[2,0,4,2,4,3,1,3,4]};if(!o)return IntersectionTests.lineSegmentPlane(e,i,r,n),IntersectionTests.lineSegmentPlane(t,i,r,a),{positions:[e,t,i,n,a],indices:[0,1,4,0,4,3,2,3,4]}}},Plane.fromPointNormal=function(e,t,i){e=-Cartesian3.dot(t,e);return defined(i)?(Cartesian3.clone(t,i.normal),i.distance=e,i):new Plane(t,e)};var scratchNormal$7=new Cartesian3;Plane.fromCartesian4=function(e,t){var i=Cartesian3.fromCartesian4(e,scratchNormal$7),e=e.w;return defined(t)?(Cartesian3.clone(i,t.normal),t.distance=e,t):new Plane(i,e)},Plane.getPointDistance=function(e,t){return Cartesian3.dot(e.normal,t)+e.distance};var scratchCartesian$8=new Cartesian3;Plane.projectPointOntoPlane=function(e,t,i){defined(i)||(i=new Cartesian3);var r=Plane.getPointDistance(e,t),r=Cartesian3.multiplyByScalar(e.normal,r,scratchCartesian$8);return Cartesian3.subtract(t,r,i)};var scratchInverseTranspose=new Matrix4,scratchPlaneCartesian4=new Cartesian4,scratchTransformNormal=new Cartesian3;function binarySearch(e,t,i){for(var r,n,a=0,o=e.length-1;a<=o;)if((n=i(e[r=~~((a+o)/2)],t))<0)a=1+r;else{if(!(0<n))return r;o=r-1}return~(o+1)}function EarthOrientationParametersSample(e,t,i,r,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=i,this.yPoleOffset=r,this.ut1MinusUtc=n}function GregorianDate(e,t,i,r,n,a,o,s){this.year=e,this.month=t,this.day=i,this.hour=r,this.minute=n,this.second=a,this.millisecond=o,this.isLeapSecond=s}function isLeapYear(e){return e%4==0&&e%100!=0||e%400==0}function LeapSecond(e,t){this.julianDate=e,this.offset=t}Plane.transform=function(e,t,i){var r=e.normal,e=e.distance,t=Matrix4.inverseTranspose(t,scratchInverseTranspose),e=Cartesian4.fromElements(r.x,r.y,r.z,e,scratchPlaneCartesian4),e=Matrix4.multiplyByVector(t,e,e),t=Cartesian3.fromCartesian4(e,scratchTransformNormal);return e=Cartesian4.divideByScalar(e,Cartesian3.magnitude(t),e),Plane.fromCartesian4(e,i)},Plane.clone=function(e,t){return defined(t)?(Cartesian3.clone(e.normal,t.normal),t.distance=e.distance,t):new Plane(e.normal,e.distance)},Plane.equals=function(e,t){return e.distance===t.distance&&Cartesian3.equals(e.normal,t.normal)},Plane.ORIGIN_XY_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Z,0)),Plane.ORIGIN_YZ_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_X,0)),Plane.ORIGIN_ZX_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Y,0));var TimeConstants={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5},TimeConstants$1=Object.freeze(TimeConstants),TimeStandard={UTC:0,TAI:1},TimeStandard$1=Object.freeze(TimeStandard),gregorianDateScratch=new GregorianDate,daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31],daysInLeapFeburary=29;function compareLeapSecondDates$1(e,t){return JulianDate.compare(e.julianDate,t.julianDate)}var binarySearchScratchLeapSecond=new LeapSecond;function convertUtcToTai(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1),r=t[i=(i=i<0?~i:i)>=t.length?t.length-1:i].offset;0<i&&r<JulianDate.secondsDifference(t[i].julianDate,e)&&(r=t[--i].offset),JulianDate.addSeconds(e,r,e)}function convertTaiToUtc(e,t){binarySearchScratchLeapSecond.julianDate=e;var i=JulianDate.leapSeconds,r=binarySearch(i,binarySearchScratchLeapSecond,compareLeapSecondDates$1);if(0===(r=r<0?~r:r))return JulianDate.addSeconds(e,-i[0].offset,t);if(r>=i.length)return JulianDate.addSeconds(e,-i[r-1].offset,t);var n=JulianDate.secondsDifference(i[r].julianDate,e);return 0===n?JulianDate.addSeconds(e,-i[r].offset,t):n<=1?void 0:JulianDate.addSeconds(e,-i[--r].offset,t)}function setComponents(e,t,i){var r=t/TimeConstants$1.SECONDS_PER_DAY|0;return e+=r,(t-=TimeConstants$1.SECONDS_PER_DAY*r)<0&&(e--,t+=TimeConstants$1.SECONDS_PER_DAY),i.dayNumber=e,i.secondsOfDay=t,i}function computeJulianDateComponents(e,t,i,r,n,a,o){var s=(t-14)/12|0,e=e+4800+s,i=(1461*e/4|0)+(367*(t-2-12*s)/12|0)-(3*((e+100)/100|0)/4|0)+i-32075;(r-=12)<0&&(r+=24);o=a+(r*TimeConstants$1.SECONDS_PER_HOUR+n*TimeConstants$1.SECONDS_PER_MINUTE+o*TimeConstants$1.SECONDS_PER_MILLISECOND);return 43200<=o&&--i,[i,o]}var matchCalendarYear=/^(\d{4})$/,matchCalendarMonth=/^(\d{4})-(\d{2})$/,matchOrdinalDate=/^(\d{4})-?(\d{3})$/,matchWeekDate=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,matchCalendarDate=/^(\d{4})-?(\d{2})-?(\d{2})$/,utcOffset=/([Z+\-])?(\d{2})?:?(\d{2})?$/,matchHours=/^(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutes=/^(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutesSeconds=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source;function JulianDate(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,TimeStandard$1.UTC);var r=0|e;setComponents(r,t+=(e-r)*TimeConstants$1.SECONDS_PER_DAY,this),i===TimeStandard$1.UTC&&convertUtcToTai(this)}JulianDate.fromGregorianDate=function(e,t){e=computeJulianDateComponents(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return defined(t)?(setComponents(e[0],e[1],t),convertUtcToTai(t),t):new JulianDate(e[0],e[1],TimeStandard$1.UTC)},JulianDate.fromDate=function(e,t){e=computeJulianDateComponents(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return defined(t)?(setComponents(e[0],e[1],t),convertUtcToTai(t),t):new JulianDate(e[0],e[1],TimeStandard$1.UTC)},JulianDate.fromIso8601=function(e,t){var i,r,n,a,o,s=(e=e.replace(",",".")).split("T"),l=1,c=1,u=0,d=0,h=0,p=0,f=s[0],e=s[1];if(null!==(s=f.match(matchCalendarDate))?(n=+s[1],l=+s[2],c=+s[3]):null!==(s=f.match(matchCalendarMonth))?(n=+s[1],l=+s[2]):null!==(s=f.match(matchCalendarYear))?n=+s[1]:(null!==(s=f.match(matchOrdinalDate))?(n=+s[1],a=+s[2],r=isLeapYear(n)):null!==(s=f.match(matchWeekDate))&&(n=+s[1],a=7*+s[2]+(+s[3]||0)-new Date(Date.UTC(n,0,4)).getUTCDay()-3),(i=new Date(Date.UTC(n,0,1))).setUTCDate(a),l=i.getUTCMonth()+1,c=i.getUTCDate()),r=isLeapYear(n),defined(e)){null!==(s=e.match(matchHoursMinutesSeconds))?(u=+s[1],d=+s[2],h=+s[3],p=1e3*+(s[4]||0),o=5):null!==(s=e.match(matchHoursMinutes))?(u=+s[1],d=+s[2],h=60*+(s[3]||0),o=4):null!==(s=e.match(matchHours))&&(u=+s[1],d=60*+(s[2]||0),o=3);var m=s[o],g=+s[o+1],_=+(s[o+2]||0);switch(m){case"+":u-=g,d-=_;break;case"-":u+=g,d+=_;break;case"Z":break;default:d+=new Date(Date.UTC(n,l-1,c,u,d)).getTimezoneOffset()}}m=60===h;for(m&&h--;60<=d;)d-=60,u++;for(;24<=u;)u-=24,c++;for(i=r&&2===l?daysInLeapFeburary:daysInMonth[l-1];i<c;)c-=i,12<++l&&(l-=12,n++),i=r&&2===l?daysInLeapFeburary:daysInMonth[l-1];for(;d<0;)d+=60,u--;for(;u<0;)u+=24,c--;for(;c<1;)--l<1&&(l+=12,n--),c+=i=r&&2===l?daysInLeapFeburary:daysInMonth[l-1];p=computeJulianDateComponents(n,l,c,u,d,h,p);return defined(t)?(setComponents(p[0],p[1],t),convertUtcToTai(t)):t=new JulianDate(p[0],p[1],TimeStandard$1.UTC),m&&JulianDate.addSeconds(t,1,t),t},JulianDate.now=function(e){return JulianDate.fromDate(new Date,e)};var toGregorianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI);function EarthOrientationParameters(e){var t,i;e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=defaultValue(e.addNewLeapSeconds,!0),defined(e.data)?onDataReady(this,e.data):defined(e.url)?(t=Resource.createIfNeeded(e.url),(i=this)._downloadPromise=t.fetchJson().then(function(e){onDataReady(i,e)}).otherwise(function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})):onDataReady(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function compareLeapSecondDates(e,t){return JulianDate.compare(e.julianDate,t)}function onDataReady(e,t){if(defined(t.columnNames))if(defined(t.samples)){var i=t.columnNames.indexOf("modifiedJulianDateUtc"),r=t.columnNames.indexOf("xPoleWanderRadians"),n=t.columnNames.indexOf("yPoleWanderRadians"),a=t.columnNames.indexOf("ut1MinusUtcSeconds"),o=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),s=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),l=t.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||r<0||n<0||a<0||o<0||s<0||l<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var c,u=e._samples=t.samples,d=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=r,e._yPoleWanderRadiansColumn=n,e._ut1MinusUtcSecondsColumn=a,e._xCelestialPoleOffsetRadiansColumn=o,e._yCelestialPoleOffsetRadiansColumn=s,e._taiMinusUtcSecondsColumn=l,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var h=e._addNewLeapSeconds,p=0,f=u.length;p<f;p+=e._columnCount){var m,g=u[p+i],_=u[p+l],y=new JulianDate(g+TimeConstants$1.MODIFIED_JULIAN_DATE_DIFFERENCE,_,TimeStandard$1.TAI);d.push(y),h&&(_===c||!defined(c)||(g=binarySearch(m=JulianDate.leapSeconds,y,compareLeapSecondDates))<0&&(y=new LeapSecond(y,_),m.splice(~g,0,y)),c=_)}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function fillResultFromIndex(e,t,i,r,n){r*=i;n.xPoleWander=t[r+e._xPoleWanderRadiansColumn],n.yPoleWander=t[r+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[r+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[r+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[r+e._ut1MinusUtcSecondsColumn]}function linearInterp(e,t,i){return t+e*(i-t)}function interpolate(e,t,i,r,n,a,o){var s=e._columnCount;if(a>t.length-1)return o.xPoleWander=0,o.yPoleWander=0,o.xPoleOffset=0,o.yPoleOffset=0,o.ut1MinusUtc=0,o;var l=t[n],c=t[a];if(l.equals(c)||r.equals(l))return fillResultFromIndex(e,i,n,s,o),o;if(r.equals(c))return fillResultFromIndex(e,i,a,s,o),o;var u=JulianDate.secondsDifference(r,l)/JulianDate.secondsDifference(c,l),d=n*s,t=a*s,l=i[d+e._ut1MinusUtcSecondsColumn],n=i[t+e._ut1MinusUtcSecondsColumn],a=n-l;return!(.5<a||a<-.5)||(s=i[d+e._taiMinusUtcSecondsColumn])!==(a=i[t+e._taiMinusUtcSecondsColumn])&&(c.equals(r)?l=n:n-=a-s),o.xPoleWander=linearInterp(u,i[d+e._xPoleWanderRadiansColumn],i[t+e._xPoleWanderRadiansColumn]),o.yPoleWander=linearInterp(u,i[d+e._yPoleWanderRadiansColumn],i[t+e._yPoleWanderRadiansColumn]),o.xPoleOffset=linearInterp(u,i[d+e._xCelestialPoleOffsetRadiansColumn],i[t+e._xCelestialPoleOffsetRadiansColumn]),o.yPoleOffset=linearInterp(u,i[d+e._yCelestialPoleOffsetRadiansColumn],i[t+e._yCelestialPoleOffsetRadiansColumn]),o.ut1MinusUtc=linearInterp(u,l,n),o}function HeadingPitchRoll(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.roll=defaultValue(i,0)}function Iau2006XysSample(e,t,i){this.x=e,this.y=t,this.s=i}function Iau2006XysData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=Resource.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new JulianDate(this._sampleZeroJulianEphemerisDate,0,TimeStandard$1.TAI),this._stepSizeDays=defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),n=Math.pow(this._stepSizeDays,t),a=0;a<=t;++a){i[a]=n,r[a]=a*this._stepSizeDays;for(var o=0;o<=t;++o)o!==a&&(i[a]*=a-o);i[a]=1/i[a]}this._work=new Array(t+1),this._coef=new Array(t+1)}JulianDate.toGregorianDate=function(e,t){var i=!1,r=convertTaiToUtc(e,toGregorianDateScratch);defined(r)||(JulianDate.addSeconds(e,-1,toGregorianDateScratch),r=convertTaiToUtc(toGregorianDateScratch,toGregorianDateScratch),i=!0);var n=r.dayNumber,a=r.secondsOfDay;43200<=a&&(n+=1);var o=n+68569|0,s=4*o/146097|0,l=4e3*(1+(o=o-((146097*s+3)/4|0)|0))/1461001|0,e=80*(o=o-(1461*l/4|0)+31|0)/2447|0,r=o-(2447*e/80|0)|0,n=2+e-12*(o=e/11|0)|0,e=100*(s-49)+l+o|0,s=a/TimeConstants$1.SECONDS_PER_HOUR|0,l=a-s*TimeConstants$1.SECONDS_PER_HOUR,o=l/TimeConstants$1.SECONDS_PER_MINUTE|0,a=0|(l-=o*TimeConstants$1.SECONDS_PER_MINUTE),l=(l-a)/TimeConstants$1.SECONDS_PER_MILLISECOND;return 23<(s+=12)&&(s-=24),i&&(a+=1),defined(t)?(t.year=e,t.month=n,t.day=r,t.hour=s,t.minute=o,t.second=a,t.millisecond=l,t.isLeapSecond=i,t):new GregorianDate(e,n,r,s,o,a,l,i)},JulianDate.toDate=function(e){var t=JulianDate.toGregorianDate(e,gregorianDateScratch),e=t.second;return t.isLeapSecond&&--e,new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,e,t.millisecond))},JulianDate.toIso8601=function(e,t){var i,r=JulianDate.toGregorianDate(e,gregorianDateScratch),n=r.year,a=r.month,o=r.day,s=r.hour,l=r.minute,e=r.second,r=r.millisecond;return 1e4===n&&1===a&&1===o&&0===s&&0===l&&0===e&&0===r&&(n=9999,a=12,o=31,s=24),defined(t)||0===r?defined(t)&&0!==t?(i=(.01*r).toFixed(t).replace(".","").slice(0,t),n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+e.toString().padStart(2,"0")+"."+i+"Z"):n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+e.toString().padStart(2,"0")+"Z":(i=(.01*r).toString().replace(".",""),n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+e.toString().padStart(2,"0")+"."+i+"Z")},JulianDate.clone=function(e,t){if(defined(e))return defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new JulianDate(e.dayNumber,e.secondsOfDay,TimeStandard$1.TAI)},JulianDate.compare=function(e,t){var i=e.dayNumber-t.dayNumber;return 0!=i?i:e.secondsOfDay-t.secondsOfDay},JulianDate.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},JulianDate.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(JulianDate.secondsDifference(e,t))<=i},JulianDate.totalDays=function(e){return e.dayNumber+e.secondsOfDay/TimeConstants$1.SECONDS_PER_DAY},JulianDate.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*TimeConstants$1.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},JulianDate.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY},JulianDate.computeTaiMinusUtc=function(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,e=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1);return e<0&&(e=~e,--e<0&&(e=0)),t[e].offset},JulianDate.addSeconds=function(e,t,i){return setComponents(e.dayNumber,e.secondsOfDay+t,i)},JulianDate.addMinutes=function(e,t,i){t=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_MINUTE;return setComponents(e.dayNumber,t,i)},JulianDate.addHours=function(e,t,i){t=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_HOUR;return setComponents(e.dayNumber,t,i)},JulianDate.addDays=function(e,t,i){return setComponents(e.dayNumber+t,e.secondsOfDay,i)},JulianDate.lessThan=function(e,t){return JulianDate.compare(e,t)<0},JulianDate.lessThanOrEquals=function(e,t){return JulianDate.compare(e,t)<=0},JulianDate.greaterThan=function(e,t){return 0<JulianDate.compare(e,t)},JulianDate.greaterThanOrEquals=function(e,t){return 0<=JulianDate.compare(e,t)},JulianDate.prototype.clone=function(e){return JulianDate.clone(this,e)},JulianDate.prototype.equals=function(e){return JulianDate.equals(this,e)},JulianDate.prototype.equalsEpsilon=function(e,t){return JulianDate.equalsEpsilon(this,e,t)},JulianDate.prototype.toString=function(){return JulianDate.toIso8601(this)},JulianDate.leapSeconds=[new LeapSecond(new JulianDate(2441317,43210,TimeStandard$1.TAI),10),new LeapSecond(new JulianDate(2441499,43211,TimeStandard$1.TAI),11),new LeapSecond(new JulianDate(2441683,43212,TimeStandard$1.TAI),12),new LeapSecond(new JulianDate(2442048,43213,TimeStandard$1.TAI),13),new LeapSecond(new JulianDate(2442413,43214,TimeStandard$1.TAI),14),new LeapSecond(new JulianDate(2442778,43215,TimeStandard$1.TAI),15),new LeapSecond(new JulianDate(2443144,43216,TimeStandard$1.TAI),16),new LeapSecond(new JulianDate(2443509,43217,TimeStandard$1.TAI),17),new LeapSecond(new JulianDate(2443874,43218,TimeStandard$1.TAI),18),new LeapSecond(new JulianDate(2444239,43219,TimeStandard$1.TAI),19),new LeapSecond(new JulianDate(2444786,43220,TimeStandard$1.TAI),20),new LeapSecond(new JulianDate(2445151,43221,TimeStandard$1.TAI),21),new LeapSecond(new JulianDate(2445516,43222,TimeStandard$1.TAI),22),new LeapSecond(new JulianDate(2446247,43223,TimeStandard$1.TAI),23),new LeapSecond(new JulianDate(2447161,43224,TimeStandard$1.TAI),24),new LeapSecond(new JulianDate(2447892,43225,TimeStandard$1.TAI),25),new LeapSecond(new JulianDate(2448257,43226,TimeStandard$1.TAI),26),new LeapSecond(new JulianDate(2448804,43227,TimeStandard$1.TAI),27),new LeapSecond(new JulianDate(2449169,43228,TimeStandard$1.TAI),28),new LeapSecond(new JulianDate(2449534,43229,TimeStandard$1.TAI),29),new LeapSecond(new JulianDate(2450083,43230,TimeStandard$1.TAI),30),new LeapSecond(new JulianDate(2450630,43231,TimeStandard$1.TAI),31),new LeapSecond(new JulianDate(2451179,43232,TimeStandard$1.TAI),32),new LeapSecond(new JulianDate(2453736,43233,TimeStandard$1.TAI),33),new LeapSecond(new JulianDate(2454832,43234,TimeStandard$1.TAI),34),new LeapSecond(new JulianDate(2456109,43235,TimeStandard$1.TAI),35),new LeapSecond(new JulianDate(2457204,43236,TimeStandard$1.TAI),36),new LeapSecond(new JulianDate(2457754,43237,TimeStandard$1.TAI),37)],EarthOrientationParameters.NONE=Object.freeze({getPromiseToLoad:function(){return when.resolve()},compute:function(e,t){return defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new EarthOrientationParametersSample(0,0,0,0,0),t}}),EarthOrientationParameters.prototype.getPromiseToLoad=function(){return when(this._downloadPromise)},EarthOrientationParameters.prototype.compute=function(e,t){if(defined(this._samples)){if(defined(t)||(t=new EarthOrientationParametersSample(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var i=this._dates,r=this._lastIndex,n=0,a=0;if(defined(r)){var o=i[r],s=i[r+1],l=JulianDate.lessThanOrEquals(o,e),c=!defined(s),o=c||JulianDate.greaterThanOrEquals(s,e);if(l&&o)return n=r,!c&&s.equals(e)&&++n,interpolate(this,i,this._samples,e,n,a=n+1,t),t}s=binarySearch(i,e,JulianDate.compare,this._dateColumn);return 0<=s?(s<i.length-1&&i[s+1].equals(e)&&++s,a=n=s):(n=(a=~s)-1)<0&&(n=0),this._lastIndex=n,interpolate(this,i,this._samples,e,n,a,t),t}if(defined(this._dataError))throw new RuntimeError(this._dataError)},HeadingPitchRoll.fromQuaternion=function(e,t){defined(t)||(t=new HeadingPitchRoll);var i=2*(e.w*e.y-e.z*e.x),r=1-2*(e.x*e.x+e.y*e.y),n=2*(e.w*e.x+e.y*e.z),a=1-2*(e.y*e.y+e.z*e.z),e=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(e,a),t.roll=Math.atan2(n,r),t.pitch=-CesiumMath.asinClamped(i),t},HeadingPitchRoll.fromDegrees=function(e,t,i,r){return(r=!defined(r)?new HeadingPitchRoll:r).heading=e*CesiumMath.RADIANS_PER_DEGREE,r.pitch=t*CesiumMath.RADIANS_PER_DEGREE,r.roll=i*CesiumMath.RADIANS_PER_DEGREE,r},HeadingPitchRoll.clone=function(e,t){if(defined(e))return defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new HeadingPitchRoll(e.heading,e.pitch,e.roll)},HeadingPitchRoll.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},HeadingPitchRoll.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.heading,t.heading,i,r)&&CesiumMath.equalsEpsilon(e.pitch,t.pitch,i,r)&&CesiumMath.equalsEpsilon(e.roll,t.roll,i,r)},HeadingPitchRoll.prototype.clone=function(e){return HeadingPitchRoll.clone(this,e)},HeadingPitchRoll.prototype.equals=function(e){return HeadingPitchRoll.equals(this,e)},HeadingPitchRoll.prototype.equalsEpsilon=function(e,t,i){return HeadingPitchRoll.equalsEpsilon(this,e,t,i)},HeadingPitchRoll.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};var julianDateScratch$1=new JulianDate(0,0,TimeStandard$1.TAI),_supportsFullscreen;function getDaysSinceEpoch(e,t,i){var r=julianDateScratch$1;return r.dayNumber=t,r.secondsOfDay=i,JulianDate.daysDifference(r,e._sampleZeroDateTT)}function requestXysChunk(o,s){if(o._chunkDownloadsInProgress[s])return o._chunkDownloadsInProgress[s];var l=when.defer();o._chunkDownloadsInProgress[s]=l;var e=o._xysFileUrlTemplate,e=defined(e)?e.getDerivedResource({templateValues:{0:s}}):new Resource({url:buildModuleUrl("Assets/IAU2006_XYS/IAU2006_XYS_"+s+".json")});return when(e.fetchJson(),function(e){o._chunkDownloadsInProgress[s]=!1;for(var t=o._samples,i=e.samples,r=s*o._samplesPerXysFile*3,n=0,a=i.length;n<a;++n)t[r+n]=i[n];l.resolve()}),l.promise}Iau2006XysData.prototype.preload=function(e,t,i,r){t=getDaysSinceEpoch(this,e,t),r=getDaysSinceEpoch(this,i,r),t=t/this._stepSizeDays-this._interpolationOrder/2|0,r=r/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;r>=this._totalSamples&&(r=this._totalSamples-1);for(var t=(t=t<0?0:t)/this._samplesPerXysFile|0,n=r/this._samplesPerXysFile|0,a=[],o=t;o<=n;++o)a.push(requestXysChunk(this,o));return when.all(a)},Iau2006XysData.prototype.computeXysRadians=function(e,t,i){var r=getDaysSinceEpoch(this,e,t);if(!(r<0)){e=r/this._stepSizeDays|0;if(!(e>=this._totalSamples)){var n=this._interpolationOrder,a=e-(n/2|0),t=(a=a<0?0:a)+n;t>=this._totalSamples&&(a=(t=this._totalSamples-1)-n)<0&&(a=0);var e=!1,o=this._samples;if(defined(o[3*a])||(requestXysChunk(this,a/this._samplesPerXysFile|0),e=!0),defined(o[3*t])||(requestXysChunk(this,t/this._samplesPerXysFile|0),e=!0),!e){defined(i)?(i.x=0,i.y=0,i.s=0):i=new Iau2006XysSample(0,0,0);for(var s,l=r-a*this._stepSizeDays,c=this._work,u=this._denominators,d=this._coef,h=this._xTable,p=0;p<=n;++p)c[p]=l-h[p];for(p=0;p<=n;++p){for(d[p]=1,s=0;s<=n;++s)s!==p&&(d[p]*=c[s]);d[p]*=u[p];var f=3*(a+p);i.x+=d[p]*o[f++],i.y+=d[p]*o[f++],i.s+=d[p]*o[f]}return i}}}};var _names={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Fullscreen={},theNavigator,isChromeResult,chromeVersionResult,isSafariResult,safariVersionResult,isWebkitResult,webkitVersionResult,isInternetExplorerResult,internetExplorerVersionResult,isEdgeResult,edgeVersionResult,isFirefoxResult,firefoxVersionResult,isWindowsResult,hasPointerEvents,imageRenderingValueResult,supportsImageRenderingPixelatedResult;function extractVersion(e){for(var t=e.split("."),i=0,r=t.length;i<r;++i)t[i]=parseInt(t[i],10);return t}function isChrome(){var e;return defined(isChromeResult)||(isChromeResult=!1,isEdge()||null!==(e=/ Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isChromeResult=!0,chromeVersionResult=extractVersion(e[1]))),isChromeResult}function chromeVersion(){return isChrome()&&chromeVersionResult}function isSafari(){var e;return defined(isSafariResult)||(isSafariResult=!1,isChrome()||isEdge()||!/ Safari\/[\.0-9]+/.test(theNavigator.userAgent)||null!==(e=/ Version\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isSafariResult=!0,safariVersionResult=extractVersion(e[1]))),isSafariResult}function safariVersion(){return isSafari()&&safariVersionResult}function isWebkit(){var e;return defined(isWebkitResult)||(isWebkitResult=!1,null!==(e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent))&&(isWebkitResult=!0,(webkitVersionResult=extractVersion(e[1])).isNightly=!!e[2])),isWebkitResult}function webkitVersion(){return isWebkit()&&webkitVersionResult}function isInternetExplorer(){var e;return defined(isInternetExplorerResult)||(isInternetExplorerResult=!1,"Microsoft Internet Explorer"===theNavigator.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])):"Netscape"===theNavigator.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1]))),isInternetExplorerResult}function internetExplorerVersion(){return isInternetExplorer()&&internetExplorerVersionResult}function isEdge(){var e;return defined(isEdgeResult)||(isEdgeResult=!1,null!==(e=/ Edge\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isEdgeResult=!0,edgeVersionResult=extractVersion(e[1]))),isEdgeResult}function edgeVersion(){return isEdge()&&edgeVersionResult}function isFirefox(){var e;return defined(isFirefoxResult)||(isFirefoxResult=!1,null!==(e=/Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isFirefoxResult=!0,firefoxVersionResult=extractVersion(e[1]))),isFirefoxResult}function isWindows(){return isWindowsResult=!defined(isWindowsResult)?/Windows/i.test(theNavigator.appVersion):isWindowsResult}function firefoxVersion(){return isFirefox()&&firefoxVersionResult}function supportsPointerEvents(){return hasPointerEvents=!defined(hasPointerEvents)?!isFirefox()&&"undefined"!=typeof PointerEvent&&(!defined(theNavigator.pointerEnabled)||theNavigator.pointerEnabled):hasPointerEvents}function supportsImageRenderingPixelated(){var e;return defined(supportsImageRenderingPixelatedResult)||((e=document.createElement("canvas")).setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;"),e=e.style.imageRendering,(supportsImageRenderingPixelatedResult=defined(e)&&""!==e)&&(imageRenderingValueResult=e)),supportsImageRenderingPixelatedResult}function imageRenderingValue(){return supportsImageRenderingPixelated()?imageRenderingValueResult:void 0}function supportsWebP(){return supportsWebP._result}Object.defineProperties(Fullscreen,{element:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenElement]}},changeEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenchange}},errorEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenerror}},enabled:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenEnabled]}},fullscreen:{get:function(){if(Fullscreen.supportsFullscreen())return null!==Fullscreen.element}}}),Fullscreen.supportsFullscreen=function(){if(defined(_supportsFullscreen))return _supportsFullscreen;_supportsFullscreen=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return _names.requestFullscreen="requestFullscreen",_names.exitFullscreen="exitFullscreen",_names.fullscreenEnabled="fullscreenEnabled",_names.fullscreenElement="fullscreenElement",_names.fullscreenchange="fullscreenchange",_names.fullscreenerror="fullscreenerror",_supportsFullscreen=!0;for(var t=["webkit","moz","o","ms","khtml"],i=0,r=t.length;i<r;++i){var n,a=t[i];"function"!=typeof e[n=a+"RequestFullscreen"]&&"function"!=typeof e[n=a+"RequestFullScreen"]||(_names.requestFullscreen=n,_supportsFullscreen=!0),n=a+"ExitFullscreen","function"==typeof document[n]?_names.exitFullscreen=n:(n=a+"CancelFullScreen","function"==typeof document[n]&&(_names.exitFullscreen=n)),n=a+"FullscreenEnabled",void 0!==document[n]?_names.fullscreenEnabled=n:(n=a+"FullScreenEnabled",void 0!==document[n]&&(_names.fullscreenEnabled=n)),n=a+"FullscreenElement",void 0!==document[n]?_names.fullscreenElement=n:(n=a+"FullScreenElement",void 0!==document[n]&&(_names.fullscreenElement=n)),n=a+"fullscreenchange",void 0!==document["on"+n]&&(_names.fullscreenchange=n="ms"===a?"MSFullscreenChange":n),n=a+"fullscreenerror",void 0!==document["on"+n]&&(_names.fullscreenerror=n="ms"===a?"MSFullscreenError":n)}return _supportsFullscreen},Fullscreen.requestFullscreen=function(e,t){Fullscreen.supportsFullscreen()&&e[_names.requestFullscreen]({vrDisplay:t})},Fullscreen.exitFullscreen=function(){Fullscreen.supportsFullscreen()&&document[_names.exitFullscreen]()},Fullscreen._names=_names,theNavigator="undefined"!=typeof navigator?navigator:{},supportsWebP._promise=void 0,supportsWebP._result=void 0,supportsWebP.initialize=function(){if(defined(supportsWebP._promise))return supportsWebP._promise;var e=when.defer();if(supportsWebP._promise=e.promise,isEdge())return supportsWebP._result=!1,e.resolve(supportsWebP._result),e.promise;var t=new Image;return t.onload=function(){supportsWebP._result=0<t.width&&0<t.height,e.resolve(supportsWebP._result)},t.onerror=function(){supportsWebP._result=!1,e.resolve(supportsWebP._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},Object.defineProperties(supportsWebP,{initialized:{get:function(){return defined(supportsWebP._result)}}});var typedArrayTypes=[];"undefined"!=typeof ArrayBuffer&&(typedArrayTypes.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof BigInt64Array&&typedArrayTypes.push(BigInt64Array),"undefined"!=typeof BigUint64Array&&typedArrayTypes.push(BigUint64Array));var FeatureDetection={isChrome:isChrome,chromeVersion:chromeVersion,isSafari:isSafari,safariVersion:safariVersion,isWebkit:isWebkit,webkitVersion:webkitVersion,isInternetExplorer:isInternetExplorer,internetExplorerVersion:internetExplorerVersion,isEdge:isEdge,edgeVersion:edgeVersion,isFirefox:isFirefox,firefoxVersion:firefoxVersion,isWindows:isWindows,hardwareConcurrency:defaultValue(theNavigator.hardwareConcurrency,3),supportsPointerEvents:supportsPointerEvents,supportsImageRenderingPixelated:supportsImageRenderingPixelated,supportsWebP:supportsWebP,imageRenderingValue:imageRenderingValue,typedArrayTypes:typedArrayTypes};function Quaternion(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}FeatureDetection.supportsBasis=function(e){return FeatureDetection.supportsWebAssembly()&&e.context.supportsBasis},FeatureDetection.supportsFullscreen=function(){return Fullscreen.supportsFullscreen()},FeatureDetection.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},FeatureDetection.supportsBigInt64Array=function(){return"undefined"!=typeof BigInt64Array},FeatureDetection.supportsBigUint64Array=function(){return"undefined"!=typeof BigUint64Array},FeatureDetection.supportsBigInt=function(){return"undefined"!=typeof BigInt},FeatureDetection.supportsWebWorkers=function(){return"undefined"!=typeof Worker},FeatureDetection.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!FeatureDetection.isEdge()};var fromAxisAngleScratch=new Cartesian3;Quaternion.fromAxisAngle=function(e,t,i){var r=t/2,n=Math.sin(r),t=(fromAxisAngleScratch=Cartesian3.normalize(e,fromAxisAngleScratch)).x*n,e=fromAxisAngleScratch.y*n,n=fromAxisAngleScratch.z*n,r=Math.cos(r);return defined(i)?(i.x=t,i.y=e,i.z=n,i.w=r,i):new Quaternion(t,e,n,r)};var fromRotationMatrixNext=[1,2,0],fromRotationMatrixQuat=new Array(3);Quaternion.fromRotationMatrix=function(e,t){var i,r,n,a,o=e[Matrix3.COLUMN0ROW0],s=e[Matrix3.COLUMN1ROW1],l=e[Matrix3.COLUMN2ROW2],c=o+s+l,u=0<c?(n=.5*(a=Math.sqrt(c+1)),i=(e[Matrix3.COLUMN1ROW2]-e[Matrix3.COLUMN2ROW1])*(a=.5/a),r=(e[Matrix3.COLUMN2ROW0]-e[Matrix3.COLUMN0ROW2])*a,(e[Matrix3.COLUMN0ROW1]-e[Matrix3.COLUMN1ROW0])*a):(o=fromRotationMatrixNext[l=o<l&&s<l?2:o<s?1:0],s=fromRotationMatrixNext[o],a=Math.sqrt(e[Matrix3.getElementIndex(l,l)]-e[Matrix3.getElementIndex(o,o)]-e[Matrix3.getElementIndex(s,s)]+1),(u=fromRotationMatrixQuat)[l]=.5*a,a=.5/a,n=(e[Matrix3.getElementIndex(s,o)]-e[Matrix3.getElementIndex(o,s)])*a,u[o]=(e[Matrix3.getElementIndex(o,l)]+e[Matrix3.getElementIndex(l,o)])*a,u[s]=(e[Matrix3.getElementIndex(s,l)]+e[Matrix3.getElementIndex(l,s)])*a,i=-u[0],r=-u[1],-u[2]);return defined(t)?(t.x=i,t.y=r,t.z=u,t.w=n,t):new Quaternion(i,r,u,n)};var scratchHPRQuaternion$1=new Quaternion,scratchHeadingQuaternion=new Quaternion,scratchPitchQuaternion=new Quaternion,scratchRollQuaternion=new Quaternion;Quaternion.fromHeadingPitchRoll=function(e,t){return scratchRollQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_X,e.roll,scratchHPRQuaternion$1),scratchPitchQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Y,-e.pitch,t),t=Quaternion.multiply(scratchPitchQuaternion,scratchRollQuaternion,scratchPitchQuaternion),scratchHeadingQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-e.heading,scratchHPRQuaternion$1),Quaternion.multiply(scratchHeadingQuaternion,t,t)};var sampledQuaternionAxis=new Cartesian3,sampledQuaternionRotation=new Cartesian3,sampledQuaternionTempQuaternion=new Quaternion,sampledQuaternionQuaternion0=new Quaternion,sampledQuaternionQuaternion0Conjugate=new Quaternion;Quaternion.packedLength=4,Quaternion.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Quaternion.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Quaternion:i).x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3],i},Quaternion.packedInterpolationLength=3,Quaternion.convertPackedArrayForInterpolation=function(e,t,i,r){Quaternion.unpack(e,4*i,sampledQuaternionQuaternion0Conjugate),Quaternion.conjugate(sampledQuaternionQuaternion0Conjugate,sampledQuaternionQuaternion0Conjugate);for(var n=0,a=i-t+1;n<a;n++){var o=3*n;Quaternion.unpack(e,4*(t+n),sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0Conjugate,sampledQuaternionTempQuaternion),sampledQuaternionTempQuaternion.w<0&&Quaternion.negate(sampledQuaternionTempQuaternion,sampledQuaternionTempQuaternion),Quaternion.computeAxis(sampledQuaternionTempQuaternion,sampledQuaternionAxis);var s=Quaternion.computeAngle(sampledQuaternionTempQuaternion);(r=!defined(r)?[]:r)[o]=sampledQuaternionAxis.x*s,r[1+o]=sampledQuaternionAxis.y*s,r[2+o]=sampledQuaternionAxis.z*s}},Quaternion.unpackInterpolationResult=function(e,t,i,r,n){defined(n)||(n=new Quaternion),Cartesian3.fromArray(e,0,sampledQuaternionRotation);e=Cartesian3.magnitude(sampledQuaternionRotation);return Quaternion.unpack(t,4*r,sampledQuaternionQuaternion0),0===e?Quaternion.clone(Quaternion.IDENTITY,sampledQuaternionTempQuaternion):Quaternion.fromAxisAngle(sampledQuaternionRotation,e,sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0,n)},Quaternion.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Quaternion(e.x,e.y,e.z,e.w)},Quaternion.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},Quaternion.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Quaternion.magnitude=function(e){return Math.sqrt(Quaternion.magnitudeSquared(e))},Quaternion.normalize=function(e,t){var i=1/Quaternion.magnitude(e),r=e.x*i,n=e.y*i,a=e.z*i,i=e.w*i;return t.x=r,t.y=n,t.z=a,t.w=i,t},Quaternion.inverse=function(e,t){var i=Quaternion.magnitudeSquared(e);return t=Quaternion.conjugate(e,t),Quaternion.multiplyByScalar(t,1/i,t)},Quaternion.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Quaternion.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Quaternion.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Quaternion.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Quaternion.multiply=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=e.w,s=t.x,l=t.y,c=t.z,u=t.w,d=o*l-r*c+n*u+a*s,e=o*c+r*l-n*s+a*u,t=o*u-r*s-n*l-a*c;return i.x=o*s+r*u+n*c-a*l,i.y=d,i.z=e,i.w=t,i},Quaternion.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Quaternion.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Quaternion.computeAxis=function(e,t){var i=e.w;if(Math.abs(i-1)<CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;i=1/Math.sqrt(1-i*i);return t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t},Quaternion.computeAngle=function(e){return Math.abs(e.w-1)<CesiumMath.EPSILON6?0:2*Math.acos(e.w)};var lerpScratch=new Quaternion;Quaternion.lerp=function(e,t,i,r){return lerpScratch=Quaternion.multiplyByScalar(t,i,lerpScratch),r=Quaternion.multiplyByScalar(e,1-i,r),Quaternion.add(lerpScratch,r,r)};var slerpEndNegated=new Quaternion,slerpScaledP=new Quaternion,slerpScaledR=new Quaternion;Quaternion.slerp=function(e,t,i,r){var n=Quaternion.dot(e,t),a=t;if(n<0&&(n=-n,a=slerpEndNegated=Quaternion.negate(t,slerpEndNegated)),1-n<CesiumMath.EPSILON6)return Quaternion.lerp(e,a,i,r);n=Math.acos(n);return slerpScaledP=Quaternion.multiplyByScalar(e,Math.sin((1-i)*n),slerpScaledP),slerpScaledR=Quaternion.multiplyByScalar(a,Math.sin(i*n),slerpScaledR),r=Quaternion.add(slerpScaledP,slerpScaledR,r),Quaternion.multiplyByScalar(r,1/Math.sin(n),r)},Quaternion.log=function(e,t){var i=CesiumMath.acosClamped(e.w),r=0;return 0!==i&&(r=i/Math.sin(i)),Cartesian3.multiplyByScalar(e,r,t)},Quaternion.exp=function(e,t){var i=Cartesian3.magnitude(e),r=0;return 0!==i&&(r=Math.sin(i)/i),t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t.w=Math.cos(i),t};var squadScratchCartesian0=new Cartesian3,squadScratchCartesian1=new Cartesian3,squadScratchQuaternion0=new Quaternion,squadScratchQuaternion1=new Quaternion;Quaternion.computeInnerQuadrangle=function(e,t,i,r){var n=Quaternion.conjugate(t,squadScratchQuaternion0);Quaternion.multiply(n,i,squadScratchQuaternion1);i=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian0);Quaternion.multiply(n,e,squadScratchQuaternion1);e=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian1);return Cartesian3.add(i,e,i),Cartesian3.multiplyByScalar(i,.25,i),Cartesian3.negate(i,i),Quaternion.exp(i,squadScratchQuaternion0),Quaternion.multiply(t,squadScratchQuaternion0,r)},Quaternion.squad=function(e,t,i,r,n,a){t=Quaternion.slerp(e,t,n,squadScratchQuaternion0),r=Quaternion.slerp(i,r,n,squadScratchQuaternion1);return Quaternion.slerp(t,r,2*n*(1-n),a)};for(var fastSlerpScratchQuaternion=new Quaternion,opmu=1.9011074535173003,u=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],v=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bT=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bD=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],i$6=0;i$6<7;++i$6){var s$1=i$6+1,t=2*s$1+1;u[i$6]=1/(s$1*t),v[i$6]=s$1/t}u[7]=opmu/136,v[7]=8*opmu/17,Quaternion.fastSlerp=function(e,t,i,r){var n,a=Quaternion.dot(e,t);0<=a?n=1:(n=-1,a=-a);for(var o=a-1,a=1-i,s=i*i,l=a*a,c=7;0<=c;--c)bT[c]=(u[c]*s-v[c])*o,bD[c]=(u[c]*l-v[c])*o;i=n*i*(1+bT[0]*(1+bT[1]*(1+bT[2]*(1+bT[3]*(1+bT[4]*(1+bT[5]*(1+bT[6]*(1+bT[7])))))))),a*=1+bD[0]*(1+bD[1]*(1+bD[2]*(1+bD[3]*(1+bD[4]*(1+bD[5]*(1+bD[6]*(1+bD[7]))))))),a=Quaternion.multiplyByScalar(e,a,fastSlerpScratchQuaternion);return Quaternion.multiplyByScalar(t,i,r),Quaternion.add(a,r,r)},Quaternion.fastSquad=function(e,t,i,r,n,a){t=Quaternion.fastSlerp(e,t,n,squadScratchQuaternion0),r=Quaternion.fastSlerp(i,r,n,squadScratchQuaternion1);return Quaternion.fastSlerp(t,r,2*n*(1-n),a)},Quaternion.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Quaternion.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},Quaternion.ZERO=Object.freeze(new Quaternion(0,0,0,0)),Quaternion.IDENTITY=Object.freeze(new Quaternion(0,0,0,1)),Quaternion.prototype.clone=function(e){return Quaternion.clone(this,e)},Quaternion.prototype.equals=function(e){return Quaternion.equals(this,e)},Quaternion.prototype.equalsEpsilon=function(e,t){return Quaternion.equalsEpsilon(this,e,t)},Quaternion.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var Transforms={},vectorProductLocalFrame={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},degeneratePositionLocalFrame={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},localFrameToFixedFrameCache={},scratchCalculateCartesian={east:new Cartesian3,north:new Cartesian3,up:new Cartesian3,west:new Cartesian3,south:new Cartesian3,down:new Cartesian3},scratchFirstCartesian=new Cartesian3,scratchSecondCartesian=new Cartesian3,scratchThirdCartesian=new Cartesian3;Transforms.localFrameToFixedFrameGenerator=function(n,a){if(!vectorProductLocalFrame.hasOwnProperty(n)||!vectorProductLocalFrame[n].hasOwnProperty(a))throw new DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");var e,o=vectorProductLocalFrame[n][a],t=n+a;return defined(localFrameToFixedFrameCache[t])?e=localFrameToFixedFrameCache[t]:(e=function(e,t,i){var r;return defined(i)||(i=new Matrix4),Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14)?(Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[a],0,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[o],0,scratchThirdCartesian)):CesiumMath.equalsEpsilon(e.x,0,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(e.y,0,CesiumMath.EPSILON14)?(r=CesiumMath.sign(e.z),Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchFirstCartesian),"east"!==n&&"west"!==n&&Cartesian3.multiplyByScalar(scratchFirstCartesian,r,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[a],0,scratchSecondCartesian),"east"!==a&&"west"!==a&&Cartesian3.multiplyByScalar(scratchSecondCartesian,r,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[o],0,scratchThirdCartesian),"east"!==o&&"west"!==o&&Cartesian3.multiplyByScalar(scratchThirdCartesian,r,scratchThirdCartesian)):((t=defaultValue(t,Ellipsoid.WGS84)).geodeticSurfaceNormal(e,scratchCalculateCartesian.up),r=scratchCalculateCartesian.up,(t=scratchCalculateCartesian.east).x=-e.y,t.y=e.x,t.z=0,Cartesian3.normalize(t,scratchCalculateCartesian.east),Cartesian3.cross(r,t,scratchCalculateCartesian.north),Cartesian3.multiplyByScalar(scratchCalculateCartesian.up,-1,scratchCalculateCartesian.down),Cartesian3.multiplyByScalar(scratchCalculateCartesian.east,-1,scratchCalculateCartesian.west),Cartesian3.multiplyByScalar(scratchCalculateCartesian.north,-1,scratchCalculateCartesian.south),scratchFirstCartesian=scratchCalculateCartesian[n],scratchSecondCartesian=scratchCalculateCartesian[a],scratchThirdCartesian=scratchCalculateCartesian[o]),i[0]=scratchFirstCartesian.x,i[1]=scratchFirstCartesian.y,i[2]=scratchFirstCartesian.z,i[3]=0,i[4]=scratchSecondCartesian.x,i[5]=scratchSecondCartesian.y,i[6]=scratchSecondCartesian.z,i[7]=0,i[8]=scratchThirdCartesian.x,i[9]=scratchThirdCartesian.y,i[10]=scratchThirdCartesian.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},localFrameToFixedFrameCache[t]=e),e},Transforms.eastNorthUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("east","north"),Transforms.northEastDownToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","east"),Transforms.northUpEastToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","up"),Transforms.northWestUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","west");var scratchHPRQuaternion=new Quaternion,scratchScale$6=new Cartesian3(1,1,1),scratchHPRMatrix4=new Matrix4;Transforms.headingPitchRollToFixedFrame=function(e,t,i,r,n){r=defaultValue(r,Transforms.eastNorthUpToFixedFrame);t=Quaternion.fromHeadingPitchRoll(t,scratchHPRQuaternion),t=Matrix4.fromTranslationQuaternionRotationScale(Cartesian3.ZERO,t,scratchScale$6,scratchHPRMatrix4);return n=r(e,i,n),Matrix4.multiply(n,t,n)};var scratchENUMatrix4=new Matrix4,scratchHPRMatrix3=new Matrix3;Transforms.headingPitchRollQuaternion=function(e,t,i,r,n){r=Transforms.headingPitchRollToFixedFrame(e,t,i,r,scratchENUMatrix4),r=Matrix4.getMatrix3(r,scratchHPRMatrix3);return Quaternion.fromRotationMatrix(r,n)};var noScale=new Cartesian3(1,1,1),hprCenterScratch=new Cartesian3,ffScratch=new Matrix4,hprTransformScratch=new Matrix4,hprRotationScratch=new Matrix3,hprQuaternionScratch=new Quaternion;Transforms.fixedFrameToHeadingPitchRoll=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,Transforms.eastNorthUpToFixedFrame),defined(r)||(r=new HeadingPitchRoll);var n=Matrix4.getTranslation(e,hprCenterScratch);if(Cartesian3.equals(n,Cartesian3.ZERO))return r.heading=0,r.pitch=0,r.roll=0,r;t=Matrix4.inverseTransformation(i(n,t,ffScratch),ffScratch),e=Matrix4.setScale(e,noScale,hprTransformScratch),e=Matrix4.setTranslation(e,Cartesian3.ZERO,e),t=Matrix4.multiply(t,e,t),t=Quaternion.fromRotationMatrix(Matrix4.getMatrix3(t,hprRotationScratch),hprQuaternionScratch),t=Quaternion.normalize(t,t);return HeadingPitchRoll.fromQuaternion(t,r)};var gmstConstant0=24110.54841,gmstConstant1=8640184.812866,gmstConstant2=.093104,gmstConstant3=-62e-7,rateCoef=11772758384668e-32,wgs84WRPrecessing=72921158553e-15,twoPiOverSecondsInDay=CesiumMath.TWO_PI/86400,dateInUtc=new JulianDate;Transforms.computeTemeToPseudoFixedMatrix=function(e,t){var i=(dateInUtc=JulianDate.addSeconds(e,-JulianDate.computeTaiMinusUtc(e),dateInUtc)).dayNumber,r=dateInUtc.secondsOfDay,e=i-2451545,e=43200<=r?(.5+e)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY:(e-.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,i=(gmstConstant0+e*(gmstConstant1+e*(gmstConstant2+e*gmstConstant3)))*twoPiOverSecondsInDay%CesiumMath.TWO_PI+(wgs84WRPrecessing+rateCoef*(i-2451545.5))*((r+.5*TimeConstants$1.SECONDS_PER_DAY)%TimeConstants$1.SECONDS_PER_DAY),r=Math.cos(i),i=Math.sin(i);return defined(t)?(t[0]=r,t[1]=-i,t[2]=0,t[3]=i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(r,i,0,-i,r,0,0,0,1)},Transforms.iau2006XysData=new Iau2006XysData,Transforms.earthOrientationParameters=EarthOrientationParameters.NONE;var ttMinusTai=32.184,j2000ttDays=2451545;Transforms.preloadIcrfFixed=function(e){var t=e.start.dayNumber,i=e.start.secondsOfDay+ttMinusTai,r=e.stop.dayNumber,e=e.stop.secondsOfDay+ttMinusTai,r=Transforms.iau2006XysData.preload(t,i,r,e),e=Transforms.earthOrientationParameters.getPromiseToLoad();return when.all([r,e])},Transforms.computeIcrfToFixedMatrix=function(e,t){defined(t)||(t=new Matrix3);e=Transforms.computeFixedToIcrfMatrix(e,t);if(defined(e))return Matrix3.transpose(e,t)};var xysScratch=new Iau2006XysSample(0,0,0),eopScratch=new EarthOrientationParametersSample(0,0,0,0,0,0),rotation1Scratch=new Matrix3,rotation2Scratch=new Matrix3;Transforms.computeFixedToIcrfMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.earthOrientationParameters.compute(e,eopScratch);if(defined(i)){var r=e.dayNumber,n=e.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.computeXysRadians(r,n,xysScratch);if(defined(a)){var o=a.x+i.xPoleOffset,s=a.y+i.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-s*s)),c=rotation1Scratch;c[0]=1-l*o*o,c[3]=-l*o*s,c[6]=o,c[1]=-l*o*s,c[4]=1-l*s*s,c[7]=s,c[2]=-o,c[5]=-s,c[8]=1-l*(o*o+s*s);o=Matrix3.fromRotationZ(-a.s,rotation2Scratch),s=Matrix3.multiply(c,o,rotation1Scratch),a=e.dayNumber,c=(e.secondsOfDay-JulianDate.computeTaiMinusUtc(e)+i.ut1MinusUtc)/TimeConstants$1.SECONDS_PER_DAY,o=(o=.779057273264+c+.00273781191135448*(a-2451545+c))%1*CesiumMath.TWO_PI,e=Matrix3.fromRotationZ(o,rotation2Scratch),a=Matrix3.multiply(s,e,rotation1Scratch),c=Math.cos(i.xPoleWander),o=Math.cos(i.yPoleWander),s=Math.sin(i.xPoleWander),e=Math.sin(i.yPoleWander),i=r-j2000ttDays+n/TimeConstants$1.SECONDS_PER_DAY,r=-47e-6*(i/=36525)*CesiumMath.RADIANS_PER_DEGREE/3600,n=Math.cos(r),i=Math.sin(r),r=rotation2Scratch;return r[0]=c*n,r[1]=c*i,r[2]=s,r[3]=-o*i+e*s*n,r[4]=o*n+e*s*i,r[5]=-e*c,r[6]=-e*i-o*s*n,r[7]=e*n-o*s*i,r[8]=o*c,Matrix3.multiply(a,r,t)}}};var pointToWindowCoordinatesTemp=new Cartesian4;Transforms.pointToWindowCoordinates=function(e,t,i,r){return(r=Transforms.pointToGLWindowCoordinates(e,t,i,r)).y=2*t[5]-r.y,r},Transforms.pointToGLWindowCoordinates=function(e,t,i,r){defined(r)||(r=new Cartesian2);var n=pointToWindowCoordinatesTemp;return Matrix4.multiplyByVector(e,Cartesian4.fromElements(i.x,i.y,i.z,1,n),n),Cartesian4.multiplyByScalar(n,1/n.w,n),Matrix4.multiplyByVector(t,n,n),Cartesian2.fromCartesian4(n,r)};var normalScratch$5=new Cartesian3,rightScratch$1=new Cartesian3,upScratch=new Cartesian3;Transforms.rotationMatrixFromPositionVelocity=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84).geodeticSurfaceNormal(e,normalScratch$5),e=Cartesian3.cross(t,i,rightScratch$1);Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON6)&&(e=Cartesian3.clone(Cartesian3.UNIT_X,e));i=Cartesian3.cross(e,t,upScratch);return Cartesian3.normalize(i,i),Cartesian3.cross(t,i,e),Cartesian3.negate(e,e),Cartesian3.normalize(e,e),(r=!defined(r)?new Matrix3:r)[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=e.x,r[4]=e.y,r[5]=e.z,r[6]=i.x,r[7]=i.y,r[8]=i.z,r};var swizzleMatrix=new Matrix4(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),scratchCartographic$h=new Cartographic,scratchCartesian3Projection$1=new Cartesian3,scratchCenter$8=new Cartesian3,scratchRotation$2=new Matrix3,scratchFromENU=new Matrix4,scratchToENU=new Matrix4;Transforms.basisTo2D=function(e,t,i){var r=Matrix4.getTranslation(t,scratchCenter$8),n=e.ellipsoid,a=n.cartesianToCartographic(r,scratchCartographic$h),a=e.project(a,scratchCartesian3Projection$1);Cartesian3.fromElements(a.z,a.x,a.y,a);n=Transforms.eastNorthUpToFixedFrame(r,n,scratchFromENU),n=Matrix4.inverseTransformation(n,scratchToENU),t=Matrix4.getMatrix3(t,scratchRotation$2),t=Matrix4.multiplyByMatrix3(n,t,i);return Matrix4.multiply(swizzleMatrix,t,i),Matrix4.setTranslation(i,a,i),i},Transforms.wgs84To2DModelMatrix=function(e,t,i){var r=e.ellipsoid,n=Transforms.eastNorthUpToFixedFrame(t,r,scratchFromENU),n=Matrix4.inverseTransformation(n,scratchToENU),t=r.cartesianToCartographic(t,scratchCartographic$h),t=e.project(t,scratchCartesian3Projection$1);Cartesian3.fromElements(t.z,t.x,t.y,t);t=Matrix4.fromTranslation(t,scratchFromENU);return Matrix4.multiply(swizzleMatrix,n,i),Matrix4.multiply(t,i,i),i};var scratchCart4=new Cartesian4;function EllipsoidTangentPlane(e,t){e=(t=defaultValue(t,Ellipsoid.WGS84)).scaleToGeodeticSurface(e);var i=Transforms.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,0,scratchCart4)),this._yAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,1,scratchCart4));i=Cartesian3.fromCartesian4(Matrix4.getColumn(i,2,scratchCart4));this._plane=Plane.fromPointNormal(e,i)}Object.defineProperties(EllipsoidTangentPlane.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var tmp=new AxisAlignedBoundingBox;EllipsoidTangentPlane.fromPoints=function(e,t){return new EllipsoidTangentPlane(AxisAlignedBoundingBox.fromPoints(e,tmp).center,t)};var scratchProjectPointOntoPlaneRay=new Ray,scratchProjectPointOntoPlaneCartesian3=new Cartesian3;EllipsoidTangentPlane.prototype.projectPointOntoPlane=function(e,t){var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.normalize(e,i.direction);e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);if(defined(e)||(Cartesian3.negate(i.direction,i.direction),e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3)),defined(e)){i=Cartesian3.subtract(e,this._origin,e),e=Cartesian3.dot(this._xAxis,i),i=Cartesian3.dot(this._yAxis,i);return defined(t)?(t.x=e,t.y=i,t):new Cartesian2(e,i)}},EllipsoidTangentPlane.prototype.projectPointsOntoPlane=function(e,t){defined(t)||(t=[]);for(var i=0,r=e.length,n=0;n<r;n++){var a=this.projectPointOntoPlane(e[n],t[i]);defined(a)&&(t[i]=a,i++)}return t.length=i,t},EllipsoidTangentPlane.prototype.projectPointToNearestOnPlane=function(e,t){defined(t)||(t=new Cartesian2);var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.clone(this._plane.normal,i.direction);e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);defined(e)||(Cartesian3.negate(i.direction,i.direction),e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3));i=Cartesian3.subtract(e,this._origin,e),e=Cartesian3.dot(this._xAxis,i),i=Cartesian3.dot(this._yAxis,i);return t.x=e,t.y=i,t},EllipsoidTangentPlane.prototype.projectPointsToNearestOnPlane=function(e,t){defined(t)||(t=[]);var i=e.length;t.length=i;for(var r=0;r<i;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var projectPointsOntoEllipsoidScratch=new Cartesian3;function OrientedBoundingBox(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.halfAxes=Matrix3.clone(defaultValue(t,Matrix3.ZERO))}EllipsoidTangentPlane.prototype.projectPointOntoEllipsoid=function(e,t){defined(t)||(t=new Cartesian3);var i=this._ellipsoid,r=this._origin,n=this._xAxis,a=this._yAxis,o=projectPointsOntoEllipsoidScratch;return Cartesian3.multiplyByScalar(n,e.x,o),t=Cartesian3.add(r,o,t),Cartesian3.multiplyByScalar(a,e.y,o),Cartesian3.add(t,o,t),i.scaleToGeocentricSurface(t,t),t},EllipsoidTangentPlane.prototype.projectPointsOntoEllipsoid=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.projectPointOntoEllipsoid(e[r],t[r]);return t},OrientedBoundingBox.packedLength=Cartesian3.packedLength+Matrix3.packedLength,OrientedBoundingBox.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e.center,t,i),Matrix3.pack(e.halfAxes,t,i+Cartesian3.packedLength),t},OrientedBoundingBox.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrientedBoundingBox),Cartesian3.unpack(e,t,i.center),Matrix3.unpack(e,t+Cartesian3.packedLength,i.halfAxes),i};var scratchCartesian1$8=new Cartesian3,scratchCartesian2$b=new Cartesian3,scratchCartesian3$c=new Cartesian3,scratchCartesian4$6=new Cartesian3,scratchCartesian5$2=new Cartesian3,scratchCartesian6$1=new Cartesian3,scratchCovarianceResult=new Matrix3,scratchEigenResult={unitary:new Matrix3,diagonal:new Matrix3};OrientedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new OrientedBoundingBox),!defined(e)||0===e.length)return t.halfAxes=Matrix3.ZERO,t.center=Cartesian3.ZERO,t;for(var i=e.length,r=Cartesian3.clone(e[0],scratchCartesian1$8),n=1;n<i;n++)Cartesian3.add(r,e[n],r);var a=1/i;Cartesian3.multiplyByScalar(r,a,r);var o,s=0,l=0,c=0,u=0,d=0,h=0;for(n=0;n<i;n++)s+=(o=Cartesian3.subtract(e[n],r,scratchCartesian2$b)).x*o.x,l+=o.x*o.y,c+=o.x*o.z,u+=o.y*o.y,d+=o.y*o.z,h+=o.z*o.z;l*=a,c*=a,u*=a,d*=a,h*=a;var p=scratchCovarianceResult;p[0]=s*=a,p[1]=l,p[2]=c,p[3]=l,p[4]=u,p[5]=d,p[6]=c,p[7]=d,p[8]=h;var p=Matrix3.computeEigenDecomposition(p,scratchEigenResult),p=Matrix3.clone(p.unitary,t.halfAxes),f=Matrix3.getColumn(p,0,scratchCartesian4$6),m=Matrix3.getColumn(p,1,scratchCartesian5$2),g=Matrix3.getColumn(p,2,scratchCartesian6$1),_=-Number.MAX_VALUE,y=-Number.MAX_VALUE,C=-Number.MAX_VALUE,v=Number.MAX_VALUE,T=Number.MAX_VALUE,S=Number.MAX_VALUE;for(n=0;n<i;n++)o=e[n],_=Math.max(Cartesian3.dot(f,o),_),y=Math.max(Cartesian3.dot(m,o),y),C=Math.max(Cartesian3.dot(g,o),C),v=Math.min(Cartesian3.dot(f,o),v),T=Math.min(Cartesian3.dot(m,o),T),S=Math.min(Cartesian3.dot(g,o),S);f=Cartesian3.multiplyByScalar(f,.5*(v+_),f),m=Cartesian3.multiplyByScalar(m,.5*(T+y),m),g=Cartesian3.multiplyByScalar(g,.5*(S+C),g),p=Cartesian3.add(f,m,t.center);Cartesian3.add(p,g,p);p=scratchCartesian3$c;return p.x=_-v,p.y=y-T,p.z=C-S,Cartesian3.multiplyByScalar(p,.5,p),Matrix3.multiplyByScale(t.halfAxes,p,t.halfAxes),t};var scratchOffset=new Cartesian3,scratchScale$5=new Cartesian3;function fromPlaneExtents(e,t,i,r,n,a,o,s,l,c,u){var d=(u=!defined(u)?new OrientedBoundingBox:u).halfAxes;Matrix3.setColumn(d,0,t,d),Matrix3.setColumn(d,1,i,d),Matrix3.setColumn(d,2,r,d),(i=scratchOffset).x=(n+a)/2,i.y=(o+s)/2,i.z=(l+c)/2;r=scratchScale$5;r.x=(a-n)/2,r.y=(s-o)/2,r.z=(c-l)/2;l=u.center,i=Matrix3.multiplyByVector(d,i,i);return Cartesian3.add(e,i,l),Matrix3.multiplyByScale(d,r,d),u}var scratchRectangleCenterCartographic=new Cartographic,scratchRectangleCenter=new Cartesian3,scratchPerimeterCartographicNC=new Cartographic,scratchPerimeterCartographicNW=new Cartographic,scratchPerimeterCartographicCW=new Cartographic,scratchPerimeterCartographicSW=new Cartographic,scratchPerimeterCartographicSC=new Cartographic,scratchPerimeterCartesianNC=new Cartesian3,scratchPerimeterCartesianNW=new Cartesian3,scratchPerimeterCartesianCW=new Cartesian3,scratchPerimeterCartesianSW=new Cartesian3,scratchPerimeterCartesianSC=new Cartesian3,scratchPerimeterProjectedNC=new Cartesian2,scratchPerimeterProjectedNW=new Cartesian2,scratchPerimeterProjectedCW=new Cartesian2,scratchPerimeterProjectedSW=new Cartesian2,scratchPerimeterProjectedSC=new Cartesian2,scratchPlaneOrigin=new Cartesian3,scratchPlaneNormal$1=new Cartesian3,scratchPlaneXAxis=new Cartesian3,scratchHorizonCartesian=new Cartesian3,scratchHorizonProjected=new Cartesian2,scratchMaxY=new Cartesian3,scratchMinY=new Cartesian3,scratchZ=new Cartesian3,scratchPlane$2=new Plane(Cartesian3.UNIT_X,0);OrientedBoundingBox.fromRectangle=function(e,t,i,r,n){if(t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,Ellipsoid.WGS84),e.width<=CesiumMath.PI){var a=Rectangle.center(e,scratchRectangleCenterCartographic),o=new EllipsoidTangentPlane(r.cartographicToCartesian(a,scratchRectangleCenter),r),s=o.plane,l=a.longitude,c=e.south<0&&0<e.north?0:a.latitude,u=Cartographic.fromRadians(l,e.north,i,scratchPerimeterCartographicNC),d=Cartographic.fromRadians(e.west,e.north,i,scratchPerimeterCartographicNW),h=Cartographic.fromRadians(e.west,c,i,scratchPerimeterCartographicCW),p=Cartographic.fromRadians(e.west,e.south,i,scratchPerimeterCartographicSW),f=Cartographic.fromRadians(l,e.south,i,scratchPerimeterCartographicSC),m=r.cartographicToCartesian(u,scratchPerimeterCartesianNC),g=r.cartographicToCartesian(d,scratchPerimeterCartesianNW),_=r.cartographicToCartesian(h,scratchPerimeterCartesianCW),y=r.cartographicToCartesian(p,scratchPerimeterCartesianSW),C=r.cartographicToCartesian(f,scratchPerimeterCartesianSC),a=o.projectPointToNearestOnPlane(m,scratchPerimeterProjectedNC),c=o.projectPointToNearestOnPlane(g,scratchPerimeterProjectedNW),l=o.projectPointToNearestOnPlane(_,scratchPerimeterProjectedCW),u=o.projectPointToNearestOnPlane(y,scratchPerimeterProjectedSW),h=o.projectPointToNearestOnPlane(C,scratchPerimeterProjectedSC),m=-(f=Math.min(c.x,l.x,u.x)),_=Math.max(c.y,a.y),C=Math.min(u.y,h.y);return d.height=p.height=t,g=r.cartographicToCartesian(d,scratchPerimeterCartesianNW),y=r.cartographicToCartesian(p,scratchPerimeterCartesianSW),l=Math.min(Plane.getPointDistance(s,g),Plane.getPointDistance(s,y)),c=i,fromPlaneExtents(o.origin,o.xAxis,o.yAxis,o.zAxis,f,m,C,_,l,c,n)}a=0<e.south,u=e.north<0,h=a?e.south:u?e.north:0,d=Rectangle.center(e,scratchRectangleCenterCartographic).longitude,p=Cartesian3.fromRadians(d,h,i,r,scratchPlaneOrigin);p.z=0;g=Math.abs(p.x)<CesiumMath.EPSILON10&&Math.abs(p.y)<CesiumMath.EPSILON10?Cartesian3.UNIT_X:Cartesian3.normalize(p,scratchPlaneNormal$1),y=Cartesian3.UNIT_Z,o=Cartesian3.cross(g,y,scratchPlaneXAxis);s=Plane.fromPointNormal(p,g,scratchPlane$2);d=Cartesian3.fromRadians(d+CesiumMath.PI_OVER_TWO,h,i,r,scratchHorizonCartesian);f=-(m=Cartesian3.dot(Plane.projectPointOntoPlane(s,d,scratchHorizonProjected),o)),_=Cartesian3.fromRadians(0,e.north,u?t:i,r,scratchMaxY).z,C=Cartesian3.fromRadians(0,e.south,a?t:i,r,scratchMinY).z;r=Cartesian3.fromRadians(e.east,h,i,r,scratchZ);return fromPlaneExtents(p,o,y,g,f,m,C,_,l=Plane.getPointDistance(s,r),c=0,n)},OrientedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(Cartesian3.clone(e.center,t.center),Matrix3.clone(e.halfAxes,t.halfAxes),t):new OrientedBoundingBox(e.center,e.halfAxes)},OrientedBoundingBox.intersectPlane=function(e,t){var i=e.center,r=t.normal,n=e.halfAxes,a=r.x,o=r.y,e=r.z,n=Math.abs(a*n[Matrix3.COLUMN0ROW0]+o*n[Matrix3.COLUMN0ROW1]+e*n[Matrix3.COLUMN0ROW2])+Math.abs(a*n[Matrix3.COLUMN1ROW0]+o*n[Matrix3.COLUMN1ROW1]+e*n[Matrix3.COLUMN1ROW2])+Math.abs(a*n[Matrix3.COLUMN2ROW0]+o*n[Matrix3.COLUMN2ROW1]+e*n[Matrix3.COLUMN2ROW2]),t=Cartesian3.dot(r,i)+t.distance;return t<=-n?Intersect$1.OUTSIDE:n<=t?Intersect$1.INSIDE:Intersect$1.INTERSECTING};var scratchCartesianU=new Cartesian3,scratchCartesianV=new Cartesian3,scratchCartesianW=new Cartesian3,scratchValidAxis2=new Cartesian3,scratchValidAxis3=new Cartesian3,scratchPPrime=new Cartesian3;OrientedBoundingBox.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(t,e.center,scratchOffset),r=e.halfAxes,n=Matrix3.getColumn(r,0,scratchCartesianU),a=Matrix3.getColumn(r,1,scratchCartesianV),o=Matrix3.getColumn(r,2,scratchCartesianW),s=Cartesian3.magnitude(n),l=Cartesian3.magnitude(a),c=Cartesian3.magnitude(o),u=!0,t=!0,e=!0;0<s?Cartesian3.divideByScalar(n,s,n):u=!1,0<l?Cartesian3.divideByScalar(a,l,a):t=!1,0<c?Cartesian3.divideByScalar(o,c,o):e=!1;var d,h,p,r=!u+!t+!e;1==r?(u=n,h=a,p=o,t?e||(u=o,p=n):(u=a,h=n),d=Cartesian3.cross(h,p,scratchValidAxis3),u===n?n=d:u===a?a=d:u===o&&(o=d)):2==r?(h=n,t?h=a:e&&(h=o),(e=Cartesian3.UNIT_Y).equalsEpsilon(h,CesiumMath.EPSILON3)&&(e=Cartesian3.UNIT_X),p=Cartesian3.cross(h,e,scratchValidAxis2),Cartesian3.normalize(p,p),d=Cartesian3.cross(h,p,scratchValidAxis3),Cartesian3.normalize(d,d),h===n?(a=p,o=d):h===a?(o=p,n=d):h===o&&(n=p,a=d)):3==r&&(n=Cartesian3.UNIT_X,a=Cartesian3.UNIT_Y,o=Cartesian3.UNIT_Z);r=scratchPPrime;r.x=Cartesian3.dot(i,n),r.y=Cartesian3.dot(i,a),r.z=Cartesian3.dot(i,o);var f,o=0;return r.x<-s?o+=(f=r.x+s)*f:r.x>s&&(o+=(f=r.x-s)*f),r.y<-l?o+=(f=r.y+l)*f:r.y>l&&(o+=(f=r.y-l)*f),r.z<-c?o+=(f=r.z+c)*f:r.z>c&&(o+=(f=r.z-c)*f),o};var scratchCorner=new Cartesian3,scratchToCenter$1=new Cartesian3;OrientedBoundingBox.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Number.POSITIVE_INFINITY,a=Number.NEGATIVE_INFINITY,o=e.center,s=e.halfAxes,l=Matrix3.getColumn(s,0,scratchCartesianU),c=Matrix3.getColumn(s,1,scratchCartesianV),u=Matrix3.getColumn(s,2,scratchCartesianW),d=Cartesian3.add(l,c,scratchCorner);Cartesian3.add(d,u,d),Cartesian3.add(d,o,d);e=Cartesian3.subtract(d,t,scratchToCenter$1),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a);return Cartesian3.add(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),r.start=n,r.stop=a,r};var scratchBoundingSphere$3=new BoundingSphere;OrientedBoundingBox.isOccluded=function(e,t){e=BoundingSphere.fromOrientedBoundingBox(e,scratchBoundingSphere$3);return!t.isBoundingSphereVisible(e)},OrientedBoundingBox.prototype.intersectPlane=function(e){return OrientedBoundingBox.intersectPlane(this,e)},OrientedBoundingBox.prototype.distanceSquaredTo=function(e){return OrientedBoundingBox.distanceSquaredTo(this,e)},OrientedBoundingBox.prototype.computePlaneDistances=function(e,t,i){return OrientedBoundingBox.computePlaneDistances(this,e,t,i)},OrientedBoundingBox.prototype.isOccluded=function(e){return OrientedBoundingBox.isOccluded(this,e)},OrientedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Matrix3.equals(e.halfAxes,t.halfAxes)},OrientedBoundingBox.prototype.clone=function(e){return OrientedBoundingBox.clone(this,e)},OrientedBoundingBox.prototype.equals=function(e){return OrientedBoundingBox.equals(this,e)};var WebGLConstants={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGBA_ASTC_4x4_WEBGL:37808,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGBA_BPTC_UNORM:36492,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},WebGLConstants$1=Object.freeze(WebGLConstants),ComponentDatatype={BYTE:WebGLConstants$1.BYTE,UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,SHORT:WebGLConstants$1.SHORT,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,INT:WebGLConstants$1.INT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,DOUBLE:WebGLConstants$1.DOUBLE,getSizeInBytes:function(e){switch(e){case ComponentDatatype.BYTE:return Int8Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case ComponentDatatype.SHORT:return Int16Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case ComponentDatatype.INT:return Int32Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case ComponentDatatype.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case ComponentDatatype.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},fromTypedArray:function(e){return e instanceof Int8Array?ComponentDatatype.BYTE:e instanceof Uint8Array?ComponentDatatype.UNSIGNED_BYTE:e instanceof Int16Array?ComponentDatatype.SHORT:e instanceof Uint16Array?ComponentDatatype.UNSIGNED_SHORT:e instanceof Int32Array?ComponentDatatype.INT:e instanceof Uint32Array?ComponentDatatype.UNSIGNED_INT:e instanceof Float32Array?ComponentDatatype.FLOAT:e instanceof Float64Array?ComponentDatatype.DOUBLE:void 0},validate:function(e){return defined(e)&&(e===ComponentDatatype.BYTE||e===ComponentDatatype.UNSIGNED_BYTE||e===ComponentDatatype.SHORT||e===ComponentDatatype.UNSIGNED_SHORT||e===ComponentDatatype.INT||e===ComponentDatatype.UNSIGNED_INT||e===ComponentDatatype.FLOAT||e===ComponentDatatype.DOUBLE)},createTypedArray:function(e,t){switch(e){case ComponentDatatype.BYTE:return new Int8Array(t);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t);case ComponentDatatype.SHORT:return new Int16Array(t);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t);case ComponentDatatype.INT:return new Int32Array(t);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t);case ComponentDatatype.FLOAT:return new Float32Array(t);case ComponentDatatype.DOUBLE:return new Float64Array(t)}},createArrayBufferView:function(e,t,i,r){switch(i=defaultValue(i,0),r=defaultValue(r,(t.byteLength-i)/ComponentDatatype.getSizeInBytes(e)),e){case ComponentDatatype.BYTE:return new Int8Array(t,i,r);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t,i,r);case ComponentDatatype.SHORT:return new Int16Array(t,i,r);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t,i,r);case ComponentDatatype.INT:return new Int32Array(t,i,r);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t,i,r);case ComponentDatatype.FLOAT:return new Float32Array(t,i,r);case ComponentDatatype.DOUBLE:return new Float64Array(t,i,r)}},fromName:function(e){switch(e){case"BYTE":return ComponentDatatype.BYTE;case"UNSIGNED_BYTE":return ComponentDatatype.UNSIGNED_BYTE;case"SHORT":return ComponentDatatype.SHORT;case"UNSIGNED_SHORT":return ComponentDatatype.UNSIGNED_SHORT;case"INT":return ComponentDatatype.INT;case"UNSIGNED_INT":return ComponentDatatype.UNSIGNED_INT;case"FLOAT":return ComponentDatatype.FLOAT;case"DOUBLE":return ComponentDatatype.DOUBLE}}},ComponentDatatype$1=Object.freeze(ComponentDatatype);function Matrix2(e,t,i,r){this[0]=defaultValue(e,0),this[1]=defaultValue(i,0),this[2]=defaultValue(t,0),this[3]=defaultValue(r,0)}Matrix2.packedLength=4,Matrix2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t},Matrix2.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Matrix2:i)[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i},Matrix2.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Matrix2(e[0],e[2],e[1],e[3])},Matrix2.fromArray=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Matrix2:i)[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i},Matrix2.fromColumnMajorArray=function(e,t){return Matrix2.clone(e,t)},Matrix2.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Matrix2(e[0],e[1],e[2],e[3])},Matrix2.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Matrix2(e.x,0,0,e.y)},Matrix2.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Matrix2(e,0,0,e)},Matrix2.fromRotation=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=e,t[2]=-e,t[3]=i,t):new Matrix2(i,-e,e,i)},Matrix2.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},Matrix2.getElementIndex=function(e,t){return 2*e+t},Matrix2.getColumn=function(e,t,i){var r=2*t,t=e[r],r=e[1+r];return i.x=t,i.y=r,i},Matrix2.setColumn=function(e,t,i,r){t*=2;return(r=Matrix2.clone(e,r))[t]=i.x,r[1+t]=i.y,r},Matrix2.getRow=function(e,t,i){var r=e[t],t=e[t+2];return i.x=r,i.y=t,i},Matrix2.setRow=function(e,t,i,r){return(r=Matrix2.clone(e,r))[t]=i.x,r[t+2]=i.y,r};var scratchColumn=new Cartesian2;Matrix2.getScale=function(e,t){return t.x=Cartesian2.magnitude(Cartesian2.fromElements(e[0],e[1],scratchColumn)),t.y=Cartesian2.magnitude(Cartesian2.fromElements(e[2],e[3],scratchColumn)),t};var scratchScale$4=new Cartesian2;Matrix2.getMaximumScale=function(e){return Matrix2.getScale(e,scratchScale$4),Cartesian2.maximumComponent(scratchScale$4)},Matrix2.multiply=function(e,t,i){var r=e[0]*t[0]+e[2]*t[1],n=e[0]*t[2]+e[2]*t[3],a=e[1]*t[0]+e[3]*t[1],t=e[1]*t[2]+e[3]*t[3];return i[0]=r,i[1]=a,i[2]=n,i[3]=t,i},Matrix2.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i},Matrix2.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i},Matrix2.multiplyByVector=function(e,t,i){var r=e[0]*t.x+e[2]*t.y,t=e[1]*t.x+e[3]*t.y;return i.x=r,i.y=t,i},Matrix2.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i},Matrix2.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.y,i[3]=e[3]*t.y,i},Matrix2.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Matrix2.transpose=function(e,t){var i=e[0],r=e[2],n=e[1],e=e[3];return t[0]=i,t[1]=r,t[2]=n,t[3]=e,t},Matrix2.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},Matrix2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Matrix2.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]},Matrix2.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},Matrix2.IDENTITY=Object.freeze(new Matrix2(1,0,0,1)),Matrix2.ZERO=Object.freeze(new Matrix2(0,0,0,0)),Matrix2.COLUMN0ROW0=0,Matrix2.COLUMN0ROW1=1,Matrix2.COLUMN1ROW0=2,Matrix2.COLUMN1ROW1=3,Object.defineProperties(Matrix2.prototype,{length:{get:function(){return Matrix2.packedLength}}}),Matrix2.prototype.clone=function(e){return Matrix2.clone(this,e)},Matrix2.prototype.equals=function(e){return Matrix2.equals(this,e)},Matrix2.prototype.equalsEpsilon=function(e,t){return Matrix2.equalsEpsilon(this,e,t)},Matrix2.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"};var AttributeType={SCALAR:"SCALAR",VEC2:"VEC2",VEC3:"VEC3",VEC4:"VEC4",MAT2:"MAT2",MAT3:"MAT3",MAT4:"MAT4",getMathType:function(e){switch(e){case AttributeType.SCALAR:return Number;case AttributeType.VEC2:return Cartesian2;case AttributeType.VEC3:return Cartesian3;case AttributeType.VEC4:return Cartesian4;case AttributeType.MAT2:return Matrix2;case AttributeType.MAT3:return Matrix3;case AttributeType.MAT4:return Matrix4}},getNumberOfComponents:function(e){switch(e){case AttributeType.SCALAR:return 1;case AttributeType.VEC2:return 2;case AttributeType.VEC3:return 3;case AttributeType.VEC4:case AttributeType.MAT2:return 4;case AttributeType.MAT3:return 9;case AttributeType.MAT4:return 16}},getGlslType:function(e){switch(e){case AttributeType.SCALAR:return"float";case AttributeType.VEC2:return"vec2";case AttributeType.VEC3:return"vec3";case AttributeType.VEC4:return"vec4";case AttributeType.MAT2:return"mat2";case AttributeType.MAT3:return"mat3";case AttributeType.MAT4:return"mat4"}}},AttributeType$1=Object.freeze(AttributeType),RIGHT_SHIFT=1/256,LEFT_SHIFT=256,AttributeCompression={octEncodeInRange:function(e,t,i){var r;return i.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),i.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0&&(r=i.x,e=i.y,i.x=(1-Math.abs(e))*CesiumMath.signNotZero(r),i.y=(1-Math.abs(r))*CesiumMath.signNotZero(e)),i.x=CesiumMath.toSNorm(i.x,t),i.y=CesiumMath.toSNorm(i.y,t),i},octEncode:function(e,t){return AttributeCompression.octEncodeInRange(e,255,t)}},octEncodeScratch=new Cartesian2,uint8ForceArray=new Uint8Array(1);function forceUint8(e){return uint8ForceArray[0]=e,uint8ForceArray[0]}AttributeCompression.octEncodeToCartesian4=function(e,t){return AttributeCompression.octEncodeInRange(e,65535,octEncodeScratch),t.x=forceUint8(octEncodeScratch.x*RIGHT_SHIFT),t.y=forceUint8(octEncodeScratch.x),t.z=forceUint8(octEncodeScratch.y*RIGHT_SHIFT),t.w=forceUint8(octEncodeScratch.y),t},AttributeCompression.octDecodeInRange=function(e,t,i,r){return r.x=CesiumMath.fromSNorm(e,i),r.y=CesiumMath.fromSNorm(t,i),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0&&(i=r.x,r.x=(1-Math.abs(r.y))*CesiumMath.signNotZero(i),r.y=(1-Math.abs(i))*CesiumMath.signNotZero(r.y)),Cartesian3.normalize(r,r)},AttributeCompression.octDecode=function(e,t,i){return AttributeCompression.octDecodeInRange(e,t,255,i)},AttributeCompression.octDecodeFromCartesian4=function(e,t){var i=e.x,r=e.y,n=e.z,e=e.w;return AttributeCompression.octDecodeInRange(i*LEFT_SHIFT+r,n*LEFT_SHIFT+e,65535,t)},AttributeCompression.octPackFloat=function(e){return 256*e.x+e.y};var scratchEncodeCart2=new Cartesian2;function zigZagDecode(e){return e>>1^-(1&e)}AttributeCompression.octEncodeFloat=function(e){return AttributeCompression.octEncode(e,scratchEncodeCart2),AttributeCompression.octPackFloat(scratchEncodeCart2)},AttributeCompression.octDecodeFloat=function(e,t){var i=e/256,e=Math.floor(i);return AttributeCompression.octDecode(e,256*(i-e),t)},AttributeCompression.octPack=function(e,t,i,r){e=AttributeCompression.octEncodeFloat(e),t=AttributeCompression.octEncodeFloat(t),i=AttributeCompression.octEncode(i,scratchEncodeCart2);return r.x=65536*i.x+e,r.y=65536*i.y+t,r},AttributeCompression.octUnpack=function(e,t,i,r){var n=e.x/65536,a=Math.floor(n),o=65536*(n-a),n=e.y/65536,e=Math.floor(n),n=65536*(n-e);AttributeCompression.octDecodeFloat(o,t),AttributeCompression.octDecodeFloat(n,i),AttributeCompression.octDecode(a,e,r)},AttributeCompression.compressTextureCoordinates=function(e){return 4096*(4095*e.x|0)+(4095*e.y|0)},AttributeCompression.decompressTextureCoordinates=function(e,t){var i=Math.floor(e/4096);return t.x=i/4095,t.y=(e-4096*i)/4095,t},AttributeCompression.zigZagDeltaDecode=function(e,t,i){for(var r=e.length,n=0,a=0,o=0,s=0;s<r;++s)n+=zigZagDecode(e[s]),a+=zigZagDecode(t[s]),e[s]=n,t[s]=a,defined(i)&&(o+=zigZagDecode(i[s]),i[s]=o)},AttributeCompression.dequantize=function(e,t,i,r){var n,a=AttributeType$1.getNumberOfComponents(i);switch(t){case ComponentDatatype$1.BYTE:n=127;break;case ComponentDatatype$1.UNSIGNED_BYTE:n=255;break;case ComponentDatatype$1.SHORT:n=32767;break;case ComponentDatatype$1.UNSIGNED_SHORT:n=65535;break;case ComponentDatatype$1.INT:n=2147483647;break;case ComponentDatatype$1.UNSIGNED_INT:n=4294967295}for(var o=new Float32Array(r*a),s=0;s<r;s++)for(var l=0;l<a;l++){var c=s*a+l;o[c]=Math.max(e[c]/n,-1)}return o};var TerrainExaggeration={getHeight:function(e,t,i){return(e-i)*t+i}},scratchCartographic$g=new Cartesian3;TerrainExaggeration.getPosition=function(e,t,i,r,n){e=t.cartesianToCartographic(e,scratchCartographic$g),r=TerrainExaggeration.getHeight(e.height,i,r);return Cartesian3.fromRadians(e.longitude,e.latitude,r,t,n)};var TerrainQuantization={NONE:0,BITS12:1},TerrainQuantization$1=Object.freeze(TerrainQuantization),cartesian3Scratch$3=new Cartesian3,cartesian3DimScratch=new Cartesian3,cartesian2Scratch=new Cartesian2,matrix4Scratch$1=new Matrix4,matrix4Scratch2=new Matrix4,SHIFT_LEFT_12=Math.pow(2,12);function TerrainEncoding(e,t,i,r,n,a,o,s,l,c){var u,d,h,p=TerrainQuantization$1.NONE;defined(t)&&defined(i)&&defined(r)&&defined(n)&&(h=t.minimum,u=t.maximum,t=Cartesian3.subtract(u,h,cartesian3DimScratch),d=r-i,p=Math.max(Cartesian3.maximumComponent(t),d)<SHIFT_LEFT_12-1?TerrainQuantization$1.BITS12:TerrainQuantization$1.NONE,u=Matrix4.inverseTransformation(n,new Matrix4),d=Cartesian3.negate(h,cartesian3Scratch$3),Matrix4.multiply(Matrix4.fromTranslation(d,matrix4Scratch$1),u,u),(d=cartesian3Scratch$3).x=1/t.x,d.y=1/t.y,d.z=1/t.z,Matrix4.multiply(Matrix4.fromScale(d,matrix4Scratch$1),u,u),d=Matrix4.clone(n),Matrix4.setTranslation(d,Cartesian3.ZERO,d),n=Matrix4.clone(n,new Matrix4),h=Matrix4.fromTranslation(h,matrix4Scratch$1),t=Matrix4.fromScale(t,matrix4Scratch2),t=Matrix4.multiply(h,t,matrix4Scratch$1),Matrix4.multiply(n,t,n),Matrix4.multiply(d,t,d)),this.quantization=p,this.minimumHeight=i,this.maximumHeight=r,this.center=Cartesian3.clone(e),this.toScaledENU=u,this.fromScaledENU=n,this.matrix=d,this.hasVertexNormals=a,this.hasWebMercatorT=defaultValue(o,!1),this.hasGeodeticSurfaceNormals=defaultValue(s,!1),this.exaggeration=defaultValue(l,1),this.exaggerationRelativeHeight=defaultValue(c,0),this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}TerrainEncoding.prototype.encode=function(e,t,i,r,n,a,o,s){var l,c,u=r.x,d=r.y;return this.quantization===TerrainQuantization$1.BITS12?((i=Matrix4.multiplyByPoint(this.toScaledENU,i,cartesian3Scratch$3)).x=CesiumMath.clamp(i.x,0,1),i.y=CesiumMath.clamp(i.y,0,1),i.z=CesiumMath.clamp(i.z,0,1),l=this.maximumHeight-this.minimumHeight,c=CesiumMath.clamp((n-this.minimumHeight)/l,0,1),Cartesian2.fromElements(i.x,i.y,cartesian2Scratch),r=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),Cartesian2.fromElements(i.z,c,cartesian2Scratch),l=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),Cartesian2.fromElements(u,d,cartesian2Scratch),c=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),e[t++]=r,e[t++]=l,e[t++]=c,this.hasWebMercatorT&&(Cartesian2.fromElements(o,0,cartesian2Scratch),c=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),e[t++]=c)):(Cartesian3.subtract(i,this.center,cartesian3Scratch$3),e[t++]=cartesian3Scratch$3.x,e[t++]=cartesian3Scratch$3.y,e[t++]=cartesian3Scratch$3.z,e[t++]=n,e[t++]=u,e[t++]=d,this.hasWebMercatorT&&(e[t++]=o)),this.hasVertexNormals&&(e[t++]=AttributeCompression.octPackFloat(a)),this.hasGeodeticSurfaceNormals&&(e[t++]=s.x,e[t++]=s.y,e[t++]=s.z),t};var scratchPosition$c=new Cartesian3,scratchGeodeticSurfaceNormal=new Cartesian3;TerrainEncoding.prototype.addGeodeticSurfaceNormals=function(e,t,i){if(!this.hasGeodeticSurfaceNormals){var r=this.stride,n=e.length/r;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();for(var a=this.stride,o=0;o<n;o++){for(var s=0;s<r;s++)t[o*a+s]=e[o*r+s];var l=this.decodePosition(t,o,scratchPosition$c),c=i.geodeticSurfaceNormal(l,scratchGeodeticSurfaceNormal),l=o*a+this._offsetGeodeticSurfaceNormal;t[l]=c.x,t[l+1]=c.y,t[l+2]=c.z}}},TerrainEncoding.prototype.removeGeodeticSurfaceNormals=function(e,t){if(this.hasGeodeticSurfaceNormals){var i=this.stride,r=e.length/i;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();for(var n=this.stride,a=0;a<r;a++)for(var o=0;o<n;o++)t[a*n+o]=e[a*i+o]}},TerrainEncoding.prototype.decodePosition=function(e,t,i){if(defined(i)||(i=new Cartesian3),t*=this.stride,this.quantization!==TerrainQuantization$1.BITS12)return i.x=e[t],i.y=e[t+1],i.z=e[t+2],Cartesian3.add(i,this.center,i);var r=AttributeCompression.decompressTextureCoordinates(e[t],cartesian2Scratch);i.x=r.x,i.y=r.y;t=AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch);return i.z=t.x,Matrix4.multiplyByPoint(this.fromScaledENU,i,i)},TerrainEncoding.prototype.getExaggeratedPosition=function(e,t,i){i=this.decodePosition(e,t,i);var r,n=this.exaggeration,a=this.exaggerationRelativeHeight;return 1!==n&&this.hasGeodeticSurfaceNormals&&(r=this.decodeGeodeticSurfaceNormal(e,t,scratchGeodeticSurfaceNormal),t=this.decodeHeight(e,t),t=TerrainExaggeration.getHeight(t,n,a)-t,i.x+=r.x*t,i.y+=r.y*t,i.z+=r.z*t),i},TerrainEncoding.prototype.decodeTextureCoordinates=function(e,t,i){return defined(i)||(i=new Cartesian2),t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+2],i):Cartesian2.fromElements(e[t+4],e[t+5],i)},TerrainEncoding.prototype.decodeHeight=function(e,t){return t*=this.stride,this.quantization!==TerrainQuantization$1.BITS12?e[t+3]:AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight},TerrainEncoding.prototype.decodeWebMercatorT=function(e,t){return t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+3],cartesian2Scratch).x:e[t+6]},TerrainEncoding.prototype.getOctEncodedNormal=function(e,t,i){e=e[t=t*this.stride+this._offsetVertexNormal]/256,t=Math.floor(e);return Cartesian2.fromElements(t,256*(e-t),i)},TerrainEncoding.prototype.decodeGeodeticSurfaceNormal=function(e,t,i){return t=t*this.stride+this._offsetGeodeticSurfaceNormal,i.x=e[t],i.y=e[t+1],i.z=e[t+2],i},TerrainEncoding.prototype._calculateStrideAndOffsets=function(){var e=0;this.quantization===TerrainQuantization$1.BITS12?e+=3:e+=6,this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};var attributesIndicesNone={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},attributesIndicesBits12={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};function WebMercatorProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}TerrainEncoding.prototype.getAttributes=function(i){var e,t,r=ComponentDatatype$1.FLOAT,n=ComponentDatatype$1.getSizeInBytes(r),a=this.stride*n,o=0,s=[];function l(e,t){s.push({index:e,vertexBuffer:i,componentDatatype:r,componentsPerAttribute:t,offsetInBytes:o,strideInBytes:a}),o+=t*n}return this.quantization===TerrainQuantization$1.NONE?(l(attributesIndicesNone.position3DAndHeight,4),t=2,t+=this.hasWebMercatorT?1:0,t+=this.hasVertexNormals?1:0,l(attributesIndicesNone.textureCoordAndEncodedNormals,t),this.hasGeodeticSurfaceNormals&&l(attributesIndicesNone.geodeticSurfaceNormal,3)):(e=this.hasWebMercatorT||this.hasVertexNormals,t=this.hasWebMercatorT&&this.hasVertexNormals,l(attributesIndicesBits12.compressed0,e?4:3),t&&l(attributesIndicesBits12.compressed1,1),this.hasGeodeticSurfaceNormals&&l(attributesIndicesBits12.geodeticSurfaceNormal,3)),s},TerrainEncoding.prototype.getAttributeLocations=function(){return this.quantization===TerrainQuantization$1.NONE?attributesIndicesNone:attributesIndicesBits12},TerrainEncoding.clone=function(e,t){if(defined(e))return(t=!defined(t)?new TerrainEncoding:t).quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=Cartesian3.clone(e.center),t.toScaledENU=Matrix4.clone(e.toScaledENU),t.fromScaledENU=Matrix4.clone(e.fromScaledENU),t.matrix=Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t},Object.defineProperties(WebMercatorProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),WebMercatorProjection.mercatorAngleToGeodeticLatitude=function(e){return CesiumMath.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},WebMercatorProjection.geodeticLatitudeToMercatorAngle=function(e){e>WebMercatorProjection.MaximumLatitude?e=WebMercatorProjection.MaximumLatitude:e<-WebMercatorProjection.MaximumLatitude&&(e=-WebMercatorProjection.MaximumLatitude);e=Math.sin(e);return.5*Math.log((1+e)/(1-e))},WebMercatorProjection.MaximumLatitude=WebMercatorProjection.mercatorAngleToGeodeticLatitude(Math.PI),WebMercatorProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,i=WebMercatorProjection.geodeticLatitudeToMercatorAngle(e.latitude)*i,e=e.height;return defined(t)?(t.x=r,t.y=i,t.z=e,t):new Cartesian3(r,i,e)},WebMercatorProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,i=WebMercatorProjection.mercatorAngleToGeodeticLatitude(e.y*i),e=e.z;return defined(t)?(t.longitude=r,t.latitude=i,t.height=e,t):new Cartographic(r,i,e)};var HeightmapTessellator={};HeightmapTessellator.DEFAULT_STRUCTURE=Object.freeze({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var cartesian3Scratch$2=new Cartesian3,matrix4Scratch=new Matrix4,minimumScratch=new Cartesian3,maximumScratch=new Cartesian3;function returnTrue(){return!0}function destroyObject(e,t){function i(){}for(var r in e)"function"==typeof e[r]&&(e[r]=i);e.isDestroyed=returnTrue}function canTransferArrayBuffer(){if(!defined(TaskProcessor._canTransferArrayBuffer)){var t=new Worker(getWorkerUrl("Workers/transferTypedArrayTest.js"));t.postMessage=defaultValue(t.webkitPostMessage,t.postMessage);var e=new Int8Array([99]);try{t.postMessage({array:e},[e.buffer])}catch(e){return TaskProcessor._canTransferArrayBuffer=!1,TaskProcessor._canTransferArrayBuffer}var i=when.defer();t.onmessage=function(e){e=e.data.array,e=defined(e)&&99===e[0];i.resolve(e),t.terminate(),TaskProcessor._canTransferArrayBuffer=e},TaskProcessor._canTransferArrayBuffer=i.promise}return TaskProcessor._canTransferArrayBuffer}HeightmapTessellator.computeVertices=function(e){var t,i,r,n=Math.cos,a=Math.sin,o=Math.sqrt,s=Math.atan,l=Math.exp,c=CesiumMath.PI_OVER_TWO,u=CesiumMath.toRadians,d=e.heightmap,h=e.width,p=e.height,f=e.skirtHeight,m=0<f,g=defaultValue(e.isGeographic,!0),_=defaultValue(e.ellipsoid,Ellipsoid.WGS84),y=1/_.maximumRadius,C=Rectangle.clone(e.nativeRectangle),v=Rectangle.clone(e.rectangle),T=defined(v)?(t=v.west,i=v.south,r=v.east,v.north):g?(t=u(C.west),i=u(C.south),r=u(C.east),u(C.north)):(t=C.west*y,i=c-2*s(l(-C.south*y)),r=C.east*y,c-2*s(l(-C.north*y))),S=defined(A=e.relativeToCenter),A=S?A:Cartesian3.ZERO,x=defaultValue(e.includeWebMercatorT,!1),b=defaultValue(e.exaggeration,1),E=defaultValue(e.exaggerationRelativeHeight,0),P=1!==b,e=defaultValue(e.structure,HeightmapTessellator.DEFAULT_STRUCTURE),D=defaultValue(e.heightScale,HeightmapTessellator.DEFAULT_STRUCTURE.heightScale),w=defaultValue(e.heightOffset,HeightmapTessellator.DEFAULT_STRUCTURE.heightOffset),M=defaultValue(e.elementsPerHeight,HeightmapTessellator.DEFAULT_STRUCTURE.elementsPerHeight),I=defaultValue(e.stride,HeightmapTessellator.DEFAULT_STRUCTURE.stride),R=defaultValue(e.elementMultiplier,HeightmapTessellator.DEFAULT_STRUCTURE.elementMultiplier),O=defaultValue(e.isBigEndian,HeightmapTessellator.DEFAULT_STRUCTURE.isBigEndian),B=Rectangle.computeWidth(C),L=Rectangle.computeHeight(C),F=B/(h-1),N=L/(p-1);g||(B*=y,L*=y);var V,k,e=_.radiiSquared,G=e.x,U=e.y,$=e.z,z=65536,H=-65536,e=Transforms.eastNorthUpToFixedFrame(A,_),W=Matrix4.inverseTransformation(e,matrix4Scratch);x&&(V=WebMercatorProjection.geodeticLatitudeToMercatorAngle(i),k=1/(WebMercatorProjection.geodeticLatitudeToMercatorAngle(T)-V));var q=minimumScratch;q.x=Number.POSITIVE_INFINITY,q.y=Number.POSITIVE_INFINITY,q.z=Number.POSITIVE_INFINITY;var j=maximumScratch;j.x=Number.NEGATIVE_INFINITY,j.y=Number.NEGATIVE_INFINITY,j.z=Number.NEGATIVE_INFINITY;var X=Number.POSITIVE_INFINITY,K=h*p,Y=K+(0<f?2*h+2*p:0),J=new Array(Y),Q=new Array(Y),Z=new Array(Y),ee=x?new Array(Y):[],te=P?new Array(Y):[],ie=0,re=p,ne=0,ae=h;m&&(--ie,++re,--ne,++ae);for(var oe=ie;oe<re;++oe){var se=oe;p<=(se=se<0?0:se)&&(se=p-1);var le=C.north-N*se,le=g?u(le):c-2*s(l(-le*y)),ce=CesiumMath.clamp(ce=(le-i)/(T-i),0,1),ue=oe===ie,de=oe===re-1;0<f&&(ue?le+=1e-5*L:de&&(le-=1e-5*L));var he,pe=n(le),fe=a(le),me=$*fe;x&&(he=(WebMercatorProjection.geodeticLatitudeToMercatorAngle(le)-V)*k);for(var ge=ne;ge<ae;++ge){var _e=ge,ye=se*(h*I)+(_e=h<=(_e=_e<0?0:_e)?h-1:_e)*I;if(1===M)ve=d[ye];else{var Ce,ve=0;if(O)for(Ce=0;Ce<M;++Ce)ve=ve*R+d[ye+Ce];else for(Ce=M-1;0<=Ce;--Ce)ve=ve*R+d[ye+Ce]}ve=ve*D+w;var H=Math.max(H,ve),z=Math.min(z,ve),Te=C.west+F*_e;g?Te=u(Te):Te*=y;var Se=CesiumMath.clamp(Se=(Te-t)/(r-t),0,1),Ae=se*h+_e;if(0<f){var xe=ge===ne,be=ge===ae-1,Ee=ue||de||xe||be;if((ue||de)&&(xe||be))continue;Ee&&(ve-=f,xe?(Ae=p-se-1+K,Te-=1e-5*B):de?Ae=K+p+(h-_e-1):be?(Ae=K+p+h+se,Te+=1e-5*B):ue&&(Ae=K+p+h+p+_e))}var Pe=pe*n(Te),Ee=pe*a(Te),xe=G*Pe,be=U*Ee,_e=1/o(xe*Pe+be*Ee+me*fe),Te=xe*_e,xe=be*_e,be=me*_e,_e=new Cartesian3;_e.x=Te+Pe*ve,_e.y=xe+Ee*ve,_e.z=be+fe*ve,Matrix4.multiplyByPoint(W,_e,cartesian3Scratch$2),Cartesian3.minimumByComponent(cartesian3Scratch$2,q,q),Cartesian3.maximumByComponent(cartesian3Scratch$2,j,j),X=Math.min(X,ve),J[Ae]=_e,Z[Ae]=new Cartesian2(Se,ce),Q[Ae]=ve,x&&(ee[Ae]=he),P&&(te[Ae]=_.geodeticSurfaceNormal(_e))}}var De,we,m=BoundingSphere.fromPoints(J);defined(v)&&(De=OrientedBoundingBox.fromRectangle(v,z,H,_)),S&&(we=new EllipsoidalOccluder(_).computeHorizonCullingPointPossiblyUnderEllipsoid(A,J,z));for(var Me=new TerrainEncoding(A,new AxisAlignedBoundingBox(q,j,A),X,H,e,!1,x,P,b,E),Ie=new Float32Array(Y*Me.stride),Re=0,Oe=0;Oe<Y;++Oe)Re=Me.encode(Ie,Re,J[Oe],Z[Oe],Q[Oe],void 0,ee[Oe],te[Oe]);return{vertices:Ie,maximumHeight:H,minimumHeight:z,encoding:Me,boundingSphere3D:m,orientedBoundingBox:De,occludeePointInScaledSpace:we}};var taskCompletedEvent=new Event,bootstrapperUrlResult;function completeTask(e,t){--e._activeTasks;var i,r,n=t.id;defined(n)&&(r=(i=e._deferreds)[n],defined(t.error)?("RuntimeError"===(e=t.error).name?(e=new RuntimeError(t.error.message)).stack=t.error.stack:"DeveloperError"===e.name&&((e=new DeveloperError(t.error.message)).stack=t.error.stack),taskCompletedEvent.raiseEvent(e),r.reject(e)):(taskCompletedEvent.raiseEvent(),r.resolve(t.result)),delete i[n])}function getWorkerUrl(t){if(isCrossOriginUrl(e=buildModuleUrl(t))){var i,r='importScripts("'+e+'");';try{i=new Blob([r],{type:"application/javascript"})}catch(e){t=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder);t.append(r),i=t.getBlob("application/javascript")}var e=(window.URL||window.webkitURL).createObjectURL(i)}return e}function getBootstrapperUrl(){return bootstrapperUrlResult=!defined(bootstrapperUrlResult)?getWorkerUrl("Workers/cesiumWorkerBootstrapper.js"):bootstrapperUrlResult}function createWorker(t){var e=new Worker(getBootstrapperUrl());e.postMessage=defaultValue(e.webkitPostMessage,e.postMessage);var i={loaderConfig:{paths:{Workers:buildModuleUrl("Workers")},baseUrl:buildModuleUrl.getCesiumBaseUrl().url},workerModule:t._workerPath};return e.postMessage(i),e.onmessage=function(e){completeTask(t,e.data)},e}function getWebAssemblyLoaderConfig(e,t){var i={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(FeatureDetection.supportsWebAssembly())return i.modulePath=buildModuleUrl(t.modulePath),i.wasmBinaryFile=buildModuleUrl(t.wasmBinaryFile),Resource.fetchArrayBuffer({url:i.wasmBinaryFile}).then(function(e){return i.wasmBinary=e,i});if(!defined(t.fallbackModulePath))throw new RuntimeError("This browser does not support Web Assembly, and no backup module was provided for "+e._workerPath);return i.modulePath=buildModuleUrl(t.fallbackModulePath),when.resolve(i)}function TaskProcessor(e,t){var i=new URI(e);this._workerPath=0!==i.scheme().length&&0===i.fragment().length?e:TaskProcessor._workerModulePrefix+e,this._maximumActiveTasks=defaultValue(t,Number.POSITIVE_INFINITY),this._activeTasks=0,this._deferreds={},this._nextID=0}var emptyTransferableObjectArray=[];function TerrainData(){DeveloperError.throwInstantiationError()}function TerrainMesh(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){this.center=e,this.vertices=t,this.stride=defaultValue(c,6),this.indices=i,this.indexCountWithoutSkirts=r,this.vertexCountWithoutSkirts=n,this.minimumHeight=a,this.maximumHeight=o,this.boundingSphere3D=s,this.occludeePointInScaledSpace=l,this.orientedBoundingBox=u,this.encoding=d,this.westIndicesSouthToNorth=h,this.southIndicesEastToWest=p,this.eastIndicesNorthToSouth=f,this.northIndicesWestToEast=m}TaskProcessor.prototype.scheduleTask=function(r,n){if(defined(this._worker)||(this._worker=createWorker(this)),!(this._activeTasks>=this._maximumActiveTasks)){++this._activeTasks;var a=this;return when(canTransferArrayBuffer(),function(e){defined(n)?e||(n.length=0):n=emptyTransferableObjectArray;var t=a._nextID++,i=when.defer();return a._deferreds[t]=i,a._worker.postMessage({id:t,parameters:r,canTransferArrayBuffer:e},n),i.promise})}},TaskProcessor.prototype.initWebAssemblyModule=function(e){defined(this._worker)||(this._worker=createWorker(this));var n=when.defer(),a=this,o=this._worker;return getWebAssemblyLoaderConfig(this,e).then(function(r){return when(canTransferArrayBuffer(),function(e){var t,i=r.wasmBinary;defined(i)&&e&&(t=[i]),o.onmessage=function(e){o.onmessage=function(e){completeTask(a,e.data)},n.resolve(e.data)},o.postMessage({webAssemblyConfig:r},t)})}),n},TaskProcessor.prototype.isDestroyed=function(){return!1},TaskProcessor.prototype.destroy=function(){return defined(this._worker)&&this._worker.terminate(),destroyObject(this)},TaskProcessor.taskCompletedEvent=taskCompletedEvent,TaskProcessor._defaultWorkerModulePrefix="Workers/",TaskProcessor._workerModulePrefix=TaskProcessor._defaultWorkerModulePrefix,TaskProcessor._canTransferArrayBuffer=void 0,Object.defineProperties(TerrainData.prototype,{credits:{get:DeveloperError.throwInstantiationError},waterMask:{get:DeveloperError.throwInstantiationError}}),TerrainData.prototype.interpolateHeight=DeveloperError.throwInstantiationError,TerrainData.prototype.isChildAvailable=DeveloperError.throwInstantiationError,TerrainData.prototype.createMesh=DeveloperError.throwInstantiationError,TerrainData.prototype.upsample=DeveloperError.throwInstantiationError,TerrainData.prototype.wasCreatedByUpsampling=DeveloperError.throwInstantiationError,TerrainData.maximumAsynchronousTasks=5;var IndexDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case IndexDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},fromSizeInBytes:function(e){switch(e){case 2:return IndexDatatype.UNSIGNED_SHORT;case 4:return IndexDatatype.UNSIGNED_INT;case 1:return IndexDatatype.UNSIGNED_BYTE}},validate:function(e){return defined(e)&&(e===IndexDatatype.UNSIGNED_BYTE||e===IndexDatatype.UNSIGNED_SHORT||e===IndexDatatype.UNSIGNED_INT)},createTypedArray:function(e,t){return new(e>=CesiumMath.SIXTY_FOUR_KILOBYTES?Uint32Array:Uint16Array)(t)},createTypedArrayFromArrayBuffer:function(e,t,i,r){return new(e>=CesiumMath.SIXTY_FOUR_KILOBYTES?Uint32Array:Uint16Array)(t,i,r)}},IndexDatatype$1=Object.freeze(IndexDatatype);function TerrainProvider(){DeveloperError.throwInstantiationError()}Object.defineProperties(TerrainProvider.prototype,{errorEvent:{get:DeveloperError.throwInstantiationError},credit:{get:DeveloperError.throwInstantiationError},tilingScheme:{get:DeveloperError.throwInstantiationError},ready:{get:DeveloperError.throwInstantiationError},readyPromise:{get:DeveloperError.throwInstantiationError},hasWaterMask:{get:DeveloperError.throwInstantiationError},hasVertexNormals:{get:DeveloperError.throwInstantiationError},availability:{get:DeveloperError.throwInstantiationError}});var regularGridIndicesCache=[];TerrainProvider.getRegularGridIndices=function(e,t){var i=regularGridIndicesCache[e];defined(i)||(regularGridIndicesCache[e]=i=[]);var r=i[t];return defined(r)||addRegularGridIndices(e,t,r=e*t<CesiumMath.SIXTY_FOUR_KILOBYTES?i[t]=new Uint16Array((e-1)*(t-1)*6):i[t]=new Uint32Array((e-1)*(t-1)*6),0),r};var regularGridAndEdgeIndicesCache=[];TerrainProvider.getRegularGridIndicesAndEdgeIndices=function(e,t){var i=regularGridAndEdgeIndicesCache[e];defined(i)||(regularGridAndEdgeIndicesCache[e]=i=[]);var r,n,a,o,s=i[t];return defined(s)||(r=TerrainProvider.getRegularGridIndices(e,t),n=(o=getEdgeIndices(e,t)).westIndicesSouthToNorth,a=o.southIndicesEastToWest,e=o.eastIndicesNorthToSouth,o=o.northIndicesWestToEast,s=i[t]={indices:r,westIndicesSouthToNorth:n,southIndicesEastToWest:a,eastIndicesNorthToSouth:e,northIndicesWestToEast:o}),s};var regularGridAndSkirtAndEdgeIndicesCache=[];function getEdgeIndices(e,t){for(var i=new Array(t),r=new Array(e),n=new Array(t),a=new Array(e),o=0;o<e;++o)r[a[o]=o]=e*t-1-o;for(o=0;o<t;++o)n[o]=(o+1)*e-1,i[o]=(t-o-1)*e;return{westIndicesSouthToNorth:i,southIndicesEastToWest:r,eastIndicesNorthToSouth:n,northIndicesWestToEast:a}}function addRegularGridIndices(e,t,i,r){for(var n=0,a=0;a<t-1;++a){for(var o=0;o<e-1;++o){var s=n,l=s+e,c=l+1,u=s+1;i[r++]=s,i[r++]=l,i[r++]=u,i[r++]=u,i[r++]=l,i[r++]=c,++n}++n}}function addSkirtIndices(e,t,i,r){for(var n=e[0],a=e.length,o=1;o<a;++o){var s=e[o];i[r++]=n,i[r++]=s,i[r++]=t,i[r++]=t,i[r++]=s,i[r++]=t+1,n=s,++t}return r}function HeightmapTerrainData(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=defaultValue(e.childTileMask,15),this._encoding=defaultValue(e.encoding,HeightmapEncoding$1.NONE);var t=HeightmapTessellator.DEFAULT_STRUCTURE,i=e.structure;defined(i)?i!==t&&(i.heightScale=defaultValue(i.heightScale,t.heightScale),i.heightOffset=defaultValue(i.heightOffset,t.heightOffset),i.elementsPerHeight=defaultValue(i.elementsPerHeight,t.elementsPerHeight),i.stride=defaultValue(i.stride,t.stride),i.elementMultiplier=defaultValue(i.elementMultiplier,t.elementMultiplier),i.isBigEndian=defaultValue(i.isBigEndian,t.isBigEndian)):i=t,this._structure=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===HeightmapEncoding$1.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices=function(e,t){var i=regularGridAndSkirtAndEdgeIndicesCache[e];defined(i)||(regularGridAndSkirtAndEdgeIndicesCache[e]=i=[]);var r,n,a,o,s,l,c,u,d=i[t];return defined(d)||(a=(r=e*t)+(l=2*e+2*t),u=(n=(e-1)*(t-1)*6)+6*Math.max(0,l-4),o=(c=getEdgeIndices(e,t)).westIndicesSouthToNorth,s=c.southIndicesEastToWest,l=c.eastIndicesNorthToSouth,c=c.northIndicesWestToEast,addRegularGridIndices(e,t,u=IndexDatatype$1.createTypedArray(a,u),0),TerrainProvider.addSkirtIndices(o,s,l,c,r,u,n),d=i[t]={indices:u,westIndicesSouthToNorth:o,southIndicesEastToWest:s,eastIndicesNorthToSouth:l,northIndicesWestToEast:c,indexCountWithoutSkirts:n}),d},TerrainProvider.addSkirtIndices=function(e,t,i,r,n,a,o){o=addSkirtIndices(e,n,a,o),o=addSkirtIndices(t,n+=e.length,a,o),o=addSkirtIndices(i,n+=t.length,a,o),addSkirtIndices(r,n+=i.length,a,o)},TerrainProvider.heightmapTerrainQuality=.25,TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,i){return 2*e.maximumRadius*Math.PI*TerrainProvider.heightmapTerrainQuality/(t*i)},TerrainProvider.prototype.requestTileGeometry=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getLevelMaximumGeometricError=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getTileDataAvailable=DeveloperError.throwInstantiationError,TerrainProvider.prototype.loadTileDataAvailability=DeveloperError.throwInstantiationError,Object.defineProperties(HeightmapTerrainData.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});var createMeshTaskName$2="createVerticesFromHeightmap",createMeshTaskProcessorNoThrottle$2=new TaskProcessor(createMeshTaskName$2),createMeshTaskProcessorThrottle$2=new TaskProcessor(createMeshTaskName$2,TerrainData.maximumAsynchronousTasks);function interpolateHeight$2(e,t,i,r,n,a,o,s,l,c){var u=(l-a.west)*(o-1)/(a.east-a.west),d=(c-a.south)*(s-1)/(a.north-a.south),h=0|u,l=h+1;o<=l&&(l=o-1,h=o-2);c=0|d;s<=(a=c+1)&&(a=s-1,c=s-2);a=s-1-a;return triangleInterpolateHeight(u-h,d-c,getHeight(e,t,i,r,n,(c=s-1-c)*o+h),getHeight(e,t,i,r,n,c*o+l),getHeight(e,t,i,r,n,a*o+h),getHeight(e,t,i,r,n,a*o+l))}function interpolateMeshHeight$2(e,t,i,r,n,a,o,s,l){var c=(s-n.west)*(a-1)/(n.east-n.west),u=(l-n.south)*(o-1)/(n.north-n.south),d=0|c,s=d+1;a<=s&&(s=a-1,d=a-2),o<=(n=(l=0|u)+1)&&(n=o-1,l=o-2);u-=l,l=o-1-l,n=o-1-n;return triangleInterpolateHeight(c-d,u,(t.decodeHeight(e,l*a+d)-i)/r,(t.decodeHeight(e,l*a+s)-i)/r,(t.decodeHeight(e,n*a+d)-i)/r,(t.decodeHeight(e,n*a+s)-i)/r)}function triangleInterpolateHeight(e,t,i,r,n,a){return t<e?i+e*(r-i)+t*(a-r):i+e*(a-n)+t*(n-i)}function getHeight(e,t,i,r,n,a){a*=r;var o,s=0;if(n)for(o=0;o<t;++o)s=s*i+e[a+o];else for(o=t-1;0<=o;--o)s=s*i+e[a+o];return s}function setHeight(e,t,i,r,n,a,o,s){var l;if(o*=n,a)for(l=0;l<t-1;++l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;else for(l=t-1;0<l;--l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;e[o+l]=s}function TileAvailability(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}HeightmapTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),l=t.ellipsoid,c=t.tileXYToNativeRectangle(i,r,n),e=t.tileXYToRectangle(i,r,n),u=l.cartographicToCartesian(Rectangle.center(e)),i=this._structure,r=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(l,this._width,t.getNumberOfXTilesAtLevel(0));this._skirtHeight=Math.min(4*(r/(1<<n)),1e3);o=(s?createMeshTaskProcessorThrottle$2:createMeshTaskProcessorNoThrottle$2).scheduleTask({heightmap:this._buffer,structure:i,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:c,rectangle:e,relativeToCenter:u,ellipsoid:l,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:a,exaggerationRelativeHeight:o,encoding:this._encoding});if(defined(o)){var d=this;return when(o,function(e){var t=0<d._skirtHeight?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(e.gridWidth,e.gridHeight):TerrainProvider.getRegularGridIndicesAndEdgeIndices(e.gridWidth,e.gridHeight),i=e.gridWidth*e.gridHeight;return d._mesh=new TerrainMesh(u,new Float32Array(e.vertices),t.indices,t.indexCountWithoutSkirts,i,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),t.westIndicesSouthToNorth,t.southIndicesEastToWest,t.eastIndicesNorthToSouth,t.northIndicesWestToEast),d._buffer=void 0,d._mesh})}},HeightmapTerrainData.prototype._createMeshSync=function(e){var t=e.tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=t.ellipsoid,l=t.tileXYToNativeRectangle(i,r,n),c=t.tileXYToRectangle(i,r,n),e=s.cartographicToCartesian(Rectangle.center(c)),i=this._structure,r=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(s,this._width,t.getNumberOfXTilesAtLevel(0));this._skirtHeight=Math.min(4*(r/(1<<n)),1e3);t=HeightmapTessellator.computeVertices({heightmap:this._buffer,structure:i,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:l,rectangle:c,relativeToCenter:e,ellipsoid:s,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:a,exaggerationRelativeHeight:o});this._buffer=void 0;a=0<this._skirtHeight?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(this._width,this._height):TerrainProvider.getRegularGridIndicesAndEdgeIndices(this._width,this._height),o=t.gridWidth*t.gridHeight;return this._mesh=new TerrainMesh(e,t.vertices,a.indices,a.indexCountWithoutSkirts,o,t.minimumHeight,t.maximumHeight,t.boundingSphere3D,t.occludeePointInScaledSpace,t.encoding.stride,t.orientedBoundingBox,t.encoding,a.westIndicesSouthToNorth,a.southIndicesEastToWest,a.eastIndicesNorthToSouth,a.northIndicesWestToEast),this._mesh},HeightmapTerrainData.prototype.interpolateHeight=function(e,t,i){var r=this._width,n=this._height,a=this._structure,o=a.stride,s=a.elementsPerHeight,l=a.elementMultiplier,c=a.isBigEndian,u=a.heightOffset,d=a.heightScale,h=defined(this._mesh),a=this._encoding===HeightmapEncoding$1.LERC,a=!h&&a;if(!a)return h?interpolateMeshHeight$2(this._mesh.vertices,this._mesh.encoding,u,d,e,r,n,t,i):interpolateHeight$2(this._buffer,s,l,o,c,e,r,n,t,i)*d+u},HeightmapTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(s)){for(var l=this._width,c=this._height,u=this._structure,d=u.stride,h=new this._bufferType(l*c*d),p=s.vertices,f=s.encoding,m=e.tileXYToRectangle(t,i,r),g=e.tileXYToRectangle(n,a,o),_=u.heightOffset,y=u.heightScale,C=u.elementsPerHeight,v=u.elementMultiplier,T=u.isBigEndian,S=Math.pow(v,C-1),A=0;A<c;++A)for(var x=CesiumMath.lerp(g.north,g.south,A/(c-1)),b=0;b<l;++b){var E=interpolateMeshHeight$2(p,f,_,y,m,l,c,CesiumMath.lerp(g.west,g.east,b/(l-1)),x);setHeight(h,C,v,S,d,T,A*l+b,E=(E=E<u.lowestEncodedHeight?u.lowestEncodedHeight:E)>u.highestEncodedHeight?u.highestEncodedHeight:E)}return new HeightmapTerrainData({buffer:h,width:l,height:c,childTileMask:0,structure:this._structure,createdByUpsampling:!0})}},HeightmapTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},HeightmapTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var rectangleScratch$6=new Rectangle;function findNode$1(e,t,i,r){for(var n=r.length,a=0;a<n;++a){var o=r[a];if(o.x===t&&o.y===i&&o.level===e)return 1}}TileAvailability.prototype.addAvailableTileRange=function(e,t,i,r,n){var a=this._tilingScheme,o=this._rootNodes;if(0===e)for(var s=i;s<=n;++s)for(var l=t;l<=r;++l)findNode$1(e,l,s,o)||o.push(new QuadtreeNode(a,void 0,0,l,s));a.tileXYToRectangle(t,i,e,rectangleScratch$6);var c=rectangleScratch$6.west,u=rectangleScratch$6.north;a.tileXYToRectangle(r,n,e,rectangleScratch$6);for(var i=rectangleScratch$6.east,d=new RectangleWithLevel(e,c,rectangleScratch$6.south,i,u),h=0;h<o.length;++h){var p=o[h];rectanglesOverlap(p.extent,d)&&putRectangleInQuadtree(this._maximumLevel,p,d)}},TileAvailability.prototype.computeMaximumLevelAtPosition=function(e){for(var t,i=0;i<this._rootNodes.length;++i){var r=this._rootNodes[i];if(rectangleContainsPosition(r.extent,e)){t=r;break}}return defined(t)?findMaxLevelFromNode(void 0,t,e):-1};var rectanglesScratch=[],remainingToCoverByLevelScratch=[],westScratch$1=new Rectangle,eastScratch=new Rectangle;TileAvailability.prototype.computeBestAvailableLevelOverRectangle=function(e){var t=rectanglesScratch;t.length=0,e.east<e.west?(t.push(Rectangle.fromRadians(-Math.PI,e.south,e.east,e.north,westScratch$1)),t.push(Rectangle.fromRadians(e.west,e.south,Math.PI,e.north,eastScratch))):t.push(e);for(var i=remainingToCoverByLevelScratch,r=i.length=0;r<this._rootNodes.length;++r)updateCoverageWithNode(i,this._rootNodes[r],t);for(r=i.length-1;0<=r;--r)if(defined(i[r])&&0===i[r].length)return r;return 0};var cartographicScratch$4=new Cartographic;function QuadtreeNode(e,t,i,r,n){this.tilingScheme=e,this.parent=t,this.level=i,this.x=r,this.y=n,this.extent=e.tileXYToRectangle(r,n,i),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}function RectangleWithLevel(e,t,i,r,n){this.level=e,this.west=t,this.south=i,this.east=r,this.north=n}function rectanglesOverlap(e,t){var i=Math.max(e.west,t.west),r=Math.max(e.south,t.south),n=Math.min(e.east,t.east);return r<Math.min(e.north,t.north)&&i<n}function putRectangleInQuadtree(e,t,i){for(;t.level<e;)if(rectangleFullyContainsRectangle(t.nw.extent,i))t=t.nw;else if(rectangleFullyContainsRectangle(t.ne.extent,i))t=t.ne;else if(rectangleFullyContainsRectangle(t.sw.extent,i))t=t.sw;else{if(!rectangleFullyContainsRectangle(t.se.extent,i))break;t=t.se}var r;0===t.rectangles.length||t.rectangles[t.rectangles.length-1].level<=i.level?t.rectangles.push(i):(r=binarySearch(t.rectangles,i.level,rectangleLevelComparator),t.rectangles.splice(r=r<0?~r:r,0,i))}function rectangleLevelComparator(e,t){return e.level-t}function rectangleFullyContainsRectangle(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function rectangleContainsPosition(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function findMaxLevelFromNode(e,t,i){for(var r=0,n=!1;!n;){var a=t._nw&&rectangleContainsPosition(t._nw.extent,i),o=t._ne&&rectangleContainsPosition(t._ne.extent,i),s=t._sw&&rectangleContainsPosition(t._sw.extent,i),l=t._se&&rectangleContainsPosition(t._se.extent,i);if(1<a+o+s+l){a&&(r=Math.max(r,findMaxLevelFromNode(t,t._nw,i))),o&&(r=Math.max(r,findMaxLevelFromNode(t,t._ne,i))),s&&(r=Math.max(r,findMaxLevelFromNode(t,t._sw,i))),l&&(r=Math.max(r,findMaxLevelFromNode(t,t._se,i)));break}a?t=t._nw:o?t=t._ne:s?t=t._sw:l?t=t._se:n=!0}for(;t!==e;){for(var c=t.rectangles,u=c.length-1;0<=u&&c[u].level>r;--u){var d=c[u];rectangleContainsPosition(d,i)&&(r=d.level)}t=t.parent}return r}function updateCoverageWithNode(e,t,i){if(t){var r=!1;for(a=0;a<i.length;++a)r=r||rectanglesOverlap(t.extent,i[a]);if(r){for(var n=t.rectangles,a=0;a<n.length;++a){var o=n[a];e[o.level]||(e[o.level]=i),e[o.level]=subtractRectangle(e[o.level],o)}updateCoverageWithNode(e,t._nw,i),updateCoverageWithNode(e,t._ne,i),updateCoverageWithNode(e,t._sw,i),updateCoverageWithNode(e,t._se,i)}}}function subtractRectangle(e,t){for(var i=[],r=0;r<e.length;++r){var n=e[r];rectanglesOverlap(n,t)?(n.west<t.west&&i.push(new Rectangle(n.west,n.south,t.west,n.north)),n.east>t.east&&i.push(new Rectangle(t.east,n.south,n.east,n.north)),n.south<t.south&&i.push(new Rectangle(Math.max(t.west,n.west),n.south,Math.min(t.east,n.east),t.south)),n.north>t.north&&i.push(new Rectangle(Math.max(t.west,n.west),t.north,Math.min(t.east,n.east),n.north))):i.push(n)}return i}function formatError(e){var t=e.name,i=e.message,i=defined(t)&&defined(i)?t+": "+i:e.toString(),e=e.stack;return defined(e)&&(i+="\n"+e),i}function TileProviderError(e,t,i,r,n,a,o){this.provider=e,this.message=t,this.x=i,this.y=r,this.level=n,this.timesRetried=defaultValue(a,0),this.retry=!1,this.error=o}function WebMercatorTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1),this._projection=new WebMercatorProjection(this._ellipsoid),defined(e.rectangleSouthwestInMeters)&&defined(e.rectangleNortheastInMeters)?(this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters):(t=this._ellipsoid.maximumRadius*Math.PI,this._rectangleSouthwestInMeters=new Cartesian2(-t,-t),this._rectangleNortheastInMeters=new Cartesian2(t,t));var e=this._projection.unproject(this._rectangleSouthwestInMeters),t=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new Rectangle(e.longitude,e.latitude,t.longitude,t.latitude)}TileAvailability.prototype.isTileAvailable=function(e,t,i){i=this._tilingScheme.tileXYToRectangle(t,i,e,rectangleScratch$6);return Rectangle.center(i,cartographicScratch$4),this.computeMaximumLevelAtPosition(cartographicScratch$4)>=e},TileAvailability.prototype.computeChildMaskForTile=function(e,t,i){var r=e+1;if(r>=this._maximumLevel)return 0;e=0;return e|=this.isTileAvailable(r,2*t,2*i+1)?1:0,e|=this.isTileAvailable(r,2*t+1,2*i+1)?2:0,e|=this.isTileAvailable(r,2*t,2*i)?4:0,e|=this.isTileAvailable(r,2*t+1,2*i)?8:0},Object.defineProperties(QuadtreeNode.prototype,{nw:{get:function(){return this._nw||(this._nw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y+1)),this._sw}},se:{get:function(){return this._se||(this._se=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y+1)),this._se}}}),TileProviderError.handleError=function(e,t,i,r,n,a,o,s,l){var c=e;return defined(e)?(c.provider=t,c.message=r,c.x=n,c.y=a,c.level=o,c.retry=!1,c.error=l,++c.timesRetried):c=new TileProviderError(t,r,n,a,o,0,l),0<i.numberOfListeners?i.raiseEvent(c):console.log('An error occurred in "'+t.constructor.name+'": '+formatError(r)),c.retry&&defined(s)&&s(),c},TileProviderError.handleSuccess=function(e){defined(e)&&(e.timesRetried=-1)},Object.defineProperties(WebMercatorTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),WebMercatorTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},WebMercatorTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},WebMercatorTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,r=i.project(Rectangle.southwest(e)),e=i.project(Rectangle.northeast(e));return defined(t)?(t.west=r.x,t.south=r.y,t.east=e.x,t.north=e.y,t):new Rectangle(r.x,r.y,e.x,e.y)},WebMercatorTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.getNumberOfXTilesAtLevel(i),a=this.getNumberOfYTilesAtLevel(i),i=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,n=this._rectangleSouthwestInMeters.x+e*i,e=this._rectangleSouthwestInMeters.x+(e+1)*i,i=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,a=this._rectangleNortheastInMeters.y-t*i,i=this._rectangleNortheastInMeters.y-(t+1)*i;return defined(r)?(r.west=n,r.south=i,r.east=e,r.north=a,r):new Rectangle(n,i,e,a)},WebMercatorTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){t=this.tileXYToNativeRectangle(e,t,i,r),i=this._projection,r=i.unproject(new Cartesian2(t.west,t.south)),i=i.unproject(new Cartesian2(t.east,t.north));return t.west=r.longitude,t.south=r.latitude,t.east=i.longitude,t.north=i.latitude,t},WebMercatorTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),r=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,t=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,e=this._projection.project(e),r=(e.x-this._rectangleSouthwestInMeters.x)/r|0;n<=r&&(r=n-1);t=(this._rectangleNortheastInMeters.y-e.y)/t|0;return(a<=t&&(t=a-1),defined(i))?(i.x=r,i.y=t,i):new Cartesian2(r,t)}};var ALL_CHILDREN=15;function ArcGISTiledElevationTerrainProvider(e){this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._ready=!1,this._width=void 0,this._height=void 0,this._encoding=void 0;var t=e.token;this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailablityLoaded=void 0,this._availableCache={};var n=this,a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._readyPromise=when(e.url).then(function(e){e=Resource.createIfNeeded(e);return e.appendForwardSlash(),defined(t)&&(e=e.getDerivedResource({queryParameters:{token:t}})),(n._resource=e).getDerivedResource({queryParameters:{f:"pjson"}}).fetchJson()}).then(function(e){var t=e.copyrightText;defined(t)&&(n._credit=new Credit(t));var i=e.spatialReference,r=defaultValue(i.latestWkid,i.wkid),t=e.extent,i={ellipsoid:a};if(4326===r)i.rectangle=Rectangle.fromDegrees(t.xmin,t.ymin,t.xmax,t.ymax),n._tilingScheme=new GeographicTilingScheme(i);else{if(3857!==r)return when.reject(new RuntimeError("Invalid spatial reference"));i.rectangleSouthwestInMeters=new Cartesian2(t.xmin,t.ymin),i.rectangleNortheastInMeters=new Cartesian2(t.xmax,t.ymax),n._tilingScheme=new WebMercatorTilingScheme(i)}i=e.tileInfo;return defined(i)?(n._width=i.rows+1,n._height=i.cols+1,n._encoding="LERC"===i.format?HeightmapEncoding$1.LERC:HeightmapEncoding$1.NONE,n._lodCount=i.lods.length-1,(n._hasAvailability=-1!==e.capabilities.indexOf("Tilemap"))&&(n._tilesAvailable=new TileAvailability(n._tilingScheme,n._lodCount),n._tilesAvailable.addAvailableTileRange(0,0,0,n._tilingScheme.getNumberOfXTilesAtLevel(0),n._tilingScheme.getNumberOfYTilesAtLevel(0)),n._tilesAvailablityLoaded=new TileAvailability(n._tilingScheme,n._lodCount)),n._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(n._tilingScheme.ellipsoid,n._width,n._tilingScheme.getNumberOfXTilesAtLevel(0)),1<e.bandCount&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),n._terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:e.minValues[0],highestEncodedHeight:e.maxValues[0]},n._ready=!0):when.reject(new RuntimeError("tileInfo is required"))}).otherwise(function(e){var t="An error occurred while accessing "+n._resource.url+".";return TileProviderError.handleError(void 0,n,n._errorEvent,t),when.reject(e)}),this._errorEvent=new Event}function isTileAvailable(e,t,i,r){if(e._hasAvailability){var n=e._tilesAvailablityLoaded,a=e._tilesAvailable;return!(t>e._lodCount)&&(!!a.isTileAvailable(t,i,r)||!n.isTileAvailable(t,i,r)&&void 0)}}function findRange(e,t,i,r){for(var n=t-1,a=i-1,o=r[e.y*t+e.x],s=[],l={startX:e.x,startY:e.y,endX:0,endY:0},c=new Cartesian2(e.x+1,e.y+1),u=!1,d=!1;!u||!d;){var h=c.x,p=d?c.y+1:c.y;if(!u){for(var f=e.y;f<p;++f)if(r[f*t+c.x]!==o){u=!0;break}u?(s.push(new Cartesian2(c.x,e.y)),--c.x,--h,l.endX=c.x):c.x===n?(l.endX=c.x,u=!0):++c.x}if(!d){for(var m=c.y*t,g=e.x;g<=h;++g)if(r[m+g]!==o){d=!0;break}d?(s.push(new Cartesian2(e.x,c.y)),--c.y,l.endY=c.y):c.y===a?(l.endY=c.y,d=!0):++c.y}}return{endingIndices:s,range:l,value:o}}function computeAvailability(e,t,i,r,n){var a=[];if(n.every(function(e){return e===n[0]}))return 1===n[0]&&a.push({startX:e,startY:t,endX:e+i-1,endY:t+r-1}),a;for(var o=[new Cartesian2(0,0)];0<o.length;){var s,l=findRange(o.pop(),i,r,n);1===l.value&&((s=l.range).startX+=e,s.endX+=e,s.startY+=t,s.endY+=t,a.push(s));l=l.endingIndices;0<l.length&&(o=o.concat(l))}return a}function requestAvailability(a,o,s,l){if(!a._hasAvailability)return{};var c=128*Math.floor(s/128),u=128*Math.floor(l/128),d=Math.min(1<<o,128),t="tilemap/"+o+"/"+u+"/"+c+"/"+d+"/"+d,i=a._availableCache;if(defined(i[t]))return i[t];var e=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),r=a._resource.getDerivedResource({url:t,request:e}).fetchJson();return defined(r)?(r=r.then(function(e){var t=computeAvailability(c,u,d,d,e.data);a._tilesAvailablityLoaded.addAvailableTileRange(o,c,u,c+d,u+d);for(var i=a._tilesAvailable,r=0;r<t.length;++r){var n=t[r];i.addAvailableTileRange(o,n.startX,n.startY,n.endX,n.endY)}return isTileAvailable(a,o,s,l)}),i[t]={promise:r,request:e},{promise:r=r.always(function(e){return delete i[t],e}),request:e}):{}}Object.defineProperties(ArcGISTiledElevationTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){return this._tilesAvailable}}}),ArcGISTiledElevationTerrainProvider.prototype.requestTileGeometry=function(t,i,r,n){var e,a,o=this._resource.getDerivedResource({url:"tile/"+r+"/"+i+"/"+t,request:n}),s=this._hasAvailability,l=when.resolve(!0);s&&!defined(isTileAvailable(this,r+1,2*t,2*i))&&(l=(e=requestAvailability(this,r+1,2*t,2*i)).promise,a=e.request);o=o.fetchArrayBuffer();if(defined(o)&&defined(l)){var c=this,u=this._tilesAvailable;return when.join(o,l).then(function(e){return new HeightmapTerrainData({buffer:e[0],width:c._width,height:c._height,childTileMask:s?u.computeChildMaskForTile(r,t,i):ALL_CHILDREN,structure:c._terrainDataStructure,encoding:c._encoding})}).otherwise(function(e){return defined(a)&&a.state===RequestState$1.CANCELLED?(n.cancel(),n.deferred.promise.always(function(){return n.state=RequestState$1.CANCELLED,when.reject(e)})):when.reject(e)})}},ArcGISTiledElevationTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},ArcGISTiledElevationTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(this._hasAvailability){var r=isTileAvailable(this,i,e,t);if(defined(r))return r;requestAvailability(this,i,e,t)}},ArcGISTiledElevationTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var ArcType={NONE:0,GEODESIC:1,RHUMB:2},ArcType$1=Object.freeze(ArcType);function AssociativeArray(){this._array=[],this._hash={}}Object.defineProperties(AssociativeArray.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),AssociativeArray.prototype.contains=function(e){return defined(this._hash[e])},AssociativeArray.prototype.set=function(e,t){t!==this._hash[e]&&(this.remove(e),this._hash[e]=t,this._array.push(t))},AssociativeArray.prototype.get=function(e){return this._hash[e]},AssociativeArray.prototype.remove=function(e){var t,i=this._hash[e],r=defined(i);return r&&((t=this._array).splice(t.indexOf(i),1),delete this._hash[e]),r},AssociativeArray.prototype.removeAll=function(){var e=this._array;0<e.length&&(this._hash={},e.length=0)};var url="https://dev.virtualearth.net/REST/v1/Locations";function BingMapsGeocoderService(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).key,t={key:this._key=t};defined(e.culture)&&(t.culture=e.culture),this._resource=new Resource({url:url,queryParameters:t})}function BoundingRectangle(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.width=defaultValue(i,0),this.height=defaultValue(r,0)}Object.defineProperties(BingMapsGeocoderService.prototype,{url:{get:function(){return url}},key:{get:function(){return this._key}}}),BingMapsGeocoderService.prototype.geocode=function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then(function(e){return 0===e.resourceSets.length?[]:e.resourceSets[0].resources.map(function(e){var t=e.bbox,i=t[0],r=t[1],n=t[2],t=t[3];return{displayName:e.name,destination:Rectangle.fromDegrees(r,i,t,n)}})})},BoundingRectangle.packedLength=4,BoundingRectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},BoundingRectangle.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new BoundingRectangle:i).x=e[t++],i.y=e[t++],i.width=e[t++],i.height=e[t],i},BoundingRectangle.fromPoints=function(e,t){if(defined(t)||(t=new BoundingRectangle),!defined(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var i=e.length,r=e[0].x,n=e[0].y,a=e[0].x,o=e[0].y,s=1;s<i;s++)var l=e[s],c=l.x,l=l.y,r=Math.min(c,r),a=Math.max(c,a),n=Math.min(l,n),o=Math.max(l,o);return t.x=r,t.y=n,t.width=a-r,t.height=o-n,t};var defaultProjection=new GeographicProjection,fromRectangleLowerLeft=new Cartographic,fromRectangleUpperRight=new Cartographic;function arrayFill(e,t,i,r){if("function"==typeof e.fill)return e.fill(t,i,r);for(var n=e.length>>>0,i=defaultValue(i,0),a=i<0?Math.max(n+i,0):Math.min(i,n),r=defaultValue(r,n),o=r<0?Math.max(n+r,0):Math.min(r,n);a<o;)e[a]=t,a++;return e}BoundingRectangle.fromRectangle=function(e,t,i){if(defined(i)||(i=new BoundingRectangle),!defined(e))return i.x=0,i.y=0,i.width=0,i.height=0,i;var r=(t=defaultValue(t,defaultProjection)).project(Rectangle.southwest(e,fromRectangleLowerLeft)),e=t.project(Rectangle.northeast(e,fromRectangleUpperRight));return Cartesian2.subtract(e,r,e),i.x=r.x,i.y=r.y,i.width=e.x,i.height=e.y,i},BoundingRectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new BoundingRectangle(e.x,e.y,e.width,e.height)},BoundingRectangle.union=function(e,t,i){defined(i)||(i=new BoundingRectangle);var r=Math.min(e.x,t.x),n=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),t=Math.max(e.y+e.height,t.y+t.height);return i.x=r,i.y=n,i.width=a-r,i.height=t-n,i},BoundingRectangle.expand=function(e,t,i){i=BoundingRectangle.clone(e,i);var r=t.x-i.x,e=t.y-i.y;return r>i.width?i.width=r:r<0&&(i.width-=r,i.x=t.x),e>i.height?i.height=e:e<0&&(i.height-=e,i.y=t.y),i},BoundingRectangle.intersect=function(e,t){var i=e.x,r=e.y,n=t.x,a=t.y;return i>n+t.width||i+e.width<n||r+e.height<a||r>a+t.height?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},BoundingRectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},BoundingRectangle.prototype.clone=function(e){return BoundingRectangle.clone(this,e)},BoundingRectangle.prototype.intersect=function(e){return BoundingRectangle.intersect(this,e)},BoundingRectangle.prototype.equals=function(e){return BoundingRectangle.equals(this,e)};var GeometryType={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},GeometryType$1=Object.freeze(GeometryType),PrimitiveType={POINTS:WebGLConstants$1.POINTS,LINES:WebGLConstants$1.LINES,LINE_LOOP:WebGLConstants$1.LINE_LOOP,LINE_STRIP:WebGLConstants$1.LINE_STRIP,TRIANGLES:WebGLConstants$1.TRIANGLES,TRIANGLE_STRIP:WebGLConstants$1.TRIANGLE_STRIP,TRIANGLE_FAN:WebGLConstants$1.TRIANGLE_FAN,validate:function(e){return e===PrimitiveType.POINTS||e===PrimitiveType.LINES||e===PrimitiveType.LINE_LOOP||e===PrimitiveType.LINE_STRIP||e===PrimitiveType.TRIANGLES||e===PrimitiveType.TRIANGLE_STRIP||e===PrimitiveType.TRIANGLE_FAN}},PrimitiveType$1=Object.freeze(PrimitiveType);function Geometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=defaultValue(e.geometryType,GeometryType$1.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}Geometry.computeNumberOfVertices=function(e){var t,i,r=-1;for(t in e.attributes)e.attributes.hasOwnProperty(t)&&defined(e.attributes[t])&&defined(e.attributes[t].values)&&(r=(i=e.attributes[t]).values.length/i.componentsPerAttribute);return r};var rectangleCenterScratch$3=new Cartographic,enuCenterScratch=new Cartesian3,fixedFrameToEnuScratch=new Matrix4,boundingRectanglePointsCartographicScratch=[new Cartographic,new Cartographic,new Cartographic],boundingRectanglePointsEnuScratch=[new Cartesian2,new Cartesian2,new Cartesian2],points2DScratch$2=[new Cartesian2,new Cartesian2,new Cartesian2],pointEnuScratch=new Cartesian3,enuRotationScratch=new Quaternion,enuRotationMatrixScratch=new Matrix4,rotation2DScratch$1=new Matrix2;function GeometryAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.values=e.values}function GeometryAttributes(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}Geometry._textureCoordinateRotationPoints=function(e,t,i,r){var n=Rectangle.center(r,rectangleCenterScratch$3),a=Cartographic.toCartesian(n,i,enuCenterScratch),n=Transforms.eastNorthUpToFixedFrame(a,i,fixedFrameToEnuScratch),o=Matrix4.inverse(n,fixedFrameToEnuScratch),s=boundingRectanglePointsEnuScratch,l=boundingRectanglePointsCartographicScratch;l[0].longitude=r.west,l[0].latitude=r.south,l[1].longitude=r.west,l[1].latitude=r.north,l[2].longitude=r.east,l[2].latitude=r.south;for(var c=pointEnuScratch,u=0;u<3;u++)Cartographic.toCartesian(l[u],i,c),c=Matrix4.multiplyByPointAsVector(o,c,c),s[u].x=c.x,s[u].y=c.y;var a=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-t,enuRotationScratch),d=Matrix3.fromQuaternion(a,enuRotationMatrixScratch),h=e.length,p=Number.POSITIVE_INFINITY,f=Number.POSITIVE_INFINITY,m=Number.NEGATIVE_INFINITY,g=Number.NEGATIVE_INFINITY;for(u=0;u<h;u++)c=Matrix4.multiplyByPointAsVector(o,e[u],c),c=Matrix3.multiplyByVector(d,c,c),p=Math.min(p,c.x),f=Math.min(f,c.y),m=Math.max(m,c.x),g=Math.max(g,c.y);var _=Matrix2.fromRotation(t,rotation2DScratch$1),y=points2DScratch$2;y[0].x=p,y[0].y=f,y[1].x=p,y[1].y=g,y[2].x=m,y[2].y=f;var C=s[0],v=s[2].x-C.x,T=s[1].y-C.y;for(u=0;u<3;u++){var S=y[u];Matrix2.multiplyByVector(_,S,S),S.x=(S.x-C.x)/v,S.y=(S.y-C.y)/T}n=y[0],r=y[1],a=y[2],t=new Array(6);return Cartesian2.pack(n,t),Cartesian2.pack(r,t,2),Cartesian2.pack(a,t,4),t};var GeometryOffsetAttribute={NONE:0,TOP:1,ALL:2},GeometryOffsetAttribute$1=Object.freeze(GeometryOffsetAttribute);function VertexFormat(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=defaultValue(e.position,!1),this.normal=defaultValue(e.normal,!1),this.st=defaultValue(e.st,!1),this.bitangent=defaultValue(e.bitangent,!1),this.tangent=defaultValue(e.tangent,!1),this.color=defaultValue(e.color,!1)}VertexFormat.POSITION_ONLY=Object.freeze(new VertexFormat({position:!0})),VertexFormat.POSITION_AND_NORMAL=Object.freeze(new VertexFormat({position:!0,normal:!0})),VertexFormat.POSITION_NORMAL_AND_ST=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0})),VertexFormat.POSITION_AND_ST=Object.freeze(new VertexFormat({position:!0,st:!0})),VertexFormat.POSITION_AND_COLOR=Object.freeze(new VertexFormat({position:!0,color:!0})),VertexFormat.ALL=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),VertexFormat.DEFAULT=VertexFormat.POSITION_NORMAL_AND_ST,VertexFormat.packedLength=6,VertexFormat.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.position?1:0,t[i++]=e.normal?1:0,t[i++]=e.st?1:0,t[i++]=e.tangent?1:0,t[i++]=e.bitangent?1:0,t[i]=e.color?1:0,t},VertexFormat.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new VertexFormat:i).position=1===e[t++],i.normal=1===e[t++],i.st=1===e[t++],i.tangent=1===e[t++],i.bitangent=1===e[t++],i.color=1===e[t],i},VertexFormat.clone=function(e,t){if(defined(e))return(t=!defined(t)?new VertexFormat:t).position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};var diffScratch$1=new Cartesian3;function BoxGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._minimum=Cartesian3.clone(t),this._maximum=Cartesian3.clone(i),this._vertexFormat=r,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}BoxGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,t=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxGeometry({minimum:Cartesian3.negate(t,new Cartesian3),maximum:t,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},BoxGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxGeometry({minimum:e.minimum,maximum:e.maximum})},BoxGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+1,BoxGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._minimum,t,i),Cartesian3.pack(e._maximum,t,i+Cartesian3.packedLength),VertexFormat.pack(e._vertexFormat,t,i+2*Cartesian3.packedLength),t[i+2*Cartesian3.packedLength+VertexFormat.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$3=new Cartesian3,scratchMax$3=new Cartesian3,scratchVertexFormat$c=new VertexFormat,scratchOptions$n={minimum:scratchMin$3,maximum:scratchMax$3,vertexFormat:scratchVertexFormat$c,offsetAttribute:void 0},unitBoxGeometry;BoxGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$3),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$3),a=VertexFormat.unpack(e,t+2*Cartesian3.packedLength,scratchVertexFormat$c),t=e[t+2*Cartesian3.packedLength+VertexFormat.packedLength];return defined(i)?(i._minimum=Cartesian3.clone(r,i._minimum),i._maximum=Cartesian3.clone(n,i._maximum),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$n.offsetAttribute=-1===t?void 0:t,new BoxGeometry(scratchOptions$n))},BoxGeometry.createGeometry=function(e){var t=e._minimum,i=e._maximum,r=e._vertexFormat;if(!Cartesian3.equals(t,i)){var n,a,o,s=new GeometryAttributes;r.position&&(r.st||r.normal||r.tangent||r.bitangent)?(r.position&&((l=new Float64Array(72))[0]=t.x,l[1]=t.y,l[2]=i.z,l[3]=i.x,l[4]=t.y,l[5]=i.z,l[6]=i.x,l[7]=i.y,l[8]=i.z,l[9]=t.x,l[10]=i.y,l[11]=i.z,l[12]=t.x,l[13]=t.y,l[14]=t.z,l[15]=i.x,l[16]=t.y,l[17]=t.z,l[18]=i.x,l[19]=i.y,l[20]=t.z,l[21]=t.x,l[22]=i.y,l[23]=t.z,l[24]=i.x,l[25]=t.y,l[26]=t.z,l[27]=i.x,l[28]=i.y,l[29]=t.z,l[30]=i.x,l[31]=i.y,l[32]=i.z,l[33]=i.x,l[34]=t.y,l[35]=i.z,l[36]=t.x,l[37]=t.y,l[38]=t.z,l[39]=t.x,l[40]=i.y,l[41]=t.z,l[42]=t.x,l[43]=i.y,l[44]=i.z,l[45]=t.x,l[46]=t.y,l[47]=i.z,l[48]=t.x,l[49]=i.y,l[50]=t.z,l[51]=i.x,l[52]=i.y,l[53]=t.z,l[54]=i.x,l[55]=i.y,l[56]=i.z,l[57]=t.x,l[58]=i.y,l[59]=i.z,l[60]=t.x,l[61]=t.y,l[62]=t.z,l[63]=i.x,l[64]=t.y,l[65]=t.z,l[66]=i.x,l[67]=t.y,l[68]=i.z,l[69]=t.x,l[70]=t.y,l[71]=i.z,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})),r.normal&&((n=new Float32Array(72))[0]=0,n[1]=0,n[2]=1,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=1,n[9]=0,n[10]=0,n[11]=1,n[12]=0,n[13]=0,n[14]=-1,n[15]=0,n[16]=0,n[17]=-1,n[18]=0,n[19]=0,n[20]=-1,n[21]=0,n[22]=0,n[23]=-1,n[24]=1,n[25]=0,n[26]=0,n[27]=1,n[28]=0,n[29]=0,n[30]=1,n[31]=0,n[32]=0,n[33]=1,n[34]=0,n[35]=0,n[36]=-1,n[37]=0,n[38]=0,n[39]=-1,n[40]=0,n[41]=0,n[42]=-1,n[43]=0,n[44]=0,n[45]=-1,n[46]=0,n[47]=0,n[48]=0,n[49]=1,n[50]=0,n[51]=0,n[52]=1,n[53]=0,n[54]=0,n[55]=1,n[56]=0,n[57]=0,n[58]=1,n[59]=0,n[60]=0,n[61]=-1,n[62]=0,n[63]=0,n[64]=-1,n[65]=0,n[66]=0,n[67]=-1,n[68]=0,n[69]=0,n[70]=-1,n[71]=0,s.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n})),r.st&&((a=new Float32Array(48))[0]=0,a[1]=0,a[2]=1,a[3]=0,a[4]=1,a[5]=1,a[6]=0,a[7]=1,a[8]=1,a[9]=0,a[10]=0,a[11]=0,a[12]=0,a[13]=1,a[14]=1,a[15]=1,a[16]=0,a[17]=0,a[18]=1,a[19]=0,a[20]=1,a[21]=1,a[22]=0,a[23]=1,a[24]=1,a[25]=0,a[26]=0,a[27]=0,a[28]=0,a[29]=1,a[30]=1,a[31]=1,a[32]=1,a[33]=0,a[34]=0,a[35]=0,a[36]=0,a[37]=1,a[38]=1,a[39]=1,a[40]=0,a[41]=0,a[42]=1,a[43]=0,a[44]=1,a[45]=1,a[46]=0,a[47]=1,s.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:a})),r.tangent&&((a=new Float32Array(72))[0]=1,a[1]=0,a[2]=0,a[3]=1,a[4]=0,a[5]=0,a[6]=1,a[7]=0,a[8]=0,a[9]=1,a[10]=0,a[11]=0,a[12]=-1,a[13]=0,a[14]=0,a[15]=-1,a[16]=0,a[17]=0,a[18]=-1,a[19]=0,a[20]=0,a[21]=-1,a[22]=0,a[23]=0,a[24]=0,a[25]=1,a[26]=0,a[27]=0,a[28]=1,a[29]=0,a[30]=0,a[31]=1,a[32]=0,a[33]=0,a[34]=1,a[35]=0,a[36]=0,a[37]=-1,a[38]=0,a[39]=0,a[40]=-1,a[41]=0,a[42]=0,a[43]=-1,a[44]=0,a[45]=0,a[46]=-1,a[47]=0,a[48]=-1,a[49]=0,a[50]=0,a[51]=-1,a[52]=0,a[53]=0,a[54]=-1,a[55]=0,a[56]=0,a[57]=-1,a[58]=0,a[59]=0,a[60]=1,a[61]=0,a[62]=0,a[63]=1,a[64]=0,a[65]=0,a[66]=1,a[67]=0,a[68]=0,a[69]=1,a[70]=0,a[71]=0,s.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:a})),r.bitangent&&((o=new Float32Array(72))[0]=0,o[1]=1,o[2]=0,o[3]=0,o[4]=1,o[5]=0,o[6]=0,o[7]=1,o[8]=0,o[9]=0,o[10]=1,o[11]=0,o[12]=0,o[13]=1,o[14]=0,o[15]=0,o[16]=1,o[17]=0,o[18]=0,o[19]=1,o[20]=0,o[21]=0,o[22]=1,o[23]=0,o[24]=0,o[25]=0,o[26]=1,o[27]=0,o[28]=0,o[29]=1,o[30]=0,o[31]=0,o[32]=1,o[33]=0,o[34]=0,o[35]=1,o[36]=0,o[37]=0,o[38]=1,o[39]=0,o[40]=0,o[41]=1,o[42]=0,o[43]=0,o[44]=1,o[45]=0,o[46]=0,o[47]=1,o[48]=0,o[49]=0,o[50]=1,o[51]=0,o[52]=0,o[53]=1,o[54]=0,o[55]=0,o[56]=1,o[57]=0,o[58]=0,o[59]=1,o[60]=0,o[61]=0,o[62]=1,o[63]=0,o[64]=0,o[65]=1,o[66]=0,o[67]=0,o[68]=1,o[69]=0,o[70]=0,o[71]=1,s.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:o})),(o=new Uint16Array(36))[0]=0,o[1]=1,o[2]=2,o[3]=0,o[4]=2,o[5]=3,o[6]=6,o[7]=5,o[8]=4,o[9]=7,o[10]=6,o[11]=4,o[12]=8,o[13]=9,o[14]=10,o[15]=8,o[16]=10,o[17]=11,o[18]=14,o[19]=13,o[20]=12,o[21]=15,o[22]=14,o[23]=12,o[24]=18,o[25]=17,o[26]=16,o[27]=19,o[28]=18,o[29]=16,o[30]=20,o[31]=21,o[32]=22,o[33]=20,o[34]=22,o[35]=23):((l=new Float64Array(24))[0]=t.x,l[1]=t.y,l[2]=t.z,l[3]=i.x,l[4]=t.y,l[5]=t.z,l[6]=i.x,l[7]=i.y,l[8]=t.z,l[9]=t.x,l[10]=i.y,l[11]=t.z,l[12]=t.x,l[13]=t.y,l[14]=i.z,l[15]=i.x,l[16]=t.y,l[17]=i.z,l[18]=i.x,l[19]=i.y,l[20]=i.z,l[21]=t.x,l[22]=i.y,l[23]=i.z,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),(o=new Uint16Array(36))[0]=4,o[1]=5,o[2]=6,o[3]=4,o[4]=6,o[5]=7,o[6]=1,o[7]=0,o[8]=3,o[9]=1,o[10]=3,o[11]=2,o[12]=1,o[13]=6,o[14]=5,o[15]=1,o[16]=2,o[17]=6,o[18]=2,o[19]=3,o[20]=7,o[21]=2,o[22]=7,o[23]=6,o[24]=3,o[25]=0,o[26]=4,o[27]=3,o[28]=4,o[29]=7,o[30]=0,o[31]=1,o[32]=5,o[33]=0,o[34]=5,o[35]=4);var l,t=Cartesian3.subtract(i,t,diffScratch$1),t=.5*Cartesian3.magnitude(t);return defined(e._offsetAttribute)&&(l=l.length,arrayFill(l=new Uint8Array(l/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:l})),new Geometry({attributes:s,indices:o,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,t),offsetAttribute:e._offsetAttribute})}},BoxGeometry.getUnitBox=function(){return unitBoxGeometry=!defined(unitBoxGeometry)?BoxGeometry.createGeometry(BoxGeometry.fromDimensions({dimensions:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY})):unitBoxGeometry};var diffScratch=new Cartesian3;function BoxOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum;this._min=Cartesian3.clone(t),this._max=Cartesian3.clone(i),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}BoxOutlineGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,t=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxOutlineGeometry({minimum:Cartesian3.negate(t,new Cartesian3),maximum:t,offsetAttribute:e.offsetAttribute})},BoxOutlineGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxOutlineGeometry({minimum:e.minimum,maximum:e.maximum})},BoxOutlineGeometry.packedLength=2*Cartesian3.packedLength+1,BoxOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._min,t,i),Cartesian3.pack(e._max,t,i+Cartesian3.packedLength),t[i+2*Cartesian3.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$2=new Cartesian3,scratchMax$2=new Cartesian3,scratchOptions$m={minimum:scratchMin$2,maximum:scratchMax$2,offsetAttribute:void 0};function CartographicGeocoderService(){}function Spline(){this.times=void 0,this.points=void 0,DeveloperError.throwInstantiationError()}function LinearSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,e=e.times;this._times=e,this._points=t,this._lastTimeIndex=0}BoxOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$2),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$2),t=e[t+2*Cartesian3.packedLength];return defined(i)?(i._min=Cartesian3.clone(r,i._min),i._max=Cartesian3.clone(n,i._max),i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$m.offsetAttribute=-1===t?void 0:t,new BoxOutlineGeometry(scratchOptions$m))},BoxOutlineGeometry.createGeometry=function(e){var t=e._min,i=e._max;if(!Cartesian3.equals(t,i)){var r=new GeometryAttributes,n=new Uint16Array(24),a=new Float64Array(24);a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),n[0]=4,n[1]=5,n[2]=5,n[3]=6,n[4]=6,n[5]=7,n[6]=7,n[7]=4,n[8]=0,n[9]=1,n[10]=1,n[11]=2,n[12]=2,n[13]=3,n[14]=3,n[15]=0,n[16]=0,n[17]=4,n[18]=1,n[19]=5,n[20]=2,n[21]=6,n[22]=3,n[23]=7;t=Cartesian3.subtract(i,t,diffScratch),t=.5*Cartesian3.magnitude(t);return defined(e._offsetAttribute)&&(a=a.length,arrayFill(a=new Uint8Array(a/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:a})),new Geometry({attributes:r,indices:n,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,t),offsetAttribute:e._offsetAttribute})}},CartographicGeocoderService.prototype.geocode=function(e){var t=e.match(/[^\s,\n]+/g);if(2===t.length||3===t.length){var i=+t[0],r=+t[1],n=3===t.length?+t[2]:300;if(isNaN(i)&&isNaN(r))for(var a=/^(\d+.?\d*)([nsew])/i,o=0;o<t.length;++o){var s=t[o].match(a);a.test(t[o])&&3===s.length&&(/^[ns]/i.test(s[2])?r=/^[n]/i.test(s[2])?+s[1]:-s[1]:/^[ew]/i.test(s[2])&&(i=/^[e]/i.test(s[2])?+s[1]:-s[1]))}if(!isNaN(i)&&!isNaN(r)&&!isNaN(n)){n={displayName:e,destination:Cartesian3.fromDegrees(i,r,n)};return when.resolve([n])}}return when.resolve([])},Spline.prototype.evaluate=DeveloperError.throwInstantiationError,Spline.prototype.findTimeInterval=function(e,t){var i,r=this.times,n=r.length;if(e>=r[t=defaultValue(t,0)]){if(t+1<n&&e<r[t+1])return t;if(t+2<n&&e<r[t+2])return t+1}else if(0<=t-1&&e>=r[t-1])return t-1;if(e>r[t])for(i=t;i<n-1&&!(e>=r[i]&&e<r[i+1]);++i);else for(i=t-1;0<=i&&!(e>=r[i]&&e<r[i+1]);--i);return i=i===n-1?n-2:i},Spline.prototype.wrapTime=function(e){var t=this.times,i=t[t.length-1],r=t[0],t=i-r;return e<r&&(e+=(Math.floor((r-e)/t)+1)*t),i<e&&(e-=(Math.floor((e-i)/t)+1)*t),e},Spline.prototype.clampTime=function(e){var t=this.times;return CesiumMath.clamp(e,t[0],t[t.length-1])},Object.defineProperties(LinearSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),LinearSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,LinearSpline.prototype.wrapTime=Spline.prototype.wrapTime,LinearSpline.prototype.clampTime=Spline.prototype.clampTime,LinearSpline.prototype.evaluate=function(e,t){var i=this.points,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),r=(e-r[n])/(r[n+1]-r[n]);return defined(t)||(t=new Cartesian3),Cartesian3.lerp(i[n],i[n+1],r,t)};var TridiagonalSystemSolver={solve:function(e,t,i,r){for(var n,a=new Array(i.length),o=new Array(r.length),s=new Array(r.length),l=0;l<o.length;l++)o[l]=new Cartesian3,s[l]=new Cartesian3;for(a[0]=i[0]/t[0],o[0]=Cartesian3.multiplyByScalar(r[0],1/t[0],o[0]),l=1;l<a.length;++l)n=1/(t[l]-a[l-1]*e[l-1]),a[l]=i[l]*n,o[l]=Cartesian3.subtract(r[l],Cartesian3.multiplyByScalar(o[l-1],e[l-1],o[l]),o[l]),o[l]=Cartesian3.multiplyByScalar(o[l],n,o[l]);for(n=1/(t[l]-a[l-1]*e[l-1]),o[l]=Cartesian3.subtract(r[l],Cartesian3.multiplyByScalar(o[l-1],e[l-1],o[l]),o[l]),o[l]=Cartesian3.multiplyByScalar(o[l],n,o[l]),s[s.length-1]=o[o.length-1],l=s.length-2;0<=l;--l)s[l]=Cartesian3.subtract(o[l],Cartesian3.multiplyByScalar(s[l+1],a[l],s[l]),s[l]);return s}},scratchLower=[],scratchDiagonal=[],scratchUpper=[],scratchRight$3=[];function generateClamped(e,t,i){var r,n=scratchLower,a=scratchUpper,o=scratchDiagonal,s=scratchRight$3;n.length=a.length=e.length-1,o.length=s.length=e.length,n[0]=o[0]=1;var l=s[a[0]=0];for(defined(l)||(l=s[0]=new Cartesian3),Cartesian3.clone(t,l),r=1;r<n.length-1;++r)n[r]=a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l);return n[r]=0,a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l),defined(l=s[r+(o[r+1]=1)])||(l=s[r+1]=new Cartesian3),Cartesian3.clone(i,l),TridiagonalSystemSolver.solve(n,o,a,s)}function generateNatural(e){var t,i=scratchLower,r=scratchUpper,n=scratchDiagonal,a=scratchRight$3;i.length=r.length=e.length-1,n.length=a.length=e.length,i[0]=r[0]=1,n[0]=2;var o=a[0];for(defined(o)||(o=a[0]=new Cartesian3),Cartesian3.subtract(e[1],e[0],o),Cartesian3.multiplyByScalar(o,3,o),t=1;t<i.length;++t)i[t]=r[t]=1,n[t]=4,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t+1],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o);return n[t]=2,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o),TridiagonalSystemSolver.solve(i,n,r,a)}function HermiteSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.inTangents,e=e.outTangents;this._times=i,this._points=t,this._inTangents=r,this._outTangents=e,this._lastTimeIndex=0}Object.defineProperties(HermiteSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),HermiteSpline.createC1=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.tangents,e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.createNaturalCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points;if(i.length<3)return new LinearSpline({points:i,times:t});var r=generateNatural(i),e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.createClampedCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.firstTangent,e=e.lastTangent;if(i.length<3)return new LinearSpline({points:i,times:t});r=generateClamped(i,r,e),e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.hermiteCoefficientMatrix=new Matrix4(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),HermiteSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval;var scratchTimeVec$1=new Cartesian4,scratchTemp=new Cartesian3;HermiteSpline.prototype.wrapTime=Spline.prototype.wrapTime,HermiteSpline.prototype.clampTime=Spline.prototype.clampTime,HermiteSpline.prototype.evaluate=function(e,t){defined(t)||(t=new Cartesian3);var i=this.points,r=this.times,n=this.inTangents,a=this.outTangents,o=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),e=(e-r[o])/(r[o+1]-r[o]),r=scratchTimeVec$1;r.z=e,r.y=e*e,r.x=r.y*e,r.w=1;r=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,r,r);return t=Cartesian3.multiplyByScalar(i[o],r.x,t),Cartesian3.multiplyByScalar(i[o+1],r.y,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(a[o],r.z,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(n[o],r.w,scratchTemp),Cartesian3.add(t,scratchTemp,t)};var scratchTimeVec=new Cartesian4,scratchTemp0=new Cartesian3,scratchTemp1=new Cartesian3;function createEvaluateFunction$1(l){var c=l.points,u=l.times;if(c.length<3){var i=u[0],r=1/(u[1]-i),n=c[0],a=c[1];return function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.lerp(n,a,(e-i)*r,t)}}return function(e,t){defined(t)||(t=new Cartesian3);var i,r,n,a,o=l._lastTimeIndex=l.findTimeInterval(e,l._lastTimeIndex),s=(e-u[o])/(u[o+1]-u[o]),e=scratchTimeVec;return e.z=s,e.y=s*s,e.x=e.y*s,e.w=1,e=0===o?(i=c[0],r=c[1],n=l.firstTangent,a=Cartesian3.subtract(c[2],i,scratchTemp0),Cartesian3.multiplyByScalar(a,.5,a),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,e,e)):o===c.length-2?(i=c[o],r=c[o+1],a=l.lastTangent,n=Cartesian3.subtract(r,c[o-1],scratchTemp0),Cartesian3.multiplyByScalar(n,.5,n),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,e,e)):(i=c[o-1],r=c[o],n=c[o+1],a=c[o+2],Matrix4.multiplyByVector(CatmullRomSpline.catmullRomCoefficientMatrix,e,e)),t=Cartesian3.multiplyByScalar(i,e.x,t),Cartesian3.multiplyByScalar(r,e.y,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(n,e.z,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(a,e.w,scratchTemp1),Cartesian3.add(t,scratchTemp1,t)}}var firstTangentScratch=new Cartesian3,lastTangentScratch=new Cartesian3;function CatmullRomSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.firstTangent,n=e.lastTangent;2<t.length&&(defined(r)||(Cartesian3.multiplyByScalar(t[1],2,r=firstTangentScratch),Cartesian3.subtract(r,t[2],r),Cartesian3.subtract(r,t[0],r),Cartesian3.multiplyByScalar(r,.5,r)),defined(n)||(e=t.length-1,Cartesian3.multiplyByScalar(t[e-1],2,n=lastTangentScratch),Cartesian3.subtract(t[e],n,n),Cartesian3.add(n,t[e-2],n),Cartesian3.multiplyByScalar(n,.5,n))),this._times=i,this._points=t,this._firstTangent=Cartesian3.clone(r),this._lastTangent=Cartesian3.clone(n),this._evaluateFunction=createEvaluateFunction$1(this),this._lastTimeIndex=0}function getStringFromTypedArray(e,t,i){return t=defaultValue(t,0),i=defaultValue(i,e.byteLength-t),e=e.subarray(t,t+i),getStringFromTypedArray.decode(e)}function inRange(e,t,i){return t<=e&&e<=i}function utf8Handler(e){for(var t=0,i=0,r=0,n=128,a=191,o=[],s=e.length,l=0;l<s;++l){var c=e[l];if(0===r){if(inRange(c,0,127)){o.push(c);continue}if(inRange(c,194,223)){r=1,t=31&c;continue}if(inRange(c,224,239)){224===c&&(n=160),237===c&&(a=159),r=2,t=15&c;continue}if(inRange(c,240,244)){240===c&&(n=144),244===c&&(a=143),r=3,t=7&c;continue}throw new RuntimeError("String decoding failed.")}inRange(c,n,a)?(n=128,a=191,t=t<<6|63&c,++i===r&&(o.push(t),t=r=i=0)):(t=r=i=0,n=128,a=191,--l)}return o}function getJsonFromTypedArray(e,t,i){return JSON.parse(getStringFromTypedArray(e,t,i))}Object.defineProperties(CatmullRomSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),CatmullRomSpline.catmullRomCoefficientMatrix=new Matrix4(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),CatmullRomSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,CatmullRomSpline.prototype.wrapTime=Spline.prototype.wrapTime,CatmullRomSpline.prototype.clampTime=Spline.prototype.clampTime,CatmullRomSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},getStringFromTypedArray.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)},getStringFromTypedArray.decodeWithFromCharCode=function(e){for(var t="",i=utf8Handler(e),r=i.length,n=0;n<r;++n){var a=i[n];a<=65535?t+=String.fromCharCode(a):(a-=65536,t+=String.fromCharCode(55296+(a>>10),56320+(1023&a)))}return t},"undefined"!=typeof TextDecoder?getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithTextDecoder:getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithFromCharCode;var Intersections2D={};function QuantizedMeshTerrainData(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;var t=this._quantizedVertices.length/3,i=this._uValues=this._quantizedVertices.subarray(0,t),r=this._vValues=this._quantizedVertices.subarray(t,2*t);function n(e,t){return r[e]-r[t]}function a(e,t){return i[e]-i[t]}this._heightValues=this._quantizedVertices.subarray(2*t,3*t),this._westIndices=sortIndicesIfNecessary(e.westIndices,n,t),this._southIndices=sortIndicesIfNecessary(e.southIndices,a,t),this._eastIndices=sortIndicesIfNecessary(e.eastIndices,n,t),this._northIndices=sortIndicesIfNecessary(e.northIndices,a,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=defaultValue(e.childTileMask,15),this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Intersections2D.clipTriangleAtAxisAlignedThreshold=function(e,t,i,r,n,a){var o,s;defined(a)?a.length=0:a=[];var l,c,u,d,h,p,f=t?(o=i<e,s=r<e,n<e):(o=e<i,s=e<r,e<n),t=o+s+f;return 1===t?o?(l=(e-i)/(r-i),c=(e-i)/(n-i),a.push(1),a.push(2),1!==c&&(a.push(-1),a.push(0),a.push(2),a.push(c)),1!==l&&(a.push(-1),a.push(0),a.push(1),a.push(l))):s?(u=(e-r)/(n-r),d=(e-r)/(i-r),a.push(2),a.push(0),1!==d&&(a.push(-1),a.push(1),a.push(0),a.push(d)),1!==u&&(a.push(-1),a.push(1),a.push(2),a.push(u))):f&&(h=(e-n)/(i-n),p=(e-n)/(r-n),a.push(0),a.push(1),1!==p&&(a.push(-1),a.push(2),a.push(1),a.push(p)),1!==h&&(a.push(-1),a.push(2),a.push(0),a.push(h))):2===t?o||i===e?s||r===e?f||n===e||(c=(e-i)/(n-i),u=(e-r)/(n-r),a.push(2),a.push(-1),a.push(0),a.push(2),a.push(c),a.push(-1),a.push(1),a.push(2),a.push(u)):(p=(e-n)/(r-n),l=(e-i)/(r-i),a.push(1),a.push(-1),a.push(2),a.push(1),a.push(p),a.push(-1),a.push(0),a.push(1),a.push(l)):(d=(e-r)/(i-r),h=(e-n)/(i-n),a.push(0),a.push(-1),a.push(1),a.push(0),a.push(d),a.push(-1),a.push(2),a.push(0),a.push(h)):3!==t&&(a.push(0),a.push(1),a.push(2)),a},Intersections2D.computeBarycentricCoordinates=function(e,t,i,r,n,a,o,s,l){var c=i-o,i=o-n,n=a-s,a=r-s,r=1/(n*c+i*a),s=t-s,o=e-o,i=(n*o+i*s)*r,s=(-a*o+c*s)*r,r=1-i-s;return defined(l)?(l.x=i,l.y=s,l.z=r,l):new Cartesian3(i,s,r)},Intersections2D.computeLineSegmentLineSegmentIntersection=function(e,t,i,r,n,a,o,s,l){var c=(o-n)*(t-a)-(s-a)*(e-n),u=(i-e)*(t-a)-(r-t)*(e-n),n=(s-a)*(i-e)-(o-n)*(r-t);if(0!=n){c=c/n,n=u/n;return 0<=c&&c<=1&&0<=n&&n<=1?((l=!defined(l)?new Cartesian2:l).x=e+c*(i-e),l.y=t+c*(r-t),l):void 0}},Object.defineProperties(QuantizedMeshTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return defined(this._mesh)}}});var arrayScratch$1=[];function sortIndicesIfNecessary(e,t,i){arrayScratch$1.length=e.length;for(var r=!1,n=0,a=e.length;n<a;++n)arrayScratch$1[n]=e[n],r=r||0<n&&0<t(e[n-1],e[n]);return r?(arrayScratch$1.sort(t),IndexDatatype$1.createTypedArray(i,arrayScratch$1)):e}var createMeshTaskName$1="createVerticesFromQuantizedTerrainMesh",createMeshTaskProcessorNoThrottle$1=new TaskProcessor(createMeshTaskName$1),createMeshTaskProcessorThrottle$1=new TaskProcessor(createMeshTaskName$1,TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),e=t.ellipsoid,n=t.tileXYToRectangle(i,r,n),o=(s?createMeshTaskProcessorThrottle$1:createMeshTaskProcessorNoThrottle$1).scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:n,relativeToCenter:this._boundingSphere.center,ellipsoid:e,exaggeration:a,exaggerationRelativeHeight:o});if(defined(o)){var h=this;return when(o,function(e){var t=h._quantizedVertices.length/3,i=t+h._westIndices.length+h._southIndices.length+h._eastIndices.length+h._northIndices.length,r=IndexDatatype$1.createTypedArray(i,e.indices),n=new Float32Array(e.vertices),a=e.center,o=e.minimumHeight,s=e.maximumHeight,l=h._boundingSphere,c=h._orientedBoundingBox,u=defaultValue(Cartesian3.clone(e.occludeePointInScaledSpace),h._horizonOcclusionPoint),d=e.vertexStride,i=TerrainEncoding.clone(e.encoding);return h._mesh=new TerrainMesh(a,n,r,e.indexCountWithoutSkirts,t,o,s,l,u,d,c,i,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),h._quantizedVertices=void 0,h._encodedNormals=void 0,h._indices=void 0,h._uValues=void 0,h._vValues=void 0,h._heightValues=void 0,h._westIndices=void 0,h._southIndices=void 0,h._eastIndices=void 0,h._northIndices=void 0,h._mesh})}};var upsampleTaskProcessor$1=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,t=2*i===a,i=e.ellipsoid,o=e.tileXYToRectangle(n,a,o),o=upsampleTaskProcessor$1.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:t,childRectangle:o,ellipsoid:i});if(defined(o)){i=Math.min(this._westSkirtHeight,this._eastSkirtHeight),i=Math.min(i,this._southSkirtHeight);i=Math.min(i,this._northSkirtHeight);var c=l?.5*i:this._westSkirtHeight,u=t?.5*i:this._southSkirtHeight,d=l?this._eastSkirtHeight:.5*i,h=t?this._northSkirtHeight:.5*i,p=this._credits;return when(o).then(function(e){var t,i=new Uint16Array(e.vertices);return new QuantizedMeshTerrainData({quantizedVertices:i,indices:IndexDatatype$1.createTypedArray(i.length/3,e.indices),encodedNormals:t=defined(e.encodedNormals)?new Uint8Array(e.encodedNormals):t,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:c,southSkirtHeight:u,eastSkirtHeight:d,northSkirtHeight:h,childTileMask:0,credits:p,createdByUpsampling:!0})})}}};var maxShort$1=32767,barycentricCoordinateScratch$1=new Cartesian3;function pointInBoundingBox(e,t,i,r,n,a,o,s){var l=Math.min(i,n,o),n=Math.max(i,n,o),o=Math.min(r,a,s),s=Math.max(r,a,s);return l<=e&&e<=n&&o<=t&&t<=s}QuantizedMeshTerrainData.prototype.interpolateHeight=function(e,t,i){t=CesiumMath.clamp((t-e.west)/e.width,0,1);t*=maxShort$1;e=CesiumMath.clamp((i-e.south)/e.height,0,1);return e*=maxShort$1,(defined(this._mesh)?interpolateMeshHeight$1:interpolateHeight$1)(this,t,e)};var texCoordScratch0$1=new Cartesian2,texCoordScratch1$1=new Cartesian2,texCoordScratch2$1=new Cartesian2;function interpolateMeshHeight$1(e,t,i){for(var e=e._mesh,r=e.vertices,n=e.encoding,a=e.indices,o=0,s=a.length;o<s;o+=3){var l=a[o],c=a[o+1],u=a[o+2],d=n.decodeTextureCoordinates(r,l,texCoordScratch0$1),h=n.decodeTextureCoordinates(r,c,texCoordScratch1$1),p=n.decodeTextureCoordinates(r,u,texCoordScratch2$1);if(pointInBoundingBox(t,i,d.x,d.y,h.x,h.y,p.x,p.y)){p=Intersections2D.computeBarycentricCoordinates(t,i,d.x,d.y,h.x,h.y,p.x,p.y,barycentricCoordinateScratch$1);if(-1e-15<=p.x&&-1e-15<=p.y&&-1e-15<=p.z){l=n.decodeHeight(r,l),c=n.decodeHeight(r,c),u=n.decodeHeight(r,u);return p.x*l+p.y*c+p.z*u}}}}function interpolateHeight$1(e,t,i){for(var r=e._uValues,n=e._vValues,a=e._heightValues,o=e._indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=r[c],p=r[u],f=r[d],m=n[c],g=n[u],_=n[d];if(pointInBoundingBox(t,i,h,m,p,g,f,_)){_=Intersections2D.computeBarycentricCoordinates(t,i,h,m,p,g,f,_,barycentricCoordinateScratch$1);if(-1e-15<=_.x&&-1e-15<=_.y&&-1e-15<=_.z){d=_.x*a[c]+_.y*a[u]+_.z*a[d];return CesiumMath.lerp(e._minimumHeight,e._maximumHeight,d/maxShort$1)}}}}function LayerInformation(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityPromiseCache={}}function CesiumTerrainProvider(e){this._heightmapWidth=65,this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._ellipsoid=e.ellipsoid,this._requestVertexNormals=defaultValue(e.requestVertexNormals,!1),this._requestWaterMask=defaultValue(e.requestWaterMask,!1),this._requestMetadata=defaultValue(e.requestMetadata,!0),this._errorEvent=new Event;var t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._availability=void 0;var i=when.defer();this._ready=!1,this._readyPromise=i,this._tileCredits=void 0;var v,T,S,A=this,x=this._layers=[],b="",E=[],P=0;function D(e){var t;if(e.format){if(e.tiles&&0!==e.tiles.length){var i=!1,r=!1,n=!1,a=!0,o=!1;if("heightmap-1.0"===e.format)o=!0,defined(A._heightmapStructure)||(A._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:65535}),A._requestWaterMask=r=!0;else if(0!==e.format.indexOf("quantized-mesh-1."))return t='The tile format "'+e.format+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,A,A._errorEvent,t,void 0,void 0,void 0,M));var s,l=e.tiles,c=e.maxzoom;if(P=Math.max(P,c),e.projection&&"EPSG:4326"!==e.projection){if("EPSG:3857"!==e.projection)return t='The projection "'+e.projection+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,A,A._errorEvent,t,void 0,void 0,void 0,M));A._tilingScheme=new WebMercatorTilingScheme({numberOfLevelZeroTilesX:1,numberOfLevelZeroTilesY:1,ellipsoid:A._ellipsoid})}else A._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:A._ellipsoid});if(A._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(A._tilingScheme.ellipsoid,A._heightmapWidth,A._tilingScheme.getNumberOfXTilesAtLevel(0)),e.scheme&&"tms"!==e.scheme&&"slippyMap"!==e.scheme)return t='The scheme "'+e.scheme+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,A,A._errorEvent,t,void 0,void 0,void 0,M));A._scheme=e.scheme,defined(e.extensions)&&-1!==e.extensions.indexOf("octvertexnormals")?i=!0:defined(e.extensions)&&-1!==e.extensions.indexOf("vertexnormals")&&(a=!(i=!0)),defined(e.extensions)&&-1!==e.extensions.indexOf("watermask")&&(r=!0),defined(e.extensions)&&-1!==e.extensions.indexOf("metadata")&&(n=!0);var u=e.metadataAvailability,d=e.available;if(defined(d)&&!defined(u))for(var h=new TileAvailability(A._tilingScheme,d.length),p=0;p<d.length;++p){var f=d[p],m=A._tilingScheme.getNumberOfYTilesAtLevel(p);defined(E[p])||(E[p]=[]);for(var g=0;g<f.length;++g){var _=f[g],y=m-_.endY-1,C=m-_.startY-1;E[p].push([_.startX,y,_.endX,C]),h.addAvailableTileRange(p,_.startX,y,_.endX,C)}}else defined(u)&&(s=new TileAvailability(A._tilingScheme,c),h=new TileAvailability(A._tilingScheme,c),E[0]=[[0,0,1,0]],h.addAvailableTileRange(0,0,0,1,0));A._hasWaterMask=A._hasWaterMask||r,A._hasVertexNormals=A._hasVertexNormals||i,A._hasMetadata=A._hasMetadata||n,defined(e.attribution)&&(0<b.length&&(b+=" "),b+=e.attribution),x.push(new LayerInformation({resource:v,version:e.version,isHeightmap:o,tileUrlTemplates:l,availability:h,hasVertexNormals:i,hasWaterMask:r,hasMetadata:n,availabilityLevels:u,availabilityTilesLoaded:s,littleEndianExtensionSize:a}));e=e.parentUrl;if(defined(e)){if(!defined(h))return console.log("A layer.json can't have a parentUrl if it does't have an available array."),when.resolve();(v=v.getDerivedResource({url:e})).appendForwardSlash();e=(T=v.getDerivedResource({url:"layer.json"})).fetchJson();return when(e,D,w)}return when.resolve()}S=TileProviderError.handleError(S,A,A._errorEvent,t="The layer.json file does not specify any tile URL templates.",void 0,void 0,void 0,M)}else S=TileProviderError.handleError(S,A,A._errorEvent,t="The tile format is not specified in the layer.json file.",void 0,void 0,void 0,M)}function w(e){var t="An error occurred while accessing "+T.url+".";S=TileProviderError.handleError(S,A,A._errorEvent,t,void 0,void 0,void 0,M)}function r(e){D(e).then(function(){if(!defined(S)){var e,t=E.length;if(0<t)for(var i=A._availability=new TileAvailability(A._tilingScheme,P),r=0;r<t;++r)for(var n=E[r],a=0;a<n.length;++a){var o=n[a];i.addAvailableTileRange(r,o[0],o[1],o[2],o[3])}0<b.length&&(e=new Credit(b),defined(A._tileCredits)?A._tileCredits.push(e):A._tileCredits=[e]),A._ready=!0,A._readyPromise.resolve(!0)}})}function n(e){defined(e)&&404===e.statusCode?r({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]}):w()}function M(){when(T.fetchJson()).then(r).otherwise(n)}when(e.url).then(function(e){e=Resource.createIfNeeded(e);e.appendForwardSlash(),T=(v=e).getDerivedResource({url:"layer.json"}),A._tileCredits=e.credits,M()}).otherwise(function(e){i.reject(e)})}QuantizedMeshTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},QuantizedMeshTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var QuantizedMeshExtensionIds={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function getRequestHeader(e){return defined(e)&&0!==e.length?{Accept:"application/vnd.quantized-mesh;extensions="+e.join("-")+",application/octet-stream;q=0.9,*/*;q=0.01"}:{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function createHeightmapTerrainData(e,t,i,r,n){var a=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new HeightmapTerrainData({buffer:a,childTileMask:new Uint8Array(t,a.byteLength,1)[0],waterMask:new Uint8Array(t,a.byteLength+1,t.byteLength-a.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function createQuantizedMeshTerrainData(e,t,i,r,n,a){var o=a.littleEndianExtensionSize,s=0,l=3*Float64Array.BYTES_PER_ELEMENT,c=4*Float64Array.BYTES_PER_ELEMENT,u=3*Uint16Array.BYTES_PER_ELEMENT,d=Uint16Array.BYTES_PER_ELEMENT,h=3*d,p=new DataView(t),f=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),m=p.getFloat32(s+=l,!0);s+=Float32Array.BYTES_PER_ELEMENT;var g=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;var _=new BoundingSphere(new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),p.getFloat64(s+l,!0)),y=new Cartesian3(p.getFloat64(s+=c,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),C=p.getUint32(s+=l,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var v=new Uint16Array(t,s,3*C);s+=C*u,65536<C&&(h=3*(d=Uint32Array.BYTES_PER_ELEMENT));var T=v.subarray(0,C),c=v.subarray(C,2*C),l=v.subarray(2*C,3*C);AttributeCompression.zigZagDeltaDecode(T,c,l),s%d!=0&&(s+=d-s%d);u=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var S=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,3*u);s+=u*h;for(var A=0,x=S.length,b=0;b<x;++b){var E=S[b];S[b]=A-E,0===E&&++A}T=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;c=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,T),l=p.getUint32(s+=T*d,!0);s+=Uint32Array.BYTES_PER_ELEMENT;u=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,l),h=p.getUint32(s+=l*d,!0);s+=Uint32Array.BYTES_PER_ELEMENT;T=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,h),l=p.getUint32(s+=h*d,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var P,D,h=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,l);for(s+=l*d;s<p.byteLength;){var w=p.getUint8(s,!0);s+=Uint8Array.BYTES_PER_ELEMENT;var M=p.getUint32(s,o);if(s+=Uint32Array.BYTES_PER_ELEMENT,w===QuantizedMeshExtensionIds.OCT_VERTEX_NORMALS&&e._requestVertexNormals)P=new Uint8Array(t,s,2*C);else if(w===QuantizedMeshExtensionIds.WATER_MASK&&e._requestWaterMask)D=new Uint8Array(t,s,M);else if(w===QuantizedMeshExtensionIds.METADATA&&e._requestMetadata){w=p.getUint32(s,!0);if(0<w){var I=getJsonFromTypedArray(new Uint8Array(t),s+Uint32Array.BYTES_PER_ELEMENT,w).available;if(defined(I))for(var R=0;R<I.length;++R)for(var O=i+R+1,B=I[R],L=e._tilingScheme.getNumberOfYTilesAtLevel(O),F=0;F<B.length;++F){var N=B[F],V=L-N.endY-1,k=L-N.startY-1;e.availability.addAvailableTileRange(O,N.startX,V,N.endX,k),a.availability.addAvailableTileRange(O,N.startX,V,N.endX,k)}}a.availabilityTilesLoaded.addAvailableTileRange(i,r,n,r,n)}s+=M}l=5*e.getLevelMaximumGeometricError(i),d=e._tilingScheme.tileXYToRectangle(r,n,i);return new QuantizedMeshTerrainData({center:f,minimumHeight:m,maximumHeight:g,boundingSphere:_,orientedBoundingBox:OrientedBoundingBox.fromRectangle(d,m,g,e._tilingScheme.ellipsoid),horizonOcclusionPoint:y,quantizedVertices:v,encodedNormals:P,indices:S,westIndices:c,southIndices:u,eastIndices:T,northIndices:h,westSkirtHeight:l,southSkirtHeight:l,eastSkirtHeight:l,northSkirtHeight:l,childTileMask:e.availability.computeChildMaskForTile(i,r,n),waterMask:D,credits:e._tileCredits})}function requestTileGeometry$1(t,i,r,n,a,e){if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var o,s=a.tileUrlTemplates;if(0!==s.length){o=t._scheme&&"tms"!==t._scheme?r:t._tilingScheme.getNumberOfYTilesAtLevel(n)-r-1;var l,c=[];t._requestVertexNormals&&a.hasVertexNormals&&c.push(a.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),t._requestWaterMask&&a.hasWaterMask&&c.push("watermask"),t._requestMetadata&&a.hasMetadata&&c.push("metadata");var u=s[(i+o+n)%s.length],s=a.resource,c=defined(s._ionEndpoint)&&!defined(s._ionEndpoint.externalType)?(0!==c.length&&(l={extensions:c.join("-")}),getRequestHeader(void 0)):getRequestHeader(c),e=s.getDerivedResource({url:u,templateValues:{version:a.version,z:n,x:i,y:o},queryParameters:l,headers:c,request:e}).fetchArrayBuffer();if(defined(e))return e.then(function(e){return defined(t._heightmapStructure)?createHeightmapTerrainData(t,e):createQuantizedMeshTerrainData(t,e,n,i,r,a)})}}function getAvailabilityTile(e,t,i,r){if(0!==r){e=e.availabilityLevels,e=r%e==0?r-e:(r/e|0)*e,r=1<<r-e;return{level:e,x:t/r|0,y:i/r|0}}}function checkLayer(e,t,i,r,n,a){if(!defined(n.availabilityLevels))return{result:!1};for(var o,s,l,c=function(){delete n.availabilityPromiseCache[l]},u=n.availabilityTilesLoaded,d=n.availability,h=getAvailabilityTile(n,t,i,r);defined(h);){if(d.isTileAvailable(h.level,h.x,h.y)&&!u.isTileAvailable(h.level,h.x,h.y))return a||(l=h.level+"-"+h.x+"-"+h.y,defined(s=n.availabilityPromiseCache[l])||(o=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),defined(s=requestTileGeometry$1(e,h.x,h.y,h.level,n,o))&&(n.availabilityPromiseCache[l]=s).then(c))),{result:!0,promise:s};h=getAvailabilityTile(n,h.x,h.y,h.level)}return{result:!1}}CesiumTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n,a=this._layers,o=a.length;if(1===o)n=a[0];else for(var s=0;s<o;++s){var l=a[s];if(!defined(l.availability)||l.availability.isTileAvailable(i,e,t)){n=l;break}}return requestTileGeometry$1(this,e,t,i,n,r)},Object.defineProperties(CesiumTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}}),CesiumTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CesiumTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(defined(this._availability)){if(i>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(i,e,t))return!0;if(!this._hasMetadata)return!1;for(var r=this._layers,n=r.length,a=0;a<n;++a)if(checkLayer(this,e,t,i,r[a],0===a).result)return;return!1}},CesiumTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){if(!(!defined(this._availability)||i>this._availability._maximumLevel||this._availability.isTileAvailable(i,e,t))&&this._hasMetadata)for(var r=this._layers,n=r.length,a=0;a<n;++a){var o=checkLayer(this,e,t,i,r[a],0===a);if(defined(o.promise))return o.promise}},CesiumTerrainProvider._getAvailabilityTile=getAvailabilityTile;var EllipseGeometryLibrary={},rotAxis=new Cartesian3,tempVec=new Cartesian3,unitQuat=new Quaternion,rotMtx=new Matrix3;function pointOnEllipsoid(e,t,i,r,n,a,o,s,l,c){t=e+t;Cartesian3.multiplyByScalar(r,Math.cos(t),rotAxis),Cartesian3.multiplyByScalar(i,Math.sin(t),tempVec),Cartesian3.add(rotAxis,tempVec,rotAxis);t=Math.cos(e);t*=t;e=Math.sin(e);e*=e;e=a/Math.sqrt(o*t+n*e);return Quaternion.fromAxisAngle(rotAxis,e/s,unitQuat),Matrix3.fromQuaternion(unitQuat,rotMtx),Matrix3.multiplyByVector(rotMtx,l,c),Cartesian3.normalize(c,c),Cartesian3.multiplyByScalar(c,s,c),c}var scratchCartesian1$7=new Cartesian3,scratchCartesian2$a=new Cartesian3,scratchCartesian3$b=new Cartesian3,scratchNormal$6=new Cartesian3;EllipseGeometryLibrary.raisePositionsToHeight=function(e,t,i){for(var r=t.ellipsoid,n=t.height,a=t.extrudedHeight,t=i?e.length/3*2:e.length/3,o=new Float64Array(3*t),s=e.length,l=i?s:0,c=0;c<s;c+=3){var u=c+1,d=c+2,h=Cartesian3.fromArray(e,c,scratchCartesian1$7);r.scaleToGeodeticSurface(h,h);var p=Cartesian3.clone(h,scratchCartesian2$a),f=r.geodeticSurfaceNormal(h,scratchNormal$6),m=Cartesian3.multiplyByScalar(f,n,scratchCartesian3$b);Cartesian3.add(h,m,h),i&&(Cartesian3.multiplyByScalar(f,a,m),Cartesian3.add(p,m,p),o[c+l]=p.x,o[u+l]=p.y,o[d+l]=p.z),o[c]=h.x,o[u]=h.y,o[d]=h.z}return o};var unitPosScratch=new Cartesian3,eastVecScratch=new Cartesian3,northVecScratch=new Cartesian3;function GeometryInstance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=Matrix4.clone(defaultValue(e.modelMatrix,Matrix4.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=defaultValue(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}EllipseGeometryLibrary.computeEllipsePositions=function(e,t,i){var r=e.semiMinorAxis,n=e.semiMajorAxis,a=e.rotation,o=e.center,e=8*e.granularity,s=r*r,l=n*n,c=n*r,u=Cartesian3.magnitude(o),d=Cartesian3.normalize(o,unitPosScratch),h=Cartesian3.cross(Cartesian3.UNIT_Z,o,eastVecScratch),h=Cartesian3.normalize(h,h),p=Cartesian3.cross(d,h,northVecScratch),f=1+Math.ceil(CesiumMath.PI_OVER_TWO/e),m=CesiumMath.PI_OVER_TWO/(f-1),g=CesiumMath.PI_OVER_TWO-f*m;g<0&&(f-=Math.ceil(Math.abs(g)/m));var _,y,C,v,T=t?new Array(3*(f*(f+2)*2)):void 0,S=0,A=scratchCartesian1$7,x=scratchCartesian2$a,e=4*f*3,b=e-1,E=0,P=i?new Array(e):void 0,A=pointOnEllipsoid(g=CesiumMath.PI_OVER_TWO,a,p,h,s,c,l,u,d,A);for(t&&(T[S++]=A.x,T[S++]=A.y,T[S++]=A.z),i&&(P[b--]=A.z,P[b--]=A.y,P[b--]=A.x),g=CesiumMath.PI_OVER_TWO-m,_=1;_<f+1;++_){if(A=pointOnEllipsoid(g,a,p,h,s,c,l,u,d,A),x=pointOnEllipsoid(Math.PI-g,a,p,h,s,c,l,u,d,x),t){for(T[S++]=A.x,T[S++]=A.y,T[S++]=A.z,C=2*_+2,y=1;y<C-1;++y)v=Cartesian3.lerp(A,x,y/(C-1),scratchCartesian3$b),T[S++]=v.x,T[S++]=v.y,T[S++]=v.z;T[S++]=x.x,T[S++]=x.y,T[S++]=x.z}i&&(P[b--]=A.z,P[b--]=A.y,P[b--]=A.x,P[E++]=x.x,P[E++]=x.y,P[E++]=x.z),g=CesiumMath.PI_OVER_TWO-(_+1)*m}for(_=f;1<_;--_){if(A=pointOnEllipsoid(-(g=CesiumMath.PI_OVER_TWO-(_-1)*m),a,p,h,s,c,l,u,d,A),x=pointOnEllipsoid(g+Math.PI,a,p,h,s,c,l,u,d,x),t){for(T[S++]=A.x,T[S++]=A.y,T[S++]=A.z,C=2*(_-1)+2,y=1;y<C-1;++y)v=Cartesian3.lerp(A,x,y/(C-1),scratchCartesian3$b),T[S++]=v.x,T[S++]=v.y,T[S++]=v.z;T[S++]=x.x,T[S++]=x.y,T[S++]=x.z}i&&(P[b--]=A.z,P[b--]=A.y,P[b--]=A.x,P[E++]=x.x,P[E++]=x.y,P[E++]=x.z)}A=pointOnEllipsoid(-(g=CesiumMath.PI_OVER_TWO),a,p,h,s,c,l,u,d,A);e={};return t&&(T[S++]=A.x,T[S++]=A.y,T[S++]=A.z,e.positions=T,e.numPts=f),i&&(P[b--]=A.z,P[b--]=A.y,P[b--]=A.x,e.outerPositions=P),e};var scratchCartesian1$6=new Cartesian3,scratchCartesian2$9=new Cartesian3,scratchCartesian3$a=new Cartesian3;function barycentricCoordinates(e,t,i,r,n){var a,o,s,l,c,u,d;if(defined(n)||(n=new Cartesian3),defined(t.z)){if(Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian3.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian3.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian3.subtract(i,t,scratchCartesian1$6),o=Cartesian3.subtract(r,t,scratchCartesian2$9),s=Cartesian3.subtract(e,t,scratchCartesian3$a),l=Cartesian3.dot(a,a),h=Cartesian3.dot(a,o),c=Cartesian3.dot(a,s),u=Cartesian3.dot(o,o),d=Cartesian3.dot(o,s)}else{if(Cartesian2.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian2.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian2.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian2.subtract(i,t,scratchCartesian1$6),o=Cartesian2.subtract(r,t,scratchCartesian2$9),s=Cartesian2.subtract(e,t,scratchCartesian3$a),l=Cartesian2.dot(a,a),h=Cartesian2.dot(a,o),c=Cartesian2.dot(a,s),u=Cartesian2.dot(o,o),d=Cartesian2.dot(o,s)}n.y=u*c-h*d,n.z=l*d-h*c;var h=l*u-h*h;return 0!==n.y&&(n.y/=h),0!==n.z&&(n.z/=h),n.x=1-n.y-n.z,n}function EncodedCartesian3(){this.high=Cartesian3.clone(Cartesian3.ZERO),this.low=Cartesian3.clone(Cartesian3.ZERO)}EncodedCartesian3.encode=function(e,t){var i;return defined(t)||(t={high:0,low:0}),0<=e?(i=65536*Math.floor(e/65536),t.high=i,t.low=e-i):(i=65536*Math.floor(-e/65536),t.high=-i,t.low=e+i),t};var scratchEncode={high:0,low:0};EncodedCartesian3.fromCartesian=function(e,t){var i=(t=!defined(t)?new EncodedCartesian3:t).high,r=t.low;return EncodedCartesian3.encode(e.x,scratchEncode),i.x=scratchEncode.high,r.x=scratchEncode.low,EncodedCartesian3.encode(e.y,scratchEncode),i.y=scratchEncode.high,r.y=scratchEncode.low,EncodedCartesian3.encode(e.z,scratchEncode),i.z=scratchEncode.high,r.z=scratchEncode.low,t};var encodedP=new EncodedCartesian3;EncodedCartesian3.writeElements=function(e,t,i){EncodedCartesian3.fromCartesian(e,encodedP);var r=encodedP.high,e=encodedP.low;t[i]=r.x,t[i+1]=r.y,t[i+2]=r.z,t[i+3]=e.x,t[i+4]=e.y,t[i+5]=e.z};var Tipsify={calculateACMR:function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24),n=t.length;if(!defined(i))for(var i=0,a=0,o=t[a];a<n;)i<o&&(i=o),o=t[++a];for(var s=[],l=0;l<i+1;l++)s[l]=0;for(var c=r+1,u=0;u<n;++u)c-s[t[u]]>r&&(s[t[u]]=c,++c);return(c-r+1)/(n/3)}};Tipsify.tipsify=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24);function n(e,t,i,r,n,a,o){for(var s,l=-1,c=-1,u=0;u<i.length;){var d=i[u];r[d].numLiveTriangles&&(s=0,(c<(s=n-r[d].timeStamp+2*r[d].numLiveTriangles<=t?n-r[d].timeStamp:s)||-1===c)&&(c=s,l=d)),++u}return-1===l?function(e,t,i){for(;1<=t.length;){var r=t[t.length-1];if(t.splice(t.length-1,1),0<e[r].numLiveTriangles)return r}for(;f<i;){if(0<e[f].numLiveTriangles)return++f-1;++f}return-1}(r,a,o):l}var e=t.length,a=0,o=t[x=0],s=e;if(defined(i))a=i+1;else{for(;x<s;)a<o&&(a=o),o=t[++x];if(-1===a)return 0;++a}for(var l=[],c=0;c<a;c++)l[c]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};for(var u=x=0;x<s;)l[t[x]].vertexTriangles.push(u),++l[t[x]].numLiveTriangles,l[t[x+1]].vertexTriangles.push(u),++l[t[x+1]].numLiveTriangles,l[t[x+2]].vertexTriangles.push(u),++l[t[x+2]].numLiveTriangles,++u,x+=3;var d,h=0,p=r+1,f=1,m=[],g=[],_=0,y=[],C=e/3,v=[];for(c=0;c<C;c++)v[c]=!1;for(;-1!==h;){for(var T,m=[],S=(T=l[h]).vertexTriangles.length,A=0;A<S;++A)if(!v[u=T.vertexTriangles[A]]){v[u]=!0;for(var x=u+u+u,b=0;b<3;++b)d=t[x],m.push(d),g.push(d),y[_]=d,++_,--(d=l[d]).numLiveTriangles,p-d.timeStamp>r&&(d.timeStamp=p,++p),++x}h=n(0,r,m,l,p,g,a)}return y};var GeometryPipeline={};function addTriangle(e,t,i,r,n){e[t++]=i,e[t++]=r,e[t++]=r,e[t++]=n,e[t++]=n,e[t]=i}function trianglesToLines(e){for(var t=e.length,i=IndexDatatype$1.createTypedArray(t,t/3*6),r=0,n=0;n<t;n+=3,r+=6)addTriangle(i,r,e[n],e[n+1],e[n+2]);return i}function triangleStripToLines(e){var t=e.length;if(3<=t){var i=IndexDatatype$1.createTypedArray(t,6*(t-2));addTriangle(i,0,e[0],e[1],e[2]);for(var r=6,n=3;n<t;++n,r+=6)addTriangle(i,r,e[n-1],e[n],e[n-2]);return i}return new Uint16Array}function triangleFanToLines(e){if(0<e.length){for(var t=e.length-1,i=IndexDatatype$1.createTypedArray(t,6*(t-1)),r=e[0],n=0,a=1;a<t;++a,n+=6)addTriangle(i,n,r,e[a],e[a+1]);return i}return new Uint16Array}function copyAttributesDescriptions(e){var t,i,r={};for(t in e)e.hasOwnProperty(t)&&defined(e[t])&&defined(e[t].values)&&(i=e[t],r[t]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]}));return r}function copyVertex(e,t,i){for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values))for(var n=t[r],a=0;a<n.componentsPerAttribute;++a)e[r].values.push(n.values[i*n.componentsPerAttribute+a])}GeometryPipeline.toWireframe=function(e){var t=e.indices;if(defined(t)){switch(e.primitiveType){case PrimitiveType$1.TRIANGLES:e.indices=trianglesToLines(t);break;case PrimitiveType$1.TRIANGLE_STRIP:e.indices=triangleStripToLines(t);break;case PrimitiveType$1.TRIANGLE_FAN:e.indices=triangleFanToLines(t)}e.primitiveType=PrimitiveType$1.LINES}return e},GeometryPipeline.createLineSegmentsForVectors=function(e,t,i){t=defaultValue(t,"normal"),i=defaultValue(i,1e4);for(var r,n=e.attributes.position.values,a=e.attributes[t].values,o=n.length,s=new Float64Array(2*o),l=0,c=0;c<o;c+=3)s[l++]=n[c],s[l++]=n[c+1],s[l++]=n[c+2],s[l++]=n[c]+a[c]*i,s[l++]=n[c+1]+a[c+1]*i,s[l++]=n[c+2]+a[c+2]*i;e=e.boundingSphere;return defined(e)&&(r=new BoundingSphere(e.center,e.radius+i)),new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:PrimitiveType$1.LINES,boundingSphere:r})},GeometryPipeline.createAttributeLocations=function(e){for(var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],r=e.attributes,n={},a=0,o=i.length,s=0;s<o;++s){var l=i[s];defined(r[l])&&(n[l]=a++)}for(t in r)r.hasOwnProperty(t)&&!defined(n[t])&&(n[t]=a++);return n},GeometryPipeline.reorderForPreVertexCache=function(e){var t=Geometry.computeNumberOfVertices(e),i=e.indices;if(defined(i)){for(var r=new Int32Array(t),n=0;n<t;n++)r[n]=-1;for(var a,o=i,s=o.length,l=IndexDatatype$1.createTypedArray(t,s),c=0,u=0,d=0;c<s;)-1!==(a=r[o[c]])?l[u]=a:(r[a=o[c]]=d,l[u]=d,++d),++c,++u;e.indices=l;var h,p=e.attributes;for(h in p)if(p.hasOwnProperty(h)&&defined(p[h])&&defined(p[h].values)){for(var f=p[h],m=f.values,g=0,_=f.componentsPerAttribute,y=ComponentDatatype$1.createTypedArray(f.componentDatatype,d*_);g<t;){var C=r[g];if(-1!==C)for(var v=0;v<_;v++)y[_*C+v]=m[_*g+v];++g}f.values=y}}return e},GeometryPipeline.reorderForPostVertexCache=function(e,t){var i=e.indices;if(e.primitiveType===PrimitiveType$1.TRIANGLES&&defined(i)){for(var r=i.length,n=0,a=0;a<r;a++)i[a]>n&&(n=i[a]);e.indices=Tipsify.tipsify({indices:i,maximumIndex:n,cacheSize:t})}return e},GeometryPipeline.fitToUnsignedShortIndices=function(e){var t=[],i=Geometry.computeNumberOfVertices(e);if(defined(e.indices)&&i>=CesiumMath.SIXTY_FOUR_KILOBYTES){var r,n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes),l=e.indices,c=l.length;e.primitiveType===PrimitiveType$1.TRIANGLES?r=3:e.primitiveType===PrimitiveType$1.LINES?r=2:e.primitiveType===PrimitiveType$1.POINTS&&(r=1);for(var u=0;u<c;u+=r){for(var d=0;d<r;++d){var h=l[u+d],p=n[h];defined(p)||(p=o++,n[h]=p,copyVertex(s,e.attributes,h)),a.push(p)}o+r>=CesiumMath.SIXTY_FOUR_KILOBYTES&&(t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes))}0!==a.length&&t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var scratchProjectTo2DCartesian3=new Cartesian3,scratchProjectTo2DCartographic=new Cartographic;GeometryPipeline.projectTo2D=function(e,t,i,r,n){for(var a=e.attributes[t],o=(n=defined(n)?n:new GeographicProjection).ellipsoid,s=a.values,l=new Float64Array(s.length),c=0,u=0;u<s.length;u+=3){var d=Cartesian3.fromArray(s,u,scratchProjectTo2DCartesian3),d=o.cartesianToCartographic(d,scratchProjectTo2DCartographic),d=n.project(d,scratchProjectTo2DCartesian3);l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}return e.attributes[i]=a,e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),delete e.attributes[t],e};var encodedResult={high:0,low:0};GeometryPipeline.encodeAttribute=function(e,t,i,r){for(var n=e.attributes[t],a=n.values,o=a.length,s=new Float32Array(o),l=new Float32Array(o),c=0;c<o;++c)EncodedCartesian3.encode(a[c],encodedResult),s[c]=encodedResult.high,l[c]=encodedResult.low;n=n.componentsPerAttribute;return e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:n,values:s}),e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:n,values:l}),delete e.attributes[t],e};var scratchCartesian3$9=new Cartesian3;function transformPoint(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$9),Matrix4.multiplyByPoint(e,scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,i,n)}function transformVector(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$9),Matrix3.multiplyByVector(e,scratchCartesian3$9,scratchCartesian3$9),scratchCartesian3$9=Cartesian3.normalize(scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,i,n)}var inverseTranspose=new Matrix4,normalMatrix=new Matrix3;function findAttributesInAllGeometries(e,t){var i,r=e.length,n={},a=e[0][t].attributes;for(i in a)if(a.hasOwnProperty(i)&&defined(a[i])&&defined(a[i].values)){for(var o=a[i],s=o.values.length,l=!0,c=1;c<r;++c){var u=e[c][t].attributes[i];if(!defined(u)||o.componentDatatype!==u.componentDatatype||o.componentsPerAttribute!==u.componentsPerAttribute||o.normalize!==u.normalize){l=!1;break}s+=u.values.length}l&&(n[i]=new GeometryAttribute({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:ComponentDatatype$1.createTypedArray(o.componentDatatype,s)}))}return n}GeometryPipeline.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(Matrix4.equals(t,Matrix4.IDENTITY))return e;var i=e.geometry.attributes;transformPoint(t,i.position),transformPoint(t,i.prevPosition),transformPoint(t,i.nextPosition),(defined(i.normal)||defined(i.tangent)||defined(i.bitangent))&&(Matrix4.inverse(t,inverseTranspose),Matrix4.transpose(inverseTranspose,inverseTranspose),Matrix4.getMatrix3(inverseTranspose,normalMatrix),transformVector(normalMatrix,i.normal),transformVector(normalMatrix,i.tangent),transformVector(normalMatrix,i.bitangent));i=e.geometry.boundingSphere;return defined(i)&&(e.geometry.boundingSphere=BoundingSphere.transform(i,t,i)),e.modelMatrix=Matrix4.clone(Matrix4.IDENTITY),e};var tempScratch$1=new Cartesian3;function combineGeometries(e,t){var i,r,n=e.length;e[0].modelMatrix;var a,o,s,l=defined(e[0][t].indices),c=e[0][t].primitiveType,u=findAttributesInAllGeometries(e,t);for(i in u)if(u.hasOwnProperty(i))for(a=u[i].values,h=C=0;h<n;++h)for(s=(o=e[h][t].attributes[i].values).length,r=0;r<s;++r)a[C++]=o[r];if(l){for(var d=0,h=0;h<n;++h)d+=e[h][t].indices.length;var p=Geometry.computeNumberOfVertices(new Geometry({attributes:u,primitiveType:PrimitiveType$1.POINTS})),f=IndexDatatype$1.createTypedArray(p,d),m=0,g=0;for(h=0;h<n;++h){for(var _=e[h][t].indices,y=_.length,C=0;C<y;++C)f[m++]=g+_[C];g+=Geometry.computeNumberOfVertices(e[h][t])}p=f}var v=new Cartesian3,T=0;for(h=0;h<n;++h){if(!defined(S=e[h][t].boundingSphere)){v=void 0;break}Cartesian3.add(S.center,v,v)}if(defined(v))for(Cartesian3.divideByScalar(v,n,v),h=0;h<n;++h){var S=e[h][t].boundingSphere,A=Cartesian3.magnitude(Cartesian3.subtract(S.center,v,tempScratch$1))+S.radius;T<A&&(T=A)}return new Geometry({attributes:u,indices:p,primitiveType:c,boundingSphere:defined(v)?new BoundingSphere(v,T):void 0})}GeometryPipeline.combineInstances=function(e){for(var t=[],i=[],r=e.length,n=0;n<r;++n){var a=e[n];defined(a.geometry)?t.push(a):defined(a.westHemisphereGeometry)&&defined(a.eastHemisphereGeometry)&&i.push(a)}var o=[];return 0<t.length&&o.push(combineGeometries(t,"geometry")),0<i.length&&(o.push(combineGeometries(i,"westHemisphereGeometry")),o.push(combineGeometries(i,"eastHemisphereGeometry"))),o};var normal=new Cartesian3,v0=new Cartesian3,v1$1=new Cartesian3,v2$1=new Cartesian3;GeometryPipeline.computeNormal=function(e){for(var t=e.indices,i=e.attributes,r=i.position.values,n=i.position.values.length/3,a=t.length,o=new Array(n),s=new Array(a/3),l=new Array(a),c=0;c<n;c++)o[c]={indexOffset:0,count:0,currentCount:0};var u=0;for(c=0;c<a;c+=3){var d=t[c],h=t[c+1],p=t[c+2],f=3*d,m=3*h,g=3*p;v0.x=r[f],v0.y=r[1+f],v0.z=r[2+f],v1$1.x=r[m],v1$1.y=r[1+m],v1$1.z=r[2+m],v2$1.x=r[g],v2$1.y=r[1+g],v2$1.z=r[2+g],o[d].count++,o[h].count++,o[p].count++,Cartesian3.subtract(v1$1,v0,v1$1),Cartesian3.subtract(v2$1,v0,v2$1),s[u]=Cartesian3.cross(v1$1,v2$1,new Cartesian3),u++}var _,y=0;for(c=0;c<n;c++)o[c].indexOffset+=y,y+=o[c].count;for(c=u=0;c<a;c+=3)l[(_=o[t[c]]).indexOffset+_.currentCount]=u,_.currentCount++,l[(_=o[t[c+1]]).indexOffset+_.currentCount]=u,_.currentCount++,l[(_=o[t[c+2]]).indexOffset+_.currentCount]=u,_.currentCount++,u++;var C=new Float32Array(3*n);for(c=0;c<n;c++){var v=3*c;if(_=o[c],Cartesian3.clone(Cartesian3.ZERO,normal),0<_.count){for(u=0;u<_.count;u++)Cartesian3.add(normal,s[l[_.indexOffset+u]],normal);Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&Cartesian3.clone(s[l[_.indexOffset]],normal)}Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&(normal.z=1),Cartesian3.normalize(normal,normal),C[v]=normal.x,C[1+v]=normal.y,C[2+v]=normal.z}return e.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C}),e};var normalScratch$4=new Cartesian3,normalScale=new Cartesian3,tScratch=new Cartesian3;GeometryPipeline.computeTangentAndBitangent=function(e){e.attributes;for(var t=e.indices,i=e.attributes.position.values,r=e.attributes.normal.values,n=e.attributes.st.values,a=e.attributes.position.values.length/3,o=t.length,s=new Array(3*a),l=0;l<s.length;l++)s[l]=0;for(l=0;l<o;l+=3){var c,u=t[l],d=t[l+1],h=t[l+2],p=3*d,f=3*h,m=2*u,g=2*d,_=2*h,y=i[c=3*u],C=i[c+1],d=i[c+2],h=n[m],u=n[1+m],m=n[1+g]-u,u=n[1+_]-u,h=1/((n[g]-h)*u-(n[_]-h)*m),y=(u*(i[p]-y)-m*(i[f]-y))*h,C=(u*(i[p+1]-C)-m*(i[f+1]-C))*h,h=(u*(i[p+2]-d)-m*(i[f+2]-d))*h;s[c]+=y,s[c+1]+=C,s[c+2]+=h,s[p]+=y,s[p+1]+=C,s[p+2]+=h,s[f]+=y,s[f+1]+=C,s[f+2]+=h}var v=new Float32Array(3*a),T=new Float32Array(3*a);for(l=0;l<a;l++){p=(c=3*l)+1,f=c+2;var S=Cartesian3.fromArray(r,c,normalScratch$4),A=Cartesian3.fromArray(s,c,tScratch),x=Cartesian3.dot(S,A);Cartesian3.multiplyByScalar(S,x,normalScale),Cartesian3.normalize(Cartesian3.subtract(A,normalScale,A),A),v[c]=A.x,v[p]=A.y,v[f]=A.z,Cartesian3.normalize(Cartesian3.cross(S,A,A),A),T[c]=A.x,T[p]=A.y,T[f]=A.z}return e.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}),e.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:T}),e};var scratchCartesian2$8=new Cartesian2,toEncode1=new Cartesian3,toEncode2=new Cartesian3,toEncode3=new Cartesian3,encodeResult2=new Cartesian2;function indexTriangles(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexTriangleFan(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=1,i[1]=0,i[2]=2;for(var r=3,n=3;n<t;++n)i[r++]=n-1,i[r++]=0,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexTriangleStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=0,i[1]=1,i[2]=2,3<t&&(i[3]=0,i[4]=2,i[5]=3);for(var r=6,n=3;n<t-1;n+=2)i[r++]=n,i[r++]=n-1,i[r++]=n+1,n+2<t&&(i[r++]=n,i[r++]=n+1,i[r++]=n+2);return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexLines(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexLineStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*(t-1));i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexLineLoop(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*t);i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return i[r++]=t-1,i[r]=0,e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexPrimitive(e){switch(e.primitiveType){case PrimitiveType$1.TRIANGLE_FAN:return indexTriangleFan(e);case PrimitiveType$1.TRIANGLE_STRIP:return indexTriangleStrip(e);case PrimitiveType$1.TRIANGLES:return indexTriangles(e);case PrimitiveType$1.LINE_STRIP:return indexLineStrip(e);case PrimitiveType$1.LINE_LOOP:return indexLineLoop(e);case PrimitiveType$1.LINES:return indexLines(e)}return e}function offsetPointFromXZPlane(e,t){Math.abs(e.y)<CesiumMath.EPSILON6&&(e.y=t?-CesiumMath.EPSILON6:CesiumMath.EPSILON6)}function offsetTriangleFromXZPlane(e,t,i){if(0!==e.y&&0!==t.y&&0!==i.y)return offsetPointFromXZPlane(e,e.y<0),offsetPointFromXZPlane(t,t.y<0),void offsetPointFromXZPlane(i,i.y<0);var r=Math.abs(e.y),n=Math.abs(t.y),a=Math.abs(i.y),n=n<r?a<r?CesiumMath.sign(e.y):CesiumMath.sign(i.y):a<n?CesiumMath.sign(t.y):CesiumMath.sign(i.y),n=n<0;offsetPointFromXZPlane(e,n),offsetPointFromXZPlane(t,n),offsetPointFromXZPlane(i,n)}GeometryPipeline.compressVertices=function(e){var t=e.attributes.extrudeDirection;if(defined(t)){for(var i=t.values,r=i.length/3,n=new Float32Array(2*r),a=0,o=0;o<r;++o)Cartesian3.fromArray(i,3*o,toEncode1),Cartesian3.equals(toEncode1,Cartesian3.ZERO)?a+=2:(encodeResult2=AttributeCompression.octEncodeInRange(toEncode1,65535,encodeResult2),n[a++]=encodeResult2.x,n[a++]=encodeResult2.y);return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:n}),delete e.attributes.extrudeDirection,e}var s=e.attributes.normal,l=e.attributes.st,c=defined(s),u=defined(l);if(!c&&!u)return e;var d,h,p,f,m=e.attributes.tangent,t=e.attributes.bitangent,g=defined(m),_=defined(t);c&&(d=s.values),u&&(h=l.values),g&&(p=m.values),_&&(f=t.values);m=r=(c?d:h).length/(c?3:2),t=u&&c?2:1;m*=t+=g||_?1:0;var y=new Float32Array(m),C=0;for(o=0;o<r;++o){u&&(Cartesian2.fromArray(h,2*o,scratchCartesian2$8),y[C++]=AttributeCompression.compressTextureCoordinates(scratchCartesian2$8));var v=3*o;c&&defined(p)&&defined(f)?(Cartesian3.fromArray(d,v,toEncode1),Cartesian3.fromArray(p,v,toEncode2),Cartesian3.fromArray(f,v,toEncode3),AttributeCompression.octPack(toEncode1,toEncode2,toEncode3,scratchCartesian2$8),y[C++]=scratchCartesian2$8.x,y[C++]=scratchCartesian2$8.y):(c&&(Cartesian3.fromArray(d,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),g&&(Cartesian3.fromArray(p,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),_&&(Cartesian3.fromArray(f,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)))}return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:t,values:y}),c&&delete e.attributes.normal,u&&delete e.attributes.st,_&&delete e.attributes.bitangent,g&&delete e.attributes.tangent,e};var c3$1=new Cartesian3;function getXZIntersectionOffsetPoints(e,t,i,r){Cartesian3.add(e,Cartesian3.multiplyByScalar(Cartesian3.subtract(t,e,c3$1),e.y/(e.y-t.y),c3$1),i),Cartesian3.clone(i,r),offsetPointFromXZPlane(i,!0),offsetPointFromXZPlane(r,!1)}var u1=new Cartesian3,u2=new Cartesian3,q1=new Cartesian3,q2=new Cartesian3,splitTriangleResult={positions:new Array(7),indices:new Array(9)};function splitTriangle(e,t,i){if(!(0<=e.x||0<=t.x||0<=i.x)){offsetTriangleFromXZPlane(e,t,i);var r=e.y<0,n=t.y<0,a=i.y<0,o=0;o+=r?1:0,o+=n?1:0;var s=splitTriangleResult.indices;1==(o+=a?1:0)?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,r?(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2==o&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,r?n?a||(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=1,s[1]=2,s[3]=1,s[6]=0));s=splitTriangleResult.positions;return s[0]=e,s[1]=t,s[2]=i,s.length=3,1!=o&&2!=o||(s[3]=u1,s[4]=u2,s[5]=q1,s[6]=q2,s.length=7),splitTriangleResult}}function updateGeometryAfterSplit(e,t){var i=e.attributes;if(0!==i.position.values.length){for(var r in i)i.hasOwnProperty(r)&&defined(i[r])&&defined(i[r].values)&&((r=i[r]).values=ComponentDatatype$1.createTypedArray(r.componentDatatype,r.values));var n=Geometry.computeNumberOfVertices(e);return e.indices=IndexDatatype$1.createTypedArray(n,e.indices),t&&(e.boundingSphere=BoundingSphere.fromVertices(i.position.values)),e}}function copyGeometryForSplit(e){var t,i,r=e.attributes,n={};for(t in r)r.hasOwnProperty(t)&&defined(r[t])&&defined(r[t].values)&&(i=r[t],n[t]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]}));return new Geometry({attributes:n,indices:[],primitiveType:e.primitiveType})}function updateInstanceAfterSplit(e,t,i){var r=defined(e.geometry.boundingSphere);t=updateGeometryAfterSplit(t,r),defined(i=updateGeometryAfterSplit(i,r))&&!defined(t)?e.geometry=i:!defined(i)&&defined(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=i,e.geometry=void 0)}function generateBarycentricInterpolateFunction(l,c){var u=new l,d=new l,h=new l;return function(e,t,i,r,n,a,o,s){e=l.fromArray(n,e*c,u),t=l.fromArray(n,t*c,d),i=l.fromArray(n,i*c,h);l.multiplyByScalar(e,r.x,e),l.multiplyByScalar(t,r.y,t),l.multiplyByScalar(i,r.z,i);e=l.add(e,t,e);l.add(e,i,e),s&&l.normalize(e,e),l.pack(e,a,o*c)}}var interpolateAndPackCartesian4=generateBarycentricInterpolateFunction(Cartesian4,4),interpolateAndPackCartesian3=generateBarycentricInterpolateFunction(Cartesian3,3),interpolateAndPackCartesian2=generateBarycentricInterpolateFunction(Cartesian2,2),interpolateAndPackBoolean=function(e,t,i,r,n,a,o){e=n[e]*r.x,t=n[t]*r.y,r=n[i]*r.z;a[o]=e+t+r>CesiumMath.EPSILON6?1:0},p0Scratch=new Cartesian3,p1Scratch$2=new Cartesian3,p2Scratch$2=new Cartesian3,barycentricScratch=new Cartesian3;function computeTriangleAttributes(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){if(defined(a)||defined(o)||defined(s)||defined(l)||defined(c)||0!==p){var g,_=barycentricCoordinates(r,Cartesian3.fromArray(n,3*e,p0Scratch),Cartesian3.fromArray(n,3*t,p1Scratch$2),Cartesian3.fromArray(n,3*i,p2Scratch$2),barycentricScratch);if(defined(a)&&interpolateAndPackCartesian3(e,t,i,_,a,d.normal.values,m,!0),defined(c)&&(n=Cartesian3.fromArray(c,3*e,p0Scratch),a=Cartesian3.fromArray(c,3*t,p1Scratch$2),c=Cartesian3.fromArray(c,3*i,p2Scratch$2),Cartesian3.multiplyByScalar(n,_.x,n),Cartesian3.multiplyByScalar(a,_.y,a),Cartesian3.multiplyByScalar(c,_.z,c),Cartesian3.equals(n,Cartesian3.ZERO)&&Cartesian3.equals(a,Cartesian3.ZERO)&&Cartesian3.equals(c,Cartesian3.ZERO)?((g=p0Scratch).x=0,g.y=0,g.z=0):(g=Cartesian3.add(n,a,n),Cartesian3.add(g,c,g),Cartesian3.normalize(g,g)),Cartesian3.pack(g,d.extrudeDirection.values,3*m)),defined(u)&&interpolateAndPackBoolean(e,t,i,_,u,d.applyOffset.values,m),defined(o)&&interpolateAndPackCartesian3(e,t,i,_,o,d.tangent.values,m,!0),defined(s)&&interpolateAndPackCartesian3(e,t,i,_,s,d.bitangent.values,m,!0),defined(l)&&interpolateAndPackCartesian2(e,t,i,_,l,d.st.values,m),0<p)for(var y=0;y<p;y++){var C=h[y];genericInterpolate(e,t,i,_,m,f[C],d[C])}}}function genericInterpolate(e,t,i,r,n,a,o){var s=a.componentsPerAttribute,l=a.values,c=o.values;switch(s){case 4:interpolateAndPackCartesian4(e,t,i,r,l,c,n,!1);break;case 3:interpolateAndPackCartesian3(e,t,i,r,l,c,n,!1);break;case 2:interpolateAndPackCartesian2(e,t,i,r,l,c,n,!1);break;default:c[n]=l[e]*r.x+l[t]*r.y+l[i]*r.z}}function insertSplitPoint(e,t,i,r,n,a){var o=e.position.values.length/3;if(-1===n)return e.position.values.push(a.x,a.y,a.z),t.push(o),o;r=r[n],n=i[r];return-1===n?(i[r]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(n),n)}var NAMED_ATTRIBUTES={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function splitLongitudeTriangles(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.normal)?r.normal.values:void 0,o=defined(r.bitangent)?r.bitangent.values:void 0,s=defined(r.tangent)?r.tangent.values:void 0,l=defined(r.st)?r.st.values:void 0,c=defined(r.extrudeDirection)?r.extrudeDirection.values:void 0,u=defined(r.applyOffset)?r.applyOffset.values:void 0,d=i.indices,h=[];for(t in r)r.hasOwnProperty(t)&&!NAMED_ATTRIBUTES[t]&&defined(r[t])&&h.push(t);var p,f,m=h.length,g=copyGeometryForSplit(i),_=copyGeometryForSplit(i),y=[];y.length=n.length/3;var C=[];for(C.length=n.length/3,T=0;T<y.length;++T)y[T]=-1,C[T]=-1;for(var v=d.length,T=0;T<v;T+=3){var S=d[T],A=d[T+1],x=d[T+2],b=Cartesian3.fromArray(n,3*S),E=Cartesian3.fromArray(n,3*A),P=Cartesian3.fromArray(n,3*x),D=splitTriangle(b,E,P);if(defined(D)&&3<D.positions.length)for(var w=D.positions,M=D.indices,I=M.length,R=0;R<I;++R){var O=M[R],B=w[O],L=B.y<0?(p=_.attributes,f=_.indices,y):(p=g.attributes,f=g.indices,C);computeTriangleAttributes(S,A,x,B,n,a,s,o,l,c,u,p,h,m,r,insertSplitPoint(p,f,L,d,O<3?T+O:-1,B))}else defined(D)&&(b=D.positions[0],E=D.positions[1],P=D.positions[2]),L=b.y<0?(p=_.attributes,f=_.indices,y):(p=g.attributes,f=g.indices,C),computeTriangleAttributes(S,A,x,b,n,a,s,o,l,c,u,p,h,m,r,insertSplitPoint(p,f,L,d,T,b)),computeTriangleAttributes(S,A,x,E,n,a,s,o,l,c,u,p,h,m,r,insertSplitPoint(p,f,L,d,T+1,E)),computeTriangleAttributes(S,A,x,P,n,a,s,o,l,c,u,p,h,m,r,insertSplitPoint(p,f,L,d,T+2,P))}updateInstanceAfterSplit(e,_,g)}var xzPlane=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),offsetScratch$c=new Cartesian3,offsetPointScratch=new Cartesian3;function computeLineAttributes(e,t,i,r,n,a,o){defined(o)&&(r=Cartesian3.fromArray(r,3*e,p0Scratch),Cartesian3.equalsEpsilon(r,i,CesiumMath.EPSILON10)?a.applyOffset.values[n]=o[e]:a.applyOffset.values[n]=o[t])}function splitLongitudeLines(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.applyOffset)?r.applyOffset.values:void 0,o=i.indices,s=copyGeometryForSplit(i),l=copyGeometryForSplit(i),c=o.length,u=[];u.length=n.length/3;var d=[];for(d.length=n.length/3,t=0;t<u.length;++t)u[t]=-1,d[t]=-1;for(t=0;t<c;t+=2){var h=o[t],p=o[t+1],f=Cartesian3.fromArray(n,3*h,p0Scratch),m=Cartesian3.fromArray(n,3*p,p1Scratch$2);Math.abs(f.y)<CesiumMath.EPSILON6&&(f.y<0?f.y=-CesiumMath.EPSILON6:f.y=CesiumMath.EPSILON6),Math.abs(m.y)<CesiumMath.EPSILON6&&(m.y<0?m.y=-CesiumMath.EPSILON6:m.y=CesiumMath.EPSILON6);var g,_,y,C,v=s.attributes,T=s.indices,S=d,A=l.attributes,x=l.indices,b=u,E=IntersectionTests.lineSegmentPlane(f,m,xzPlane,p2Scratch$2);defined(E)?(g=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,5*CesiumMath.EPSILON9,offsetScratch$c),f.y<0&&(Cartesian3.negate(g,g),v=l.attributes,T=l.indices,S=u,A=s.attributes,x=s.indices,b=d),_=Cartesian3.add(E,g,offsetPointScratch),computeLineAttributes(h,p,f,n,insertSplitPoint(v,T,S,o,t,f),v,a),computeLineAttributes(h,p,_,n,insertSplitPoint(v,T,S,o,-1,_),v,a),Cartesian3.negate(g,g),Cartesian3.add(E,g,_),computeLineAttributes(h,p,_,n,insertSplitPoint(A,x,b,o,-1,_),A,a),computeLineAttributes(h,p,m,n,insertSplitPoint(A,x,b,o,t+1,m),A,a)):(A=f.y<0?(y=l.attributes,C=l.indices,u):(y=s.attributes,C=s.indices,d),computeLineAttributes(h,p,f,n,insertSplitPoint(y,C,A,o,t,f),y,a),computeLineAttributes(h,p,m,n,insertSplitPoint(y,C,A,o,t+1,m),y,a))}updateInstanceAfterSplit(e,l,s)}var cartesian2Scratch0=new Cartesian2,cartesian2Scratch1=new Cartesian2,cartesian3Scratch0=new Cartesian3,cartesian3Scratch2$1=new Cartesian3,cartesian3Scratch3$1=new Cartesian3,cartesian3Scratch4=new Cartesian3,cartesian3Scratch5=new Cartesian3,cartesian3Scratch6=new Cartesian3,cartesian4Scratch0=new Cartesian4;function updateAdjacencyAfterSplit(e){for(var e=e.attributes,t=e.position.values,i=e.prevPosition.values,r=e.nextPosition.values,n=t.length,a=0;a<n;a+=3){var o,s=Cartesian3.unpack(t,a,cartesian3Scratch0);0<s.x||(o=Cartesian3.unpack(i,a,cartesian3Scratch2$1),(s.y<0&&0<o.y||0<s.y&&o.y<0)&&(0<a-3?(i[a]=t[a-3],i[a+1]=t[a-2],i[a+2]=t[a-1]):Cartesian3.pack(s,i,a)),o=Cartesian3.unpack(r,a,cartesian3Scratch3$1),(s.y<0&&0<o.y||0<s.y&&o.y<0)&&(a+3<n?(r[a]=t[a+3],r[a+1]=t[a+4],r[a+2]=t[a+5]):Cartesian3.pack(s,r,a)))}}var offsetScalar=5*CesiumMath.EPSILON9,coplanarOffset=CesiumMath.EPSILON6;function splitLongitudePolyline(e){for(var t=e.geometry,i=t.attributes,r=i.position.values,n=i.prevPosition.values,a=i.nextPosition.values,o=i.expandAndWidth.values,s=defined(i.st)?i.st.values:void 0,l=defined(i.color)?i.color.values:void 0,c=copyGeometryForSplit(t),u=copyGeometryForSplit(t),d=!1,h=r.length/3,p=0;p<h;p+=4){var f=p,m=p+2,g=Cartesian3.fromArray(r,3*f,cartesian3Scratch0),_=Cartesian3.fromArray(r,3*m,cartesian3Scratch2$1);if(Math.abs(g.y)<coplanarOffset)for(g.y=coplanarOffset*(_.y<0?-1:1),r[3*p+1]=g.y,r[3*(p+1)+1]=g.y,D=3*f;D<3*f+12;D+=3)n[D]=r[3*p],n[D+1]=r[3*p+1],n[D+2]=r[3*p+2];if(Math.abs(_.y)<coplanarOffset)for(_.y=coplanarOffset*(g.y<0?-1:1),r[3*(p+2)+1]=_.y,r[3*(p+3)+1]=_.y,D=3*f;D<3*f+12;D+=3)a[D]=r[3*(p+2)],a[D+1]=r[3*(p+2)+1],a[D+2]=r[3*(p+2)+2];var y=c.attributes,C=c.indices,v=u.attributes,T=u.indices,S=IntersectionTests.lineSegmentPlane(g,_,xzPlane,cartesian3Scratch4);if(defined(S)){var d=!0,A=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,offsetScalar,cartesian3Scratch5);g.y<0&&(Cartesian3.negate(A,A),y=u.attributes,C=u.indices,v=c.attributes,T=c.indices);var x=Cartesian3.add(S,A,cartesian3Scratch6);y.position.values.push(g.x,g.y,g.z,g.x,g.y,g.z),y.position.values.push(x.x,x.y,x.z),y.position.values.push(x.x,x.y,x.z),y.prevPosition.values.push(n[3*f],n[3*f+1],n[3*f+2]),y.prevPosition.values.push(n[3*f+3],n[3*f+4],n[3*f+5]),y.prevPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),y.nextPosition.values.push(x.x,x.y,x.z),y.nextPosition.values.push(x.x,x.y,x.z),y.nextPosition.values.push(x.x,x.y,x.z),y.nextPosition.values.push(x.x,x.y,x.z),Cartesian3.negate(A,A),Cartesian3.add(S,A,x),v.position.values.push(x.x,x.y,x.z),v.position.values.push(x.x,x.y,x.z),v.position.values.push(_.x,_.y,_.z,_.x,_.y,_.z),v.prevPosition.values.push(x.x,x.y,x.z),v.prevPosition.values.push(x.x,x.y,x.z),v.prevPosition.values.push(x.x,x.y,x.z),v.prevPosition.values.push(x.x,x.y,x.z),v.nextPosition.values.push(_.x,_.y,_.z,_.x,_.y,_.z),v.nextPosition.values.push(a[3*m],a[3*m+1],a[3*m+2]),v.nextPosition.values.push(a[3*m+3],a[3*m+4],a[3*m+5]);var b=Cartesian2.fromArray(o,2*f,cartesian2Scratch0),E=Math.abs(b.y);y.expandAndWidth.values.push(-1,E,1,E),y.expandAndWidth.values.push(-1,-E,1,-E),v.expandAndWidth.values.push(-1,E,1,E),v.expandAndWidth.values.push(-1,-E,1,-E);A=Cartesian3.magnitudeSquared(Cartesian3.subtract(S,g,cartesian3Scratch3$1));if(A/=Cartesian3.magnitudeSquared(Cartesian3.subtract(_,g,cartesian3Scratch3$1)),defined(l)){for(var x=Cartesian4.fromArray(l,4*f,cartesian4Scratch0),P=Cartesian4.fromArray(l,4*m,cartesian4Scratch0),b=CesiumMath.lerp(x.x,P.x,A),E=CesiumMath.lerp(x.y,P.y,A),S=CesiumMath.lerp(x.z,P.z,A),P=CesiumMath.lerp(x.w,P.w,A),D=4*f;D<4*f+8;++D)y.color.values.push(l[D]);for(y.color.values.push(b,E,S,P),y.color.values.push(b,E,S,P),v.color.values.push(b,E,S,P),v.color.values.push(b,E,S,P),D=4*m;D<4*m+8;++D)v.color.values.push(l[D])}if(defined(s)){var P=Cartesian2.fromArray(s,2*f,cartesian2Scratch0),w=Cartesian2.fromArray(s,2*(p+3),cartesian2Scratch1),A=CesiumMath.lerp(P.x,w.x,A);for(D=2*f;D<2*f+4;++D)y.st.values.push(s[D]);for(y.st.values.push(A,P.y),y.st.values.push(A,w.y),v.st.values.push(A,P.y),v.st.values.push(A,w.y),D=2*m;D<2*m+4;++D)v.st.values.push(s[D])}w=y.position.values.length/3-4,C.push(w,w+2,w+1),C.push(w+1,w+2,w+3),w=v.position.values.length/3-4,T.push(w,w+2,w+1),T.push(w+1,w+2,w+3)}else{var M,T=g.y<0?(M=u.attributes,u.indices):(M=c.attributes,c.indices);for(M.position.values.push(g.x,g.y,g.z),M.position.values.push(g.x,g.y,g.z),M.position.values.push(_.x,_.y,_.z),M.position.values.push(_.x,_.y,_.z),D=3*p;D<3*p+12;++D)M.prevPosition.values.push(n[D]),M.nextPosition.values.push(a[D]);for(D=2*p;D<2*p+8;++D)M.expandAndWidth.values.push(o[D]),defined(s)&&M.st.values.push(s[D]);if(defined(l))for(D=4*p;D<4*p+16;++D)M.color.values.push(l[D]);w=M.position.values.length/3-4,T.push(w,w+2,w+1),T.push(w+1,w+2,w+3)}}d&&(updateAdjacencyAfterSplit(u),updateAdjacencyAfterSplit(c)),updateInstanceAfterSplit(e,u,c)}GeometryPipeline.splitLongitude=function(e){var t=e.geometry,i=t.boundingSphere;if(defined(i)&&(0<i.center.x-i.radius||BoundingSphere.intersectPlane(i,Plane.ORIGIN_ZX_PLANE)!==Intersect$1.INTERSECTING))return e;if(t.geometryType!==GeometryType$1.NONE)switch(t.geometryType){case GeometryType$1.POLYLINES:splitLongitudePolyline(e);break;case GeometryType$1.TRIANGLES:splitLongitudeTriangles(e);break;case GeometryType$1.LINES:splitLongitudeLines(e)}else indexPrimitive(t),t.primitiveType===PrimitiveType$1.TRIANGLES?splitLongitudeTriangles(e):t.primitiveType===PrimitiveType$1.LINES&&splitLongitudeLines(e);return e};var scratchCartesian1$5=new Cartesian3,scratchCartesian2$7=new Cartesian3,scratchCartesian3$8=new Cartesian3,scratchCartesian4$5=new Cartesian3,texCoordScratch=new Cartesian2,textureMatrixScratch$1=new Matrix3,tangentMatrixScratch$1=new Matrix3,quaternionScratch$3=new Quaternion,scratchNormal$5=new Cartesian3,scratchTangent$4=new Cartesian3,scratchBitangent$4=new Cartesian3,scratchCartographic$f=new Cartographic,projectedCenterScratch=new Cartesian3,scratchMinTexCoord=new Cartesian2,scratchMaxTexCoord=new Cartesian2;function computeTopBottomAttributes(e,t,i){var r=t.vertexFormat,n=t.center,a=t.semiMajorAxis,o=t.semiMinorAxis,s=t.ellipsoid,l=t.stRotation,c=i?e.length/3*2:e.length/3,u=t.shadowVolume,d=r.st?new Float32Array(2*c):void 0,h=r.normal?new Float32Array(3*c):void 0,p=r.tangent?new Float32Array(3*c):void 0,f=r.bitangent?new Float32Array(3*c):void 0,m=u?new Float32Array(3*c):void 0,g=0,_=scratchNormal$5,y=scratchTangent$4,C=scratchBitangent$4,v=new GeographicProjection(s),T=v.project(s.cartesianToCartographic(n,scratchCartographic$f),projectedCenterScratch),n=s.scaleToGeodeticSurface(n,scratchCartesian1$5);s.geodeticSurfaceNormal(n,n);var S=textureMatrixScratch$1,A=tangentMatrixScratch$1;A=0!==l?(F=Quaternion.fromAxisAngle(n,l,quaternionScratch$3),S=Matrix3.fromQuaternion(F,S),F=Quaternion.fromAxisAngle(n,-l,quaternionScratch$3),Matrix3.fromQuaternion(F,A)):(S=Matrix3.clone(Matrix3.IDENTITY,S),Matrix3.clone(Matrix3.IDENTITY,A));for(var x=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),b=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),E=e.length,P=i?E:0,D=P/3*2,w=0;w<E;w+=3){var M,I=w+1,R=w+2,O=Cartesian3.fromArray(e,w,scratchCartesian1$5);r.st&&(M=Matrix3.multiplyByVector(S,O,scratchCartesian2$7),M=v.project(s.cartesianToCartographic(M,scratchCartographic$f),scratchCartesian3$8),Cartesian3.subtract(M,T,M),texCoordScratch.x=(M.x+a)/(2*a),texCoordScratch.y=(M.y+o)/(2*o),x.x=Math.min(texCoordScratch.x,x.x),x.y=Math.min(texCoordScratch.y,x.y),b.x=Math.max(texCoordScratch.x,b.x),b.y=Math.max(texCoordScratch.y,b.y),i&&(d[g+D]=texCoordScratch.x,d[g+1+D]=texCoordScratch.y),d[g++]=texCoordScratch.x,d[g++]=texCoordScratch.y),(r.normal||r.tangent||r.bitangent||u)&&(_=s.geodeticSurfaceNormal(O,_),u&&(m[w+P]=-_.x,m[I+P]=-_.y,m[R+P]=-_.z),(r.normal||r.tangent||r.bitangent)&&((r.tangent||r.bitangent)&&(y=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,_,y),y),Matrix3.multiplyByVector(A,y,y)),r.normal&&(h[w]=_.x,h[I]=_.y,h[R]=_.z,i&&(h[w+P]=-_.x,h[I+P]=-_.y,h[R+P]=-_.z)),r.tangent&&(p[w]=y.x,p[I]=y.y,p[R]=y.z,i&&(p[w+P]=-y.x,p[I+P]=-y.y,p[R+P]=-y.z)),r.bitangent&&(C=Cartesian3.normalize(Cartesian3.cross(_,y,C),C),f[w]=C.x,f[I]=C.y,f[R]=C.z,i&&(f[w+P]=C.x,f[I+P]=C.y,f[R+P]=C.z))))}if(r.st)for(var E=d.length,B=0;B<E;B+=2)d[B]=(d[B]-x.x)/(b.x-x.x),d[B+1]=(d[B+1]-x.y)/(b.y-x.y);var L,F=new GeometryAttributes;return r.position&&(L=EllipseGeometryLibrary.raisePositionsToHeight(e,t,i),F.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:L})),r.st&&(F.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),r.normal&&(F.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),r.tangent&&(F.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),r.bitangent&&(F.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),u&&(F.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),i&&defined(t.offsetAttribute)&&(L=new Uint8Array(c),L=t.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(L,1,0,c/2):arrayFill(L,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),F.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:L})),F}function topIndices(e){for(var t,i,r=new Array(e*(e+1)*12-6),n=0,a=0,o=1,s=0;s<3;s++)r[n++]=o++,r[n++]=a,r[n++]=o;for(s=2;s<e+1;++s){for(o=s*(s+1)-1,a=(s-1)*s-1,r[n++]=o++,r[n++]=a,r[n++]=o,t=2*s,i=0;i<t-1;++i)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;r[n++]=o++,r[n++]=a,r[n++]=o}for(t=2*e,++o,++a,s=0;s<t-1;++s)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;for(r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a++,r[n++]=a,++a,s=e-1;1<s;--s){for(r[n++]=a++,r[n++]=a,r[n++]=o,t=2*s,i=0;i<t-1;++i)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;r[n++]=a++,r[n++]=a++,r[n++]=o++}for(s=0;s<3;s++)r[n++]=a++,r[n++]=a,r[n++]=o;return r}var boundingSphereCenter$1=new Cartesian3;function computeEllipse$1(e){var t=e.center;boundingSphereCenter$1=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter$1),e.height,boundingSphereCenter$1);var i=new BoundingSphere(boundingSphereCenter$1=Cartesian3.add(t,boundingSphereCenter$1,boundingSphereCenter$1),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!1),t=r.positions,r=r.numPts,e=computeTopBottomAttributes(t,e,!1),r=topIndices(r);return{boundingSphere:i,attributes:e,indices:r=IndexDatatype$1.createTypedArray(t.length/3,r)}}function computeWallAttributes(e,t){var i=t.vertexFormat,r=t.center,n=t.semiMajorAxis,a=t.semiMinorAxis,o=t.ellipsoid,s=t.height,l=t.extrudedHeight,c=t.stRotation,u=e.length/3*2,d=new Float64Array(3*u),h=i.st?new Float32Array(2*u):void 0,p=i.normal?new Float32Array(3*u):void 0,f=i.tangent?new Float32Array(3*u):void 0,m=i.bitangent?new Float32Array(3*u):void 0,g=t.shadowVolume,_=g?new Float32Array(3*u):void 0,y=0,C=scratchNormal$5,v=scratchTangent$4,T=scratchBitangent$4,S=new GeographicProjection(o),A=S.project(o.cartesianToCartographic(r,scratchCartographic$f),projectedCenterScratch),r=o.scaleToGeodeticSurface(r,scratchCartesian1$5);o.geodeticSurfaceNormal(r,r);for(var r=Quaternion.fromAxisAngle(r,c,quaternionScratch$3),x=Matrix3.fromQuaternion(r,textureMatrixScratch$1),b=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),E=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),P=(B=e.length)/3*2,D=0;D<B;D+=3){var w=D+1,M=D+2,I=Cartesian3.fromArray(e,D,scratchCartesian1$5);i.st&&(O=Matrix3.multiplyByVector(x,I,scratchCartesian2$7),R=S.project(o.cartesianToCartographic(O,scratchCartographic$f),scratchCartesian3$8),Cartesian3.subtract(R,A,R),texCoordScratch.x=(R.x+n)/(2*n),texCoordScratch.y=(R.y+a)/(2*a),b.x=Math.min(texCoordScratch.x,b.x),b.y=Math.min(texCoordScratch.y,b.y),E.x=Math.max(texCoordScratch.x,E.x),E.y=Math.max(texCoordScratch.y,E.y),h[y+P]=texCoordScratch.x,h[y+1+P]=texCoordScratch.y,h[y++]=texCoordScratch.x,h[y++]=texCoordScratch.y),I=o.scaleToGeodeticSurface(I,I),O=Cartesian3.clone(I,scratchCartesian2$7),C=o.geodeticSurfaceNormal(I,C),g&&(_[D+B]=-C.x,_[w+B]=-C.y,_[M+B]=-C.z);var R=Cartesian3.multiplyByScalar(C,s,scratchCartesian4$5),I=Cartesian3.add(I,R,I),R=Cartesian3.multiplyByScalar(C,l,R),O=Cartesian3.add(O,R,O);i.position&&(d[D+B]=O.x,d[w+B]=O.y,d[M+B]=O.z,d[D]=I.x,d[w]=I.y,d[M]=I.z),(i.normal||i.tangent||i.bitangent)&&(T=Cartesian3.clone(C,T),R=Cartesian3.fromArray(e,(D+3)%B,scratchCartesian4$5),Cartesian3.subtract(R,I,R),I=Cartesian3.subtract(O,I,scratchCartesian3$8),C=Cartesian3.normalize(Cartesian3.cross(I,R,C),C),i.normal&&(p[D]=C.x,p[w]=C.y,p[M]=C.z,p[D+B]=C.x,p[w+B]=C.y,p[M+B]=C.z),i.tangent&&(v=Cartesian3.normalize(Cartesian3.cross(T,C,v),v),f[D]=v.x,f[w]=v.y,f[M]=v.z,f[D+B]=v.x,f[D+1+B]=v.y,f[D+2+B]=v.z),i.bitangent&&(m[D]=T.x,m[w]=T.y,m[M]=T.z,m[D+B]=T.x,m[w+B]=T.y,m[M+B]=T.z))}if(i.st)for(var B=h.length,L=0;L<B;L+=2)h[L]=(h[L]-b.x)/(E.x-b.x),h[L+1]=(h[L+1]-b.y)/(E.y-b.y);c=new GeometryAttributes;return i.position&&(c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})),i.st&&(c.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),i.normal&&(c.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&(c.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),i.bitangent&&(c.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),g&&(c.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),defined(t.offsetAttribute)&&(r=new Uint8Array(u),r=t.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(r,1,0,u/2):arrayFill(r,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),c.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})),c}function computeWallIndices(e){for(var t=e.length/3,i=IndexDatatype$1.createTypedArray(t,6*t),r=0,n=0;n<t;n++){var a=n,o=n+t,s=(a+1)%t,l=s+t;i[r++]=a,i[r++]=o,i[r++]=s,i[r++]=s,i[r++]=o,i[r++]=l}return i}var topBoundingSphere$3=new BoundingSphere,bottomBoundingSphere$3=new BoundingSphere;function computeExtrudedEllipse$1(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$5),e.height,scratchCartesian1$5);topBoundingSphere$3.center=Cartesian3.add(t,n,topBoundingSphere$3.center),topBoundingSphere$3.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$3.center=Cartesian3.add(t,n,bottomBoundingSphere$3.center),bottomBoundingSphere$3.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!0),i=a.positions,t=a.numPts,n=a.outerPositions,r=BoundingSphere.union(topBoundingSphere$3,bottomBoundingSphere$3),a=computeTopBottomAttributes(i,e,!0),o=(c=topIndices(t)).length;c.length=2*o;for(var s=i.length/3,l=0;l<o;l+=3)c[l+o]=c[l+2]+s,c[l+1+o]=c[l+1]+s,c[l+2+o]=c[l]+s;var a=new Geometry({attributes:a,indices:IndexDatatype$1.createTypedArray(2*s/3,c),primitiveType:PrimitiveType$1.TRIANGLES}),e=computeWallAttributes(n,e),c=computeWallIndices(n),n=new Geometry({attributes:e,indices:IndexDatatype$1.createTypedArray(2*n.length/3,c),primitiveType:PrimitiveType$1.TRIANGLES}),n=GeometryPipeline.combineInstances([new GeometryInstance({geometry:a}),new GeometryInstance({geometry:n})]);return{boundingSphere:r,attributes:n[0].attributes,indices:n[0].indices}}function computeRectangle$3(e,t,i,r,n,a,o){for(var s=EllipseGeometryLibrary.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:i,rotation:r,granularity:n},!1,!0).outerPositions,l=s.length/3,c=new Array(l),u=0;u<l;++u)c[u]=Cartesian3.fromArray(s,3*u);o=Rectangle.fromCartesianArray(c,a,o);return o.width>CesiumMath.PI&&(o.north=0<o.north?CesiumMath.PI_OVER_TWO-CesiumMath.EPSILON7:o.north,o.south=o.south<0?CesiumMath.EPSILON7-CesiumMath.PI_OVER_TWO:o.south,o.east=CesiumMath.PI,o.west=-CesiumMath.PI),o}function EllipseGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._height=Math.max(l,s),this._granularity=a,this._vertexFormat=VertexFormat.clone(o),this._extrudedHeight=Math.min(l,s),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}EllipseGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+9,EllipseGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$7=new Cartesian3,scratchEllipsoid$e=new Ellipsoid,scratchVertexFormat$b=new VertexFormat,scratchOptions$l={center:scratchCenter$7,ellipsoid:scratchEllipsoid$e,vertexFormat:scratchVertexFormat$b,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function textureCoordinateRotationPoints$2(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];for(var i=EllipseGeometryLibrary.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,r=i.length/3,n=new Array(r),a=0;a<r;++a)n[a]=Cartesian3.fromArray(i,3*a);var o=e._ellipsoid,e=e.rectangle;return Geometry._textureCoordinateRotationPoints(n,t,o,e)}function CircleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,e={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new EllipseGeometry(e),this._workerName="createCircleGeometry"}EllipseGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$7);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$e);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$b);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],t=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._semiMajorAxis=o,i._semiMinorAxis=s,i._rotation=l,i._stRotation=c,i._height=u,i._granularity=d,i._extrudedHeight=h,i._shadowVolume=p,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$l.height=u,scratchOptions$l.extrudedHeight=h,scratchOptions$l.granularity=d,scratchOptions$l.stRotation=c,scratchOptions$l.rotation=l,scratchOptions$l.semiMajorAxis=o,scratchOptions$l.semiMinorAxis=s,scratchOptions$l.shadowVolume=p,scratchOptions$l.offsetAttribute=-1===t?void 0:t,new EllipseGeometry(scratchOptions$l))},EllipseGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=e.semiMajorAxis,a=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);return computeRectangle$3(i,n,a,defaultValue(e.rotation,0),o,r,t)},EllipseGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return r?(t.extrudedHeight=i,t.shadowVolume=e._shadowVolume,t.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse$1(t)):(n=computeEllipse$1(t),defined(e._offsetAttribute)&&(t=n.attributes.position.values.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}))),new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},EllipseGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new EllipseGeometry({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,rotation:e._rotation,stRotation:e._stRotation,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(EllipseGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$3(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$2(this)),this._textureCoordinateRotationPoints}}}),CircleGeometry.packedLength=EllipseGeometry.packedLength,CircleGeometry.pack=function(e,t,i){return EllipseGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry$1=new EllipseGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$k={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new VertexFormat,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};CircleGeometry.unpack=function(e,t,i){t=EllipseGeometry.unpack(e,t,scratchEllipseGeometry$1);return scratchOptions$k.center=Cartesian3.clone(t._center,scratchOptions$k.center),scratchOptions$k.ellipsoid=Ellipsoid.clone(t._ellipsoid,scratchOptions$k.ellipsoid),scratchOptions$k.height=t._height,scratchOptions$k.extrudedHeight=t._extrudedHeight,scratchOptions$k.granularity=t._granularity,scratchOptions$k.vertexFormat=VertexFormat.clone(t._vertexFormat,scratchOptions$k.vertexFormat),scratchOptions$k.stRotation=t._stRotation,scratchOptions$k.shadowVolume=t._shadowVolume,defined(i)?(scratchOptions$k.semiMajorAxis=t._semiMajorAxis,scratchOptions$k.semiMinorAxis=t._semiMinorAxis,i._ellipseGeometry=new EllipseGeometry(scratchOptions$k),i):(scratchOptions$k.radius=t._semiMajorAxis,new CircleGeometry(scratchOptions$k))},CircleGeometry.createGeometry=function(e){return EllipseGeometry.createGeometry(e._ellipseGeometry)},CircleGeometry.createShadowVolume=function(e,t,i){var r=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,t=t(r,n),i=i(r,n);return new CircleGeometry({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CircleGeometry.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});var scratchCartesian1$4=new Cartesian3,boundingSphereCenter=new Cartesian3;function computeEllipse(e){var t=e.center;boundingSphereCenter=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter),e.height,boundingSphereCenter);for(var i=new BoundingSphere(boundingSphereCenter=Cartesian3.add(t,boundingSphereCenter,boundingSphereCenter),e.semiMajorAxis),t=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,e=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(t,e,!1)})}),r=t.length/3,n=IndexDatatype$1.createTypedArray(r,2*r),a=0,o=0;o<r;++o)n[a++]=o,n[a++]=(o+1)%r;return{boundingSphere:i,attributes:e,indices:n}}var topBoundingSphere$2=new BoundingSphere,bottomBoundingSphere$2=new BoundingSphere;function computeExtrudedEllipse(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$4),e.height,scratchCartesian1$4);topBoundingSphere$2.center=Cartesian3.add(t,n,topBoundingSphere$2.center),topBoundingSphere$2.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$2.center=Cartesian3.add(t,n,bottomBoundingSphere$2.center),bottomBoundingSphere$2.radius=r;var t=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,n=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(t,e,!0)})}),t=n.position.values,r=BoundingSphere.union(topBoundingSphere$2,bottomBoundingSphere$2),a=t.length/3;defined(e.offsetAttribute)&&(o=new Uint8Array(a),o=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(o,1,0,a/2):arrayFill(o,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o}));var o=defaultValue(e.numberOfVerticalLines,16),o=CesiumMath.clamp(o,0,a/2),s=IndexDatatype$1.createTypedArray(a,2*a+2*o);a/=2;var l=0;for(d=0;d<a;++d)s[l++]=d,s[l++]=(d+1)%a,s[l++]=d+a,s[l++]=(d+1)%a+a;if(0<o)for(var e=Math.min(o,a),c=Math.round(a/e),u=Math.min(c*o,a),d=0;d<u;d+=c)s[l++]=d,s[l++]=d+a;return{boundingSphere:r,attributes:n,indices:s}}function EllipseOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.height,0),s=defaultValue(e.extrudedHeight,o);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._height=Math.max(s,o),this._granularity=a,this._extrudedHeight=Math.min(s,o),this._numberOfVerticalLines=Math.max(defaultValue(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}EllipseOutlineGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+8,EllipseOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$6=new Cartesian3,scratchEllipsoid$d=new Ellipsoid,scratchOptions$j={center:scratchCenter$6,ellipsoid:scratchEllipsoid$d,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function CircleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,e={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new EllipseOutlineGeometry(e),this._workerName="createCircleOutlineGeometry"}EllipseOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$6);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$d);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._semiMajorAxis=a,i._semiMinorAxis=o,i._rotation=s,i._height=l,i._granularity=c,i._extrudedHeight=u,i._numberOfVerticalLines=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$j.height=l,scratchOptions$j.extrudedHeight=u,scratchOptions$j.granularity=c,scratchOptions$j.rotation=s,scratchOptions$j.semiMajorAxis=a,scratchOptions$j.semiMinorAxis=o,scratchOptions$j.numberOfVerticalLines=d,scratchOptions$j.offsetAttribute=-1===t?void 0:t,new EllipseOutlineGeometry(scratchOptions$j))},EllipseOutlineGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return r?(t.extrudedHeight=i,t.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse(t)):(n=computeEllipse(t),defined(e._offsetAttribute)&&(t=n.attributes.position.values.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}))),new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},CircleOutlineGeometry.packedLength=EllipseOutlineGeometry.packedLength,CircleOutlineGeometry.pack=function(e,t,i){return EllipseOutlineGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry=new EllipseOutlineGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$i={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};CircleOutlineGeometry.unpack=function(e,t,i){t=EllipseOutlineGeometry.unpack(e,t,scratchEllipseGeometry);return scratchOptions$i.center=Cartesian3.clone(t._center,scratchOptions$i.center),scratchOptions$i.ellipsoid=Ellipsoid.clone(t._ellipsoid,scratchOptions$i.ellipsoid),scratchOptions$i.height=t._height,scratchOptions$i.extrudedHeight=t._extrudedHeight,scratchOptions$i.granularity=t._granularity,scratchOptions$i.numberOfVerticalLines=t._numberOfVerticalLines,defined(i)?(scratchOptions$i.semiMajorAxis=t._semiMajorAxis,scratchOptions$i.semiMinorAxis=t._semiMinorAxis,i._ellipseGeometry=new EllipseOutlineGeometry(scratchOptions$i),i):(scratchOptions$i.radius=t._semiMajorAxis,new CircleOutlineGeometry(scratchOptions$i))},CircleOutlineGeometry.createGeometry=function(e){return EllipseOutlineGeometry.createGeometry(e._ellipseGeometry)};var ClockRange={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2},ClockRange$1=Object.freeze(ClockRange),ClockStep={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2},ClockStep$1=Object.freeze(ClockStep),getTimestamp,getTimestamp="undefined"!=typeof performance&&"function"==typeof performance.now&&isFinite(performance.now())?function(){return performance.now()}:function(){return Date.now()},getTimestamp$1=getTimestamp,scratchArrayBuffer,scratchUint32Array,scratchUint8Array;function Clock(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).currentTime,i=e.startTime,r=e.stopTime,t=defined(t)?JulianDate.clone(t):defined(i)?JulianDate.clone(i):defined(r)?JulianDate.addDays(r,-1,new JulianDate):JulianDate.now(),i=defined(i)?JulianDate.clone(i):JulianDate.clone(t),r=defined(r)?JulianDate.clone(r):JulianDate.addDays(i,1,new JulianDate);this.startTime=i,this.stopTime=r,this.clockRange=defaultValue(e.clockRange,ClockRange$1.UNBOUNDED),this.canAnimate=defaultValue(e.canAnimate,!0),this.onTick=new Event,this.onStop=new Event,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=getTimestamp$1(),this.currentTime=t,this.multiplier=defaultValue(e.multiplier,1),this.shouldAnimate=defaultValue(e.shouldAnimate,!1),this.clockStep=defaultValue(e.clockStep,ClockStep$1.SYSTEM_CLOCK_MULTIPLIER)}function hue2rgb(e,t,i){return i<0&&(i+=1),1<i&&--i,6*i<1?e+6*(t-e)*i:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}function Color(e,t,i,r){this.red=defaultValue(e,1),this.green=defaultValue(t,1),this.blue=defaultValue(i,1),this.alpha=defaultValue(r,1)}Object.defineProperties(Clock.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){JulianDate.equals(this._currentTime,e)||(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===ClockStep$1.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=JulianDate.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}}),Clock.prototype.tick=function(){var e=getTimestamp$1(),t=JulianDate.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){var i=this._clockStep;if(i===ClockStep$1.SYSTEM_CLOCK)t=JulianDate.now(t);else{var r=this._multiplier;t=i===ClockStep$1.TICK_DEPENDENT?JulianDate.addSeconds(t,r,t):(n=e-this._lastSystemTime,JulianDate.addSeconds(t,r*(n/1e3),t));var n=this.clockRange,a=this.startTime,o=this.stopTime;if(n===ClockRange$1.CLAMPED)JulianDate.lessThan(t,a)?t=JulianDate.clone(a,t):JulianDate.greaterThan(t,o)&&(t=JulianDate.clone(o,t),this.onStop.raiseEvent(this));else if(n===ClockRange$1.LOOP_STOP)for(JulianDate.lessThan(t,a)&&(t=JulianDate.clone(a,t));JulianDate.greaterThan(t,o);)t=JulianDate.addSeconds(a,JulianDate.secondsDifference(t,o),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},Color.fromCartesian4=function(e,t){return defined(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new Color(e.x,e.y,e.z,e.w)},Color.fromBytes=function(e,t,i,r,n){return e=Color.byteToFloat(defaultValue(e,255)),t=Color.byteToFloat(defaultValue(t,255)),i=Color.byteToFloat(defaultValue(i,255)),r=Color.byteToFloat(defaultValue(r,255)),defined(n)?(n.red=e,n.green=t,n.blue=i,n.alpha=r,n):new Color(e,t,i,r)},Color.fromAlpha=function(e,t,i){return defined(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=t,i):new Color(e.red,e.green,e.blue,t)},FeatureDetection.supportsTypedArrays()&&(scratchArrayBuffer=new ArrayBuffer(4),scratchUint32Array=new Uint32Array(scratchArrayBuffer),scratchUint8Array=new Uint8Array(scratchArrayBuffer)),Color.fromRgba=function(e,t){return scratchUint32Array[0]=e,Color.fromBytes(scratchUint8Array[0],scratchUint8Array[1],scratchUint8Array[2],scratchUint8Array[3],t)},Color.fromHsl=function(e,t,i,r,n){e=defaultValue(e,0)%1,t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,1);var a=i,o=i,s=i;return 0!==t&&(a=hue2rgb(t=2*i-(i=i<.5?i*(1+t):i+t-i*t),i,e+1/3),o=hue2rgb(t,i,e),s=hue2rgb(t,i,e-1/3)),defined(n)?(n.red=a,n.green=o,n.blue=s,n.alpha=r,n):new Color(a,o,s,r)},Color.fromRandom=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).red;defined(i)||(r=defaultValue(e.minimumRed,0),n=defaultValue(e.maximumRed,1),i=r+CesiumMath.nextRandomNumber()*(n-r));var r,n=e.green;defined(n)||(a=defaultValue(e.minimumGreen,0),r=defaultValue(e.maximumGreen,1),n=a+CesiumMath.nextRandomNumber()*(r-a));var a=e.blue;defined(a)||(o=defaultValue(e.minimumBlue,0),s=defaultValue(e.maximumBlue,1),a=o+CesiumMath.nextRandomNumber()*(s-o));var o,s=e.alpha;return defined(s)||(o=defaultValue(e.minimumAlpha,0),e=defaultValue(e.maximumAlpha,1),s=o+CesiumMath.nextRandomNumber()*(e-o)),defined(t)?(t.red=i,t.green=n,t.blue=a,t.alpha=s,t):new Color(i,n,a,s)};var rgbaMatcher=/^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i,rrggbbaaMatcher=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i,rgbParenthesesMatcher=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,hslParenthesesMatcher=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;function ColorGeometryInstanceAttribute(e,t,i,r){e=defaultValue(e,1),t=defaultValue(t,1),i=defaultValue(i,1),r=defaultValue(r,1),this.value=new Uint8Array([Color.floatToByte(e),Color.floatToByte(t),Color.floatToByte(i),Color.floatToByte(r)])}function CompressedTextureBuffer(e,t,i,r,n){this._format=e,this._datatype=t,this._width=i,this._height=r,this._buffer=n}Color.fromCssColorString=function(e,t){defined(t)||(t=new Color);var i=Color[(e=e.replace(/\s/g,"")).toUpperCase()];if(defined(i))return Color.clone(i,t),t;i=rgbaMatcher.exec(e);return null!==i?(t.red=parseInt(i[1],16)/15,t.green=parseInt(i[2],16)/15,t.blue=parseInt(i[3],16)/15,t.alpha=parseInt(defaultValue(i[4],"f"),16)/15,t):null!==(i=rrggbbaaMatcher.exec(e))?(t.red=parseInt(i[1],16)/255,t.green=parseInt(i[2],16)/255,t.blue=parseInt(i[3],16)/255,t.alpha=parseInt(defaultValue(i[4],"ff"),16)/255,t):null!==(i=rgbParenthesesMatcher.exec(e))?(t.red=parseFloat(i[1])/("%"===i[1].substr(-1)?100:255),t.green=parseFloat(i[2])/("%"===i[2].substr(-1)?100:255),t.blue=parseFloat(i[3])/("%"===i[3].substr(-1)?100:255),t.alpha=parseFloat(defaultValue(i[4],"1.0")),t):null!==(i=hslParenthesesMatcher.exec(e))?Color.fromHsl(parseFloat(i[1])/360,parseFloat(i[2])/100,parseFloat(i[3])/100,parseFloat(defaultValue(i[4],"1.0")),t):t=void 0},Color.packedLength=4,Color.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.red,t[i++]=e.green,t[i++]=e.blue,t[i]=e.alpha,t},Color.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new Color:i).red=e[t++],i.green=e[t++],i.blue=e[t++],i.alpha=e[t],i},Color.byteToFloat=function(e){return e/255},Color.floatToByte=function(e){return 1===e?255:256*e|0},Color.clone=function(e,t){if(defined(e))return defined(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new Color(e.red,e.green,e.blue,e.alpha)},Color.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},Color.equalsArray=function(e,t,i){return e.red===t[i]&&e.green===t[i+1]&&e.blue===t[i+2]&&e.alpha===t[i+3]},Color.prototype.clone=function(e){return Color.clone(this,e)},Color.prototype.equals=function(e){return Color.equals(this,e)},Color.prototype.equalsEpsilon=function(e,t){return this===e||defined(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},Color.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},Color.prototype.toCssColorString=function(){var e=Color.floatToByte(this.red),t=Color.floatToByte(this.green),i=Color.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+i+")":"rgba("+e+","+t+","+i+","+this.alpha+")"},Color.prototype.toCssHexString=function(){var e=Color.floatToByte(this.red).toString(16);e.length<2&&(e="0"+e);var t=Color.floatToByte(this.green).toString(16);t.length<2&&(t="0"+t);var i=Color.floatToByte(this.blue).toString(16);if(i.length<2&&(i="0"+i),this.alpha<1){var r=Color.floatToByte(this.alpha).toString(16);return"#"+e+t+i+(r=r.length<2?"0"+r:r)}return"#"+e+t+i},Color.prototype.toBytes=function(e){var t=Color.floatToByte(this.red),i=Color.floatToByte(this.green),r=Color.floatToByte(this.blue),n=Color.floatToByte(this.alpha);return defined(e)?(e[0]=t,e[1]=i,e[2]=r,e[3]=n,e):[t,i,r,n]},Color.prototype.toRgba=function(){return scratchUint8Array[0]=Color.floatToByte(this.red),scratchUint8Array[1]=Color.floatToByte(this.green),scratchUint8Array[2]=Color.floatToByte(this.blue),scratchUint8Array[3]=Color.floatToByte(this.alpha),scratchUint32Array[0]},Color.prototype.brighten=function(e,t){return t.red=1-(1-this.red)*(e=1-e),t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},Color.prototype.darken=function(e,t){return t.red=this.red*(e=1-e),t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},Color.prototype.withAlpha=function(e,t){return Color.fromAlpha(this,e,t)},Color.add=function(e,t,i){return i.red=e.red+t.red,i.green=e.green+t.green,i.blue=e.blue+t.blue,i.alpha=e.alpha+t.alpha,i},Color.subtract=function(e,t,i){return i.red=e.red-t.red,i.green=e.green-t.green,i.blue=e.blue-t.blue,i.alpha=e.alpha-t.alpha,i},Color.multiply=function(e,t,i){return i.red=e.red*t.red,i.green=e.green*t.green,i.blue=e.blue*t.blue,i.alpha=e.alpha*t.alpha,i},Color.divide=function(e,t,i){return i.red=e.red/t.red,i.green=e.green/t.green,i.blue=e.blue/t.blue,i.alpha=e.alpha/t.alpha,i},Color.mod=function(e,t,i){return i.red=e.red%t.red,i.green=e.green%t.green,i.blue=e.blue%t.blue,i.alpha=e.alpha%t.alpha,i},Color.lerp=function(e,t,i,r){return r.red=CesiumMath.lerp(e.red,t.red,i),r.green=CesiumMath.lerp(e.green,t.green,i),r.blue=CesiumMath.lerp(e.blue,t.blue,i),r.alpha=CesiumMath.lerp(e.alpha,t.alpha,i),r},Color.multiplyByScalar=function(e,t,i){return i.red=e.red*t,i.green=e.green*t,i.blue=e.blue*t,i.alpha=e.alpha*t,i},Color.divideByScalar=function(e,t,i){return i.red=e.red/t,i.green=e.green/t,i.blue=e.blue/t,i.alpha=e.alpha/t,i},Color.ALICEBLUE=Object.freeze(Color.fromCssColorString("#F0F8FF")),Color.ANTIQUEWHITE=Object.freeze(Color.fromCssColorString("#FAEBD7")),Color.AQUA=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.AQUAMARINE=Object.freeze(Color.fromCssColorString("#7FFFD4")),Color.AZURE=Object.freeze(Color.fromCssColorString("#F0FFFF")),Color.BEIGE=Object.freeze(Color.fromCssColorString("#F5F5DC")),Color.BISQUE=Object.freeze(Color.fromCssColorString("#FFE4C4")),Color.BLACK=Object.freeze(Color.fromCssColorString("#000000")),Color.BLANCHEDALMOND=Object.freeze(Color.fromCssColorString("#FFEBCD")),Color.BLUE=Object.freeze(Color.fromCssColorString("#0000FF")),Color.BLUEVIOLET=Object.freeze(Color.fromCssColorString("#8A2BE2")),Color.BROWN=Object.freeze(Color.fromCssColorString("#A52A2A")),Color.BURLYWOOD=Object.freeze(Color.fromCssColorString("#DEB887")),Color.CADETBLUE=Object.freeze(Color.fromCssColorString("#5F9EA0")),Color.CHARTREUSE=Object.freeze(Color.fromCssColorString("#7FFF00")),Color.CHOCOLATE=Object.freeze(Color.fromCssColorString("#D2691E")),Color.CORAL=Object.freeze(Color.fromCssColorString("#FF7F50")),Color.CORNFLOWERBLUE=Object.freeze(Color.fromCssColorString("#6495ED")),Color.CORNSILK=Object.freeze(Color.fromCssColorString("#FFF8DC")),Color.CRIMSON=Object.freeze(Color.fromCssColorString("#DC143C")),Color.CYAN=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.DARKBLUE=Object.freeze(Color.fromCssColorString("#00008B")),Color.DARKCYAN=Object.freeze(Color.fromCssColorString("#008B8B")),Color.DARKGOLDENROD=Object.freeze(Color.fromCssColorString("#B8860B")),Color.DARKGRAY=Object.freeze(Color.fromCssColorString("#A9A9A9")),Color.DARKGREEN=Object.freeze(Color.fromCssColorString("#006400")),Color.DARKGREY=Color.DARKGRAY,Color.DARKKHAKI=Object.freeze(Color.fromCssColorString("#BDB76B")),Color.DARKMAGENTA=Object.freeze(Color.fromCssColorString("#8B008B")),Color.DARKOLIVEGREEN=Object.freeze(Color.fromCssColorString("#556B2F")),Color.DARKORANGE=Object.freeze(Color.fromCssColorString("#FF8C00")),Color.DARKORCHID=Object.freeze(Color.fromCssColorString("#9932CC")),Color.DARKRED=Object.freeze(Color.fromCssColorString("#8B0000")),Color.DARKSALMON=Object.freeze(Color.fromCssColorString("#E9967A")),Color.DARKSEAGREEN=Object.freeze(Color.fromCssColorString("#8FBC8F")),Color.DARKSLATEBLUE=Object.freeze(Color.fromCssColorString("#483D8B")),Color.DARKSLATEGRAY=Object.freeze(Color.fromCssColorString("#2F4F4F")),Color.DARKSLATEGREY=Color.DARKSLATEGRAY,Color.DARKTURQUOISE=Object.freeze(Color.fromCssColorString("#00CED1")),Color.DARKVIOLET=Object.freeze(Color.fromCssColorString("#9400D3")),Color.DEEPPINK=Object.freeze(Color.fromCssColorString("#FF1493")),Color.DEEPSKYBLUE=Object.freeze(Color.fromCssColorString("#00BFFF")),Color.DIMGRAY=Object.freeze(Color.fromCssColorString("#696969")),Color.DIMGREY=Color.DIMGRAY,Color.DODGERBLUE=Object.freeze(Color.fromCssColorString("#1E90FF")),Color.FIREBRICK=Object.freeze(Color.fromCssColorString("#B22222")),Color.FLORALWHITE=Object.freeze(Color.fromCssColorString("#FFFAF0")),Color.FORESTGREEN=Object.freeze(Color.fromCssColorString("#228B22")),Color.FUCHSIA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.GAINSBORO=Object.freeze(Color.fromCssColorString("#DCDCDC")),Color.GHOSTWHITE=Object.freeze(Color.fromCssColorString("#F8F8FF")),Color.GOLD=Object.freeze(Color.fromCssColorString("#FFD700")),Color.GOLDENROD=Object.freeze(Color.fromCssColorString("#DAA520")),Color.GRAY=Object.freeze(Color.fromCssColorString("#808080")),Color.GREEN=Object.freeze(Color.fromCssColorString("#008000")),Color.GREENYELLOW=Object.freeze(Color.fromCssColorString("#ADFF2F")),Color.GREY=Color.GRAY,Color.HONEYDEW=Object.freeze(Color.fromCssColorString("#F0FFF0")),Color.HOTPINK=Object.freeze(Color.fromCssColorString("#FF69B4")),Color.INDIANRED=Object.freeze(Color.fromCssColorString("#CD5C5C")),Color.INDIGO=Object.freeze(Color.fromCssColorString("#4B0082")),Color.IVORY=Object.freeze(Color.fromCssColorString("#FFFFF0")),Color.KHAKI=Object.freeze(Color.fromCssColorString("#F0E68C")),Color.LAVENDER=Object.freeze(Color.fromCssColorString("#E6E6FA")),Color.LAVENDAR_BLUSH=Object.freeze(Color.fromCssColorString("#FFF0F5")),Color.LAWNGREEN=Object.freeze(Color.fromCssColorString("#7CFC00")),Color.LEMONCHIFFON=Object.freeze(Color.fromCssColorString("#FFFACD")),Color.LIGHTBLUE=Object.freeze(Color.fromCssColorString("#ADD8E6")),Color.LIGHTCORAL=Object.freeze(Color.fromCssColorString("#F08080")),Color.LIGHTCYAN=Object.freeze(Color.fromCssColorString("#E0FFFF")),Color.LIGHTGOLDENRODYELLOW=Object.freeze(Color.fromCssColorString("#FAFAD2")),Color.LIGHTGRAY=Object.freeze(Color.fromCssColorString("#D3D3D3")),Color.LIGHTGREEN=Object.freeze(Color.fromCssColorString("#90EE90")),Color.LIGHTGREY=Color.LIGHTGRAY,Color.LIGHTPINK=Object.freeze(Color.fromCssColorString("#FFB6C1")),Color.LIGHTSEAGREEN=Object.freeze(Color.fromCssColorString("#20B2AA")),Color.LIGHTSKYBLUE=Object.freeze(Color.fromCssColorString("#87CEFA")),Color.LIGHTSLATEGRAY=Object.freeze(Color.fromCssColorString("#778899")),Color.LIGHTSLATEGREY=Color.LIGHTSLATEGRAY,Color.LIGHTSTEELBLUE=Object.freeze(Color.fromCssColorString("#B0C4DE")),Color.LIGHTYELLOW=Object.freeze(Color.fromCssColorString("#FFFFE0")),Color.LIME=Object.freeze(Color.fromCssColorString("#00FF00")),Color.LIMEGREEN=Object.freeze(Color.fromCssColorString("#32CD32")),Color.LINEN=Object.freeze(Color.fromCssColorString("#FAF0E6")),Color.MAGENTA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.MAROON=Object.freeze(Color.fromCssColorString("#800000")),Color.MEDIUMAQUAMARINE=Object.freeze(Color.fromCssColorString("#66CDAA")),Color.MEDIUMBLUE=Object.freeze(Color.fromCssColorString("#0000CD")),Color.MEDIUMORCHID=Object.freeze(Color.fromCssColorString("#BA55D3")),Color.MEDIUMPURPLE=Object.freeze(Color.fromCssColorString("#9370DB")),Color.MEDIUMSEAGREEN=Object.freeze(Color.fromCssColorString("#3CB371")),Color.MEDIUMSLATEBLUE=Object.freeze(Color.fromCssColorString("#7B68EE")),Color.MEDIUMSPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FA9A")),Color.MEDIUMTURQUOISE=Object.freeze(Color.fromCssColorString("#48D1CC")),Color.MEDIUMVIOLETRED=Object.freeze(Color.fromCssColorString("#C71585")),Color.MIDNIGHTBLUE=Object.freeze(Color.fromCssColorString("#191970")),Color.MINTCREAM=Object.freeze(Color.fromCssColorString("#F5FFFA")),Color.MISTYROSE=Object.freeze(Color.fromCssColorString("#FFE4E1")),Color.MOCCASIN=Object.freeze(Color.fromCssColorString("#FFE4B5")),Color.NAVAJOWHITE=Object.freeze(Color.fromCssColorString("#FFDEAD")),Color.NAVY=Object.freeze(Color.fromCssColorString("#000080")),Color.OLDLACE=Object.freeze(Color.fromCssColorString("#FDF5E6")),Color.OLIVE=Object.freeze(Color.fromCssColorString("#808000")),Color.OLIVEDRAB=Object.freeze(Color.fromCssColorString("#6B8E23")),Color.ORANGE=Object.freeze(Color.fromCssColorString("#FFA500")),Color.ORANGERED=Object.freeze(Color.fromCssColorString("#FF4500")),Color.ORCHID=Object.freeze(Color.fromCssColorString("#DA70D6")),Color.PALEGOLDENROD=Object.freeze(Color.fromCssColorString("#EEE8AA")),Color.PALEGREEN=Object.freeze(Color.fromCssColorString("#98FB98")),Color.PALETURQUOISE=Object.freeze(Color.fromCssColorString("#AFEEEE")),Color.PALEVIOLETRED=Object.freeze(Color.fromCssColorString("#DB7093")),Color.PAPAYAWHIP=Object.freeze(Color.fromCssColorString("#FFEFD5")),Color.PEACHPUFF=Object.freeze(Color.fromCssColorString("#FFDAB9")),Color.PERU=Object.freeze(Color.fromCssColorString("#CD853F")),Color.PINK=Object.freeze(Color.fromCssColorString("#FFC0CB")),Color.PLUM=Object.freeze(Color.fromCssColorString("#DDA0DD")),Color.POWDERBLUE=Object.freeze(Color.fromCssColorString("#B0E0E6")),Color.PURPLE=Object.freeze(Color.fromCssColorString("#800080")),Color.RED=Object.freeze(Color.fromCssColorString("#FF0000")),Color.ROSYBROWN=Object.freeze(Color.fromCssColorString("#BC8F8F")),Color.ROYALBLUE=Object.freeze(Color.fromCssColorString("#4169E1")),Color.SADDLEBROWN=Object.freeze(Color.fromCssColorString("#8B4513")),Color.SALMON=Object.freeze(Color.fromCssColorString("#FA8072")),Color.SANDYBROWN=Object.freeze(Color.fromCssColorString("#F4A460")),Color.SEAGREEN=Object.freeze(Color.fromCssColorString("#2E8B57")),Color.SEASHELL=Object.freeze(Color.fromCssColorString("#FFF5EE")),Color.SIENNA=Object.freeze(Color.fromCssColorString("#A0522D")),Color.SILVER=Object.freeze(Color.fromCssColorString("#C0C0C0")),Color.SKYBLUE=Object.freeze(Color.fromCssColorString("#87CEEB")),Color.SLATEBLUE=Object.freeze(Color.fromCssColorString("#6A5ACD")),Color.SLATEGRAY=Object.freeze(Color.fromCssColorString("#708090")),Color.SLATEGREY=Color.SLATEGRAY,Color.SNOW=Object.freeze(Color.fromCssColorString("#FFFAFA")),Color.SPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FF7F")),Color.STEELBLUE=Object.freeze(Color.fromCssColorString("#4682B4")),Color.TAN=Object.freeze(Color.fromCssColorString("#D2B48C")),Color.TEAL=Object.freeze(Color.fromCssColorString("#008080")),Color.THISTLE=Object.freeze(Color.fromCssColorString("#D8BFD8")),Color.TOMATO=Object.freeze(Color.fromCssColorString("#FF6347")),Color.TURQUOISE=Object.freeze(Color.fromCssColorString("#40E0D0")),Color.VIOLET=Object.freeze(Color.fromCssColorString("#EE82EE")),Color.WHEAT=Object.freeze(Color.fromCssColorString("#F5DEB3")),Color.WHITE=Object.freeze(Color.fromCssColorString("#FFFFFF")),Color.WHITESMOKE=Object.freeze(Color.fromCssColorString("#F5F5F5")),Color.YELLOW=Object.freeze(Color.fromCssColorString("#FFFF00")),Color.YELLOWGREEN=Object.freeze(Color.fromCssColorString("#9ACD32")),Color.TRANSPARENT=Object.freeze(new Color(0,0,0,0)),Object.defineProperties(ColorGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),ColorGeometryInstanceAttribute.fromColor=function(e){return new ColorGeometryInstanceAttribute(e.red,e.green,e.blue,e.alpha)},ColorGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?e.toBytes(t):new Uint8Array(e.toBytes())},ColorGeometryInstanceAttribute.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]},Object.defineProperties(CompressedTextureBuffer.prototype,{internalFormat:{get:function(){return this._format}},pixelDatatype:{get:function(){return this._datatype}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),CompressedTextureBuffer.clone=function(e){if(defined(e))return new CompressedTextureBuffer(e._format,e._datatype,e._width,e._height,e._buffer)},CompressedTextureBuffer.prototype.clone=function(){return CompressedTextureBuffer.clone(this)};var removeDuplicatesEpsilon=CesiumMath.EPSILON10;function arrayRemoveDuplicates(e,t,i,r){if(defined(e)){i=defaultValue(i,!1);var n=defined(r),a=e.length;if(a<2)return e;for(var o,s,l=e[0],c=0,u=-1,d=1;d<a;++d)t(l,o=e[d],removeDuplicatesEpsilon)?(defined(s)||(s=e.slice(0,d),c=d-1,u=0),n&&r.push(d)):(defined(s)&&(s.push(o),c=d,n&&(u=r.length)),l=o);return i&&t(e[0],e[a-1],removeDuplicatesEpsilon)&&(n&&(defined(s)?r.splice(u,0,c):r.push(a-1)),defined(s)?--s.length:s=e.slice(0,-1)),defined(s)?s:e}}var CoplanarPolygonGeometryLibrary={},scratchIntersectionPoint=new Cartesian3,scratchXAxis=new Cartesian3,scratchYAxis=new Cartesian3,scratchZAxis=new Cartesian3,obbScratch=new OrientedBoundingBox;function projectTo2D(e,t,i,r,n){t=Cartesian3.subtract(e,t,scratchIntersectionPoint),i=Cartesian3.dot(i,t),t=Cartesian3.dot(r,t);return Cartesian2.fromElements(i,t,n)}function calculateM(e,t,i){if(0===e)return t*i;var r=e*e,n=r*r,a=n*r,o=a*r,s=o*r,e=s*r,i=i;return t*((1-r/4-3*n/64-5*a/256-175*o/16384-441*s/65536-4851*e/1048576)*i-(3*r/8+3*n/32+45*a/1024+105*o/4096+2205*s/131072+6237*e/524288)*Math.sin(2*i)+(15*n/256+45*a/1024+525*o/16384+1575*s/65536+155925*e/8388608)*Math.sin(4*i)-(35*a/3072+175*o/12288+3675*s/262144+13475*e/1048576)*Math.sin(6*i)+(315*o/131072+2205*s/524288+43659*e/8388608)*Math.sin(8*i)-(693*s/1310720+6237*e/5242880)*Math.sin(10*i)+1001*e/8388608*Math.sin(12*i))}function calculateInverseM(e,t,i){var r=e/i;if(0===t)return r;var n=r*r,a=n*r,o=a*r,s=t*t,l=s*s,c=l*s,u=c*s,d=u*s,h=d*s,p=Math.sin(2*r),f=Math.cos(2*r),m=Math.sin(4*r),g=Math.cos(4*r),_=Math.sin(6*r),y=Math.cos(6*r),e=Math.sin(8*r),i=Math.cos(8*r),t=Math.sin(10*r);return r+r*s/4+7*r*l/64+15*r*c/256+579*r*u/16384+1515*r*d/65536+16837*r*h/1048576+(3*r*l/16+45*r*c/256-r*(32*n-561)*u/4096-r*(232*n-1677)*d/16384+r*(399985-90560*n+512*o)*h/5242880)*f+(21*r*c/256+483*r*u/4096-r*(224*n-1969)*d/16384-r*(33152*n-112599)*h/1048576)*g+(151*r*u/4096+4681*r*d/65536+1479*r*h/16384-453*a*h/32768)*y+(1097*r*d/65536+42783*r*h/1048576)*i+8011*r*h/1048576*Math.cos(10*r)+(3*s/8+3*l/16+213*c/2048-3*n*c/64+255*u/4096-33*n*u/512+20861*d/524288-33*n*d/512+o*d/1024+28273*h/1048576-471*n*h/8192+9*o*h/4096)*p+(21*l/256+21*c/256+533*u/8192-21*n*u/512+197*d/4096-315*n*d/4096+584039*h/16777216-12517*n*h/131072+7*o*h/2048)*m+(151*c/6144+151*u/4096+5019*d/131072-453*n*d/16384+26965*h/786432-8607*n*h/131072)*_+(1097*u/131072+1097*d/65536+225797*h/10485760-1097*n*h/65536)*e+(8011*d/2621440+8011*h/1048576)*t+293393*h/251658240*Math.sin(12*r)}function calculateSigma(e,t){if(0===e)return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)));var i=e*Math.sin(t);return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)))-e/2*Math.log((1+i)/(1-i))}function calculateHeading(e,t,i,r,n){i=calculateSigma(e._ellipticity,i),n=calculateSigma(e._ellipticity,n);return Math.atan2(CesiumMath.negativePiToPi(r-t),n-i)}function calculateArcLength(e,t,i,r,n,a,o){var s=e._heading,a=a-r,r=0;return r=CesiumMath.equalsEpsilon(Math.abs(s),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)?t===i?t*Math.cos(n)*CesiumMath.negativePiToPi(a):(i=Math.sin(n),t*Math.cos(n)*CesiumMath.negativePiToPi(a)/Math.sqrt(1-e._ellipticitySquared*i*i)):(n=calculateM(e._ellipticity,t,n),(calculateM(e._ellipticity,t,o)-n)/Math.cos(s)),Math.abs(r)}CoplanarPolygonGeometryLibrary.validOutline=function(e){var t=OrientedBoundingBox.fromPoints(e,obbScratch).halfAxes,i=Matrix3.getColumn(t,0,scratchXAxis),e=Matrix3.getColumn(t,1,scratchYAxis),t=Matrix3.getColumn(t,2,scratchZAxis),i=Cartesian3.magnitude(i),e=Cartesian3.magnitude(e),t=Cartesian3.magnitude(t);return!(0===i&&(0===e||0===t)||0===e&&0===t)},CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments=function(e,t,i,r){var n,a,o=OrientedBoundingBox.fromPoints(e,obbScratch),s=o.halfAxes,l=Matrix3.getColumn(s,0,scratchXAxis),c=Matrix3.getColumn(s,1,scratchYAxis),u=Matrix3.getColumn(s,2,scratchZAxis),d=Cartesian3.magnitude(l),h=Cartesian3.magnitude(c),e=Cartesian3.magnitude(u),s=Math.min(d,h,e);return(0!==d||0!==h&&0!==e)&&(0!==h||0!==e)&&(s!==h&&s!==e||(n=l),s===d?n=c:s===e&&(a=c),s!==d&&s!==h||(a=u),Cartesian3.normalize(n,i),Cartesian3.normalize(a,r),Cartesian3.clone(o.center,t),!0)},CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction=function(r,n,a){return function(e){for(var t=new Array(e.length),i=0;i<e.length;i++)t[i]=projectTo2D(e[i],r,n,a);return t}},CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction=function(i,r,n){return function(e,t){return projectTo2D(e,i,r,n,t)}};var scratchCart1$1=new Cartesian3,scratchCart2$2=new Cartesian3;function computeProperties$1(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$2),scratchCart1$1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$2),scratchCart2$2);var n=r.maximumRadius,a=r.minimumRadius,n=n*n;e._ellipticitySquared=(n-a*a)/n,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=Cartographic.clone(t,e._start),e._start.height=0,e._end=Cartographic.clone(i,e._end),e._end.height=0,e._heading=calculateHeading(e,t.longitude,t.latitude,i.longitude,i.latitude),e._distance=calculateArcLength(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude)}function interpolateUsingSurfaceDistance(e,t,i,r,n,a){if(0===i)return Cartographic.clone(e,a);var o,s,l,c=n*n;return l=Math.abs(CesiumMath.PI_OVER_TWO-Math.abs(t))>CesiumMath.EPSILON8?(o=calculateInverseM(calculateM(n,r,e.latitude)+i*Math.cos(t),n,r),l=calculateSigma(n,e.latitude),s=calculateSigma(n,o),l=Math.tan(t)*(s-l),CesiumMath.negativePiToPi(e.longitude+l)):(o=e.latitude,l=i/(0===n?r*Math.cos(e.latitude):(n=Math.sin(e.latitude),r*Math.cos(e.latitude)/Math.sqrt(1-c*n*n))),0<t?CesiumMath.negativePiToPi(e.longitude+l):CesiumMath.negativePiToPi(e.longitude-l)),defined(a)?(a.longitude=l,a.latitude=o,a.height=0,a):new Cartographic(l,o,0)}function EllipsoidRhumbLine(e,t,i){i=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,defined(e)&&defined(t)&&computeProperties$1(this,e,t,i)}Object.defineProperties(EllipsoidRhumbLine.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return this._heading}}}),EllipsoidRhumbLine.fromStartHeadingDistance=function(e,t,i,r,n){var a=defaultValue(r,Ellipsoid.WGS84),o=a.maximumRadius,s=a.minimumRadius,o=o*o,o=Math.sqrt((o-s*s)/o),o=interpolateUsingSurfaceDistance(e,t=CesiumMath.negativePiToPi(t),i,a.maximumRadius,o);return!defined(n)||defined(r)&&!r.equals(n.ellipsoid)?new EllipsoidRhumbLine(e,o,a):(n.setEndPoints(e,o),n)},EllipsoidRhumbLine.prototype.setEndPoints=function(e,t){computeProperties$1(this,e,t,this._ellipsoid)},EllipsoidRhumbLine.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},EllipsoidRhumbLine.prototype.interpolateUsingSurfaceDistance=function(e,t){return interpolateUsingSurfaceDistance(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},EllipsoidRhumbLine.prototype.findIntersectionWithLongitude=function(e,t){var i=this._ellipticity,r=this._heading,n=Math.abs(r),a=this._start;if(e=CesiumMath.negativePiToPi(e),CesiumMath.equalsEpsilon(Math.abs(e),Math.PI,CesiumMath.EPSILON14)&&(e=CesiumMath.sign(a.longitude)*Math.PI),defined(t)||(t=new Cartographic),Math.abs(CesiumMath.PI_OVER_TWO-n)<=CesiumMath.EPSILON8)return t.longitude=e,t.latitude=a.latitude,t.height=0,t;if(CesiumMath.equalsEpsilon(Math.abs(CesiumMath.PI_OVER_TWO-n),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))return CesiumMath.equalsEpsilon(e,a.longitude,CesiumMath.EPSILON12)?void 0:(t.longitude=e,t.latitude=CesiumMath.PI_OVER_TWO*CesiumMath.sign(CesiumMath.PI_OVER_TWO-r),t.height=0,t);var o=a.latitude,n=i*Math.sin(o),s=Math.tan(.5*(CesiumMath.PI_OVER_TWO+o))*Math.exp((e-a.longitude)/Math.tan(r)),l=(1+n)/(1-n),c=a.latitude;do{var u=c,d=i*Math.sin(u),c=2*Math.atan(s*Math.pow((1+d)/(1-d)/l,i/2))-CesiumMath.PI_OVER_TWO}while(!CesiumMath.equalsEpsilon(c,u,CesiumMath.EPSILON12));return t.longitude=e,t.latitude=c,t.height=0,t},EllipsoidRhumbLine.prototype.findIntersectionWithLatitude=function(e,t){var i=this._ellipticity,r=this._heading,n=this._start;if(!CesiumMath.equalsEpsilon(Math.abs(r),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){var a=calculateSigma(i,n.latitude),i=calculateSigma(i,e),a=Math.tan(r)*(i-a),a=CesiumMath.negativePiToPi(n.longitude+a);return defined(t)?(t.longitude=a,t.latitude=e,t.height=0,t):new Cartographic(a,e,0)}};var earcut_1=earcut,_default=earcut;function earcut(e,t,i){i=i||2;var r,n,a,o,s,l=t&&t.length,c=l?t[0]*i:e.length,u=linkedList(e,0,c,i,!0),d=[];if(!u||u.next===u.prev)return d;if(l&&(u=eliminateHoles(e,t,u,i)),e.length>80*i){for(var h=r=e[0],p=n=e[1],f=i;f<c;f+=i)(a=e[f])<h&&(h=a),(o=e[f+1])<p&&(p=o),r<a&&(r=a),n<o&&(n=o);s=0!==(s=Math.max(r-h,n-p))?1/s:0}return earcutLinked(u,d,i,h,p,s),d}function linkedList(e,t,i,r,n){var a,o;if(n===0<signedArea(e,t,i,r))for(a=t;a<i;a+=r)o=insertNode(a,e[a],e[a+1],o);else for(a=i-r;t<=a;a-=r)o=insertNode(a,e[a],e[a+1],o);return o&&equals(o,o.next)&&(removeNode(o),o=o.next),o}function filterPoints(e,t){if(!e)return e;t=t||e;var i,r=e;do{if(i=!1,r.steiner||!equals(r,r.next)&&0!==area(r.prev,r,r.next))r=r.next;else{if(removeNode(r),(r=t=r.prev)===r.next)break;i=!0}}while(i||r!==t);return t}function earcutLinked(e,t,i,r,n,a,o){if(e){!o&&a&&indexCurve(e,r,n,a);for(var s,l,c=e;e.prev!==e.next;)if(s=e.prev,l=e.next,a?isEarHashed(e,r,n,a):isEar(e))t.push(s.i/i),t.push(e.i/i),t.push(l.i/i),removeNode(e),e=l.next,c=l.next;else if((e=l)===c){o?1===o?earcutLinked(e=cureLocalIntersections(filterPoints(e),t,i),t,i,r,n,a,2):2===o&&splitEarcut(e,t,i,r,n,a):earcutLinked(filterPoints(e),t,i,r,n,a,1);break}}}function isEar(e){var t=e.prev,i=e,r=e.next;if(!(0<=area(t,i,r))){for(var n=e.next.next;n!==e.prev;){if(pointInTriangle(t.x,t.y,i.x,i.y,r.x,r.y,n.x,n.y)&&0<=area(n.prev,n,n.next))return;n=n.next}return 1}}function isEarHashed(e,t,i,r){var n=e.prev,a=e,o=e.next;if(!(0<=area(n,a,o))){for(var s=(n.x<a.x?n.x<o.x?n:o:a.x<o.x?a:o).x,l=(n.y<a.y?n.y<o.y?n:o:a.y<o.y?a:o).y,c=(n.x>a.x?n.x>o.x?n:o:a.x>o.x?a:o).x,u=(n.y>a.y?n.y>o.y?n:o:a.y>o.y?a:o).y,d=zOrder(s,l,t,i,r),h=zOrder(c,u,t,i,r),p=e.prevZ,f=e.nextZ;p&&p.z>=d&&f&&f.z<=h;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return;if(p=p.prevZ,f!==e.prev&&f!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,f.x,f.y)&&0<=area(f.prev,f,f.next))return;f=f.nextZ}for(;p&&p.z>=d;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return;p=p.prevZ}for(;f&&f.z<=h;){if(f!==e.prev&&f!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,f.x,f.y)&&0<=area(f.prev,f,f.next))return;f=f.nextZ}return 1}}function cureLocalIntersections(e,t,i){var r=e;do{var n=r.prev,a=r.next.next}while(!equals(n,a)&&intersects$1(n,r,r.next,a)&&locallyInside(n,a)&&locallyInside(a,n)&&(t.push(n.i/i),t.push(r.i/i),t.push(a.i/i),removeNode(r),removeNode(r.next),r=e=a),(r=r.next)!==e);return filterPoints(r)}function splitEarcut(e,t,i,r,n,a){var o=e;do{for(var s=o.next.next;s!==o.prev;){if(o.i!==s.i&&isValidDiagonal(o,s)){var l=splitPolygon(o,s),o=filterPoints(o,o.next),l=filterPoints(l,l.next);return earcutLinked(o,t,i,r,n,a),void earcutLinked(l,t,i,r,n,a)}s=s.next}}while((o=o.next)!==e)}function eliminateHoles(e,t,i,r){for(var n,a=[],o=0,s=t.length;o<s;o++)(n=linkedList(e,t[o]*r,o<s-1?t[o+1]*r:e.length,r,!1))===n.next&&(n.steiner=!0),a.push(getLeftmost(n));for(a.sort(compareX),o=0;o<a.length;o++)i=filterPoints(i=eliminateHole(a[o],i),i.next);return i}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){var i=findHoleBridge(e,t);if(!i)return t;var r=splitPolygon(i,e),e=filterPoints(i,i.next);return filterPoints(r,r.next),t===i?e:t}function findHoleBridge(e,t){var i,r=t,n=e.x,a=e.y,o=-1/0;do{if(a<=r.y&&a>=r.next.y&&r.next.y!==r.y){var s=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&o<s){if((o=s)===n){if(a===r.y)return r;if(a===r.next.y)return r.next}i=r.x<r.next.x?r:r.next}}}while((r=r.next)!==t);if(!i)return null;if(n===o)return i;for(var l,c=i,u=i.x,d=i.y,h=1/0,r=i;n>=r.x&&r.x>=u&&n!==r.x&&pointInTriangle(a<d?n:o,a,u,d,a<d?o:n,a,r.x,r.y)&&(l=Math.abs(a-r.y)/(n-r.x),locallyInside(r,e)&&(l<h||l===h&&(r.x>i.x||r.x===i.x&&sectorContainsSector(i,r)))&&(i=r,h=l)),(r=r.next)!==c;);return i}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,i,r){for(var n=e;null===n.z&&(n.z=zOrder(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,(n=n.next)!==e;);n.prevZ.nextZ=null,n.prevZ=null,sortLinked(n)}function sortLinked(e){var t,i,r,n,a,o,s,l,c=1;do{for(i=e,a=e=null,o=0;i;){for(o++,r=i,t=s=0;t<c&&(s++,r=r.nextZ);t++);for(l=c;0<s||0<l&&r;)0!==s&&(0===l||!r||i.z<=r.z)?(i=(n=i).nextZ,s--):(r=(n=r).nextZ,l--),a?a.nextZ=n:e=n,n.prevZ=a,a=n;i=r}}while(a.nextZ=null,c*=2,1<o);return e}function zOrder(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*n)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*n)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){for(var t=e,i=e;(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),(t=t.next)!==e;);return i}function pointInTriangle(e,t,i,r,n,a,o,s){return 0<=(n-o)*(t-s)-(e-o)*(a-s)&&0<=(e-o)*(r-s)-(i-o)*(t-s)&&0<=(i-o)*(a-s)-(n-o)*(r-s)}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&0<area(e.prev,e,e.next)&&0<area(t.prev,t,t.next))}function area(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects$1(e,t,i,r){var n=sign(area(e,t,i)),a=sign(area(e,t,r)),o=sign(area(i,r,e)),s=sign(area(i,r,t));return n!==a&&o!==s||(0===n&&onSegment(e,i,t)||(0===a&&onSegment(e,r,t)||(0===o&&onSegment(i,e,r)||!(0!==s||!onSegment(i,t,r)))))}function onSegment(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function sign(e){return 0<e?1:e<0?-1:0}function intersectsPolygon(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&intersects$1(i,i.next,e,t))return 1}while((i=i.next)!==e)}function locallyInside(e,t){return area(e.prev,e,e.next)<0?0<=area(e,t,e.next)&&0<=area(e,e.prev,t):area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){for(var i=e,r=!1,n=(e.x+t.x)/2,a=(e.y+t.y)/2;i.y>a!=i.next.y>a&&i.next.y!==i.y&&n<(i.next.x-i.x)*(a-i.y)/(i.next.y-i.y)+i.x&&(r=!r),(i=i.next)!==e;);return r}function splitPolygon(e,t){var i=new Node$4(e.i,e.x,e.y),r=new Node$4(t.i,t.x,t.y),n=e.next,a=t.prev;return(e.next=t).prev=e,(i.next=n).prev=i,(r.next=i).prev=r,(a.next=r).prev=a,r}function insertNode(e,t,i,r){i=new Node$4(e,t,i);return r?(i.next=r.next,(i.prev=r).next.prev=i,r.next=i):(i.prev=i).next=i,i}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node$4(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,i,r){for(var n=0,a=t,o=i-r;a<i;a+=r)n+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return n}earcut.deviation=function(e,t,i,r){var n=t&&t.length,a=n?t[0]*i:e.length,o=Math.abs(signedArea(e,0,a,i));if(n)for(var s=0,l=t.length;s<l;s++){var c=t[s]*i,u=s<l-1?t[s+1]*i:e.length;o-=Math.abs(signedArea(e,c,u,i))}for(var d=0,s=0;s<r.length;s+=3){var h=r[s]*i,p=r[s+1]*i,f=r[s+2]*i;d+=Math.abs((e[h]-e[f])*(e[1+p]-e[1+h])-(e[h]-e[p])*(e[1+f]-e[1+h]))}return 0===o&&0===d?0:Math.abs((d-o)/o)},earcut.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var a=0;a<e[n].length;a++)for(var o=0;o<t;o++)i.vertices.push(e[n][a][o]);0<n&&(r+=e[n-1].length,i.holes.push(r))}return i},earcut_1.default=_default;var WindingOrder={CLOCKWISE:WebGLConstants$1.CW,COUNTER_CLOCKWISE:WebGLConstants$1.CCW,validate:function(e){return e===WindingOrder.CLOCKWISE||e===WindingOrder.COUNTER_CLOCKWISE}},WindingOrder$1=Object.freeze(WindingOrder),scaleToGeodeticHeightN=new Cartesian3,scaleToGeodeticHeightP=new Cartesian3,PolygonPipeline={computeArea2D:function(e){for(var t=e.length,i=0,r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];i+=a.x*o.y-o.x*a.y}return.5*i},computeWindingOrder2D:function(e){return 0<PolygonPipeline.computeArea2D(e)?WindingOrder$1.COUNTER_CLOCKWISE:WindingOrder$1.CLOCKWISE},triangulate:function(e,t){e=Cartesian2.packArray(e);return earcut_1(e,t,2)}},subdivisionV0Scratch=new Cartesian3,subdivisionV1Scratch=new Cartesian3,subdivisionV2Scratch=new Cartesian3,subdivisionS0Scratch=new Cartesian3,subdivisionS1Scratch=new Cartesian3,subdivisionS2Scratch=new Cartesian3,subdivisionMidScratch=new Cartesian3;PolygonPipeline.computeSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);for(var n=i.slice(0),a=t.length,o=new Array(3*a),s=0,l=0;l<a;l++){var c=t[l];o[s++]=c.x,o[s++]=c.y,o[s++]=c.z}for(var u=[],d={},h=e.maximumRadius,r=CesiumMath.chordLength(r,h),p=r*r;0<n.length;){var f,m,g=n.pop(),_=n.pop(),y=n.pop(),C=Cartesian3.fromArray(o,3*y,subdivisionV0Scratch),v=Cartesian3.fromArray(o,3*_,subdivisionV1Scratch),T=Cartesian3.fromArray(o,3*g,subdivisionV2Scratch),S=Cartesian3.multiplyByScalar(Cartesian3.normalize(C,subdivisionS0Scratch),h,subdivisionS0Scratch),A=Cartesian3.multiplyByScalar(Cartesian3.normalize(v,subdivisionS1Scratch),h,subdivisionS1Scratch),x=Cartesian3.multiplyByScalar(Cartesian3.normalize(T,subdivisionS2Scratch),h,subdivisionS2Scratch),b=Cartesian3.magnitudeSquared(Cartesian3.subtract(S,A,subdivisionMidScratch)),A=Cartesian3.magnitudeSquared(Cartesian3.subtract(A,x,subdivisionMidScratch)),x=Cartesian3.magnitudeSquared(Cartesian3.subtract(x,S,subdivisionMidScratch)),S=Math.max(b,A,x);p<S?b===S?(defined(l=d[f=Math.min(y,_)+" "+Math.max(y,_)])||(m=Cartesian3.add(C,v,subdivisionMidScratch),Cartesian3.multiplyByScalar(m,.5,m),o.push(m.x,m.y,m.z),l=o.length/3-1,d[f]=l),n.push(y,l,g),n.push(l,_,g)):A===S?(defined(l=d[f=Math.min(_,g)+" "+Math.max(_,g)])||(m=Cartesian3.add(v,T,subdivisionMidScratch),Cartesian3.multiplyByScalar(m,.5,m),o.push(m.x,m.y,m.z),l=o.length/3-1,d[f]=l),n.push(_,l,y),n.push(l,g,y)):x===S&&(defined(l=d[f=Math.min(g,y)+" "+Math.max(g,y)])||(m=Cartesian3.add(T,C,subdivisionMidScratch),Cartesian3.multiplyByScalar(m,.5,m),o.push(m.x,m.y,m.z),l=o.length/3-1,d[f]=l),n.push(g,l,_),n.push(l,y,_)):(u.push(y),u.push(_),u.push(g))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})};var subdivisionC0Scratch=new Cartographic,subdivisionC1Scratch=new Cartographic,subdivisionC2Scratch=new Cartographic,subdivisionCartographicScratch=new Cartographic;function Queue(){this._array=[],this._offset=0,this._length=0}PolygonPipeline.computeRhumbLineSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);for(var n=i.slice(0),a=t.length,o=new Array(3*a),s=0,l=0;l<a;l++){var c=t[l];o[s++]=c.x,o[s++]=c.y,o[s++]=c.z}for(var u=[],d={},i=e.maximumRadius,h=CesiumMath.chordLength(r,i),p=new EllipsoidRhumbLine(void 0,void 0,e),f=new EllipsoidRhumbLine(void 0,void 0,e),m=new EllipsoidRhumbLine(void 0,void 0,e);0<n.length;){var g=n.pop(),_=n.pop(),y=n.pop(),C=Cartesian3.fromArray(o,3*y,subdivisionV0Scratch),v=Cartesian3.fromArray(o,3*_,subdivisionV1Scratch),T=Cartesian3.fromArray(o,3*g,subdivisionV2Scratch),S=e.cartesianToCartographic(C,subdivisionC0Scratch),A=e.cartesianToCartographic(v,subdivisionC1Scratch),x=e.cartesianToCartographic(T,subdivisionC2Scratch);p.setEndPoints(S,A);var b=p.surfaceDistance;f.setEndPoints(A,x);C=f.surfaceDistance;m.setEndPoints(x,S);var E,P,D,w,v=m.surfaceDistance,T=Math.max(b,C,v);h<T?b===T?(defined(l=d[E=Math.min(y,_)+" "+Math.max(y,_)])||(P=p.interpolateUsingFraction(.5,subdivisionCartographicScratch),D=.5*(S.height+A.height),w=Cartesian3.fromRadians(P.longitude,P.latitude,D,e,subdivisionMidScratch),o.push(w.x,w.y,w.z),l=o.length/3-1,d[E]=l),n.push(y,l,g),n.push(l,_,g)):C===T?(defined(l=d[E=Math.min(_,g)+" "+Math.max(_,g)])||(P=f.interpolateUsingFraction(.5,subdivisionCartographicScratch),D=.5*(A.height+x.height),w=Cartesian3.fromRadians(P.longitude,P.latitude,D,e,subdivisionMidScratch),o.push(w.x,w.y,w.z),l=o.length/3-1,d[E]=l),n.push(_,l,y),n.push(l,g,y)):v===T&&(defined(l=d[E=Math.min(g,y)+" "+Math.max(g,y)])||(P=m.interpolateUsingFraction(.5,subdivisionCartographicScratch),D=.5*(x.height+S.height),w=Cartesian3.fromRadians(P.longitude,P.latitude,D,e,subdivisionMidScratch),o.push(w.x,w.y,w.z),l=o.length/3-1,d[E]=l),n.push(g,l,_),n.push(l,y,_)):(u.push(y),u.push(_),u.push(g))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})},PolygonPipeline.scaleToGeodeticHeight=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84);var n=scaleToGeodeticHeightN,a=scaleToGeodeticHeightP;if(t=defaultValue(t,0),r=defaultValue(r,!0),defined(e))for(var o=e.length,s=0;s<o;s+=3)Cartesian3.fromArray(e,s,a),r&&(a=i.scaleToGeodeticSurface(a,a)),0!==t&&(n=i.geodeticSurfaceNormal(a,n),Cartesian3.multiplyByScalar(n,t,n),Cartesian3.add(a,n,a)),e[s]=a.x,e[s+1]=a.y,e[s+2]=a.z;return e},Object.defineProperties(Queue.prototype,{length:{get:function(){return this._length}}}),Queue.prototype.enqueue=function(e){this._array.push(e),this._length++},Queue.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,i=e[t];return e[t]=void 0,10<++t&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,i}},Queue.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},Queue.prototype.contains=function(e){return-1!==this._array.indexOf(e)},Queue.prototype.clear=function(){this._array.length=this._offset=this._length=0},Queue.prototype.sort=function(e){0<this._offset&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)};var PolygonGeometryLibrary={computeHierarchyPackedLength:function(e){for(var t=0,i=[e];0<i.length;){var r=i.pop();if(defined(r)){t+=2;var n=r.positions,a=r.holes;if(defined(n)&&(t+=n.length*Cartesian3.packedLength),defined(a))for(var o=a.length,s=0;s<o;++s)i.push(a[s])}}return t},packPolygonHierarchy:function(e,t,i){for(var r=[e];0<r.length;){var n=r.pop();if(defined(n)){var a=n.positions,o=n.holes;if(t[i++]=defined(a)?a.length:0,t[i++]=defined(o)?o.length:0,defined(a))for(var s=a.length,l=0;l<s;++l,i+=3)Cartesian3.pack(a[l],t,i);if(defined(o))for(var c=o.length,u=0;u<c;++u)r.push(o[u])}}return i},unpackPolygonHierarchy:function(e,t){for(var i=e[t++],r=e[t++],n=new Array(i),a=0<r?new Array(r):void 0,o=0;o<i;++o,t+=Cartesian3.packedLength)n[o]=Cartesian3.unpack(e,t);for(var s=0;s<r;++s)a[s]=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t),t=a[s].startingIndex,delete a[s].startingIndex;return{positions:n,holes:a,startingIndex:t}}},distanceScratch=new Cartesian3;function getPointAtDistance(e,t,i,r){return Cartesian3.subtract(t,e,distanceScratch),Cartesian3.multiplyByScalar(distanceScratch,i/r,distanceScratch),Cartesian3.add(e,distanceScratch,distanceScratch),[distanceScratch.x,distanceScratch.y,distanceScratch.z]}PolygonGeometryLibrary.subdivideLineCount=function(e,t,i){t=Cartesian3.distance(e,t),i=Math.max(0,Math.ceil(CesiumMath.log2(t/i)));return Math.pow(2,i)};var scratchCartographic0$1=new Cartographic,scratchCartographic1$2=new Cartographic,scratchCartographic2$1=new Cartographic,scratchCartesian0=new Cartesian3;PolygonGeometryLibrary.subdivideRhumbLineCount=function(e,t,i,r){r=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(i,scratchCartographic1$2),e).surfaceDistance/r,r=Math.max(0,Math.ceil(CesiumMath.log2(r)));return Math.pow(2,r)},PolygonGeometryLibrary.subdivideLine=function(e,t,i,r){var n=PolygonGeometryLibrary.subdivideLineCount(e,t,i),a=Cartesian3.distance(e,t),o=a/n,s=r=!defined(r)?[]:r;s.length=3*n;for(var l=0,c=0;c<n;c++){var u=getPointAtDistance(e,t,c*o,a);s[l++]=u[0],s[l++]=u[1],s[l++]=u[2]}return s},PolygonGeometryLibrary.subdivideRhumbLine=function(e,t,i,r,n){var a=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(i,scratchCartographic1$2),e),r=a.surfaceDistance/r,r=Math.max(0,Math.ceil(CesiumMath.log2(r))),o=Math.pow(2,r),s=a.surfaceDistance/o,l=n=!defined(n)?[]:n;l.length=3*o;for(var c=0,u=0;u<o;u++){var d=a.interpolateUsingSurfaceDistance(u*s,scratchCartographic2$1),d=e.cartographicToCartesian(d,scratchCartesian0);l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}return l};var scaleToGeodeticHeightN1=new Cartesian3,scaleToGeodeticHeightN2=new Cartesian3,scaleToGeodeticHeightP1=new Cartesian3,scaleToGeodeticHeightP2=new Cartesian3;PolygonGeometryLibrary.scaleToGeodeticHeightExtruded=function(e,t,i,r,n){r=defaultValue(r,Ellipsoid.WGS84);var a=scaleToGeodeticHeightN1,o=scaleToGeodeticHeightN2,s=scaleToGeodeticHeightP1,l=scaleToGeodeticHeightP2;if(defined(e)&&defined(e.attributes)&&defined(e.attributes.position))for(var c=e.attributes.position.values,u=c.length/2,d=0;d<u;d+=3)Cartesian3.fromArray(c,d,s),r.geodeticSurfaceNormal(s,a),l=r.scaleToGeodeticSurface(s,l),o=Cartesian3.multiplyByScalar(a,i,o),o=Cartesian3.add(l,o,o),c[d+u]=o.x,c[d+1+u]=o.y,c[d+2+u]=o.z,n&&(l=Cartesian3.clone(s,l)),o=Cartesian3.multiplyByScalar(a,t,o),o=Cartesian3.add(l,o,o),c[d]=o.x,c[d+1]=o.y,c[d+2]=o.z;return e},PolygonGeometryLibrary.polygonOutlinesFromHierarchy=function(e,t,i){var r,n,a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s=o.dequeue(),l=s.positions;if(t)for(n=l.length,u=0;u<n;u++)i.scaleToGeodeticSurface(l[u],l[u]);if(!((l=arrayRemoveDuplicates(l,Cartesian3.equalsEpsilon,!0)).length<3)){for(var c=s.holes?s.holes.length:0,u=0;u<c;u++){var d=s.holes[u],h=d.positions;if(t)for(n=h.length,r=0;r<n;++r)i.scaleToGeodeticSurface(h[r],h[r]);if(!((h=arrayRemoveDuplicates(h,Cartesian3.equalsEpsilon,!0)).length<3)){a.push(h);var p=0;for(defined(d.holes)&&(p=d.holes.length),r=0;r<p;r++)o.enqueue(d.holes[r])}}a.push(l)}}return a},PolygonGeometryLibrary.polygonsFromHierarchy=function(e,t,i,r){var n=[],a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s,l=o.dequeue(),c=l.positions,u=l.holes;if(i)for(s=c.length,g=0;g<s;g++)r.scaleToGeodeticSurface(c[g],c[g]);if(!((c=arrayRemoveDuplicates(c,Cartesian3.equalsEpsilon,!0)).length<3))if(defined(v=t(c))){var d=[];PolygonPipeline.computeWindingOrder2D(v)===WindingOrder$1.CLOCKWISE&&(v.reverse(),c=c.slice().reverse());for(var h,p=c.slice(),f=defined(u)?u.length:0,m=[],g=0;g<f;g++){var _=u[g],y=_.positions;if(i)for(s=y.length,h=0;h<s;++h)r.scaleToGeodeticSurface(y[h],y[h]);if(!((y=arrayRemoveDuplicates(y,Cartesian3.equalsEpsilon,!0)).length<3)){var C=t(y);if(defined(C)){PolygonPipeline.computeWindingOrder2D(C)===WindingOrder$1.CLOCKWISE&&(C.reverse(),y=y.slice().reverse()),m.push(y),d.push(p.length);var p=p.concat(y),v=v.concat(C),T=0;for(defined(_.holes)&&(T=_.holes.length),h=0;h<T;h++)o.enqueue(_.holes[h])}}}n.push({outerRing:c,holes:m}),a.push({positions:p,positions2D:v,holes:d})}}return{hierarchy:n,polygons:a}};var computeBoundingRectangleCartesian2=new Cartesian2,computeBoundingRectangleCartesian3=new Cartesian3,computeBoundingRectangleQuaternion=new Quaternion,computeBoundingRectangleMatrix3=new Matrix3;PolygonGeometryLibrary.computeBoundingRectangle=function(e,t,i,r,n){for(var r=Quaternion.fromAxisAngle(e,r,computeBoundingRectangleQuaternion),a=Matrix3.fromQuaternion(r,computeBoundingRectangleMatrix3),o=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,l=Number.POSITIVE_INFINITY,c=Number.NEGATIVE_INFINITY,u=i.length,d=0;d<u;++d){var h=Cartesian3.clone(i[d],computeBoundingRectangleCartesian3);Matrix3.multiplyByVector(a,h,h);h=t(h,computeBoundingRectangleCartesian2);defined(h)&&(o=Math.min(o,h.x),s=Math.max(s,h.x),l=Math.min(l,h.y),c=Math.max(c,h.y))}return n.x=o,n.y=l,n.width=s-o,n.height=c-l,n},PolygonGeometryLibrary.createGeometryFromPositions=function(e,t,i,r,n,a){var o=PolygonPipeline.triangulate(t.positions2D,t.holes);o.length<3&&(o=[0,1,2]);var s=t.positions;if(r){for(var l=s.length,c=new Array(3*l),u=0,d=0;d<l;d++){var h=s[d];c[u++]=h.x,c[u++]=h.y,c[u++]=h.z}r=new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})},indices:o,primitiveType:PrimitiveType$1.TRIANGLES});return n.normal?GeometryPipeline.computeNormal(r):r}return a===ArcType$1.GEODESIC?PolygonPipeline.computeSubdivision(e,s,o,i):a===ArcType$1.RHUMB?PolygonPipeline.computeRhumbLineSubdivision(e,s,o,i):void 0};var computeWallIndicesSubdivided=[],p1Scratch$1=new Cartesian3,p2Scratch$1=new Cartesian3;PolygonGeometryLibrary.computeWallGeometry=function(e,t,i,r,n){var a,o,s,l=e.length,c=0;if(r)for(o=3*l*2,a=new Array(2*o),s=0;s<l;s++)p=e[s],f=e[(s+1)%l],a[c]=a[c+o]=p.x,a[++c]=a[c+o]=p.y,a[++c]=a[c+o]=p.z,a[++c]=a[c+o]=f.x,a[++c]=a[c+o]=f.y,a[++c]=a[c+o]=f.z,++c;else{var u=CesiumMath.chordLength(i,t.maximumRadius),d=0;if(n===ArcType$1.GEODESIC)for(s=0;s<l;s++)d+=PolygonGeometryLibrary.subdivideLineCount(e[s],e[(s+1)%l],u);else if(n===ArcType$1.RHUMB)for(s=0;s<l;s++)d+=PolygonGeometryLibrary.subdivideRhumbLineCount(t,e[s],e[(s+1)%l],u);for(o=3*(d+l),a=new Array(2*o),s=0;s<l;s++){var h,p=e[s],f=e[(s+1)%l];n===ArcType$1.GEODESIC?h=PolygonGeometryLibrary.subdivideLine(p,f,u,computeWallIndicesSubdivided):n===ArcType$1.RHUMB&&(h=PolygonGeometryLibrary.subdivideRhumbLine(t,p,f,u,computeWallIndicesSubdivided));for(var m=h.length,g=0;g<m;++g,++c)a[c]=h[g],a[c+o]=h[g];a[c]=f.x,a[c+o]=f.x,a[++c]=f.y,a[c+o]=f.y,a[++c]=f.z,a[c+o]=f.z,++c}}var l=a.length,_=IndexDatatype$1.createTypedArray(l/3,l-6*e.length),y=0;for(l/=6,s=0;s<l;s++){var C=s,v=C+1,T=C+l,S=T+1;p=Cartesian3.fromArray(a,3*C,p1Scratch$1),f=Cartesian3.fromArray(a,3*v,p2Scratch$1),Cartesian3.equalsEpsilon(p,f,CesiumMath.EPSILON10,CesiumMath.EPSILON10)||(_[y++]=C,_[y++]=T,_[y++]=v,_[y++]=v,_[y++]=T,_[y++]=S)}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.TRIANGLES})};var scratchPosition$b=new Cartesian3,scratchBR=new BoundingRectangle,stScratch$1=new Cartesian2,textureCoordinatesOrigin=new Cartesian2,scratchNormal$4=new Cartesian3,scratchTangent$3=new Cartesian3,scratchBitangent$3=new Cartesian3,centerScratch$5=new Cartesian3,axis1Scratch=new Cartesian3,axis2Scratch=new Cartesian3,quaternionScratch$2=new Quaternion,textureMatrixScratch=new Matrix3,tangentRotationScratch=new Matrix3,surfaceNormalScratch=new Cartesian3;function createGeometryFromPolygon(e,t,i,r,n,a,o,s){var l=e.positions,c=PolygonPipeline.triangulate(e.positions2D,e.holes);c.length<3&&(c=[0,1,2]);e=IndexDatatype$1.createTypedArray(l.length,c.length);e.set(c);var u=textureMatrixScratch;0!==r?(c=Quaternion.fromAxisAngle(a,r,quaternionScratch$2),u=Matrix3.fromQuaternion(c,u),(t.tangent||t.bitangent)&&(c=Quaternion.fromAxisAngle(a,-r,quaternionScratch$2),p=Matrix3.fromQuaternion(c,tangentRotationScratch),o=Cartesian3.normalize(Matrix3.multiplyByVector(p,o,o),o),t.bitangent&&(s=Cartesian3.normalize(Cartesian3.cross(a,o,s),s)))):u=Matrix3.clone(Matrix3.IDENTITY,u);var d=textureCoordinatesOrigin;t.st&&(d.x=i.x,d.y=i.y);for(var h=l.length,p=3*h,f=new Float64Array(p),m=t.normal?new Float32Array(p):void 0,g=t.tangent?new Float32Array(p):void 0,_=t.bitangent?new Float32Array(p):void 0,y=t.st?new Float32Array(2*h):void 0,C=0,v=0,T=0,S=0,A=0,x=0;x<h;x++){var b,E=l[x];f[C++]=E.x,f[C++]=E.y,f[C++]=E.z,t.st&&(b=n(Matrix3.multiplyByVector(u,E,scratchPosition$b),stScratch$1),Cartesian2.subtract(b,d,b),E=CesiumMath.clamp(b.x/i.width,0,1),b=CesiumMath.clamp(b.y/i.height,0,1),y[A++]=E,y[A++]=b),t.normal&&(m[v++]=a.x,m[v++]=a.y,m[v++]=a.z),t.tangent&&(g[S++]=o.x,g[S++]=o.y,g[S++]=o.z),t.bitangent&&(_[T++]=s.x,_[T++]=s.y,_[T++]=s.z)}p=new GeometryAttributes;return t.position&&(p.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:f})),t.normal&&(p.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),t.tangent&&(p.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),t.bitangent&&(p.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.st&&(p.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:y})),new Geometry({attributes:p,indices:e,primitiveType:PrimitiveType$1.TRIANGLES})}function CoplanarPolygonGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=VertexFormat.clone(i),this._polygonHierarchy=t,this._stRotation=defaultValue(e.stRotation,0),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+VertexFormat.packedLength+Ellipsoid.packedLength+2}CoplanarPolygonGeometry.fromPositions=function(e){return new CoplanarPolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid})},CoplanarPolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._stRotation,t[i]=e.packedLength,t};var scratchEllipsoid$c=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$a=new VertexFormat,scratchOptions$h={polygonHierarchy:{}};function createGeometryFromPositions$1(e){for(var t=e.length,i=new Float64Array(3*t),r=IndexDatatype$1.createTypedArray(t,2*t),n=0,a=0,o=0;o<t;o++){var s=e[o];i[n++]=s.x,i[n++]=s.y,i[n++]=s.z,r[a++]=o,r[a++]=(o+1)%t}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i})}),indices:r,primitiveType:PrimitiveType$1.LINES})}function CoplanarPolygonOutlineGeometry(e){e=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy;this._polygonHierarchy=e,this._workerName="createCoplanarPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(e)+1}CoplanarPolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$c);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$a);t+=VertexFormat.packedLength;var o=e[t++],t=e[t];return(i=!defined(i)?new CoplanarPolygonGeometry(scratchOptions$h):i)._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._stRotation=o,i.packedLength=t,i},CoplanarPolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._polygonHierarchy,r=e._stRotation;if(!((h=arrayRemoveDuplicates(h=i.positions,Cartesian3.equalsEpsilon,!0)).length<3)){var n=scratchNormal$4,a=scratchTangent$3,o=scratchBitangent$3,s=axis1Scratch,l=axis2Scratch;if(CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(h,centerScratch$5,s,l)){n=Cartesian3.cross(s,l,n);n=Cartesian3.normalize(n,n),Cartesian3.equalsEpsilon(centerScratch$5,Cartesian3.ZERO,CesiumMath.EPSILON6)||(c=e._ellipsoid.geodeticSurfaceNormal(centerScratch$5,surfaceNormalScratch),Cartesian3.dot(n,c)<0&&(n=Cartesian3.negate(n,n),s=Cartesian3.negate(s,s)));var c=CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(centerScratch$5,s,l),u=CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(centerScratch$5,s,l);t.tangent&&(a=Cartesian3.clone(s,a)),t.bitangent&&(o=Cartesian3.clone(l,o));var i=PolygonGeometryLibrary.polygonsFromHierarchy(i,c,!1),c=i.hierarchy,d=i.polygons;if(0!==c.length){for(var h=c[0].outerRing,i=BoundingSphere.fromPoints(h),p=PolygonGeometryLibrary.computeBoundingRectangle(n,u,h,r,scratchBR),f=[],m=0;m<d.length;m++){var g=new GeometryInstance({geometry:createGeometryFromPolygon(d[m],t,p,r,u,n,a,o)});f.push(g)}c=GeometryPipeline.combineInstances(f)[0];c.attributes.position.values=new Float64Array(c.attributes.position.values),c.indices=IndexDatatype$1.createTypedArray(c.attributes.position.values.length/3,c.indices);h=c.attributes;return t.position||delete h.position,new Geometry({attributes:h,indices:c.indices,primitiveType:c.primitiveType,boundingSphere:i})}}}},CoplanarPolygonOutlineGeometry.fromPositions=function(e){return new CoplanarPolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions}})},CoplanarPolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i)]=e.packedLength,t};var scratchOptions$g={polygonHierarchy:{}};CoplanarPolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;t=e[t];return(i=!defined(i)?new CoplanarPolygonOutlineGeometry(scratchOptions$g):i)._polygonHierarchy=r,i.packedLength=t,i},CoplanarPolygonOutlineGeometry.createGeometry=function(e){var t=e._polygonHierarchy,e=arrayRemoveDuplicates(e=t.positions,Cartesian3.equalsEpsilon,!0);if(!(e.length<3)&&CoplanarPolygonGeometryLibrary.validOutline(e)){var i=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(t,!1);if(0!==i.length){for(var r=[],n=0;n<i.length;n++){var a=new GeometryInstance({geometry:createGeometryFromPositions$1(i[n])});r.push(a)}e=GeometryPipeline.combineInstances(r)[0],t=BoundingSphere.fromPoints(t.positions);return new Geometry({attributes:e.attributes,indices:e.indices,primitiveType:e.primitiveType,boundingSphere:t})}}};var CornerType={ROUNDED:0,MITERED:1,BEVELED:2},CornerType$1=Object.freeze(CornerType);function setConstants(e){var t=e._uSquared,i=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,n=(i-r)/i,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),c=l*s,u=Math.atan2(s,a),d=l*o,h=d*d,p=1-h,f=Math.sqrt(p),m=t/4,g=m*m,_=g*m,y=g*g,C=1+m-3*g/4+5*_/4-175*y/64,v=1-m+15*g/8-35*_/8,T=1-3*m+35*g/4,S=1-5*m,t=C*u-v*Math.sin(2*u)*m/2-T*Math.sin(4*u)*g/16-S*Math.sin(6*u)*_/48-5*Math.sin(8*u)*y/512,e=e._constants;e.a=i,e.b=r,e.f=n,e.cosineHeading=a,e.sineHeading=o,e.tanU=s,e.cosineU=l,e.sineU=c,e.sigma=u,e.sineAlpha=d,e.sineSquaredAlpha=h,e.cosineSquaredAlpha=p,e.cosineAlpha=f,e.u2Over4=m,e.u4Over16=g,e.u6Over64=_,e.u8Over256=y,e.a0=C,e.a1=v,e.a2=T,e.a3=S,e.distanceRatio=t}function computeC(e,t){return e*t*(4+e*(4-3*t))/16}function computeDeltaLambda(e,t,i,r,n,a,o){i=computeC(e,i);return(1-i)*e*t*(r+i*n*(o+i*a*(2*o*o-1)))}function vincentyInverseFormula(e,t,i,r,n,a,o){var s=(t-i)/t,l=a-r,r=Math.atan((1-s)*Math.tan(n)),n=Math.atan((1-s)*Math.tan(o)),o=Math.cos(r),r=Math.sin(r),c=Math.cos(n),n=Math.sin(n),u=o*c,d=o*n,h=r*n,p=r*c,f=l,m=(CesiumMath.TWO_PI,Math.cos(f)),g=Math.sin(f);do{var _,y,C,v,T,m=Math.cos(f),g=Math.sin(f),S=d-p*m,A=f,x=(C=h+u*m)-2*h/(T=0===(y=Math.sqrt(c*c*g*g+S*S))?(_=0,1):1-(_=u*g/y)*_),f=l+computeDeltaLambda(s,_,T,v=Math.atan2(y,C),y,C,x=!isFinite(x)?0:x)}while(Math.abs(f-A)>CesiumMath.EPSILON12);n=T*(t*t-i*i)/(i*i),r=n*(256+n*(n*(74-47*n)-128))/1024,t=x*x,r=i*(1+n*(4096+n*(n*(320-175*n)-768))/16384)*(v-r*y*(x+r*(C*(2*t-1)-r*x*(4*y*y-3)*(4*t-3)/6)/4)),t=Math.atan2(c*g,d-p*m),o=Math.atan2(o*g,d*m-p);e._distance=r,e._startHeading=t,e._endHeading=o,e._uSquared=n}var scratchCart1=new Cartesian3,scratchCart2$1=new Cartesian3;function computeProperties(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$1),scratchCart1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$1),scratchCart2$1),vincentyInverseFormula(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude),e._start=Cartographic.clone(t,e._start),e._end=Cartographic.clone(i,e._end),e._start.height=0,e._end.height=0,setConstants(e)}function EllipsoidGeodesic(e,t,i){i=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,defined(e)&&defined(t)&&computeProperties(this,e,t,i)}Object.defineProperties(EllipsoidGeodesic.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),EllipsoidGeodesic.prototype.setEndPoints=function(e,t){computeProperties(this,e,t,this._ellipsoid)},EllipsoidGeodesic.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},EllipsoidGeodesic.prototype.interpolateUsingSurfaceDistance=function(e,t){var i=this._constants,r=i.distanceRatio+e/i.b,n=Math.cos(2*r),a=Math.cos(4*r),o=Math.cos(6*r),s=Math.sin(2*r),l=Math.sin(4*r),c=Math.sin(6*r),u=Math.sin(8*r),d=r*r,h=i.u8Over256,p=i.u2Over4,f=i.u6Over64,e=i.u4Over16,d=2*(r*d)*h*n/3+r*(1-p+7*e/4-15*f/4+579*h/64-(e-15*f/4+187*h/16)*n-(5*f/4-115*h/16)*a-29*h*o/16)+(p/2-e+71*f/32-85*h/16)*s+(5*e/16-5*f/4+383*h/96)*l-d*((f-11*h/2)*s+5*h*l/2)+(29*f/96-29*h/16)*c+539*h*u/1536,s=Math.asin(Math.sin(d)*i.cosineAlpha),l=Math.atan(i.a/i.b*Math.tan(s));d-=i.sigma;f=Math.cos(2*i.sigma+d),c=Math.sin(d),h=Math.cos(d),u=i.cosineU*h,s=i.sineU*c,f=Math.atan2(c*i.sineHeading,u-s*i.cosineHeading)-computeDeltaLambda(i.f,i.sineAlpha,i.cosineSquaredAlpha,d,c,h,f);return defined(t)?(t.longitude=this._start.longitude+f,t.latitude=l,t.height=0,t):new Cartographic(this._start.longitude+f,l,0)};var PolylinePipeline={numberOfPoints:function(e,t,i){t=Cartesian3.distance(e,t);return Math.ceil(t/i)},numberOfPointsRhumbLine:function(e,t,i){t=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.max(1,Math.ceil(Math.sqrt(t/(i*i))))}},cartoScratch$2=new Cartographic;PolylinePipeline.extractHeights=function(e,t){for(var i=e.length,r=new Array(i),n=0;n<i;n++){var a=e[n];r[n]=t.cartesianToCartographic(a,cartoScratch$2).height}return r};var wrapLongitudeInversMatrix=new Matrix4,wrapLongitudeOrigin=new Cartesian3,wrapLongitudeXZNormal=new Cartesian3,wrapLongitudeXZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeYZNormal=new Cartesian3,wrapLongitudeYZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeIntersection=new Cartesian3,wrapLongitudeOffset=new Cartesian3,subdivideHeightsScratchArray=[];function subdivideHeights$1(e,t,i){var r=subdivideHeightsScratchArray;if(r.length=e,t===i){for(a=0;a<e;a++)r[a]=t;return r}for(var n=(i-t)/e,a=0;a<e;a++)r[a]=t+a*n;return r}var carto1=new Cartographic,carto2=new Cartographic,cartesian=new Cartesian3,scaleFirst=new Cartesian3,scaleLast=new Cartesian3,ellipsoidGeodesic$1=new EllipsoidGeodesic,ellipsoidRhumb=new EllipsoidRhumbLine;function generateCartesianArc(e,t,i,r,n,a,o,s){var l=r.scaleToGeodeticSurface(e,scaleFirst),c=r.scaleToGeodeticSurface(t,scaleLast),u=PolylinePipeline.numberOfPoints(e,t,i),l=r.cartesianToCartographic(l,carto1),c=r.cartesianToCartographic(c,carto2),d=subdivideHeights$1(u,n,a);ellipsoidGeodesic$1.setEndPoints(l,c);var h=ellipsoidGeodesic$1.surfaceDistance/u,p=s;l.height=n;var f=r.cartographicToCartesian(l,cartesian);Cartesian3.pack(f,o,p),p+=3;for(var m=1;m<u;m++){var g=ellipsoidGeodesic$1.interpolateUsingSurfaceDistance(m*h,carto2);g.height=d[m],f=r.cartographicToCartesian(g,cartesian),Cartesian3.pack(f,o,p),p+=3}return p}function generateCartesianRhumbArc(e,t,i,r,n,a,o,s){var e=r.cartesianToCartographic(e,carto1),t=r.cartesianToCartographic(t,carto2),l=PolylinePipeline.numberOfPointsRhumbLine(e,t,i);e.height=0,t.height=0;var c=subdivideHeights$1(l,n,a);(ellipsoidRhumb=!ellipsoidRhumb.ellipsoid.equals(r)?new EllipsoidRhumbLine(void 0,void 0,r):ellipsoidRhumb).setEndPoints(e,t);var u=ellipsoidRhumb.surfaceDistance/l,d=s;e.height=n;var h=r.cartographicToCartesian(e,cartesian);Cartesian3.pack(h,o,d),d+=3;for(var p=1;p<l;p++){var f=ellipsoidRhumb.interpolateUsingSurfaceDistance(p*u,carto2);f.height=c[p],h=r.cartographicToCartesian(f,cartesian),Cartesian3.pack(h,o,d),d+=3}return d}PolylinePipeline.wrapLongitude=function(e,t){var i=[],r=[];if(defined(e)&&0<e.length){t=defaultValue(t,Matrix4.IDENTITY);var n=Matrix4.inverseTransformation(t,wrapLongitudeInversMatrix),t=Matrix4.multiplyByPoint(n,Cartesian3.ZERO,wrapLongitudeOrigin),a=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_Y,wrapLongitudeXZNormal),wrapLongitudeXZNormal),o=Plane.fromPointNormal(t,a,wrapLongitudeXZPlane),n=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_X,wrapLongitudeYZNormal),wrapLongitudeYZNormal),s=Plane.fromPointNormal(t,n,wrapLongitudeYZPlane),l=1;i.push(Cartesian3.clone(e[0]));for(var c=i[0],u=e.length,d=1;d<u;++d){var h,p,f=e[d];!(Plane.getPointDistance(s,c)<0||Plane.getPointDistance(s,f)<0)||defined(h=IntersectionTests.lineSegmentPlane(c,f,o,wrapLongitudeIntersection))&&(p=Cartesian3.multiplyByScalar(a,5e-9,wrapLongitudeOffset),Plane.getPointDistance(o,c)<0&&Cartesian3.negate(p,p),i.push(Cartesian3.add(h,p,new Cartesian3)),r.push(l+1),Cartesian3.negate(p,p),i.push(Cartesian3.add(h,p,new Cartesian3)),l=1),i.push(Cartesian3.clone(e[d])),l++,c=f}r.push(l)}return{positions:i,lengths:r}},PolylinePipeline.generateArc=function(e){var t=(e=!defined(e)?{}:e).positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o,s=r.scaleToGeodeticSurface(t[0],scaleFirst);return 0!==(n=a?n[0]:n)&&(o=r.geodeticSurfaceNormal(s,cartesian),Cartesian3.multiplyByScalar(o,n,o),Cartesian3.add(s,o,s)),[s.x,s.y,s.z]}var l=e.minDistance;defined(l)||(p=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),l=CesiumMath.chordLength(p,r.maximumRadius));for(var c=0,u=0;u<i-1;u++)c+=PolylinePipeline.numberOfPoints(t[u],t[u+1],l);var e=3*(c+1),d=new Array(e),h=0;for(u=0;u<i-1;u++)h=generateCartesianArc(t[u],t[u+1],l,r,a?n[u]:n,a?n[u+1]:n,d,h);subdivideHeightsScratchArray.length=0;var p=t[i-1],p=r.cartesianToCartographic(p,carto1);p.height=a?n[i-1]:n;p=r.cartographicToCartesian(p,cartesian);return Cartesian3.pack(p,d,e-3),d};var scratchCartographic0=new Cartographic,scratchCartographic1$1=new Cartographic;PolylinePipeline.generateRhumbArc=function(e){var t=(e=!defined(e)?{}:e).positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o,s=r.scaleToGeodeticSurface(t[0],scaleFirst);return 0!==(n=a?n[0]:n)&&(o=r.geodeticSurfaceNormal(s,cartesian),Cartesian3.multiplyByScalar(o,n,o),Cartesian3.add(s,o,s)),[s.x,s.y,s.z]}for(var l,c=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),u=0,d=r.cartesianToCartographic(t[0],scratchCartographic0),h=0;h<i-1;h++)l=r.cartesianToCartographic(t[h+1],scratchCartographic1$1),u+=PolylinePipeline.numberOfPointsRhumbLine(d,l,c),d=Cartographic.clone(l,scratchCartographic0);var s=3*(u+1),p=new Array(s),f=0;for(h=0;h<i-1;h++)f=generateCartesianRhumbArc(t[h],t[h+1],c,r,a?n[h]:n,a?n[h+1]:n,p,f);subdivideHeightsScratchArray.length=0;e=t[i-1],e=r.cartesianToCartographic(e,carto1);e.height=a?n[i-1]:n;e=r.cartographicToCartesian(e,cartesian);return Cartesian3.pack(e,p,s-3),p},PolylinePipeline.generateCartesianArc=function(e){for(var t=PolylinePipeline.generateArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r},PolylinePipeline.generateCartesianRhumbArc=function(e){for(var t=PolylinePipeline.generateRhumbArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r};var warnings={};function oneTimeWarning(e,t){defined(warnings[e])||(warnings[e]=!0,console.warn(defaultValue(t,e)))}oneTimeWarning.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",oneTimeWarning.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",oneTimeWarning.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",oneTimeWarning.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";var scratch2Array=[new Cartesian3,new Cartesian3],scratchCartesian1$3=new Cartesian3,scratchCartesian2$6=new Cartesian3,scratchCartesian3$7=new Cartesian3,scratchCartesian4$4=new Cartesian3,scratchCartesian5$1=new Cartesian3,scratchCartesian6=new Cartesian3,scratchCartesian7=new Cartesian3,scratchCartesian8=new Cartesian3,scratchCartesian9=new Cartesian3,scratch1$2=new Cartesian3,scratch2$2=new Cartesian3,PolylineVolumeGeometryLibrary={},cartographic=new Cartographic;function scaleToSurface$2(e,t){for(var i=new Array(e.length),r=0;r<e.length;r++){var n=e[r];cartographic=t.cartesianToCartographic(n,cartographic),i[r]=cartographic.height,e[r]=t.scaleToGeodeticSurface(n,n)}return i}function subdivideHeights(e,t,i,r){var n=e[0],e=e[1],e=Cartesian3.angleBetween(n,e),a=Math.ceil(e/r),o=new Array(a);if(t===i){for(l=0;l<a;l++)o[l]=t;return o.push(i),o}for(var s=(i-t)/a,l=1;l<a;l++)o[l]=t+l*s;return o[0]=t,o.push(i),o}var nextScratch=new Cartesian3,prevScratch=new Cartesian3;function computeRotationAngle(e,t,i,r){r=new EllipsoidTangentPlane(i,r),e=r.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),i=r.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch),t=Cartesian2.angleBetween(e,i);return 0<=i.x*e.y-i.y*e.x?-t:t}var negativeX=new Cartesian3(-1,0,0),transform$2=new Matrix4,translation$1=new Matrix4,rotationZ=new Matrix3,scaleMatrix=Matrix3.IDENTITY.clone(),westScratch=new Cartesian3,finalPosScratch=new Cartesian4,heightCartesian=new Cartesian3;function addPosition(e,t,i,r,n,a,o,s){var l=westScratch,c=finalPosScratch;transform$2=Transforms.eastNorthUpToFixedFrame(e,n,transform$2),l=Matrix4.multiplyByPointAsVector(transform$2,negativeX,l);n=computeRotationAngle(l=Cartesian3.normalize(l,l),t,e,n);rotationZ=Matrix3.fromRotationZ(n,rotationZ),heightCartesian.z=a,transform$2=Matrix4.multiplyTransformation(transform$2,Matrix4.fromRotationTranslation(rotationZ,heightCartesian,translation$1),transform$2);var u=scaleMatrix;u[0]=o;for(var d=0;d<s;d++)for(var h=0;h<i.length;h+=3)c=Cartesian3.fromArray(i,h,c),c=Matrix3.multiplyByVector(u,c,c),c=Matrix4.multiplyByPoint(transform$2,c,c),r.push(c.x,c.y,c.z);return r}var centerScratch$4=new Cartesian3;function addPositions(e,t,i,r,n,a,o){for(var s=0;s<e.length;s+=3)r=addPosition(Cartesian3.fromArray(e,s,centerScratch$4),t,i,r,n,a[s/3],o,1);return r}function convertShapeTo3DDuplicate(e,t){var i=e.length,r=new Array(6*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=e[0];r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o;for(var l=1;l<i;l++){var c=(s=e[l]).x-a,u=s.y-o;r[n++]=c,r[n++]=0,r[n++]=u,r[n++]=c,r[n++]=0,r[n++]=u}return s=e[0],r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o,r}function convertShapeTo3D(e,t){for(var i=e.length,r=new Array(3*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=0;s<i;s++)r[n++]=e[s].x-a,r[n++]=0,r[n++]=e[s].y-o;return r}var quaterion$1=new Quaternion,startPointScratch=new Cartesian3,rotMatrix$1=new Matrix3;function computeRoundCorner$1(e,t,i,r,n,a,o,s,l,c){var u,d=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$2),Cartesian3.subtract(i,e,scratch2$2)),h=r===CornerType$1.BEVELED?0:Math.ceil(d/CesiumMath.toRadians(5)),p=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$2),d/(h+1),quaterion$1),rotMatrix$1):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,d/(h+1),quaterion$1),rotMatrix$1);if(t=Cartesian3.clone(t,startPointScratch),0<h)for(var f=c?2:1,m=0;m<h;m++)t=Matrix3.multiplyByVector(p,t,t),u=Cartesian3.subtract(t,e,scratch1$2),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2$2),u,s,o,a,l,1,f);else u=Cartesian3.subtract(t,e,scratch1$2),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2$2),u,s,o,a,l,1,1),i=Cartesian3.clone(i,startPointScratch),u=Cartesian3.subtract(i,e,scratch1$2),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(i,scratch2$2),u,s,o,a,l,1,1);return o}PolylineVolumeGeometryLibrary.removeDuplicatesFromShape=function(e){for(var t=e.length,i=[],r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];Cartesian2.equals(a,o)||i.push(o)}return i},PolylineVolumeGeometryLibrary.angleIsGreaterThanPi=function(e,t,i,r){r=new EllipsoidTangentPlane(i,r),e=r.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),t=r.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch);return 0<=t.x*e.y-t.y*e.x};var scratchForwardProjection$1=new Cartesian3,scratchBackwardProjection$1=new Cartesian3;PolylineVolumeGeometryLibrary.computePositions=function(e,t,i,r,n){var a=r._ellipsoid,o=scaleToSurface$2(e,a),s=r._granularity,l=r._cornerType,c=(n?convertShapeTo3DDuplicate:convertShapeTo3D)(t,i),t=n?convertShapeTo3D(t,i):void 0,u=i.height/2,d=i.width/2,h=e.length,p=[],i=n?[]:void 0,f=scratchCartesian1$3,m=scratchCartesian2$6,g=scratchCartesian3$7,_=scratchCartesian4$4,y=scratchCartesian5$1,C=scratchCartesian6,v=scratchCartesian7,T=scratchCartesian8,S=scratchCartesian9,A=e[0],x=e[1];_=a.geodeticSurfaceNormal(A,_),f=Cartesian3.subtract(x,A,f),f=Cartesian3.normalize(f,f),T=Cartesian3.cross(_,f,T);var b,T=Cartesian3.normalize(T,T),E=o[0],P=o[1];n&&(i=addPosition(A,T,t,i,a,E+u,1,1)),S=Cartesian3.clone(A,S),A=x,m=Cartesian3.negate(f,m);for(var D=1;D<h-1;D++){var w,M,I=n?2:1,x=e[D+1];A.equals(x)?oneTimeWarning("Positions are too close and are considered equivalent with rounding error."):(f=Cartesian3.subtract(x,A,f),f=Cartesian3.normalize(f,f),g=Cartesian3.add(f,m,g),g=Cartesian3.normalize(g,g),_=a.geodeticSurfaceNormal(A,_),w=Cartesian3.multiplyByScalar(_,Cartesian3.dot(f,_),scratchForwardProjection$1),Cartesian3.subtract(f,w,w),Cartesian3.normalize(w,w),M=Cartesian3.multiplyByScalar(_,Cartesian3.dot(m,_),scratchBackwardProjection$1),Cartesian3.subtract(m,M,M),Cartesian3.normalize(M,M),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(w,M)),1,CesiumMath.EPSILON7)?(g=Cartesian3.cross(g,_,g),g=Cartesian3.cross(_,g,g),g=Cartesian3.normalize(g,g),w=1/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(g,m,scratch1$2))),(M=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(f,m,A,a))?(y=Cartesian3.add(A,Cartesian3.multiplyByScalar(g,w*d,g),y),C=Cartesian3.add(y,Cartesian3.multiplyByScalar(T,d,C),C),scratch2Array[0]=Cartesian3.clone(S,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(C,scratch2Array[1]),b=subdivideHeights(scratch2Array,E+u,P+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),T,c,p,a,b,1),T=Cartesian3.cross(_,f,T),T=Cartesian3.normalize(T,T),v=Cartesian3.add(y,Cartesian3.multiplyByScalar(T,d,v),v),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner$1(y,C,v,l,M,a,p,c,P+u,n):p=addPosition(A,g=Cartesian3.negate(g,g),c,p,a,P+u,w,I)):(y=Cartesian3.add(A,Cartesian3.multiplyByScalar(g,w*d,g),y),C=Cartesian3.add(y,Cartesian3.multiplyByScalar(T,-d,C),C),scratch2Array[0]=Cartesian3.clone(S,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(C,scratch2Array[1]),b=subdivideHeights(scratch2Array,E+u,P+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),T,c,p,a,b,1),T=Cartesian3.cross(_,f,T),T=Cartesian3.normalize(T,T),v=Cartesian3.add(y,Cartesian3.multiplyByScalar(T,-d,v),v),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner$1(y,C,v,l,M,a,p,c,P+u,n):p=addPosition(A,g,c,p,a,P+u,w,I)),S=Cartesian3.clone(v,S),m=Cartesian3.negate(f,m)):(p=addPosition(S,T,c,p,a,E+u,1,1),S=A),E=P,P=o[D+1],A=x)}scratch2Array[0]=Cartesian3.clone(S,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(A,scratch2Array[1]),b=subdivideHeights(scratch2Array,E+u,P+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),T,c,p,a,b,1),n&&(i=addPosition(A,T,t,i,a,P+u,1,1));h=p.length,t=n?h+i.length:h,t=new Float64Array(t);return t.set(p),n&&t.set(i,h),t};var CorridorGeometryLibrary={},scratch1$1=new Cartesian3,scratch2$1=new Cartesian3,scratch3=new Cartesian3,scratch4=new Cartesian3,scaleArray2=[new Cartesian3,new Cartesian3],cartesian1$2=new Cartesian3,cartesian2$2=new Cartesian3,cartesian3$2=new Cartesian3,cartesian4$1=new Cartesian3,cartesian5$1=new Cartesian3,cartesian6$1=new Cartesian3,cartesian7=new Cartesian3,cartesian8=new Cartesian3,cartesian9=new Cartesian3,cartesian10=new Cartesian3,quaterion=new Quaternion,rotMatrix=new Matrix3;function computeRoundCorner(e,t,i,r,n){var a=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$1),Cartesian3.subtract(i,e,scratch2$1)),o=r===CornerType$1.BEVELED?1:Math.ceil(a/CesiumMath.toRadians(5))+1,r=3*o,s=new Array(r);s[r-3]=i.x,s[r-2]=i.y,s[r-1]=i.z;var l=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$1),a/o,quaterion),rotMatrix):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,a/o,quaterion),rotMatrix),c=0;t=Cartesian3.clone(t,scratch1$1);for(var u=0;u<o;u++)t=Matrix3.multiplyByVector(l,t,t),s[c++]=t.x,s[c++]=t.y,s[c++]=t.z;return s}function addEndCaps(e){var t=cartesian1$2,i=cartesian3$2,r=e[1],n=Cartesian3.fromArray(e[1],r.length-3,cartesian2$2),i=Cartesian3.fromArray(e[0],0,i),a=computeRoundCorner(t=Cartesian3.midpoint(n,i,t),n,i,CornerType$1.ROUNDED,!1),o=e.length-1,s=e[o-1],r=e[o];return n=Cartesian3.fromArray(s,s.length-3,n),i=Cartesian3.fromArray(r,0,i),[a,computeRoundCorner(t=Cartesian3.midpoint(n,i,t),n,i,CornerType$1.ROUNDED,!1)]}function computeMiteredCorner(e,t,i,r){var n=scratch1$1;return[(n=(r||(t=Cartesian3.negate(t,t)),Cartesian3.add(e,t,n))).x,n.y,n.z,i.x,i.y,i.z]}function addShiftedPositions(e,t,i,r){for(var n=new Array(e.length),a=new Array(e.length),o=Cartesian3.multiplyByScalar(t,i,scratch1$1),s=Cartesian3.negate(o,scratch2$1),l=0,c=e.length-1,u=0;u<e.length;u+=3){var d=Cartesian3.fromArray(e,u,scratch3),h=Cartesian3.add(d,s,scratch4);n[l++]=h.x,n[l++]=h.y,n[l++]=h.z;d=Cartesian3.add(d,o,scratch4);a[c--]=d.z,a[c--]=d.y,a[c--]=d.x}return r.push(n,a),r}CorridorGeometryLibrary.addAttribute=function(e,t,i,r){var n=t.x,a=t.y,t=t.z;defined(i)&&(e[i]=n,e[i+1]=a,e[i+2]=t),defined(r)&&(e[r]=t,e[r-1]=a,e[r-2]=n)};var scratchForwardProjection=new Cartesian3,scratchBackwardProjection=new Cartesian3;CorridorGeometryLibrary.computePositions=function(e){var t=e.granularity,i=e.positions,r=e.ellipsoid,n=e.width/2,a=e.cornerType,o=e.saveAttributes,s=cartesian1$2,l=cartesian2$2,c=cartesian3$2,u=cartesian4$1,d=cartesian5$1,h=cartesian6$1,p=cartesian7,f=cartesian8,m=cartesian9,g=cartesian10,_=[],y=o?[]:void 0,C=o?[]:void 0,v=i[0],T=i[1],l=Cartesian3.normalize(Cartesian3.subtract(T,v,l),l),s=r.geodeticSurfaceNormal(v,s),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u);o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z));for(var S,p=Cartesian3.clone(v,p),v=T,c=Cartesian3.negate(l,c),A=[],x=i.length,b=1;b<x-1;b++){s=r.geodeticSurfaceNormal(v,s),T=i[b+1],l=Cartesian3.normalize(Cartesian3.subtract(T,v,l),l),d=Cartesian3.normalize(Cartesian3.add(l,c,d),d);var E=Cartesian3.multiplyByScalar(s,Cartesian3.dot(l,s),scratchForwardProjection);Cartesian3.subtract(l,E,E),Cartesian3.normalize(E,E);var P=Cartesian3.multiplyByScalar(s,Cartesian3.dot(c,s),scratchBackwardProjection);Cartesian3.subtract(c,P,P),Cartesian3.normalize(P,P),CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(E,P)),1,CesiumMath.EPSILON7)||(d=Cartesian3.cross(d,s,d),d=Cartesian3.cross(s,d,d),d=Cartesian3.normalize(d,d),E=n/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(d,c,scratch1$1))),P=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(l,c,v,r),d=Cartesian3.multiplyByScalar(d,E,d),P?(f=Cartesian3.add(v,d,f),g=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,n,g),g),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*n,m),m),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(m,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*n,m),m),p=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,n,p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?A.push({leftPositions:computeRoundCorner(f,h,m,a,P)}):A.push({leftPositions:computeMiteredCorner(v,Cartesian3.negate(d,d),m,P)})):(m=Cartesian3.add(v,d,m),g=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,g),g),g),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,f),f),f),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(f,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,f),f),f),p=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,p),p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?A.push({rightPositions:computeRoundCorner(m,h,f,a,P)}):A.push({rightPositions:computeMiteredCorner(v,d,f,P)})),c=Cartesian3.negate(l,c)),v=T}return s=r.geodeticSurfaceNormal(v,s),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(v,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),{positions:_,corners:A,lefts:y,normals:C,endPositions:S=a===CornerType$1.ROUNDED?addEndCaps(_):S}};var cartesian1$1=new Cartesian3,cartesian2$1=new Cartesian3,cartesian3$1=new Cartesian3,cartesian4=new Cartesian3,cartesian5=new Cartesian3,cartesian6=new Cartesian3,scratch1=new Cartesian3,scratch2=new Cartesian3;function scaleToSurface$1(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function addNormals(e,t,i,r,n,a){var o=e.normals,s=e.tangents,l=e.bitangents,e=Cartesian3.normalize(Cartesian3.cross(i,t,scratch1),scratch1);a.normal&&CorridorGeometryLibrary.addAttribute(o,t,r,n),a.tangent&&CorridorGeometryLibrary.addAttribute(s,e,r,n),a.bitangent&&CorridorGeometryLibrary.addAttribute(l,i,r,n)}function combine$1(e,t,i){var r,n=e.positions,a=e.corners,o=e.endPositions,s=e.lefts,l=e.normals,c=new GeometryAttributes,u=0,d=0,h=0;for(O=0;O<n.length;O+=2)u+=r=n[O].length-3,h+=2*r,d+=n[O+1].length-3;for(u+=3,d+=3,O=0;O<a.length;O++){var p=a[O],f=a[O].leftPositions;defined(f)?u+=r=f.length:d+=r=a[O].rightPositions.length,h+=r}var m,g=defined(o);g&&(u+=m=o[0].length-3,d+=m,h+=6*(m/=3));var _,y,C,v,e=u+d,T=new Float64Array(e),S={normals:t.normal?new Float32Array(e):void 0,tangents:t.tangent?new Float32Array(e):void 0,bitangents:t.bitangent?new Float32Array(e):void 0},A=0,x=e-1,b=cartesian1$1,E=cartesian2$1,P=m/2,D=IndexDatatype$1.createTypedArray(e/3,h),w=0;if(g)for(var M=cartesian3$1,I=cartesian4,R=o[0],b=Cartesian3.fromArray(l,0,b),E=Cartesian3.fromArray(s,0,E),O=0;O<P;O++)M=Cartesian3.fromArray(R,3*(P-1-O),M),I=Cartesian3.fromArray(R,3*(P+O),I),CorridorGeometryLibrary.addAttribute(T,I,A),CorridorGeometryLibrary.addAttribute(T,M,void 0,x),addNormals(S,b,E,A,x,t),v=(y=A/3)+1,C=(_=(x-2)/3)-1,D[w++]=_,D[w++]=y,D[w++]=C,D[w++]=C,D[w++]=y,D[w++]=v,A+=3,x-=3;var B,L,F=0,N=0,V=n[F++],k=n[F++];for(T.set(V,A),T.set(k,x-k.length+1),E=Cartesian3.fromArray(s,N,E),r=k.length-3,O=0;O<r;O+=3)B=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,O,scratch1),scratch1),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,r-O,scratch2),scratch2),addNormals(S,b=Cartesian3.normalize(Cartesian3.add(B,L,b),b),E,A,x,t),v=(y=A/3)+1,C=(_=(x-2)/3)-1,D[w++]=_,D[w++]=y,D[w++]=C,D[w++]=C,D[w++]=y,D[w++]=v,A+=3,x-=3;for(B=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,r,scratch1),scratch1),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,r,scratch2),scratch2),b=Cartesian3.normalize(Cartesian3.add(B,L,b),b),N+=3,O=0;O<a.length;O++){var G,U,$,z=(p=a[O]).leftPositions,H=p.rightPositions,W=cartesian6,q=cartesian3$1,j=cartesian4;if(b=Cartesian3.fromArray(l,N,b),defined(z)){for(addNormals(S,b,E,void 0,x,t),x-=3,U=v,$=C,G=0;G<z.length/3;G++)W=Cartesian3.fromArray(z,3*G,W),D[w++]=U,D[w++]=$-G-1,D[w++]=$-G,CorridorGeometryLibrary.addAttribute(T,W,void 0,x),q=Cartesian3.fromArray(T,3*($-G-1),q),j=Cartesian3.fromArray(T,3*U,j),addNormals(S,b,E=Cartesian3.normalize(Cartesian3.subtract(q,j,E),E),void 0,x,t),x-=3;W=Cartesian3.fromArray(T,3*U,W),q=Cartesian3.subtract(Cartesian3.fromArray(T,3*$,q),W,q),j=Cartesian3.subtract(Cartesian3.fromArray(T,3*($-G),j),W,j),addNormals(S,b,E=Cartesian3.normalize(Cartesian3.add(q,j,E),E),A,void 0,t),A+=3}else{for(addNormals(S,b,E,A,void 0,t),A+=3,U=C,$=v,G=0;G<H.length/3;G++)W=Cartesian3.fromArray(H,3*G,W),D[w++]=U,D[w++]=$+G,D[w++]=$+G+1,CorridorGeometryLibrary.addAttribute(T,W,A),q=Cartesian3.fromArray(T,3*U,q),j=Cartesian3.fromArray(T,3*($+G),j),addNormals(S,b,E=Cartesian3.normalize(Cartesian3.subtract(q,j,E),E),A,void 0,t),A+=3;W=Cartesian3.fromArray(T,3*U,W),q=Cartesian3.subtract(Cartesian3.fromArray(T,3*($+G),q),W,q),j=Cartesian3.subtract(Cartesian3.fromArray(T,3*$,j),W,j),addNormals(S,b,E=Cartesian3.normalize(Cartesian3.negate(Cartesian3.add(j,q,E),E),E),void 0,x,t),x-=3}for(V=n[F++],k=n[F++],V.splice(0,3),k.splice(k.length-3,3),T.set(V,A),T.set(k,x-k.length+1),r=k.length-3,N+=3,E=Cartesian3.fromArray(s,N,E),G=0;G<k.length;G+=3)B=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,G,scratch1),scratch1),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,r-G,scratch2),scratch2),addNormals(S,b=Cartesian3.normalize(Cartesian3.add(B,L,b),b),E,A,x,t),y=(v=A/3)-1,D[w++]=_=(C=(x-2)/3)+1,D[w++]=y,D[w++]=C,D[w++]=C,D[w++]=y,D[w++]=v,A+=3,x-=3;A-=3,x+=3}if(addNormals(S,b=Cartesian3.fromArray(l,l.length-3,b),E,A,x,t),g){A+=3,x-=3,M=cartesian3$1,I=cartesian4;var X=o[1];for(O=0;O<P;O++)M=Cartesian3.fromArray(X,3*(m-O-1),M),I=Cartesian3.fromArray(X,3*O,I),CorridorGeometryLibrary.addAttribute(T,M,void 0,x),CorridorGeometryLibrary.addAttribute(T,I,A),addNormals(S,b,E,A,x,t),y=(v=A/3)-1,D[w++]=_=(C=(x-2)/3)+1,D[w++]=y,D[w++]=C,D[w++]=C,D[w++]=y,D[w++]=v,A+=3,x-=3}if(c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:T}),t.st){var K=new Float32Array(e/3*2),Y=0;if(g){u/=3,d/=3;var J,Q=Math.PI/(m+1),Z=1/(u-m+1),ee=1/(d-m+1),te=m/2;for(O=1+te;O<m+1;O++)J=CesiumMath.PI_OVER_TWO+Q*O,K[Y++]=ee*(1+Math.cos(J)),K[Y++]=.5*(1+Math.sin(J));for(O=1;O<d-m+1;O++)K[Y++]=O*ee,K[Y++]=0;for(O=m;te<O;O--)J=CesiumMath.PI_OVER_TWO-O*Q,K[Y++]=1-ee*(1+Math.cos(J)),K[Y++]=.5*(1+Math.sin(J));for(O=te;0<O;O--)J=CesiumMath.PI_OVER_TWO-Q*O,K[Y++]=1-Z*(1+Math.cos(J)),K[Y++]=.5*(1+Math.sin(J));for(O=u-m;0<O;O--)K[Y++]=O*Z,K[Y++]=1;for(O=1;O<1+te;O++)J=CesiumMath.PI_OVER_TWO+Q*O,K[Y++]=Z*(1+Math.cos(J)),K[Y++]=.5*(1+Math.sin(J))}else{for(Z=1/((u/=3)-1),ee=1/((d/=3)-1),O=0;O<d;O++)K[Y++]=O*ee,K[Y++]=0;for(O=u;0<O;O--)K[Y++]=(O-1)*Z,K[Y++]=1}c.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:K})}return t.normal&&(c.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:S.normals})),t.tangent&&(c.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:S.tangents})),t.bitangent&&(c.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:S.bitangents})),{attributes:c,indices:D}}function extrudedAttributes(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;var i,r=e.position.values;(t.normal||t.bitangent)&&(i=e.normal.values,l=e.bitangent.values);var n=e.position.values.length/18,a=3*n,o=2*n,s=2*a;if(t.normal||t.bitangent||t.tangent){for(var l,c=t.normal?new Float32Array(6*a):void 0,u=t.tangent?new Float32Array(6*a):void 0,d=t.bitangent?new Float32Array(6*a):void 0,h=cartesian1$1,p=cartesian2$1,f=cartesian3$1,m=cartesian4,g=cartesian5,_=cartesian6,y=s,C=0;C<a;C+=3){var v=y+s,h=Cartesian3.fromArray(r,C,h),p=Cartesian3.fromArray(r,C+a,p),f=Cartesian3.fromArray(r,(C+3)%a,f);p=Cartesian3.subtract(p,h,p),f=Cartesian3.subtract(f,h,f),m=Cartesian3.normalize(Cartesian3.cross(p,f,m),m),t.normal&&(CorridorGeometryLibrary.addAttribute(c,m,v),CorridorGeometryLibrary.addAttribute(c,m,v+3),CorridorGeometryLibrary.addAttribute(c,m,y),CorridorGeometryLibrary.addAttribute(c,m,y+3)),(t.tangent||t.bitangent)&&(_=Cartesian3.fromArray(i,C,_),t.bitangent&&(CorridorGeometryLibrary.addAttribute(d,_,v),CorridorGeometryLibrary.addAttribute(d,_,v+3),CorridorGeometryLibrary.addAttribute(d,_,y),CorridorGeometryLibrary.addAttribute(d,_,y+3)),t.tangent&&(g=Cartesian3.normalize(Cartesian3.cross(_,m,g),g),CorridorGeometryLibrary.addAttribute(u,g,v),CorridorGeometryLibrary.addAttribute(u,g,v+3),CorridorGeometryLibrary.addAttribute(u,g,y),CorridorGeometryLibrary.addAttribute(u,g,y+3))),y+=6}if(t.normal){for(c.set(i),C=0;C<a;C+=3)c[C+a]=-i[C],c[C+a+1]=-i[C+1],c[C+a+2]=-i[C+2];e.normal.values=c}else e.normal=void 0;t.bitangent?(d.set(l),d.set(l,a),e.bitangent.values=d):e.bitangent=void 0,t.tangent&&(l=e.tangent.values,u.set(l),u.set(l,a),e.tangent.values=u)}if(t.st){var T=e.st.values,S=new Float32Array(6*o);S.set(T),S.set(T,o);for(var A=2*o,x=0;x<2;x++){for(S[A++]=T[0],S[A++]=T[1],C=2;C<o;C+=2){var b=T[C],E=T[C+1];S[A++]=b,S[A++]=E,S[A++]=b,S[A++]=E}S[A++]=T[0],S[A++]=T[1]}e.st.values=S}return e}function addWallPositions$1(e,t,i){i[t++]=e[0],i[t++]=e[1],i[t++]=e[2];for(var r=3;r<e.length;r+=3){var n=e[r],a=e[r+1],o=e[r+2];i[t++]=n,i[t++]=a,i[t++]=o,i[t++]=n,i[t++]=a,i[t++]=o}return i[t++]=e[0],i[t++]=e[1],i[t++]=e[2],i}function computePositionsExtruded$1(e,t){var i=new VertexFormat({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),r=e.ellipsoid,n=combine$1(CorridorGeometryLibrary.computePositions(e),i,r),a=e.height,o=e.extrudedHeight,s=n.attributes,l=n.indices,c=s.position.values,u=c.length,d=new Float64Array(6*u),i=new Float64Array(u);i.set(c);n=new Float64Array(4*u),n=addWallPositions$1(c=PolygonPipeline.scaleToGeodeticHeight(c,a,r),0,n);n=addWallPositions$1(i=PolygonPipeline.scaleToGeodeticHeight(i,o,r),2*u,n),d.set(c),d.set(i,u),d.set(n,2*u),s.position.values=d;var s=extrudedAttributes(s,t),h=u/3;if(e.shadowVolume){for(var p=s.normal.values,u=p.length,n=new Float32Array(6*u),f=0;f<u;f++)p[f]=-p[f];n.set(p,u),n=addWallPositions$1(p,4*u,n),s.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n}),t.normal||(s.normal=void 0)}defined(e.offsetAttribute)&&(t=new Uint8Array(6*h),t=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?(t=arrayFill(t,1,0,h),arrayFill(t,1,2*h,4*h)):arrayFill(t,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}));var m=l.length,g=h+h,_=IndexDatatype$1.createTypedArray(d.length/3,2*m+3*g);_.set(l);var y,C,v,T,S=m;for(f=0;f<m;f+=3){var A=l[f],x=l[f+1],b=l[f+2];_[S++]=b+h,_[S++]=x+h,_[S++]=A+h}for(f=0;f<g;f+=2)v=(y=f+g)+1,T=(C=y+g)+1,_[S++]=y,_[S++]=C,_[S++]=v,_[S++]=v,_[S++]=C,_[S++]=T;return{attributes:s,indices:_}}var scratchCartesian1$2=new Cartesian3,scratchCartesian2$5=new Cartesian3,scratchCartographic$e=new Cartographic;function computeOffsetPoints(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,scratchCartesian1$2);Cartesian3.normalize(o,o);var s=i.geodeticSurfaceNormal(e,scratchCartesian2$5),l=Cartesian3.cross(o,s,scratchCartesian1$2);Cartesian3.multiplyByScalar(l,r,l);var c=n.latitude,u=n.longitude,t=a.latitude,o=a.longitude;Cartesian3.add(e,l,scratchCartesian2$5),i.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e);s=scratchCartographic$e.latitude,r=scratchCartographic$e.longitude,c=Math.min(c,s),u=Math.min(u,r),t=Math.max(t,s),o=Math.max(o,r);Cartesian3.subtract(e,l,scratchCartesian2$5),i.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e),s=scratchCartographic$e.latitude,r=scratchCartographic$e.longitude,c=Math.min(c,s),u=Math.min(u,r),t=Math.max(t,s),o=Math.max(o,r),n.latitude=c,n.longitude=u,a.latitude=t,a.longitude=o}var scratchCartesianOffset=new Cartesian3,scratchCartesianEnds=new Cartesian3,scratchCartographicMin=new Cartographic,scratchCartographicMax=new Cartographic;function computeRectangle$2(e,t,i,r,n){var a=arrayRemoveDuplicates(e=scaleToSurface$1(e,t),Cartesian3.equalsEpsilon),o=a.length;if(o<2||i<=0)return new Rectangle;var s,l,c=.5*i;scratchCartographicMin.latitude=Number.POSITIVE_INFINITY,scratchCartographicMin.longitude=Number.POSITIVE_INFINITY,scratchCartographicMax.latitude=Number.NEGATIVE_INFINITY,scratchCartographicMax.longitude=Number.NEGATIVE_INFINITY,r===CornerType$1.ROUNDED&&(d=a[0],Cartesian3.subtract(d,a[1],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(d,scratchCartesianOffset,scratchCartesianEnds),t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),s=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));for(var u=0;u<o-1;++u)computeOffsetPoints(a[u],a[u+1],t,c,scratchCartographicMin,scratchCartographicMax);var d=a[o-1];Cartesian3.subtract(d,a[o-2],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(d,scratchCartesianOffset,scratchCartesianEnds),computeOffsetPoints(d,scratchCartesianEnds,t,c,scratchCartographicMin,scratchCartographicMax),r===CornerType$1.ROUNDED&&(t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),s=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));n=defined(n)?n:new Rectangle;return n.north=scratchCartographicMax.latitude,n.south=scratchCartographicMin.latitude,n.east=scratchCartographicMax.longitude,n.west=scratchCartographicMin.longitude,n}function CorridorGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7}CorridorGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$b=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$9=new VertexFormat,scratchOptions$f={positions:void 0,ellipsoid:scratchEllipsoid$b,vertexFormat:scratchVertexFormat$9,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};CorridorGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$b);t+=Ellipsoid.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$9);t+=VertexFormat.packedLength;var l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],f=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._width=l,i._height=c,i._extrudedHeight=u,i._cornerType=d,i._granularity=h,i._shadowVolume=p,i._offsetAttribute=-1===f?void 0:f,i):(scratchOptions$f.positions=n,scratchOptions$f.width=l,scratchOptions$f.height=c,scratchOptions$f.extrudedHeight=u,scratchOptions$f.cornerType=d,scratchOptions$f.granularity=h,scratchOptions$f.shadowVolume=p,scratchOptions$f.offsetAttribute=-1===f?void 0:f,new CorridorGeometry(scratchOptions$f))},CorridorGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,r=e.width;return computeRectangle$2(i,defaultValue(e.ellipsoid,Ellipsoid.WGS84),r,defaultValue(e.cornerType,CornerType$1.ROUNDED),t)},CorridorGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$1(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),t=e._vertexFormat,i={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};l?(i.height=o,i.extrudedHeight=s,i.shadowVolume=e._shadowVolume,i.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded$1(i,t)):((a=combine$1(CorridorGeometryLibrary.computePositions(i),t,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)&&(c=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,u=a.attributes.position.values.length,arrayFill(u=new Uint8Array(u/3),c),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:u})));var c=a.attributes,u=BoundingSphere.fromVertices(c.position.values,void 0,3);return t.position||(a.attributes.position.values=void 0),new Geometry({attributes:c,indices:a.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:u,offsetAttribute:e._offsetAttribute})}},CorridorGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new CorridorGeometry({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CorridorGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$2(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});var cartesian1=new Cartesian3,cartesian2=new Cartesian3,cartesian3=new Cartesian3;function scaleToSurface(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function combine(e,t){var i,r=[],n=e.positions,a=e.corners,o=e.endPositions,s=new GeometryAttributes,l=0,c=0,u=0;for(D=0;D<n.length;D+=2)l+=i=n[D].length-3,u+=i/3*4,c+=n[D+1].length-3;for(l+=3,c+=3,D=0;D<a.length;D++){var d=a[D],h=a[D].leftPositions;defined(h)?l+=i=h.length:c+=i=a[D].rightPositions.length,u+=i/3*2}var p,f=defined(o);f&&(l+=p=o[0].length-3,c+=p,u+=4*(p/=3));var m,g,_,y,e=l+c,C=new Float64Array(e),v=0,T=e-1,S=p/2,A=IndexDatatype$1.createTypedArray(e/3,u+4),x=0;if(A[x++]=v/3,A[x++]=(T-2)/3,f){r.push(v/3);for(var b=cartesian1,E=cartesian2,P=o[0],D=0;D<S;D++)b=Cartesian3.fromArray(P,3*(S-1-D),b),E=Cartesian3.fromArray(P,3*(S+D),E),CorridorGeometryLibrary.addAttribute(C,E,v),CorridorGeometryLibrary.addAttribute(C,b,void 0,T),y=(g=v/3)+1,_=(m=(T-2)/3)-1,A[x++]=m,A[x++]=_,A[x++]=g,A[x++]=y,v+=3,T-=3}var w=0,M=n[w++],I=n[w++];for(C.set(M,v),C.set(I,T-I.length+1),i=I.length-3,r.push(v/3,(T-2)/3),D=0;D<i;D+=3)y=(g=v/3)+1,_=(m=(T-2)/3)-1,A[x++]=m,A[x++]=_,A[x++]=g,A[x++]=y,v+=3,T-=3;for(D=0;D<a.length;D++){var R,O,B=(d=a[D]).leftPositions,L=d.rightPositions,F=cartesian3;if(defined(B)){for(T-=3,O=_,r.push(y),R=0;R<B.length/3;R++)F=Cartesian3.fromArray(B,3*R,F),A[x++]=O-R-1,A[x++]=O-R,CorridorGeometryLibrary.addAttribute(C,F,void 0,T),T-=3;r.push(O-Math.floor(B.length/6)),t===CornerType$1.BEVELED&&r.push((T-2)/3+1),v+=3}else{for(v+=3,O=y,r.push(_),R=0;R<L.length/3;R++)F=Cartesian3.fromArray(L,3*R,F),A[x++]=O+R,A[x++]=O+R+1,CorridorGeometryLibrary.addAttribute(C,F,v),v+=3;r.push(O+Math.floor(L.length/6)),t===CornerType$1.BEVELED&&r.push(v/3-1),T-=3}for(M=n[w++],I=n[w++],M.splice(0,3),I.splice(I.length-3,3),C.set(M,v),C.set(I,T-I.length+1),i=I.length-3,R=0;R<I.length;R+=3)g=(y=v/3)-1,A[x++]=m=(_=(T-2)/3)+1,A[x++]=_,A[x++]=g,A[x++]=y,v+=3,T-=3;v-=3,T+=3,r.push(v/3,(T-2)/3)}if(f){v+=3,T-=3,b=cartesian1,E=cartesian2;var N=o[1];for(D=0;D<S;D++)b=Cartesian3.fromArray(N,3*(p-D-1),b),E=Cartesian3.fromArray(N,3*D,E),CorridorGeometryLibrary.addAttribute(C,b,void 0,T),CorridorGeometryLibrary.addAttribute(C,E,v),g=(y=v/3)-1,A[x++]=m=(_=(T-2)/3)+1,A[x++]=_,A[x++]=g,A[x++]=y,v+=3,T-=3;r.push(v/3)}else r.push(v/3,(T-2)/3);return A[x++]=v/3,A[x++]=(T-2)/3,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:C}),{attributes:s,indices:A,wallIndices:r}}function computePositionsExtruded(e){var t=e.ellipsoid,i=combine(CorridorGeometryLibrary.computePositions(e),e.cornerType),r=i.wallIndices,n=e.height,a=e.extrudedHeight,o=i.attributes,s=i.indices,l=(c=o.position.values).length;(u=new Float64Array(l)).set(c);var i=new Float64Array(2*l),c=PolygonPipeline.scaleToGeodeticHeight(c,n,t),u=PolygonPipeline.scaleToGeodeticHeight(u,a,t);i.set(c),i.set(u,l),o.position.values=i,l/=3,defined(e.offsetAttribute)&&(u=new Uint8Array(2*l),u=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(u,1,0,l):arrayFill(u,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:u}));var d=s.length,h=IndexDatatype$1.createTypedArray(i.length/3,2*(d+r.length));h.set(s);for(var p,f,m=d,g=0;g<d;g+=2){var _=s[g],y=s[g+1];h[m++]=_+l,h[m++]=y+l}for(g=0;g<r.length;g++)f=(p=r[g])+l,h[m++]=p,h[m++]=f;return{attributes:o,indices:h}}function CorridorOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._offsetAttribute=e.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+6}CorridorOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$a=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$e={positions:void 0,ellipsoid:scratchEllipsoid$a,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};function CullingVolume(e){this.planes=defaultValue(e,[])}CorridorOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$a);t+=Ellipsoid.packedLength;var s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._width=s,i._height=l,i._extrudedHeight=c,i._cornerType=u,i._granularity=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$e.positions=n,scratchOptions$e.width=s,scratchOptions$e.height=l,scratchOptions$e.extrudedHeight=c,scratchOptions$e.cornerType=u,scratchOptions$e.granularity=d,scratchOptions$e.offsetAttribute=-1===h?void 0:h,new CorridorOutlineGeometry(scratchOptions$e))},CorridorOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,t=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),i={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};t?(i.height=o,i.extrudedHeight=s,i.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded(i)):((a=combine(CorridorGeometryLibrary.computePositions(i),i.cornerType)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)&&(l=a.attributes.position.values.length,arrayFill(c=new Uint8Array(l/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})));var l=a.attributes,c=BoundingSphere.fromVertices(l.position.values,void 0,3);return new Geometry({attributes:l,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:c,offsetAttribute:e._offsetAttribute})}};var faces=[new Cartesian3,new Cartesian3,new Cartesian3];Cartesian3.clone(Cartesian3.UNIT_X,faces[0]),Cartesian3.clone(Cartesian3.UNIT_Y,faces[1]),Cartesian3.clone(Cartesian3.UNIT_Z,faces[2]);var scratchPlaneCenter=new Cartesian3,scratchPlaneNormal=new Cartesian3,scratchPlane$1=new Plane(new Cartesian3(1,0,0),0);function CustomHeightmapTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._callback=e.callback,this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._width=e.width,this._height=e.height;var t=Math.max(this._width,this._height);this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,t,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event;e=e.credit;"string"==typeof e&&(e=new Credit(e)),this._credit=e,this._readyPromise=when.resolve(!0)}CullingVolume.fromBoundingSphere=function(e,t){defined(t)||(t=new CullingVolume);var i=faces.length,r=t.planes;r.length=2*i;for(var n=e.center,a=e.radius,o=0,s=0;s<i;++s){var l=faces[s],c=r[o],u=r[o+1];defined(c)||(c=r[o]=new Cartesian4),defined(u)||(u=r[o+1]=new Cartesian4),Cartesian3.multiplyByScalar(l,-a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),c.x=l.x,c.y=l.y,c.z=l.z,c.w=-Cartesian3.dot(l,scratchPlaneCenter),Cartesian3.multiplyByScalar(l,a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),u.x=-l.x,u.y=-l.y,u.z=-l.z,u.w=-Cartesian3.dot(Cartesian3.negate(l,scratchPlaneNormal),scratchPlaneCenter),o+=2}return t},CullingVolume.prototype.computeVisibility=function(e){for(var t=this.planes,i=!1,r=0,n=t.length;r<n;++r){var a=e.intersectPlane(Plane.fromCartesian4(t[r],scratchPlane$1));if(a===Intersect$1.OUTSIDE)return Intersect$1.OUTSIDE;a===Intersect$1.INTERSECTING&&(i=!0)}return i?Intersect$1.INTERSECTING:Intersect$1.INSIDE},CullingVolume.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===CullingVolume.MASK_OUTSIDE||t===CullingVolume.MASK_INSIDE)return t;for(var i=CullingVolume.MASK_INSIDE,r=this.planes,n=0,a=r.length;n<a;++n){var o=n<31?1<<n:0;if(!(n<31&&0==(t&o))){var s=e.intersectPlane(Plane.fromCartesian4(r[n],scratchPlane$1));if(s===Intersect$1.OUTSIDE)return CullingVolume.MASK_OUTSIDE;s===Intersect$1.INTERSECTING&&(i|=o)}}return i},CullingVolume.MASK_OUTSIDE=4294967295,CullingVolume.MASK_INSIDE=0,CullingVolume.MASK_INDETERMINATE=2147483647,Object.defineProperties(CustomHeightmapTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},width:{get:function(){return this._width}},height:{get:function(){return this._height}}}),CustomHeightmapTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){i=this._callback(e,t,i);if(defined(i)){var n=this._width,a=this._height;return when(i).then(function(e){return new HeightmapTerrainData({buffer:e=Array.isArray(e)?new Float64Array(e):e,width:n,height:a})})}},CustomHeightmapTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CustomHeightmapTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},CustomHeightmapTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var CylinderGeometryLibrary={computePositions:function(e,t,i,r,n){for(var a=.5*e,o=-a,e=r+r,s=new Float64Array(3*(n?2*e:e)),l=0,c=0,u=n?3*e:0,d=n?3*(e+r):3*r,h=0;h<r;h++){var p=h/r*CesiumMath.TWO_PI,f=Math.cos(p),m=Math.sin(p),g=f*i,p=m*i,f=f*t,m=m*t;s[c+u]=g,s[c+u+1]=p,s[c+u+2]=o,s[c+d]=f,s[c+d+1]=m,s[c+d+2]=a,c+=3,n&&(s[l++]=g,s[l++]=p,s[l++]=o,s[l++]=f,s[l++]=m,s[l++]=a)}return s}},radiusScratch$1=new Cartesian2,normalScratch$3=new Cartesian3,bitangentScratch$1=new Cartesian3,tangentScratch$1=new Cartesian3,positionScratch$a=new Cartesian3;function CylinderGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.slices,128);this._length=t,this._topRadius=i,this._bottomRadius=r,this._vertexFormat=VertexFormat.clone(n),this._slices=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}CylinderGeometry.packedLength=VertexFormat.packedLength+5,CylinderGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchVertexFormat$8=new VertexFormat,scratchOptions$d={vertexFormat:scratchVertexFormat$8,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0},unitCylinderGeometry;CylinderGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$8);t+=VertexFormat.packedLength;var n=e[t++],a=e[t++],o=e[t++],s=e[t++],t=e[t];return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i._length=n,i._topRadius=a,i._bottomRadius=o,i._slices=s,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$d.length=n,scratchOptions$d.topRadius=a,scratchOptions$d.bottomRadius=o,scratchOptions$d.slices=s,scratchOptions$d.offsetAttribute=-1===t?void 0:t,new CylinderGeometry(scratchOptions$d))},CylinderGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._vertexFormat,a=e._slices;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o=a+a,s=a+o,l=o+o,c=CylinderGeometryLibrary.computePositions(t,i,r,a,!0),u=n.st?new Float32Array(2*l):void 0,d=n.normal?new Float32Array(3*l):void 0,h=n.tangent?new Float32Array(3*l):void 0,p=n.bitangent?new Float32Array(3*l):void 0,f=n.normal||n.tangent||n.bitangent;if(f){var m=n.tangent||n.bitangent,g=0,_=0,y=0,C=Math.atan2(r-i,t),v=normalScratch$3;v.z=Math.sin(C);for(var T=Math.cos(C),S=tangentScratch$1,A=bitangentScratch$1,x=0;x<a;x++){var b=x/a*CesiumMath.TWO_PI,E=T*Math.cos(b),b=T*Math.sin(b);f&&(v.x=E,v.y=b,m&&(S=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,v,S),S)),n.normal&&(d[g++]=v.x,d[g++]=v.y,d[g++]=v.z,d[g++]=v.x,d[g++]=v.y,d[g++]=v.z),n.tangent&&(h[_++]=S.x,h[_++]=S.y,h[_++]=S.z,h[_++]=S.x,h[_++]=S.y,h[_++]=S.z),n.bitangent&&(A=Cartesian3.normalize(Cartesian3.cross(v,S,A),A),p[y++]=A.x,p[y++]=A.y,p[y++]=A.z,p[y++]=A.x,p[y++]=A.y,p[y++]=A.z))}for(x=0;x<a;x++)n.normal&&(d[g++]=0,d[g++]=0,d[g++]=-1),n.tangent&&(h[_++]=1,h[_++]=0,h[_++]=0),n.bitangent&&(p[y++]=0,p[y++]=-1,p[y++]=0);for(x=0;x<a;x++)n.normal&&(d[g++]=0,d[g++]=0,d[g++]=1),n.tangent&&(h[_++]=1,h[_++]=0,h[_++]=0),n.bitangent&&(p[y++]=0,p[y++]=1,p[y++]=0)}var P=IndexDatatype$1.createTypedArray(l,12*a-12),D=0,w=0;for(x=0;x<a-1;x++)P[D++]=w,P[D++]=w+2,P[D++]=w+3,P[D++]=w,P[D++]=w+3,P[D++]=w+1,w+=2;for(P[D++]=o-2,P[D++]=0,P[D++]=1,P[D++]=o-2,P[D++]=1,P[D++]=o-1,x=1;x<a-1;x++)P[D++]=o+x+1,P[D++]=o+x,P[D++]=o;for(x=1;x<a-1;x++)P[D++]=s,P[D++]=s+x,P[D++]=s+x+1;var M=0;if(n.st){var I=Math.max(i,r);for(x=0;x<l;x++){var R=Cartesian3.fromArray(c,3*x,positionScratch$a);u[M++]=(R.x+I)/(2*I),u[M++]=(R.y+I)/(2*I)}}C=new GeometryAttributes;n.position&&(C.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})),n.normal&&(C.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),n.tangent&&(C.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.bitangent&&(C.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.st&&(C.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:u})),radiusScratch$1.x=.5*t,radiusScratch$1.y=Math.max(r,i);i=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch$1));return defined(e._offsetAttribute)&&(t=c.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),C.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})),new Geometry({attributes:C,indices:P,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}},CylinderGeometry.getUnitCylinder=function(){return unitCylinderGeometry=!defined(unitCylinderGeometry)?CylinderGeometry.createGeometry(new CylinderGeometry({topRadius:1,bottomRadius:1,length:1,vertexFormat:VertexFormat.POSITION_ONLY})):unitCylinderGeometry};var radiusScratch=new Cartesian2;function CylinderOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.slices,128),a=Math.max(defaultValue(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=i,this._bottomRadius=r,this._slices=n,this._numberOfVerticalLines=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderOutlineGeometry"}CylinderOutlineGeometry.packedLength=6,CylinderOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchOptions$c={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function DefaultProxy(e){this.proxy=e}function DistanceDisplayCondition(e,t){e=defaultValue(e,0),this._near=e,t=defaultValue(t,Number.MAX_VALUE),this._far=t}function DistanceDisplayConditionGeometryInstanceAttribute(e,t){e=defaultValue(e,0),t=defaultValue(t,Number.MAX_VALUE),this.value=new Float32Array([e,t])}function DoubleEndedPriorityQueue(e){this._comparator=e.comparator,this._maximumLength=e.maximumLength,this._array=defined(e.maximumLength)?new Array(e.maximumLength):[],this._length=0}function swap$2(e,t,i){var r=e._array,e=r[t];r[t]=r[i],r[i]=e}function lessThan(e,t,i){return e._comparator(e._array[t],e._array[i])<0}function greaterThan(e,t,i){return 0<e._comparator(e._array[t],e._array[i])}function pushUp(e,t){if(0!==t){var i=Math.floor(CesiumMath.log2(t+1))%2==0,r=Math.floor((t-1)/2),n=lessThan(e,t,r);for(n!==i&&(swap$2(e,t,r),t=r);3<=t;){var a=Math.floor((t-3)/4);if(lessThan(e,t,a)!==n)break;swap$2(e,t,a),t=a}}}function pushDown(e,t){for(var i,r=e._length,n=Math.floor(CesiumMath.log2(t+1))%2==0;(i=2*t+1)<r;){var a=i,o=1+i;if(o<r){lessThan(e,o,a)===n&&(a=o);for(var s=2*i+1,l=Math.max(Math.min(r-s,4),0),c=0;c<l;c++){var u=s+c;lessThan(e,u,a)===n&&(a=u)}}lessThan(e,a,t)===n&&(swap$2(e,a,t),a===i||a===o||greaterThan(e,a,o=Math.floor((a-1)/2))===n&&swap$2(e,a,o)),t=a}}function DoublyLinkedList(){this.head=void 0,this.tail=void 0,this._length=0}function DoublyLinkedListNode(e,t,i){this.item=e,this.previous=t,this.next=i}function remove$2(e,t){defined(t.previous)&&defined(t.next)?(t.previous.next=t.next,t.next.previous=t.previous):defined(t.previous)?(t.previous.next=void 0,e.tail=t.previous):defined(t.next)?(t.next.previous=void 0,e.head=t.next):(e.head=void 0,e.tail=void 0),t.next=void 0,t.previous=void 0}CylinderOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=e[t++],n=e[t++],a=e[t++],o=e[t++],s=e[t++],t=e[t];return defined(i)?(i._length=r,i._topRadius=n,i._bottomRadius=a,i._slices=o,i._numberOfVerticalLines=s,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$c.length=r,scratchOptions$c.topRadius=n,scratchOptions$c.bottomRadius=a,scratchOptions$c.slices=o,scratchOptions$c.numberOfVerticalLines=s,scratchOptions$c.offsetAttribute=-1===t?void 0:t,new CylinderOutlineGeometry(scratchOptions$c))},CylinderOutlineGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._slices,a=e._numberOfVerticalLines;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s,l=2*n,c=CylinderGeometryLibrary.computePositions(t,i,r,n,!1),u=2*n;0<a&&(o=Math.min(a,n),s=Math.round(n/o),u+=o);for(var d=IndexDatatype$1.createTypedArray(l,2*u),h=0,p=0;p<n-1;p++)d[h++]=p,d[h++]=p+1,d[h++]=p+n,d[h++]=p+1+n;if(d[h++]=n-1,d[h++]=0,d[h++]=n+n-1,d[h++]=n,0<a)for(p=0;p<n;p+=s)d[h++]=p,d[h++]=p+n;a=new GeometryAttributes;a.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c}),radiusScratch.x=.5*t,radiusScratch.y=Math.max(r,i);i=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch));return defined(e._offsetAttribute)&&(t=c.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})),new Geometry({attributes:a,indices:d,primitiveType:PrimitiveType$1.LINES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}},DefaultProxy.prototype.getURL=function(e){var t=-1===this.proxy.indexOf("?")?"?":"";return this.proxy+t+encodeURIComponent(e)},Object.defineProperties(DistanceDisplayCondition.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}}),DistanceDisplayCondition.packedLength=2,DistanceDisplayCondition.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i]=e.far,t},DistanceDisplayCondition.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new DistanceDisplayCondition:i).near=e[t++],i.far=e[t],i},DistanceDisplayCondition.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.far===t.far},DistanceDisplayCondition.clone=function(e,t){if(defined(e))return(t=!defined(t)?new DistanceDisplayCondition:t).near=e.near,t.far=e.far,t},DistanceDisplayCondition.prototype.clone=function(e){return DistanceDisplayCondition.clone(this,e)},DistanceDisplayCondition.prototype.equals=function(e){return DistanceDisplayCondition.equals(this,e)},Object.defineProperties(DistanceDisplayConditionGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}}),DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition=function(e){return new DistanceDisplayConditionGeometryInstanceAttribute(e.near,e.far)},DistanceDisplayConditionGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e.near,t[1]=e.far,t):new Float32Array([e.near,e.far])},Object.defineProperties(DoubleEndedPriorityQueue.prototype,{length:{get:function(){return this._length}},maximumLength:{get:function(){return this._maximumLength},set:function(e){if(defined(e)){for(;this._length>e;)this.removeMinimum();this._array.length=e}this._maximumLength=e}},internalArray:{get:function(){return this._array}},comparator:{get:function(){return this._comparator}}}),DoubleEndedPriorityQueue.prototype.clone=function(){var e=this._maximumLength,t=this._comparator,i=this._array,r=this._length,n=new DoubleEndedPriorityQueue({comparator:t,maximumLength:e});n._length=r;for(var a=0;a<r;a++)n._array[a]=i[a];return n},DoubleEndedPriorityQueue.prototype.reset=function(){this._length=0;var e=this._maximumLength;if(defined(e))for(var t=0;t<e;t++)this._array[t]=void 0;else this._array.length=0},DoubleEndedPriorityQueue.prototype.resort=function(){for(var e=this._length,t=0;t<e;t++)pushUp(this,t)},DoubleEndedPriorityQueue.prototype.insert=function(e){var t,i=this._maximumLength;if(defined(i)){if(0===i)return;if(this._length===i){var r=this._array[0];if(this._comparator(e,r)<=0)return e;t=this.removeMinimum()}}r=this._length;return this._array[r]=e,this._length++,pushUp(this,r),t},DoubleEndedPriorityQueue.prototype.removeMinimum=function(){var e=this._length;if(0!==e){this._length--;var t=this._array[0];return 2<=e&&(this._array[0]=this._array[e-1],pushDown(this,0)),this._array[e-1]=void 0,t}},DoubleEndedPriorityQueue.prototype.removeMaximum=function(){var e,t,i=this._length;if(0!==i)return this._length--,i<=2?t=this._array[i-1]:(e=greaterThan(this,1,2)?1:2,t=this._array[e],this._array[e]=this._array[i-1],4<=i&&pushDown(this,e)),this._array[i-1]=void 0,t},DoubleEndedPriorityQueue.prototype.getMinimum=function(){if(0!==this._length)return this._array[0]},DoubleEndedPriorityQueue.prototype.getMaximum=function(){var e=this._length;if(0!==e)return e<=2?this._array[e-1]:this._array[greaterThan(this,1,2)?1:2]},Object.defineProperties(DoublyLinkedList.prototype,{length:{get:function(){return this._length}}}),DoublyLinkedList.prototype.add=function(e){e=new DoublyLinkedListNode(e,this.tail,void 0);return defined(this.tail)?this.tail.next=e:this.head=e,this.tail=e,++this._length,e},DoublyLinkedList.prototype.remove=function(e){defined(e)&&(remove$2(this,e),--this._length)},DoublyLinkedList.prototype.splice=function(e,t){var i;e!==t&&(remove$2(this,t),i=e.next,e.next=t,this.tail===e?this.tail=t:i.previous=t,t.next=i,t.previous=e)};var Tween$1=createCommonjsModule(function(e,t){var r,n,s=s||(r=[],{getAll:function(){return r},removeAll:function(){r=[]},add:function(e){r.push(e)},remove:function(e){e=r.indexOf(e);-1!==e&&r.splice(e,1)},update:function(e,t){if(0===r.length)return!1;var i=0;for(e=void 0!==e?e:s.now();i<r.length;)r[i].update(e)||t?i++:r.splice(i,1);return!0}});"undefined"==typeof window&&"undefined"!=typeof process?s.now=function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?s.now=window.performance.now.bind(window.performance):void 0!==Date.now?s.now=Date.now:s.now=function(){return(new Date).getTime()},s.Tween=function(e){var c,u=e,d={},h={},p={},f=1e3,m=0,g=!1,i=!1,_=0,y=null,C=s.Easing.Linear.None,v=s.Interpolation.Linear,T=[],S=null,A=!1,x=null,b=null,t=null;this.to=function(e,t){return h=e,void 0!==t&&(f=t),this},this.start=function(e){for(var t in s.add(this),A=!(i=!0),y=void 0!==e?e:s.now(),y+=_,h){if(h[t]instanceof Array){if(0===h[t].length)continue;h[t]=[u[t]].concat(h[t])}void 0!==u[t]&&(d[t]=u[t],d[t]instanceof Array==!1&&(d[t]*=1),p[t]=d[t]||0)}return this},this.stop=function(){return i&&(s.remove(this),i=!1,null!==t&&t.call(u,u),this.stopChainedTweens()),this},this.end=function(){return this.update(y+f),this},this.stopChainedTweens=function(){for(var e=0,t=T.length;e<t;e++)T[e].stop()},this.delay=function(e){return _=e,this},this.repeat=function(e){return m=e,this},this.repeatDelay=function(e){return c=e,this},this.yoyo=function(e){return g=e,this},this.easing=function(e){return C=e,this},this.interpolation=function(e){return v=e,this},this.chain=function(){return T=arguments,this},this.onStart=function(e){return S=e,this},this.onUpdate=function(e){return x=e,this},this.onComplete=function(e){return b=e,this},this.onStop=function(e){return t=e,this},this.update=function(e){var t,i,r,n,a,o;if(e<y)return!0;for(t in!1===A&&(null!==S&&S.call(u,u),A=!0),r=C(i=1<(i=(e-y)/f)?1:i),h)void 0!==d[t]&&(n=d[t]||0,(a=h[t])instanceof Array?u[t]=v(a,r):"number"==typeof(a="string"==typeof a?"+"===a.charAt(0)||"-"===a.charAt(0)?n+parseFloat(a):parseFloat(a):a)&&(u[t]=n+(a-n)*r));if(null!==x&&x.call(u,r),1!==i)return!0;if(0<m){for(t in isFinite(m)&&m--,p)"string"==typeof h[t]&&(p[t]=p[t]+parseFloat(h[t])),g&&(o=p[t],p[t]=h[t],h[t]=o),d[t]=p[t];return y=void 0!==c?e+c:e+_,!0}null!==b&&b.call(u,u);for(var s=0,l=T.length;s<l;s++)T[s].start(y+f);return!1}},s.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){return 0===e?0:1===e?1:-Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)},Out:function(e){return 0===e?0:1===e?1:Math.pow(2,-10*e)*Math.sin(5*(e-.1)*Math.PI)+1},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?-.5*Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI):.5*Math.pow(2,-10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)+1}},Back:{In:function(e){return e*e*(2.70158*e-1.70158)},Out:function(e){return--e*e*(2.70158*e+1.70158)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((1+t)*e-t)*.5:.5*((e-=2)*e*((1+t)*e+t)+2)}},Bounce:{In:function(e){return 1-s.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*s.Easing.Bounce.In(2*e):.5*s.Easing.Bounce.Out(2*e-1)+.5}}},s.Interpolation={Linear:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=s.Interpolation.Utils.Linear;return t<0?a(e[0],e[1],r):1<t?a(e[i],e[i-1],i-r):a(e[n],e[i<n+1?i:n+1],r-n)},Bezier:function(e,t){for(var i=0,r=e.length-1,n=Math.pow,a=s.Interpolation.Utils.Bernstein,o=0;o<=r;o++)i+=n(1-t,r-o)*n(t,o)*e[o]*a(r,o);return i},CatmullRom:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=s.Interpolation.Utils.CatmullRom;return e[0]===e[i]?a(e[((n=t<0?Math.floor(r=i*(1+t)):n)-1+i)%i],e[n],e[(n+1)%i],e[(n+2)%i],r-n):t<0?e[0]-(a(e[0],e[0],e[1],e[1],-r)-e[0]):1<t?e[i]-(a(e[i],e[i],e[i-1],e[i-1],r-i)-e[i]):a(e[n?n-1:0],e[n],e[i<n+1?i:n+1],e[i<n+2?i:n+2],r-n)},Utils:{Linear:function(e,t,i){return(t-e)*i+e},Bernstein:function(e,t){var i=s.Interpolation.Utils.Factorial;return i(e)/i(t)/i(e-t)},Factorial:(n=[1],function(e){var t=1;if(n[e])return n[e];for(var i=e;1<i;i--)t*=i;return n[e]=t}),CatmullRom:function(e,t,i,r,n){var a=.5*(i-e),e=.5*(r-t),r=n*n;return(2*t-2*i+a+e)*(n*r)+(-3*t+3*i-2*a-e)*r+a*n+t}}},e.exports=s}),EasingFunction={LINEAR_NONE:Tween$1.Easing.Linear.None,QUADRATIC_IN:Tween$1.Easing.Quadratic.In,QUADRATIC_OUT:Tween$1.Easing.Quadratic.Out,QUADRATIC_IN_OUT:Tween$1.Easing.Quadratic.InOut,CUBIC_IN:Tween$1.Easing.Cubic.In,CUBIC_OUT:Tween$1.Easing.Cubic.Out,CUBIC_IN_OUT:Tween$1.Easing.Cubic.InOut,QUARTIC_IN:Tween$1.Easing.Quartic.In,QUARTIC_OUT:Tween$1.Easing.Quartic.Out,QUARTIC_IN_OUT:Tween$1.Easing.Quartic.InOut,QUINTIC_IN:Tween$1.Easing.Quintic.In,QUINTIC_OUT:Tween$1.Easing.Quintic.Out,QUINTIC_IN_OUT:Tween$1.Easing.Quintic.InOut,SINUSOIDAL_IN:Tween$1.Easing.Sinusoidal.In,SINUSOIDAL_OUT:Tween$1.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:Tween$1.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:Tween$1.Easing.Exponential.In,EXPONENTIAL_OUT:Tween$1.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:Tween$1.Easing.Exponential.InOut,CIRCULAR_IN:Tween$1.Easing.Circular.In,CIRCULAR_OUT:Tween$1.Easing.Circular.Out,CIRCULAR_IN_OUT:Tween$1.Easing.Circular.InOut,ELASTIC_IN:Tween$1.Easing.Elastic.In,ELASTIC_OUT:Tween$1.Easing.Elastic.Out,ELASTIC_IN_OUT:Tween$1.Easing.Elastic.InOut,BACK_IN:Tween$1.Easing.Back.In,BACK_OUT:Tween$1.Easing.Back.Out,BACK_IN_OUT:Tween$1.Easing.Back.InOut,BOUNCE_IN:Tween$1.Easing.Bounce.In,BOUNCE_OUT:Tween$1.Easing.Bounce.Out,BOUNCE_IN_OUT:Tween$1.Easing.Bounce.InOut},EasingFunction$1=Object.freeze(EasingFunction),scratchPosition$a=new Cartesian3,scratchNormal$3=new Cartesian3,scratchTangent$2=new Cartesian3,scratchBitangent$2=new Cartesian3,scratchNormalST=new Cartesian3,defaultRadii$1=new Cartesian3(1,1,1),cos$2=Math.cos,sin$2=Math.sin;function EllipsoidGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii$1),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,64)),l=Math.round(defaultValue(e.slicePartitions,64)),c=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._vertexFormat=VertexFormat.clone(c),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}EllipsoidGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+7,EllipsoidGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$2=new Cartesian3,scratchInnerRadii$1=new Cartesian3,scratchVertexFormat$7=new VertexFormat,scratchOptions$b={radii:scratchRadii$2,innerRadii:scratchInnerRadii$1,vertexFormat:scratchVertexFormat$7,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0},unitEllipsoidGeometry;EllipsoidGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$2);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii$1);t+=Cartesian3.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$7);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._minimumClock=o,i._maximumClock=s,i._minimumCone=l,i._maximumCone=c,i._stackPartitions=u,i._slicePartitions=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$b.minimumClock=o,scratchOptions$b.maximumClock=s,scratchOptions$b.minimumCone=l,scratchOptions$b.maximumCone=c,scratchOptions$b.stackPartitions=u,scratchOptions$b.slicePartitions=d,scratchOptions$b.offsetAttribute=-1===t?void 0:t,new EllipsoidGeometry(scratchOptions$b))},EllipsoidGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._vertexFormat,l=e._slicePartitions+1,c=e._stackPartitions+1;(l=Math.round(l*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(l=2),(c=Math.round(c*Math.abs(o-a)/CesiumMath.PI))<2&&(c=2);var u=0,d=[a],h=[r];for($=0;$<c;$++)d.push(a+$*(o-a)/(c-1));for(d.push(o),L=0;L<l;L++)h.push(r+L*(n-r)/(l-1));h.push(n);var p=d.length,f=h.length,m=0,g=1,_=i.x!==t.x||i.y!==t.y||i.z!==t.z,y=!1,C=!1,v=!1;_&&(g=2,0<a&&(y=!0,m+=l-1),o<Math.PI&&(C=!0,m+=l-1),(n-r)%CesiumMath.TWO_PI?(v=!0,m+=2*(c-1)+1):m+=1);var T=f*p*g,S=new Float64Array(3*T),A=arrayFill(new Array(T),!1),x=arrayFill(new Array(T),!1),b=l*c*g,E=IndexDatatype$1.createTypedArray(b,6*(b+m+1-(l+c)*g)),P=s.normal?new Float32Array(3*T):void 0,D=s.tangent?new Float32Array(3*T):void 0,w=s.bitangent?new Float32Array(3*T):void 0,M=s.st?new Float32Array(2*T):void 0,I=new Array(p),R=new Array(p);for($=0;$<p;$++)I[$]=sin$2(d[$]),R[$]=cos$2(d[$]);for(var O=new Array(f),B=new Array(f),L=0;L<f;L++)B[L]=cos$2(h[L]),O[L]=sin$2(h[L]);for($=0;$<p;$++)for(L=0;L<f;L++)S[u++]=t.x*I[$]*B[L],S[u++]=t.y*I[$]*O[L],S[u++]=t.z*R[$];var F,N,V,k,G=T/2;if(_)for($=0;$<p;$++)for(L=0;L<f;L++)S[u++]=i.x*I[$]*B[L],S[u++]=i.y*I[$]*O[L],S[u++]=i.z*R[$],A[G]=!0,0<$&&$!==p-1&&0!==L&&L!==f-1&&(x[G]=!0),G++;for(u=0,$=1;$<p-2;$++)for(F=$*f,N=($+1)*f,L=1;L<f-2;L++)E[u++]=N+L,E[u++]=N+L+1,E[u++]=F+L+1,E[u++]=N+L,E[u++]=F+L+1,E[u++]=F+L;if(_)for(var U=p*f,$=1;$<p-2;$++)for(F=U+$*f,N=U+($+1)*f,L=1;L<f-2;L++)E[u++]=N+L,E[u++]=F+L,E[u++]=F+L+1,E[u++]=N+L,E[u++]=F+L+1,E[u++]=N+L+1;if(_){if(y)for(k=p*f,$=1;$<f-2;$++)E[u++]=$,E[u++]=$+1,E[u++]=k+$+1,E[u++]=$,E[u++]=k+$+1,E[u++]=k+$;if(C)for(V=p*f-f,k=p*f*g-f,$=1;$<f-2;$++)E[u++]=V+$+1,E[u++]=V+$,E[u++]=k+$,E[u++]=V+$+1,E[u++]=k+$,E[u++]=k+$+1}if(v){for($=1;$<p-2;$++)E[u++]=k=f*p+(V=f*$),E[u++]=V+f,E[u++]=V,E[u++]=k,E[u++]=k+f,E[u++]=V+f;for($=1;$<p-2;$++)k=f*p+f*($+1)-1,E[u++]=(V=f*($+1)-1)+f,E[u++]=k,E[u++]=V,E[u++]=V+f,E[u++]=k+f,E[u++]=k}g=new GeometryAttributes;s.position&&(g.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:S}));var z=0,H=0,W=0,q=0,j=T/2,X=Ellipsoid.fromCartesian3(t),K=Ellipsoid.fromCartesian3(i);if(s.st||s.normal||s.tangent||s.bitangent){for($=0;$<T;$++){var Y,J=A[$]?K:X,Q=Cartesian3.fromArray(S,3*$,scratchPosition$a),Q=J.geodeticSurfaceNormal(Q,scratchNormal$3);x[$]&&Cartesian3.negate(Q,Q),s.st&&(Y=Cartesian2.negate(Q,scratchNormalST),M[z++]=Math.atan2(Y.y,Y.x)/CesiumMath.TWO_PI+.5,M[z++]=Math.asin(Q.z)/Math.PI+.5),s.normal&&(P[H++]=Q.x,P[H++]=Q.y,P[H++]=Q.z),(s.tangent||s.bitangent)&&(Y=0,A[$]&&(Y=j),Y=!y&&Y<=$&&$<Y+2*f?Cartesian3.UNIT_X:Cartesian3.UNIT_Z,Cartesian3.cross(Y,Q,Y=scratchTangent$2),Cartesian3.normalize(Y,Y),s.tangent&&(D[W++]=Y.x,D[W++]=Y.y,D[W++]=Y.z),s.bitangent&&(Y=Cartesian3.cross(Q,Y,scratchBitangent$2),Cartesian3.normalize(Y,Y),w[q++]=Y.x,w[q++]=Y.y,w[q++]=Y.z))}s.st&&(g.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:M})),s.normal&&(g.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:P})),s.tangent&&(g.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:D})),s.bitangent&&(g.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:w}))}return defined(e._offsetAttribute)&&(v=S.length,arrayFill(v=new Uint8Array(v/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),g.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:v})),new Geometry({attributes:g,indices:E,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromEllipsoid(X),offsetAttribute:e._offsetAttribute})}}},EllipsoidGeometry.getUnitEllipsoid=function(){return unitEllipsoidGeometry=!defined(unitEllipsoidGeometry)?EllipsoidGeometry.createGeometry(new EllipsoidGeometry({radii:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY})):unitEllipsoidGeometry};var defaultRadii=new Cartesian3(1,1,1),cos$1=Math.cos,sin$1=Math.sin;function EllipsoidOutlineGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,10)),l=Math.round(defaultValue(e.slicePartitions,8)),c=Math.round(defaultValue(e.subdivisions,128));this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._subdivisions=c,this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}EllipsoidOutlineGeometry.packedLength=2*Cartesian3.packedLength+8,EllipsoidOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i++]=e._subdivisions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$1=new Cartesian3,scratchInnerRadii=new Cartesian3,scratchOptions$a={radii:scratchRadii$1,innerRadii:scratchInnerRadii,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};function EllipsoidTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event,this._readyPromise=when.resolve(!0)}function EventHelper(){this._removalFunctions=[]}EllipsoidOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$1);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii);t+=Cartesian3.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._minimumClock=a,i._maximumClock=o,i._minimumCone=s,i._maximumCone=l,i._stackPartitions=c,i._slicePartitions=u,i._subdivisions=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$a.minimumClock=a,scratchOptions$a.maximumClock=o,scratchOptions$a.minimumCone=s,scratchOptions$a.maximumCone=l,scratchOptions$a.stackPartitions=c,scratchOptions$a.slicePartitions=u,scratchOptions$a.subdivisions=d,scratchOptions$a.offsetAttribute=-1===t?void 0:t,new EllipsoidOutlineGeometry(scratchOptions$a))},EllipsoidOutlineGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._subdivisions,l=Ellipsoid.fromCartesian3(t),c=e._slicePartitions+1,u=e._stackPartitions+1;(c=Math.round(c*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(c=2),(u=Math.round(u*Math.abs(o-a)/CesiumMath.PI))<2&&(u=2);var d=0,h=1,p=i.x!==t.x||i.y!==t.y||i.z!==t.z,f=!1,m=!1;p&&(h=2,0<a&&(f=!0,d+=c),o<Math.PI&&(m=!0,d+=c));for(var g,_,y=s*h*(u+c),C=new Float64Array(3*y),v=IndexDatatype$1.createTypedArray(y,2*(y+d-(c+u)*h)),T=0,S=new Array(u),A=new Array(u),x=0;x<u;x++)S[x]=sin$1(_=a+x*(o-a)/(u-1)),A[x]=cos$1(_);var b=new Array(s),E=new Array(s);for(x=0;x<s;x++)b[x]=sin$1(g=r+x*(n-r)/(s-1)),E[x]=cos$1(g);for(x=0;x<u;x++)for(D=0;D<s;D++)C[T++]=t.x*S[x]*E[D],C[T++]=t.y*S[x]*b[D],C[T++]=t.z*A[x];if(p)for(x=0;x<u;x++)for(D=0;D<s;D++)C[T++]=i.x*S[x]*E[D],C[T++]=i.y*S[x]*b[D],C[T++]=i.z*A[x];for(S.length=s,A.length=s,x=0;x<s;x++)S[x]=sin$1(_=a+x*(o-a)/(s-1)),A[x]=cos$1(_);for(b.length=c,E.length=c,x=0;x<c;x++)b[x]=sin$1(g=r+x*(n-r)/(c-1)),E[x]=cos$1(g);for(x=0;x<s;x++)for(D=0;D<c;D++)C[T++]=t.x*S[x]*E[D],C[T++]=t.y*S[x]*b[D],C[T++]=t.z*A[x];if(p)for(x=0;x<s;x++)for(D=0;D<c;D++)C[T++]=i.x*S[x]*E[D],C[T++]=i.y*S[x]*b[D],C[T++]=i.z*A[x];for(x=T=0;x<u*h;x++)for(var P=x*s,D=0;D<s-1;D++)v[T++]=P+D,v[T++]=P+D+1;var w=u*s*h;for(x=0;x<c;x++)for(D=0;D<s-1;D++)v[T++]=w+x+D*c,v[T++]=w+x+(D+1)*c;if(p)for(w=u*s*h+c*s,x=0;x<c;x++)for(D=0;D<s-1;D++)v[T++]=w+x+D*c,v[T++]=w+x+(D+1)*c;if(p){var M=u*s*h,I=M+s*c;if(f)for(x=0;x<c;x++)v[T++]=M+x,v[T++]=I+x;if(m)for(M+=s*c-c,I+=s*c-c,x=0;x<c;x++)v[T++]=M+x,v[T++]=I+x}f=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:C})});return defined(e._offsetAttribute)&&(m=C.length,arrayFill(m=new Uint8Array(m/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),f.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:m})),new Geometry({attributes:f,indices:v,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromEllipsoid(l),offsetAttribute:e._offsetAttribute})}}},Object.defineProperties(EllipsoidTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),EllipsoidTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}))},EllipsoidTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},EllipsoidTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},EllipsoidTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},EventHelper.prototype.add=function(e,t,i){var r=e.addEventListener(t,i);this._removalFunctions.push(r);var n=this;return function(){r();var e=n._removalFunctions;e.splice(e.indexOf(r),1)}},EventHelper.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,i=e.length;t<i;++t)e[t]();e.length=0};var ExperimentalFeatures={enableModelExperimental:!1},ExtrapolationType={NONE:0,HOLD:1,EXTRAPOLATE:2},ExtrapolationType$1=Object.freeze(ExtrapolationType);function OrthographicOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._orthographicMatrix=new Matrix4}function update$5(e){e.top===e._top&&e.bottom===e._bottom&&e.left===e._left&&e.right===e._right&&e.near===e._near&&e.far===e._far||(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Matrix4.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}Object.defineProperties(OrthographicOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$5(this),this._orthographicMatrix}}});var getPlanesRight$1=new Cartesian3,getPlanesNearCenter$1=new Cartesian3,getPlanesPoint=new Cartesian3,negateScratch=new Cartesian3;function OrthographicFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new OrthographicOffCenterFrustum,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far}function update$4(e){var t,i=e._offCenterFrustum;e.width===e._width&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far||(e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far,t=1/e.aspectRatio,i.right=.5*e.width,i.left=-i.right,i.top=t*i.right,i.bottom=-i.top,i.near=e.near,i.far=e.far)}function PerspectiveOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._perspectiveMatrix=new Matrix4,this._infinitePerspective=new Matrix4}function update$3(e){var t=e.top,i=e.bottom,r=e.right,n=e.left,a=e.near,o=e.far;t===e._top&&i===e._bottom&&n===e._left&&r===e._right&&a===e._near&&o===e._far||(e._left=n,e._right=r,e._top=t,e._bottom=i,e._near=a,e._far=o,e._perspectiveMatrix=Matrix4.computePerspectiveOffCenter(n,r,i,t,a,o,e._perspectiveMatrix),e._infinitePerspective=Matrix4.computeInfinitePerspectiveOffCenter(n,r,i,t,a,e._infinitePerspective))}OrthographicOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight$1);Cartesian3.normalize(u,u);var d=getPlanesNearCenter$1;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);l=getPlanesPoint;Cartesian3.multiplyByScalar(u,s,l),Cartesian3.add(d,l,l);s=r[0];return(s=!defined(s)?r[0]=new Cartesian4:s).x=u.x,s.y=u.y,s.z=u.z,s.w=-Cartesian3.dot(u,l),Cartesian3.multiplyByScalar(u,o,l),Cartesian3.add(d,l,l),(s=!defined(s=r[1])?r[1]=new Cartesian4:s).x=-u.x,s.y=-u.y,s.z=-u.z,s.w=-Cartesian3.dot(Cartesian3.negate(u,negateScratch),l),Cartesian3.multiplyByScalar(i,a,l),Cartesian3.add(d,l,l),(s=!defined(s=r[2])?r[2]=new Cartesian4:s).x=i.x,s.y=i.y,s.z=i.z,s.w=-Cartesian3.dot(i,l),Cartesian3.multiplyByScalar(i,n,l),Cartesian3.add(d,l,l),(s=!defined(s=r[3])?r[3]=new Cartesian4:s).x=-i.x,s.y=-i.y,s.z=-i.z,s.w=-Cartesian3.dot(Cartesian3.negate(i,negateScratch),l),(s=!defined(s=r[4])?r[4]=new Cartesian4:s).x=t.x,s.y=t.y,s.z=t.z,s.w=-Cartesian3.dot(t,d),Cartesian3.multiplyByScalar(t,c,l),Cartesian3.add(e,l,l),(s=!defined(s=r[5])?r[5]=new Cartesian4:s).x=-t.x,s.y=-t.y,s.z=-t.z,s.w=-Cartesian3.dot(Cartesian3.negate(t,negateScratch),l),this._cullingVolume},OrthographicOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$5(this);var a=this.right-this.left,t=r*(this.top-this.bottom)/t;return n.x=r*a/e,n.y=t,n},OrthographicOffCenterFrustum.prototype.clone=function(e){return(e=!defined(e)?new OrthographicOffCenterFrustum:e).left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},OrthographicOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof OrthographicOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},OrthographicOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof OrthographicOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},OrthographicFrustum.packedLength=4,OrthographicFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.width,t[i++]=e.aspectRatio,t[i++]=e.near,t[i]=e.far,t},OrthographicFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new OrthographicFrustum:i).width=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t],i},Object.defineProperties(OrthographicFrustum.prototype,{projectionMatrix:{get:function(){return update$4(this),this._offCenterFrustum.projectionMatrix}}}),OrthographicFrustum.prototype.computeCullingVolume=function(e,t,i){return update$4(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},OrthographicFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$4(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},OrthographicFrustum.prototype.clone=function(e){return(e=!defined(e)?new OrthographicFrustum:e).aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},OrthographicFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},OrthographicFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),CesiumMath.equalsEpsilon(this.width,e.width,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))},Object.defineProperties(PerspectiveOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$3(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return update$3(this),this._infinitePerspective}}});var getPlanesRight=new Cartesian3,getPlanesNearCenter=new Cartesian3,getPlanesFarCenter=new Cartesian3,getPlanesNormal=new Cartesian3;function PerspectiveFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new PerspectiveOffCenterFrustum,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this.xOffset=defaultValue(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=defaultValue(e.yOffset,0),this._yOffset=this.yOffset}function update$2(e){var t=e._offCenterFrustum;e.fov===e._fov&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far&&e.xOffset===e._xOffset&&e.yOffset===e._yOffset||(e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset)}PerspectiveOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight),d=getPlanesNearCenter;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);l=getPlanesFarCenter;Cartesian3.multiplyByScalar(t,c,l),Cartesian3.add(e,l,l);c=getPlanesNormal;Cartesian3.multiplyByScalar(u,s,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.normalize(c,c),Cartesian3.cross(c,i,c),Cartesian3.normalize(c,c);s=r[0];return(s=!defined(s)?r[0]=new Cartesian4:s).x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(u,o,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(i,c,c),Cartesian3.normalize(c,c),(s=!defined(s=r[1])?r[1]=new Cartesian4:s).x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(i,a,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(u,c,c),Cartesian3.normalize(c,c),(s=!defined(s=r[2])?r[2]=new Cartesian4:s).x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(i,n,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(c,u,c),Cartesian3.normalize(c,c),(s=!defined(s=r[3])?r[3]=new Cartesian4:s).x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),(s=!defined(s=r[4])?r[4]=new Cartesian4:s).x=t.x,s.y=t.y,s.z=t.z,s.w=-Cartesian3.dot(t,d),Cartesian3.negate(t,c),(s=!defined(s=r[5])?r[5]=new Cartesian4:s).x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,l),this._cullingVolume},PerspectiveOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$3(this);var a=1/this.near,t=2*r*i*(o=this.top*a)/t,o=this.right*a;return n.x=2*r*i*o/e,n.y=t,n},PerspectiveOffCenterFrustum.prototype.clone=function(e){return(e=!defined(e)?new PerspectiveOffCenterFrustum:e).right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},PerspectiveOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof PerspectiveOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},PerspectiveOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof PerspectiveOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},PerspectiveFrustum.packedLength=6,PerspectiveFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.fov,t[i++]=e.aspectRatio,t[i++]=e.near,t[i++]=e.far,t[i++]=e.xOffset,t[i]=e.yOffset,t},PerspectiveFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new PerspectiveFrustum:i).fov=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t++],i.xOffset=e[t++],i.yOffset=e[t],i},Object.defineProperties(PerspectiveFrustum.prototype,{projectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return update$2(this),this._fovy}},sseDenominator:{get:function(){return update$2(this),this._sseDenominator}}}),PerspectiveFrustum.prototype.computeCullingVolume=function(e,t,i){return update$2(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},PerspectiveFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$2(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},PerspectiveFrustum.prototype.clone=function(e){return(e=!defined(e)?new PerspectiveFrustum:e).aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},PerspectiveFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},PerspectiveFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),CesiumMath.equalsEpsilon(this.fov,e.fov,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))};var PERSPECTIVE$1=0,ORTHOGRAPHIC$1=1;function FrustumGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),e=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE$1,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC$1,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=e,this._vertexFormat=o,this._workerName="createFrustumGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength+VertexFormat.packedLength}FrustumGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE$1?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),i+=Quaternion.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective$1=new PerspectiveFrustum,scratchPackOrthographic$1=new OrthographicFrustum,scratchPackQuaternion$1=new Quaternion,scratchPackorigin$1=new Cartesian3,scratchVertexFormat$6=new VertexFormat;function getAttributes(e,t,i,r,n,a,o,s){for(var l=e/3*2,c=0;c<4;++c)defined(t)&&(t[e]=a.x,t[e+1]=a.y,t[e+2]=a.z),defined(i)&&(i[e]=o.x,i[e+1]=o.y,i[e+2]=o.z),defined(r)&&(r[e]=s.x,r[e+1]=s.y,r[e+2]=s.z),e+=3;n[l]=0,n[1+l]=0,n[2+l]=1,n[3+l]=0,n[4+l]=1,n[5+l]=1,n[6+l]=0,n[7+l]=1}FrustumGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE$1?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective$1),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic$1),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin$1);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion$1);t+=Quaternion.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$6),e=1===e[t+=VertexFormat.packedLength];if(!defined(i))return new FrustumGeometry({frustum:r,origin:a,orientation:o,vertexFormat:s,_drawNearPlane:e});t=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(t),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._drawNearPlane=e,i};var scratchRotationMatrix=new Matrix3,scratchViewMatrix=new Matrix4,scratchInverseMatrix=new Matrix4,scratchXDirection=new Cartesian3,scratchYDirection=new Cartesian3,scratchZDirection=new Cartesian3,scratchNegativeX=new Cartesian3,scratchNegativeY=new Cartesian3,scratchNegativeZ=new Cartesian3,frustumSplits=new Array(3),frustumCornersNDC$1=new Array(4);frustumCornersNDC$1[0]=new Cartesian4(-1,-1,1,1),frustumCornersNDC$1[1]=new Cartesian4(1,-1,1,1),frustumCornersNDC$1[2]=new Cartesian4(1,1,1,1),frustumCornersNDC$1[3]=new Cartesian4(-1,1,1,1);for(var scratchFrustumCorners$1=new Array(4),i$5=0;i$5<4;++i$5)scratchFrustumCorners$1[i$5]=new Cartesian4;FrustumGeometry._computeNearFarPlanes=function(e,t,i,r,n,a,o,s){var t=Matrix3.fromQuaternion(t,scratchRotationMatrix),a=defaultValue(a,scratchXDirection),o=defaultValue(o,scratchYDirection),l=defaultValue(s,scratchZDirection),a=Matrix3.getColumn(t,0,a),o=Matrix3.getColumn(t,1,o),l=Matrix3.getColumn(t,2,l);Cartesian3.normalize(a,a),Cartesian3.normalize(o,o),Cartesian3.normalize(l,l),Cartesian3.negate(a,a);var c,u,a=Matrix4.computeView(e,l,o,a,scratchViewMatrix);i===PERSPECTIVE$1?(i=r.projectionMatrix,i=Matrix4.multiply(i,a,scratchInverseMatrix),u=Matrix4.inverse(i,scratchInverseMatrix)):c=Matrix4.inverseTransformation(a,scratchInverseMatrix),defined(u)?(frustumSplits[0]=r.near,frustumSplits[1]=r.far):(frustumSplits[0]=0,frustumSplits[1]=r.near,frustumSplits[2]=r.far);for(var d=0;d<2;++d)for(var h=0;h<4;++h){var p,f,m=Cartesian4.clone(frustumCornersNDC$1[h],scratchFrustumCorners$1[h]);defined(u)?(p=1/(m=Matrix4.multiplyByVector(u,m,m)).w,Cartesian3.multiplyByScalar(m,p,m),Cartesian3.subtract(m,e,m),Cartesian3.normalize(m,m),f=Cartesian3.dot(l,m),Cartesian3.multiplyByScalar(m,frustumSplits[d]/f,m),Cartesian3.add(m,e,m)):(defined(r._offCenterFrustum)&&(r=r._offCenterFrustum),p=frustumSplits[d],f=frustumSplits[d+1],m.x=.5*(m.x*(r.right-r.left)+r.left+r.right),m.y=.5*(m.y*(r.top-r.bottom)+r.bottom+r.top),m.z=.5*(m.z*(p-f)-p-f),m.w=1,Matrix4.multiplyByVector(c,m,m)),n[12*d+3*h]=m.x,n[12*d+3*h+1]=m.y,n[12*d+3*h+2]=m.z}},FrustumGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=e._vertexFormat,s=a?6:5,l=new Float64Array(72);FrustumGeometry._computeNearFarPlanes(r,n,t,i,l);var c=24;l[c]=l[12],l[c+1]=l[13],l[c+2]=l[14],l[c+3]=l[0],l[c+4]=l[1],l[c+5]=l[2],l[c+6]=l[9],l[c+7]=l[10],l[c+8]=l[11],l[c+9]=l[21],l[c+10]=l[22],l[c+11]=l[23],l[c+=12]=l[15],l[c+1]=l[16],l[c+2]=l[17],l[c+3]=l[3],l[c+4]=l[4],l[c+5]=l[5],l[c+6]=l[0],l[c+7]=l[1],l[c+8]=l[2],l[c+9]=l[12],l[c+10]=l[13],l[c+11]=l[14],l[c+=12]=l[3],l[c+1]=l[4],l[c+2]=l[5],l[c+3]=l[15],l[c+4]=l[16],l[c+5]=l[17],l[c+6]=l[18],l[c+7]=l[19],l[c+8]=l[20],l[c+9]=l[6],l[c+10]=l[7],l[c+11]=l[8],l[c+=12]=l[6],l[c+1]=l[7],l[c+2]=l[8],l[c+3]=l[18],l[c+4]=l[19],l[c+5]=l[20],l[c+6]=l[21],l[c+7]=l[22],l[c+8]=l[23],l[c+9]=l[9],l[c+10]=l[10],l[c+11]=l[11],a||(l=l.subarray(12));var u,d,h,p,f=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})});(defined(o.normal)||defined(o.tangent)||defined(o.bitangent)||defined(o.st))&&(u=defined(o.normal)?new Float32Array(12*s):void 0,d=defined(o.tangent)?new Float32Array(12*s):void 0,h=defined(o.bitangent)?new Float32Array(12*s):void 0,p=defined(o.st)?new Float32Array(8*s):void 0,e=scratchYDirection,r=scratchZDirection,t=Cartesian3.negate(n=scratchXDirection,scratchNegativeX),i=Cartesian3.negate(e,scratchNegativeY),o=Cartesian3.negate(r,scratchNegativeZ),c=0,a&&(getAttributes(c,u,d,h,p,o,n,e),c+=12),getAttributes(c,u,d,h,p,r,t,e),getAttributes(c+=12,u,d,h,p,t,o,e),getAttributes(c+=12,u,d,h,p,i,o,t),getAttributes(c+=12,u,d,h,p,n,r,e),getAttributes(c+=12,u,d,h,p,e,r,t),defined(u)&&(f.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:u})),defined(d)&&(f.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),defined(h)&&(f.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),defined(p)&&(f.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:p})));for(var m=new Uint16Array(6*s),g=0;g<s;++g){var _=6*g,y=4*g;m[_]=y,m[1+_]=1+y,m[2+_]=2+y,m[3+_]=y,m[4+_]=2+y,m[5+_]=3+y}return new Geometry({attributes:f,indices:m,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromVertices(l)})};var PERSPECTIVE=0,ORTHOGRAPHIC=1;function FrustumOutlineGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,e=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=e,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength}FrustumOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),t[i+=Quaternion.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective=new PerspectiveFrustum,scratchPackOrthographic=new OrthographicFrustum,scratchPackQuaternion=new Quaternion,scratchPackorigin=new Cartesian3;FrustumOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion),e=1===e[t+=Quaternion.packedLength];if(!defined(i))return new FrustumOutlineGeometry({frustum:r,origin:a,orientation:o,_drawNearPlane:e});t=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(t),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._drawNearPlane=e,i},FrustumOutlineGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,e=new Float64Array(24);FrustumGeometry._computeNearFarPlanes(r,n,t,i,e);for(var o,s,i=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e})}),l=a?2:1,c=new Uint16Array(8*(1+l)),u=a?0:1;u<2;++u)c[o=a?8*u:0]=s=4*u,c[o+1]=s+1,c[o+2]=s+1,c[o+3]=s+2,c[o+4]=s+2,c[o+5]=s+3,c[o+6]=s+3,c[o+7]=s;for(u=0;u<2;++u)c[o=8*(l+u)]=s=4*u,c[o+1]=s+4,c[o+2]=s+1,c[o+3]=s+5,c[o+4]=s+2,c[o+5]=s+6,c[o+6]=s+3,c[o+7]=s+7;return new Geometry({attributes:i,indices:c,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromVertices(e)})};var GeocodeType={SEARCH:0,AUTOCOMPLETE:1},GeocodeType$1=Object.freeze(GeocodeType);function GeocoderService(){}function GeometryFactory(){DeveloperError.throwInstantiationError()}function GeometryInstanceAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.value=e.value}GeocoderService.prototype.geocode=DeveloperError.throwInstantiationError,GeometryFactory.createGeometry=function(e){DeveloperError.throwInstantiationError()};var protobuf=createCommonjsModule(function(module){!function(global,undefined$1){var QM0,RM0,SM0,UM0;QM0={1:[function(e,t,i){t.exports=function(e,t){for(var i=[],r=2;r<arguments.length;)i.push(arguments[r++]);var a=!0;return new Promise(function(r,n){i.push(function(e){if(a)if(a=!1,e)n(e);else{for(var t=[],i=1;i<arguments.length;)t.push(arguments[i++]);r.apply(null,t)}});try{e.apply(t||this,i)}catch(e){a&&(a=!1,n(e))}})}},{}],2:[function(e,t,i){i.length=function(e){var t=e.length;if(!t)return 0;for(var i=0;1<--t%4&&"="===e.charAt(t);)++i;return Math.ceil(3*e.length)/4-i};for(var l=new Array(64),c=new Array(123),r=0;r<64;)c[l[r]=r<26?r+65:r<52?r+71:r<62?r-4:r-59|43]=r++;i.encode=function(e,t,i){for(var r,n=[],a=0,o=0;t<i;){var s=e[t++];switch(o){case 0:n[a++]=l[s>>2],r=(3&s)<<4,o=1;break;case 1:n[a++]=l[r|s>>4],r=(15&s)<<2,o=2;break;case 2:n[a++]=l[r|s>>6],n[a++]=l[63&s],o=0}}return o&&(n[a++]=l[r],n[a]=61,1===o&&(n[a+1]=61)),String.fromCharCode.apply(String,n)};var u="invalid encoding";i.decode=function(e,t,i){for(var r,n=i,a=0,o=0;o<e.length;){var s=e.charCodeAt(o++);if(61===s&&1<a)break;if((s=c[s])===undefined$1)throw Error(u);switch(a){case 0:r=s,a=1;break;case 1:t[i++]=r<<2|(48&s)>>4,r=s,a=2;break;case 2:t[i++]=(15&r)<<4|(60&s)>>2,r=s,a=3;break;case 3:t[i++]=(3&r)<<6|s,a=0}}if(1===a)throw Error(u);return i-n},i.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,i){function r(){this._listeners={}}(t.exports=r).prototype.on=function(e,t,i){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:i||this}),this},r.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var i=this._listeners[e],r=0;r<i.length;)i[r].fn===t?i.splice(r,1):++r;return this},r.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var i=[],r=1;r<arguments.length;)i.push(arguments[r++]);for(r=0;r<t.length;)t[r].fn.apply(t[r++].ctx,i)}return this}},{}],4:[function(e,t,i){function r(e){function t(e,t,i,r){var n=t<0?1:0;0===(t=n?-t:t)?e(0<1/t?0:2147483648,i,r):isNaN(t)?e(2143289344,i,r):e(34028234663852886e22<t?(n<<31|2139095040)>>>0:t<11754943508222875e-54?(n<<31|Math.round(t/1401298464324817e-60))>>>0:(n<<31|(n=Math.floor(Math.log(t)/Math.LN2))+127<<23|8388607&Math.round(t*Math.pow(2,-n)*8388608))>>>0,i,r)}function i(e,t,i){e=e(t,i),t=2*(e>>31)+1,i=e>>>23&255,e&=8388607;return 255==i?e?NaN:1/0*t:0==i?1401298464324817e-60*t*e:t*Math.pow(2,i-150)*(8388608+e)}function r(e,t,i){s[0]=e,t[i]=l[0],t[i+1]=l[1],t[i+2]=l[2],t[i+3]=l[3]}function n(e,t,i){s[0]=e,t[i]=l[3],t[i+1]=l[2],t[i+2]=l[1],t[i+3]=l[0]}function a(e,t){return l[0]=e[t],l[1]=e[t+1],l[2]=e[t+2],l[3]=e[t+3],s[0]}function o(e,t){return l[3]=e[t],l[2]=e[t+1],l[1]=e[t+2],l[0]=e[t+3],s[0]}var s,l,c,u,d;function h(e,t,i,r,n,a){var o,s,l=r<0?1:0;0===(r=l?-r:r)?(e(0,n,a+t),e(0<1/r?0:2147483648,n,a+i)):isNaN(r)?(e(0,n,a+t),e(2146959360,n,a+i)):17976931348623157e292<r?(e(0,n,a+t),e((l<<31|2146435072)>>>0,n,a+i)):r<22250738585072014e-324?(e((o=r/5e-324)>>>0,n,a+t),e((l<<31|o/4294967296)>>>0,n,a+i)):(1024===(s=Math.floor(Math.log(r)/Math.LN2))&&(s=1023),e(4503599627370496*(o=r*Math.pow(2,-s))>>>0,n,a+t),e((l<<31|s+1023<<20|1048576*o&1048575)>>>0,n,a+i))}function p(e,t,i,r,n){t=e(r,n+t),r=e(r,n+i),n=2*(r>>31)+1,i=r>>>20&2047,t=4294967296*(1048575&r)+t;return 2047==i?t?NaN:1/0*n:0==i?5e-324*n*t:n*Math.pow(2,i-1075)*(t+4503599627370496)}function f(e,t,i){c[0]=e,t[i]=u[0],t[i+1]=u[1],t[i+2]=u[2],t[i+3]=u[3],t[i+4]=u[4],t[i+5]=u[5],t[i+6]=u[6],t[i+7]=u[7]}function m(e,t,i){c[0]=e,t[i]=u[7],t[i+1]=u[6],t[i+2]=u[5],t[i+3]=u[4],t[i+4]=u[3],t[i+5]=u[2],t[i+6]=u[1],t[i+7]=u[0]}function g(e,t){return u[0]=e[t],u[1]=e[t+1],u[2]=e[t+2],u[3]=e[t+3],u[4]=e[t+4],u[5]=e[t+5],u[6]=e[t+6],u[7]=e[t+7],c[0]}function _(e,t){return u[7]=e[t],u[6]=e[t+1],u[5]=e[t+2],u[4]=e[t+3],u[3]=e[t+4],u[2]=e[t+5],u[1]=e[t+6],u[0]=e[t+7],c[0]}return"undefined"!=typeof Float32Array?(s=new Float32Array([-0]),l=new Uint8Array(s.buffer),d=128===l[3],e.writeFloatLE=d?r:n,e.writeFloatBE=d?n:r,e.readFloatLE=d?a:o,e.readFloatBE=d?o:a):(e.writeFloatLE=t.bind(null,y),e.writeFloatBE=t.bind(null,C),e.readFloatLE=i.bind(null,v),e.readFloatBE=i.bind(null,T)),"undefined"!=typeof Float64Array?(c=new Float64Array([-0]),u=new Uint8Array(c.buffer),d=128===u[7],e.writeDoubleLE=d?f:m,e.writeDoubleBE=d?m:f,e.readDoubleLE=d?g:_,e.readDoubleBE=d?_:g):(e.writeDoubleLE=h.bind(null,y,0,4),e.writeDoubleBE=h.bind(null,C,4,0),e.readDoubleLE=p.bind(null,v,0,4),e.readDoubleBE=p.bind(null,T,4,0)),e}function y(e,t,i){t[i]=255&e,t[i+1]=e>>>8&255,t[i+2]=e>>>16&255,t[i+3]=e>>>24}function C(e,t,i){t[i]=e>>>24,t[i+1]=e>>>16&255,t[i+2]=e>>>8&255,t[i+3]=255&e}function v(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24)>>>0}function T(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0}t.exports=r(r)},{}],5:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],6:[function(e,t,i){t.exports=function(t,i,e){var r=e||8192,n=r>>>1,a=null,o=r;return function(e){if(e<1||n<e)return t(e);r<o+e&&(a=t(r),o=0);e=i.call(a,o,o+=e);return 7&o&&(o=1+(7|o)),e}}},{}],7:[function(e,t,i){i.length=function(e){for(var t,i=0,r=0;r<e.length;++r)(t=e.charCodeAt(r))<128?i+=1:t<2048?i+=2:55296==(64512&t)&&56320==(64512&e.charCodeAt(r+1))?(++r,i+=4):i+=3;return i},i.read=function(e,t,i){if(i-t<1)return"";for(var r,n=null,a=[],o=0;t<i;)(r=e[t++])<128?a[o++]=r:191<r&&r<224?a[o++]=(31&r)<<6|63&e[t++]:239<r&&r<365?(r=((7&r)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,a[o++]=55296+(r>>10),a[o++]=56320+(1023&r)):a[o++]=(15&r)<<12|(63&e[t++])<<6|63&e[t++],8191<o&&((n=n||[]).push(String.fromCharCode.apply(String,a)),o=0);return n?(o&&n.push(String.fromCharCode.apply(String,a.slice(0,o))),n.join("")):String.fromCharCode.apply(String,a.slice(0,o))},i.write=function(e,t,i){for(var r,n,a=i,o=0;o<e.length;++o)(r=e.charCodeAt(o))<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(55296==(64512&r)&&56320==(64512&(n=e.charCodeAt(o+1)))?(++o,t[i++]=(r=65536+((1023&r)<<10)+(1023&n))>>18|240,t[i++]=r>>12&63|128):t[i++]=r>>12|224,t[i++]=r>>6&63|128),t[i++]=63&r|128);return i-a}},{}],8:[function(e,t,i){var r=i;function n(){r.Reader._configure(r.BufferReader),r.util._configure()}r.build="minimal",r.roots={},r.Writer=e(15),r.BufferWriter=e(16),r.Reader=e(9),r.BufferReader=e(10),r.util=e(14),r.rpc=e(11),r.configure=n,r.Writer._configure(r.BufferWriter),n()},{10:10,11:11,14:14,15:15,16:16,9:9}],9:[function(e,t,i){t.exports=l;var r,n=e(14),a=n.LongBits,o=n.utf8;function s(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function l(e){this.buf=e,this.pos=0,this.len=e.length}var c,u="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new l(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new l(e);throw Error("illegal buffer")};function d(){var e=new a(0,0),t=0;if(!(4<this.len-this.pos)){for(;t<3;++t){if(this.pos>=this.len)throw s(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,4<this.len-this.pos){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw s(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function h(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function p(){if(this.pos+8>this.len)throw s(this,8);return new a(h(this.buf,this.pos+=4),h(this.buf,this.pos+=4))}l.create=n.Buffer?function(e){return(l.create=function(e){return n.Buffer.isBuffer(e)?new r(e):u(e)})(e)}:u,l.prototype._slice=n.Array.prototype.subarray||n.Array.prototype.slice,l.prototype.uint32=(c=4294967295,function(){if(c=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return c;if((this.pos+=5)>this.len)throw this.pos=this.len,s(this,10);return c}),l.prototype.int32=function(){return 0|this.uint32()},l.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},l.prototype.bool=function(){return 0!==this.uint32()},l.prototype.fixed32=function(){if(this.pos+4>this.len)throw s(this,4);return h(this.buf,this.pos+=4)},l.prototype.sfixed32=function(){if(this.pos+4>this.len)throw s(this,4);return 0|h(this.buf,this.pos+=4)},l.prototype.float=function(){if(this.pos+4>this.len)throw s(this,4);var e=n.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e},l.prototype.double=function(){if(this.pos+8>this.len)throw s(this,4);var e=n.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e},l.prototype.bytes=function(){var e=this.uint32(),t=this.pos,i=this.pos+e;if(i>this.len)throw s(this,e);return this.pos+=e,t===i?new this.buf.constructor(0):this._slice.call(this.buf,t,i)},l.prototype.string=function(){var e=this.bytes();return o.read(e,0,e.length)},l.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw s(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw s(this)}while(128&this.buf[this.pos++]);return this},l.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;;){if(4==(e=7&this.uint32()))break;this.skipType(e)}break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},l._configure=function(e){r=e;var t=n.Long?"toLong":"toNumber";n.merge(l.prototype,{int64:function(){return d.call(this)[t](!1)},uint64:function(){return d.call(this)[t](!0)},sint64:function(){return d.call(this).zzDecode()[t](!1)},fixed64:function(){return p.call(this)[t](!0)},sfixed64:function(){return p.call(this)[t](!1)}})}},{14:14}],10:[function(e,t,i){t.exports=n;var r=e(9);(n.prototype=Object.create(r.prototype)).constructor=n;e=e(14);function n(e){r.call(this,e)}e.Buffer&&(n.prototype._slice=e.Buffer.prototype.slice),n.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len))}},{14:14,9:9}],11:[function(e,t,i){i.Service=e(12)},{12:12}],12:[function(e,t,i){t.exports=r;var s=e(14);function r(e,t,i){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");s.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(i)}((r.prototype=Object.create(s.EventEmitter.prototype)).constructor=r).prototype.rpcCall=function e(i,t,r,n,a){if(!n)throw TypeError("request must be specified");var o=this;if(!a)return s.asPromise(e,o,i,t,r,n);if(!o.rpcImpl)return setTimeout(function(){a(Error("already ended"))},0),undefined$1;try{return o.rpcImpl(i,t[o.requestDelimited?"encodeDelimited":"encode"](n).finish(),function(e,t){if(e)return o.emit("error",e,i),a(e);if(null===t)return o.end(!0),undefined$1;if(!(t instanceof r))try{t=r[o.responseDelimited?"decodeDelimited":"decode"](t)}catch(e){return o.emit("error",e,i),a(e)}return o.emit("data",t,i),a(null,t)})}catch(e){return o.emit("error",e,i),setTimeout(function(){a(e)},0),undefined$1}},r.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{14:14}],13:[function(e,t,i){t.exports=n;var r=e(14);function n(e,t){this.lo=e>>>0,this.hi=t>>>0}var a=n.zero=new n(0,0);a.toNumber=function(){return 0},a.zzEncode=a.zzDecode=function(){return this},a.length=function(){return 1};n.zeroHash="\0\0\0\0\0\0\0\0";n.fromNumber=function(e){if(0===e)return a;var t=e<0,i=(e=t?-e:e)>>>0,e=(e-i)/4294967296>>>0;return t&&(e=~e>>>0,i=~i>>>0,4294967295<++i&&(i=0,4294967295<++e&&(e=0))),new n(i,e)},n.from=function(e){if("number"==typeof e)return n.fromNumber(e);if(r.isString(e)){if(!r.Long)return n.fromNumber(parseInt(e,10));e=r.Long.fromString(e)}return e.low||e.high?new n(e.low>>>0,e.high>>>0):a},n.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,e=~this.hi>>>0;return-(t+4294967296*(e=!t?e+1>>>0:e))}return this.lo+4294967296*this.hi},n.prototype.toLong=function(e){return r.Long?new r.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var o=String.prototype.charCodeAt;n.fromHash=function(e){return"\0\0\0\0\0\0\0\0"===e?a:new n((o.call(e,0)|o.call(e,1)<<8|o.call(e,2)<<16|o.call(e,3)<<24)>>>0,(o.call(e,4)|o.call(e,5)<<8|o.call(e,6)<<16|o.call(e,7)<<24)>>>0)},n.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},n.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},n.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},n.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,i=this.hi>>>24;return 0==i?0==t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:i<128?9:10}},{14:14}],14:[function(e,t,i){var r=i;function n(e,t,i){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]!==undefined$1&&i||(e[r[n]]=t[r[n]]);return e}function a(e){function i(e,t){if(!(this instanceof i))return new i(e,t);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,i):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),t&&n(this,t)}return(i.prototype=Object.create(Error.prototype)).constructor=i,Object.defineProperty(i.prototype,"name",{get:function(){return e}}),i.prototype.toString=function(){return this.name+": "+this.message},i}r.asPromise=e(1),r.base64=e(2),r.EventEmitter=e(3),r.float=e(4),r.inquire=e(5),r.utf8=e(7),r.pool=e(6),r.LongBits=e(13),r.emptyArray=Object.freeze?Object.freeze([]):[],r.emptyObject=Object.freeze?Object.freeze({}):{},r.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node),r.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},r.isString=function(e){return"string"==typeof e||e instanceof String},r.isObject=function(e){return e&&"object"==typeof e},r.isset=r.isSet=function(e,t){var i=e[t];return!(null==i||!e.hasOwnProperty(t))&&("object"!=typeof i||0<(Array.isArray(i)?i:Object.keys(i)).length)},r.Buffer=function(){try{var e=r.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),r._Buffer_from=null,r._Buffer_allocUnsafe=null,r.newBuffer=function(e){return"number"==typeof e?r.Buffer?r._Buffer_allocUnsafe(e):new r.Array(e):r.Buffer?r._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},r.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,r.Long=global.dcodeIO&&global.dcodeIO.Long||r.inquire("long"),r.key2Re=/^true|false|0|1$/,r.key32Re=/^-?(?:0|[1-9][0-9]*)$/,r.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,r.longToHash=function(e){return e?r.LongBits.from(e).toHash():r.LongBits.zeroHash},r.longFromHash=function(e,t){e=r.LongBits.fromHash(e);return r.Long?r.Long.fromBits(e.lo,e.hi,t):e.toNumber(Boolean(t))},r.merge=n,r.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},r.newError=a,r.ProtocolError=a("ProtocolError"),r.oneOfGetter=function(e){for(var i={},t=0;t<e.length;++t)i[e[t]]=1;return function(){for(var e=Object.keys(this),t=e.length-1;-1<t;--t)if(1===i[e[t]]&&this[e[t]]!==undefined$1&&null!==this[e[t]])return e[t]}},r.oneOfSetter=function(i){return function(e){for(var t=0;t<i.length;++t)i[t]!==e&&delete this[i[t]]}},r.lazyResolve=function(e,t){for(var i=0;i<t.length;++i)for(var r=Object.keys(t[i]),n=0;n<r.length;++n){for(var a=t[i][r[n]].split("."),o=e;a.length;)o=o[a.shift()];t[i][r[n]]=o}},r.toJSONOptions={longs:String,enums:String,bytes:String},r._configure=function(){var i=r.Buffer;i?(r._Buffer_from=i.from!==Uint8Array.from&&i.from||function(e,t){return new i(e,t)},r._Buffer_allocUnsafe=i.allocUnsafe||function(e){return new i(e)}):r._Buffer_from=r._Buffer_allocUnsafe=null}},{1:1,13:13,2:2,3:3,4:4,5:5,6:6,7:7}],15:[function(e,t,i){t.exports=d;var r,n=e(14),a=n.LongBits,o=n.base64,s=n.utf8;function l(e,t,i){this.fn=e,this.len=t,this.next=undefined$1,this.val=i}function c(){}function u(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function d(){this.len=0,this.head=new l(c,0,0),this.tail=this.head,this.states=null}function h(e,t,i){t[i]=255&e}function p(e,t){this.len=e,this.next=undefined$1,this.val=t}function f(e,t,i){for(;e.hi;)t[i++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;127<e.lo;)t[i++]=127&e.lo|128,e.lo=e.lo>>>7;t[i++]=e.lo}function m(e,t,i){t[i]=255&e,t[i+1]=e>>>8&255,t[i+2]=e>>>16&255,t[i+3]=e>>>24}d.create=n.Buffer?function(){return(d.create=function(){return new r})()}:function(){return new d},d.alloc=function(e){return new n.Array(e)},n.Array!==Array&&(d.alloc=n.pool(d.alloc,n.Array.prototype.subarray)),d.prototype.push=function(e,t,i){return this.tail=this.tail.next=new l(e,t,i),this.len+=t,this},(p.prototype=Object.create(l.prototype)).fn=function(e,t,i){for(;127<e;)t[i++]=127&e|128,e>>>=7;t[i]=e},d.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new p((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},d.prototype.int32=function(e){return e<0?this.push(f,10,a.fromNumber(e)):this.uint32(e)},d.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},d.prototype.int64=d.prototype.uint64=function(e){e=a.from(e);return this.push(f,e.length(),e)},d.prototype.sint64=function(e){e=a.from(e).zzEncode();return this.push(f,e.length(),e)},d.prototype.bool=function(e){return this.push(h,1,e?1:0)},d.prototype.sfixed32=d.prototype.fixed32=function(e){return this.push(m,4,e>>>0)},d.prototype.sfixed64=d.prototype.fixed64=function(e){e=a.from(e);return this.push(m,4,e.lo).push(m,4,e.hi)},d.prototype.float=function(e){return this.push(n.float.writeFloatLE,4,e)},d.prototype.double=function(e){return this.push(n.float.writeDoubleLE,8,e)};var g=n.Array.prototype.set?function(e,t,i){t.set(e,i)}:function(e,t,i){for(var r=0;r<e.length;++r)t[i+r]=e[r]};d.prototype.bytes=function(e){var t,i=e.length>>>0;return i?(n.isString(e)&&(t=d.alloc(i=o.length(e)),o.decode(e,t,0),e=t),this.uint32(i).push(g,i,e)):this.push(h,1,0)},d.prototype.string=function(e){var t=s.length(e);return t?this.uint32(t).push(s.write,t,e):this.push(h,1,0)},d.prototype.fork=function(){return this.states=new u(this),this.head=this.tail=new l(c,0,0),this.len=0,this},d.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new l(c,0,0),this.len=0),this},d.prototype.ldelim=function(){var e=this.head,t=this.tail,i=this.len;return this.reset().uint32(i),i&&(this.tail.next=e.next,this.tail=t,this.len+=i),this},d.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),i=0;e;)e.fn(e.val,t,i),i+=e.len,e=e.next;return t},d._configure=function(e){r=e}},{14:14}],16:[function(e,t,i){t.exports=o;var r=e(15);(o.prototype=Object.create(r.prototype)).constructor=o;var n=e(14),a=n.Buffer;function o(){r.call(this)}o.alloc=function(e){return(o.alloc=n._Buffer_allocUnsafe)(e)};var s=a&&a.prototype instanceof Uint8Array&&"set"===a.prototype.set.name?function(e,t,i){t.set(e,i)}:function(e,t,i){if(e.copy)e.copy(t,i,0,e.length);else for(var r=0;r<e.length;)t[i++]=e[r++]};function l(e,t,i){e.length<40?n.utf8.write(e,t,i):t.utf8Write(e,i)}o.prototype.bytes=function(e){var t=(e=n.isString(e)?n._Buffer_from(e,"base64"):e).length>>>0;return this.uint32(t),t&&this.push(s,t,e),this},o.prototype.string=function(e){var t=a.byteLength(e);return this.uint32(t),t&&this.push(l,t,e),this}},{14:14,15:15}]},RM0={},SM0=[8],UM0=global.protobuf=function e(t){var i=RM0[t];return i||QM0[t][0].call(i=RM0[t]={exports:{}},e,i,i.exports),i.exports}(SM0[0]),"function"==typeof undefined$1&&undefined$1.amd&&undefined$1(["long"],function(e){return e&&e.isLong&&(UM0.util.Long=e,UM0.configure()),UM0}),module&&module.exports&&(module.exports=UM0)}("object"==typeof window&&window||"object"==typeof self&&self||commonjsGlobal)}),protobuf$1=Object.freeze(Object.assign(Object.create(null),protobuf,{default:protobuf}));function isBitSet(e,t){return 0!=(e&t)}var childrenBitmasks=[1,2,4,8],anyChildBitmask=15,cacheFlagBitmask=16,imageBitmask=64,terrainBitmask=128;function GoogleEarthEnterpriseTileInformation(e,t,i,r,n,a){this._bits=e,this.cnodeVersion=t,this.imageryVersion=i,this.terrainVersion=r,this.imageryProvider=n,this.terrainProvider=a,this.ancestorHasTerrain=!1,this.terrainState=void 0}function stringToBuffer(e){for(var t=e.length,i=new ArrayBuffer(t),r=new Uint8Array(i),n=0;n<t;++n)r[n]=e.charCodeAt(n);return i}GoogleEarthEnterpriseTileInformation.clone=function(e,t){return defined(t)?(t._bits=e._bits,t.cnodeVersion=e.cnodeVersion,t.imageryVersion=e.imageryVersion,t.terrainVersion=e.terrainVersion,t.imageryProvider=e.imageryProvider,t.terrainProvider=e.terrainProvider):t=new GoogleEarthEnterpriseTileInformation(e._bits,e.cnodeVersion,e.imageryVersion,e.terrainVersion,e.imageryProvider,e.terrainProvider),t.ancestorHasTerrain=e.ancestorHasTerrain,t.terrainState=e.terrainState,t},GoogleEarthEnterpriseTileInformation.prototype.setParent=function(e){this.ancestorHasTerrain=e.ancestorHasTerrain||this.hasTerrain()},GoogleEarthEnterpriseTileInformation.prototype.hasSubtree=function(){return isBitSet(this._bits,cacheFlagBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasImagery=function(){return isBitSet(this._bits,imageBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasTerrain=function(){return isBitSet(this._bits,terrainBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChildren=function(){return isBitSet(this._bits,anyChildBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChild=function(e){return isBitSet(this._bits,childrenBitmasks[e])},GoogleEarthEnterpriseTileInformation.prototype.getChildBitmask=function(){return this._bits&anyChildBitmask};var defaultKey=stringToBuffer('Eô½\vyâjE",ÍqøIFgQ\0B%Æèa,f)\bÆ4Üjb%y\nwmiÖðk¡½NuàA[ß@V\fÙ»r|3SîOlÔq°{ÀEVZ­wUe\v3*¬l5Å0sø3>mF8J´Ýð.ÝuÚDt"úa"\f3"So¯9D\v9Ù9L¹¿«\\P_"uxéqh;ÁÄð<VqH\'UfYNeu£aF}a?A\0×´4MÎF°Õ¸\'{Ü+»Mg0ÈÑö\\Pú[/Fn5/\'C.ë\n\f^¥se4ål.jC\'c#U©?q{gC}:¯ÍâTUýKÆâ/(íË\\Æ-f§;/*"N°k.Ý\r}}GºC²²+>Mª>}æÎIÆæx\fa1-¤O¥~q ì\r1èN\v\0nPh}=\b\r¦n£h$[kó#ó¶s³\r\v@ÀØQ]ú".jßI\0¹ wUÆïj¿{GLîÜÜF©­S+S4ÿYä8è1N¹XFkË-#p\x005"Ï1²&/çÃu-6,rt°#G·ÓÑ&7râ\0DÏÚ3-Þ`i#i*|ÍKQ\rT9w.)ê¦P¢joP\\>TûïP[\vEm(w7ÛJfJo åpâ¹q~\fmI-zþrÇòY0»]såÉ êxì ðB|G`°½&·q¶ÇÑ3=Ó«îcÈ+S D\\qÆÌD2O<ÊÀ)=RÓaX©}e´ÜÏ\rô=ñ\b©BÚ#\tØ¿^PIøMÀËGLO÷{+ØÅ1;µoÜl\rÑÛ?âéÚ_ÔâFaZÞUÏ¤\0¾ýÎgñJiæ HØ]~®q N®ÀV©<rçvì)IÖ]-ãÛ6©;fjÕ¶=P^R¹KÇsWxÉô.YoÐKW>\'\'Ç`Û;íSD>?mw¢\në?R¨ÆU^1I7ôÅ&-©¿\'TÚÃj å*x°Öprªh½÷_H±~ÀXL?fù>áeÀp§Ï8i¯ðVldI\'­xtOÂÞV9\0Úw\vË-û5Oõ\bQ`Á\nZGM&30xÚÀFGâ[y`In7gS\n>éìF9²ñ4\rÆSuná\fYÙÞ){II¥wy¾IV.6ç\v:»Ob{ÒM1/½8{¨O!áìFpv})"x\nÝ\\ÚÞQÏðüYRe|3ßóHÚ»*uÛ`²Ôüíì5¨ÿ(1-ÈÜF|["');function GoogleEarthEnterpriseMetadata(e){var t=e;"string"==typeof e||e instanceof Resource||(t=e.url);t=Resource.createIfNeeded(t);t.appendForwardSlash(),this._resource=t,this.imageryPresent=!0,this.protoImagery=void 0,this.terrainPresent=!0,this.negativeAltitudeExponentBias=32,this.negativeAltitudeThreshold=CesiumMath.EPSILON12,this.providers={},this.key=void 0,this._quadPacketVersion=1,this._tileInfo={},this._subtreePromises={};var i=this;this._readyPromise=requestDbRoot(this).then(function(){return i.getQuadTreePacket("",i._quadPacketVersion)}).then(function(){return!0}).otherwise(function(e){var t="An error occurred while accessing "+getMetadataResource(i,"",1).url+".";return when.reject(new RuntimeError(t))})}Object.defineProperties(GoogleEarthEnterpriseMetadata.prototype,{url:{get:function(){return this._resource.url}},proxy:{get:function(){return this._resource.proxy}},resource:{get:function(){return this._resource}},readyPromise:{get:function(){return this._readyPromise}}}),GoogleEarthEnterpriseMetadata.tileXYToQuadKey=function(e,t,i){for(var r="",n=i;0<=n;--n){var a=1<<n,o=0;isBitSet(t,a)?isBitSet(e,a)&&(o|=1):(o|=2,isBitSet(e,a)||(o|=1)),r+=o}return r},GoogleEarthEnterpriseMetadata.quadKeyToTileXY=function(e){for(var t=0,i=0,r=e.length-1,n=r;0<=n;--n){var a=1<<n,o=+e[r-n];isBitSet(o,2)?isBitSet(o,1)||(t|=a):(i|=a,isBitSet(o,1)&&(t|=a))}return{x:t,y:i,level:r}},GoogleEarthEnterpriseMetadata.prototype.isValid=function(e){var t=this.getTileInformationFromQuadKey(e);if(defined(t))return null!==t;for(var i,r=!0,n=e;1<n.length;){if(i=n.substring(n.length-1),n=n.substring(0,n.length-1),defined(t=this.getTileInformationFromQuadKey(n))){t.hasSubtree()||t.hasChild(parseInt(i))||(r=!1);break}if(null===t){r=!1;break}}return r};var taskProcessor$1=new TaskProcessor("decodeGoogleEarthEnterprisePacket"),dbrootParser,dbrootParserPromise;function populateSubtree(e,t,i){var r,n=e._tileInfo,a=t,o=n[a];if(defined(o)&&(!o.hasSubtree()||o.hasChildren()))return o;for(;void 0===o&&1<a.length;)o=n[a=a.substring(0,a.length-1)];var s=e._subtreePromises,l=s[a];return defined(l)?l.then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}):defined(o)&&o.hasSubtree()?defined(l=e.getQuadTreePacket(a,o.cnodeVersion,i))?(s[a]=l).then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}).always(function(){delete s[a]}):void 0:when.reject(new RuntimeError("Couldn't load metadata for tile "+t))}function getMetadataResource(e,t,i,r){return e._resource.getDerivedResource({url:"flatfile?q2-0"+t+"-q."+i.toString(),request:r})}function requestDbRoot(l){var e,t,i=l._resource.getDerivedResource({url:"dbRoot.v5",queryParameters:{output:"proto"}});return defined(dbrootParserPromise)||(e=buildModuleUrl("ThirdParty/google-earth-dbroot-parser.js"),t=window.cesiumGoogleEarthDbRootParser,dbrootParserPromise=loadAndExecuteScript(e).then(function(){dbrootParser=window.cesiumGoogleEarthDbRootParser(protobuf$1),defined(t)?window.cesiumGoogleEarthDbRootParser=t:delete window.cesiumGoogleEarthDbRootParser})),dbrootParserPromise.then(function(){return i.fetchArrayBuffer()}).then(function(e){var t=dbrootParser.EncryptedDbRootProto.decode(new Uint8Array(e)),i=t.encryptionData,r=i.byteOffset,n=r+i.byteLength,e=l.key=i.buffer.slice(r,n),n=(r=(i=t.dbrootData).byteOffset)+i.byteLength,n=i.buffer.slice(r,n);return taskProcessor$1.scheduleTask({buffer:n,type:"DbRoot",key:e},[n])}).then(function(e){var t=dbrootParser.DbRootProto.decode(new Uint8Array(e.buffer));l.imageryPresent=defaultValue(t.imageryPresent,l.imageryPresent),l.protoImagery=t.protoImagery,l.terrainPresent=defaultValue(t.terrainPresent,l.terrainPresent),defined(t.endSnippet)&&defined(t.endSnippet.model)&&(e=t.endSnippet.model,l.negativeAltitudeExponentBias=defaultValue(e.negativeAltitudeExponentBias,l.negativeAltitudeExponentBias),l.negativeAltitudeThreshold=defaultValue(e.compressedNegativeAltitudeThreshold,l.negativeAltitudeThreshold)),defined(t.databaseVersion)&&(l._quadPacketVersion=defaultValue(t.databaseVersion.quadtreeVersion,l._quadPacketVersion));for(var i=l.providers,r=defaultValue(t.providerInfo,[]),n=r.length,a=0;a<n;++a){var o=r[a],s=o.copyrightString;defined(s)&&(i[o.providerId]=new Credit(s.value))}}).otherwise(function(){console.log("Failed to retrieve "+i.url+". Using defaults."),l.key=defaultKey})}function GoogleEarthEnterpriseTerrainData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._buffer=e.buffer,this._credits=e.credits,this._negativeAltitudeExponentBias=e.negativeAltitudeExponentBias,this._negativeElevationThreshold=e.negativeElevationThreshold;var t=defaultValue(e.childTileMask,15),i=3&t;i|=4&t?8:0,this._childTileMask=i|=8&t?4:0,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._skirtHeight=void 0,this._bufferType=this._buffer.constructor,this._mesh=void 0,this._minimumHeight=void 0,this._maximumHeight=void 0}GoogleEarthEnterpriseMetadata.prototype.getQuadTreePacket=function(u,e,t){e=defaultValue(e,1);t=getMetadataResource(this,u=defaultValue(u,""),e,t).fetchArrayBuffer();if(defined(t)){var d=this._tileInfo,i=this.key;return t.then(function(e){return taskProcessor$1.scheduleTask({buffer:e,quadKey:u,type:"Metadata",key:i},[e]).then(function(e){var t,i,r=-1;""!==u&&(r=u.length+1,t=e[u],(i=d[u])._bits|=t._bits,delete e[u]);var n=Object.keys(e);n.sort(function(e,t){return e.length-t.length});for(var a=n.length,o=0;o<a;++o){var s,l,c=n[o];null!==e[c]?(s=GoogleEarthEnterpriseTileInformation.clone(e[c]),(l=c.length)===r?s.setParent(i):1<l&&(l=d[c.substring(0,c.length-1)],s.setParent(l)),d[c]=s):d[c]=null}})})}},GoogleEarthEnterpriseMetadata.prototype.populateSubtree=function(e,t,i,r){return populateSubtree(this,GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),r)},GoogleEarthEnterpriseMetadata.prototype.getTileInformation=function(e,t,i){i=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i);return this._tileInfo[i]},GoogleEarthEnterpriseMetadata.prototype.getTileInformationFromQuadKey=function(e){return this._tileInfo[e]},Object.defineProperties(GoogleEarthEnterpriseTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){}}});var createMeshTaskName="createVerticesFromGoogleEarthEnterpriseBuffer",createMeshTaskProcessorNoThrottle=new TaskProcessor(createMeshTaskName),createMeshTaskProcessorThrottle=new TaskProcessor(createMeshTaskName,TerrainData.maximumAsynchronousTasks),nativeRectangleScratch=new Rectangle,rectangleScratch$5=new Rectangle;GoogleEarthEnterpriseTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),e=t.ellipsoid;t.tileXYToNativeRectangle(i,r,n,nativeRectangleScratch),t.tileXYToRectangle(i,r,n,rectangleScratch$5);var l=e.cartographicToCartesian(Rectangle.center(rectangleScratch$5));this._skirtHeight=Math.min(8*(40075.16/(1<<n)),1e3);o=(s?createMeshTaskProcessorThrottle:createMeshTaskProcessorNoThrottle).scheduleTask({buffer:this._buffer,nativeRectangle:nativeRectangleScratch,rectangle:rectangleScratch$5,relativeToCenter:l,ellipsoid:e,skirtHeight:this._skirtHeight,exaggeration:a,exaggerationRelativeHeight:o,includeWebMercatorT:!0,negativeAltitudeExponentBias:this._negativeAltitudeExponentBias,negativeElevationThreshold:this._negativeElevationThreshold});if(defined(o)){var c=this;return o.then(function(e){return c._mesh=new TerrainMesh(l,new Float32Array(e.vertices),new Uint16Array(e.indices),e.indexCountWithoutSkirts,e.vertexCountWithoutSkirts,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),c._minimumHeight=e.minimumHeight,c._maximumHeight=e.maximumHeight,c._buffer=void 0,c._mesh})}},GoogleEarthEnterpriseTerrainData.prototype.interpolateHeight=function(e,t,i){t=CesiumMath.clamp((t-e.west)/e.width,0,1),i=CesiumMath.clamp((i-e.south)/e.height,0,1);return defined(this._mesh)?interpolateMeshHeight(this,t,i):interpolateHeight(this,t,i,e)};var upsampleTaskProcessor=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);GoogleEarthEnterpriseTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,t=2*i===a,i=e.ellipsoid,o=e.tileXYToRectangle(n,a,o),i=upsampleTaskProcessor.scheduleTask({vertices:s.vertices,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:t,childRectangle:o,ellipsoid:i});if(defined(i)){var c=this;return i.then(function(e){var t=new Uint16Array(e.vertices),i=IndexDatatype$1.createTypedArray(t.length/3,e.indices),r=c._skirtHeight;return new QuantizedMeshTerrainData({quantizedVertices:t,indices:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:r,southSkirtHeight:r,eastSkirtHeight:r,northSkirtHeight:r,childTileMask:0,createdByUpsampling:!0,credits:c._credits})})}}},GoogleEarthEnterpriseTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},GoogleEarthEnterpriseTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var texCoordScratch0=new Cartesian2,texCoordScratch1=new Cartesian2,texCoordScratch2=new Cartesian2,barycentricCoordinateScratch=new Cartesian3;function interpolateMeshHeight(e,t,i){for(var e=e._mesh,r=e.vertices,n=e.encoding,a=e.indices,o=0,s=a.length;o<s;o+=3){var l=a[o],c=a[o+1],u=a[o+2],d=n.decodeTextureCoordinates(r,l,texCoordScratch0),h=n.decodeTextureCoordinates(r,c,texCoordScratch1),p=n.decodeTextureCoordinates(r,u,texCoordScratch2),p=Intersections2D.computeBarycentricCoordinates(t,i,d.x,d.y,h.x,h.y,p.x,p.y,barycentricCoordinateScratch);if(-1e-15<=p.x&&-1e-15<=p.y&&-1e-15<=p.z){l=n.decodeHeight(r,l),c=n.decodeHeight(r,c),u=n.decodeHeight(r,u);return p.x*l+p.y*c+p.z*u}}}var sizeOfUint16=Uint16Array.BYTES_PER_ELEMENT,sizeOfUint32$7=Uint32Array.BYTES_PER_ELEMENT,sizeOfInt32=Int32Array.BYTES_PER_ELEMENT,sizeOfFloat=Float32Array.BYTES_PER_ELEMENT,sizeOfDouble=Float64Array.BYTES_PER_ELEMENT;function interpolateHeight(e,t,i,r){var n=e._buffer,a=0,o=0,s=0;.5<i?(.5<t?(a=2,o=.5):a=3,s=.5):.5<t&&(a=1,o=.5);for(var l=new DataView(n),c=0,u=0;u<a;++u)c+=l.getUint32(c,!0),c+=sizeOfUint32$7;c+=sizeOfUint32$7;var e=CesiumMath.toRadians(180*l.getFloat64(c+=2*sizeOfDouble,!0)),n=CesiumMath.toRadians(180*l.getFloat64(c+=sizeOfDouble,!0)),d=r.width/e/2,h=r.height/n/2,p=l.getInt32(c+=sizeOfDouble,!0),f=3*l.getInt32(c+=sizeOfInt32,!0);c+=sizeOfInt32,c+=sizeOfInt32;for(var m=new Array(p),g=new Array(p),_=new Array(p),y=0;y<p;++y)m[y]=o+l.getUint8(c++)*d,g[y]=s+l.getUint8(c++)*h,_[y]=6371010*l.getFloat32(c,!0),c+=sizeOfFloat;var C=new Array(f);for(y=0;y<f;++y)C[y]=l.getUint16(c,!0),c+=sizeOfUint16;for(y=0;y<f;y+=3){var v=C[y],T=C[y+1],S=C[y+2],A=m[v],x=m[T],b=m[S],E=g[v],P=g[T],D=g[S],D=Intersections2D.computeBarycentricCoordinates(t,i,A,E,x,P,b,D,barycentricCoordinateScratch);if(-1e-15<=D.x&&-1e-15<=D.y&&-1e-15<=D.z)return D.x*_[v]+D.y*_[T]+D.z*_[S]}}var TerrainState$2={UNKNOWN:0,NONE:1,SELF:2,PARENT:3},julianDateScratch=new JulianDate;function TerrainCache(){this._terrainCache={},this._lastTidy=JulianDate.now()}function GoogleEarthEnterpriseTerrainProvider(e){var t;e=defaultValue(e,defaultValue.EMPTY_OBJECT),t=defined(e.metadata)?e.metadata:new GoogleEarthEnterpriseMetadata(Resource.createIfNeeded(e.url)),this._metadata=t,this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,rectangle:new Rectangle(-CesiumMath.PI,-CesiumMath.PI,CesiumMath.PI,CesiumMath.PI),ellipsoid:e.ellipsoid});e=e.credit;"string"==typeof e&&(e=new Credit(e)),this._credit=e,this._levelZeroMaximumGeometricError=40075.16,this._terrainCache=new TerrainCache,this._terrainPromises={},this._terrainRequests={},this._errorEvent=new Event,this._ready=!1;var i,r=this;this._readyPromise=t.readyPromise.then(function(e){if(t.terrainPresent)return TileProviderError.handleSuccess(i),r._ready=e;e=new RuntimeError("The server "+t.url+" doesn't have terrain");return i=TileProviderError.handleError(i,r,r._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)}).otherwise(function(e){return i=TileProviderError.handleError(i,r,r._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)})}TerrainCache.prototype.add=function(e,t){this._terrainCache[e]={buffer:t,timestamp:JulianDate.now()}},TerrainCache.prototype.get=function(e){var t=this._terrainCache[e];if(defined(t))return delete this._terrainCache[e],t.buffer},TerrainCache.prototype.tidy=function(){if(JulianDate.now(julianDateScratch),10<JulianDate.secondsDifference(julianDateScratch,this._lastTidy)){for(var e=this._terrainCache,t=Object.keys(e),i=t.length,r=0;r<i;++r){var n=t[r],a=e[n];10<JulianDate.secondsDifference(julianDateScratch,a.timestamp)&&delete e[n]}JulianDate.clone(julianDateScratch,this._lastTidy)}},Object.defineProperties(GoogleEarthEnterpriseTerrainProvider.prototype,{url:{get:function(){return this._metadata.url}},proxy:{get:function(){return this._metadata.proxy}},tilingScheme:{get:function(){return this._tilingScheme}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},credit:{get:function(){return this._credit}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}});var taskProcessor=new TaskProcessor("decodeGoogleEarthEnterprisePacket");function computeChildMask(e,t,i){var r=t.getChildBitmask();if(t.terrainState===TerrainState$2.PARENT)for(var r=0,n=0;n<4;++n){var a=i.getTileInformationFromQuadKey(e+n.toString());defined(a)&&a.hasTerrain()&&(r|=1<<n)}return r}function buildTerrainResource(e,t,i,r){return i=defined(i)&&0<i?i:1,e._metadata.resource.getDerivedResource({url:"flatfile?f1c-0"+t+"-t."+i.toString(),request:r})}GoogleEarthEnterpriseTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),s=this._terrainCache,l=this._metadata,a=l.getTileInformationFromQuadKey(n);if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));e=a.terrainState;defined(e)||(e=a.terrainState=TerrainState$2.UNKNOWN);var o,t=s.get(n);if(defined(t)){i=l.providers[a.terrainProvider];return when.resolve(new GoogleEarthEnterpriseTerrainData({buffer:t,childTileMask:computeChildMask(n,a,l),credits:defined(i)?[i]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold}))}if(s.tidy(),!a.ancestorHasTerrain)return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}));if(e===TerrainState$2.NONE)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var c=n,u=-1;switch(e){case TerrainState$2.SELF:u=a.terrainVersion;break;case TerrainState$2.PARENT:c=c.substring(0,c.length-1),u=(o=l.getTileInformationFromQuadKey(c)).terrainVersion;break;case TerrainState$2.UNKNOWN:a.hasTerrain()?u=a.terrainVersion:(c=c.substring(0,c.length-1),defined(o=l.getTileInformationFromQuadKey(c))&&o.hasTerrain()&&(u=o.terrainVersion))}if(u<0)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var d,h=this._terrainPromises,p=this._terrainRequests;if(defined(h[c]))d=h[c],f=p[c];else{var f,e=buildTerrainResource(this,c,u,f=r).fetchArrayBuffer();if(!defined(e))return;d=e.then(function(e){return defined(e)?taskProcessor.scheduleTask({buffer:e,type:"Terrain",key:l.key},[e]).then(function(e){var t=l.getTileInformationFromQuadKey(c);t.terrainState=TerrainState$2.SELF,s.add(c,e[0]);for(var i=t.terrainProvider,r=e.length-1,n=0;n<r;++n){var a=c+n.toString(),o=l.getTileInformationFromQuadKey(a);defined(o)&&(s.add(a,e[n+1]),o.terrainState=TerrainState$2.PARENT,0===o.terrainProvider&&(o.terrainProvider=i))}}):when.reject(new RuntimeError("Failed to load terrain."))}),h[c]=d,p[c]=f,d=d.always(function(){delete h[c],delete p[c]})}return d.then(function(){var e=s.get(n);if(defined(e)){var t=l.providers[a.terrainProvider];return new GoogleEarthEnterpriseTerrainData({buffer:e,childTileMask:computeChildMask(n,a,l),credits:defined(t)?[t]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold})}return when.reject(new RuntimeError("Failed to load terrain."))}).otherwise(function(e){return f.state===RequestState$1.CANCELLED?r.state=f.state:a.terrainState=TerrainState$2.NONE,when.reject(e)})},GoogleEarthEnterpriseTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},GoogleEarthEnterpriseTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){var r=this._metadata,n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),a=r.getTileInformation(e,t,i);if(null===a)return!1;if(defined(a)){if(!a.ancestorHasTerrain)return!0;var o=a.terrainState;if(o===TerrainState$2.NONE)return!1;if(!(defined(o)&&o!==TerrainState$2.UNKNOWN||(a.terrainState=TerrainState$2.UNKNOWN,a.hasTerrain()))){var n=n.substring(0,n.length-1),a=r.getTileInformationFromQuadKey(n);if(!defined(a)||!a.hasTerrain())return!1}return!0}return r.isValid(n)&&(n=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),r.populateSubtree(e,t,i,n)),!1},GoogleEarthEnterpriseTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var PROJECTIONS=[GeographicProjection,WebMercatorProjection],PROJECTION_COUNT=PROJECTIONS.length,MITER_BREAK_SMALL=Math.cos(CesiumMath.toRadians(30)),MITER_BREAK_LARGE=Math.cos(CesiumMath.toRadians(150)),WALL_INITIAL_MIN_HEIGHT=0,WALL_INITIAL_MAX_HEIGHT=1e3;function GroundPolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;this.width=defaultValue(e.width,1),this._positions=t,this.granularity=defaultValue(e.granularity,9999),this.loop=defaultValue(e.loop,!1),this.arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._ellipsoid=Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(GroundPolylineGeometry.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+Ellipsoid.packedLength+1+1}}}),GroundPolylineGeometry.setProjectionAndEllipsoid=function(e,t){for(var i=0,r=0;r<PROJECTION_COUNT;r++)if(t instanceof PROJECTIONS[r]){i=r;break}e._projectionIndex=i,e._ellipsoid=t.ellipsoid};var cart3Scratch1=new Cartesian3,cart3Scratch2=new Cartesian3,cart3Scratch3=new Cartesian3;function computeRightNormal(e,t,i,r,n){var a=getPosition$2(r,e,0,cart3Scratch1),i=getPosition$2(r,e,i,cart3Scratch2),t=getPosition$2(r,t,0,cart3Scratch3),i=direction(i,a,cart3Scratch2),a=direction(t,a,cart3Scratch3);return Cartesian3.cross(a,i,n),Cartesian3.normalize(n,n)}var interpolatedCartographicScratch$1=new Cartographic,interpolatedBottomScratch=new Cartesian3,interpolatedTopScratch=new Cartesian3,interpolatedNormalScratch=new Cartesian3;function interpolateSegment(e,t,i,r,n,a,o,s,l,c,u){if(0!==n){var d;a===ArcType$1.GEODESIC?d=new EllipsoidGeodesic(e,t,o):a===ArcType$1.RHUMB&&(d=new EllipsoidRhumbLine(e,t,o));a=d.surfaceDistance;if(!(a<n))for(var h=computeRightNormal(e,t,r,o,interpolatedNormalScratch),n=Math.ceil(a/n),p=a/n,f=p,m=n-1,g=s.length,_=0;_<m;_++){var y=d.interpolateUsingSurfaceDistance(f,interpolatedCartographicScratch$1),C=getPosition$2(o,y,i,interpolatedBottomScratch),v=getPosition$2(o,y,r,interpolatedTopScratch);Cartesian3.pack(h,s,g),Cartesian3.pack(C,l,g),Cartesian3.pack(v,c,g),u.push(y.latitude),u.push(y.longitude),g+=3,f+=p}}}var heightlessCartographicScratch=new Cartographic;function getPosition$2(e,t,i,r){return Cartographic.clone(t,heightlessCartographicScratch),heightlessCartographicScratch.height=i,Cartographic.toCartesian(heightlessCartographicScratch,e,r)}function direction(e,t,i){return Cartesian3.subtract(e,t,i),Cartesian3.normalize(i,i),i}function tangentDirection(e,t,i,r){return r=direction(e,t,r),r=Cartesian3.cross(r,i,r),r=Cartesian3.normalize(r,r),r=Cartesian3.cross(i,r,r)}GroundPolylineGeometry.pack=function(e,t,i){var r=defaultValue(i,0),n=e._positions,a=n.length;t[r++]=a;for(var o=0;o<a;++o){var s=n[o];Cartesian3.pack(s,t,r),r+=3}return t[r++]=e.granularity,t[r++]=e.loop?1:0,t[r++]=e.arcType,Ellipsoid.pack(e._ellipsoid,t,r),r+=Ellipsoid.packedLength,t[r++]=e._projectionIndex,t[r++]=e._scene3DOnly?1:0,t},GroundPolylineGeometry.unpack=function(e,t,i){for(var r=defaultValue(t,0),n=e[r++],a=new Array(n),o=0;o<n;o++)a[o]=Cartesian3.unpack(e,r),r+=3;var s=e[r++],l=1===e[r++],c=e[r++],u=Ellipsoid.unpack(e,r);r+=Ellipsoid.packedLength;var d=e[r++],t=1===e[r++];return(i=!defined(i)?new GroundPolylineGeometry({positions:a}):i)._positions=a,i.granularity=s,i.loop=l,i.arcType=c,i._ellipsoid=u,i._projectionIndex=d,i._scene3DOnly=t,i};var toPreviousScratch=new Cartesian3,toNextScratch=new Cartesian3,forwardScratch=new Cartesian3,vertexUpScratch=new Cartesian3,cosine90=0,cosine180=-1;function computeVertexMiterNormal(e,t,i,r,n){i=direction(i,t,vertexUpScratch),e=tangentDirection(e,t,i,toPreviousScratch),t=tangentDirection(r,t,i,toNextScratch);if(CesiumMath.equalsEpsilon(Cartesian3.dot(e,t),cosine180,CesiumMath.EPSILON5))return n=Cartesian3.cross(i,e,n),n=Cartesian3.normalize(n,n);n=Cartesian3.add(t,e,n),n=Cartesian3.normalize(n,n);i=Cartesian3.cross(i,n,forwardScratch);return n=Cartesian3.dot(t,i)<cosine90?Cartesian3.negate(n,n):n}var XZ_PLANE=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),previousBottomScratch=new Cartesian3,vertexBottomScratch=new Cartesian3,vertexTopScratch=new Cartesian3,nextBottomScratch=new Cartesian3,vertexNormalScratch=new Cartesian3,intersectionScratch$1=new Cartesian3,cartographicScratch0=new Cartographic,cartographicScratch1=new Cartographic,cartographicIntersectionScratch=new Cartographic;GroundPolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o=!e._scene3DOnly,s=e.loop,l=e._ellipsoid,c=e.granularity,u=e.arcType,d=new PROJECTIONS[e._projectionIndex](l),h=WALL_INITIAL_MIN_HEIGHT,p=WALL_INITIAL_MAX_HEIGHT,f=e._positions,m=f.length;2===m&&(s=!1);for(var g,_,y,C=new EllipsoidRhumbLine(void 0,void 0,l),v=[f[0]],T=0;T<m-1;T++)i=f[T],r=f[T+1],!defined(g=IntersectionTests.lineSegmentPlane(i,r,XZ_PLANE,intersectionScratch$1))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?v.push(Cartesian3.clone(g)):e.arcType===ArcType$1.RHUMB&&(y=l.cartesianToCartographic(g,cartographicScratch0).longitude,n=l.cartesianToCartographic(i,cartographicScratch0),a=l.cartesianToCartographic(r,cartographicScratch1),C.setEndPoints(n,a),_=C.findIntersectionWithLongitude(y,cartographicIntersectionScratch),!defined(g=l.cartographicToCartesian(_,intersectionScratch$1))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||v.push(Cartesian3.clone(g)))),v.push(r);s&&(i=f[m-1],r=f[0],!defined(g=IntersectionTests.lineSegmentPlane(i,r,XZ_PLANE,intersectionScratch$1))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?v.push(Cartesian3.clone(g)):e.arcType===ArcType$1.RHUMB&&(y=l.cartesianToCartographic(g,cartographicScratch0).longitude,n=l.cartesianToCartographic(i,cartographicScratch0),a=l.cartesianToCartographic(r,cartographicScratch1),C.setEndPoints(n,a),_=C.findIntersectionWithLongitude(y,cartographicIntersectionScratch),!defined(g=l.cartographicToCartesian(_,intersectionScratch$1))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||v.push(Cartesian3.clone(g)))));var S=v.length,A=new Array(S);for(T=0;T<S;T++){var x=Cartographic.fromCartesian(v[T],l);x.height=0,A[T]=x}if(!((S=(A=arrayRemoveDuplicates(A,Cartographic.equalsEpsilon)).length)<2)){var b=[],E=[],P=[],D=[],w=previousBottomScratch,M=vertexBottomScratch,I=vertexTopScratch,R=nextBottomScratch,O=vertexNormalScratch,B=A[0],L=A[1];for(w=getPosition$2(l,A[S-1],h,w),R=getPosition$2(l,L,h,R),M=getPosition$2(l,B,h,M),I=getPosition$2(l,B,p,I),O=s?computeVertexMiterNormal(w,M,I,R,O):computeRightNormal(B,L,p,l,O),Cartesian3.pack(O,E,0),Cartesian3.pack(M,P,0),Cartesian3.pack(I,D,0),b.push(B.latitude),b.push(B.longitude),interpolateSegment(B,L,h,p,c,u,l,E,P,D,b),T=1;T<S-1;++T){var w=Cartesian3.clone(M,w),M=Cartesian3.clone(R,M),F=A[T];getPosition$2(l,F,p,I),getPosition$2(l,A[T+1],h,R),computeVertexMiterNormal(w,M,I,R,O),t=E.length,Cartesian3.pack(O,E,t),Cartesian3.pack(M,P,t),Cartesian3.pack(I,D,t),b.push(F.latitude),b.push(F.longitude),interpolateSegment(A[T],A[T+1],h,p,c,u,l,E,P,D,b)}var N=A[S-1],V=A[S-2];if(M=getPosition$2(l,N,h,M),I=getPosition$2(l,N,p,I),O=s?(L=A[0],computeVertexMiterNormal(w=getPosition$2(l,V,h,w),M,I,R=getPosition$2(l,L,h,R),O)):computeRightNormal(V,N,p,l,O),t=E.length,Cartesian3.pack(O,E,t),Cartesian3.pack(M,P,t),Cartesian3.pack(I,D,t),b.push(N.latitude),b.push(N.longitude),s){for(interpolateSegment(N,B,h,p,c,u,l,E,P,D,b),t=E.length,T=0;T<3;++T)E[t+T]=E[T],P[t+T]=P[T],D[t+T]=D[T];b.push(B.latitude),b.push(B.longitude)}return generateGeometryAttributes(s,d,P,D,E,b,o)}};var lineDirectionScratch=new Cartesian3,matrix3Scratch$1=new Matrix3,quaternionScratch$1=new Quaternion;function breakMiter(e,t,i,r){t=direction(i,t,lineDirectionScratch),t=Cartesian3.dot(t,e);if(MITER_BREAK_SMALL<t||t<MITER_BREAK_LARGE){i=direction(r,i,vertexUpScratch),t=t<MITER_BREAK_LARGE?CesiumMath.PI_OVER_TWO:-CesiumMath.PI_OVER_TWO,t=Quaternion.fromAxisAngle(i,t,quaternionScratch$1),t=Matrix3.fromQuaternion(t,matrix3Scratch$1);return Matrix3.multiplyByVector(t,e,e),!0}return!1}var endPosCartographicScratch=new Cartographic,normalStartpointScratch=new Cartesian3,normalEndpointScratch=new Cartesian3;function projectNormal(e,t,i,r,n){var a=Cartographic.toCartesian(t,e._ellipsoid,normalStartpointScratch),o=Cartesian3.add(a,i,normalEndpointScratch),s=!1,l=e._ellipsoid,c=l.cartesianToCartographic(o,endPosCartographicScratch);Math.abs(t.longitude-c.longitude)>CesiumMath.PI_OVER_TWO&&(s=!0,o=Cartesian3.subtract(a,i,normalEndpointScratch),c=l.cartesianToCartographic(o,endPosCartographicScratch)),c.height=0;c=e.project(c,n);return(n=Cartesian3.subtract(c,r,n)).z=0,n=Cartesian3.normalize(n,n),s&&Cartesian3.negate(n,n),n}var adjustHeightNormalScratch=new Cartesian3,adjustHeightOffsetScratch=new Cartesian3;function adjustHeights(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,adjustHeightNormalScratch);Cartesian3.normalize(o,o);i=Cartesian3.multiplyByScalar(o,i-WALL_INITIAL_MIN_HEIGHT,adjustHeightOffsetScratch);Cartesian3.add(e,i,n);i=Cartesian3.multiplyByScalar(o,r-WALL_INITIAL_MAX_HEIGHT,adjustHeightOffsetScratch);Cartesian3.add(t,i,a)}var nudgeDirectionScratch=new Cartesian3;function nudgeXZ(e,t){var i=Plane.getPointDistance(XZ_PLANE,e),r=Plane.getPointDistance(XZ_PLANE,t),n=nudgeDirectionScratch;CesiumMath.equalsEpsilon(i,0,CesiumMath.EPSILON2)?(n=direction(t,e,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(e,n,e)):CesiumMath.equalsEpsilon(r,0,CesiumMath.EPSILON2)&&(n=direction(e,t,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(t,n,t))}function nudgeCartographic(e,t){var i=Math.abs(e.longitude),r=Math.abs(t.longitude);if(CesiumMath.equalsEpsilon(i,CesiumMath.PI,CesiumMath.EPSILON11)){var n=CesiumMath.sign(t.longitude);return e.longitude=n*(i-CesiumMath.EPSILON11),1}if(CesiumMath.equalsEpsilon(r,CesiumMath.PI,CesiumMath.EPSILON11)){e=CesiumMath.sign(e.longitude);return t.longitude=e*(r-CesiumMath.EPSILON11),2}return 0}var startCartographicScratch$1=new Cartographic,endCartographicScratch$1=new Cartographic,segmentStartTopScratch=new Cartesian3,segmentEndTopScratch=new Cartesian3,segmentStartBottomScratch=new Cartesian3,segmentEndBottomScratch=new Cartesian3,segmentStartNormalScratch=new Cartesian3,segmentEndNormalScratch=new Cartesian3,getHeightCartographics=[startCartographicScratch$1,endCartographicScratch$1],getHeightRectangleScratch=new Rectangle,adjustHeightStartTopScratch=new Cartesian3,adjustHeightEndTopScratch=new Cartesian3,adjustHeightStartBottomScratch=new Cartesian3,adjustHeightEndBottomScratch=new Cartesian3,segmentStart2DScratch=new Cartesian3,segmentEnd2DScratch=new Cartesian3,segmentStartNormal2DScratch=new Cartesian3,segmentEndNormal2DScratch=new Cartesian3,offsetScratch$b=new Cartesian3,startUpScratch=new Cartesian3,endUpScratch=new Cartesian3,rightScratch=new Cartesian3,startPlaneNormalScratch=new Cartesian3,endPlaneNormalScratch=new Cartesian3,encodeScratch$1=new EncodedCartesian3,encodeScratch2D=new EncodedCartesian3,forwardOffset2DScratch=new Cartesian3,right2DScratch=new Cartesian3,normalNudgeScratch=new Cartesian3,scratchBoundingSpheres=[new BoundingSphere,new BoundingSphere],REFERENCE_INDICES=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],REFERENCE_INDICES_LENGTH=REFERENCE_INDICES.length;function generateGeometryAttributes(e,t,i,r,n,a,o){var s,l,c,u,d=t._ellipsoid,h=i.length/3-1,p=8*h,f=4*p,m=36*h,g=new(65535<p?Uint32Array:Uint16Array)(m),_=new Float64Array(3*p),y=new Float32Array(f),C=new Float32Array(f),v=new Float32Array(f),T=new Float32Array(f),S=new Float32Array(f);o&&(s=new Float32Array(f),l=new Float32Array(f),c=new Float32Array(f),u=new Float32Array(2*p));var A=a.length/2,x=0,b=startCartographicScratch$1;b.height=0;var E=endCartographicScratch$1;E.height=0;var P=segmentStartTopScratch,D=segmentEndTopScratch;if(o)for(R=0,O=1;O<A;O++)b.latitude=a[R],b.longitude=a[R+1],E.latitude=a[R+2],E.longitude=a[R+3],P=t.project(b,P),D=t.project(E,D),x+=Cartesian3.distance(P,D),R+=2;for(var w,M=r.length/3,D=Cartesian3.unpack(r,0,D),I=0,R=3,O=1;O<M;O++)P=Cartesian3.clone(D,P),D=Cartesian3.unpack(r,R,D),I+=Cartesian3.distance(P,D),R+=3;var B=0,L=0,F=0,N=0,V=!(R=3),k=Cartesian3.unpack(i,0,segmentEndBottomScratch),G=Cartesian3.unpack(r,0,segmentEndTopScratch),U=Cartesian3.unpack(n,0,segmentEndNormalScratch);e&&breakMiter(U,Cartesian3.unpack(i,i.length-6,segmentStartBottomScratch),k,G)&&(U=Cartesian3.negate(U,U));var $=0,z=0,H=0;for(O=0;O<h;O++){var W,q,j,X,K=Cartesian3.clone(k,segmentStartBottomScratch),Y=Cartesian3.clone(G,segmentStartTopScratch),J=Cartesian3.clone(U,segmentStartNormalScratch);V&&(J=Cartesian3.negate(J,J)),k=Cartesian3.unpack(i,R,segmentEndBottomScratch),G=Cartesian3.unpack(r,R,segmentEndTopScratch),V=breakMiter(U=Cartesian3.unpack(n,R,segmentEndNormalScratch),K,k,G),b.latitude=a[B],b.longitude=a[B+1],E.latitude=a[B+2],E.longitude=a[B+3],o&&(Te=nudgeCartographic(b,E),j=t.project(b,segmentStart2DScratch),(he=direction(X=t.project(E,segmentEnd2DScratch),j,forwardOffset2DScratch)).y=Math.abs(he.y),W=segmentStartNormal2DScratch,q=segmentEndNormal2DScratch,0===Te||Cartesian3.dot(he,Cartesian3.UNIT_Y)>MITER_BREAK_SMALL?(W=projectNormal(t,b,J,j,segmentStartNormal2DScratch),q=projectNormal(t,E,U,X,segmentEndNormal2DScratch)):1===Te?(q=projectNormal(t,E,U,X,segmentEndNormal2DScratch),W.x=0,W.y=CesiumMath.sign(b.longitude-Math.abs(E.longitude)),W.z=0):(W=projectNormal(t,b,J,j,segmentStartNormal2DScratch),q.x=0,q.y=CesiumMath.sign(b.longitude-E.longitude),q.z=0));var Q,Z,ee,te=Cartesian3.distance(Y,G),ie=EncodedCartesian3.fromCartesian(K,encodeScratch$1),re=Cartesian3.subtract(k,K,offsetScratch$b),ne=Cartesian3.normalize(re,rightScratch),ae=Cartesian3.subtract(Y,K,startUpScratch),ae=Cartesian3.normalize(ae,ae),oe=Cartesian3.cross(ne,ae,rightScratch),oe=Cartesian3.normalize(oe,oe),se=Cartesian3.cross(ae,J,startPlaneNormalScratch),se=Cartesian3.normalize(se,se),le=Cartesian3.subtract(G,k,endUpScratch),le=Cartesian3.normalize(le,le),ce=Cartesian3.cross(U,le,endPlaneNormalScratch),ce=Cartesian3.normalize(ce,ce),ue=te/I,de=$/I,he=0,pe=0,fe=0;for(o&&(he=Cartesian3.distance(j,X),Q=EncodedCartesian3.fromCartesian(j,encodeScratch2D),Z=Cartesian3.subtract(X,j,forwardOffset2DScratch),Se=(ee=Cartesian3.normalize(Z,right2DScratch)).x,ee.x=ee.y,ee.y=-Se,pe=he/x,fe=z/x),w=0;w<8;w++){var me=N+4*w,ge=L+2*w,_e=me+3,ye=w<4?1:-1,Ce=2===w||3===w||6===w||7===w?1:-1;Cartesian3.pack(ie.high,y,me),y[_e]=re.x,Cartesian3.pack(ie.low,C,me),C[_e]=re.y,Cartesian3.pack(se,v,me),v[_e]=re.z,Cartesian3.pack(ce,T,me),T[_e]=ue*ye,Cartesian3.pack(oe,S,me);var ve=de*Ce;0===ve&&Ce<0&&(ve=9),S[_e]=ve,o&&(s[me]=Q.high.x,s[me+1]=Q.high.y,s[me+2]=Q.low.x,s[me+3]=Q.low.y,c[me]=-W.y,c[me+1]=W.x,c[me+2]=q.y,c[me+3]=-q.x,l[me]=Z.x,l[me+1]=Z.y,l[me+2]=ee.x,l[me+3]=ee.y,u[ge]=pe*ye,0===(ve=fe*Ce)&&Ce<0&&(ve=9),u[ge+1]=ve)}var Te=adjustHeightStartBottomScratch,ne=adjustHeightEndBottomScratch,ae=adjustHeightStartTopScratch,J=adjustHeightEndTopScratch,le=Rectangle.fromCartographicArray(getHeightCartographics,getHeightRectangleScratch),Se=ApproximateTerrainHeights.getMinimumMaximumHeights(le,d),le=Se.minimumTerrainHeight,Se=Se.maximumTerrainHeight;H+=le,H+=Se,adjustHeights(K,Y,le,Se,Te,ae),adjustHeights(k,G,le,Se,ne,J);Se=Cartesian3.multiplyByScalar(oe,CesiumMath.EPSILON5,normalNudgeScratch);Cartesian3.add(Te,Se,Te),Cartesian3.add(ne,Se,ne),Cartesian3.add(ae,Se,ae),Cartesian3.add(J,Se,J),nudgeXZ(Te,ne),nudgeXZ(ae,J),Cartesian3.pack(Te,_,F),Cartesian3.pack(ne,_,F+3),Cartesian3.pack(J,_,F+6),Cartesian3.pack(ae,_,F+9),Se=Cartesian3.multiplyByScalar(oe,-2*CesiumMath.EPSILON5,normalNudgeScratch),Cartesian3.add(Te,Se,Te),Cartesian3.add(ne,Se,ne),Cartesian3.add(ae,Se,ae),Cartesian3.add(J,Se,J),nudgeXZ(Te,ne),nudgeXZ(ae,J),Cartesian3.pack(Te,_,F+12),Cartesian3.pack(ne,_,F+15),Cartesian3.pack(J,_,F+18),Cartesian3.pack(ae,_,F+21),B+=2,R+=3,L+=16,F+=24,N+=32,$+=te,z+=he}var Ae=R=0;for(O=0;O<h;O++){for(w=0;w<REFERENCE_INDICES_LENGTH;w++)g[R+w]=REFERENCE_INDICES[w]+Ae;Ae+=8,R+=REFERENCE_INDICES_LENGTH}p=scratchBoundingSpheres;BoundingSphere.fromVertices(i,Cartesian3.ZERO,3,p[0]),BoundingSphere.fromVertices(r,Cartesian3.ZERO,3,p[1]);e=BoundingSphere.fromBoundingSpheres(p);e.radius+=H/(2*h);p={position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,normalize:!1,values:_}),startHiAndForwardOffsetX:getVec4GeometryAttribute(y),startLoAndForwardOffsetY:getVec4GeometryAttribute(C),startNormalAndForwardOffsetZ:getVec4GeometryAttribute(v),endNormalAndTextureCoordinateNormalizationX:getVec4GeometryAttribute(T),rightNormalAndTextureCoordinateNormalizationY:getVec4GeometryAttribute(S)};return o&&(p.startHiLo2D=getVec4GeometryAttribute(s),p.offsetAndRight2D=getVec4GeometryAttribute(l),p.startEndNormals2D=getVec4GeometryAttribute(c),p.texcoordNormalization2D=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,normalize:!1,values:u})),new Geometry({attributes:p,indices:g,boundingSphere:e})}function getVec4GeometryAttribute(e){return new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}function HeadingPitchRange(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.range=defaultValue(i,0)}GroundPolylineGeometry._projectNormal=projectNormal,HeadingPitchRange.clone=function(e,t){if(defined(e))return(t=!defined(t)?new HeadingPitchRange:t).heading=e.heading,t.pitch=e.pitch,t.range=e.range,t};var factorial=CesiumMath.factorial;function calculateCoefficientTerm(e,t,i,r,n,a){var o,s,l,c=0;if(0<r){for(s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(a.push(s),c+=calculateCoefficientTerm(e,t,i,r-1,n,a),a.splice(a.length-1,1))}return c}for(c=1,s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(c*=e-i[t[s]])}return c}var HermitePolynomialApproximation={type:"Hermite",getRequiredDataPoints:function(e,t){return t=defaultValue(t,0),Math.max(Math.floor((e+1)/(t+1)),2)},interpolateOrderZero:function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));for(var s=t.length,l=new Array(r),c=0;c<r;c++){n[c]=0;var u=new Array(s);for(l[c]=u,m=0;m<s;m++)u[m]=[]}var d=s,h=new Array(d);for(c=0;c<d;c++)h[c]=c;var p=s-1;for(v=0;v<r;v++){for(m=0;m<d;m++)o=h[m]*r+v,l[v][0].push(i[o]);for(c=1;c<d;c++){for(var f=!1,m=0;m<d-c;m++){var g,_=t[h[m]],y=t[h[m+c]];y-_<=0?(g=i[o=h[m]*r+r*c+v],l[v][c].push(g/factorial(c))):(g=l[v][c-1][m+1]-l[v][c-1][m],l[v][c].push(g/(y-_))),f=f||0!==g}f||(p=c-1)}}for(a=0;a<=0;a++)for(c=a;c<=p;c++)for(var C=calculateCoefficientTerm(e,h,t,a,c,[]),v=0;v<r;v++){var T=l[v][c][0];n[v+a*r]+=T*C}return n}},arrayScratch=[];function fillCoefficientList(e,t,i,r,n,a){for(var o,s=-1,l=t.length,c=l*(l+1)/2,u=0;u<n;u++){var d=Math.floor(u*c);for(g=0;g<l;g++)o=t[g]*n*(a+1)+u,e[d+g]=r[o];for(var h=1;h<l;h++){for(var p=0,f=Math.floor(h*(1-h)/2)+l*h,m=!1,g=0;g<l-h;g++){var _,y,C=i[t[g]],v=i[t[g+h]];C=v-C<=0?(y=r[o=t[g]*n*(a+1)+n*h+u])/CesiumMath.factorial(h):(y=e[d+(_=Math.floor((h-1)*(2-h)/2)+l*(h-1))+g+1]-e[d+_+g])/(v-C),e[d+f+p]=C,p++,m=m||0!==y}m&&(s=Math.max(s,h))}}return s}HermitePolynomialApproximation.interpolate=function(e,t,i,r,n,a,o){var s=r*(a+1);defined(o)||(o=new Array(s));for(var l=0;l<s;l++)o[l]=0;for(var c=t.length,u=new Array(c*(n+1)),d=0;d<c;d++)for(var h=0;h<n+1;h++)u[d*(n+1)+h]=d;for(var p=u.length,f=arrayScratch,m=fillCoefficientList(f,u,t,i,r,n),g=[],_=p*(p+1)/2,y=Math.min(m,a),C=0;C<=y;C++)for(d=C;d<=m;d++){g.length=0;for(var v=calculateCoefficientTerm(e,u,t,C,d,g),T=Math.floor(d*(1-d)/2)+p*d,S=0;S<r;S++){var A=f[Math.floor(S*_)+T];o[S+C*r]+=A*v}}return o};var HilbertOrder={};function rotate$1(e,t,i,r){0===r&&(1===i&&(t.x=e-1-t.x,t.y=e-1-t.y),e=t.x,t.x=t.y,t.y=e)}function IauOrientationParameters(e,t,i,r){this.rightAscension=e,this.declination=t,this.rotation=i,this.rotationRate=r}HilbertOrder.encode2D=function(e,t,i){for(var r,n,a=Math.pow(2,e),o={x:t,y:i},s=BigInt(0),l=a/2;0<l;l/=2)r=0<(o.x&l)?1:0,n=0<(o.y&l)?1:0,s+=BigInt((3*r^n)*l*l),rotate$1(a,o,r,n);return s},HilbertOrder.decode2D=function(e,t){for(var i,r,n=Math.pow(2,e),a={x:0,y:0},o=1,s=t;o<n;o*=2)rotate$1(o,a,i=1&Number(s/BigInt(2)),r=1&Number(s^BigInt(i))),a.x+=o*i,a.y+=o*r,s/=BigInt(4);return[a.x,a.y]};var Iau2000Orientation={},TdtMinusTai$1=32.184,J2000d$1=2451545,c1=-.0529921,c2=-.1059842,c3=13.0120009,c4=13.3407154,c5=.9856003,c6=26.4057084,c7=13.064993,c8=.3287146,c9=1.7484877,c10=-.1589763,c11=.0036096,c12=.1643573,c13=12.9590088,dateTT=new JulianDate;function IauOrientationAxes(e){defined(e)&&"function"==typeof e||(e=Iau2000Orientation.ComputeMoon),this._computeFunction=e}Iau2000Orientation.ComputeMoon=function(e,t){defined(e)||(e=JulianDate.now()),dateTT=JulianDate.addSeconds(e,TdtMinusTai$1,dateTT);var i=JulianDate.totalDays(dateTT)-J2000d$1,r=i/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,n=(125.045+c1*i)*CesiumMath.RADIANS_PER_DEGREE,a=(250.089+c2*i)*CesiumMath.RADIANS_PER_DEGREE,o=(260.008+c3*i)*CesiumMath.RADIANS_PER_DEGREE,s=(176.625+c4*i)*CesiumMath.RADIANS_PER_DEGREE,l=(357.529+c5*i)*CesiumMath.RADIANS_PER_DEGREE,c=(311.589+c6*i)*CesiumMath.RADIANS_PER_DEGREE,u=(134.963+c7*i)*CesiumMath.RADIANS_PER_DEGREE,d=(276.617+c8*i)*CesiumMath.RADIANS_PER_DEGREE,h=(34.226+c9*i)*CesiumMath.RADIANS_PER_DEGREE,p=(15.134+c10*i)*CesiumMath.RADIANS_PER_DEGREE,f=(119.743+c11*i)*CesiumMath.RADIANS_PER_DEGREE,m=(239.961+c12*i)*CesiumMath.RADIANS_PER_DEGREE,g=(25.053+c13*i)*CesiumMath.RADIANS_PER_DEGREE,_=Math.sin(n),y=Math.sin(a),C=Math.sin(o),v=Math.sin(s),T=Math.sin(l),S=Math.sin(c),A=Math.sin(u),x=Math.sin(d),b=Math.sin(h),E=Math.sin(p),P=Math.sin(f),D=Math.sin(m),w=Math.sin(g),e=Math.cos(n),n=Math.cos(a),a=Math.cos(o),o=Math.cos(s),s=Math.cos(l),l=Math.cos(c),c=Math.cos(u),u=Math.cos(d),d=Math.cos(h),h=Math.cos(p),p=Math.cos(f),f=Math.cos(m),m=Math.cos(g),g=(269.9949+.0031*r-3.8787*_-.1204*y+.07*C-.0172*v+.0072*S-.0052*E+.0043*w)*CesiumMath.RADIANS_PER_DEGREE,r=(66.5392+.013*r+1.5419*e+.0239*n-.0278*a+.0068*o-.0029*l+9e-4*c+8e-4*h-9e-4*m)*CesiumMath.RADIANS_PER_DEGREE,w=(38.3213+13.17635815*i-14e-13*i*i+3.561*_+.1208*y-.0642*C+.0158*v+.0252*T-.0066*S-.0047*A-.0046*x+.0028*b+.0052*E+.004*P+.0019*D-.0044*w)*CesiumMath.RADIANS_PER_DEGREE,m=(13.17635815-2*i*14e-13+3.561*e*c1+.1208*n*c2-.0642*a*c3+.0158*o*c4+.0252*s*c5-.0066*l*c6-.0047*c*c7-.0046*u*c8+.0028*d*c9+.0052*h*c10+.004*p*c11+.0019*f*c12-.0044*m*c13)/86400*CesiumMath.RADIANS_PER_DEGREE;return(t=!defined(t)?new IauOrientationParameters:t).rightAscension=g,t.declination=r,t.rotation=w,t.rotationRate=m,t};var xAxisScratch=new Cartesian3,yAxisScratch=new Cartesian3,zAxisScratch=new Cartesian3;function computeRotationMatrix(e,t,i){var r=xAxisScratch;r.x=Math.cos(e+CesiumMath.PI_OVER_TWO),r.y=Math.sin(e+CesiumMath.PI_OVER_TWO),r.z=0;var n=Math.cos(t),a=zAxisScratch;a.x=n*Math.cos(e),a.y=n*Math.sin(e),a.z=Math.sin(t);t=Cartesian3.cross(a,r,yAxisScratch);return(i=!defined(i)?new Matrix3:i)[0]=r.x,i[1]=t.x,i[2]=a.x,i[3]=r.y,i[4]=t.y,i[5]=a.y,i[6]=r.z,i[7]=t.z,i[8]=a.z,i}var rotMtxScratch=new Matrix3,quatScratch=new Quaternion;IauOrientationAxes.prototype.evaluate=function(e,t){defined(e)||(e=JulianDate.now());e=this._computeFunction(e),t=computeRotationMatrix(e.rightAscension,e.declination,t),e=CesiumMath.zeroToTwoPi(e.rotation),e=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,e,quatScratch),e=Matrix3.fromQuaternion(Quaternion.conjugate(e,e),rotMtxScratch);return Matrix3.multiply(e,t,t)};var InterpolationAlgorithm={type:void 0},defaultTokenCredit;InterpolationAlgorithm.getRequiredDataPoints=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolateOrderZero=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolate=DeveloperError.throwInstantiationError;var defaultAccessToken="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI2NjU0MGI3NC1iZjM2LTQzNzctYjM3Yy0zMmU2NGQyNTBiM2MiLCJpZCI6MjU5LCJpYXQiOjE2MzA0OTk1NzV9.xNFmNo8X26_nTRRouMiQSbmrOYel9uLf-eXp_q6htb4",Ion={};function PeliasGeocoderService(e){this._url=Resource.createIfNeeded(e),this._url.appendForwardSlash()}function IonGeocoderService(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(defaultValue(e.server,Ion.defaultServer));i.appendForwardSlash();var r=Ion.getDefaultTokenCredit(t);defined(r)&&e.scene.frameState.creditDisplay.addDefaultCredit(Credit.clone(r));r=i.getDerivedResource({url:"v1/geocode"});defined(t)&&r.appendQueryParameters({access_token:t}),this._accessToken=t,this._server=i,this._pelias=new PeliasGeocoderService(r)}function IonResource(e,t){var i,r=e.externalType,n=defined(r);if(n){if("3DTILES"!==r&&"STK_TERRAIN_SERVER"!==r)throw new RuntimeError("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");i={url:e.options.url}}else i={url:e.url,retryAttempts:1,retryCallback:retryCallback};Resource.call(this,i),this._ionEndpoint=e,this._ionEndpointDomain=n?void 0:new URI(e.url).authority(),this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=n}function retryCallback(t,e){var i=defaultValue(t._ionRoot,t),r=i._ionEndpointResource,n="undefined"!=typeof Image;return defined(e)&&(401===e.statusCode||n&&e.target instanceof Image)?(defined(i._pendingPromise)||(i._pendingPromise=r.fetchJson().then(function(e){return i._ionEndpoint=e}).always(function(e){return i._pendingPromise=void 0,e})),i._pendingPromise.then(function(e){return t._ionEndpoint=e,!0})):when.resolve(!1)}function TimeInterval(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.start=defined(e.start)?JulianDate.clone(e.start):new JulianDate,this.stop=defined(e.stop)?JulianDate.clone(e.stop):new JulianDate,this.data=e.data,this.isStartIncluded=defaultValue(e.isStartIncluded,!0),this.isStopIncluded=defaultValue(e.isStopIncluded,!0)}Ion.defaultAccessToken=defaultAccessToken,Ion.defaultServer=new Resource({url:"https://api.cesium.com/"}),Ion.getDefaultTokenCredit=function(e){if(e===defaultAccessToken)return defined(defaultTokenCredit)||(defaultTokenCredit=new Credit('<b>             This application is using Cesium\'s default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>',!0)),defaultTokenCredit},Object.defineProperties(PeliasGeocoderService.prototype,{url:{get:function(){return this._url}}}),PeliasGeocoderService.prototype.geocode=function(e,t){return this._url.getDerivedResource({url:t===GeocodeType$1.AUTOCOMPLETE?"autocomplete":"search",queryParameters:{text:e}}).fetchJson().then(function(e){return e.features.map(function(e){var t,i=e.bbox;return t=defined(i)?Rectangle.fromDegrees(i[0],i[1],i[2],i[3]):(i=e.geometry.coordinates[0],t=e.geometry.coordinates[1],Cartesian3.fromDegrees(i,t)),{displayName:e.properties.label,destination:t}})})},IonGeocoderService.prototype.geocode=function(e,t){return this._pelias.geocode(e,t)},defined(Object.create)&&(IonResource.prototype=Object.create(Resource.prototype),IonResource.prototype.constructor=IonResource),IonResource.fromAssetId=function(e,t){var i=IonResource._createEndpointResource(e,t);return i.fetchJson().then(function(e){return new IonResource(e,i)})},Object.defineProperties(IonResource.prototype,{credits:{get:function(){return defined(this._ionRoot)?this._ionRoot.credits:(defined(this._credits)||(this._credits=IonResource.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource)),this._credits)}}}),IonResource.getCreditsFromEndpoint=function(e,t){e=e.attributions.map(Credit.getIonCredit),t=Ion.getDefaultTokenCredit(t.queryParameters.access_token);return defined(t)&&e.push(Credit.clone(t)),e},IonResource.prototype.clone=function(e){var t=defaultValue(this._ionRoot,this);return defined(e)||(e=new IonResource(t._ionEndpoint,t._ionEndpointResource)),(e=Resource.prototype.clone.call(this,e))._ionRoot=t,e._isExternal=this._isExternal,e},IonResource.prototype.fetchImage=function(e){var t;return this._isExternal||(t=e,e={preferBlob:!0},defined(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)),Resource.prototype.fetchImage.call(this,e)},IonResource.prototype._makeRequest=function(e){return this._isExternal||new URI(this.url).authority()!==this._ionEndpointDomain||(defined(e.headers)||(e.headers={}),e.headers.Authorization="Bearer "+this._ionEndpoint.accessToken),Resource.prototype._makeRequest.call(this,e)},IonResource._createEndpointResource=function(e,t){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.server,Ion.defaultServer),t=defaultValue(t.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(i),e={url:"v1/assets/"+e+"/endpoint"};return defined(t)&&(e.queryParameters={access_token:t}),i.getDerivedResource(e)},Object.defineProperties(TimeInterval.prototype,{isEmpty:{get:function(){var e=JulianDate.compare(this.stop,this.start);return e<0||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var scratchInterval={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};TimeInterval.fromIso8601=function(e,t){var i=e.iso8601.split("/");if(2!==i.length)throw new DeveloperError("options.iso8601 is an invalid ISO 8601 interval.");var r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=defaultValue(e.isStartIncluded,!0),i=defaultValue(e.isStopIncluded,!0),e=e.data;return defined(t)?(t.start=r,t.stop=n,t.isStartIncluded=a,t.isStopIncluded=i,t.data=e,t):(scratchInterval.start=r,scratchInterval.stop=n,scratchInterval.isStartIncluded=a,scratchInterval.isStopIncluded=i,scratchInterval.data=e,new TimeInterval(scratchInterval))},TimeInterval.toIso8601=function(e,t){return JulianDate.toIso8601(e.start,t)+"/"+JulianDate.toIso8601(e.stop,t)},TimeInterval.clone=function(e,t){if(defined(e))return defined(t)?(t.start=e.start,t.stop=e.stop,t.isStartIncluded=e.isStartIncluded,t.isStopIncluded=e.isStopIncluded,t.data=e.data,t):new TimeInterval(e)},TimeInterval.equals=function(e,t,i){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equals(e.start,t.start)&&JulianDate.equals(e.stop,t.stop)&&(e.data===t.data||defined(i)&&i(e.data,t.data)))},TimeInterval.equalsEpsilon=function(e,t,i,r){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equalsEpsilon(e.start,t.start,i)&&JulianDate.equalsEpsilon(e.stop,t.stop,i)&&(e.data===t.data||defined(r)&&r(e.data,t.data)))},TimeInterval.intersect=function(e,t,i,r){if(!defined(t))return TimeInterval.clone(TimeInterval.EMPTY,i);var n=e.start,a=e.stop,o=t.start,s=t.stop,l=JulianDate.greaterThanOrEquals(o,n)&&JulianDate.greaterThanOrEquals(a,o),c=!l&&JulianDate.lessThanOrEquals(o,n)&&JulianDate.lessThanOrEquals(n,s);if(!l&&!c)return TimeInterval.clone(TimeInterval.EMPTY,i);var u=e.isStartIncluded,d=e.isStopIncluded,h=t.isStartIncluded,p=t.isStopIncluded,f=JulianDate.lessThan(a,s);return(i=!defined(i)?new TimeInterval:i).start=l?o:n,i.isStartIncluded=u&&h||!JulianDate.equals(o,n)&&(l&&h||c&&u),i.stop=f?a:s,i.isStopIncluded=f?d:d&&p||!JulianDate.equals(s,a)&&p,i.data=defined(r)?r(e.data,t.data):e.data,i},TimeInterval.contains=function(e,t){if(e.isEmpty)return!1;var i=JulianDate.compare(e.start,t);if(0===i)return e.isStartIncluded;t=JulianDate.compare(t,e.stop);return 0===t?e.isStopIncluded:i<0&&t<0},TimeInterval.prototype.clone=function(e){return TimeInterval.clone(this,e)},TimeInterval.prototype.equals=function(e,t){return TimeInterval.equals(this,e,t)},TimeInterval.prototype.equalsEpsilon=function(e,t,i){return TimeInterval.equalsEpsilon(this,e,t,i)},TimeInterval.prototype.toString=function(){return TimeInterval.toIso8601(this)},TimeInterval.EMPTY=Object.freeze(new TimeInterval({start:new JulianDate,stop:new JulianDate,isStartIncluded:!1,isStopIncluded:!1}));var MINIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("0000-01-01T00:00:00Z")),MAXIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("9999-12-31T24:00:00Z")),MAXIMUM_INTERVAL=Object.freeze(new TimeInterval({start:MINIMUM_VALUE,stop:MAXIMUM_VALUE})),Iso8601={MINIMUM_VALUE:MINIMUM_VALUE,MAXIMUM_VALUE:MAXIMUM_VALUE,MAXIMUM_INTERVAL:MAXIMUM_INTERVAL};function KTX2Transcoder(){}function makeReadyPromise(){var e=KTX2Transcoder._transcodeTaskProcessor.initWebAssemblyModule({modulePath:"ThirdParty/Workers/basis_transcoder.js",wasmBinaryFile:"ThirdParty/basis_transcoder.wasm"}).then(function(){return KTX2Transcoder._transcodeTaskProcessor});KTX2Transcoder._readyPromise=e}KTX2Transcoder._transcodeTaskProcessor=new TaskProcessor("transcodeKTX2",Number.POSITIVE_INFINITY),KTX2Transcoder._readyPromise=void 0,KTX2Transcoder.transcode=function(i,r){return defined(KTX2Transcoder._readyPromise)||makeReadyPromise(),KTX2Transcoder._readyPromise.then(function(e){if(i instanceof ArrayBuffer){var t=new Uint8Array(i),t={supportedTargetFormats:r,ktx2Buffer:t};return e.scheduleTask(t,[i])}return e.scheduleTask(t={supportedTargetFormats:r,ktx2Buffer:i},[i.buffer])}).then(function(e){for(var t=e.length,i=Object.keys(e[0]),r=i.length,n=0;n<t;n++)for(var a=e[n],o=0;o<r;o++){var s=a[i[o]];a[i[o]]=new CompressedTextureBuffer(s.internalFormat,s.datatype,s.width,s.height,s.levelBuffer)}if(1===r){for(n=0;n<t;++n)e[n]=e[n][i[0]];1===t&&(e=e[0])}return e}).otherwise(function(e){throw e})};var KeyboardEventModifier={SHIFT:0,CTRL:1,ALT:2},KeyboardEventModifier$1=Object.freeze(KeyboardEventModifier),LagrangePolynomialApproximation={type:"Lagrange",getRequiredDataPoints:function(e){return Math.max(e+1,2)},interpolateOrderZero:function(e,t,i,r,n){defined(n)||(n=new Array(r));for(var a=t.length,o=0;o<r;o++)n[o]=0;for(o=0;o<a;o++){for(var s,l=1,c=0;c<a;c++)c!==o&&(s=t[o]-t[c],l*=(e-t[c])/s);for(c=0;c<r;c++)n[c]+=l*i[o*r+c]}return n}},LinearApproximation={type:"Linear"};function ManagedArray(e){e=defaultValue(e,0),this._array=new Array(e),this._length=e}function MapProjection(){DeveloperError.throwInstantiationError()}LinearApproximation.getRequiredDataPoints=function(e){return 2},LinearApproximation.interpolateOrderZero=function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));for(var s=t[0],l=t[1],c=0;c<r;c++)a=i[c],o=i[c+r],n[c]=((o-a)*e+l*a-s*o)/(l-s);return n},Object.defineProperties(ManagedArray.prototype,{length:{get:function(){return this._length},set:function(e){var t=this._array,i=this._length;if(e<i)for(var r=e;r<i;++r)t[r]=void 0;else e>t.length&&(t.length=e);this._length=e}},values:{get:function(){return this._array}}}),ManagedArray.prototype.get=function(e){return this._array[e]},ManagedArray.prototype.set=function(e,t){e>=this._length&&(this.length=e+1),this._array[e]=t},ManagedArray.prototype.peek=function(){return this._array[this._length-1]},ManagedArray.prototype.push=function(e){var t=this.length++;this._array[t]=e},ManagedArray.prototype.pop=function(){if(0!==this._length){var e=this._array[this._length-1];return--this.length,e}},ManagedArray.prototype.reserve=function(e){e>this._array.length&&(this._array.length=e)},ManagedArray.prototype.resize=function(e){this.length=e},ManagedArray.prototype.trim=function(e){e=defaultValue(e,this._length),this._array.length=e},Object.defineProperties(MapProjection.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError}}),MapProjection.prototype.project=DeveloperError.throwInstantiationError,MapProjection.prototype.unproject=DeveloperError.throwInstantiationError;var MortonOrder={};function insertOneSpacing(e){return e=1431655765&((e=858993459&((e=252645135&((e=16711935&(e^e<<8))^e<<4))^e<<2))^e<<1)}function insertTwoSpacing(e){return e=153391689&((e=51130563&((e=50393103&((e=50331903&(e^e<<16))^e<<8))^e<<4))^e<<2)}function removeOneSpacing(e){return e=65535&((e=16711935&((e=252645135&((e=858993459&((e&=1431655765)^e>>1))^e>>2))^e>>4))^e>>8)}function removeTwoSpacing(e){return e=1023&((e=4278190335&((e=50393103&((e=51130563&((e&=153391689)^e>>2))^e>>4))^e>>8))^e>>16)}function NearFarScalar(e,t,i,r){this.near=defaultValue(e,0),this.nearValue=defaultValue(t,0),this.far=defaultValue(i,1),this.farValue=defaultValue(r,0)}MortonOrder.encode2D=function(e,t){return(insertOneSpacing(e)|insertOneSpacing(t)<<1)>>>0},MortonOrder.decode2D=function(e,t){return(t=!defined(t)?new Array(2):t)[0]=removeOneSpacing(e),t[1]=removeOneSpacing(e>>1),t},MortonOrder.encode3D=function(e,t,i){return insertTwoSpacing(e)|insertTwoSpacing(t)<<1|insertTwoSpacing(i)<<2},MortonOrder.decode3D=function(e,t){return(t=!defined(t)?new Array(3):t)[0]=removeTwoSpacing(e),t[1]=removeTwoSpacing(e>>1),t[2]=removeTwoSpacing(e>>2),t},NearFarScalar.clone=function(e,t){if(defined(e))return defined(t)?(t.near=e.near,t.nearValue=e.nearValue,t.far=e.far,t.farValue=e.farValue,t):new NearFarScalar(e.near,e.nearValue,e.far,e.farValue)},NearFarScalar.packedLength=4,NearFarScalar.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i++]=e.nearValue,t[i++]=e.far,t[i]=e.farValue,t},NearFarScalar.unpack=function(e,t,i){return t=defaultValue(t,0),(i=!defined(i)?new NearFarScalar:i).near=e[t++],i.nearValue=e[t++],i.far=e[t++],i.farValue=e[t],i},NearFarScalar.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.nearValue===t.nearValue&&e.far===t.far&&e.farValue===t.farValue},NearFarScalar.prototype.clone=function(e){return NearFarScalar.clone(this,e)},NearFarScalar.prototype.equals=function(e){return NearFarScalar.equals(this,e)};var Visibility={NONE:-1,PARTIAL:0,FULL:1},Visibility$1=Object.freeze(Visibility);function Occluder(e,t){this._occluderPosition=Cartesian3.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=t}var scratchCartesian3$6=new Cartesian3;Object.defineProperties(Occluder.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=Cartesian3.clone(e,this._cameraPosition);var t,i,r,n=Cartesian3.subtract(this._occluderPosition,e,scratchCartesian3$6),a=Cartesian3.magnitudeSquared(n),o=this._occluderRadius*this._occluderRadius;o<a?(t=Math.sqrt(a-o),a=1/Math.sqrt(a),i=Cartesian3.multiplyByScalar(n,a,scratchCartesian3$6),r=Cartesian3.add(e,Cartesian3.multiplyByScalar(i,t*t*a,scratchCartesian3$6),scratchCartesian3$6)):t=Number.MAX_VALUE,this._horizonDistance=t,this._horizonPlaneNormal=i,this._horizonPlanePosition=r,this._cameraPosition=e}}}),Occluder.fromBoundingSphere=function(e,t,i){return defined(i)?(Cartesian3.clone(e.center,i._occluderPosition),i._occluderRadius=e.radius,i.cameraPosition=t,i):new Occluder(e,t)};var tempVecScratch=new Cartesian3;Occluder.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var t=Cartesian3.subtract(e,this._occluderPosition,tempVecScratch),i=this._occluderRadius;if(0<(i=Cartesian3.magnitudeSquared(t)-i*i))return i=Math.sqrt(i)+this._horizonDistance,t=Cartesian3.subtract(e,this._cameraPosition,t),i*i>Cartesian3.magnitudeSquared(t)}return!1};var occludeePositionScratch=new Cartesian3;Occluder.prototype.isBoundingSphereVisible=function(e){var t=Cartesian3.clone(e.center,occludeePositionScratch),i=e.radius;if(this._horizonDistance===Number.MAX_VALUE)return!1;var r=Cartesian3.subtract(t,this._occluderPosition,tempVecScratch),e=this._occluderRadius-i,e=Cartesian3.magnitudeSquared(r)-e*e;if(i<this._occluderRadius)return 0<e&&(e=Math.sqrt(e)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r),e*e+i*i>Cartesian3.magnitudeSquared(r));if(0<e){r=Cartesian3.subtract(t,this._cameraPosition,r),t=Cartesian3.magnitudeSquared(r),r=this._occluderRadius*this._occluderRadius,i=i*i;return(this._horizonDistance*this._horizonDistance+r)*i>t*r?!0:t<(e=Math.sqrt(e)+this._horizonDistance)*e+i}return!0};var tempScratch=new Cartesian3;Occluder.prototype.computeVisibility=function(e){var t=Cartesian3.clone(e.center),i=e.radius;if(i>this._occluderRadius)return Visibility$1.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var r=Cartesian3.subtract(t,this._occluderPosition,tempScratch),n=this._occluderRadius-i,a=Cartesian3.magnitudeSquared(r);if(0<(n=a-n*n)){n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r),e=Cartesian3.magnitudeSquared(r);return n*n+i*i<e?Visibility$1.NONE:0<(n=a-(n=this._occluderRadius+i)*n)?e<(n=Math.sqrt(n)+this._horizonDistance)*n+i*i?Visibility$1.FULL:Visibility$1.PARTIAL:(r=Cartesian3.subtract(t,this._horizonPlanePosition,r),Cartesian3.dot(r,this._horizonPlaneNormal)>-i?Visibility$1.PARTIAL:Visibility$1.FULL)}}return Visibility$1.NONE};var occludeePointScratch=new Cartesian3;Occluder.computeOccludeePoint=function(e,t,i){var r=Cartesian3.clone(t),n=Cartesian3.clone(e.center),t=e.radius,a=i.length,o=Cartesian3.normalize(Cartesian3.subtract(r,n,occludeePointScratch),occludeePointScratch),s=-Cartesian3.dot(o,n),l=Occluder._anyRotationVector(n,o,s),c=Occluder._horizonToPlaneNormalDotProduct(e,o,s,l,i[0]);if(c){for(var u,d=1;d<a;++d){if(!(u=Occluder._horizonToPlaneNormalDotProduct(e,o,s,l,i[d])))return;u<c&&(c=u)}if(!(c<.0017453283658983088))return Cartesian3.add(n,Cartesian3.multiplyByScalar(o,t/c,occludeePointScratch),occludeePointScratch)}};var computeOccludeePointFromRectangleScratch=[];Occluder.computeOccludeePointFromRectangle=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=Rectangle.subsample(e,t,0,computeOccludeePointFromRectangleScratch),r=BoundingSphere.fromPoints(i),e=Cartesian3.ZERO;if(!Cartesian3.equals(e,r.center))return Occluder.computeOccludeePoint(new BoundingSphere(e,t.minimumRadius),r.center,i)};var tempVec0Scratch=new Cartesian3;Occluder._anyRotationVector=function(e,t,i){var r=Cartesian3.abs(t,tempVec0Scratch),n=r.x>r.y?0:1;(0===n&&r.z>r.x||1===n&&r.z>r.y)&&(n=2);var a=new Cartesian3,n=0===n?(r.x=e.x,r.y=e.y+1,r.z=e.z+1,Cartesian3.UNIT_X):1===n?(r.x=e.x+1,r.y=e.y,r.z=e.z+1,Cartesian3.UNIT_Y):(r.x=e.x+1,r.y=e.y+1,r.z=e.z,Cartesian3.UNIT_Z),t=(Cartesian3.dot(t,r)+i)/-Cartesian3.dot(t,n);return Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(r,Cartesian3.multiplyByScalar(n,t,a),r),e,r),r)};var posDirectionScratch=new Cartesian3;Occluder._rotationVector=function(e,t,i,r,n){e=Cartesian3.subtract(r,e,posDirectionScratch),e=Cartesian3.normalize(e,e);if(Cartesian3.dot(t,e)<.9999999847691291){e=Cartesian3.cross(t,e,e);if(Cartesian3.magnitude(e)>CesiumMath.EPSILON13)return Cartesian3.normalize(e,new Cartesian3)}return n};var posScratch1=new Cartesian3,occluerPosScratch=new Cartesian3,posScratch2=new Cartesian3,horizonPlanePosScratch=new Cartesian3;function OffsetGeometryInstanceAttribute(e,t,i){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),this.value=new Float32Array([e,t,i])}function OpenCageGeocoderService(e,t,i){(e=Resource.createIfNeeded(e)).appendForwardSlash(),e.setQueryParameters({key:t}),this._url=e,this._params=defaultValue(i,{})}Occluder._horizonToPlaneNormalDotProduct=function(e,t,i,r,n){var a=Cartesian3.clone(n,posScratch1),o=Cartesian3.clone(e.center,occluerPosScratch),s=e.radius,l=Cartesian3.subtract(o,a,posScratch2),n=Cartesian3.magnitudeSquared(l),e=s*s;if(n<e)return!1;s=n-e,e=Math.sqrt(s),n=e*(1/Math.sqrt(n))*e,l=Cartesian3.normalize(l,l),e=Cartesian3.add(a,Cartesian3.multiplyByScalar(l,n,horizonPlanePosScratch),horizonPlanePosScratch),n=Math.sqrt(s-n*n),r=this._rotationVector(o,t,i,a,r),l=Cartesian3.fromElements(r.x*r.x*l.x+(r.x*r.y-r.z)*l.y+(r.x*r.z+r.y)*l.z,(r.x*r.y+r.z)*l.x+r.y*r.y*l.y+(r.y*r.z-r.x)*l.z,(r.x*r.z-r.y)*l.x+(r.y*r.z+r.x)*l.y+r.z*r.z*l.z,posScratch1),l=Cartesian3.normalize(l,l),l=Cartesian3.multiplyByScalar(l,n,posScratch1),r=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(e,l,posScratch2),o,posScratch2),posScratch2),n=Cartesian3.dot(t,r);r=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.subtract(e,l,r),o,r),r);r=Cartesian3.dot(t,r);return n<r?n:r},Object.defineProperties(OffsetGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),OffsetGeometryInstanceAttribute.fromCartesian3=function(e){return new OffsetGeometryInstanceAttribute(e.x,e.y,e.z)},OffsetGeometryInstanceAttribute.toValue=function(e,t){return(t=!defined(t)?new Float32Array([e.x,e.y,e.z]):t)[0]=e.x,t[1]=e.y,t[2]=e.z,t},Object.defineProperties(OpenCageGeocoderService.prototype,{url:{get:function(){return this._url}},params:{get:function(){return this._params}}}),OpenCageGeocoderService.prototype.geocode=function(e){return this._url.getDerivedResource({url:"json",queryParameters:combine$2(this._params,{q:e})}).fetchJson().then(function(e){return e.results.map(function(e){var t,i=e.bounds;return t=defined(i)?Rectangle.fromDegrees(i.southwest.lng,i.southwest.lat,i.northeast.lng,i.northeast.lat):(i=e.geometry.lat,t=e.geometry.lng,Cartesian3.fromDegrees(i,t)),{displayName:e.formatted,destination:t}})})};var Packable={packedLength:void 0,pack:DeveloperError.throwInstantiationError,unpack:DeveloperError.throwInstantiationError},PackableForInterpolation={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:DeveloperError.throwInstantiationError,unpackInterpolationResult:DeveloperError.throwInstantiationError},imageSmoothingEnabledName;function measureText(e,t,i,r,n){var a=e.measureText(t);if(!/\S/.test(t))return{width:a.width,height:0,ascent:0,descent:0,minx:0};var o=document.defaultView.getComputedStyle(e.canvas).getPropertyValue("font-size").replace("px",""),s=document.createElement("canvas"),l=a.width+100|0,c=3*o,u=c/2;s.width=l,s.height=c;o=s.getContext("2d");o.font=i,o.fillStyle="white",o.fillRect(0,0,s.width+1,s.height+1),r&&(o.strokeStyle="black",o.lineWidth=e.lineWidth,o.strokeText(t,50,u)),n&&(o.fillStyle="black",o.fillText(t,50,u));for(var d,h,p,f=o.getImageData(0,0,l,c).data,m=f.length,g=4*l,_=0;_<m;++_)if(255!==f[_]){h=_/g|0;break}for(_=m-1;0<=_;--_)if(255!==f[_]){p=_/g|0;break}var y=-1;for(_=0;_<l&&-1===y;++_)for(d=0;d<c;++d){var C=4*_+d*g;if(255!==f[C]||255!==f[1+C]||255!==f[2+C]||255!==f[3+C]){y=_;break}}return{width:a.width,height:p-h,ascent:u-h,descent:p-u,minx:y-50}}function writeTextToCanvas(e,t){if(""!==e){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.font,"10px sans-serif"),r=defaultValue(t.stroke,!1),n=defaultValue(t.fill,!0),a=defaultValue(t.strokeWidth,1),o=defaultValue(t.backgroundColor,Color.TRANSPARENT),s=defaultValue(t.padding,0),l=2*s,c=document.createElement("canvas");c.width=1,c.height=1,c.style.font=i;var u=c.getContext("2d");defined(imageSmoothingEnabledName)||(defined(u.imageSmoothingEnabled)?imageSmoothingEnabledName="imageSmoothingEnabled":defined(u.mozImageSmoothingEnabled)?imageSmoothingEnabledName="mozImageSmoothingEnabled":defined(u.webkitImageSmoothingEnabled)?imageSmoothingEnabledName="webkitImageSmoothingEnabled":defined(u.msImageSmoothingEnabled)&&(imageSmoothingEnabledName="msImageSmoothingEnabled")),u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,c.style.visibility="hidden",document.body.appendChild(c);var d=measureText(u,e,i,r,n);c.dimensions=d,document.body.removeChild(c),c.style.visibility="";var h=-d.minx,p=Math.ceil(d.width)+h+l,f=d.height+l,l=f-(f-d.ascent+s)+l;return c.width=p,c.height=f,u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,o!==Color.TRANSPARENT&&(u.fillStyle=o.toCssColorString(),u.fillRect(0,0,c.width,c.height)),r&&(r=defaultValue(t.strokeColor,Color.BLACK),u.strokeStyle=r.toCssColorString(),u.strokeText(e,h+s,l)),n&&(t=defaultValue(t.fillColor,Color.WHITE),u.fillStyle=t.toCssColorString(),u.fillText(e,h+s,l)),c}}function PinBuilder(){this._cache={}}PinBuilder.prototype.fromColor=function(e,t){return createPin(void 0,void 0,e,t,this._cache)},PinBuilder.prototype.fromUrl=function(e,t,i){return createPin(e,void 0,t,i,this._cache)},PinBuilder.prototype.fromMakiIconId=function(e,t,i){return createPin(buildModuleUrl("Assets/Textures/maki/"+encodeURIComponent(e)+".png"),void 0,t,i,this._cache)},PinBuilder.prototype.fromText=function(e,t,i){return createPin(void 0,e,t,i,this._cache)};var colorScratch$7=new Color;function drawPin(e,t,i){e.save(),e.scale(i/24,i/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,colorScratch$7).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function drawIcon(e,t,i){var r=i/2.5,n=r,a=r;t.width>t.height?a=r*(t.height/t.width):t.width<t.height&&(n=r*(t.width/t.height));r=Math.round((i-n)/2),i=Math.round(7/24*i-a/2);e.globalCompositeOperation="destination-out",e.drawImage(t,r-1,i,n,a),e.drawImage(t,r,i-1,n,a),e.drawImage(t,r+1,i,n,a),e.drawImage(t,r,i+1,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.BLACK.toCssColorString(),e.fillRect(r-1,i-1,n+2,a+2),e.globalCompositeOperation="destination-out",e.drawImage(t,r,i,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.WHITE.toCssColorString(),e.fillRect(r-1,i-2,n+2,a+2)}var stringifyScratch=new Array(4);function createPin(e,t,i,r,n){stringifyScratch[0]=e,stringifyScratch[1]=t,stringifyScratch[2]=i,stringifyScratch[3]=r;var a=JSON.stringify(stringifyScratch),o=n[a];if(defined(o))return o;var s=document.createElement("canvas");s.width=r,s.height=r;var l=s.getContext("2d");if(drawPin(l,i,r),defined(e)){e=Resource.createIfNeeded(e).fetchImage().then(function(e){return drawIcon(l,e,r),n[a]=s});return n[a]=e}return defined(t)&&(t=writeTextToCanvas(t,{font:"bold "+r+"px sans-serif"}),drawIcon(l,t,r)),n[a]=s}var PixelDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES,UNSIGNED_INT_24_8:WebGLConstants$1.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:WebGLConstants$1.UNSIGNED_SHORT_5_6_5,toWebGLConstant:function(e,t){switch(e){case PixelDatatype.UNSIGNED_BYTE:return WebGLConstants$1.UNSIGNED_BYTE;case PixelDatatype.UNSIGNED_SHORT:return WebGLConstants$1.UNSIGNED_SHORT;case PixelDatatype.UNSIGNED_INT:return WebGLConstants$1.UNSIGNED_INT;case PixelDatatype.FLOAT:return WebGLConstants$1.FLOAT;case PixelDatatype.HALF_FLOAT:return t.webgl2?WebGLConstants$1.HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES;case PixelDatatype.UNSIGNED_INT_24_8:return WebGLConstants$1.UNSIGNED_INT_24_8;case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:return WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4;case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:return WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1;case PixelDatatype.UNSIGNED_SHORT_5_6_5:return PixelDatatype.UNSIGNED_SHORT_5_6_5}},isPacked:function(e){return e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case PixelDatatype.UNSIGNED_BYTE:return 1;case PixelDatatype.UNSIGNED_SHORT:case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:case PixelDatatype.UNSIGNED_SHORT_5_6_5:case PixelDatatype.HALF_FLOAT:return 2;case PixelDatatype.UNSIGNED_INT:case PixelDatatype.FLOAT:case PixelDatatype.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===PixelDatatype.UNSIGNED_BYTE||e===PixelDatatype.UNSIGNED_SHORT||e===PixelDatatype.UNSIGNED_INT||e===PixelDatatype.FLOAT||e===PixelDatatype.HALF_FLOAT||e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5}},PixelDatatype$1=Object.freeze(PixelDatatype),PixelFormat={DEPTH_COMPONENT:WebGLConstants$1.DEPTH_COMPONENT,DEPTH_STENCIL:WebGLConstants$1.DEPTH_STENCIL,ALPHA:WebGLConstants$1.ALPHA,RGB:WebGLConstants$1.RGB,RGBA:WebGLConstants$1.RGBA,LUMINANCE:WebGLConstants$1.LUMINANCE,LUMINANCE_ALPHA:WebGLConstants$1.LUMINANCE_ALPHA,RGB_DXT1:WebGLConstants$1.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGBA_ASTC:WebGLConstants$1.COMPRESSED_RGBA_ASTC_4x4_WEBGL,RGB_ETC1:WebGLConstants$1.COMPRESSED_RGB_ETC1_WEBGL,RGB8_ETC2:WebGLConstants$1.COMPRESSED_RGB8_ETC2,RGBA8_ETC2_EAC:WebGLConstants$1.COMPRESSED_RGBA8_ETC2_EAC,RGBA_BC7:WebGLConstants$1.COMPRESSED_RGBA_BPTC_UNORM,componentsLength:function(e){switch(e){case PixelFormat.RGB:return 3;case PixelFormat.RGBA:return 4;case PixelFormat.LUMINANCE_ALPHA:return 2;case PixelFormat.ALPHA:case PixelFormat.LUMINANCE:default:return 1}},validate:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL||e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA||e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isColorFormat:function(e){return e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL},isCompressedFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isDXTFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5},isPVRTCFormat:function(e){return e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1},isASTCFormat:function(e){return e===PixelFormat.RGBA_ASTC},isETC1Format:function(e){return e===PixelFormat.RGB_ETC1},isETC2Format:function(e){return e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC},isBC7Format:function(e){return e===PixelFormat.RGBA_BC7},compressedTextureSizeInBytes:function(e,t,i){switch(e){case PixelFormat.RGB_DXT1:case PixelFormat.RGBA_DXT1:case PixelFormat.RGB_ETC1:case PixelFormat.RGB8_ETC2:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case PixelFormat.RGBA_DXT3:case PixelFormat.RGBA_DXT5:case PixelFormat.RGBA_ASTC:case PixelFormat.RGBA8_ETC2_EAC:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case PixelFormat.RGB_PVRTC_4BPPV1:case PixelFormat.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(i,8)*4+7)/8);case PixelFormat.RGB_PVRTC_2BPPV1:case PixelFormat.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(i,8)*2+7)/8);case PixelFormat.RGBA_BC7:return Math.ceil(t/4)*Math.ceil(i/4)*16;default:return 0}},textureSizeInBytes:function(e,t,i,r){e=PixelFormat.componentsLength(e);return(e=PixelDatatype$1.isPacked(t)?1:e)*PixelDatatype$1.sizeInBytes(t)*i*r},alignmentInBytes:function(e,t,i){i=PixelFormat.textureSizeInBytes(e,t,i,1)%4;return 0==i?4:2==i?2:1},createTypedArray:function(e,t,i,r){var n=PixelDatatype$1.sizeInBytes(t),t=n===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:n===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:n===Float32Array.BYTES_PER_ELEMENT&&t===PixelDatatype$1.FLOAT?Float32Array:Uint32Array;return new t(PixelFormat.componentsLength(e)*i*r)},flipY:function(e,t,i,r,n){if(1===n)return e;for(var a=PixelFormat.createTypedArray(t,i,r,n),o=PixelFormat.componentsLength(t),s=r*o,l=0;l<n;++l)for(var c=l*r*o,u=(n-l-1)*r*o,d=0;d<s;++d)a[u+d]=e[c+d];return a},toInternalFormat:function(e,t,i){if(!i.webgl2)return e;if(e===PixelFormat.DEPTH_STENCIL)return WebGLConstants$1.DEPTH24_STENCIL8;if(e===PixelFormat.DEPTH_COMPONENT){if(t===PixelDatatype$1.UNSIGNED_SHORT)return WebGLConstants$1.DEPTH_COMPONENT16;if(t===PixelDatatype$1.UNSIGNED_INT)return WebGLConstants$1.DEPTH_COMPONENT24}if(t===PixelDatatype$1.FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA32F;case PixelFormat.RGB:return WebGLConstants$1.RGB32F;case PixelFormat.RG:return WebGLConstants$1.RG32F;case PixelFormat.R:return WebGLConstants$1.R32F}if(t===PixelDatatype$1.HALF_FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA16F;case PixelFormat.RGB:return WebGLConstants$1.RGB16F;case PixelFormat.RG:return WebGLConstants$1.RG16F;case PixelFormat.R:return WebGLConstants$1.R16F}return e}},PixelFormat$1=Object.freeze(PixelFormat);function PlaneGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);e=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=e,this._workerName="createPlaneGeometry"}PlaneGeometry.packedLength=VertexFormat.packedLength,PlaneGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),t};var scratchVertexFormat$5=new VertexFormat,scratchOptions$9={vertexFormat:scratchVertexFormat$5};PlaneGeometry.unpack=function(e,t,i){t=defaultValue(t,0);t=VertexFormat.unpack(e,t,scratchVertexFormat$5);return defined(i)?(i._vertexFormat=VertexFormat.clone(t,i._vertexFormat),i):new PlaneGeometry(scratchOptions$9)};var min$1=new Cartesian3(-.5,-.5,0),max$1=new Cartesian3(.5,.5,0);function PlaneOutlineGeometry(){this._workerName="createPlaneOutlineGeometry"}PlaneGeometry.createGeometry=function(e){var t,i,r=e._vertexFormat,n=new GeometryAttributes;return r.position&&((e=new Float64Array(12))[0]=min$1.x,e[1]=min$1.y,e[2]=0,e[3]=max$1.x,e[4]=min$1.y,e[5]=0,e[6]=max$1.x,e[7]=max$1.y,e[8]=0,e[9]=min$1.x,e[10]=max$1.y,e[11]=0,n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}),r.normal&&((e=new Float32Array(12))[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=1,e[9]=0,e[10]=0,e[11]=1,n.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})),r.st&&((t=new Float32Array(8))[0]=0,t[1]=0,t[2]=1,t[3]=0,t[4]=1,t[5]=1,t[6]=0,t[7]=1,n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:t})),r.tangent&&((t=new Float32Array(12))[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=1,t[7]=0,t[8]=0,t[9]=1,t[10]=0,t[11]=0,n.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t})),r.bitangent&&((i=new Float32Array(12))[0]=0,i[1]=1,i[2]=0,i[3]=0,i[4]=1,i[5]=0,i[6]=0,i[7]=1,i[8]=0,i[9]=0,i[10]=1,i[11]=0,n.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:i})),(i=new Uint16Array(6))[0]=0,i[1]=1,i[2]=2,i[3]=0,i[4]=2,i[5]=3),new Geometry({attributes:n,indices:i,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})},PlaneOutlineGeometry.packedLength=0,PlaneOutlineGeometry.pack=function(e,t){return t},PlaneOutlineGeometry.unpack=function(e,t,i){return defined(i)?i:new PlaneOutlineGeometry};var min=new Cartesian3(-.5,-.5,0),max=new Cartesian3(.5,.5,0);PlaneOutlineGeometry.createGeometry=function(){var e=new GeometryAttributes,t=new Uint16Array(8),i=new Float64Array(12);return i[0]=min.x,i[1]=min.y,i[2]=min.z,i[3]=max.x,i[4]=min.y,i[5]=min.z,i[6]=max.x,i[7]=max.y,i[8]=min.z,i[9]=min.x,i[10]=max.y,i[11]=min.z,e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),t[0]=0,t[1]=1,t[2]=1,t[3]=2,t[4]=2,t[5]=3,t[6]=3,t[7]=0,new Geometry({attributes:e,indices:t,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})};var scratchCarto1=new Cartographic,scratchCarto2=new Cartographic;function adjustPosHeightsForNormal(e,t,i,r){var n=r.cartesianToCartographic(e,scratchCarto1).height,e=r.cartesianToCartographic(t,scratchCarto2);e.height=n,r.cartographicToCartesian(e,t);t=r.cartesianToCartographic(i,scratchCarto2);t.height=n-100,r.cartographicToCartesian(t,i)}var scratchBoundingRectangle=new BoundingRectangle,scratchPosition$9=new Cartesian3,scratchNormal$2=new Cartesian3,scratchTangent$1=new Cartesian3,scratchBitangent$1=new Cartesian3,p1Scratch=new Cartesian3,p2Scratch=new Cartesian3,scratchPerPosNormal=new Cartesian3,scratchPerPosTangent=new Cartesian3,scratchPerPosBitangent=new Cartesian3,appendTextureCoordinatesOrigin=new Cartesian2,appendTextureCoordinatesCartesian2=new Cartesian2,appendTextureCoordinatesCartesian3=new Cartesian3,appendTextureCoordinatesQuaternion=new Quaternion,appendTextureCoordinatesMatrix3=new Matrix3,tangentMatrixScratch=new Matrix3;function computeAttributes$2(e){var t=e.vertexFormat,i=e.geometry,r=e.shadowVolume,n=i.attributes.position.values,a=n.length,o=e.wall,s=e.top||o,l=e.bottom||o;if(t.st||t.normal||t.tangent||t.bitangent||r){var c=e.boundingRectangle,u=e.tangentPlane,d=e.ellipsoid,h=e.stRotation,p=e.perPositionHeight,f=appendTextureCoordinatesOrigin;f.x=c.x,f.y=c.y;var m,g=t.st?new Float32Array(a/3*2):void 0;t.normal&&(m=p&&s&&!o?i.attributes.normal.values:new Float32Array(a));var _,y=t.tangent?new Float32Array(a):void 0,C=t.bitangent?new Float32Array(a):void 0,v=r?new Float32Array(a):void 0,T=0,S=0,A=scratchNormal$2,x=scratchTangent$1,b=scratchBitangent$1,E=!0,P=appendTextureCoordinatesMatrix3,D=tangentMatrixScratch;D=0!==h?(_=Quaternion.fromAxisAngle(u._plane.normal,h,appendTextureCoordinatesQuaternion),P=Matrix3.fromQuaternion(_,P),_=Quaternion.fromAxisAngle(u._plane.normal,-h,appendTextureCoordinatesQuaternion),Matrix3.fromQuaternion(_,D)):(P=Matrix3.clone(Matrix3.IDENTITY,P),Matrix3.clone(Matrix3.IDENTITY,D));var w=0,M=0;s&&l&&(w=a/2,M=a/3,a/=2);for(var I=0;I<a;I+=3){var R,O,B,L,F=Cartesian3.fromArray(n,I,appendTextureCoordinatesCartesian3);t.st&&(R=Matrix3.multiplyByVector(P,F,scratchPosition$9),R=d.scaleToGeodeticSurface(R,R),O=u.projectPointOntoPlane(R,appendTextureCoordinatesCartesian2),Cartesian2.subtract(O,f,O),B=CesiumMath.clamp(O.x/c.width,0,1),L=CesiumMath.clamp(O.y/c.height,0,1),l&&(g[T+M]=B,g[T+1+M]=L),s&&(g[T]=B,g[T+1]=L),T+=2),(t.normal||t.tangent||t.bitangent||r)&&(R=S+1,O=S+2,o?(I+3<a&&(B=Cartesian3.fromArray(n,I+3,p1Scratch),E&&(L=Cartesian3.fromArray(n,I+a,p2Scratch),p&&adjustPosHeightsForNormal(F,B,L,d),Cartesian3.subtract(B,F,B),Cartesian3.subtract(L,F,L),A=Cartesian3.normalize(Cartesian3.cross(L,B,A),A),E=!1),Cartesian3.equalsEpsilon(B,F,CesiumMath.EPSILON10)&&(E=!0)),(t.tangent||t.bitangent)&&(b=d.geodeticSurfaceNormal(F,b),t.tangent&&(x=Cartesian3.normalize(Cartesian3.cross(b,A,x),x)))):(A=d.geodeticSurfaceNormal(F,A),(t.tangent||t.bitangent)&&(p&&(scratchPerPosNormal=Cartesian3.fromArray(m,S,scratchPerPosNormal),scratchPerPosTangent=Cartesian3.cross(Cartesian3.UNIT_Z,scratchPerPosNormal,scratchPerPosTangent),scratchPerPosTangent=Cartesian3.normalize(Matrix3.multiplyByVector(D,scratchPerPosTangent,scratchPerPosTangent),scratchPerPosTangent),t.bitangent&&(scratchPerPosBitangent=Cartesian3.normalize(Cartesian3.cross(scratchPerPosNormal,scratchPerPosTangent,scratchPerPosBitangent),scratchPerPosBitangent))),x=Cartesian3.cross(Cartesian3.UNIT_Z,A,x),x=Cartesian3.normalize(Matrix3.multiplyByVector(D,x,x),x),t.bitangent&&(b=Cartesian3.normalize(Cartesian3.cross(A,x,b),b)))),t.normal&&(e.wall?(m[S+w]=A.x,m[R+w]=A.y,m[O+w]=A.z):l&&(m[S+w]=-A.x,m[R+w]=-A.y,m[O+w]=-A.z),(s&&!p||o)&&(m[S]=A.x,m[R]=A.y,m[O]=A.z)),r&&(o&&(A=d.geodeticSurfaceNormal(F,A)),v[S+w]=-A.x,v[R+w]=-A.y,v[O+w]=-A.z),t.tangent&&(e.wall?(y[S+w]=x.x,y[R+w]=x.y,y[O+w]=x.z):l&&(y[S+w]=-x.x,y[R+w]=-x.y,y[O+w]=-x.z),s&&(p?(y[S]=scratchPerPosTangent.x,y[R]=scratchPerPosTangent.y,y[O]=scratchPerPosTangent.z):(y[S]=x.x,y[R]=x.y,y[O]=x.z))),t.bitangent&&(l&&(C[S+w]=b.x,C[R+w]=b.y,C[O+w]=b.z),s&&(p?(C[S]=scratchPerPosBitangent.x,C[R]=scratchPerPosBitangent.y,C[O]=scratchPerPosBitangent.z):(C[S]=b.x,C[R]=b.y,C[O]=b.z))),S+=3)}t.st&&(i.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:g})),t.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),t.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),t.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C})),r&&(i.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}))}return e.extrude&&defined(e.offsetAttribute)&&(h=n.length/3,_=new Uint8Array(h),e.offsetAttribute===GeometryOffsetAttribute$1.TOP?s&&l||o?_=arrayFill(_,1,0,h/2):s&&(_=arrayFill(_,1)):_=arrayFill(_,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),i.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:_})),i}var startCartographicScratch=new Cartographic,endCartographicScratch=new Cartographic,idlCross={westOverIDL:0,eastOverIDL:0},ellipsoidGeodesic=new EllipsoidGeodesic;function computeRectangle$1(e,t,i,r,n){if(n=defaultValue(n,new Rectangle),!defined(e)||e.length<3)return n.west=0,n.north=0,n.south=0,n.east=0,n;if(i===ArcType$1.RHUMB)return Rectangle.fromCartesianArray(e,t,n);ellipsoidGeodesic.ellipsoid.equals(t)||(ellipsoidGeodesic=new EllipsoidGeodesic(void 0,void 0,t)),n.west=Number.POSITIVE_INFINITY,n.east=Number.NEGATIVE_INFINITY,n.south=Number.POSITIVE_INFINITY,n.north=Number.NEGATIVE_INFINITY,idlCross.westOverIDL=Number.POSITIVE_INFINITY,idlCross.eastOverIDL=Number.NEGATIVE_INFINITY;for(var a,o=1/CesiumMath.chordLength(r,t.maximumRadius),s=e.length,l=t.cartesianToCartographic(e[0],endCartographicScratch),c=startCartographicScratch,u=1;u<s;u++)a=c,c=l,l=t.cartesianToCartographic(e[u],a),ellipsoidGeodesic.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic,o,n,idlCross);return a=c,c=l,l=t.cartesianToCartographic(e[0],a),ellipsoidGeodesic.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic,o,n,idlCross),n.east-n.west>idlCross.eastOverIDL-idlCross.westOverIDL&&(n.west=idlCross.westOverIDL,n.east=idlCross.eastOverIDL,n.east>CesiumMath.PI&&(n.east=n.east-CesiumMath.TWO_PI),n.west>CesiumMath.PI&&(n.west=n.west-CesiumMath.TWO_PI)),n}var interpolatedCartographicScratch=new Cartographic;function interpolateAndGrowRectangle(e,t,i,r){for(var n=e.surfaceDistance,a=Math.ceil(n*t),o=0<a?n/(a-1):Number.POSITIVE_INFINITY,s=0,l=0;l<a;l++){var c=e.interpolateUsingSurfaceDistance(s,interpolatedCartographicScratch);s+=o;var u=c.longitude,c=c.latitude;i.west=Math.min(i.west,u),i.east=Math.max(i.east,u),i.south=Math.min(i.south,c),i.north=Math.max(i.north,c);u=0<=u?u:u+CesiumMath.TWO_PI;r.westOverIDL=Math.min(r.westOverIDL,u),r.eastOverIDL=Math.max(r.eastOverIDL,u)}}var createGeometryFromPositionsExtrudedPositions=[];function createGeometryFromPositionsExtruded$1(e,t,i,r,n,a,o,s,l){var c={walls:[]};if(a||o){var u=PolygonGeometryLibrary.createGeometryFromPositions(e,t,i,n,s,l),t=u.attributes.position.values,d=u.indices;if(a&&o){var h,a=t.concat(t),p=a.length/3;(h=IndexDatatype$1.createTypedArray(p,2*d.length)).set(d);for(var f=d.length,m=p/2,g=0;g<f;g+=3){var _=h[g]+m,y=h[g+1]+m,C=h[g+2]+m;h[g+f]=C,h[g+1+f]=y,h[g+2+f]=_}u.attributes.position.values=a,n&&s.normal&&(s=u.attributes.normal.values,u.attributes.normal.values=new Float32Array(a.length),u.attributes.normal.values.set(s)),u.indices=h}else if(o){for(p=t.length/3,h=IndexDatatype$1.createTypedArray(p,d.length),g=0;g<d.length;g+=3)h[g]=d[g+2],h[g+1]=d[g+1],h[g+2]=d[g];u.indices=h}c.topAndBottom=new GeometryInstance({geometry:u})}var u=r.outerRing,v=EllipsoidTangentPlane.fromPoints(u,e).projectPointsOntoPlane(u,createGeometryFromPositionsExtrudedPositions);PolygonPipeline.computeWindingOrder2D(v)===WindingOrder$1.CLOCKWISE&&(u=u.slice().reverse());var T=PolygonGeometryLibrary.computeWallGeometry(u,e,i,n,l);c.walls.push(new GeometryInstance({geometry:T}));var S=r.holes;for(g=0;g<S.length;g++){var A=S[g],v=EllipsoidTangentPlane.fromPoints(A,e).projectPointsOntoPlane(A,createGeometryFromPositionsExtrudedPositions);PolygonPipeline.computeWindingOrder2D(v)===WindingOrder$1.COUNTER_CLOCKWISE&&(A=A.slice().reverse()),T=PolygonGeometryLibrary.computeWallGeometry(A,e,i,n,l),c.walls.push(new GeometryInstance({geometry:T}))}return c}function PolygonGeometry(e){var t,i=e.polygonHierarchy,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.stRotation,0),s=defaultValue(e.perPositionHeight,!1),l=s&&defined(e.extrudedHeight),c=defaultValue(e.height,0),u=defaultValue(e.extrudedHeight,c);l||(t=Math.max(c,u),u=Math.min(c,u),c=t),this._vertexFormat=VertexFormat.clone(r),this._ellipsoid=Ellipsoid.clone(n),this._granularity=a,this._stRotation=o,this._height=c,this._extrudedHeight=u,this._closeTop=defaultValue(e.closeTop,!0),this._closeBottom=defaultValue(e.closeBottom,!0),this._polygonHierarchy=i,this._perPositionHeight=s,this._perPositionHeightExtrude=l,this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(i)+Ellipsoid.packedLength+VertexFormat.packedLength+12}PolygonGeometry.fromPositions=function(e){return new PolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute,arcType:e.arcType})},PolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._stRotation,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._closeTop?1:0,t[i++]=e._closeBottom?1:0,t[i++]=e._shadowVolume?1:0,t[i++]=defaultValue(e._offsetAttribute,-1),t[i++]=e._arcType,t[i]=e.packedLength,t};var scratchEllipsoid$9=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$4=new VertexFormat,dummyOptions$1={polygonHierarchy:{}};function textureCoordinateRotationPoints$1(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];var i=e._ellipsoid,r=e._polygonHierarchy.positions,e=e.rectangle;return Geometry._textureCoordinateRotationPoints(r,t,i,e)}function PolygonHierarchy(e,t){this.positions=defined(e)?e:[],this.holes=defined(t)?t:[]}PolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$9);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$4);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=1===e[t++],d=1===e[t++],h=1===e[t++],p=1===e[t++],f=1===e[t++],m=e[t++],g=e[t++],t=e[t];return(i=!defined(i)?new PolygonGeometry(dummyOptions$1):i)._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._height=o,i._extrudedHeight=s,i._granularity=l,i._stRotation=c,i._perPositionHeightExtrude=u,i._perPositionHeight=d,i._closeTop=h,i._closeBottom=p,i._shadowVolume=f,i._offsetAttribute=-1===m?void 0:m,i._arcType=g,i.packedLength=t,i},PolygonGeometry.computeRectangle=function(e,t){var i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.arcType,ArcType$1.GEODESIC),n=e.polygonHierarchy,e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$1(n.positions,e,r,i,t)},PolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._ellipsoid,r=e._granularity,n=e._stRotation,a=e._polygonHierarchy,o=e._perPositionHeight,s=e._closeTop,l=e._closeBottom,c=e._arcType;if(!((f=a.positions).length<3)){var u=EllipsoidTangentPlane.fromPoints(f,i),a=PolygonGeometryLibrary.polygonsFromHierarchy(a,u.projectPointsOntoPlane.bind(u),!o,i),d=a.hierarchy,h=a.polygons;if(0!==d.length){var p,f=d[0].outerRing,f=PolygonGeometryLibrary.computeBoundingRectangle(u.plane.normal,u.projectPointOntoPlane.bind(u),f,n,scratchBoundingRectangle),m=[],g=e._height,_=e._extrudedHeight,y={perPositionHeight:o,vertexFormat:t,geometry:void 0,tangentPlane:u,boundingRectangle:f,ellipsoid:i,stRotation:n,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:c};if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(g,_,0,CesiumMath.EPSILON2))for(y.extrude=!0,y.top=s,y.bottom=l,y.shadowVolume=e._shadowVolume,y.offsetAttribute=e._offsetAttribute,p=0;p<h.length;p++){var C,v=createGeometryFromPositionsExtruded$1(i,h[p],r,d[p],o,s,l,t,c);s&&l?(C=v.topAndBottom,y.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(C.geometry,g,_,i,o)):s?((C=v.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(C.geometry.attributes.position.values,g,i,!o),y.geometry=C.geometry):l&&((C=v.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(C.geometry.attributes.position.values,_,i,!0),y.geometry=C.geometry),(s||l)&&(y.wall=!1,C.geometry=computeAttributes$2(y),m.push(C));var T=v.walls;y.wall=!0;for(var S=0;S<T.length;S++){var A=T[S];y.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(A.geometry,g,_,i,o),A.geometry=computeAttributes$2(y),m.push(A)}}else for(p=0;p<h.length;p++){var x,b=new GeometryInstance({geometry:PolygonGeometryLibrary.createGeometryFromPositions(i,h[p],r,o,t,c)});b.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(b.geometry.attributes.position.values,g,i,!o),y.geometry=b.geometry,b.geometry=computeAttributes$2(y),defined(e._offsetAttribute)&&(x=b.geometry.attributes.position.values.length,arrayFill(x=new Uint8Array(x/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),b.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:x})),m.push(b)}u=GeometryPipeline.combineInstances(m)[0];u.attributes.position.values=new Float64Array(u.attributes.position.values),u.indices=IndexDatatype$1.createTypedArray(u.attributes.position.values.length/3,u.indices);f=u.attributes,n=BoundingSphere.fromVertices(f.position.values);return t.position||delete f.position,new Geometry({attributes:f,indices:u.indices,primitiveType:u.primitiveType,boundingSphere:n,offsetAttribute:e._offsetAttribute})}}},PolygonGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new PolygonGeometry({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:r,perPositionHeight:!1,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},Object.defineProperties(PolygonGeometry.prototype,{rectangle:{get:function(){var e;return defined(this._rectangle)||(e=this._polygonHierarchy.positions,this._rectangle=computeRectangle$1(e,this._ellipsoid,this._arcType,this._granularity)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$1(this)),this._textureCoordinateRotationPoints}}});var createGeometryFromPositionsPositions=[],createGeometryFromPositionsSubdivided=[];function createGeometryFromPositions(e,t,i,r,n){var a,o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());var s=t.length,l=0;if(r)for(a=new Float64Array(2*s*3),g=0;g<s;g++){var c=t[g],u=t[(g+1)%s];a[l++]=c.x,a[l++]=c.y,a[l++]=c.z,a[l++]=u.x,a[l++]=u.y,a[l++]=u.z}else{var d,h=0;if(n===ArcType$1.GEODESIC)for(g=0;g<s;g++)h+=PolygonGeometryLibrary.subdivideLineCount(t[g],t[(g+1)%s],i);else if(n===ArcType$1.RHUMB)for(g=0;g<s;g++)h+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[g],t[(g+1)%s],i);for(a=new Float64Array(3*h),g=0;g<s;g++){n===ArcType$1.GEODESIC?d=PolygonGeometryLibrary.subdivideLine(t[g],t[(g+1)%s],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(d=PolygonGeometryLibrary.subdivideRhumbLine(e,t[g],t[(g+1)%s],i,createGeometryFromPositionsSubdivided));for(var p=d.length,f=0;f<p;++f)a[l++]=d[f]}}for(var s=a.length/3,m=IndexDatatype$1.createTypedArray(s,2*s),l=0,g=0;g<s-1;g++)m[l++]=g,m[l++]=g+1;return m[l++]=s-1,m[l++]=0,new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:m,primitiveType:PrimitiveType$1.LINES})})}function createGeometryFromPositionsExtruded(e,t,i,r,n){var a,o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());var s=t.length,l=new Array(s),c=0;if(r)for(a=new Float64Array(2*s*3*2),y=0;y<s;++y){l[y]=c/3;var u=t[y],d=t[(y+1)%s];a[c++]=u.x,a[c++]=u.y,a[c++]=u.z,a[c++]=d.x,a[c++]=d.y,a[c++]=d.z}else{var h,p=0;if(n===ArcType$1.GEODESIC)for(y=0;y<s;y++)p+=PolygonGeometryLibrary.subdivideLineCount(t[y],t[(y+1)%s],i);else if(n===ArcType$1.RHUMB)for(y=0;y<s;y++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[y],t[(y+1)%s],i);for(a=new Float64Array(3*p*2),y=0;y<s;++y){l[y]=c/3,n===ArcType$1.GEODESIC?h=PolygonGeometryLibrary.subdivideLine(t[y],t[(y+1)%s],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(h=PolygonGeometryLibrary.subdivideRhumbLine(e,t[y],t[(y+1)%s],i,createGeometryFromPositionsSubdivided));for(var f=h.length,m=0;m<f;++m)a[c++]=h[m]}}for(var s=a.length/6,g=l.length,_=IndexDatatype$1.createTypedArray(s+g,2*(2*s+g)),c=0,y=0;y<s;++y)_[c++]=y,_[c++]=(y+1)%s,_[c++]=y+s,_[c++]=(y+1)%s+s;for(y=0;y<g;y++){var C=l[y];_[c++]=C,_[c++]=C+s}return new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.LINES})})}function PolygonOutlineGeometry(e){var t,i=e.polygonHierarchy,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.perPositionHeight,!1),o=a&&defined(e.extrudedHeight),s=defaultValue(e.arcType,ArcType$1.GEODESIC),l=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,l);o||(t=Math.max(l,c),c=Math.min(l,c),l=t),this._ellipsoid=Ellipsoid.clone(r),this._granularity=n,this._height=l,this._extrudedHeight=c,this._arcType=s,this._polygonHierarchy=i,this._perPositionHeight=a,this._perPositionHeightExtrude=o,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(i)+Ellipsoid.packedLength+8}PolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._arcType,t[i++]=defaultValue(e._offsetAttribute,-1),t[i]=e.packedLength,t};var scratchEllipsoid$8=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),dummyOptions={polygonHierarchy:{}};PolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$8);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=1===e[t++],c=1===e[t++],u=e[t++],d=e[t++],t=e[t];return(i=!defined(i)?new PolygonOutlineGeometry(dummyOptions):i)._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._height=a,i._extrudedHeight=o,i._granularity=s,i._perPositionHeight=c,i._perPositionHeightExtrude=l,i._arcType=u,i._offsetAttribute=-1===d?void 0:d,i.packedLength=t,i},PolygonOutlineGeometry.fromPositions=function(e){return new PolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},PolygonOutlineGeometry.createGeometry=function(e){var t=e._ellipsoid,i=e._granularity,r=e._polygonHierarchy,n=e._perPositionHeight,a=e._arcType,o=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(r,!n,t);if(0!==o.length){var s,l,c,u,d,h=[],p=CesiumMath.chordLength(i,t.maximumRadius),f=e._height,m=e._extrudedHeight;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(f,m,0,CesiumMath.EPSILON2))for(s=0;s<o.length;s++)(u=createGeometryFromPositionsExtruded(t,o[s],p,n,a)).geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(u.geometry,f,m,t,n),defined(e._offsetAttribute)&&(l=u.geometry.attributes.position.values.length/3,c=new Uint8Array(l),c=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(c,1,0,l/2):arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})),h.push(u);else for(s=0;s<o.length;s++)(u=createGeometryFromPositions(t,o[s],p,n,a)).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(u.geometry.attributes.position.values,f,t,!n),defined(e._offsetAttribute)&&(d=u.geometry.attributes.position.values.length,arrayFill(d=new Uint8Array(d/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:d})),h.push(u);r=GeometryPipeline.combineInstances(h)[0],i=BoundingSphere.fromVertices(r.attributes.position.values);return new Geometry({attributes:r.attributes,indices:r.indices,primitiveType:r.primitiveType,boundingSphere:i,offsetAttribute:e._offsetAttribute})}};var scratchInterpolateColorsArray=[];function interpolateColors$1(e,t,i,r,n){var a=scratchInterpolateColorsArray;a.length=n;var o=i.red,s=i.green,l=i.blue,c=i.alpha,u=r.red,d=r.green,h=r.blue,p=r.alpha;if(Color.equals(i,r)){for(y=0;y<n;y++)a[y]=Color.clone(i);return a}for(var f=(u-o)/n,m=(d-s)/n,g=(h-l)/n,_=(p-c)/n,y=0;y<n;y++)a[y]=new Color(o+y*f,s+y*m,l+y*g,c+y*_);return a}function PolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.width,1),n=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._width=r,this._colorsPerVertex=n,this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";t=1+t.length*Cartesian3.packedLength;t+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+4}PolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors,a=defined(o)?o.length:0;for(t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t};var scratchEllipsoid$7=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$3=new VertexFormat,scratchOptions$8={positions:void 0,colors:void 0,ellipsoid:scratchEllipsoid$7,vertexFormat:scratchVertexFormat$3,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};PolylineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=0<(r=e[t++])?new Array(r):void 0;for(a=0;a<r;++a,t+=Color.packedLength)o[a]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$7);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$3);t+=VertexFormat.packedLength;var c=e[t++],u=1===e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._colors=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._width=c,i._colorsPerVertex=u,i._arcType=d,i._granularity=h,i):(scratchOptions$8.positions=n,scratchOptions$8.colors=o,scratchOptions$8.width=c,scratchOptions$8.colorsPerVertex=u,scratchOptions$8.arcType=d,scratchOptions$8.granularity=h,new PolylineGeometry(scratchOptions$8))};var scratchCartesian3$5=new Cartesian3,scratchPosition$8=new Cartesian3,scratchPrevPosition=new Cartesian3,scratchNextPosition=new Cartesian3;function computeAttributes$1(e,t,i,r){var n=new GeometryAttributes;r.position&&(n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}));var a,o,s,l,c,u=t.length,d=e.length/3,h=(d-2*u)/(2*u),p=PolygonPipeline.triangulate(t),f=(h-1)*u*6+2*p.length,m=IndexDatatype$1.createTypedArray(d,f),g=2*u,_=0;for(b=0;b<h-1;b++){for(a=0;a<u-1;a++)c=(o=2*a+b*u*2)+g,l=(s=o+1)+g,m[_++]=s,m[_++]=o,m[_++]=l,m[_++]=l,m[_++]=o,m[_++]=c;l=(s=(o=2*u-2+b*u*2)+1)+g,c=o+g,m[_++]=s,m[_++]=o,m[_++]=l,m[_++]=l,m[_++]=o,m[_++]=c}if(r.st||r.tangent||r.bitangent){for(var y,C,v=new Float32Array(2*d),T=1/(h-1),S=1/i.height,A=i.height/2,x=0,b=0;b<h;b++){for(C=S*(t[0].y+A),v[x++]=y=b*T,v[x++]=C,a=1;a<u;a++)C=S*(t[a].y+A),v[x++]=y,v[x++]=C,v[x++]=y,v[x++]=C;C=S*(t[0].y+A),v[x++]=y,v[x++]=C}for(a=0;a<u;a++)C=S*(t[a].y+A),v[x++]=y=0,v[x++]=C;for(a=0;a<u;a++)C=S*(t[a].y+A),v[x++]=y=(h-1)*T,v[x++]=C;n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:new Float32Array(v)})}var E=d-2*u;for(b=0;b<p.length;b+=3){var P=p[b]+E,D=p[b+1]+E,w=p[b+2]+E;m[_++]=P,m[_++]=D,m[_++]=w,m[_++]=w+u,m[_++]=D+u,m[_++]=P+u}e=new Geometry({attributes:n,indices:m,boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.TRIANGLES});if(r.normal&&(e=GeometryPipeline.computeNormal(e)),r.tangent||r.bitangent){try{e=GeometryPipeline.computeTangentAndBitangent(e)}catch(e){oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}r.tangent||(e.attributes.tangent=void 0),r.bitangent||(e.attributes.bitangent=void 0),r.st||(e.attributes.st=void 0)}return e}function PolylineVolumeGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";t=1+t.length*Cartesian3.packedLength;t+=1+i.length*Cartesian2.packedLength,this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+2}PolylineGeometry.createGeometry=function(e){var i,r,t=e._width,n=e._vertexFormat,a=e._colors,o=e._colorsPerVertex,s=e._arcType,l=e._granularity,c=e._ellipsoid,u=[],d=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon,!1,u);if(defined(a)&&0<u.length&&(r=u[i=0],a=a.filter(function(e,t){return(o?t!==r&&(0!==t||1!==r):t+1!==r)||(r=u[++i],!1)})),!((E=d.length)<2||t<=0)){if(s===ArcType$1.GEODESIC||s===ArcType$1.RHUMB){var h,p=s===ArcType$1.GEODESIC?(h=CesiumMath.chordLength(l,c.maximumRadius),PolylinePipeline.numberOfPoints):(h=l,PolylinePipeline.numberOfPointsRhumbLine),f=PolylinePipeline.extractHeights(d,c);if(defined(a)){for(var m=1,g=0;g<E-1;++g)m+=p(d[g],d[g+1],h);var _=new Array(m),y=0;for(g=0;g<E-1;++g){var C=d[g],v=d[g+1],T=a[g],S=p(C,v,h);if(o&&g<m)for(var A=interpolateColors$1(C,v,T,a[g+1],S),x=A.length,b=0;b<x;++b)_[y++]=A[b];else for(b=0;b<S;++b)_[y++]=Color.clone(T)}_[y]=Color.clone(a[a.length-1]),a=_,scratchInterpolateColorsArray.length=0}d=s===ArcType$1.GEODESIC?PolylinePipeline.generateCartesianArc({positions:d,minDistance:h,ellipsoid:c,height:f}):PolylinePipeline.generateCartesianRhumbArc({positions:d,granularity:h,ellipsoid:c,height:f})}var E,P,D,w,c=4*(E=d.length)-4,M=new Float64Array(3*c),I=new Float64Array(3*c),R=new Float64Array(3*c),O=new Float32Array(2*c),B=n.st?new Float32Array(2*c):void 0,L=defined(a)?new Uint8Array(4*c):void 0,F=0,N=0,V=0,k=0;for(b=0;b<E;++b){0===b?(Cartesian3.subtract(d[0],d[1],P=scratchCartesian3$5),Cartesian3.add(d[0],P,P)):P=d[b-1],Cartesian3.clone(P,scratchPrevPosition),Cartesian3.clone(d[b],scratchPosition$8),b===E-1?(Cartesian3.subtract(d[E-1],d[E-2],P=scratchCartesian3$5),Cartesian3.add(d[E-1],P,P)):P=d[b+1],Cartesian3.clone(P,scratchNextPosition),defined(L)&&(D=0===b||o?a[b]:a[b-1],b!==E-1&&(w=a[b]));for(var G=b===E-1?2:4,U=0===b?2:0;U<G;++U){Cartesian3.pack(scratchPosition$8,M,F),Cartesian3.pack(scratchPrevPosition,I,F),Cartesian3.pack(scratchNextPosition,R,F),F+=3;var $=U-2<0?-1:1;O[N++]=U%2*2-1,O[N++]=$*t,n.st&&(B[V++]=b/(E-1),B[V++]=Math.max(O[N-2],0)),defined(L)&&(L[k++]=Color.floatToByte(($=U<2?D:w).red),L[k++]=Color.floatToByte($.green),L[k++]=Color.floatToByte($.blue),L[k++]=Color.floatToByte($.alpha))}}f=new GeometryAttributes;f.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:M}),f.prevPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:I}),f.nextPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:R}),f.expandAndWidth=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:O}),n.st&&(f.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:B})),defined(L)&&(f.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:L,normalize:!0}));var z=IndexDatatype$1.createTypedArray(c,6*E-6),H=0,W=0,q=E-1;for(b=0;b<q;++b)z[W++]=H,z[W++]=H+2,z[W++]=H+1,z[W++]=H+1,z[W++]=H+2,z[W++]=H+3,H+=4;return new Geometry({attributes:f,indices:z,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromPoints(d),geometryType:GeometryType$1.POLYLINES})}},PolylineVolumeGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape,a=o.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$6=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$2=new VertexFormat,scratchOptions$7={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$6,vertexFormat:scratchVertexFormat$2,cornerType:void 0,granularity:void 0};PolylineVolumeGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var r=e[t++],o=new Array(r);for(a=0;a<r;++a,t+=Cartesian2.packedLength)o[a]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$6);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$2);t+=VertexFormat.packedLength;var c=e[t++],u=e[t];return defined(i)?(i._positions=n,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._cornerType=c,i._granularity=u,i):(scratchOptions$7.polylinePositions=n,scratchOptions$7.shapePositions=o,scratchOptions$7.cornerType=c,scratchOptions$7.granularity=u,new PolylineVolumeGeometry(scratchOptions$7))};var brScratch$1=new BoundingRectangle;function computeAttributes(e,t){var i=new GeometryAttributes;i.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e});var r=t.length,t=i.position.values.length/3,n=e.length/3/r,a=IndexDatatype$1.createTypedArray(t,2*r*(1+n)),o=0,s=0,l=s*r;for(d=0;d<r-1;d++)a[o++]=d+l,a[o++]=d+l+1;for(a[o++]=r-1+l,a[o++]=l,l=(s=n-1)*r,d=0;d<r-1;d++)a[o++]=d+l,a[o++]=d+l+1;for(a[o++]=r-1+l,a[o++]=l,s=0;s<n-1;s++)for(var c=r*s,u=c+r,d=0;d<r;d++)a[o++]=d+c,a[o++]=d+u;return new Geometry({attributes:i,indices:IndexDatatype$1.createTypedArray(t,a),boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.LINES})}function PolylineVolumeOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";t=1+t.length*Cartesian3.packedLength;t+=1+i.length*Cartesian2.packedLength,this.packedLength=t+Ellipsoid.packedLength+2}PolylineVolumeGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape,i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i);if(!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch$1);return computeAttributes$1(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!0),i,r,e._vertexFormat)}},PolylineVolumeOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape,a=o.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$5=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$6={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$5,height:void 0,cornerType:void 0,granularity:void 0};PolylineVolumeOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var r=e[t++],o=new Array(r);for(a=0;a<r;++a,t+=Cartesian2.packedLength)o[a]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$5);t+=Ellipsoid.packedLength;var l=e[t++],c=e[t];return defined(i)?(i._positions=n,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._cornerType=l,i._granularity=c,i):(scratchOptions$6.polylinePositions=n,scratchOptions$6.shapePositions=o,scratchOptions$6.cornerType=l,scratchOptions$6.granularity=c,new PolylineVolumeOutlineGeometry(scratchOptions$6))};var brScratch=new BoundingRectangle;function Proxy(){DeveloperError.throwInstantiationError()}function createEvaluateFunction(n){var a=n.points,o=n.times;return function(e,t){defined(t)||(t=new Quaternion);var i=n._lastTimeIndex=n.findTimeInterval(e,n._lastTimeIndex),r=(e-o[i])/(o[i+1]-o[i]),e=a[i],i=a[i+1];return Quaternion.fastSlerp(e,i,r,t)}}function QuaternionSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,e=e.times;this._times=e,this._points=t,this._evaluateFunction=createEvaluateFunction(this),this._lastTimeIndex=0}function quickselect(e,t,i,r,n){quickselectStep(e,t,i||0,r||e.length-1,n||defaultCompare)}function quickselectStep(e,t,i,r,n){for(;i<r;){var a,o,s,l;600<r-i&&(a=r-i+1,o=t-i+1,l=Math.log(a),s=.5*Math.exp(2*l/3),l=.5*Math.sqrt(l*s*(a-s)/a)*(o-a/2<0?-1:1),quickselectStep(e,t,Math.max(i,Math.floor(t-o*s/a+l)),Math.min(r,Math.floor(t+(a-o)*s/a+l)),n));var c=e[t],u=i,d=r;for(swap$1(e,i,t),0<n(e[r],c)&&swap$1(e,i,r);u<d;){for(swap$1(e,u,d),u++,d--;n(e[u],c)<0;)u++;for(;0<n(e[d],c);)d--}0===n(e[i],c)?swap$1(e,i,d):swap$1(e,++d,r),d<=t&&(i=d+1),t<=d&&(r=d-1)}}function swap$1(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function defaultCompare(e,t){return e<t?-1:t<e?1:0}PolylineVolumeOutlineGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape,i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i);if(!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch);return computeAttributes(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!1),i)}},Proxy.prototype.getURL=DeveloperError.throwInstantiationError,Object.defineProperties(QuaternionSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),QuaternionSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,QuaternionSpline.prototype.wrapTime=Spline.prototype.wrapTime,QuaternionSpline.prototype.clampTime=Spline.prototype.clampTime,QuaternionSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)};class RBush{constructor(e=9){this._maxEntries=Math.max(4,e),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()}all(){return this._all(this.data,[])}search(t){let i=this.data;const r=[];if(!intersects(t,i))return r;const n=this.toBBox,a=[];for(;i;){for(let e=0;e<i.children.length;e++){var o=i.children[e],s=i.leaf?n(o):o;intersects(t,s)&&(i.leaf?r.push(o):contains$1(t,s)?this._all(o,r):a.push(o))}i=a.pop()}return r}collides(t){let i=this.data;if(!intersects(t,i))return!1;const r=[];for(;i;){for(let e=0;e<i.children.length;e++){var n=i.children[e],a=i.leaf?this.toBBox(n):n;if(intersects(t,a)){if(i.leaf||contains$1(t,a))return!0;r.push(n)}}i=r.pop()}return!1}load(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(let e=0;e<t.length;e++)this.insert(t[e]);return this}let e=this._build(t.slice(),0,t.length-1,0);var i;return this.data.children.length?this.data.height===e.height?this._splitRoot(this.data,e):(this.data.height<e.height&&(i=this.data,this.data=e,e=i),this._insert(e,this.data.height-e.height-1,!0)):this.data=e,this}insert(e){return e&&this._insert(e,this.data.height-1),this}clear(){return this.data=createNode([]),this}remove(e,t){if(!e)return this;let i=this.data;var r=this.toBBox(e);const n=[],a=[];let o,s,l;for(;i||n.length;){if(i||(i=n.pop(),s=n[n.length-1],o=a.pop(),l=!0),i.leaf){var c=findItem(e,i.children,t);if(-1!==c)return i.children.splice(c,1),n.push(i),this._condense(n),this}l||i.leaf||!contains$1(i,r)?s?(o++,i=s.children[o],l=!1):i=null:(n.push(i),a.push(o),o=0,s=i,i=i.children[0])}return this}toBBox(e){return e}compareMinX(e,t){return e.minX-t.minX}compareMinY(e,t){return e.minY-t.minY}toJSON(){return this.data}fromJSON(e){return this.data=e,this}_all(e,t){const i=[];for(;e;)(e.leaf?t:i).push(...e.children),e=i.pop();return t}_build(i,e,r,n){var t=r-e+1;let a=this._maxEntries,o;if(t<=a)return o=createNode(i.slice(e,r+1)),calcBBox(o,this.toBBox),o;n||(n=Math.ceil(Math.log(t)/Math.log(a)),a=Math.ceil(t/Math.pow(a,n-1))),o=createNode([]),o.leaf=!1,o.height=n;var s=Math.ceil(t/a),l=s*Math.ceil(Math.sqrt(a));multiSelect(i,e,r,l,this.compareMinX);for(let t=e;t<=r;t+=l){var c=Math.min(t+l-1,r);multiSelect(i,t,c,s,this.compareMinY);for(let e=t;e<=c;e+=s){var u=Math.min(e+s-1,c);o.children.push(this._build(i,e,u,n-1))}}return calcBBox(o,this.toBBox),o}_chooseSubtree(n,a,e,o){for(;;){if(o.push(a),a.leaf||o.length-1===e)break;let t=1/0,i=1/0,r;for(let e=0;e<a.children.length;e++){var s=a.children[e],l=bboxArea(s),c=enlargedArea(n,s)-l;c<i?(i=c,t=l<t?l:t,r=s):c===i&&l<t&&(t=l,r=s)}a=r||a.children[0]}return a}_insert(e,t,i){var i=i?e:this.toBBox(e),r=[];const n=this._chooseSubtree(i,this.data,t,r);for(n.children.push(e),extend(n,i);0<=t&&r[t].children.length>this._maxEntries;)this._split(r,t),t--;this._adjustParentBBoxes(i,r,t)}_split(e,t){const i=e[t];var r=i.children.length,n=this._minEntries;this._chooseSplitAxis(i,n,r);r=this._chooseSplitIndex(i,n,r);const a=createNode(i.children.splice(r,i.children.length-r));a.height=i.height,a.leaf=i.leaf,calcBBox(i,this.toBBox),calcBBox(a,this.toBBox),t?e[t-1].children.push(a):this._splitRoot(i,a)}_splitRoot(e,t){this.data=createNode([e,t]),this.data.height=e.height+1,this.data.leaf=!1,calcBBox(this.data,this.toBBox)}_chooseSplitIndex(t,i,r){let n,a=1/0,o=1/0;for(let e=i;e<=r-i;e++){var s=distBBox(t,0,e,this.toBBox),l=distBBox(t,e,r,this.toBBox),c=intersectionArea(s,l),l=bboxArea(s)+bboxArea(l);c<a?(a=c,n=e,o=l<o?l:o):c===a&&l<o&&(o=l,n=e)}return n||r-i}_chooseSplitAxis(e,t,i){var r=e.leaf?this.compareMinX:compareNodeMinX,n=e.leaf?this.compareMinY:compareNodeMinY;this._allDistMargin(e,t,i,r)<this._allDistMargin(e,t,i,n)&&e.children.sort(r)}_allDistMargin(t,i,r,e){t.children.sort(e);const n=this.toBBox;var a=distBBox(t,0,i,n),o=distBBox(t,r-i,r,n);let s=bboxMargin(a)+bboxMargin(o);for(let e=i;e<r-i;e++){var l=t.children[e];extend(a,t.leaf?n(l):l),s+=bboxMargin(a)}for(let e=r-i-1;e>=i;e--){var c=t.children[e];extend(o,t.leaf?n(c):c),s+=bboxMargin(o)}return s}_adjustParentBBoxes(t,i,r){for(let e=r;0<=e;e--)extend(i[e],t)}_condense(i){for(let e=i.length-1,t;0<=e;e--)0===i[e].children.length?0<e?(t=i[e-1].children,t.splice(t.indexOf(i[e]),1)):this.clear():calcBBox(i[e],this.toBBox)}}function findItem(t,i,r){if(!r)return i.indexOf(t);for(let e=0;e<i.length;e++)if(r(t,i[e]))return e;return-1}function calcBBox(e,t){distBBox(e,0,e.children.length,t,e)}function distBBox(t,i,r,n,a){(a=a||createNode(null)).minX=1/0,a.minY=1/0,a.maxX=-1/0,a.maxY=-1/0;for(let e=i;e<r;e++){var o=t.children[e];extend(a,t.leaf?n(o):o)}return a}function extend(e,t){return e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),e}function compareNodeMinX(e,t){return e.minX-t.minX}function compareNodeMinY(e,t){return e.minY-t.minY}function bboxArea(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function bboxMargin(e){return e.maxX-e.minX+(e.maxY-e.minY)}function enlargedArea(e,t){return(Math.max(t.maxX,e.maxX)-Math.min(t.minX,e.minX))*(Math.max(t.maxY,e.maxY)-Math.min(t.minY,e.minY))}function intersectionArea(e,t){var i=Math.max(e.minX,t.minX),r=Math.max(e.minY,t.minY),n=Math.min(e.maxX,t.maxX),t=Math.min(e.maxY,t.maxY);return Math.max(0,n-i)*Math.max(0,t-r)}function contains$1(e,t){return e.minX<=t.minX&&e.minY<=t.minY&&t.maxX<=e.maxX&&t.maxY<=e.maxY}function intersects(e,t){return t.minX<=e.maxX&&t.minY<=e.maxY&&t.maxX>=e.minX&&t.maxY>=e.minY}function createNode(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function multiSelect(e,t,i,r,n){const a=[t,i];for(;a.length;){var o;(i=a.pop())-(t=a.pop())<=r||(quickselect(e,o=t+Math.ceil((i-t)/r/2)*r,t,i,n),a.push(t,o,o,i))}}function RectangleCollisionChecker(){this._tree=new RBush}function RectangleWithId(){this.minX=0,this.minY=0,this.maxX=0,this.maxY=0,this.id=""}function idCompare(e,t){return e.id===t.id}RectangleWithId.fromRectangleAndId=function(e,t,i){return i.minX=t.west,i.minY=t.south,i.maxX=t.east,i.maxY=t.north,i.id=e,i},RectangleCollisionChecker.prototype.insert=function(e,t){t=RectangleWithId.fromRectangleAndId(e,t,new RectangleWithId);this._tree.insert(t)};var removalScratch=new RectangleWithId;RectangleCollisionChecker.prototype.remove=function(e,t){t=RectangleWithId.fromRectangleAndId(e,t,removalScratch);this._tree.remove(t,idCompare)};var collisionScratch=new RectangleWithId;RectangleCollisionChecker.prototype.collides=function(e){e=RectangleWithId.fromRectangleAndId("",e,collisionScratch);return this._tree.collides(e)};var cos=Math.cos,sin=Math.sin,sqrt=Math.sqrt,RectangleGeometryLibrary={computePosition:function(e,t,i,r,n,a,o){var s=t.radiiSquared,l=e.nwCorner,c=e.boundingRectangle,u=l.latitude-e.granYCos*r+n*e.granXSin,d=cos(u),h=sin(u),p=s.z*h,f=l.longitude+r*e.granYSin+n*e.granXCos,t=d*cos(f),l=d*sin(f),d=s.x*t,s=s.y*l,h=sqrt(d*t+s*l+p*h);a.x=d/h,a.y=s/h,a.z=p/h,i&&(defined(i=e.stNwCorner)?(u=i.latitude-e.stGranYCos*r+n*e.stGranXSin,f=i.longitude+r*e.stGranYSin+n*e.stGranXCos,o.x=(f-e.stWest)*e.lonScalar,o.y=(u-e.stSouth)*e.latScalar):(o.x=(f-c.west)*e.lonScalar,o.y=(u-c.south)*e.latScalar))}},rotationMatrixScratch=new Matrix2,nwCartesian=new Cartesian3,centerScratch$3=new Cartographic,centerCartesian=new Cartesian3,proj=new GeographicProjection;function getRotationOptions(e,t,i,r,n,a,o){var s=Math.cos(t),l=r*s,c=i*s,u=Math.sin(t),d=r*u,h=i*u;nwCartesian=proj.project(e,nwCartesian),nwCartesian=Cartesian3.subtract(nwCartesian,centerCartesian,nwCartesian);s=Matrix2.fromRotation(t,rotationMatrixScratch);nwCartesian=Matrix2.multiplyByVector(s,nwCartesian,nwCartesian),nwCartesian=Cartesian3.add(nwCartesian,centerCartesian,nwCartesian);r=(e=proj.unproject(nwCartesian,e)).latitude,i=r+--a*h,u=r-l*--o,t=r-l*o+a*h,s=Math.max(r,i,u,t),r=Math.min(r,i,u,t),i=e.longitude,u=i+a*c,t=i+o*d,a=i+o*d+a*c;return{north:s,south:r,east:Math.max(i,u,t,a),west:Math.min(i,u,t,a),granYCos:l,granYSin:d,granXCos:c,granXSin:h,nwCorner:e}}RectangleGeometryLibrary.computeOptions=function(e,t,i,r,n,a,o){var s=e.east,l=e.west,c=e.north,u=e.south,d=!1,h=!1;c===CesiumMath.PI_OVER_TWO&&(d=!0),u===-CesiumMath.PI_OVER_TWO&&(h=!0);var p,f=c-u,m=(_=s<l?CesiumMath.TWO_PI-l+s:s-l)/((p=Math.ceil(_/t)+1)-1),g=f/((y=Math.ceil(f/t)+1)-1),_=Rectangle.northwest(e,a),f=Rectangle.center(e,centerScratch$3);0===i&&0===r||(f.longitude<_.longitude&&(f.longitude+=CesiumMath.TWO_PI),centerCartesian=proj.project(f,centerCartesian));var y,t=g,a=m,n=Rectangle.clone(e,n),h={granYCos:t,granYSin:0,granXCos:a,granXSin:0,nwCorner:_,boundingRectangle:n,width:p,height:y,northCap:d,southCap:h};return 0!==i&&(c=(_=getRotationOptions(_,i,m,g,f,p,y)).north,u=_.south,s=_.east,l=_.west,h.granYCos=_.granYCos,h.granYSin=_.granYSin,h.granXCos=_.granXCos,h.granXSin=_.granXSin,n.north=c,n.south=u,n.east=s,n.west=l),0!==r&&(i-=r,y=getRotationOptions(o=Rectangle.northwest(n,o),i,m,g,f,p,y),h.stGranYCos=y.granYCos,h.stGranXCos=y.granXCos,h.stGranYSin=y.granYSin,h.stGranXSin=y.granXSin,h.stNwCorner=o,h.stWest=y.west,h.stSouth=y.south),h};var positionScratch$9=new Cartesian3,normalScratch$2=new Cartesian3,tangentScratch=new Cartesian3,bitangentScratch=new Cartesian3,rectangleScratch$4=new Rectangle,stScratch=new Cartesian2,bottomBoundingSphere$1=new BoundingSphere,topBoundingSphere$1=new BoundingSphere;function createAttributes(e,t){var i=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.TRIANGLES});return i.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.bitangents})),i}function calculateAttributes(e,t,i,r){var n=e.length,a=t.normal?new Float32Array(n):void 0,o=t.tangent?new Float32Array(n):void 0,s=t.bitangent?new Float32Array(n):void 0,l=0,c=bitangentScratch,u=tangentScratch,d=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(var h=0;h<n;h+=3){var p=Cartesian3.fromArray(e,h,positionScratch$9),f=l+1,m=l+2,d=i.geodeticSurfaceNormal(p,d);(t.tangent||t.bitangent)&&(Cartesian3.cross(Cartesian3.UNIT_Z,d,u),Matrix3.multiplyByVector(r,u,u),Cartesian3.normalize(u,u),t.bitangent&&Cartesian3.normalize(Cartesian3.cross(d,u,c),c)),t.normal&&(a[l]=d.x,a[f]=d.y,a[m]=d.z),t.tangent&&(o[l]=u.x,o[f]=u.y,o[m]=u.z),t.bitangent&&(s[l]=c.x,s[f]=c.y,s[m]=c.z),l+=3}return createAttributes(t,{positions:e,normals:a,tangents:o,bitangents:s})}var v1Scratch=new Cartesian3,v2Scratch=new Cartesian3;function calculateAttributesWall(e,t,i){var r=e.length,n=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,o=t.bitangent?new Float32Array(r):void 0,s=0,l=0,c=0,u=!0,d=bitangentScratch,h=tangentScratch,p=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(var f=0;f<r;f+=6){var m,g=Cartesian3.fromArray(e,f,positionScratch$9),_=Cartesian3.fromArray(e,(f+6)%r,v1Scratch);u&&(m=Cartesian3.fromArray(e,(f+3)%r,v2Scratch),Cartesian3.subtract(_,g,_),Cartesian3.subtract(m,g,m),p=Cartesian3.normalize(Cartesian3.cross(m,_,p),p),u=!1),Cartesian3.equalsEpsilon(_,g,CesiumMath.EPSILON10)&&(u=!0),(t.tangent||t.bitangent)&&(d=i.geodeticSurfaceNormal(g,d),t.tangent&&(h=Cartesian3.normalize(Cartesian3.cross(d,p,h),h))),t.normal&&(n[s++]=p.x,n[s++]=p.y,n[s++]=p.z,n[s++]=p.x,n[s++]=p.y,n[s++]=p.z),t.tangent&&(a[l++]=h.x,a[l++]=h.y,a[l++]=h.z,a[l++]=h.x,a[l++]=h.y,a[l++]=h.z),t.bitangent&&(o[c++]=d.x,o[c++]=d.y,o[c++]=d.z,o[c++]=d.x,o[c++]=d.y,o[c++]=d.z)}return createAttributes(t,{positions:e,normals:n,tangents:a,bitangents:o})}function constructRectangle$1(e,t){var i=e._vertexFormat,r=e._ellipsoid,n=t.height,a=t.width,o=t.northCap,s=t.southCap,l=0,c=n,u=n,e=0;o&&(--u,e+=l=1),s&&(--c,--u,e+=1),e+=a*u;for(var d=i.position?new Float64Array(3*e):void 0,h=i.st?new Float32Array(2*e):void 0,p=0,f=0,m=positionScratch$9,g=stScratch,_=Number.MAX_VALUE,y=Number.MAX_VALUE,C=-Number.MAX_VALUE,v=-Number.MAX_VALUE,T=l;T<c;++T)for(var S=0;S<a;++S)RectangleGeometryLibrary.computePosition(t,r,i.st,T,S,m,g),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z,i.st&&(h[f++]=g.x,h[f++]=g.y,_=Math.min(_,g.x),y=Math.min(y,g.y),C=Math.max(C,g.x),v=Math.max(v,g.y));if(o&&(RectangleGeometryLibrary.computePosition(t,r,i.st,0,0,m,g),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z,i.st&&(h[f++]=g.x,h[f++]=g.y,_=g.x,y=g.y,C=g.x,v=g.y)),s&&(RectangleGeometryLibrary.computePosition(t,r,i.st,n-1,0,m,g),d[p++]=m.x,d[p++]=m.y,d[p]=m.z,i.st&&(h[f++]=g.x,h[f]=g.y,_=Math.min(_,g.x),y=Math.min(y,g.y),C=Math.max(C,g.x),v=Math.max(v,g.y))),i.st&&(_<0||y<0||1<C||1<v))for(var A=0;A<h.length;A+=2)h[A]=(h[A]-_)/(C-_),h[A+1]=(h[A+1]-y)/(v-y);l=calculateAttributes(d,i,r,t.tangentRotationMatrix),n=6*(a-1)*(u-1);o&&(n+=3*(a-1)),s&&(n+=3*(a-1));for(var x=IndexDatatype$1.createTypedArray(e,n),b=0,E=0,P=0;P<u-1;++P){for(var D=0;D<a-1;++D){var w=b,M=w+a,I=M+1,R=w+1;x[E++]=w,x[E++]=M,x[E++]=R,x[E++]=R,x[E++]=M,x[E++]=I,++b}++b}if(o||s){var O,B,L=e-1,F=e-1;if(o&&s&&(L=e-2),b=0,o)for(P=0;P<a-1;P++)B=(O=b)+1,x[E++]=L,x[E++]=O,x[E++]=B,++b;if(s)for(b=(u-1)*a,P=0;P<a-1;P++)B=(O=b)+1,x[E++]=O,x[E++]=F,x[E++]=B,++b}return l.indices=x,i.st&&(l.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),l}function addWallPositions(e,t,i,r,n){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],e[t++]=n[i],e[t++]=n[i+1],e[t]=n[i+2],e}function addWallTextureCoordinates(e,t,i,r){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i],e[t]=r[i+1],e}var scratchVertexFormat$1=new VertexFormat;function constructExtrudedRectangle$1(e,t){var i=e._shadowVolume,r=e._offsetAttribute,n=e._vertexFormat,a=e._extrudedHeight,o=e._surfaceHeight,s=e._ellipsoid,l=t.height,c=t.width;i&&((_=VertexFormat.clone(n,scratchVertexFormat$1)).normal=!0,e._vertexFormat=_);var u=constructRectangle$1(e,t);i&&(e._vertexFormat=n);var d=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,o,s,!1),h=2*(G=(d=new Float64Array(d)).length),p=new Float64Array(h);p.set(d);var f=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,a,s);p.set(f,G),u.attributes.position.values=p;var m,g,_=n.normal?new Float32Array(h):void 0,e=n.tangent?new Float32Array(h):void 0,o=n.bitangent?new Float32Array(h):void 0,a=n.st?new Float32Array(h/3*2):void 0;if(n.normal){for(g=u.attributes.normal.values,_.set(g),C=0;C<G;C++)g[C]=-g[C];_.set(g,G),u.attributes.normal.values=_}if(i){g=u.attributes.normal.values,n.normal||(u.attributes.normal=void 0);for(var y=new Float32Array(h),C=0;C<G;C++)g[C]=-g[C];y.set(g,G),u.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})}p=defined(r);if(p&&(_=G/3*2,y=new Uint8Array(_),y=r===GeometryOffsetAttribute$1.TOP?arrayFill(y,1,0,_/2):arrayFill(y,r===GeometryOffsetAttribute$1.NONE?0:1),u.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})),n.tangent){var v=u.attributes.tangent.values;for(e.set(v),C=0;C<G;C++)v[C]=-v[C];e.set(v,G),u.attributes.tangent.values=e}n.bitangent&&(b=u.attributes.bitangent.values,o.set(b),o.set(b,G),u.attributes.bitangent.values=o),n.st&&(m=u.attributes.st.values,a.set(m),a.set(m,G/3*2),u.attributes.st.values=a);var T=u.indices,S=T.length,A=G/3,x=IndexDatatype$1.createTypedArray(h/3,2*S);for(x.set(T),C=0;C<S;C+=3)x[C+S]=T[C+2]+A,x[C+1+S]=T[C+1]+A,x[C+2+S]=T[C]+A;u.indices=x;var e=t.northCap,b=t.southCap,o=l,a=2,h=0,t=4,l=4;e&&(--a,--o,h+=1,t-=2,--l),b&&(--a,--o,h+=1,t-=2,--l);var l=2*((h+=a*c+2*o-t)+l),E=new Float64Array(3*l),P=i?new Float32Array(3*l):void 0,D=p?new Uint8Array(l):void 0,w=n.st?new Float32Array(2*l):void 0,M=r===GeometryOffsetAttribute$1.TOP;p&&!M&&(D=arrayFill(D,r===GeometryOffsetAttribute$1.ALL?1:0));var I=0,R=0,O=0,B=0,L=c*o;for(C=0;C<L;C+=c)E=addWallPositions(E,I,N=3*C,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*C,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1);if(b){var F=e?1+L:L,N=3*F;for(C=0;C<2;C++)E=addWallPositions(E,I,N,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*F,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1)}else for(C=L-c;C<L;C++)E=addWallPositions(E,I,N=3*C,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*C,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1);for(C=L-1;0<C;C-=c)E=addWallPositions(E,I,N=3*C,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*C,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1);if(e){var V=L;for(N=3*V,C=0;C<2;C++)E=addWallPositions(E,I,N,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*V,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1)}else for(C=c-1;0<=C;C--)E=addWallPositions(E,I,N=3*C,d,f),I+=6,n.st&&(w=addWallTextureCoordinates(w,R,2*C,m),R+=4),i&&(O+=3,P[O++]=g[N],P[O++]=g[N+1],P[O++]=g[N+2]),M&&(D[B++]=1,B+=1);s=calculateAttributesWall(E,n,s);n.st&&(s.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:w})),i&&(s.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:P})),p&&(s.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:D}));var k=IndexDatatype$1.createTypedArray(l,6*h),G=E.length/3,U=0;for(C=0;C<G-1;C+=2){var $,z=(($=C)+2)%G,H=Cartesian3.fromArray(E,3*$,v1Scratch),W=Cartesian3.fromArray(E,3*z,v2Scratch);Cartesian3.equalsEpsilon(H,W,CesiumMath.EPSILON10)||(W=(2+(H=($+1)%G))%G,k[U++]=$,k[U++]=H,k[U++]=z,k[U++]=z,k[U++]=H,k[U++]=W)}return s.indices=k,(s=GeometryPipeline.combineInstances([new GeometryInstance({geometry:u}),new GeometryInstance({geometry:s})]))[0]}var scratchRectanglePoints=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],nwScratch$1=new Cartographic,stNwScratch=new Cartographic;function computeRectangle(e,t,i,r,n){if(0===i)return Rectangle.clone(e,n);var a=RectangleGeometryLibrary.computeOptions(e,t,i,0,rectangleScratch$4,nwScratch$1),e=a.height,t=a.width,i=scratchRectanglePoints;return RectangleGeometryLibrary.computePosition(a,r,!1,0,0,i[0]),RectangleGeometryLibrary.computePosition(a,r,!1,0,t-1,i[1]),RectangleGeometryLibrary.computePosition(a,r,!1,e-1,0,i[2]),RectangleGeometryLibrary.computePosition(a,r,!1,e-1,t-1,i[3]),Rectangle.fromCartesianArray(i,r,n)}function RectangleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._rectangle=Rectangle.clone(t),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._surfaceHeight=Math.max(i,r),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._extrudedHeight=Math.min(i,r),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._offsetAttribute=e.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}RectangleGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7,RectangleGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$8=new Rectangle,scratchEllipsoid$4=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$5={rectangle:scratchRectangle$8,ellipsoid:scratchEllipsoid$4,vertexFormat:scratchVertexFormat$1,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};RectangleGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$8);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$4);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$1);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=1===e[t++],t=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._granularity=o,i._surfaceHeight=s,i._rotation=l,i._stRotation=c,i._extrudedHeight=u,i._shadowVolume=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$5.granularity=o,scratchOptions$5.height=s,scratchOptions$5.rotation=l,scratchOptions$5.stRotation=c,scratchOptions$5.extrudedHeight=u,scratchOptions$5.shadowVolume=d,scratchOptions$5.offsetAttribute=-1===t?void 0:t,new RectangleGeometry(scratchOptions$5))},RectangleGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle(i,r,defaultValue(e.rotation,0),n,t)};var tangentRotationMatrixScratch=new Matrix3,quaternionScratch=new Quaternion,centerScratch$2=new Cartographic;RectangleGeometry.createGeometry=function(e){if(!CesiumMath.equalsEpsilon(e._rectangle.north,e._rectangle.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(e._rectangle.east,e._rectangle.west,CesiumMath.EPSILON10)){var t=e._rectangle,i=e._ellipsoid,r=e._rotation,n=e._stRotation,a=e._vertexFormat,o=RectangleGeometryLibrary.computeOptions(t,e._granularity,r,n,rectangleScratch$4,nwScratch$1,stNwScratch),s=tangentRotationMatrixScratch;0!==n||0!==r?(c=Rectangle.center(t,centerScratch$2),u=i.geodeticSurfaceNormalCartographic(c,v1Scratch),Quaternion.fromAxisAngle(u,-n,quaternionScratch),Matrix3.fromQuaternion(quaternionScratch,s)):Matrix3.clone(Matrix3.IDENTITY,s);var l,c=e._surfaceHeight,u=e._extrudedHeight,n=!CesiumMath.equalsEpsilon(c,u,0,CesiumMath.EPSILON2);return o.lonScalar=1/e._rectangle.width,o.latScalar=1/e._rectangle.height,o.tangentRotationMatrix=s,t=e._rectangle,c=n?(l=constructExtrudedRectangle$1(e,o),n=BoundingSphere.fromRectangle3D(t,i,c,topBoundingSphere$1),u=BoundingSphere.fromRectangle3D(t,i,u,bottomBoundingSphere$1),BoundingSphere.union(n,u)):((l=constructRectangle$1(e,o)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(l.attributes.position.values,c,i,!1),defined(e._offsetAttribute)&&(o=l.attributes.position.values.length,arrayFill(o=new Uint8Array(o/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),l.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})),BoundingSphere.fromRectangle3D(t,i,c)),a.position||delete l.attributes.position,new Geometry({attributes:l.attributes,indices:l.indices,primitiveType:l.primitiveType,boundingSphere:c,offsetAttribute:e._offsetAttribute})}},RectangleGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new RectangleGeometry({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:r,extrudedHeight:i,height:t,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})};var unrotatedTextureRectangleScratch=new Rectangle,points2DScratch$1=[new Cartesian2,new Cartesian2,new Cartesian2],rotation2DScratch=new Matrix2,rectangleCenterScratch$2=new Cartographic;function textureCoordinateRotationPoints(e){if(0===e._stRotation)return[0,0,0,1,1,0];var t=Rectangle.clone(e._rectangle,unrotatedTextureRectangleScratch),i=e._granularity,r=e._ellipsoid,t=computeRectangle(t,i,e._rotation-e._stRotation,r,unrotatedTextureRectangleScratch),n=points2DScratch$1;n[0].x=t.west,n[0].y=t.south,n[1].x=t.west,n[1].y=t.north,n[2].x=t.east,n[2].y=t.south;for(var a=e.rectangle,o=Matrix2.fromRotation(e._stRotation,rotation2DScratch),s=Rectangle.center(a,rectangleCenterScratch$2),l=0;l<3;++l){var c=n[l];c.x-=s.longitude,c.y-=s.latitude,Matrix2.multiplyByVector(o,c,c),c.x+=s.longitude,c.y+=s.latitude,c.x=(c.x-a.west)/a.width,c.y=(c.y-a.south)/a.height}i=n[0],r=n[1],t=n[2],e=new Array(6);return Cartesian2.pack(i,e),Cartesian2.pack(r,e,2),Cartesian2.pack(t,e,4),e}Object.defineProperties(RectangleGeometry.prototype,{rectangle:{get:function(){return defined(this._rotatedRectangle)||(this._rotatedRectangle=computeRectangle(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints(this)),this._textureCoordinateRotationPoints}}});var bottomBoundingSphere=new BoundingSphere,topBoundingSphere=new BoundingSphere,positionScratch$8=new Cartesian3,rectangleScratch$3=new Rectangle;function constructRectangle(e,t){var i=e._ellipsoid,r=t.height,n=t.width,a=t.northCap,o=t.southCap,s=r,l=2,c=0,e=4;a&&(--l,--s,c+=1,e-=2),o&&(--l,--s,c+=1,e-=2),c+=l*n+2*s-e;var u,d=new Float64Array(3*c),h=0,p=0,f=positionScratch$8;if(a)RectangleGeometryLibrary.computePosition(t,i,!1,p,0,f),d[h++]=f.x,d[h++]=f.y,d[h++]=f.z;else for(u=0;u<n;u++)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,f),d[h++]=f.x,d[h++]=f.y,d[h++]=f.z;for(u=n-1,p=1;p<r;p++)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,f),d[h++]=f.x,d[h++]=f.y,d[h++]=f.z;if(p=r-1,!o)for(u=n-2;0<=u;u--)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,f),d[h++]=f.x,d[h++]=f.y,d[h++]=f.z;for(u=0,p=r-2;0<p;p--)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,f),d[h++]=f.x,d[h++]=f.y,d[h++]=f.z;for(var o=d.length/3*2,m=IndexDatatype$1.createTypedArray(d.length/3,o),g=0,_=0;_<d.length/3-1;_++)m[g++]=_,m[g++]=_+1;m[g++]=d.length/3-1,m[g++]=0;o=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.LINES});return o.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d}),o.indices=m,o}function constructExtrudedRectangle(e,t){var i=e._surfaceHeight,r=e._extrudedHeight,n=e._ellipsoid,a=r,o=i,s=constructRectangle(e,t),r=t.height,i=t.width,e=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,o,n,!1),l=e.length,o=new Float64Array(2*l);o.set(e);a=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,a,n);o.set(a,l),s.attributes.position.values=o;n=t.northCap,a=t.southCap,t=4;n&&--t,a&&--t;for(var t=2*(o.length/3+t),c=IndexDatatype$1.createTypedArray(o.length/3,t),l=o.length/6,u=0,d=0;d<l-1;d++)c[u++]=d,c[u++]=d+1,c[u++]=d+l,c[u++]=d+l+1;return c[u++]=l-1,c[u++]=0,c[u++]=l+l-1,c[u++]=l,c[u++]=0,c[u++]=l,r=n?r-1:(c[u++]=n=i-1,c[u++]=n+l,i+r-2),c[u++]=r,c[u++]=r+l,a||(c[u++]=r=i+r-1,c[u]=r+l),s.indices=c,s}function RectangleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.rotation,0),a=defaultValue(e.height,0),o=defaultValue(e.extrudedHeight,a);this._rectangle=Rectangle.clone(t),this._granularity=i,this._ellipsoid=r,this._surfaceHeight=Math.max(a,o),this._rotation=n,this._extrudedHeight=Math.min(a,o),this._offsetAttribute=e.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}RectangleOutlineGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+5,RectangleOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._extrudedHeight,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$7=new Rectangle,scratchEllipsoid$3=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$4={rectangle:scratchRectangle$7,ellipsoid:scratchEllipsoid$3,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};RectangleOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$7);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$3);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],t=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._surfaceHeight=o,i._rotation=s,i._extrudedHeight=l,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$4.granularity=a,scratchOptions$4.height=o,scratchOptions$4.rotation=s,scratchOptions$4.extrudedHeight=l,scratchOptions$4.offsetAttribute=-1===t?void 0:t,new RectangleOutlineGeometry(scratchOptions$4))};var nwScratch=new Cartographic;RectangleOutlineGeometry.createGeometry=function(e){var t=e._rectangle,i=e._ellipsoid,r=RectangleGeometryLibrary.computeOptions(t,e._granularity,e._rotation,0,rectangleScratch$3,nwScratch);if(!CesiumMath.equalsEpsilon(t.north,t.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(t.east,t.west,CesiumMath.EPSILON10)){var n,a,o,s=e._surfaceHeight,l=e._extrudedHeight;return s=!CesiumMath.equalsEpsilon(s,l,0,CesiumMath.EPSILON2)?(a=constructExtrudedRectangle(e,r),defined(e._offsetAttribute)&&(n=a.attributes.position.values.length/3,o=new Uint8Array(n),o=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(o,1,0,n/2):arrayFill(o,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})),o=BoundingSphere.fromRectangle3D(t,i,s,topBoundingSphere),l=BoundingSphere.fromRectangle3D(t,i,l,bottomBoundingSphere),BoundingSphere.union(o,l)):((a=constructRectangle(e,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,s,i,!1),defined(e._offsetAttribute)&&(r=a.attributes.position.values.length,arrayFill(r=new Uint8Array(r/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})),BoundingSphere.fromRectangle3D(t,i,s)),new Geometry({attributes:a.attributes,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:s,offsetAttribute:e._offsetAttribute})}};var ReferenceFrame={FIXED:0,INERTIAL:1},ReferenceFrame$1=Object.freeze(ReferenceFrame),S2_MAX_LEVEL=30,S2_LIMIT_IJ=1<<S2_MAX_LEVEL,S2_MAX_SITI=1<<S2_MAX_LEVEL+1>>>0,S2_POSITION_BITS=2*S2_MAX_LEVEL+1,S2_LOOKUP_BITS=4,S2_LOOKUP_POSITIONS=[],S2_LOOKUP_IJ=[],S2_POSITION_TO_IJ=[[0,1,3,2],[0,2,3,1],[3,2,0,1],[3,1,0,2]],S2_SWAP_MASK=1,S2_INVERT_MASK=2,S2_POSITION_TO_ORIENTATION_MASK=[S2_SWAP_MASK,0,0,S2_SWAP_MASK|S2_INVERT_MASK];function S2Cell(e){if(!FeatureDetection.supportsBigInt())throw new RuntimeError("S2 required BigInt support");this._cellId=e,this._level=S2Cell.getLevel(e)}function getS2Center(e,t){t=convertCellIdToFaceSiTi(e,t);return convertFaceSiTitoXYZ(t[0],t[1],t[2])}function getS2Vertex(e,t,i){var r=convertCellIdToFaceIJ(e),e=convertIJLeveltoBoundUV([r[1],r[2]],t),t=i>>1&1;return convertFaceUVtoXYZ(r[0],e[0][t^1&i],e[1][t])}function convertCellIdToFaceSiTi(e,t){var i=convertCellIdToFaceIJ(e),r=i[0],n=i[1],i=i[2],t=30===t,e=!t&&(BigInt(n)^e>>BigInt(2))&BigInt(1),e=t?1:e?2:0;return[r,(n<<1)+e,(i<<1)+e]}function convertCellIdToFaceIJ(e){0===S2_LOOKUP_POSITIONS.length&&generateLookupTable();for(var t=Number(e>>BigInt(S2_POSITION_BITS)),i=t&S2_SWAP_MASK,r=(1<<S2_LOOKUP_BITS)-1,n=0,a=0,o=7;0<=o;o--){var s=(1<<2*(7===o?S2_MAX_LEVEL-7*S2_LOOKUP_BITS:S2_LOOKUP_BITS))-1;i+=Number(e>>BigInt(2*o*S2_LOOKUP_BITS+1)&BigInt(s))<<2;i=S2_LOOKUP_IJ[i],s=o*S2_LOOKUP_BITS;n+=i>>S2_LOOKUP_BITS+2<<s,a+=(i>>2&r)<<s,i&=S2_SWAP_MASK|S2_INVERT_MASK}return[t,n,a]}function convertFaceSiTitoXYZ(e,t,i){t=convertSiTitoST(t),i=convertSiTitoST(i);return convertFaceUVtoXYZ(e,convertSTtoUV(t),convertSTtoUV(i))}function convertFaceUVtoXYZ(e,t,i){switch(e){case 0:return new Cartesian3(1,t,i);case 1:return new Cartesian3(-t,1,i);case 2:return new Cartesian3(-t,-i,1);case 3:return new Cartesian3(-1,-i,-t);case 4:return new Cartesian3(i,-1,-t);default:return new Cartesian3(i,t,-1)}}function convertSTtoUV(e){return.5<=e?1/3*(4*e*e-1):1/3*(1-4*(1-e)*(1-e))}function convertSiTitoST(e){return 1/S2_MAX_SITI*e}function convertIJLeveltoBoundUV(e,t){for(var i=[[],[]],r=getSizeIJ(t),n=0;n<2;++n){var a=e[n]&-r,o=a+r;i[n][0]=convertSTtoUV(convertIJtoSTMinimum(a)),i[n][1]=convertSTtoUV(convertIJtoSTMinimum(o))}return i}function getSizeIJ(e){return 1<<S2_MAX_LEVEL-e>>>0}function convertIJtoSTMinimum(e){return 1/S2_LIMIT_IJ*e}function generateLookupCell(e,t,i,r,n,a){var o;e===S2_LOOKUP_BITS?(S2_LOOKUP_POSITIONS[((o=(t<<S2_LOOKUP_BITS)+i)<<2)+r]=(n<<2)+a,S2_LOOKUP_IJ[(n<<2)+r]=(o<<2)+a):(generateLookupCell(++e,(t<<=1)+((o=S2_POSITION_TO_IJ[a])[0]>>1),(i<<=1)+(1&o[0]),r,n<<=2,a^S2_POSITION_TO_ORIENTATION_MASK[0]),generateLookupCell(e,t+(o[1]>>1),i+(1&o[1]),r,n+1,a^S2_POSITION_TO_ORIENTATION_MASK[1]),generateLookupCell(e,t+(o[2]>>1),i+(1&o[2]),r,n+2,a^S2_POSITION_TO_ORIENTATION_MASK[2]),generateLookupCell(e,t+(o[3]>>1),i+(1&o[3]),r,n+3,a^S2_POSITION_TO_ORIENTATION_MASK[3]))}function generateLookupTable(){generateLookupCell(0,0,0,0,0,0),generateLookupCell(0,0,0,S2_SWAP_MASK,0,S2_SWAP_MASK),generateLookupCell(0,0,0,S2_INVERT_MASK,0,S2_INVERT_MASK),generateLookupCell(0,0,0,S2_SWAP_MASK|S2_INVERT_MASK,0,S2_SWAP_MASK|S2_INVERT_MASK)}function lsb(e){return e&~e+BigInt(1)}function lsbForLevel(e){return BigInt(1)<<BigInt(2*(S2_MAX_LEVEL-e))}S2Cell.fromToken=function(e){return new S2Cell(S2Cell.getIdFromToken(e))},S2Cell.isValidId=function(e){return!(e<=0)&&(!(5<e>>BigInt(S2_POSITION_BITS))&&!!(e&~e+BigInt(1)&BigInt("0x1555555555555555")))},S2Cell.isValidToken=function(e){return!!/^[0-9a-fA-F]{1,16}$/.test(e)&&S2Cell.isValidId(S2Cell.getIdFromToken(e))},S2Cell.getIdFromToken=function(e){return BigInt("0x"+e+"0".repeat(16-e.length))},S2Cell.getTokenFromId=function(e){var t=Math.floor(countTrailingZeroBits(e)/4),e=e.toString(16).replace(/0*$/,"");return Array(17-t-e.length).join("0")+e},S2Cell.getLevel=function(e){for(var t=0;e!==BigInt(0)&&!(e&BigInt(1));)t++,e>>=BigInt(1);return S2_MAX_LEVEL-(t>>1)},S2Cell.prototype.getChild=function(e){var t=lsb(this._cellId)>>BigInt(2);return new S2Cell(this._cellId+BigInt(2*e+1-4)*t)},S2Cell.prototype.getParent=function(){var e=lsb(this._cellId)<<BigInt(2);return new S2Cell(this._cellId&~e+BigInt(1)|e)},S2Cell.prototype.getParentAtLevel=function(e){e=lsbForLevel(e);return new S2Cell(this._cellId&-e|e)},S2Cell.prototype.getCenter=function(e){e=defaultValue(e,Ellipsoid.WGS84);var t=getS2Center(this._cellId,this._level),t=Cartesian3.normalize(t,t),t=new Cartographic.fromCartesian(t,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(t,e,new Cartesian3)},S2Cell.prototype.getVertex=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);e=getS2Vertex(this._cellId,this._level,e),e=Cartesian3.normalize(e,e),e=new Cartographic.fromCartesian(e,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(e,t,new Cartesian3)},S2Cell.fromFacePositionLevel=function(e,t,i){var r=(e<4?"0":"")+(e<2?"0":"")+e.toString(2),e=t.toString(2),t=Array(2*i-e.length+1).join("0"),i=Array(S2_POSITION_BITS-2*i).join("0");return new S2Cell(BigInt("0b"+r+t+e+"1"+i))};var Mod67BitPosition=[64,0,1,39,2,15,40,23,3,12,16,59,41,19,24,54,4,64,13,10,17,62,60,28,42,30,20,51,25,44,55,47,5,32,65,38,14,22,11,58,18,53,63,9,61,27,29,50,43,46,31,37,21,57,52,8,26,49,45,36,56,7,48,35,6,34,33,0];function countTrailingZeroBits(e){return Mod67BitPosition[(-e&e)%BigInt(67)]}var ScreenSpaceEventType={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19},ScreenSpaceEventType$1=Object.freeze(ScreenSpaceEventType);function getPosition$1(e,t,i){e=e._element;if(e===document)return i.x=t.clientX,i.y=t.clientY,i;e=e.getBoundingClientRect();return i.x=t.clientX-e.left,i.y=t.clientY-e.top,i}function getInputEventKey(e,t){return defined(t)&&(e+="+"+t),e}function getModifier(e){return e.shiftKey?KeyboardEventModifier$1.SHIFT:e.ctrlKey?KeyboardEventModifier$1.CTRL:e.altKey?KeyboardEventModifier$1.ALT:void 0}var MouseButton={LEFT:0,MIDDLE:1,RIGHT:2};function registerListener(t,e,i,r){function n(e){r(t,e)}FeatureDetection.isInternetExplorer()?i.addEventListener(e,n,!1):i.addEventListener(e,n,{capture:!1,passive:!1}),t._removalFunctions.push(function(){i.removeEventListener(e,n,!1)})}function registerListeners(e){var t=e._element,i=defined(t.disableRootEvents)?t:document;FeatureDetection.supportsPointerEvents()?(registerListener(e,"pointerdown",t,handlePointerDown),registerListener(e,"pointerup",t,handlePointerUp),registerListener(e,"pointermove",t,handlePointerMove),registerListener(e,"pointercancel",t,handlePointerUp)):(registerListener(e,"mousedown",t,handleMouseDown),registerListener(e,"mouseup",i,handleMouseUp),registerListener(e,"mousemove",i,handleMouseMove),registerListener(e,"touchstart",t,handleTouchStart),registerListener(e,"touchend",i,handleTouchEnd),registerListener(e,"touchmove",i,handleTouchMove),registerListener(e,"touchcancel",i,handleTouchEnd)),registerListener(e,"dblclick",t,handleDblClick),registerListener(e,"onwheel"in t?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",t,handleWheel)}function unregisterListeners(e){for(var t=e._removalFunctions,i=0;i<t.length;++i)t[i]()}var mouseDownEvent={position:new Cartesian2};function gotTouchEvent(e){e._lastSeenTouchEvent=getTimestamp$1()}function canProcessMouseEvent(e){return getTimestamp$1()-e._lastSeenTouchEvent>ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds}function checkPixelTolerance(e,t,i){var r=e.x-t.x,t=e.y-t.y;return Math.sqrt(r*r+t*t)<i}function handleMouseDown(e,t){if(canProcessMouseEvent(e)){var i,r=t.button;if(e._buttonDown[r]=!0,r===MouseButton.LEFT)i=ScreenSpaceEventType$1.LEFT_DOWN;else if(r===MouseButton.MIDDLE)i=ScreenSpaceEventType$1.MIDDLE_DOWN;else{if(r!==MouseButton.RIGHT)return;i=ScreenSpaceEventType$1.RIGHT_DOWN}var n=getPosition$1(e,t,e._primaryPosition);Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition);r=getModifier(t),r=e.getInputAction(i,r);defined(r)&&(Cartesian2.clone(n,mouseDownEvent.position),r(mouseDownEvent),t.preventDefault())}}var mouseUpEvent={position:new Cartesian2},mouseClickEvent={position:new Cartesian2};function cancelMouseEvent(e,t,i,r){var n=getModifier(r),t=e.getInputAction(t,n),n=e.getInputAction(i,n);(defined(t)||defined(n))&&(r=getPosition$1(e,r,e._primaryPosition),defined(t)&&(Cartesian2.clone(r,mouseUpEvent.position),t(mouseUpEvent)),defined(n)&&checkPixelTolerance(e._primaryStartPosition,r,e._clickPixelTolerance)&&(Cartesian2.clone(r,mouseClickEvent.position),n(mouseClickEvent)))}function handleMouseUp(e,t){var i;canProcessMouseEvent(e)&&((i=t.button)!==MouseButton.LEFT&&i!==MouseButton.MIDDLE&&i!==MouseButton.RIGHT||(e._buttonDown[MouseButton.LEFT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.LEFT_UP,ScreenSpaceEventType$1.LEFT_CLICK,t),e._buttonDown[MouseButton.LEFT]=!1),e._buttonDown[MouseButton.MIDDLE]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.MIDDLE_UP,ScreenSpaceEventType$1.MIDDLE_CLICK,t),e._buttonDown[MouseButton.MIDDLE]=!1),e._buttonDown[MouseButton.RIGHT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.RIGHT_UP,ScreenSpaceEventType$1.RIGHT_CLICK,t),e._buttonDown[MouseButton.RIGHT]=!1)))}var mouseMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2};function handleMouseMove(e,t){var i,r,n;canProcessMouseEvent(e)&&(n=getModifier(t),i=getPosition$1(e,t,e._primaryPosition),r=e._primaryPreviousPosition,defined(n=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,n))&&(Cartesian2.clone(r,mouseMoveEvent.startPosition),Cartesian2.clone(i,mouseMoveEvent.endPosition),n(mouseMoveEvent)),Cartesian2.clone(i,r),(e._buttonDown[MouseButton.LEFT]||e._buttonDown[MouseButton.MIDDLE]||e._buttonDown[MouseButton.RIGHT])&&t.preventDefault())}var mouseDblClickEvent={position:new Cartesian2};function handleDblClick(e,t){var i,r;t.button===MouseButton.LEFT&&(i=ScreenSpaceEventType$1.LEFT_DOUBLE_CLICK,r=getModifier(t),defined(r=e.getInputAction(i,r))&&(getPosition$1(e,t,mouseDblClickEvent.position),r(mouseDblClickEvent)))}function handleWheel(e,t){var i,r;i=defined(t.deltaY)?(r=t.deltaMode)===t.DOM_DELTA_PIXEL?-t.deltaY:r===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY:0<t.detail?-120*t.detail:t.wheelDelta,defined(i)&&(r=getModifier(t),defined(r=e.getInputAction(ScreenSpaceEventType$1.WHEEL,r))&&(r(i),t.preventDefault()))}function handleTouchStart(e,t){gotTouchEvent(e);for(var i,r,n=t.changedTouches,a=n.length,o=e._positions,s=0;s<a;++s)r=(i=n[s]).identifier,o.set(r,getPosition$1(e,i,new Cartesian2));fireTouchEvents(e,t);var l=e._previousPositions;for(s=0;s<a;++s)r=(i=n[s]).identifier,l.set(r,Cartesian2.clone(o.get(r)))}function handleTouchEnd(e,t){gotTouchEvent(e);for(var i,r=t.changedTouches,n=r.length,a=e._positions,o=0;o<n;++o)i=r[o].identifier,a.remove(i);fireTouchEvents(e,t);var s=e._previousPositions;for(o=0;o<n;++o)i=r[o].identifier,s.remove(i)}var touchStartEvent={position:new Cartesian2},touch2StartEvent={position1:new Cartesian2,position2:new Cartesian2},touchEndEvent={position:new Cartesian2},touchClickEvent={position:new Cartesian2},touchHoldEvent={position:new Cartesian2};function fireTouchEvents(e,t){var i,r,n,a=getModifier(t),o=e._positions,s=o.length,l=e._isPinching;1!==s&&e._buttonDown[MouseButton.LEFT]&&(e._buttonDown[MouseButton.LEFT]=!1,defined(e._touchHoldTimer)&&(clearTimeout(e._touchHoldTimer),e._touchHoldTimer=void 0),defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_UP,a))&&(Cartesian2.clone(e._primaryPosition,touchEndEvent.position),i(touchEndEvent)),0!==s||e._isTouchHolding||defined(r=e.getInputAction(ScreenSpaceEventType$1.LEFT_CLICK,a))&&checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._clickPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchClickEvent.position),r(touchClickEvent)),e._isTouchHolding=!1),0===s&&l&&(e._isPinching=!1,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_END,a))&&i()),1!==s||l||(n=o.values[0],Cartesian2.clone(n,e._primaryPosition),Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition),e._buttonDown[MouseButton.LEFT]=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_DOWN,a))&&(Cartesian2.clone(n,touchStartEvent.position),i(touchStartEvent)),e._touchHoldTimer=setTimeout(function(){e.isDestroyed()||(e._touchHoldTimer=void 0,e._isTouchHolding=!0,defined(r=e.getInputAction(ScreenSpaceEventType$1.RIGHT_CLICK,a))&&checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._holdPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchHoldEvent.position),r(touchHoldEvent)))},ScreenSpaceEventHandler.touchHoldDelayMilliseconds),t.preventDefault()),2!==s||l||(e._isPinching=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_START,a))&&(Cartesian2.clone(o.values[0],touch2StartEvent.position1),Cartesian2.clone(o.values[1],touch2StartEvent.position2),i(touch2StartEvent),t.preventDefault()))}function handleTouchMove(e,t){gotTouchEvent(e);for(var i=t.changedTouches,r=i.length,n=e._positions,a=0;a<r;++a){var o,s=(o=i[a]).identifier,l=n.get(s);defined(l)&&getPosition$1(e,o,l)}fireTouchMoveEvents(e,t);var c=e._previousPositions;for(a=0;a<r;++a)s=(o=i[a]).identifier,Cartesian2.clone(n.get(s),c.get(s))}var touchMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2},touchPinchMovementEvent={distance:{startPosition:new Cartesian2,endPosition:new Cartesian2},angleAndHeight:{startPosition:new Cartesian2,endPosition:new Cartesian2}};function fireTouchMoveEvents(e,t){var i,r,n,a,o,s=getModifier(t),l=e._positions,c=e._previousPositions,u=l.length;1===u&&e._buttonDown[MouseButton.LEFT]?(o=l.values[0],Cartesian2.clone(o,e._primaryPosition),n=e._primaryPreviousPosition,defined(i=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,s))&&(Cartesian2.clone(n,touchMoveEvent.startPosition),Cartesian2.clone(o,touchMoveEvent.endPosition),i(touchMoveEvent)),Cartesian2.clone(o,n),t.preventDefault()):2===u&&e._isPinching&&defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_MOVE,s))&&(a=l.values[0],r=l.values[1],o=c.values[0],n=c.values[1],t=r.x-a.x,u=r.y-a.y,e=.25*Math.sqrt(t*t+u*u),s=n.x-o.x,l=n.y-o.y,c=.25*Math.sqrt(s*s+l*l),a=.125*(r.y+a.y),o=.125*(n.y+o.y),t=Math.atan2(u,t),s=Math.atan2(l,s),Cartesian2.fromElements(0,c,touchPinchMovementEvent.distance.startPosition),Cartesian2.fromElements(0,e,touchPinchMovementEvent.distance.endPosition),Cartesian2.fromElements(s,o,touchPinchMovementEvent.angleAndHeight.startPosition),Cartesian2.fromElements(t,a,touchPinchMovementEvent.angleAndHeight.endPosition),i(touchPinchMovementEvent))}function handlePointerDown(e,t){var i,r;t.target.setPointerCapture(t.pointerId),"touch"===t.pointerType?(i=e._positions,r=t.pointerId,i.set(r,getPosition$1(e,t,new Cartesian2)),fireTouchEvents(e,t),e._previousPositions.set(r,Cartesian2.clone(i.get(r)))):handleMouseDown(e,t)}function handlePointerUp(e,t){var i,r;"touch"===t.pointerType?(i=e._positions,r=t.pointerId,i.remove(r),fireTouchEvents(e,t),e._previousPositions.remove(r)):handleMouseUp(e,t)}function handlePointerMove(e,t){var i,r,n;"touch"===t.pointerType?(i=e._positions,r=t.pointerId,defined(n=i.get(r))&&(getPosition$1(e,t,n),fireTouchMoveEvents(e,t),n=e._previousPositions,Cartesian2.clone(i.get(r),n.get(r)))):handleMouseMove(e,t)}function ScreenSpaceEventHandler(e){this._inputEvents={},this._buttonDown={LEFT:!1,MIDDLE:!1,RIGHT:!1},this._isPinching=!1,this._isTouchHolding=!1,this._lastSeenTouchEvent=-ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds,this._primaryStartPosition=new Cartesian2,this._primaryPosition=new Cartesian2,this._primaryPreviousPosition=new Cartesian2,this._positions=new AssociativeArray,this._previousPositions=new AssociativeArray,this._removalFunctions=[],this._touchHoldTimer=void 0,this._clickPixelTolerance=5,this._holdPixelTolerance=25,this._element=defaultValue(e,document),registerListeners(this)}function ShowGeometryInstanceAttribute(e){e=defaultValue(e,!0),this.value=ShowGeometryInstanceAttribute.toValue(e)}ScreenSpaceEventHandler.prototype.setInputAction=function(e,t,i){i=getInputEventKey(t,i);this._inputEvents[i]=e},ScreenSpaceEventHandler.prototype.getInputAction=function(e,t){t=getInputEventKey(e,t);return this._inputEvents[t]},ScreenSpaceEventHandler.prototype.removeInputAction=function(e,t){t=getInputEventKey(e,t);delete this._inputEvents[t]},ScreenSpaceEventHandler.prototype.isDestroyed=function(){return!1},ScreenSpaceEventHandler.prototype.destroy=function(){return unregisterListeners(this),destroyObject(this)},ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds=800,ScreenSpaceEventHandler.touchHoldDelayMilliseconds=1500,Object.defineProperties(ShowGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),ShowGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e,t):new Uint8Array([e])};var Simon1994PlanetaryPositions={};function computeTdbMinusTtSpice(e){e=6.239996+.0172019696544*e;return.001657*Math.sin(e+.01671*Math.sin(e))}var TdtMinusTai=32.184,J2000d=2451545;function taiToTdb(e,t){t=JulianDate.addSeconds(e,TdtMinusTai,t);e=JulianDate.totalDays(t)-J2000d;return t=JulianDate.addSeconds(t,computeTdbMinusTtSpice(e),t)}var epoch=new JulianDate(2451545,0,TimeStandard$1.TAI),MetersPerKilometer=1e3,RadiansPerDegree=CesiumMath.RADIANS_PER_DEGREE,RadiansPerArcSecond=CesiumMath.RADIANS_PER_ARCSECOND,MetersPerAstronomicalUnit=14959787e4,perifocalToEquatorial=new Matrix3;function elementsToCartesian(e,t,i,r,n,a,o){i<0&&(i=-i,n+=CesiumMath.PI);var s=e*(1-t),e=r-n,n=n,r=meanAnomalyToTrueAnomaly(a-r,t);perifocalToCartesianMatrix(e,i,n,perifocalToEquatorial);n=s*(1+t),s=Math.cos(r),r=Math.sin(r),t=n/(1+t*s);return defined(o)?(o.x=t*s,o.y=t*r,o.z=0):o=new Cartesian3(t*s,t*r,0),Matrix3.multiplyByVector(perifocalToEquatorial,o,o)}function meanAnomalyToTrueAnomaly(e,t){return eccentricAnomalyToTrueAnomaly(meanAnomalyToEccentricAnomaly(e,t),t)}var maxIterationCount=50,keplerEqConvergence=CesiumMath.EPSILON8;function meanAnomalyToEccentricAnomaly(e,t){for(var i=Math.floor(e/CesiumMath.TWO_PI),r=(e-=i*CesiumMath.TWO_PI)+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),n=Number.MAX_VALUE,a=0;a<maxIterationCount&&Math.abs(n-r)>keplerEqConvergence;++a)r=(n=r)-(n-t*Math.sin(n)-e)/(1-t*Math.cos(n));return n=r+i*CesiumMath.TWO_PI}function eccentricAnomalyToTrueAnomaly(e,t){var i=Math.floor(e/CesiumMath.TWO_PI);e-=i*CesiumMath.TWO_PI;var r=Math.cos(e)-t,t=Math.sin(e)*Math.sqrt(1-t*t),r=Math.atan2(t,r),r=CesiumMath.zeroToTwoPi(r);return e<0&&(r-=CesiumMath.TWO_PI),r+=i*CesiumMath.TWO_PI}function perifocalToCartesianMatrix(e,t,i,r){var n=Math.cos(e),a=Math.sin(e),o=Math.cos(t),e=Math.sin(t),t=Math.cos(i),i=Math.sin(i);return defined(r)?(r[0]=t*n-i*a*o,r[1]=i*n+t*a*o,r[2]=a*e,r[3]=-t*a-i*n*o,r[4]=-i*a+t*n*o,r[5]=n*e,r[6]=i*e,r[7]=-t*e,r[8]=o):r=new Matrix3(t*n-i*a*o,-t*a-i*n*o,i*e,i*n+t*a*o,-i*a+t*n*o,-t*e,a*e,n*e,o),r}var semiMajorAxis0=1.0000010178*MetersPerAstronomicalUnit,meanLongitude0=100.46645683*RadiansPerDegree,meanLongitude1=1295977422.83429*RadiansPerArcSecond,p1u=16002,p2u=21863,p3u=32004,p4u=10931,p5u=14529,p6u=16368,p7u=15318,p8u=32794,Ca1=64e-7*MetersPerAstronomicalUnit,Ca2=-152e-7*MetersPerAstronomicalUnit,Ca3=62e-7*MetersPerAstronomicalUnit,Ca4=-8e-7*MetersPerAstronomicalUnit,Ca5=32e-7*MetersPerAstronomicalUnit,Ca6=-41e-7*MetersPerAstronomicalUnit,Ca7=19e-7*MetersPerAstronomicalUnit,Ca8=-11e-7*MetersPerAstronomicalUnit,Sa1=1e-7*-150*MetersPerAstronomicalUnit,Sa2=-46e-7*MetersPerAstronomicalUnit,Sa3=68*1e-7*MetersPerAstronomicalUnit,Sa4=54e-7*MetersPerAstronomicalUnit,Sa5=14e-7*MetersPerAstronomicalUnit,Sa6=24e-7*MetersPerAstronomicalUnit,Sa7=-28e-7*MetersPerAstronomicalUnit,Sa8=22e-7*MetersPerAstronomicalUnit,q1u=10,q2u=16002,q3u=21863,q4u=10931,q5u=1473,q6u=32004,q7u=4387,q8u=73,Cl1=-325e-7,Cl2=-322e-7,Cl3=1e-7*-79,Cl4=232*1e-7,Cl5=1e-7*-52,Cl6=97e-7,Cl7=55e-7,Cl8=-41e-7,Sl1=-105e-7,Sl2=-137e-7,Sl3=258e-7,Sl4=35e-7,Sl5=1e-7*-116,Sl6=-88e-7,Sl7=-112e-7,Sl8=-8e-6,scratchDate$1=new JulianDate(0,0,TimeStandard$1.TAI);function computeSimonEarthMoonBarycenter(e,t){taiToTdb(e,scratchDate$1);var i=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/(10*TimeConstants$1.DAYS_PER_JULIAN_CENTURY),r=.3595362*i,e=semiMajorAxis0+Ca1*Math.cos(p1u*r)+Sa1*Math.sin(p1u*r)+Ca2*Math.cos(p2u*r)+Sa2*Math.sin(p2u*r)+Ca3*Math.cos(p3u*r)+Sa3*Math.sin(p3u*r)+Ca4*Math.cos(p4u*r)+Sa4*Math.sin(p4u*r)+Ca5*Math.cos(p5u*r)+Sa5*Math.sin(p5u*r)+Ca6*Math.cos(p6u*r)+Sa6*Math.sin(p6u*r)+Ca7*Math.cos(p7u*r)+Sa7*Math.sin(p7u*r)+Ca8*Math.cos(p8u*r)+Sa8*Math.sin(p8u*r),r=meanLongitude0+meanLongitude1*i+Cl1*Math.cos(q1u*r)+Sl1*Math.sin(q1u*r)+Cl2*Math.cos(q2u*r)+Sl2*Math.sin(q2u*r)+Cl3*Math.cos(q3u*r)+Sl3*Math.sin(q3u*r)+Cl4*Math.cos(q4u*r)+Sl4*Math.sin(q4u*r)+Cl5*Math.cos(q5u*r)+Sl5*Math.sin(q5u*r)+Cl6*Math.cos(q6u*r)+Sl6*Math.sin(q6u*r)+Cl7*Math.cos(q7u*r)+Sl7*Math.sin(q7u*r)+Cl8*Math.cos(q8u*r)+Sl8*Math.sin(q8u*r);return elementsToCartesian(e,.0167086342-.0004203654*i,469.97289*RadiansPerArcSecond*i,102.93734808*RadiansPerDegree+11612.3529*RadiansPerArcSecond*i,174.87317577*RadiansPerDegree-8679.27034*RadiansPerArcSecond*i,r,t)}function computeSimonMoon(e,t){taiToTdb(e,scratchDate$1);var i=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,r=i*i,n=r*i,a=n*i,o=383397.7725+.004*i,s=.055545526-16e-9*i,l=5.15668983*RadiansPerDegree,c=-8e-5*i+.02966*r-42e-6*n-13e-8*a,u=83.35324312*RadiansPerDegree,d=14643420.2669*i-38.2702*r-.045047*n+21301e-8*a,h=125.04455501*RadiansPerDegree,p=-6967919.3631*i+6.3602*r+.007625*n-3586e-8*a,f=218.31664563*RadiansPerDegree,m=1732559343.4847*i-6.391*r+.006588*n-3169e-8*a,g=297.85019547*RadiansPerDegree+RadiansPerArcSecond*(1602961601.209*i-6.3706*r+.006593*n-3169e-8*a),_=134.96340251*RadiansPerDegree+RadiansPerArcSecond*(1717915923.2178*i+31.8792*r+.051635*n-2447e-7*a),y=357.52910918*RadiansPerDegree+RadiansPerArcSecond*(129596581.0481*i-.5532*r+136e-6*n-1149e-8*a),C=310.17137918*RadiansPerDegree-RadiansPerArcSecond*(6967051.436*i+6.2068*r+.007618*n-3219e-8*a),v=2*g,T=4*g,S=6*g,A=2*_,x=3*_,e=4*_,a=2*(93.27209062*RadiansPerDegree+RadiansPerArcSecond*(1739527262.8478*i-12.7512*r-.001037*n+417e-8*a));o+=3400.4*Math.cos(v)-635.6*Math.cos(v-_)-235.6*Math.cos(_)+218.1*Math.cos(v-y)+181*Math.cos(v+_),s+=.014216*Math.cos(v-_)+.008551*Math.cos(v-A)-.001383*Math.cos(_)+.001356*Math.cos(v+_)-.001147*Math.cos(T-x)-914e-6*Math.cos(T-A)+869e-6*Math.cos(v-y-_)-627e-6*Math.cos(v)-394e-6*Math.cos(T-e)+282e-6*Math.cos(v-y-A)-279e-6*Math.cos(g-_)-236e-6*Math.cos(A)+231e-6*Math.cos(T)+229e-6*Math.cos(S-e)-201e-6*Math.cos(A-a),c+=486.26*Math.cos(v-a)-40.13*Math.cos(v)+37.51*Math.cos(a)+25.73*Math.cos(A-a)+19.97*Math.cos(v-y-a),d+=-55609*Math.sin(v-_)-34711*Math.sin(v-A)-9792*Math.sin(_)+9385*Math.sin(T-x)+7505*Math.sin(T-A)+5318*Math.sin(v+_)+3484*Math.sin(T-e)-3417*Math.sin(v-y-_)-2530*Math.sin(S-e)-2376*Math.sin(v)-2075*Math.sin(v-x)-1883*Math.sin(A)-1736*Math.sin(S-5*_)+1626*Math.sin(y)-1370*Math.sin(S-x),p+=-5392*Math.sin(v-a)-540*Math.sin(y)-441*Math.sin(v)+423*Math.sin(a)-288*Math.sin(A-a),m+=-3332.9*Math.sin(v)+1197.4*Math.sin(v-_)-662.5*Math.sin(y)+396.3*Math.sin(_)-218*Math.sin(v-y);A=2*C,_=3*C;c+=46.997*Math.cos(C)*i-.614*Math.cos(v-a+C)*i+.614*Math.cos(v-a-C)*i-.0297*Math.cos(A)*r-.0335*Math.cos(C)*r+.0012*Math.cos(v-a+A)*r-16e-5*Math.cos(C)*n+4e-5*Math.cos(_)*n+4e-5*Math.cos(A)*n;y=2.116*Math.sin(C)*i-.111*Math.sin(v-a-C)*i-.0015*Math.sin(C)*r;return d+=y,m+=y,p+=-520.77*Math.sin(C)*i+13.66*Math.sin(v-a+C)*i+1.12*Math.sin(v-C)*i-1.06*Math.sin(a-C)*i+.66*Math.sin(A)*r+.371*Math.sin(C)*r-.035*Math.sin(v-a+A)*r-.015*Math.sin(v-a+C)*r+.0014*Math.sin(C)*n-.0011*Math.sin(_)*n-9e-4*Math.sin(A)*n,elementsToCartesian(o*=MetersPerKilometer,s,l+c*RadiansPerArcSecond,u+d*RadiansPerArcSecond,h+p*RadiansPerArcSecond,f+m*RadiansPerArcSecond,t)}var moonEarthMassRatio=.012300034,factor=moonEarthMassRatio/(moonEarthMassRatio+1)*-1;function computeSimonEarth(e,t){return t=computeSimonMoon(e,t),Cartesian3.multiplyByScalar(t,factor,t)}var axesTransformation=new Matrix3(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819),translation=new Cartesian3;function interpolateColors(e,t,i,r,n,a,o){var s=PolylinePipeline.numberOfPoints(e,t,n),l=i.red,c=i.green,u=i.blue,d=i.alpha,h=r.red,e=r.green,t=r.blue,n=r.alpha;if(Color.equals(i,r)){for(y=0;y<s;y++)a[o++]=Color.floatToByte(l),a[o++]=Color.floatToByte(c),a[o++]=Color.floatToByte(u),a[o++]=Color.floatToByte(d);return o}for(var p=(h-l)/s,f=(e-c)/s,m=(t-u)/s,g=(n-d)/s,_=o,y=0;y<s;y++)a[_++]=Color.floatToByte(l+y*p),a[_++]=Color.floatToByte(c+y*f),a[_++]=Color.floatToByte(u+y*m),a[_++]=Color.floatToByte(d+y*g);return _}function SimplePolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._colorsPerVertex=r,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._workerName="createSimplePolylineGeometry";t=1+t.length*Cartesian3.packedLength;t+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=t+Ellipsoid.packedLength+3}Simon1994PlanetaryPositions.computeSunPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),defined(t)||(t=new Cartesian3),translation=computeSimonEarthMoonBarycenter(e,translation),t=Cartesian3.negate(translation,t),computeSimonEarth(e,translation),Cartesian3.subtract(t,translation,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame=function(e,t){return t=computeSimonMoon(e=!defined(e)?JulianDate.now():e,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},SimplePolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors,a=defined(o)?o.length:0;for(t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t},SimplePolylineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=0<(r=e[t++])?new Array(r):void 0;for(a=0;a<r;++a,t+=Color.packedLength)o[a]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t);t+=Ellipsoid.packedLength;var l=1===e[t++],c=e[t++],u=e[t];return defined(i)?(i._positions=n,i._colors=o,i._ellipsoid=s,i._colorsPerVertex=l,i._arcType=c,i._granularity=u,i):new SimplePolylineGeometry({positions:n,colors:o,ellipsoid:s,colorsPerVertex:l,arcType:c,granularity:u})};var scratchArray1=new Array(2),scratchArray2=new Array(2),generateArcOptionsScratch$1={positions:scratchArray1,height:scratchArray2,ellipsoid:void 0,minDistance:void 0,granularity:void 0};function SphereGeometry(e){var t=defaultValue(e.radius,1),e={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,vertexFormat:e.vertexFormat};this._ellipsoidGeometry=new EllipsoidGeometry(e),this._workerName="createSphereGeometry"}SimplePolylineGeometry.createGeometry=function(e){var t=e._positions,i=e._colors,r=e._colorsPerVertex,n=e._arcType,a=e._granularity,e=e._ellipsoid,o=CesiumMath.chordLength(a,e.maximumRadius),s=defined(i)&&!r,l=t.length,c=0;if(n===ArcType$1.GEODESIC||n===ArcType$1.RHUMB){var u,d,h=n===ArcType$1.GEODESIC?(u=CesiumMath.chordLength(a,e.maximumRadius),d=PolylinePipeline.numberOfPoints,PolylinePipeline.generateArc):(u=a,d=PolylinePipeline.numberOfPointsRhumbLine,PolylinePipeline.generateRhumbArc),p=PolylinePipeline.extractHeights(t,e),f=generateArcOptionsScratch$1;if(n===ArcType$1.GEODESIC?f.minDistance=o:f.granularity=a,f.ellipsoid=e,s){for(var m=0,g=0;g<l-1;g++)m+=d(t[g],t[g+1],u)+1;x=new Float64Array(3*m),b=new Uint8Array(4*m),f.positions=scratchArray1,f.height=scratchArray2;var _=0;for(g=0;g<l-1;++g){scratchArray1[0]=t[g],scratchArray1[1]=t[g+1],scratchArray2[0]=p[g],scratchArray2[1]=p[g+1];var y=h(f);if(defined(i))for(var C=y.length/3,v=i[g],T=0;T<C;++T)b[_++]=Color.floatToByte(v.red),b[_++]=Color.floatToByte(v.green),b[_++]=Color.floatToByte(v.blue),b[_++]=Color.floatToByte(v.alpha);x.set(y,c),c+=y.length}}else if(f.positions=t,f.height=p,x=new Float64Array(h(f)),defined(i)){for(b=new Uint8Array(x.length/3*4),g=0;g<l-1;++g)c=interpolateColors(t[g],t[g+1],i[g],i[g+1],o,b,c);var S=i[l-1];b[c++]=Color.floatToByte(S.red),b[c++]=Color.floatToByte(S.green),b[c++]=Color.floatToByte(S.blue),b[c++]=Color.floatToByte(S.alpha)}}else{var A=s?2*l-2:l,x=new Float64Array(3*A),b=defined(i)?new Uint8Array(4*A):void 0,E=0,P=0;for(g=0;g<l;++g){var D=t[g];if(s&&0<g&&(Cartesian3.pack(D,x,E),E+=3,v=i[g-1],b[P++]=Color.floatToByte(v.red),b[P++]=Color.floatToByte(v.green),b[P++]=Color.floatToByte(v.blue),b[P++]=Color.floatToByte(v.alpha)),s&&g===l-1)break;Cartesian3.pack(D,x,E),E+=3,defined(i)&&(v=i[g],b[P++]=Color.floatToByte(v.red),b[P++]=Color.floatToByte(v.green),b[P++]=Color.floatToByte(v.blue),b[P++]=Color.floatToByte(v.alpha))}}S=new GeometryAttributes;S.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:x}),defined(i)&&(S.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:b,normalize:!0})),A=x.length/3;var w=IndexDatatype$1.createTypedArray(A,2*(A-1)),M=0;for(g=0;g<A-1;++g)w[M++]=g,w[M++]=g+1;return new Geometry({attributes:S,indices:w,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromPoints(t)})},SphereGeometry.packedLength=EllipsoidGeometry.packedLength,SphereGeometry.pack=function(e,t,i){return EllipsoidGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry$1=new EllipsoidGeometry,scratchOptions$3={radius:void 0,radii:new Cartesian3,vertexFormat:new VertexFormat,stackPartitions:void 0,slicePartitions:void 0};function SphereOutlineGeometry(e){var t=defaultValue(e.radius,1),e={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,subdivisions:e.subdivisions};this._ellipsoidGeometry=new EllipsoidOutlineGeometry(e),this._workerName="createSphereOutlineGeometry"}SphereGeometry.unpack=function(e,t,i){t=EllipsoidGeometry.unpack(e,t,scratchEllipsoidGeometry$1);return scratchOptions$3.vertexFormat=VertexFormat.clone(t._vertexFormat,scratchOptions$3.vertexFormat),scratchOptions$3.stackPartitions=t._stackPartitions,scratchOptions$3.slicePartitions=t._slicePartitions,defined(i)?(Cartesian3.clone(t._radii,scratchOptions$3.radii),i._ellipsoidGeometry=new EllipsoidGeometry(scratchOptions$3),i):(scratchOptions$3.radius=t._radii.x,new SphereGeometry(scratchOptions$3))},SphereGeometry.createGeometry=function(e){return EllipsoidGeometry.createGeometry(e._ellipsoidGeometry)},SphereOutlineGeometry.packedLength=EllipsoidOutlineGeometry.packedLength,SphereOutlineGeometry.pack=function(e,t,i){return EllipsoidOutlineGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry=new EllipsoidOutlineGeometry,scratchOptions$2={radius:void 0,radii:new Cartesian3,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};function Spherical(e,t,i){this.clock=defaultValue(e,0),this.cone=defaultValue(t,0),this.magnitude=defaultValue(i,1)}SphereOutlineGeometry.unpack=function(e,t,i){t=EllipsoidOutlineGeometry.unpack(e,t,scratchEllipsoidGeometry);return scratchOptions$2.stackPartitions=t._stackPartitions,scratchOptions$2.slicePartitions=t._slicePartitions,scratchOptions$2.subdivisions=t._subdivisions,defined(i)?(Cartesian3.clone(t._radii,scratchOptions$2.radii),i._ellipsoidGeometry=new EllipsoidOutlineGeometry(scratchOptions$2),i):(scratchOptions$2.radius=t._radii.x,new SphereOutlineGeometry(scratchOptions$2))},SphereOutlineGeometry.createGeometry=function(e){return EllipsoidOutlineGeometry.createGeometry(e._ellipsoidGeometry)},Spherical.fromCartesian3=function(e,t){var i=e.x,r=e.y,n=e.z,e=i*i+r*r;return(t=!defined(t)?new Spherical:t).clock=Math.atan2(r,i),t.cone=Math.atan2(Math.sqrt(e),n),t.magnitude=Math.sqrt(e+n*n),t},Spherical.clone=function(e,t){if(defined(e))return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new Spherical(e.clock,e.cone,e.magnitude)},Spherical.normalize=function(e,t){return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=1,t):new Spherical(e.clock,e.cone,1)},Spherical.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},Spherical.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.clock-t.clock)<=i&&Math.abs(e.cone-t.cone)<=i&&Math.abs(e.magnitude-t.magnitude)<=i},Spherical.prototype.equals=function(e){return Spherical.equals(this,e)},Spherical.prototype.clone=function(e){return Spherical.clone(this,e)},Spherical.prototype.equalsEpsilon=function(e,t){return Spherical.equalsEpsilon(this,e,t)},Spherical.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"};var TileEdge={WEST:0,NORTH:1,EAST:2,SOUTH:3,NORTHWEST:4,NORTHEAST:5,SOUTHWEST:6,SOUTHEAST:7};function TilingScheme(e){}function compareIntervalStartTimes(e,t){return JulianDate.compare(e.start,t.start)}function TimeIntervalCollection(e){if(this._intervals=[],this._changedEvent=new Event,defined(e))for(var t=e.length,i=0;i<t;i++)this.addInterval(e[i])}Object.defineProperties(TilingScheme.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError},rectangle:{get:DeveloperError.throwInstantiationError},projection:{get:DeveloperError.throwInstantiationError}}),TilingScheme.prototype.getNumberOfXTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.getNumberOfYTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.rectangleToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.positionToTileXY=DeveloperError.throwInstantiationError,Object.defineProperties(TimeIntervalCollection.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0!==e.length&&e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0!==t&&e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),TimeIntervalCollection.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof TimeIntervalCollection))return!1;var i=this._intervals,r=e._intervals,n=i.length;if(n!==r.length)return!1;for(var a=0;a<n;a++)if(!TimeInterval.equals(i[a],r[a],t))return!1;return!0},TimeIntervalCollection.prototype.get=function(e){return this._intervals[e]},TimeIntervalCollection.prototype.removeAll=function(){0<this._intervals.length&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},TimeIntervalCollection.prototype.findIntervalContainingDate=function(e){e=this.indexOf(e);return 0<=e?this._intervals[e]:void 0},TimeIntervalCollection.prototype.findDataForIntervalContainingDate=function(e){e=this.indexOf(e);return 0<=e?this._intervals[e].data:void 0},TimeIntervalCollection.prototype.contains=function(e){return 0<=this.indexOf(e)};var indexOfScratch=new TimeInterval;TimeIntervalCollection.prototype.indexOf=function(e){var t=this._intervals;indexOfScratch.start=e,indexOfScratch.stop=e;var i=binarySearch(t,indexOfScratch,compareIntervalStartTimes);return 0<=i?t[i].isStartIncluded?i:0<i&&t[i-1].stop.equals(e)&&t[i-1].isStopIncluded?i-1:~i:0<(i=~i)&&i-1<t.length&&TimeInterval.contains(t[i-1],e)?i-1:~i},TimeIntervalCollection.prototype.findInterval=function(e){for(var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).start,i=e.stop,r=e.isStartIncluded,n=e.isStopIncluded,a=this._intervals,o=0,s=a.length;o<s;o++){var l=a[o];if((!defined(t)||l.start.equals(t))&&(!defined(i)||l.stop.equals(i))&&(!defined(r)||l.isStartIncluded===r)&&(!defined(n)||l.isStopIncluded===n))return a[o]}},TimeIntervalCollection.prototype.addInterval=function(e,t){if(!e.isEmpty){var i=this._intervals;if(0===i.length||JulianDate.greaterThan(e.start,i[i.length-1].stop))return i.push(e),void this._changedEvent.raiseEvent(this);var r,n=binarySearch(i,e,compareIntervalStartTimes);for(n<0?n=~n:0<n&&e.isStartIncluded&&i[n-1].isStartIncluded&&i[n-1].start.equals(e.start)?--n:n<i.length&&!e.isStartIncluded&&i[n].isStartIncluded&&i[n].start.equals(e.start)&&++n,0<n&&(0<(r=JulianDate.compare(i[n-1].stop,e.start))||0===r&&(i[n-1].isStopIncluded||e.isStartIncluded))&&((defined(t)?t(i[n-1].data,e.data):i[n-1].data===e.data)?(e=JulianDate.greaterThan(e.stop,i[n-1].stop)?new TimeInterval({start:i[n-1].start,stop:e.stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:e.isStopIncluded,data:e.data}):new TimeInterval({start:i[n-1].start,stop:i[n-1].stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:i[n-1].isStopIncluded||e.stop.equals(i[n-1].stop)&&e.isStopIncluded,data:e.data}),i.splice(n-1,1),--n):((0<(r=JulianDate.compare(i[n-1].stop,e.stop))||0===r&&i[n-1].isStopIncluded&&!e.isStopIncluded)&&i.splice(n,0,new TimeInterval({start:e.stop,stop:i[n-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n-1].isStopIncluded,data:i[n-1].data})),i[n-1]=new TimeInterval({start:i[n-1].start,stop:e.start,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:i[n-1].data})));n<i.length&&(0<(r=JulianDate.compare(e.stop,i[n].start))||0===r&&(e.isStopIncluded||i[n].isStartIncluded));)if(defined(t)?t(i[n].data,e.data):i[n].data===e.data)e=new TimeInterval({start:e.start,stop:(JulianDate.greaterThan(i[n].stop,e.stop)?i[n]:e).stop,isStartIncluded:e.isStartIncluded,isStopIncluded:(JulianDate.greaterThan(i[n].stop,e.stop)?i[n]:e).isStopIncluded,data:e.data}),i.splice(n,1);else{if(i[n]=new TimeInterval({start:e.stop,stop:i[n].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n].isStopIncluded,data:i[n].data}),!i[n].isEmpty)break;i.splice(n,1)}i.splice(n,0,e),this._changedEvent.raiseEvent(this)}},TimeIntervalCollection.prototype.removeInterval=function(e){if(e.isEmpty)return!1;var t=this._intervals,i=binarySearch(t,e,compareIntervalStartTimes),r=!1;for(0<(i=i<0?~i:i)&&(JulianDate.greaterThan(t[i-1].stop,e.start)||t[i-1].stop.equals(e.start)&&t[i-1].isStopIncluded&&e.isStartIncluded)&&(r=!0,(JulianDate.greaterThan(t[i-1].stop,e.stop)||t[i-1].isStopIncluded&&!e.isStopIncluded&&t[i-1].stop.equals(e.stop))&&t.splice(i,0,new TimeInterval({start:e.stop,stop:t[i-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i-1].isStopIncluded,data:t[i-1].data})),t[i-1]=new TimeInterval({start:t[i-1].start,stop:e.start,isStartIncluded:t[i-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:t[i-1].data})),i<t.length&&!e.isStartIncluded&&t[i].isStartIncluded&&e.start.equals(t[i].start)&&(t.splice(i,0,new TimeInterval({start:t[i].start,stop:t[i].start,isStartIncluded:r=!0,isStopIncluded:!0,data:t[i].data})),++i);i<t.length&&JulianDate.greaterThan(e.stop,t[i].stop);)r=!0,t.splice(i,1);return i<t.length&&e.stop.equals(t[i].stop)&&(r=!0,!e.isStopIncluded&&t[i].isStopIncluded?i+1<t.length&&t[i+1].start.equals(e.stop)&&t[i].data===t[i+1].data?(t.splice(i,1),t[i]=new TimeInterval({start:t[i].start,stop:t[i].stop,isStartIncluded:!0,isStopIncluded:t[i].isStopIncluded,data:t[i].data})):t[i]=new TimeInterval({start:e.stop,stop:e.stop,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data}):t.splice(i,1)),i<t.length&&(JulianDate.greaterThan(e.stop,t[i].start)||e.stop.equals(t[i].start)&&e.isStopIncluded&&t[i].isStartIncluded)&&(r=!0,t[i]=new TimeInterval({start:e.stop,stop:t[i].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i].isStopIncluded,data:t[i].data})),r&&this._changedEvent.raiseEvent(this),r},TimeIntervalCollection.prototype.intersect=function(e,t,i){for(var r=new TimeIntervalCollection,n=0,a=0,o=this._intervals,s=e._intervals;n<o.length&&a<s.length;){var l,c=o[n],u=s[a];JulianDate.lessThan(c.stop,u.start)?++n:JulianDate.lessThan(u.stop,c.start)?++a:((defined(i)||defined(t)&&t(c.data,u.data)||!defined(t)&&u.data===c.data)&&((l=TimeInterval.intersect(c,u,new TimeInterval,i)).isEmpty||r.addInterval(l,t)),JulianDate.lessThan(c.stop,u.stop)||c.stop.equals(u.stop)&&!c.isStopIncluded&&u.isStopIncluded?++n:++a)}return r},TimeIntervalCollection.fromJulianDateArray=function(e,t){defined(t)||(t=new TimeIntervalCollection);var i=e.julianDates,r=i.length,n=e.dataCallback,a=defaultValue(e.isStartIncluded,!0),o=defaultValue(e.isStopIncluded,!0),s=defaultValue(e.leadingInterval,!1),e=defaultValue(e.trailingInterval,!1),l=0;s&&(++l,(u=new TimeInterval({start:Iso8601.MINIMUM_VALUE,stop:i[0],isStartIncluded:!0,isStopIncluded:!a})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u));for(var c=0;c<r-1;++c){var u,d=i[c],h=i[c+1];(u=new TimeInterval({start:d,stop:h,isStartIncluded:t.length!==l||a,isStopIncluded:c===r-2&&o})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u),0}return e&&((u=new TimeInterval({start:i[r-1],stop:Iso8601.MAXIMUM_VALUE,isStartIncluded:!o,isStopIncluded:!0})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u)),t};var scratchGregorianDate=new GregorianDate,monthLengths=[0,31,28,31,30,31,30,31,31,30,31,30,31];function addToDate(e,t,i){defined(i)||(i=new JulianDate),JulianDate.toGregorianDate(e,scratchGregorianDate);var r=scratchGregorianDate.millisecond+t.millisecond,n=scratchGregorianDate.second+t.second,a=scratchGregorianDate.minute+t.minute,e=scratchGregorianDate.hour+t.hour,o=scratchGregorianDate.day+t.day,s=scratchGregorianDate.month+t.month,l=scratchGregorianDate.year+t.year;for(1e3<=r&&(n+=Math.floor(r/1e3),r%=1e3),60<=n&&(a+=Math.floor(n/60),n%=60),60<=a&&(e+=Math.floor(a/60),a%=60),24<=e&&(o+=Math.floor(e/24),e%=24),monthLengths[2]=isLeapYear(l)?29:28;o>monthLengths[s]||13<=s;)o>monthLengths[s]&&(o-=monthLengths[s],++s),13<=s&&(--s,l+=Math.floor(s/12),s%=12,++s),monthLengths[2]=isLeapYear(l)?29:28;return scratchGregorianDate.millisecond=r,scratchGregorianDate.second=n,scratchGregorianDate.minute=a,scratchGregorianDate.hour=e,scratchGregorianDate.day=o,scratchGregorianDate.month=s,scratchGregorianDate.year=l,JulianDate.fromGregorianDate(scratchGregorianDate,i)}var scratchJulianDate$2=new JulianDate,durationRegex=/P(?:([\d.,]+)Y)?(?:([\d.,]+)M)?(?:([\d.,]+)W)?(?:([\d.,]+)D)?(?:T(?:([\d.,]+)H)?(?:([\d.,]+)M)?(?:([\d.,]+)S)?)?/;function parseDuration(e,t){if(defined(e)&&0!==e.length){if(t.year=0,t.month=0,t.day=0,t.hour=0,t.minute=0,t.second=0,"P"===e[t.millisecond=0]){var i=e.match(durationRegex);if(!defined(i))return;defined(i[1])&&(t.year=Number(i[1].replace(",","."))),defined(i[2])&&(t.month=Number(i[2].replace(",","."))),defined(i[3])&&(t.day=7*Number(i[3].replace(",","."))),defined(i[4])&&(t.day+=Number(i[4].replace(",","."))),defined(i[5])&&(t.hour=Number(i[5].replace(",","."))),defined(i[6])&&(t.minute=Number(i[6].replace(",","."))),defined(i[7])&&(i=Number(i[7].replace(",",".")),t.second=Math.floor(i),t.millisecond=i%1*1e3)}else"Z"!==e[e.length-1]&&(e+="Z"),JulianDate.toGregorianDate(JulianDate.fromIso8601(e,scratchJulianDate$2),t);return t.year||t.month||t.day||t.hour||t.minute||t.second||t.millisecond}}var scratchDuration=new GregorianDate;TimeIntervalCollection.fromIso8601=function(e,t){var i=e.iso8601.split("/"),r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=[];if(parseDuration(i[2],scratchDuration)){var o=JulianDate.clone(r);for(a.push(o);JulianDate.compare(o,n)<0;){o=addToDate(o,scratchDuration);JulianDate.compare(n,o)<=0&&JulianDate.clone(n,o),a.push(o)}}else a.push(r,n);return TimeIntervalCollection.fromJulianDateArray({julianDates:a,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DateArray=function(e,t){return TimeIntervalCollection.fromJulianDateArray({julianDates:e.iso8601Dates.map(function(e){return JulianDate.fromIso8601(e)}),isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DurationArray=function(e,t){for(var i,r,n=e.epoch,a=e.iso8601Durations,o=defaultValue(e.relativeToPrevious,!1),s=[],l=a.length,c=0;c<l;++c)!parseDuration(a[c],scratchDuration)&&0!==c||(i=o&&defined(r)?addToDate(r,scratchDuration):addToDate(n,scratchDuration),s.push(i),r=i);return TimeIntervalCollection.fromJulianDateArray({julianDates:s,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)};var defaultScale$4=new Cartesian3(1,1,1),defaultTranslation=Cartesian3.ZERO,defaultRotation$1=Quaternion.IDENTITY;function TranslationRotationScale(e,t,i){this.translation=Cartesian3.clone(defaultValue(e,defaultTranslation)),this.rotation=Quaternion.clone(defaultValue(t,defaultRotation$1)),this.scale=Cartesian3.clone(defaultValue(i,defaultScale$4))}TranslationRotationScale.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this.translation,e.translation)&&Quaternion.equals(this.rotation,e.rotation)&&Cartesian3.equals(this.scale,e.scale)};var context2DsByWidthAndHeight={};function getImagePixels(e,t,i){defined(t)||(t=e.width),defined(i)||(i=e.height);var r=context2DsByWidthAndHeight[t];defined(r)||(context2DsByWidthAndHeight[t]=r={});var n,a=r[i];return defined(a)||((n=document.createElement("canvas")).width=t,n.height=i,(a=n.getContext("2d")).globalCompositeOperation="copy",r[i]=a),a.drawImage(e,0,0,t,i),a.getImageData(0,0,t,i).data}function DataRectangle(e,t){this.rectangle=e,this.maxLevel=t}function VRTheWorldTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=Resource.createIfNeeded(e.url);this._resource=t,this._errorEvent=new Event,this._ready=!1,this._readyPromise=when.defer(),this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0,lowestEncodedHeight:0,highestEncodedHeight:16777215};t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._tilingScheme=void 0,this._rectangles=[];var i,u=this,d=defaultValue(e.ellipsoid,Ellipsoid.WGS84);function r(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"===t){u._tilingScheme=new GeographicTilingScheme({ellipsoid:d});var i=e.getElementsByTagName("TileFormat")[0];u._heightmapWidth=parseInt(i.getAttribute("width"),10),u._heightmapHeight=parseInt(i.getAttribute("height"),10),u._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(d,Math.min(u._heightmapWidth,u._heightmapHeight),u._tilingScheme.getNumberOfXTilesAtLevel(0));for(var r=e.getElementsByTagName("DataExtent"),n=0;n<r.length;++n){var a=r[n],o=CesiumMath.toRadians(parseFloat(a.getAttribute("minx"))),s=CesiumMath.toRadians(parseFloat(a.getAttribute("miny"))),l=CesiumMath.toRadians(parseFloat(a.getAttribute("maxx"))),c=CesiumMath.toRadians(parseFloat(a.getAttribute("maxy"))),a=parseInt(a.getAttribute("maxlevel"),10);u._rectangles.push(new DataRectangle(new Rectangle(o,s,l,c),a))}u._ready=!0,u._readyPromise.resolve(!0)}else h("SRS "+t+" is not supported.")}function h(e){e=defaultValue(e,"An error occurred while accessing "+u._resource.url+".");i=TileProviderError.handleError(i,u,u._errorEvent,e,void 0,void 0,void 0,n)}function n(){when(u._resource.fetchXML(),r,h)}n()}Object.defineProperties(VRTheWorldTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),VRTheWorldTerrainProvider.prototype.requestTileGeometry=function(t,i,r,e){var n=this._tilingScheme.getNumberOfYTilesAtLevel(r),e=this._resource.getDerivedResource({url:r+"/"+t+"/"+(n-i-1)+".tif",queryParameters:{cesium:!0},request:e}).fetchImage({preferImageBitmap:!0});if(defined(e)){var a=this;return when(e).then(function(e){return new HeightmapTerrainData({buffer:getImagePixels(e),width:a._heightmapWidth,height:a._heightmapHeight,childTileMask:getChildMask(a,t,i,r),structure:a._terrainDataStructure})})}},VRTheWorldTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};var rectangleScratch$2=new Rectangle;function getChildMask(e,t,i,r){for(var n=e._tilingScheme,a=e._rectangles,o=n.tileXYToRectangle(t,i,r),s=0,l=0;l<a.length&&15!==s;++l){var c=a[l];c.maxLevel<=r||(c=c.rectangle,defined(Rectangle.intersection(c,o,rectangleScratch$2))&&(isTileInRectangle(n,c,2*t,2*i,r+1)&&(s|=4),isTileInRectangle(n,c,2*t+1,2*i,r+1)&&(s|=8),isTileInRectangle(n,c,2*t,2*i+1,r+1)&&(s|=1),isTileInRectangle(n,c,2*t+1,2*i+1,r+1)&&(s|=2)))}return s}function isTileInRectangle(e,t,i,r,n){n=e.tileXYToRectangle(i,r,n);return defined(Rectangle.intersection(n,t,rectangleScratch$2))}function VideoSynchronizer(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this._lastPlaybackRate=void 0,this.clock=e.clock,this.element=e.element,this.epoch=defaultValue(e.epoch,Iso8601.MINIMUM_VALUE),this.tolerance=defaultValue(e.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function createSeekFunction(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}VRTheWorldTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},VRTheWorldTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},Object.defineProperties(VideoSynchronizer.prototype,{clock:{get:function(){return this._clock},set:function(e){var t=this._clock;t!==e&&(defined(t)&&(this._clockSubscription(),this._clockSubscription=void 0),defined(e)&&(this._clockSubscription=e.onTick.addEventListener(VideoSynchronizer.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){var t=this._element;t!==e&&(defined(t)&&t.removeEventListener("seeked",this._seekFunction,!1),defined(e)&&(this._seeking=!1,this._seekFunction=createSeekFunction(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),VideoSynchronizer.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,destroyObject(this)},VideoSynchronizer.prototype.isDestroyed=function(){return!1},VideoSynchronizer.prototype._trySetPlaybackRate=function(e){if(this._lastPlaybackRate!==e.multiplier){var t=this._element;try{t.playbackRate=e.multiplier}catch(e){t.playbackRate=0}this._lastPlaybackRate=e.multiplier}},VideoSynchronizer.prototype._onTick=function(e){var t,i,r,n=this._element;!defined(n)||n.readyState<2||(i=n.paused,(r=e.shouldAnimate)===i&&(r?n.play():n.pause()),this._seeking||this._firstTickAfterSeek?this._firstTickAfterSeek=!1:(this._trySetPlaybackRate(e),t=e.currentTime,i=defaultValue(this.epoch,Iso8601.MINIMUM_VALUE),e=JulianDate.secondsDifference(t,i),t=n.duration,i=n.currentTime,e=n.loop?e=(e%=t)<0?t-e:e:t<e?t:e<0?0:e,r=r?defaultValue(this.tolerance,1):.001,Math.abs(e-i)>r&&(this._seeking=!0,n.currentTime=e)))};var VulkanConstants={VK_FORMAT_UNDEFINED:0,VK_FORMAT_R4G4_UNORM_PACK8:1,VK_FORMAT_R4G4B4A4_UNORM_PACK16:2,VK_FORMAT_B4G4R4A4_UNORM_PACK16:3,VK_FORMAT_R5G6B5_UNORM_PACK16:4,VK_FORMAT_B5G6R5_UNORM_PACK16:5,VK_FORMAT_R5G5B5A1_UNORM_PACK16:6,VK_FORMAT_B5G5R5A1_UNORM_PACK16:7,VK_FORMAT_A1R5G5B5_UNORM_PACK16:8,VK_FORMAT_R8_UNORM:9,VK_FORMAT_R8_SNORM:10,VK_FORMAT_R8_USCALED:11,VK_FORMAT_R8_SSCALED:12,VK_FORMAT_R8_UINT:13,VK_FORMAT_R8_SINT:14,VK_FORMAT_R8_SRGB:15,VK_FORMAT_R8G8_UNORM:16,VK_FORMAT_R8G8_SNORM:17,VK_FORMAT_R8G8_USCALED:18,VK_FORMAT_R8G8_SSCALED:19,VK_FORMAT_R8G8_UINT:20,VK_FORMAT_R8G8_SINT:21,VK_FORMAT_R8G8_SRGB:22,VK_FORMAT_R8G8B8_UNORM:23,VK_FORMAT_R8G8B8_SNORM:24,VK_FORMAT_R8G8B8_USCALED:25,VK_FORMAT_R8G8B8_SSCALED:26,VK_FORMAT_R8G8B8_UINT:27,VK_FORMAT_R8G8B8_SINT:28,VK_FORMAT_R8G8B8_SRGB:29,VK_FORMAT_B8G8R8_UNORM:30,VK_FORMAT_B8G8R8_SNORM:31,VK_FORMAT_B8G8R8_USCALED:32,VK_FORMAT_B8G8R8_SSCALED:33,VK_FORMAT_B8G8R8_UINT:34,VK_FORMAT_B8G8R8_SINT:35,VK_FORMAT_B8G8R8_SRGB:36,VK_FORMAT_R8G8B8A8_UNORM:37,VK_FORMAT_R8G8B8A8_SNORM:38,VK_FORMAT_R8G8B8A8_USCALED:39,VK_FORMAT_R8G8B8A8_SSCALED:40,VK_FORMAT_R8G8B8A8_UINT:41,VK_FORMAT_R8G8B8A8_SINT:42,VK_FORMAT_R8G8B8A8_SRGB:43,VK_FORMAT_B8G8R8A8_UNORM:44,VK_FORMAT_B8G8R8A8_SNORM:45,VK_FORMAT_B8G8R8A8_USCALED:46,VK_FORMAT_B8G8R8A8_SSCALED:47,VK_FORMAT_B8G8R8A8_UINT:48,VK_FORMAT_B8G8R8A8_SINT:49,VK_FORMAT_B8G8R8A8_SRGB:50,VK_FORMAT_A8B8G8R8_UNORM_PACK32:51,VK_FORMAT_A8B8G8R8_SNORM_PACK32:52,VK_FORMAT_A8B8G8R8_USCALED_PACK32:53,VK_FORMAT_A8B8G8R8_SSCALED_PACK32:54,VK_FORMAT_A8B8G8R8_UINT_PACK32:55,VK_FORMAT_A8B8G8R8_SINT_PACK32:56,VK_FORMAT_A8B8G8R8_SRGB_PACK32:57,VK_FORMAT_A2R10G10B10_UNORM_PACK32:58,VK_FORMAT_A2R10G10B10_SNORM_PACK32:59,VK_FORMAT_A2R10G10B10_USCALED_PACK32:60,VK_FORMAT_A2R10G10B10_SSCALED_PACK32:61,VK_FORMAT_A2R10G10B10_UINT_PACK32:62,VK_FORMAT_A2R10G10B10_SINT_PACK32:63,VK_FORMAT_A2B10G10R10_UNORM_PACK32:64,VK_FORMAT_A2B10G10R10_SNORM_PACK32:65,VK_FORMAT_A2B10G10R10_USCALED_PACK32:66,VK_FORMAT_A2B10G10R10_SSCALED_PACK32:67,VK_FORMAT_A2B10G10R10_UINT_PACK32:68,VK_FORMAT_A2B10G10R10_SINT_PACK32:69,VK_FORMAT_R16_UNORM:70,VK_FORMAT_R16_SNORM:71,VK_FORMAT_R16_USCALED:72,VK_FORMAT_R16_SSCALED:73,VK_FORMAT_R16_UINT:74,VK_FORMAT_R16_SINT:75,VK_FORMAT_R16_SFLOAT:76,VK_FORMAT_R16G16_UNORM:77,VK_FORMAT_R16G16_SNORM:78,VK_FORMAT_R16G16_USCALED:79,VK_FORMAT_R16G16_SSCALED:80,VK_FORMAT_R16G16_UINT:81,VK_FORMAT_R16G16_SINT:82,VK_FORMAT_R16G16_SFLOAT:83,VK_FORMAT_R16G16B16_UNORM:84,VK_FORMAT_R16G16B16_SNORM:85,VK_FORMAT_R16G16B16_USCALED:86,VK_FORMAT_R16G16B16_SSCALED:87,VK_FORMAT_R16G16B16_UINT:88,VK_FORMAT_R16G16B16_SINT:89,VK_FORMAT_R16G16B16_SFLOAT:90,VK_FORMAT_R16G16B16A16_UNORM:91,VK_FORMAT_R16G16B16A16_SNORM:92,VK_FORMAT_R16G16B16A16_USCALED:93,VK_FORMAT_R16G16B16A16_SSCALED:94,VK_FORMAT_R16G16B16A16_UINT:95,VK_FORMAT_R16G16B16A16_SINT:96,VK_FORMAT_R16G16B16A16_SFLOAT:97,VK_FORMAT_R32_UINT:98,VK_FORMAT_R32_SINT:99,VK_FORMAT_R32_SFLOAT:100,VK_FORMAT_R32G32_UINT:101,VK_FORMAT_R32G32_SINT:102,VK_FORMAT_R32G32_SFLOAT:103,VK_FORMAT_R32G32B32_UINT:104,VK_FORMAT_R32G32B32_SINT:105,VK_FORMAT_R32G32B32_SFLOAT:106,VK_FORMAT_R32G32B32A32_UINT:107,VK_FORMAT_R32G32B32A32_SINT:108,VK_FORMAT_R32G32B32A32_SFLOAT:109,VK_FORMAT_R64_UINT:110,VK_FORMAT_R64_SINT:111,VK_FORMAT_R64_SFLOAT:112,VK_FORMAT_R64G64_UINT:113,VK_FORMAT_R64G64_SINT:114,VK_FORMAT_R64G64_SFLOAT:115,VK_FORMAT_R64G64B64_UINT:116,VK_FORMAT_R64G64B64_SINT:117,VK_FORMAT_R64G64B64_SFLOAT:118,VK_FORMAT_R64G64B64A64_UINT:119,VK_FORMAT_R64G64B64A64_SINT:120,VK_FORMAT_R64G64B64A64_SFLOAT:121,VK_FORMAT_B10G11R11_UFLOAT_PACK32:122,VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:123,VK_FORMAT_D16_UNORM:124,VK_FORMAT_X8_D24_UNORM_PACK32:125,VK_FORMAT_D32_SFLOAT:126,VK_FORMAT_S8_UINT:127,VK_FORMAT_D16_UNORM_S8_UINT:128,VK_FORMAT_D24_UNORM_S8_UINT:129,VK_FORMAT_D32_SFLOAT_S8_UINT:130,VK_FORMAT_BC1_RGB_UNORM_BLOCK:131,VK_FORMAT_BC1_RGB_SRGB_BLOCK:132,VK_FORMAT_BC1_RGBA_UNORM_BLOCK:133,VK_FORMAT_BC1_RGBA_SRGB_BLOCK:134,VK_FORMAT_BC2_UNORM_BLOCK:135,VK_FORMAT_BC2_SRGB_BLOCK:136,VK_FORMAT_BC3_UNORM_BLOCK:137,VK_FORMAT_BC3_SRGB_BLOCK:138,VK_FORMAT_BC4_UNORM_BLOCK:139,VK_FORMAT_BC4_SNORM_BLOCK:140,VK_FORMAT_BC5_UNORM_BLOCK:141,VK_FORMAT_BC5_SNORM_BLOCK:142,VK_FORMAT_BC6H_UFLOAT_BLOCK:143,VK_FORMAT_BC6H_SFLOAT_BLOCK:144,VK_FORMAT_BC7_UNORM_BLOCK:145,VK_FORMAT_BC7_SRGB_BLOCK:146,VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:147,VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:148,VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:149,VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:150,VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:151,VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:152,VK_FORMAT_EAC_R11_UNORM_BLOCK:153,VK_FORMAT_EAC_R11_SNORM_BLOCK:154,VK_FORMAT_EAC_R11G11_UNORM_BLOCK:155,VK_FORMAT_EAC_R11G11_SNORM_BLOCK:156,VK_FORMAT_ASTC_4x4_UNORM_BLOCK:157,VK_FORMAT_ASTC_4x4_SRGB_BLOCK:158,VK_FORMAT_ASTC_5x4_UNORM_BLOCK:159,VK_FORMAT_ASTC_5x4_SRGB_BLOCK:160,VK_FORMAT_ASTC_5x5_UNORM_BLOCK:161,VK_FORMAT_ASTC_5x5_SRGB_BLOCK:162,VK_FORMAT_ASTC_6x5_UNORM_BLOCK:163,VK_FORMAT_ASTC_6x5_SRGB_BLOCK:164,VK_FORMAT_ASTC_6x6_UNORM_BLOCK:165,VK_FORMAT_ASTC_6x6_SRGB_BLOCK:166,VK_FORMAT_ASTC_8x5_UNORM_BLOCK:167,VK_FORMAT_ASTC_8x5_SRGB_BLOCK:168,VK_FORMAT_ASTC_8x6_UNORM_BLOCK:169,VK_FORMAT_ASTC_8x6_SRGB_BLOCK:170,VK_FORMAT_ASTC_8x8_UNORM_BLOCK:171,VK_FORMAT_ASTC_8x8_SRGB_BLOCK:172,VK_FORMAT_ASTC_10x5_UNORM_BLOCK:173,VK_FORMAT_ASTC_10x5_SRGB_BLOCK:174,VK_FORMAT_ASTC_10x6_UNORM_BLOCK:175,VK_FORMAT_ASTC_10x6_SRGB_BLOCK:176,VK_FORMAT_ASTC_10x8_UNORM_BLOCK:177,VK_FORMAT_ASTC_10x8_SRGB_BLOCK:178,VK_FORMAT_ASTC_10x10_UNORM_BLOCK:179,VK_FORMAT_ASTC_10x10_SRGB_BLOCK:180,VK_FORMAT_ASTC_12x10_UNORM_BLOCK:181,VK_FORMAT_ASTC_12x10_SRGB_BLOCK:182,VK_FORMAT_ASTC_12x12_UNORM_BLOCK:183,VK_FORMAT_ASTC_12x12_SRGB_BLOCK:184,VK_FORMAT_G8B8G8R8_422_UNORM:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:1000156006,VK_FORMAT_R10X6_UNORM_PACK16:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:1000156016,VK_FORMAT_R12X4_UNORM_PACK16:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:1000156033,VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:1000054e3,VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:1000054001,VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:1000054002,VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:1000054003,VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:1000054004,VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:1000054005,VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:1000054006,VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:1000054007,VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT:1000066e3,VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT:1000066001,VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT:1000066002,VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT:1000066003,VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT:1000066004,VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT:1000066005,VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT:1000066006,VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT:1000066007,VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT:1000066008,VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT:1000066009,VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT:1000066010,VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT:1000066011,VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT:1000066012,VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT:1000066013,VK_FORMAT_G8B8G8R8_422_UNORM_KHR:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM_KHR:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR:1000156006,VK_FORMAT_R10X6_UNORM_PACK16_KHR:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR:1000156016,VK_FORMAT_R12X4_UNORM_PACK16_KHR:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM_KHR:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM_KHR:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR:1000156033},VulkanConstants$1=Object.freeze(VulkanConstants),WallGeometryLibrary={};function latLonEquals(e,t){return CesiumMath.equalsEpsilon(e.latitude,t.latitude,CesiumMath.EPSILON10)&&CesiumMath.equalsEpsilon(e.longitude,t.longitude,CesiumMath.EPSILON10)}var scratchCartographic1=new Cartographic,scratchCartographic2=new Cartographic;function removeDuplicates$1(e,t,i,r){var n=(t=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon)).length;if(!(n<2)){var a=defined(r),o=defined(i),s=new Array(n),l=new Array(n),c=new Array(n),u=t[0];s[0]=u;var d=e.cartesianToCartographic(u,scratchCartographic1);o&&(d.height=i[0]),l[0]=d.height,c[0]=a?r[0]:0;for(var h=l[0]===c[0],p=1,f=1;f<n;++f){var m=t[f],g=e.cartesianToCartographic(m,scratchCartographic2);o&&(g.height=i[f]),h=h&&0===g.height,latLonEquals(d,g)?d.height<g.height&&(l[p-1]=g.height):(s[p]=m,l[p]=g.height,c[p]=a?r[f]:0,h=h&&l[p]===c[p],Cartographic.clone(g,d),++p)}if(!(h||p<2))return s.length=p,l.length=p,c.length=p,{positions:s,topHeights:l,bottomHeights:c}}}var positionsArrayScratch=new Array(2),heightsArrayScratch=new Array(2),generateArcOptionsScratch={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};WallGeometryLibrary.computePositions=function(e,t,i,r,n,a){var o=removeDuplicates$1(e,t,i,r);if(defined(o)){t=o.positions,i=o.topHeights,r=o.bottomHeights;var s=t.length,o=s-2,l=CesiumMath.chordLength(n,e.maximumRadius),c=generateArcOptionsScratch;if(c.minDistance=l,c.ellipsoid=e,a){for(var u=0,d=0;d<s-1;d++)u+=PolylinePipeline.numberOfPoints(t[d],t[d+1],l)+1;var h=new Float64Array(3*u),p=new Float64Array(3*u),f=positionsArrayScratch,m=heightsArrayScratch;c.positions=f,c.height=m;var g=0;for(d=0;d<s-1;d++){f[0]=t[d],f[1]=t[d+1],m[0]=i[d],m[1]=i[d+1];var _=PolylinePipeline.generateArc(c);h.set(_,g),m[0]=r[d],m[1]=r[d+1],p.set(PolylinePipeline.generateArc(c),g),g+=_.length}}else c.positions=t,c.height=i,h=new Float64Array(PolylinePipeline.generateArc(c)),c.height=r,p=new Float64Array(PolylinePipeline.generateArc(c));return{bottomPositions:p,topPositions:h,numCorners:o}}};var scratchCartesian3Position1$1=new Cartesian3,scratchCartesian3Position2$1=new Cartesian3,scratchCartesian3Position4=new Cartesian3,scratchCartesian3Position5=new Cartesian3,scratchBitangent=new Cartesian3,scratchTangent=new Cartesian3,scratchNormal$1=new Cartesian3;function WallGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._vertexFormat=VertexFormat.clone(n),this._granularity=a,this._ellipsoid=Ellipsoid.clone(e),this._workerName="createWallGeometry";t=1+t.length*Cartesian3.packedLength+2;defined(r)&&(t+=r.length),defined(i)&&(t+=i.length),this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+1}WallGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights,a=defined(o)?o.length:0;if(t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._granularity,t};var scratchEllipsoid$2=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat=new VertexFormat,scratchOptions$1={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$2,vertexFormat:scratchVertexFormat,granularity:void 0};WallGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r,n,a=e[t++],o=new Array(a),s=0;s<a;++s,t+=Cartesian3.packedLength)o[s]=Cartesian3.unpack(e,t);if(0<(a=e[t++]))for(r=new Array(a),s=0;s<a;++s)r[s]=e[t++];if(0<(a=e[t++]))for(n=new Array(a),s=0;s<a;++s)n[s]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$2);t+=Ellipsoid.packedLength;var c=VertexFormat.unpack(e,t,scratchVertexFormat),u=e[t+=VertexFormat.packedLength];return defined(i)?(i._positions=o,i._minimumHeights=r,i._maximumHeights=n,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._vertexFormat=VertexFormat.clone(c,i._vertexFormat),i._granularity=u,i):(scratchOptions$1.positions=o,scratchOptions$1.minimumHeights=r,scratchOptions$1.maximumHeights=n,scratchOptions$1.granularity=u,new WallGeometry(scratchOptions$1))},WallGeometry.fromConstantHeights=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.minimumHeight,r=e.maximumHeight,n=defined(i),a=defined(r);if(n||a)for(var o=t.length,s=n?new Array(o):void 0,l=a?new Array(o):void 0,c=0;c<o;++c)n&&(s[c]=i),a&&(l[c]=r);return new WallGeometry({positions:t,maximumHeights:l,minimumHeights:s,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat})},WallGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._vertexFormat,a=e._granularity,o=e._ellipsoid,r=WallGeometryLibrary.computePositions(o,t,r,i,a,!0);if(defined(r)){for(var s=r.bottomPositions,l=r.topPositions,i=r.numCorners,c=l.length,a=2*c,u=n.position?new Float64Array(a):void 0,d=n.normal?new Float32Array(a):void 0,h=n.tangent?new Float32Array(a):void 0,p=n.bitangent?new Float32Array(a):void 0,f=n.st?new Float32Array(a/3*2):void 0,m=0,g=0,_=0,y=0,C=0,v=scratchNormal$1,T=scratchTangent,S=scratchBitangent,A=!0,x=0,b=1/((c/=3)-i-1),E=0;E<c;++E){var P,D=3*E,w=Cartesian3.fromArray(l,D,scratchCartesian3Position1$1),M=Cartesian3.fromArray(s,D,scratchCartesian3Position2$1);n.position&&(u[m++]=M.x,u[m++]=M.y,u[m++]=M.z,u[m++]=w.x,u[m++]=w.y,u[m++]=w.z),n.st&&(f[C++]=x,f[C++]=0,f[C++]=x,f[C++]=1),(n.normal||n.tangent||n.bitangent)&&(P=Cartesian3.clone(Cartesian3.ZERO,scratchCartesian3Position5),M=Cartesian3.subtract(w,o.geodeticSurfaceNormal(w,scratchCartesian3Position2$1),scratchCartesian3Position2$1),E+1<c&&(P=Cartesian3.fromArray(l,3+D,scratchCartesian3Position5)),A&&(D=Cartesian3.subtract(P,w,scratchCartesian3Position4),M=Cartesian3.subtract(M,w,scratchCartesian3Position1$1),v=Cartesian3.normalize(Cartesian3.cross(M,D,v),v),A=!1),Cartesian3.equalsEpsilon(w,P,CesiumMath.EPSILON10)?A=!0:(x+=b,n.tangent&&(T=Cartesian3.normalize(Cartesian3.subtract(P,w,T),T)),n.bitangent&&(S=Cartesian3.normalize(Cartesian3.cross(v,T,S),S))),n.normal&&(d[g++]=v.x,d[g++]=v.y,d[g++]=v.z,d[g++]=v.x,d[g++]=v.y,d[g++]=v.z),n.tangent&&(h[y++]=T.x,h[y++]=T.y,h[y++]=T.z,h[y++]=T.x,h[y++]=T.y,h[y++]=T.z),n.bitangent&&(p[_++]=S.x,p[_++]=S.y,p[_++]=S.z,p[_++]=S.x,p[_++]=S.y,p[_++]=S.z))}r=new GeometryAttributes;n.position&&(r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:u})),n.normal&&(r.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),n.tangent&&(r.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.bitangent&&(r.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.st&&(r.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:f}));var I=a/3,R=IndexDatatype$1.createTypedArray(I,a-=6*(i+1)),O=0;for(E=0;E<I-2;E+=2){var B=E,L=E+2,F=Cartesian3.fromArray(u,3*B,scratchCartesian3Position1$1),N=Cartesian3.fromArray(u,3*L,scratchCartesian3Position2$1);Cartesian3.equalsEpsilon(F,N,CesiumMath.EPSILON10)||(N=E+3,R[O++]=E+1,R[O++]=B,R[O++]=N,R[O++]=N,R[O++]=B,R[O++]=L)}return new Geometry({attributes:r,indices:R,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere.fromVertices(u)})}};var scratchCartesian3Position1=new Cartesian3,scratchCartesian3Position2=new Cartesian3;function WallOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._granularity=n,this._ellipsoid=Ellipsoid.clone(e),this._workerName="createWallOutlineGeometry";t=1+t.length*Cartesian3.packedLength+2;defined(r)&&(t+=r.length),defined(i)&&(t+=i.length),this.packedLength=t+Ellipsoid.packedLength+1}WallOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights,a=defined(o)?o.length:0;if(t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),t[i+=Ellipsoid.packedLength]=e._granularity,t};var scratchEllipsoid$1=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$1,granularity:void 0},implementation$1;function WeightSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).weights,e=e.times;this._times=e,this._weights=t,this._count=t.length/e.length,this._lastTimeIndex=0}function arraySlice(e,t,i){if("function"==typeof e.slice)return e.slice(t,i);for(var r=Array.prototype.slice.call(e,t,i),n=FeatureDetection.typedArrayTypes,a=n.length,o=0;o<a;++o)if(e instanceof n[o]){r=new n[o](r);break}return r}function cancelAnimationFramePolyfill(e){implementation$1(e)}function createGuid(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)})}function createWorldTerrain(e){return e=defaultValue(e,defaultValue.EMPTY_OBJECT),new CesiumTerrainProvider({url:IonResource.fromAssetId(1),requestVertexNormals:defaultValue(e.requestVertexNormals,!1),requestWaterMask:defaultValue(e.requestWaterMask,!1)})}WallOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r,n,a=e[t++],o=new Array(a),s=0;s<a;++s,t+=Cartesian3.packedLength)o[s]=Cartesian3.unpack(e,t);if(0<(a=e[t++]))for(r=new Array(a),s=0;s<a;++s)r[s]=e[t++];if(0<(a=e[t++]))for(n=new Array(a),s=0;s<a;++s)n[s]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$1),c=e[t+=Ellipsoid.packedLength];return defined(i)?(i._positions=o,i._minimumHeights=r,i._maximumHeights=n,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._granularity=c,i):(scratchOptions.positions=o,scratchOptions.minimumHeights=r,scratchOptions.maximumHeights=n,scratchOptions.granularity=c,new WallOutlineGeometry(scratchOptions))},WallOutlineGeometry.fromConstantHeights=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.minimumHeight,r=e.maximumHeight,n=defined(i),a=defined(r);if(n||a)for(var o=t.length,s=n?new Array(o):void 0,l=a?new Array(o):void 0,c=0;c<o;++c)n&&(s[c]=i),a&&(l[c]=r);return new WallOutlineGeometry({positions:t,maximumHeights:l,minimumHeights:s,ellipsoid:e.ellipsoid})},WallOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._granularity,e=e._ellipsoid,i=WallGeometryLibrary.computePositions(e,t,r,i,n,!1);if(defined(i)){var a=i.bottomPositions,o=i.topPositions,s=o.length,n=2*s,l=new Float64Array(n),c=0;for(s/=3,m=0;m<s;++m){var u=3*m,d=Cartesian3.fromArray(o,u,scratchCartesian3Position1),u=Cartesian3.fromArray(a,u,scratchCartesian3Position2);l[c++]=u.x,l[c++]=u.y,l[c++]=u.z,l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}for(var i=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})}),h=n/3,p=IndexDatatype$1.createTypedArray(h,n=2*h-4+h),f=0,m=0;m<h-2;m+=2){var g=m,_=m+2,y=Cartesian3.fromArray(l,3*g,scratchCartesian3Position1),C=Cartesian3.fromArray(l,3*_,scratchCartesian3Position2);Cartesian3.equalsEpsilon(y,C,CesiumMath.EPSILON10)||(y=m+3,p[f++]=C=m+1,p[f++]=g,p[f++]=C,p[f++]=y,p[f++]=g,p[f++]=_)}return p[f++]=h-2,p[f++]=h-1,new Geometry({attributes:i,indices:p,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere.fromVertices(l)})}},Object.defineProperties(WeightSpline.prototype,{times:{get:function(){return this._times}},weights:{get:function(){return this._weights}}}),WeightSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,WeightSpline.prototype.wrapTime=Spline.prototype.wrapTime,WeightSpline.prototype.clampTime=Spline.prototype.clampTime,WeightSpline.prototype.evaluate=function(e,t){var i=this.weights,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);defined(t)||(t=new Array(this._count));for(var o=0;o<this._count;o++){var s=n*this._count+o;t[o]=i[s]*(1-a)+i[s+this._count]*a}return t},"undefined"!=typeof cancelAnimationFrame&&(implementation$1=cancelAnimationFrame),function(){if(!defined(implementation$1)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$1);)defined(implementation$1=window[e[t]+"CancelAnimationFrame"])||(implementation$1=window[e[t]+"CancelRequestAnimationFrame"]),++t;defined(implementation$1)||(implementation$1=clearTimeout)}();var compressedMagic=1953029805,compressedMagicSwap=2917034100;function decodeGoogleEarthEnterpriseData(e,t){if(decodeGoogleEarthEnterpriseData.passThroughDataForTesting)return t;var i=e.byteLength;if(0===i||i%4!=0)throw new RuntimeError("The length of key must be greater than 0 and a multiple of 4.");var r=new DataView(t),n=r.getUint32(0,!0);if(n===compressedMagic||n===compressedMagicSwap)return t;for(var a,o=new DataView(e),s=0,l=t.byteLength,c=l-l%8,u=i,d=8;s<c;)for(a=d=(d+8)%24;s<c&&a<u;)r.setUint32(s,r.getUint32(s,!0)^o.getUint32(a,!0),!0),r.setUint32(s+4,r.getUint32(s+4,!0)^o.getUint32(a+4,!0),!0),s+=8,a+=24;if(s<l)for(u<=a&&(a=d=(d+8)%24);s<l;)r.setUint8(s,r.getUint8(s)^o.getUint8(a)),s++,a++}decodeGoogleEarthEnterpriseData.passThroughDataForTesting=!1;var maxShort=32767,scratchBVCartographic$1=new Cartographic,scratchEncodedPosition=new Cartesian3,supportedTranscoderFormats;function decodeVectorPolylinePositions(e,t,i,r,n){var a=e.length/3,o=e.subarray(0,a),s=e.subarray(a,2*a),l=e.subarray(2*a,3*a);AttributeCompression.zigZagDeltaDecode(o,s,l);for(var c=new Float64Array(e.length),u=0;u<a;++u){var d=o[u],h=s[u],p=l[u],d=CesiumMath.lerp(t.west,t.east,d/maxShort),h=CesiumMath.lerp(t.south,t.north,h/maxShort),p=CesiumMath.lerp(i,r,p/maxShort),p=Cartographic.fromRadians(d,h,p,scratchBVCartographic$1),p=n.cartographicToCartesian(p,scratchEncodedPosition);Cartesian3.pack(p,c,3*u)}return c}function deprecationWarning(e,t){oneTimeWarning(e,t)}function getFilenameFromUri(e){var t=new URI(e);t.normalize();e=t.path(),t=e.lastIndexOf("/");return e=-1!==t?e.substr(t+1):e}function getMagic(e,t){return getStringFromTypedArray(e,t=defaultValue(t,0),Math.min(4,e.length))}function loadImageFromTypedArray(e){var t,i=e.uint8Array,r=e.format,n=e.request,a=defaultValue(e.flipY,!1),o=defaultValue(e.skipColorSpaceConversion,!1),s=new Blob([i],{type:r});return Resource.supportsImageBitmapOptions().then(function(e){return e?when(Resource.createImageBitmapFromBlob(s,{flipY:a,premultiplyAlpha:!1,skipColorSpaceConversion:o})):new Resource({url:t=window.URL.createObjectURL(s),request:n}).fetchImage({flipY:a,skipColorSpaceConversion:o})}).then(function(e){return defined(t)&&window.URL.revokeObjectURL(t),e}).otherwise(function(e){return defined(t)&&window.URL.revokeObjectURL(t),when.reject(e)})}function loadKTX2(e){return(e instanceof ArrayBuffer||ArrayBuffer.isView(e)?when.resolve(e):Resource.createIfNeeded(e).fetchArrayBuffer()).then(function(e){return KTX2Transcoder.transcode(e,supportedTranscoderFormats)})}loadKTX2.setKTX2SupportedFormats=function(e,t,i,r,n,a){supportedTranscoderFormats={s3tc:e,pvrtc:t,astc:i,etc:r,etc1:n,bc7:a}};var leftScratchArray=[],rightScratchArray=[];function merge$1(e,t,i,r,n,a){for(var o=n-r+1,s=a-n,l=leftScratchArray,c=rightScratchArray,u=0;u<o;++u)l[u]=e[r+u];for(d=0;d<s;++d)c[d]=e[n+d+1];for(var d=u=0,h=r;h<=a;++h){var p=l[u],f=c[d];u<o&&(s<=d||t(p,f,i)<=0)?(e[h]=p,++u):d<s&&(e[h]=f,++d)}}function sort(e,t,i,r,n){var a;n<=r||(sort(e,t,i,r,a=Math.floor(.5*(r+n))),sort(e,t,i,a+1,n),merge$1(e,t,i,r,a,n))}function mergeSort(e,t,i){var r=e.length,n=Math.ceil(.5*r);leftScratchArray.length=n,rightScratchArray.length=n,sort(e,t,i,0,r-1),leftScratchArray.length=0,rightScratchArray.length=0}var coords=new Cartesian3,implementation;function pointInsideTriangle(e,t,i,r){return barycentricCoordinates(e,t,i,r,coords),0<coords.x&&0<coords.y&&0<coords.z}function requestAnimationFramePolyFill(e){return implementation(e)}function sampleTerrain(e,t,i){return e.readyPromise.then(function(){return doSampling(e,t,i)})}function doSampling(e,t,i){for(var r=e.tilingScheme,n=[],a={},o=0;o<i.length;++o){var s=r.positionToTileXY(i[o],t),l=s.toString();a.hasOwnProperty(l)||(s={x:s.x,y:s.y,level:t,tilingScheme:r,terrainProvider:e,positions:[]},a[l]=s,n.push(s)),a[l].positions.push(i[o])}var c=[];for(o=0;o<n.length;++o){var u=n[o],u=u.terrainProvider.requestTileGeometry(u.x,u.y,u.level).then(createInterpolateFunction(u)).otherwise(createMarkFailedFunction(u));c.push(u)}return when.all(c,function(){return i})}function interpolateAndAssignHeight(e,t,i){i=t.interpolateHeight(i,e.longitude,e.latitude);return void 0!==i&&(e.height=i,!0)}function createInterpolateFunction(r){var n=r.positions,a=r.tilingScheme.tileXYToRectangle(r.x,r.y,r.level);return function(t){for(var e=!1,i=0;i<n.length;++i)if(!interpolateAndAssignHeight(n[i],t,a)){e=!0;break}return e?t.createMesh({tilingScheme:r.tilingScheme,x:r.x,y:r.y,level:r.level,throttle:!1}).then(function(){for(var e=0;e<n.length;++e)interpolateAndAssignHeight(n[e],t,a)}):when.resolve()}}function createMarkFailedFunction(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e)t[e].height=void 0}}"undefined"!=typeof requestAnimationFrame&&(implementation=requestAnimationFrame),function(){if(!defined(implementation)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation);)implementation=window[e[t]+"RequestAnimationFrame"],++t;var r;defined(implementation)||(r=0,implementation=function(e){var t=getTimestamp$1(),i=Math.max(1e3/60-(t-r),0);return r=t+i,setTimeout(function(){e(r)},i)})}();var scratchCartesian2$4=new Cartesian2;function sampleTerrainMostDetailed(l,c){return l.readyPromise.then(function(){for(var e=[],r=[],n=l.availability,t=[],i=0;i<c.length;++i){var a=c[i],o=n.computeMaximumLevelAtPosition(a);0===(r[i]=o)&&(l.tilingScheme.positionToTileXY(a,1,scratchCartesian2$4),defined(s=l.loadTileDataAvailability(scratchCartesian2$4.x,scratchCartesian2$4.y,1))&&t.push(s));var s=e[o];defined(s)||(e[o]=s=[]),s.push(a)}return when.all(t).then(function(){return when.all(e.map(function(e,t){if(defined(e))return sampleTerrain(l,t,e)}))}).then(function(){for(var e=[],t=0;t<c.length;++t){var i=c[t];n.computeMaximumLevelAtPosition(i)!==r[t]&&e.push(i)}if(0<e.length)return sampleTerrainMostDetailed(l,e)}).then(function(){return c})})}function subdivideArray(e,t){for(var i=[],r=e.length,n=0;n<r;){var a=Math.ceil((r-n)/t--);i.push(e.slice(n,n+a)),n+=a}return i}function webGLConstantToGlslType(e){switch(e){case WebGLConstants$1.FLOAT:return"float";case WebGLConstants$1.FLOAT_VEC2:return"vec2";case WebGLConstants$1.FLOAT_VEC3:return"vec3";case WebGLConstants$1.FLOAT_VEC4:return"vec4";case WebGLConstants$1.FLOAT_MAT2:return"mat2";case WebGLConstants$1.FLOAT_MAT3:return"mat3";case WebGLConstants$1.FLOAT_MAT4:return"mat4";case WebGLConstants$1.SAMPLER_2D:return"sampler2D";case WebGLConstants$1.BOOL:return"bool"}}function wrapFunction(e,t,i){return function(){i.apply(e,arguments),t.apply(e,arguments)}}function ConstantProperty(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new Event,this.setValue(e)}function createProperty(r,n,a,e,o){return{configurable:e,get:function(){return this[n]},set:function(e){var t=this[n],i=this[a];defined(i)&&(i(),this[a]=void 0),t!==(e=!(!(void 0!==e)||defined(e)&&defined(e.getValue))&&defined(o)?o(e):e)&&(this[n]=e,this._definitionChanged.raiseEvent(this,r,e,t)),defined(e)&&defined(e.definitionChanged)&&(this[a]=e.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,r,e,e)},this))}}}function createConstantProperty$1(e){return new ConstantProperty(e)}function createPropertyDescriptor(e,t,i){return createProperty(e,"_"+e.toString(),"_"+e.toString()+"Subscription",defaultValue(t,!1),defaultValue(i,createConstantProperty$1))}function BillboardGraphics(e){this._definitionChanged=new Event,this._show=void 0,this._showSubscription=void 0,this._image=void 0,this._imageSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._disableDepthTestDistance=void 0,this._disableDepthTestDistanceSubscription=void 0,this.merge(defaultValue(e,defaultValue.EMPTY_OBJECT))}Object.defineProperties(ConstantProperty.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),ConstantProperty.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},ConstantProperty.prototype.setValue=function(e){var t,i,r=this._value;r!==e&&(t=(i=defined(e))&&"function"==typeof e.clone,(i=i&&"function"==typeof e.equals)&&e.equals(r)||(this._hasClone=t,this._hasEquals=i,this._value=t?e.clone(this._value):e,this._definitionChanged.raiseEvent(this)))},ConstantProperty.prototype.equals=function(e){return this===e||e instanceof ConstantProperty&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},ConstantProperty.prototype.valueOf=function(){return this._value},ConstantProperty.prototype.toString=function(){return String(this._value)},Object.defineProperties(BillboardGraphics.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:createPropertyDescriptor("show"),image:createPropertyDescriptor("image"),scale:createPropertyDescriptor("scale"),pixelOffset:createPropertyDescriptor("pixelOffset"),eyeOffset:createPropertyDescriptor("eyeOffset"),horizontalOrigin:createPropertyDescriptor("horizontalOrigin"),verticalOrigin:createPropertyDescriptor("verticalOrigin"),heightReference:createPropertyDescriptor("heightReference"),color:createPropertyDescriptor("color"),rotation:createPropertyDescriptor("rotation"),alignedAxis:createPropertyDescriptor("alignedAxis"),sizeInMeters:createPropertyDescriptor("sizeInMeters"),width:createPropertyDescriptor("width"),height:createPropertyDescriptor("height"),scaleByDistance:createPropertyDescriptor("scaleByDistance"),translucencyByDistance:createPropertyDescriptor("translucencyByDistance"),pixelOffsetScaleByDistance:createPropertyDescriptor("pixelOffsetScaleByDistance"),imageSubRegion:createPropertyDescriptor("imageSubRegion"),distanceDisplayCondition:createPropertyDescriptor("distanceDisplayCondition"),disableDepthTestDistance:createPropertyDescriptor("disableDepthTestDistance")}),BillboardGraphics.prototype.clone=function(e){return defined(e)?(e.show=this._show,e.image=this._image,e.scale=this._scale,e.pixelOffset=this._pixelOffset,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.verticalOrigin=this._verticalOrigin,e.heightReference=this._heightReference,e.color=this._color,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.sizeInMeters=this._sizeInMeters,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.imageSubRegion=this._imageSubRegion,e.distanceDisplayCondition=this._distanceDisplayCondition,e.disableDepthTestDistance=this._disableDepthTestDistance,e):new BillboardGraphics(this)},BillboardGraphics.prototype.merge=function(e){this.show=defaultValue(this._show,e.show),this.image=defaultValue(this._image,e.image),this.scale=defaultValue(this._scale,e.scale),this.pixelOffset=defaultValue(this._pixelOffset,e.pixelOffset),this.eyeOffset=defaultValue(this._eyeOffset,e.eyeOffset),this.horizontalOrigin=defaultValue(this._horizontalOrigin,e.horizontalOrigin),this.verticalOrigin=defaultValue(this._verticalOrigin,e.verticalOrigin),this.heightReference=defaultValue(this._heightReference,e.heightReference),this.color=defaultValue(this._color,e.color),this.rotation=defaultValue(this._rotation,e.rotation),this.alignedAxis=defaultValue(this._alignedAxis,e.alignedAxis),this.sizeInMeters=defaultValue(this._sizeInMeters,e.sizeInMeters),this.width=defaultValue(this._width,e.width),this.height=defaultValue(this._height,e.height),this.scaleByDistance=defaultValue(this._scaleByDistance,e.scaleByDistance),this.translucencyByDistance=defaultValue(this._translucencyByDistance,e.translucencyByDistance),this.pixelOffsetScaleByDistance=defaultValue(this._pixelOffsetScaleByDistance,e.pixelOffsetScaleByDistance),this.imageSubRegion=defaultValue(this._imageSubRegion,e.imageSubRegion),this.distanceDisplayCondition=defaultValue(this._distanceDisplayCondition,e.distanceDisplayCondition),this.disableDepthTestDistance=defaultValue(this._disableDepthTestDistance,e.disableDepthTestDistance)};var HeightReference={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2},HeightReference$1=Object.freeze(HeightReference),HorizontalOrigin={CENTER:0,LEFT:1,RIGHT:-1},HorizontalOrigin$1=Object.freeze(HorizontalOrigin),VerticalOrigin={CENTER:0,BOTTOM:1,BASELINE:2,TOP:-1},VerticalOrigin$1=Object.freeze(VerticalOrigin),BoundingSphereState={DONE:0,PENDING:1,FAILED:2},BoundingSphereState$1=Object.freeze(BoundingSphereState);function Property(){DeveloperError.throwInstantiationError()}Object.defineProperties(Property.prototype,{isConstant:{get:DeveloperError.throwInstantiationError},definitionChanged:{get:DeveloperError.throwInstantiationError}}),Property.prototype.getValue=DeveloperError.throwInstantiationError,Property.prototype.equals=DeveloperError.throwInstantiationError,Property.equals=function(e,t){return e===t||defined(e)&&e.equals(t)},Property.arrayEquals=function(e,t){if(e===t)return!0;if(!defined(e)||!defined(t)||e.length!==t.length)return!1;for(var i=e.length,r=0;r<i;r++)if(!Property.equals(e[r],t[r]))return!1;return!0},Property.isConstant=function(e){return!defined(e)||e.isConstant},Property.getValueOrUndefined=function(e,t,i){return defined(e)?e.getValue(t,i):void 0},Property.getValueOrDefault=function(e,t,i,r){return defined(e)?defaultValue(e.getValue(t,r),i):i},Property.getValueOrClonedDefault=function(e,t,i,r){var n;return defined(e)&&(n=e.getValue(t,r)),n=!defined(n)?i.clone(n):n};var defaultColor$8=Color.WHITE,defaultEyeOffset$1=Cartesian3.ZERO,defaultHeightReference$2=HeightReference$1.NONE,defaultPixelOffset$1=Cartesian2.ZERO,defaultScale$3=1,defaultRotation=0,defaultAlignedAxis=Cartesian3.ZERO,defaultHorizontalOrigin$1=HorizontalOrigin$1.CENTER,defaultVerticalOrigin$1=VerticalOrigin$1.CENTER,defaultSizeInMeters=!1,positionScratch$7=new Cartesian3,colorScratch$6=new Color,eyeOffsetScratch$1=new Cartesian3,pixelOffsetScratch$1=new Cartesian2,scaleByDistanceScratch$2=new NearFarScalar,translucencyByDistanceScratch$2=new NearFarScalar,pixelOffsetScaleByDistanceScratch$1=new NearFarScalar,boundingRectangleScratch=new BoundingRectangle,distanceDisplayConditionScratch$8=new DistanceDisplayCondition;function EntityData$3(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function BillboardVisualizer(e,t){t.collectionChanged.addEventListener(BillboardVisualizer.prototype._onCollectionChanged,this),this._cluster=e,this._entityCollection=t,this._items=new AssociativeArray,this._onCollectionChanged(t,t.values,[],[])}function returnPrimitive$2(e,t,i){defined(e)&&(e.billboard=void 0,i.removeBillboard(t))}BillboardVisualizer.prototype.update=function(e){for(var t=this._items.values,i=this._cluster,r=0,n=t.length;r<n;r++){var a,o,s=t[r],l=s.entity,c=l._billboard,u=s.billboard,d=l.isShowing&&l.isAvailable(e)&&Property.getValueOrDefault(c._show,e,!0);d&&(o=Property.getValueOrUndefined(l._position,e,positionScratch$7),a=Property.getValueOrUndefined(c._image,e),d=defined(o)&&defined(a)),d?(Property.isConstant(l._position)||(i._clusterDirty=!0),defined(u)||((u=i.getBillboard(l)).id=l,u.image=void 0,s.billboard=u),u.show=d,defined(u.image)&&s.textureValue===a||(u.image=a,s.textureValue=a),u.position=o,u.color=Property.getValueOrDefault(c._color,e,defaultColor$8,colorScratch$6),u.eyeOffset=Property.getValueOrDefault(c._eyeOffset,e,defaultEyeOffset$1,eyeOffsetScratch$1),u.heightReference=Property.getValueOrDefault(c._heightReference,e,defaultHeightReference$2),u.pixelOffset=Property.getValueOrDefault(c._pixelOffset,e,defaultPixelOffset$1,pixelOffsetScratch$1),u.scale=Property.getValueOrDefault(c._scale,e,defaultScale$3),u.rotation=Property.getValueOrDefault(c._rotation,e,defaultRotation),u.alignedAxis=Property.getValueOrDefault(c._alignedAxis,e,defaultAlignedAxis),u.horizontalOrigin=Property.getValueOrDefault(c._horizontalOrigin,e,defaultHorizontalOrigin$1),u.verticalOrigin=Property.getValueOrDefault(c._verticalOrigin,e,defaultVerticalOrigin$1),u.width=Property.getValueOrUndefined(c._width,e),u.height=Property.getValueOrUndefined(c._height,e),u.scaleByDistance=Property.getValueOrUndefined(c._scaleByDistance,e,scaleByDistanceScratch$2),u.translucencyByDistance=Property.getValueOrUndefined(c._translucencyByDistance,e,translucencyByDistanceScratch$2),u.pixelOffsetScaleByDistance=Property.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,pixelOffsetScaleByDistanceScratch$1),u.sizeInMeters=Property.getValueOrDefault(c._sizeInMeters,e,defaultSizeInMeters),u.distanceDisplayCondition=Property.getValueOrUndefined(c._distanceDisplayCondition,e,distanceDisplayConditionScratch$8),u.disableDepthTestDistance=Property.getValueOrUndefined(c._disableDepthTestDistance,e),defined(c=Property.getValueOrUndefined(c._imageSubRegion,e,boundingRectangleScratch))&&u.setImageSubRegion(u._imageId,c)):returnPrimitive$2(s,l,i)}return!0},BillboardVisualizer.prototype.getBoundingSphere=function(e,t){e=this._items.get(e.id);if(!defined(e)||!defined(e.billboard))return BoundingSphereState$1.FAILED;e=e.billboard;if(e.heightReference===HeightReference$1.NONE)t.center=Cartesian3.clone(e.position,t.center);else{if(!defined(e._clampedPosition))return BoundingSphereState$1.PENDING;t.center=Cartesian3.clone(e._clampedPosition,t.center)}return t.radius=0,BoundingSphereState$1.DONE},BillboardVisualizer.prototype.isDestroyed=function(){return!1},BillboardVisualizer.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(BillboardVisualizer.prototype._onCollectionChanged,this);for(var e=this._entityCollection.values,t=0;t<e.length;t++)this._cluster.removeBillboard(e[t]);return destroyObject(this)},BillboardVisualizer.prototype._onCollectionChanged=function(e,t,i,r){for(var n,a=this._items,o=this._cluster,s=t.length-1;-1<s;s--)defined((n=t[s])._billboard)&&defined(n._position)&&a.set(n.id,new EntityData$3(n));for(s=r.length-1;-1<s;s--)defined((n=r[s])._billboard)&&defined(n._position)?a.contains(n.id)||a.set(n.id,new EntityData$3(n)):(returnPrimitive$2(a.get(n.id),n,o),a.remove(n.id));for(s=i.length-1;-1<s;s--)n=i[s],returnPrimitive$2(a.get(n.id),n,o),a.remove(n.id)};var AllMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_bitangentEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",AllMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 bitangent;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_bitangentEC = czm_normal * bitangent;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BasicMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",BasicMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",TexturedMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",TexturedMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BlendEquation={ADD:WebGLConstants$1.FUNC_ADD,SUBTRACT:WebGLConstants$1.FUNC_SUBTRACT,REVERSE_SUBTRACT:WebGLConstants$1.FUNC_REVERSE_SUBTRACT,MIN:WebGLConstants$1.MIN,MAX:WebGLConstants$1.MAX},BlendEquation$1=Object.freeze(BlendEquation),BlendFunction={ZERO:WebGLConstants$1.ZERO,ONE:WebGLConstants$1.ONE,SOURCE_COLOR:WebGLConstants$1.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:WebGLConstants$1.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:WebGLConstants$1.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:WebGLConstants$1.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:WebGLConstants$1.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:WebGLConstants$1.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:WebGLConstants$1.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:WebGLConstants$1.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:WebGLConstants$1.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:WebGLConstants$1.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:WebGLConstants$1.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:WebGLConstants$1.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:WebGLConstants$1.SRC_ALPHA_SATURATE},BlendFunction$1=Object.freeze(BlendFunction),BlendingState={DISABLED:Object.freeze({enabled:!1}),ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.ONE,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE,functionDestinationAlpha:BlendFunction$1.ONE})},BlendingState$1=Object.freeze(BlendingState),CullFace={FRONT:WebGLConstants$1.FRONT,BACK:WebGLConstants$1.BACK,FRONT_AND_BACK:WebGLConstants$1.FRONT_AND_BACK},CullFace$1=Object.freeze(CullFace);function Appearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.material=e.material,this.translucent=defaultValue(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=defaultValue(e.closed,!1)}Object.defineProperties(Appearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),Appearance.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),defined(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},Appearance.prototype.isTranslucent=function(){return defined(this.material)&&this.material.isTranslucent()||!defined(this.material)&&this.translucent},Appearance.prototype.getRenderState=function(){var e=this.isTranslucent(),t=clone$1(this.renderState,!1);return e?(t.depthMask=!1,t.blending=BlendingState$1.ALPHA_BLEND):t.depthMask=!0,t},Appearance.getDefaultRenderState=function(e,t,i){var r={depthTest:{enabled:!0}};return e&&(r.depthMask=!1,r.blending=BlendingState$1.ALPHA_BLEND),t&&(r.cull={enabled:!0,face:CullFace$1.BACK}),r=defined(i)?combine$2(i,r,!0):r};var ContextLimits={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};function CubeMapFace(e,t,i,r,n,a,o,s,l,c,u){this._context=e,this._texture=t,this._textureTarget=i,this._targetFace=r,this._pixelDatatype=o,this._internalFormat=n,this._pixelFormat=a,this._size=s,this._preMultiplyAlpha=l,this._flipY=c,this._initialized=u}Object.defineProperties(ContextLimits,{maximumCombinedTextureImageUnits:{get:function(){return ContextLimits._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return ContextLimits._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return ContextLimits._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return ContextLimits._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return ContextLimits._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return ContextLimits._maximumTextureSize}},maximumVaryingVectors:{get:function(){return ContextLimits._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return ContextLimits._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return ContextLimits._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return ContextLimits._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return ContextLimits._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return ContextLimits._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return ContextLimits._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return ContextLimits._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return ContextLimits._maximumViewportWidth}},maximumViewportHeight:{get:function(){return ContextLimits._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return ContextLimits._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return ContextLimits._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return ContextLimits._maximumColorAttachments}},highpFloatSupported:{get:function(){return ContextLimits._highpFloatSupported}},highpIntSupported:{get:function(){return ContextLimits._highpIntSupported}}}),Object.defineProperties(CubeMapFace.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),CubeMapFace.prototype.copyFrom=function(e){var t=defaultValue(e.xOffset,0),i=defaultValue(e.yOffset,0),r=e.source,n=this._context._gl,a=this._textureTarget,o=this._targetFace;n.activeTexture(n.TEXTURE0),n.bindTexture(a,this._texture);var s=r.width,l=r.height,c=r.arrayBufferView,u=this._size,d=this._pixelFormat,h=this._internalFormat,p=this._pixelDatatype,f=this._preMultiplyAlpha,m=this._flipY,g=defaultValue(e.skipColorSpaceConversion,!1),e=4;defined(c)&&(e=PixelFormat$1.alignmentInBytes(d,p,s)),n.pixelStorei(n.UNPACK_ALIGNMENT,e),g?n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.NONE):n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.BROWSER_DEFAULT_WEBGL);e=!1;this._initialized||(0===t&&0===i&&s===u&&l===u?(defined(c)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),m&&(c=PixelFormat$1.flipY(c,d,p,u,u)),n.texImage2D(o,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),c)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,m),n.texImage2D(o,0,h,d,PixelDatatype$1.toWebGLConstant(p,this._context),r)),e=!0):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),g=PixelFormat$1.createTypedArray(d,p,u,u),n.texImage2D(o,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),g)),this._initialized=!0),e||(defined(c)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),m&&(c=PixelFormat$1.flipY(c,d,p,s,l)),n.texSubImage2D(o,0,t,i,s,l,d,PixelDatatype$1.toWebGLConstant(p,this._context),c)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,m),n.texSubImage2D(o,0,t,i,d,PixelDatatype$1.toWebGLConstant(p,this._context),r))),n.bindTexture(a,null)},CubeMapFace.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._size),a=defaultValue(a,this._size);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(this._targetFace,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0};var MipmapHint={DONT_CARE:WebGLConstants$1.DONT_CARE,FASTEST:WebGLConstants$1.FASTEST,NICEST:WebGLConstants$1.NICEST,validate:function(e){return e===MipmapHint.DONT_CARE||e===MipmapHint.FASTEST||e===MipmapHint.NICEST}},MipmapHint$1=Object.freeze(MipmapHint),TextureMagnificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,validate:function(e){return e===TextureMagnificationFilter.NEAREST||e===TextureMagnificationFilter.LINEAR}},TextureMagnificationFilter$1=Object.freeze(TextureMagnificationFilter),TextureMinificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,NEAREST_MIPMAP_NEAREST:WebGLConstants$1.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:WebGLConstants$1.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:WebGLConstants$1.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:WebGLConstants$1.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===TextureMinificationFilter.NEAREST||e===TextureMinificationFilter.LINEAR||e===TextureMinificationFilter.NEAREST_MIPMAP_NEAREST||e===TextureMinificationFilter.LINEAR_MIPMAP_NEAREST||e===TextureMinificationFilter.NEAREST_MIPMAP_LINEAR||e===TextureMinificationFilter.LINEAR_MIPMAP_LINEAR}},TextureMinificationFilter$1=Object.freeze(TextureMinificationFilter),TextureWrap={CLAMP_TO_EDGE:WebGLConstants$1.CLAMP_TO_EDGE,REPEAT:WebGLConstants$1.REPEAT,MIRRORED_REPEAT:WebGLConstants$1.MIRRORED_REPEAT,validate:function(e){return e===TextureWrap.CLAMP_TO_EDGE||e===TextureWrap.REPEAT||e===TextureWrap.MIRRORED_REPEAT}},TextureWrap$1=Object.freeze(TextureWrap);function Sampler(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.wrapS,TextureWrap$1.CLAMP_TO_EDGE),i=defaultValue(e.wrapT,TextureWrap$1.CLAMP_TO_EDGE),r=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),n=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),e=defined(e.maximumAnisotropy)?e.maximumAnisotropy:1;this._wrapS=t,this._wrapT=i,this._minificationFilter=r,this._magnificationFilter=n,this._maximumAnisotropy=e}function CubeMap(e){var s,l=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,t=e.source;defined(t)?(f=[t.positiveX,t.negativeX,t.positiveY,t.negativeY,t.positiveZ,t.negativeZ],s=f[0].width,f[0].height):s=e.width;var c=s,u=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),d=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),h=PixelFormat$1.toInternalFormat(d,u,l),i=6*PixelFormat$1.textureSizeInBytes(d,u,c,c),r=e.preMultiplyAlpha||d===PixelFormat$1.RGB||d===PixelFormat$1.LUMINANCE,n=defaultValue(e.flipY,!0),a=defaultValue(e.skipColorSpaceConversion,!1),p=l._gl,o=p.TEXTURE_CUBE_MAP,f=p.createTexture();function m(e,t,i,r,n){var a=t.arrayBufferView;defined(a)||(a=t.bufferView);var o=4;defined(a)&&(o=PixelFormat$1.alignmentInBytes(d,u,s)),p.pixelStorei(p.UNPACK_ALIGNMENT,o),n?p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.NONE):p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.BROWSER_DEFAULT_WEBGL),defined(a)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1),r&&(a=PixelFormat$1.flipY(a,d,u,c,c)),p.texImage2D(e,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),a)):(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,r),p.texImage2D(e,0,h,d,PixelDatatype$1.toWebGLConstant(u,l),t))}p.activeTexture(p.TEXTURE0),p.bindTexture(o,f),defined(t)?(m(p.TEXTURE_CUBE_MAP_POSITIVE_X,t.positiveX,r,n,a),m(p.TEXTURE_CUBE_MAP_NEGATIVE_X,t.negativeX,r,n,a),m(p.TEXTURE_CUBE_MAP_POSITIVE_Y,t.positiveY,r,n,a),m(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,t.negativeY,r,n,a),m(p.TEXTURE_CUBE_MAP_POSITIVE_Z,t.positiveZ,r,n,a),m(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,t.negativeZ,r,n,a)):(p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_X,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_X,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Y,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Z,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,h,c,c,0,d,PixelDatatype$1.toWebGLConstant(u,l),null)),p.bindTexture(o,null),this._context=l,this._textureFilterAnisotropic=l._textureFilterAnisotropic,this._textureTarget=o,this._texture=f,this._pixelFormat=d,this._pixelDatatype=u,this._size=c,this._hasMipmap=!1,this._sizeInBytes=i,this._preMultiplyAlpha=r,this._flipY=n,this._sampler=void 0;t=defined(t);this._positiveX=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_POSITIVE_X,h,d,u,c,r,n,t),this._negativeX=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_NEGATIVE_X,h,d,u,c,r,n,t),this._positiveY=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_POSITIVE_Y,h,d,u,c,r,n,t),this._negativeY=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_NEGATIVE_Y,h,d,u,c,r,n,t),this._positiveZ=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_POSITIVE_Z,h,d,u,c,r,n,t),this._negativeZ=new CubeMapFace(l,f,o,p.TEXTURE_CUBE_MAP_NEGATIVE_Z,h,d,u,c,r,n,t),this.sampler=defined(e.sampler)?e.sampler:new Sampler}function Texture(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=e.width,r=e.height,n=e.source;defined(n)&&(defined(i)||(i=defaultValue(n.videoWidth,n.width)),defined(r)||(r=defaultValue(n.videoHeight,n.height)));var a=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=PixelFormat$1.toInternalFormat(a,o,t),l=PixelFormat$1.isCompressedFormat(s),c=e.preMultiplyAlpha||a===PixelFormat$1.RGB||a===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=defaultValue(e.skipColorSpaceConversion,!1),h=!0,p=t._gl,f=p.TEXTURE_2D,m=p.createTexture();p.activeTexture(p.TEXTURE0),p.bindTexture(f,m);var g=4;if(defined(n)&&defined(n.arrayBufferView)&&!l&&(g=PixelFormat$1.alignmentInBytes(a,o,i)),p.pixelStorei(p.UNPACK_ALIGNMENT,g),d?p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.NONE):p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.BROWSER_DEFAULT_WEBGL),defined(n))if(defined(n.arrayBufferView)){p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1);var _,y,C,d=n.arrayBufferView;if(l){if(p.compressedTexImage2D(f,0,s,i,r,0,d),defined(n.mipLevels))for(y=i,C=r,_=0;_<n.mipLevels.length;++_)(y=0|Math.floor(y/2))<1&&(y=1),(C=0|Math.floor(C/2))<1&&(C=1),p.compressedTexImage2D(f,_+1,s,y,C,0,n.mipLevels[_])}else if(u&&(d=PixelFormat$1.flipY(d,a,o,i,r)),p.texImage2D(f,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),d),defined(n.mipLevels))for(y=i,C=r,_=0;_<n.mipLevels.length;++_)(y=0|Math.floor(y/2))<1&&(y=1),(C=0|Math.floor(C/2))<1&&(C=1),p.texImage2D(f,_+1,s,y,C,0,a,PixelDatatype$1.toWebGLConstant(o,t),n.mipLevels[_])}else defined(n.framebuffer)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._bind(),p.copyTexImage2D(f,0,s,n.xOffset,n.yOffset,i,r,0),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._unBind()):(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,u),p.texImage2D(f,0,s,a,PixelDatatype$1.toWebGLConstant(o,t),n));else p.texImage2D(f,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h=!1;p.bindTexture(f,null),l=l?PixelFormat$1.compressedTextureSizeInBytes(a,i,r):PixelFormat$1.textureSizeInBytes(a,o,i,r),this._id=createGuid(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=f,this._texture=m,this._internalFormat=s,this._pixelFormat=a,this._pixelDatatype=o,this._width=i,this._height=r,this._dimensions=new Cartesian2(i,r),this._hasMipmap=!1,this._sizeInBytes=l,this._preMultiplyAlpha=c,this._flipY=u,this._initialized=h,this._sampler=void 0,this.sampler=defined(e.sampler)?e.sampler:new Sampler}Object.defineProperties(Sampler.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),Sampler.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy},Sampler.NEAREST=Object.freeze(new Sampler({wrapS:TextureWrap$1.CLAMP_TO_EDGE,wrapT:TextureWrap$1.CLAMP_TO_EDGE,minificationFilter:TextureMinificationFilter$1.NEAREST,magnificationFilter:TextureMagnificationFilter$1.NEAREST})),Object.defineProperties(CubeMap.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,n=this._context,a=this._pixelDatatype;(a===PixelDatatype$1.FLOAT&&!n.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!n.textureHalfFloatLinear)&&(t=r?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);r=n._gl,n=this._textureTarget;r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture),r.texParameteri(n,r.TEXTURE_MIN_FILTER,t),r.texParameteri(n,r.TEXTURE_MAG_FILTER,i),r.texParameteri(n,r.TEXTURE_WRAP_S,e.wrapS),r.texParameteri(n,r.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&r.texParameteri(n,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),r.bindTexture(n,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),CubeMap.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},CubeMap.prototype.isDestroyed=function(){return!1},CubeMap.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=destroyObject(this._positiveX),this._negativeX=destroyObject(this._negativeX),this._positiveY=destroyObject(this._positiveY),this._negativeY=destroyObject(this._negativeY),this._positiveZ=destroyObject(this._positiveZ),this._negativeZ=destroyObject(this._negativeZ),destroyObject(this)},Texture.create=function(e){return new Texture(e)},Texture.fromFramebuffer=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=t._gl,r=defaultValue(e.pixelFormat,PixelFormat$1.RGB),n=defaultValue(e.framebufferXOffset,0),a=defaultValue(e.framebufferYOffset,0),o=defaultValue(e.width,i.drawingBufferWidth),i=defaultValue(e.height,i.drawingBufferHeight),e=e.framebuffer;return new Texture({context:t,width:o,height:i,pixelFormat:r,source:{framebuffer:defined(e)?e:t.defaultFramebuffer,xOffset:n,yOffset:a,width:o,height:i}})},Object.defineProperties(Texture.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=this._context,n=this._pixelFormat,a=this._pixelDatatype,o=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR;(a===PixelDatatype$1.FLOAT&&!r.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(t=o?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST),r.webgl2&&PixelFormat$1.isDepthFormat(n)&&(t=TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);n=r._gl,r=this._textureTarget;n.activeTexture(n.TEXTURE0),n.bindTexture(r,this._texture),n.texParameteri(r,n.TEXTURE_MIN_FILTER,t),n.texParameteri(r,n.TEXTURE_MAG_FILTER,i),n.texParameteri(r,n.TEXTURE_WRAP_S,e.wrapS),n.texParameteri(r,n.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&n.texParameteri(r,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),n.bindTexture(r,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}}),Texture.prototype.copyFrom=function(e){var t=defaultValue(e.xOffset,0),i=defaultValue(e.yOffset,0),r=e.source,n=this._context,a=n._gl,o=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(o,this._texture);var s=r.width,l=r.height,c=r.arrayBufferView,u=this._width,d=this._height,h=this._internalFormat,p=this._pixelFormat,f=this._pixelDatatype,m=this._preMultiplyAlpha,g=this._flipY,_=defaultValue(e.skipColorSpaceConversion,!1),e=4;defined(c)&&(e=PixelFormat$1.alignmentInBytes(p,f,s)),a.pixelStorei(a.UNPACK_ALIGNMENT,e),_?a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.NONE):a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.BROWSER_DEFAULT_WEBGL);e=!1;this._initialized||(0===t&&0===i&&s===u&&l===d?(defined(c)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),g&&(c=PixelFormat$1.flipY(c,p,f,u,d)),a.texImage2D(o,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,n),c)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,g),a.texImage2D(o,0,h,p,PixelDatatype$1.toWebGLConstant(f,n),r)),e=!0):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),_=PixelFormat$1.createTypedArray(p,f,u,d),a.texImage2D(o,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,n),_)),this._initialized=!0),e||(defined(c)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),g&&(c=PixelFormat$1.flipY(c,p,f,s,l)),a.texSubImage2D(o,0,t,i,s,l,p,PixelDatatype$1.toWebGLConstant(f,n),c)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,g),a.texSubImage2D(o,0,t,i,p,PixelDatatype$1.toWebGLConstant(f,n),r))),a.bindTexture(o,null)},Texture.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._width),a=defaultValue(a,this._height);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(s,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0},Texture.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},Texture.prototype.isDestroyed=function(){return!1},Texture.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),destroyObject(this)};var AspectRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",BumpMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n",CheckerboardMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",DotMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationBandMaterial="uniform sampler2D heights;\nuniform sampler2D colors;\nfloat getHeight(int idx, float invTexSize)\n{\nvec2 uv = vec2((float(idx) + 0.5) * invTexSize, 0.5);\n#ifdef OES_texture_float\nreturn texture2D(heights, uv).x;\n#else\nreturn czm_unpackFloat(texture2D(heights, uv));\n#endif\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat height = materialInput.height;\nfloat invTexSize = 1.0 / float(heightsDimensions.x);\nfloat minHeight = getHeight(0, invTexSize);\nfloat maxHeight = getHeight(heightsDimensions.x - 1, invTexSize);\nif (height < minHeight || height > maxHeight) {\nmaterial.diffuse = vec3(0.0);\nmaterial.alpha = 0.0;\nreturn material;\n}\nint idxBelow = 0;\nint idxAbove = heightsDimensions.x;\nfloat heightBelow = minHeight;\nfloat heightAbove = maxHeight;\nconst int maxIterations = 16;\nfor (int i = 0; i < maxIterations; i++) {\nif (idxBelow >= idxAbove - 1) {\nbreak;\n}\nint idxMid = (idxBelow + idxAbove) / 2;\nfloat heightTex = getHeight(idxMid, invTexSize);\nif (height > heightTex) {\nidxBelow = idxMid;\nheightBelow = heightTex;\n} else {\nidxAbove = idxMid;\nheightAbove = heightTex;\n}\n}\nfloat lerper = heightBelow == heightAbove ? 1.0 : (height - heightBelow) / (heightAbove - heightBelow);\nvec2 colorUv = vec2(invTexSize * (float(idxBelow) + 0.5 + lerper), 0.5);\nvec4 color = texture2D(colors, colorUv);\nif (color.a > 0.0)\n{\ncolor.rgb /= color.a;\n}\ncolor.rgb = czm_gammaCorrect(color.rgb);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationContourMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float spacing;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat distanceToContour = mod(materialInput.height, spacing);\n#ifdef GL_OES_standard_derivatives\nfloat dxc = abs(dFdx(materialInput.height));\nfloat dyc = abs(dFdy(materialInput.height));\nfloat dF = max(dxc, dyc) * czm_pixelRatio * width;\nfloat alpha = (distanceToContour < dF) ? 1.0 : 0.0;\n#else\nfloat alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;\n#endif\nvec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha * color.a));\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",ElevationRampMaterial="uniform sampler2D image;\nuniform float minimumHeight;\nuniform float maximumHeight;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);\nvec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",FadeMaterial="uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\ncolor = czm_gammaCorrect(color);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",GridMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec4 halfColor;\nhalfColor.rgb = color.rgb * 0.5;\nhalfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nhalfColor = czm_gammaCorrect(halfColor);\nmaterial.diffuse = halfColor.rgb;\nmaterial.emission = halfColor.rgb;\nmaterial.alpha = halfColor.a;\nreturn material;\n}\n",NormalMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n",PolylineArrowMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\n#ifdef GL_OES_standard_derivatives\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;\n#else\nfloat base = 0.975;\n#endif\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",PolylineDashMaterial="uniform vec4 color;\nuniform vec4 gapColor;\nuniform float dashLength;\nuniform float dashPattern;\nvarying float v_polylineAngle;\nconst float maskLength = 16.0;\nmat2 rotate(float rad) {\nfloat c = cos(rad);\nfloat s = sin(rad);\nreturn mat2(\nc, s,\n-s, c\n);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;\nfloat dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));\nfloat maskIndex = floor(dashPosition * maskLength);\nfloat maskTest = floor(dashPattern / pow(2.0, maskIndex));\nvec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;\nif (fragColor.a < 0.005) {\ndiscard;\n}\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineGlowMaterial="uniform vec4 color;\nuniform float glowPower;\nuniform float taperPower;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nif (taperPower <= 0.99999) {\nglow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));\n}\nvec4 fragColor;\nfragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nfragColor.a = clamp(0.0, 1.0, glow) * color.a;\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineOutlineMaterial="uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",RimLightingMaterial="uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nvec4 outColor = czm_gammaCorrect(color);\nvec4 outRimColor = czm_gammaCorrect(rimColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.emission = outRimColor.rgb * s;\nmaterial.alpha = mix(outColor.a, outRimColor.a, s);\nreturn material;\n}\n",SlopeRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",StripeMaterial="uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",WaterMaterial="uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = mix(blendColor.a, baseWaterColor.a, specularMapValue) * specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.diffuse = material.diffuse;\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n";function Material$3(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._minificationFilter=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),this._magnificationFilter=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,initializeMaterial(e,this),Object.defineProperties(this,{type:{value:this.type,writable:!1}}),defined(Material$3._uniformList[this.type])||(Material$3._uniformList[this.type]=Object.keys(this._uniforms))}function initializeMaterial(e,t){e=defaultValue(e,defaultValue.EMPTY_OBJECT),t._strict=defaultValue(e.strict,!1),t._count=defaultValue(e.count,0),t._template=clone$1(defaultValue(e.fabric,defaultValue.EMPTY_OBJECT)),t._template.uniforms=clone$1(defaultValue(t._template.uniforms,defaultValue.EMPTY_OBJECT)),t._template.materials=clone$1(defaultValue(t._template.materials,defaultValue.EMPTY_OBJECT)),t.type=defined(t._template.type)?t._template.type:createGuid(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];var i,r=Material$3._materialCache.getMaterial(t.type);defined(r)&&(i=clone$1(r.fabric,!0),t._template=combine$2(t._template,i,!0),n=r.translucent),checkForTemplateErrors(t),defined(r)||Material$3._materialCache.addMaterial(t.type,t),createMethodDefinition(t),createUniforms(t),createSubMaterials(t);var r=0===t._translucentFunctions.length||void 0,n=defaultValue(n,r);defined(n=defaultValue(e.translucent,n))&&("function"==typeof n?t._translucentFunctions.push(function(){return n(t)}):t._translucentFunctions.push(n))}function checkForValidProperties(e,t,i,r){if(defined(e))for(var n in e){var a;e.hasOwnProperty(n)&&(a=-1!==t.indexOf(n),(r&&!a||!r&&a)&&i(n,t))}}function invalidNameError(e,t){}function duplicateNameError(e,t){}Material$3._uniformList={},Material$3.fromType=function(e,t){var i=new Material$3({fabric:{type:e}});if(defined(t))for(var r in t)t.hasOwnProperty(r)&&(i.uniforms[r]=t[r]);return i},Material$3.prototype.isTranslucent=function(){if(defined(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,i=t.length,r=0;r<i;++r){var n=t[r];if(!(e="function"==typeof n?e&&n():e&&n))break}return e},Material$3.prototype.update=function(e){this._defaultTexture=e.defaultTexture;for(var t=this._loadedImages,i=t.length,r=0;r<i;++r){var n,a=t[r],o=a.id,s=a.image;Array.isArray(s)&&(n=s.slice(1,s.length).map(function(e){return e.bufferView}),s=s[0]);a=new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter}),s=defined(s.internalFormat)?new Texture({context:e,pixelFormat:s.internalFormat,width:s.width,height:s.height,source:{arrayBufferView:s.bufferView,mipLevels:n},sampler:a}):new Texture({context:e,source:s,sampler:a}),a=this._textures[o];defined(a)&&a!==this._defaultTexture&&a.destroy(),this._textures[o]=s;a=o+"Dimensions";this.uniforms.hasOwnProperty(a)&&((a=this.uniforms[a]).x=s._width,a.y=s._height)}t.length=0;var l=this._loadedCubeMaps,i=l.length;for(r=0;r<i;++r){var c=l[r];o=c.id;c=c.images,c=new CubeMap({context:e,source:{positiveX:c[0],negativeX:c[1],positiveY:c[2],negativeY:c[3],positiveZ:c[4],negativeZ:c[5]},sampler:new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter})});this._textures[o]=c}l.length=0;var u=this._updateFunctions;for(i=u.length,r=0;r<i;++r)u[r](this,e);var d,h=this.materials;for(d in h)h.hasOwnProperty(d)&&h[d].update(e)},Material$3.prototype.isDestroyed=function(){return!1},Material$3.prototype.destroy=function(){var e,t,i=this._textures;for(e in i)!i.hasOwnProperty(e)||(t=i[e])!==this._defaultTexture&&t.destroy();var r,n=this.materials;for(r in n)n.hasOwnProperty(r)&&n[r].destroy();return destroyObject(this)};var templateProperties=["type","materials","uniforms","components","source"],componentProperties=["diffuse","specular","shininess","normal","emission","alpha"];function checkForTemplateErrors(e){var t=e._template,i=t.uniforms,r=t.materials,e=t.components;checkForValidProperties(t,templateProperties,invalidNameError,!0),checkForValidProperties(e,componentProperties,invalidNameError,!0);var n,a=[];for(n in r)r.hasOwnProperty(n)&&a.push(n);checkForValidProperties(i,a,duplicateNameError,!1)}function isMaterialFused(e,t){var i,r=t._template.materials;for(i in r)if(r.hasOwnProperty(i)&&-1<e.indexOf(i))return!0;return!1}function createMethodDefinition(e){var t=e._template.components,i=e._template.source;if(defined(i))e.shaderSource+=i+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",defined(t)){var r,n,a=0<Object.keys(e._template.materials).length;for(r in t)t.hasOwnProperty(r)&&("diffuse"===r||"emission"===r?(n=a&&isMaterialFused(t[r],e)?t[r]:"czm_gammaCorrect("+t[r]+")",e.shaderSource+="material."+r+" = "+n+"; \n"):e.shaderSource+="alpha"===r?"material.alpha = "+t.alpha+"; \n":"material."+r+" = "+t[r]+";\n")}e.shaderSource+="return material;\n}\n"}}var matrixMap={mat2:Matrix2,mat3:Matrix3,mat4:Matrix4},ktx2Regex$3=/\.ktx2$/i;function createTexture2DUpdateFunction(c){var u;return function(t,e){var i=t.uniforms,r=i[c],n=u!==r,a=!defined(r)||r===Material$3.DefaultImageId;u=r;var o,s=t._textures[c];if(r instanceof HTMLVideoElement)if(2<=r.readyState){if(n&&defined(s)&&(s!==e.defaultTexture&&s.destroy(),s=void 0),!defined(s)||s===e.defaultTexture){s=new Texture({context:e,source:r,sampler:new Sampler({minificationFilter:t._minificationFilter,magnificationFilter:t._magnificationFilter})});return void(t._textures[c]=s)}s.copyFrom({source:r})}else defined(s)||(t._textures[c]=e.defaultTexture);else{if(r instanceof Texture&&r!==s){t._texturePaths[c]=void 0;var l=t._textures[c];return defined(l)&&l!==t._defaultTexture&&l.destroy(),t._textures[c]=r,void(i.hasOwnProperty(l=c+"Dimensions")&&((o=i[l]).x=r._width,o.y=r._height))}n&&defined(s)&&a&&(s!==t._defaultTexture&&s.destroy(),s=void 0),defined(s)||(t._texturePaths[c]=void 0,s=t._textures[c]=t._defaultTexture,i.hasOwnProperty(l=c+"Dimensions")&&((o=i[l]).x=s._width,o.y=s._height)),a||(a=r instanceof Resource,(!defined(t._texturePaths[c])||a&&r.url!==t._texturePaths[c].url||!a&&r!==t._texturePaths[c])&&("string"==typeof r||a?(a=a?r:Resource.createIfNeeded(r),(ktx2Regex$3.test(a.url)?loadKTX2(a.url):a.fetchImage()).then(function(e){t._loadedImages.push({id:c,image:e})}).otherwise(function(){defined(s)&&s!==t._defaultTexture&&s.destroy(),t._textures[c]=t._defaultTexture})):(r instanceof HTMLCanvasElement||r instanceof HTMLImageElement)&&t._loadedImages.push({id:c,image:r}),t._texturePaths[c]=r))}}}function createCubeMapUpdateFunction(n){return function(t,e){var i=t.uniforms[n];if(i instanceof CubeMap){var r=t._textures[n];return r!==t._defaultTexture&&r.destroy(),t._texturePaths[n]=void 0,void(t._textures[n]=i)}defined(t._textures[n])||(t._texturePaths[n]=void 0,t._textures[n]=e.defaultCubeMap),i===Material$3.DefaultCubeMapId||(e=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ)!==t._texturePaths[n]&&(i=[Resource.createIfNeeded(i.positiveX).fetchImage(),Resource.createIfNeeded(i.negativeX).fetchImage(),Resource.createIfNeeded(i.positiveY).fetchImage(),Resource.createIfNeeded(i.negativeY).fetchImage(),Resource.createIfNeeded(i.positiveZ).fetchImage(),Resource.createIfNeeded(i.negativeZ).fetchImage()],when.all(i).then(function(e){t._loadedCubeMaps.push({id:n,images:e})}),t._texturePaths[n]=e)}}function createUniforms(e){var t,i=e._template.uniforms;for(t in i)i.hasOwnProperty(t)&&createUniform$1(e,t)}function createUniform$1(e,t){e._strict;var i,r,n=e._template.uniforms,a=n[t],o=getUniformType(a);"channels"===o?replaceToken(e,t,a,!1):("sampler2D"!==o||0<getNumberOfTokens(e,i=t+"Dimensions")&&(n[i]={type:"ivec3",x:1,y:1},createUniform$1(e,i)),new RegExp("uniform\\s+"+o+"\\s+"+t+"\\s*;").test(e.shaderSource)||(e.shaderSource="uniform "+o+" "+t+";"+e.shaderSource),i=t+"_"+e._count++,replaceToken(e,t,i),e.uniforms[t]=a,"sampler2D"===o?(e._uniforms[i]=function(){return e._textures[t]},e._updateFunctions.push(createTexture2DUpdateFunction(t))):"samplerCube"===o?(e._uniforms[i]=function(){return e._textures[t]},e._updateFunctions.push(createCubeMapUpdateFunction(t))):-1!==o.indexOf("mat")?(r=new matrixMap[o],e._uniforms[i]=function(){return matrixMap[o].fromColumnMajorArray(e.uniforms[t],r)}):e._uniforms[i]=function(){return e.uniforms[t]})}function getUniformType(e){var t=e.type;if(!defined(t)){var i=typeof e;if("number"==i)t="float";else if("boolean"==i)t="bool";else if("string"==i||e instanceof Resource||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===Material$3.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"==i)if(Array.isArray(e))4!==e.length&&9!==e.length&&16!==e.length||(t="mat"+Math.sqrt(e.length));else{var r,n=0;for(r in e)e.hasOwnProperty(r)&&(n+=1);2<=n&&n<=4?t="vec"+n:6===n&&(t="samplerCube")}}return t}function createSubMaterials(e){var t,i,r,n=e._strict,a=e._template.materials;for(t in a)a.hasOwnProperty(t)&&(i=new Material$3({strict:n,fabric:a[t],count:e._count}),e._count=i._count,e._uniforms=combine$2(e._uniforms,i._uniforms,!0),e.materials[t]=i,e._translucentFunctions=e._translucentFunctions.concat(i._translucentFunctions),replaceToken(i,r="czm_getMaterial",r=r+"_"+e._count++),e.shaderSource=i.shaderSource+e.shaderSource,replaceToken(e,t,r+"(materialInput)"))}function replaceToken(e,t,r,i){i=defaultValue(i,!0);var n=0,t=new RegExp("([\\w"+(i?".":"")+"])?"+t+"([\\w])?","g");return e.shaderSource=e.shaderSource.replace(t,function(e,t,i){return t||i?e:(n+=1,r)}),n}function getNumberOfTokens(e,t,i){return replaceToken(e,t,t,i)}function MaterialAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.materialSupport,MaterialAppearance.MaterialSupport.TEXTURED);this.material=defined(e.material)?e.material:Material$3.fromType(Material$3.ColorType),this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,r.vertexShaderSource),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,r.fragmentShaderSource),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._materialSupport=r,this._vertexFormat=r.vertexFormat,this._flat=defaultValue(e.flat,!1),this._faceForward=defaultValue(e.faceForward,!i)}Material$3._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},Material$3.DefaultImageId="czm_defaultImage",Material$3.DefaultCubeMapId="czm_defaultCubeMap",Material$3.ColorType="Color",Material$3._materialCache.addMaterial(Material$3.ColorType,{fabric:{type:Material$3.ColorType,uniforms:{color:new Color(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$3.ImageType="Image",Material$3._materialCache.addMaterial(Material$3.ImageType,{fabric:{type:Material$3.ImageType,uniforms:{image:Material$3.DefaultImageId,repeat:new Cartesian2(1,1),color:new Color(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$3.DiffuseMapType="DiffuseMap",Material$3._materialCache.addMaterial(Material$3.DiffuseMapType,{fabric:{type:Material$3.DiffuseMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$3.AlphaMapType="AlphaMap",Material$3._materialCache.addMaterial(Material$3.AlphaMapType,{fabric:{type:Material$3.AlphaMapType,uniforms:{image:Material$3.DefaultImageId,channel:"a",repeat:new Cartesian2(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),Material$3.SpecularMapType="SpecularMap",Material$3._materialCache.addMaterial(Material$3.SpecularMapType,{fabric:{type:Material$3.SpecularMapType,uniforms:{image:Material$3.DefaultImageId,channel:"r",repeat:new Cartesian2(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),Material$3.EmissionMapType="EmissionMap",Material$3._materialCache.addMaterial(Material$3.EmissionMapType,{fabric:{type:Material$3.EmissionMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$3.BumpMapType="BumpMap",Material$3._materialCache.addMaterial(Material$3.BumpMapType,{fabric:{type:Material$3.BumpMapType,uniforms:{image:Material$3.DefaultImageId,channel:"r",strength:.8,repeat:new Cartesian2(1,1)},source:BumpMapMaterial},translucent:!1}),Material$3.NormalMapType="NormalMap",Material$3._materialCache.addMaterial(Material$3.NormalMapType,{fabric:{type:Material$3.NormalMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",strength:.8,repeat:new Cartesian2(1,1)},source:NormalMapMaterial},translucent:!1}),Material$3.GridType="Grid",Material$3._materialCache.addMaterial(Material$3.GridType,{fabric:{type:Material$3.GridType,uniforms:{color:new Color(0,1,0,1),cellAlpha:.1,lineCount:new Cartesian2(8,8),lineThickness:new Cartesian2(1,1),lineOffset:new Cartesian2(0,0)},source:GridMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.cellAlpha<1}}),Material$3.StripeType="Stripe",Material$3._materialCache.addMaterial(Material$3.StripeType,{fabric:{type:Material$3.StripeType,uniforms:{horizontal:!0,evenColor:new Color(1,1,1,.5),oddColor:new Color(0,0,1,.5),offset:0,repeat:5},source:StripeMaterial},translucent:function(e){e=e.uniforms;return e.evenColor.alpha<1||e.oddColor.alpha<1}}),Material$3.CheckerboardType="Checkerboard",Material$3._materialCache.addMaterial(Material$3.CheckerboardType,{fabric:{type:Material$3.CheckerboardType,uniforms:{lightColor:new Color(1,1,1,.5),darkColor:new Color(0,0,0,.5),repeat:new Cartesian2(5,5)},source:CheckerboardMaterial},translucent:function(e){e=e.uniforms;return e.lightColor.alpha<1||e.darkColor.alpha<1}}),Material$3.DotType="Dot",Material$3._materialCache.addMaterial(Material$3.DotType,{fabric:{type:Material$3.DotType,uniforms:{lightColor:new Color(1,1,0,.75),darkColor:new Color(0,1,1,.75),repeat:new Cartesian2(5,5)},source:DotMaterial},translucent:function(e){e=e.uniforms;return e.lightColor.alpha<1||e.darkColor.alpha<1}}),Material$3.WaterType="Water",Material$3._materialCache.addMaterial(Material$3.WaterType,{fabric:{type:Material$3.WaterType,uniforms:{baseWaterColor:new Color(.2,.3,.6,1),blendColor:new Color(0,1,.699,1),specularMap:Material$3.DefaultImageId,normalMap:Material$3.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:WaterMaterial},translucent:function(e){e=e.uniforms;return e.baseWaterColor.alpha<1||e.blendColor.alpha<1}}),Material$3.RimLightingType="RimLighting",Material$3._materialCache.addMaterial(Material$3.RimLightingType,{fabric:{type:Material$3.RimLightingType,uniforms:{color:new Color(1,0,0,.7),rimColor:new Color(1,1,1,.4),width:.3},source:RimLightingMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.rimColor.alpha<1}}),Material$3.FadeType="Fade",Material$3._materialCache.addMaterial(Material$3.FadeType,{fabric:{type:Material$3.FadeType,uniforms:{fadeInColor:new Color(1,0,0,1),fadeOutColor:new Color(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new Cartesian2(.5,.5)},source:FadeMaterial},translucent:function(e){e=e.uniforms;return e.fadeInColor.alpha<1||e.fadeOutColor.alpha<1}}),Material$3.PolylineArrowType="PolylineArrow",Material$3._materialCache.addMaterial(Material$3.PolylineArrowType,{fabric:{type:Material$3.PolylineArrowType,uniforms:{color:new Color(1,1,1,1)},source:PolylineArrowMaterial},translucent:!0}),Material$3.PolylineDashType="PolylineDash",Material$3._materialCache.addMaterial(Material$3.PolylineDashType,{fabric:{type:Material$3.PolylineDashType,uniforms:{color:new Color(1,0,1,1),gapColor:new Color(0,0,0,0),dashLength:16,dashPattern:255},source:PolylineDashMaterial},translucent:!0}),Material$3.PolylineGlowType="PolylineGlow",Material$3._materialCache.addMaterial(Material$3.PolylineGlowType,{fabric:{type:Material$3.PolylineGlowType,uniforms:{color:new Color(0,.5,1,1),glowPower:.25,taperPower:1},source:PolylineGlowMaterial},translucent:!0}),Material$3.PolylineOutlineType="PolylineOutline",Material$3._materialCache.addMaterial(Material$3.PolylineOutlineType,{fabric:{type:Material$3.PolylineOutlineType,uniforms:{color:new Color(1,1,1,1),outlineColor:new Color(1,0,0,1),outlineWidth:1},source:PolylineOutlineMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.outlineColor.alpha<1}}),Material$3.ElevationContourType="ElevationContour",Material$3._materialCache.addMaterial(Material$3.ElevationContourType,{fabric:{type:Material$3.ElevationContourType,uniforms:{spacing:100,color:new Color(1,0,0,1),width:1},source:ElevationContourMaterial},translucent:!1}),Material$3.ElevationRampType="ElevationRamp",Material$3._materialCache.addMaterial(Material$3.ElevationRampType,{fabric:{type:Material$3.ElevationRampType,uniforms:{image:Material$3.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:ElevationRampMaterial},translucent:!1}),Material$3.SlopeRampMaterialType="SlopeRamp",Material$3._materialCache.addMaterial(Material$3.SlopeRampMaterialType,{fabric:{type:Material$3.SlopeRampMaterialType,uniforms:{image:Material$3.DefaultImageId},source:SlopeRampMaterial},translucent:!1}),Material$3.AspectRampMaterialType="AspectRamp",Material$3._materialCache.addMaterial(Material$3.AspectRampMaterialType,{fabric:{type:Material$3.AspectRampMaterialType,uniforms:{image:Material$3.DefaultImageId},source:AspectRampMaterial},translucent:!1}),Material$3.ElevationBandType="ElevationBand",Material$3._materialCache.addMaterial(Material$3.ElevationBandType,{fabric:{type:Material$3.ElevationBandType,uniforms:{heights:Material$3.DefaultImageId,colors:Material$3.DefaultImageId},source:ElevationBandMaterial},translucent:!0}),Object.defineProperties(MaterialAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),MaterialAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,MaterialAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,MaterialAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,MaterialAppearance.MaterialSupport={BASIC:Object.freeze({vertexFormat:VertexFormat.POSITION_AND_NORMAL,vertexShaderSource:BasicMaterialAppearanceVS,fragmentShaderSource:BasicMaterialAppearanceFS}),TEXTURED:Object.freeze({vertexFormat:VertexFormat.POSITION_NORMAL_AND_ST,vertexShaderSource:TexturedMaterialAppearanceVS,fragmentShaderSource:TexturedMaterialAppearanceFS}),ALL:Object.freeze({vertexFormat:VertexFormat.ALL,vertexShaderSource:AllMaterialAppearanceVS,fragmentShaderSource:AllMaterialAppearanceFS})};var PerInstanceColorAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nvec4 color = czm_gammaCorrect(v_color);\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n}\n",PerInstanceColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",PerInstanceFlatColorAppearanceFS="varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = czm_gammaCorrect(v_color);\n}\n",PerInstanceFlatColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nattribute float batchId;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";function PerInstanceColorAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.flat,!1),n=r?PerInstanceFlatColorAppearanceVS:PerInstanceColorAppearanceVS,a=r?PerInstanceFlatColorAppearanceFS:PerInstanceColorAppearanceFS,o=r?PerInstanceColorAppearance.FLAT_VERTEX_FORMAT:PerInstanceColorAppearance.VERTEX_FORMAT;this.material=void 0,this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,n),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,a),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._vertexFormat=o,this._flat=r,this._faceForward=defaultValue(e.faceForward,!i)}function ColorMaterialProperty(e){this._definitionChanged=new Event,this._color=void 0,this._colorSubscription=void 0,this.color=e}function DrawCommand(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._cull=defaultValue(e.cull,!0),this._occlude=defaultValue(e.occlude,!0),this._modelMatrix=e.modelMatrix,this._primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=defaultValue(e.offset,0),this._instanceCount=defaultValue(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._executeInClosestFrustum=defaultValue(e.executeInClosestFrustum,!1),this._owner=e.owner,this._debugShowBoundingVolume=defaultValue(e.debugShowBoundingVolume,!1),this._debugOverlappingFrustums=0,this._castShadows=defaultValue(e.castShadows,!1),this._receiveShadows=defaultValue(e.receiveShadows,!1),this._pickId=e.pickId,this._pickOnly=defaultValue(e.pickOnly,!1),this._depthForTranslucentClassification=defaultValue(e.depthForTranslucentClassification,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}Object.defineProperties(PerInstanceColorAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),PerInstanceColorAppearance.VERTEX_FORMAT=VertexFormat.POSITION_AND_NORMAL,PerInstanceColorAppearance.FLAT_VERTEX_FORMAT=VertexFormat.POSITION_ONLY,PerInstanceColorAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,PerInstanceColorAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,PerInstanceColorAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,Object.defineProperties(ColorMaterialProperty.prototype,{isConstant:{get:function(){return Property.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:createPropertyDescriptor("color")}),ColorMaterialProperty.prototype.getType=function(e){return"Color"},ColorMaterialProperty.prototype.getValue=function(e,t){return(t=!defined(t)?{}:t).color=Property.getValueOrClonedDefault(this._color,e,Color.WHITE,t.color),t},ColorMaterialProperty.prototype.equals=function(e){return this===e||e instanceof ColorMaterialProperty&&Property.equals(this._color,e._color)},Object.defineProperties(DrawCommand.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return this._cull},set:function(e){this._cull!==e&&(this._cull=e,this.dirty=!0)}},occlude:{get:function(){return this._occlude},set:function(e){this._occlude!==e&&(this._occlude=e,this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return this._castShadows},set:function(e){this._castShadows!==e&&(this._castShadows=e,this.dirty=!0)}},receiveShadows:{get:function(){return this._receiveShadows},set:function(e){this._receiveShadows!==e&&(this._receiveShadows=e,this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return this._executeInClosestFrustum},set:function(e){this._executeInClosestFrustum!==e&&(this._executeInClosestFrustum=e,this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return this._debugShowBoundingVolume},set:function(e){this._debugShowBoundingVolume!==e&&(this._debugShowBoundingVolume=e,this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return this._pickOnly},set:function(e){this._pickOnly!==e&&(this._pickOnly=e,this.dirty=!0)}},depthForTranslucentClassification:{get:function(){return this._depthForTranslucentClassification},set:function(e){this._depthForTranslucentClassification!==e&&(this._depthForTranslucentClassification=e,this.dirty=!0)}}}),DrawCommand.shallowClone=function(e,t){if(defined(e))return(t=!defined(t)?new DrawCommand:t)._boundingVolume=e._boundingVolume,t._orientedBoundingBox=e._orientedBoundingBox,t._cull=e._cull,t._occlude=e._occlude,t._modelMatrix=e._modelMatrix,t._primitiveType=e._primitiveType,t._vertexArray=e._vertexArray,t._count=e._count,t._offset=e._offset,t._instanceCount=e._instanceCount,t._shaderProgram=e._shaderProgram,t._uniformMap=e._uniformMap,t._renderState=e._renderState,t._framebuffer=e._framebuffer,t._pass=e._pass,t._executeInClosestFrustum=e._executeInClosestFrustum,t._owner=e._owner,t._debugShowBoundingVolume=e._debugShowBoundingVolume,t._debugOverlappingFrustums=e._debugOverlappingFrustums,t._castShadows=e._castShadows,t._receiveShadows=e._receiveShadows,t._pickId=e._pickId,t._pickOnly=e._pickOnly,t._depthForTranslucentClassification=e._depthForTranslucentClassification,t.dirty=!0,t.lastDirtyTime=0,t},DrawCommand.prototype.execute=function(e,t){e.draw(this,t)};var Pass={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,OPAQUE:7,TRANSLUCENT:8,OVERLAY:9,NUMBER_OF_PASSES:10},Pass$1=Object.freeze(Pass);function freezeRenderState(e){if("object"!=typeof e||null===e)return e;for(var t,i=Object.keys(e),r=0;r<i.length;r++)t=i[r],e.hasOwnProperty(t)&&"_applyFunctions"!==t&&(e[t]=freezeRenderState(e[t]));return Object.freeze(e)}function RenderState(e){var t=defaultValue(e,defaultValue.EMPTY_OBJECT),i=defaultValue(t.cull,defaultValue.EMPTY_OBJECT),r=defaultValue(t.polygonOffset,defaultValue.EMPTY_OBJECT),n=defaultValue(t.scissorTest,defaultValue.EMPTY_OBJECT),a=defaultValue(n.rectangle,defaultValue.EMPTY_OBJECT),o=defaultValue(t.depthRange,defaultValue.EMPTY_OBJECT),s=defaultValue(t.depthTest,defaultValue.EMPTY_OBJECT),l=defaultValue(t.colorMask,defaultValue.EMPTY_OBJECT),c=defaultValue(t.blending,defaultValue.EMPTY_OBJECT),u=defaultValue(c.color,defaultValue.EMPTY_OBJECT),d=defaultValue(t.stencilTest,defaultValue.EMPTY_OBJECT),h=defaultValue(d.frontOperation,defaultValue.EMPTY_OBJECT),p=defaultValue(d.backOperation,defaultValue.EMPTY_OBJECT),f=defaultValue(t.sampleCoverage,defaultValue.EMPTY_OBJECT),e=t.viewport;this.frontFace=defaultValue(t.frontFace,WindingOrder$1.COUNTER_CLOCKWISE),this.cull={enabled:defaultValue(i.enabled,!1),face:defaultValue(i.face,WebGLConstants$1.BACK)},this.lineWidth=defaultValue(t.lineWidth,1),this.polygonOffset={enabled:defaultValue(r.enabled,!1),factor:defaultValue(r.factor,0),units:defaultValue(r.units,0)},this.scissorTest={enabled:defaultValue(n.enabled,!1),rectangle:BoundingRectangle.clone(a)},this.depthRange={near:defaultValue(o.near,0),far:defaultValue(o.far,1)},this.depthTest={enabled:defaultValue(s.enabled,!1),func:defaultValue(s.func,WebGLConstants$1.LESS)},this.colorMask={red:defaultValue(l.red,!0),green:defaultValue(l.green,!0),blue:defaultValue(l.blue,!0),alpha:defaultValue(l.alpha,!0)},this.depthMask=defaultValue(t.depthMask,!0),this.stencilMask=defaultValue(t.stencilMask,-1),this.blending={enabled:defaultValue(c.enabled,!1),color:new Color(defaultValue(u.red,0),defaultValue(u.green,0),defaultValue(u.blue,0),defaultValue(u.alpha,0)),equationRgb:defaultValue(c.equationRgb,WebGLConstants$1.FUNC_ADD),equationAlpha:defaultValue(c.equationAlpha,WebGLConstants$1.FUNC_ADD),functionSourceRgb:defaultValue(c.functionSourceRgb,WebGLConstants$1.ONE),functionSourceAlpha:defaultValue(c.functionSourceAlpha,WebGLConstants$1.ONE),functionDestinationRgb:defaultValue(c.functionDestinationRgb,WebGLConstants$1.ZERO),functionDestinationAlpha:defaultValue(c.functionDestinationAlpha,WebGLConstants$1.ZERO)},this.stencilTest={enabled:defaultValue(d.enabled,!1),frontFunction:defaultValue(d.frontFunction,WebGLConstants$1.ALWAYS),backFunction:defaultValue(d.backFunction,WebGLConstants$1.ALWAYS),reference:defaultValue(d.reference,0),mask:defaultValue(d.mask,-1),frontOperation:{fail:defaultValue(h.fail,WebGLConstants$1.KEEP),zFail:defaultValue(h.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(h.zPass,WebGLConstants$1.KEEP)},backOperation:{fail:defaultValue(p.fail,WebGLConstants$1.KEEP),zFail:defaultValue(p.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(p.zPass,WebGLConstants$1.KEEP)}},this.sampleCoverage={enabled:defaultValue(f.enabled,!1),value:defaultValue(f.value,1),invert:defaultValue(f.invert,!1)},this.viewport=defined(e)?new BoundingRectangle(e.x,e.y,e.width,e.height):void 0,this.id=0,this._applyFunctions=[]}var nextRenderStateId=0,renderStateCache={};function enableOrDisable(e,t,i){i?e.enable(t):e.disable(t)}function applyFrontFace(e,t){e.frontFace(t.frontFace)}function applyCull(e,t){var i=t.cull,t=i.enabled;enableOrDisable(e,e.CULL_FACE,t),t&&e.cullFace(i.face)}function applyLineWidth(e,t){e.lineWidth(t.lineWidth)}function applyPolygonOffset(e,t){var i=t.polygonOffset,t=i.enabled;enableOrDisable(e,e.POLYGON_OFFSET_FILL,t),t&&e.polygonOffset(i.factor,i.units)}function applyScissorTest(e,t,i){var r=t.scissorTest,t=(defined(i.scissorTest)?i.scissorTest:r).enabled;enableOrDisable(e,e.SCISSOR_TEST,t),t&&(r=(defined(i.scissorTest)?i.scissorTest:r).rectangle,e.scissor(r.x,r.y,r.width,r.height))}function applyDepthRange(e,t){t=t.depthRange;e.depthRange(t.near,t.far)}function applyDepthTest(e,t){var i=t.depthTest,t=i.enabled;enableOrDisable(e,e.DEPTH_TEST,t),t&&e.depthFunc(i.func)}function applyColorMask(e,t){t=t.colorMask;e.colorMask(t.red,t.green,t.blue,t.alpha)}function applyDepthMask(e,t){e.depthMask(t.depthMask)}function applyStencilMask(e,t){e.stencilMask(t.stencilMask)}function applyBlendingColor(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function applyBlending(e,t,i){t=t.blending,i=defined(i.blendingEnabled)?i.blendingEnabled:t.enabled;enableOrDisable(e,e.BLEND,i),i&&(applyBlendingColor(e,t.color),e.blendEquationSeparate(t.equationRgb,t.equationAlpha),e.blendFuncSeparate(t.functionSourceRgb,t.functionDestinationRgb,t.functionSourceAlpha,t.functionDestinationAlpha))}function applyStencilTest(e,t){var i,r,n=t.stencilTest,a=n.enabled;enableOrDisable(e,e.STENCIL_TEST,a),a&&(r=n.frontFunction,i=n.backFunction,t=n.reference,a=n.mask,e.stencilFunc(r,t,a),e.stencilFuncSeparate(e.BACK,i,t,a),e.stencilFuncSeparate(e.FRONT,r,t,a),t=(r=n.frontOperation).fail,a=r.zFail,r=r.zPass,e.stencilOpSeparate(e.FRONT,t,a,r),r=(a=n.backOperation).fail,n=a.zFail,a=a.zPass,e.stencilOpSeparate(e.BACK,r,n,a))}function applySampleCoverage(e,t){var i=t.sampleCoverage,t=i.enabled;enableOrDisable(e,e.SAMPLE_COVERAGE,t),t&&e.sampleCoverage(i.value,i.invert)}RenderState.fromCache=function(e){var t=JSON.stringify(e),i=renderStateCache[t];if(defined(i))return++i.referenceCount,i.state;var r=new RenderState(e),e=JSON.stringify(r);return defined(i=renderStateCache[e])||(r.id=nextRenderStateId++,renderStateCache[e]=i={referenceCount:0,state:r}),++i.referenceCount,renderStateCache[t]={referenceCount:1,state:i.state},i.state},RenderState.removeFromCache=function(e){var t=new RenderState(e),i=JSON.stringify(t),r=renderStateCache[i],t=JSON.stringify(e),e=renderStateCache[t];defined(e)&&(--e.referenceCount,0===e.referenceCount&&(delete renderStateCache[t],defined(r)&&--r.referenceCount)),defined(r)&&0===r.referenceCount&&delete renderStateCache[i]},RenderState.getCache=function(){return renderStateCache},RenderState.clearCache=function(){renderStateCache={}};var scratchViewport$2=new BoundingRectangle;function applyViewport(e,t,i){t=defaultValue(t.viewport,i.viewport);defined(t)||((t=scratchViewport$2).width=i.context.drawingBufferWidth,t.height=i.context.drawingBufferHeight),i.context.uniformState.viewport=t,e.viewport(t.x,t.y,t.width,t.height)}function createFuncs(e,t){var i=[];return e.frontFace!==t.frontFace&&i.push(applyFrontFace),e.cull.enabled===t.cull.enabled&&e.cull.face===t.cull.face||i.push(applyCull),e.lineWidth!==t.lineWidth&&i.push(applyLineWidth),e.polygonOffset.enabled===t.polygonOffset.enabled&&e.polygonOffset.factor===t.polygonOffset.factor&&e.polygonOffset.units===t.polygonOffset.units||i.push(applyPolygonOffset),e.depthRange.near===t.depthRange.near&&e.depthRange.far===t.depthRange.far||i.push(applyDepthRange),e.depthTest.enabled===t.depthTest.enabled&&e.depthTest.func===t.depthTest.func||i.push(applyDepthTest),e.colorMask.red===t.colorMask.red&&e.colorMask.green===t.colorMask.green&&e.colorMask.blue===t.colorMask.blue&&e.colorMask.alpha===t.colorMask.alpha||i.push(applyColorMask),e.depthMask!==t.depthMask&&i.push(applyDepthMask),e.stencilMask!==t.stencilMask&&i.push(applyStencilMask),e.stencilTest.enabled===t.stencilTest.enabled&&e.stencilTest.frontFunction===t.stencilTest.frontFunction&&e.stencilTest.backFunction===t.stencilTest.backFunction&&e.stencilTest.reference===t.stencilTest.reference&&e.stencilTest.mask===t.stencilTest.mask&&e.stencilTest.frontOperation.fail===t.stencilTest.frontOperation.fail&&e.stencilTest.frontOperation.zFail===t.stencilTest.frontOperation.zFail&&e.stencilTest.backOperation.fail===t.stencilTest.backOperation.fail&&e.stencilTest.backOperation.zFail===t.stencilTest.backOperation.zFail&&e.stencilTest.backOperation.zPass===t.stencilTest.backOperation.zPass||i.push(applyStencilTest),e.sampleCoverage.enabled===t.sampleCoverage.enabled&&e.sampleCoverage.value===t.sampleCoverage.value&&e.sampleCoverage.invert===t.sampleCoverage.invert||i.push(applySampleCoverage),i}RenderState.apply=function(e,t,i){applyFrontFace(e,t),applyCull(e,t),applyLineWidth(e,t),applyPolygonOffset(e,t),applyDepthRange(e,t),applyDepthTest(e,t),applyColorMask(e,t),applyDepthMask(e,t),applyStencilMask(e,t),applyStencilTest(e,t),applySampleCoverage(e,t),applyScissorTest(e,t,i),applyBlending(e,t,i),applyViewport(e,t,i)},RenderState.partialApply=function(e,t,i,r,n,a){if(t!==i){var o=i._applyFunctions[t.id];defined(o)||(o=createFuncs(t,i),i._applyFunctions[t.id]=o);for(var s=o.length,l=0;l<s;++l)o[l](e,i)}(defined(r.scissorTest)?r:t).scissorTest===(defined(n.scissorTest)?n:i).scissorTest&&!a||applyScissorTest(e,i,n);var c=defined(r.blendingEnabled)?r.blendingEnabled:t.blending.enabled,a=defined(n.blendingEnabled)?n.blendingEnabled:i.blending.enabled;(c!==a||a&&t.blending!==i.blending)&&applyBlending(e,i,n),t===i&&r===n&&r.context===n.context||applyViewport(e,i,n)},RenderState.getState=function(e){return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:BoundingRectangle.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:Color.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:defined(e.viewport)?BoundingRectangle.clone(e.viewport):void 0}};var viewerPositionWCScratch=new Cartesian3;function AutomaticUniform(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var datatypeToGlsl={};datatypeToGlsl[WebGLConstants$1.FLOAT]="float",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC2]="vec2",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC3]="vec3",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC4]="vec4",datatypeToGlsl[WebGLConstants$1.INT]="int",datatypeToGlsl[WebGLConstants$1.INT_VEC2]="ivec2",datatypeToGlsl[WebGLConstants$1.INT_VEC3]="ivec3",datatypeToGlsl[WebGLConstants$1.INT_VEC4]="ivec4",datatypeToGlsl[WebGLConstants$1.BOOL]="bool",datatypeToGlsl[WebGLConstants$1.BOOL_VEC2]="bvec2",datatypeToGlsl[WebGLConstants$1.BOOL_VEC3]="bvec3",datatypeToGlsl[WebGLConstants$1.BOOL_VEC4]="bvec4",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT2]="mat2",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT3]="mat3",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT4]="mat4",datatypeToGlsl[WebGLConstants$1.SAMPLER_2D]="sampler2D",datatypeToGlsl[WebGLConstants$1.SAMPLER_CUBE]="samplerCube",AutomaticUniform.prototype.getDeclaration=function(e){var t="uniform "+datatypeToGlsl[this._datatype]+" "+e,e=this._size;return t+=1===e?";":"["+e.toString()+"];"};var AutomaticUniforms={czm_viewport:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.eyeHeight}}),czm_eyeHeight2D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_farDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.farDepthFromNearPlusOne}}),czm_log2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2FarDepthFromNearPlusOne}}),czm_oneOverLog2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.oneOverLog2FarDepthFromNearPlusOne}}),czm_sunPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_lightDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionEC}}),czm_lightDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionWC}}),czm_lightColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColor}}),czm_lightColorHdr:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColorHdr}}),czm_encodedCameraPositionMCHigh:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return Matrix4.getTranslation(e.inverseView,viewerPositionWCScratch)}}),czm_frameNumber:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_pass:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pass}}),czm_backgroundColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.backgroundColor}}),czm_brdfLut:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.brdfLut}}),czm_environmentMap:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_CUBE,getValue:function(e){return e.environmentMap}}),czm_specularEnvironmentMaps:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.specularEnvironmentMaps}}),czm_specularEnvironmentMapSize:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.specularEnvironmentMapsDimensions}}),czm_specularEnvironmentMapsMaximumLOD:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.specularEnvironmentMapsMaximumLOD}}),czm_sphericalHarmonicCoefficients:new AutomaticUniform({size:9,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sphericalHarmonicCoefficients}}),czm_temeToPseudoFixed:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_pixelRatio:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pixelRatio}}),czm_fogDensity:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.fogDensity}}),czm_imagerySplitPosition:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.imagerySplitPosition}}),czm_geometricToleranceOverMeter:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.geometricToleranceOverMeter}}),czm_minimumDisableDepthTestDistance:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.minimumDisableDepthTestDistance}}),czm_invertClassificationColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.invertClassificationColor}}),czm_gamma:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.gamma}}),czm_ellipsoidRadii:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.radii}}),czm_ellipsoidInverseRadii:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.oneOverRadii}})};function createUniform(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformFloat(e,t,i,r);case e.FLOAT_VEC2:return new UniformFloatVec2(e,t,i,r);case e.FLOAT_VEC3:return new UniformFloatVec3(e,t,i,r);case e.FLOAT_VEC4:return new UniformFloatVec4(e,t,i,r);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new UniformSampler(e,t,i,r);case e.INT:case e.BOOL:return new UniformInt(e,t,i,r);case e.INT_VEC2:case e.BOOL_VEC2:return new UniformIntVec2(e,t,i,r);case e.INT_VEC3:case e.BOOL_VEC3:return new UniformIntVec3(e,t,i,r);case e.INT_VEC4:case e.BOOL_VEC4:return new UniformIntVec4(e,t,i,r);case e.FLOAT_MAT2:return new UniformMat2(e,t,i,r);case e.FLOAT_MAT3:return new UniformMat3(e,t,i,r);case e.FLOAT_MAT4:return new UniformMat4(e,t,i,r);default:throw new RuntimeError("Unrecognized uniform type: "+t.type+' for uniform "'+i+'".')}}function UniformFloat(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformFloatVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformFloatVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformFloatVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformSampler(e,t,i,r){this.name=i,this.value=void 0,this._gl=e,this._location=r,this.textureUnitIndex=void 0}function UniformInt(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformIntVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformIntVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian3,this._gl=e,this._location=r}function UniformIntVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian4,this._gl=e,this._location=r}UniformFloat.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))},UniformFloatVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2f(this._location,e.x,e.y))},UniformFloatVec3.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue)):defined(e.x)&&(Cartesian3.equals(e,this._value)||(this._value=Cartesian3.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z)))},UniformFloatVec4.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha)):defined(e.x)&&(Cartesian4.equals(e,this._value)||(this._value=Cartesian4.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w)))},UniformSampler.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var t=this.value;e.bindTexture(t._target,t._texture)},UniformSampler.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1},UniformInt.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))},UniformIntVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2i(this._location,e.x,e.y))},UniformIntVec3.prototype.set=function(){var e=this.value;Cartesian3.equals(e,this._value)||(Cartesian3.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))},UniformIntVec4.prototype.set=function(){var e=this.value;Cartesian4.equals(e,this._value)||(Cartesian4.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))};var scratchUniformArray$1=new Float32Array(4);function UniformMat2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix2,this._gl=e,this._location=r}UniformMat2.prototype.set=function(){var e;Matrix2.equalsArray(this.value,this._value,0)||(Matrix2.clone(this.value,this._value),e=Matrix2.toArray(this.value,scratchUniformArray$1),this._gl.uniformMatrix2fv(this._location,!1,e))};var scratchMat3Array=new Float32Array(9);function UniformMat3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix3,this._gl=e,this._location=r}UniformMat3.prototype.set=function(){var e;Matrix3.equalsArray(this.value,this._value,0)||(Matrix3.clone(this.value,this._value),e=Matrix3.toArray(this.value,scratchMat3Array),this._gl.uniformMatrix3fv(this._location,!1,e))};var scratchMat4Array=new Float32Array(16);function UniformMat4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix4,this._gl=e,this._location=r}function createUniformArray(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformArrayFloat(e,t,i,r);case e.FLOAT_VEC2:return new Un