"""OKU URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from django.urls.conf import include
from django.conf import settings
from django.conf.urls.static import static
from myauth import views


urlpatterns = [
    path('', include('Application.urls')),
    path('api/', include('API.urls')),
    path('admin/', admin.site.urls),
    # path('myauth/', include('myauth.urls')),
    path('login/', views.CustomLoginView.as_view(), name='login'),
    path('logout/', views.CustomLogoutView.as_view(), name='logout'),
    path('usermanagement/', views.Usermanagement.as_view(), name='usermanagement'),
    path('adduser/', views.addUser, name="adduser"),
    path('getallGroups/', views.listGroup, name="getallGroups"),
    path('switchStatus/', views.deactivateUser, name="switchStatus"),
    path('loadUserbyId/', views.loadUserbyId, name="loadUserbyId"),
    path('addGroup/', views.addGroup, name="addGroup"),
    path('deleteGroup/', views.deleteGroup, name="deleteGroup"),
    path('getGroupById/', views.loadGroupByGroupId, name='getGroupById')
]+ static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
