/*
 Navicat Premium Data Transfer

 Source Server         : localhost_5432
 Source Server Type    : PostgreSQL
 Source Server Version : 110005
 Source Host           : localhost:5432
 Source Catalog        : Test1
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 110005
 File Encoding         : 65001

 Date: 22/09/2020 11:03:43
*/


-- ----------------------------
-- Sequence structure for antrian_id_antrian
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."antrian_id_antrian";
CREATE SEQUENCE "public"."antrian_id_antrian" 
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for dokter\_id_dokter_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."dokter\_id_dokter_seq";
CREATE SEQUENCE "public"."dokter\_id_dokter_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 32767
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for id_antrian_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."id_antrian_seq";
CREATE SEQUENCE "public"."id_antrian_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for id_antrian_seq2
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."id_antrian_seq2";
CREATE SEQUENCE "public"."id_antrian_seq2" 
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for pasien_id_pasien_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."pasien_id_pasien_seq";
CREATE SEQUENCE "public"."pasien_id_pasien_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for poli_id_poli_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."poli_id_poli_seq";
CREATE SEQUENCE "public"."poli_id_poli_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 32767
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for register_antrian_id_register
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."register_antrian_id_register";
CREATE SEQUENCE "public"."register_antrian_id_register" 
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for user_data_header_iduser_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."user_data_header_iduser_seq";
CREATE SEQUENCE "public"."user_data_header_iduser_seq" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for user_data_header_iduser_seq1
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."user_data_header_iduser_seq1";
CREATE SEQUENCE "public"."user_data_header_iduser_seq1" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for user_data_header_iduser_seq2
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."user_data_header_iduser_seq2";
CREATE SEQUENCE "public"."user_data_header_iduser_seq2" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;

-- ----------------------------
-- Sequence structure for user_data_header_iduser_seq3
-- ----------------------------
DROP SEQUENCE IF EXISTS "public"."user_data_header_iduser_seq3";
CREATE SEQUENCE "public"."user_data_header_iduser_seq3" 
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
CACHE 1;

-- ----------------------------
-- Table structure for antrian
-- ----------------------------
DROP TABLE IF EXISTS "public"."antrian";
CREATE TABLE "public"."antrian" (
  "id_antrian" int2 DEFAULT nextval('antrian_id_antrian'::regclass),
  "no_antrian" int2,
  "kode_antrian" int2,
  "create_date" date
)
;

-- ----------------------------
-- Table structure for antrian_pasien
-- ----------------------------
DROP TABLE IF EXISTS "public"."antrian_pasien";
CREATE TABLE "public"."antrian_pasien" (
  "id_pasien" int2,
  "no_antrian" int2,
  "create_date" date,
  "nama" varchar(150) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "tempat_lahir" varchar(100) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "tanggal_lahir" varchar COLLATE "pg_catalog"."default",
  "alamat" varchar(150) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "no_hp" varchar(50) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "id_poli" int2,
  "id_dokter" int2,
  "ktp" varchar(16) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "kode_antrian" varchar(255) COLLATE "pg_catalog"."default",
  "id_register" int2,
  "id_antrian" int2 NOT NULL DEFAULT nextval('id_antrian_seq2'::regclass),
  "status_code" int2,
  "id_ruang" int2,
  "waktu" time(6)
)
;

-- ----------------------------
-- Table structure for condition
-- ----------------------------
DROP TABLE IF EXISTS "public"."condition";
CREATE TABLE "public"."condition" (
  "id_condition" int2 NOT NULL,
  "condition" varchar(255) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for counter_status
-- ----------------------------
DROP TABLE IF EXISTS "public"."counter_status";
CREATE TABLE "public"."counter_status" (
  "id_status" int2 NOT NULL,
  "status_code" int2,
  "status_name" varchar(255) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for divisi_witel
-- ----------------------------
DROP TABLE IF EXISTS "public"."divisi_witel";
CREATE TABLE "public"."divisi_witel" (
  "divisi_witel_id" varchar(3) COLLATE "pg_catalog"."default" NOT NULL,
  "divisi_witel_name" varchar(32) COLLATE "pg_catalog"."default",
  "id_dmaco" int4,
  "witel_imon" varchar(100) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for dokter
-- ----------------------------
DROP TABLE IF EXISTS "public"."dokter";
CREATE TABLE "public"."dokter" (
  "id_dokter" int2 NOT NULL DEFAULT nextval('"dokter\_id_dokter_seq"'::regclass),
  "nama_dokter" varchar(30) COLLATE "pg_catalog"."default",
  "id_poli" int2,
  "id_condition" int2,
  "kode_dokter" varchar(255) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for master_parameter
-- ----------------------------
DROP TABLE IF EXISTS "public"."master_parameter";
CREATE TABLE "public"."master_parameter" (
  "idm_parameter" int4 NOT NULL,
  "param_type" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "param_val1" varchar(500) COLLATE "pg_catalog"."default",
  "param_val2" varchar(500) COLLATE "pg_catalog"."default",
  "param_val3" varchar(500) COLLATE "pg_catalog"."default",
  "param_desc" varchar(1000) COLLATE "pg_catalog"."default",
  "param_parent" int4
)
;
COMMENT ON TABLE "public"."master_parameter" IS 'master parameter';

-- ----------------------------
-- Table structure for pasien
-- ----------------------------
DROP TABLE IF EXISTS "public"."pasien";
CREATE TABLE "public"."pasien" (
  "id_pasien" int2,
  "nama" varchar(255) COLLATE "pg_catalog"."default",
  "tempat_lahir" varchar(255) COLLATE "pg_catalog"."default",
  "tanggal_lahir" varchar(255) COLLATE "pg_catalog"."default",
  "alamat" varchar(255) COLLATE "pg_catalog"."default",
  "no_hp" varchar(255) COLLATE "pg_catalog"."default",
  "ktp" varchar(255) COLLATE "pg_catalog"."default",
  "create_date" date
)
;

-- ----------------------------
-- Table structure for poli
-- ----------------------------
DROP TABLE IF EXISTS "public"."poli";
CREATE TABLE "public"."poli" (
  "id_poli" int2 NOT NULL DEFAULT nextval('poli_id_poli_seq'::regclass),
  "nama_poli" varchar(255) COLLATE "pg_catalog"."default",
  "kode_poli" varchar(5) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for regional
-- ----------------------------
DROP TABLE IF EXISTS "public"."regional";
CREATE TABLE "public"."regional" (
  "id_regional" int4 NOT NULL,
  "regional_name" varchar(30) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for register_antrian
-- ----------------------------
DROP TABLE IF EXISTS "public"."register_antrian";
CREATE TABLE "public"."register_antrian" (
  "id_register" int2 DEFAULT nextval('register_antrian_id_register'::regclass),
  "antrian_all" int2,
  "antrian_awal" int2,
  "antrian_akhir" int2,
  "create_date" date,
  "jam_mulai" varchar(6) COLLATE "pg_catalog"."default",
  "waktu_antrian" varchar(6) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for register_dokter
-- ----------------------------
DROP TABLE IF EXISTS "public"."register_dokter";
CREATE TABLE "public"."register_dokter" (
  "id_register" int2 DEFAULT nextval('id_antrian_seq'::regclass),
  "id_poli" int2,
  "id_dokter" int2,
  "id_ruang" int2,
  "antrian_all" int2,
  "antrian_awal" int2,
  "antrian_akhir" int2,
  "create_date" date,
  "id_condition" int2,
  "jam_mulai" varchar(6) COLLATE "pg_catalog"."default",
  "waktu_antrian" varchar(6) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for ruang
-- ----------------------------
DROP TABLE IF EXISTS "public"."ruang";
CREATE TABLE "public"."ruang" (
  "id_ruang" int2 NOT NULL,
  "nama_ruang" varchar(255) COLLATE "pg_catalog"."default",
  "id_poli" int2,
  "id_condition" int2
)
;

-- ----------------------------
-- Table structure for user_data_access
-- ----------------------------
DROP TABLE IF EXISTS "public"."user_data_access";
CREATE TABLE "public"."user_data_access" (
  "access_id" int4 NOT NULL,
  "access_name" varchar(50) COLLATE "pg_catalog"."default",
  "access_type" varchar(255) COLLATE "pg_catalog"."default",
  "access_code" numeric(10),
  "access_desc" varchar(100) COLLATE "pg_catalog"."default",
  "access_action" varchar(100) COLLATE "pg_catalog"."default",
  "access_controller" varchar(100) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."user_data_access"."access_action" IS 'NAMA FUNGSI PHP';
COMMENT ON COLUMN "public"."user_data_access"."access_controller" IS 'NAMA CONTROLLERNYA';

-- ----------------------------
-- Table structure for user_data_header
-- ----------------------------
DROP TABLE IF EXISTS "public"."user_data_header";
CREATE TABLE "public"."user_data_header" (
  "iduser" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY (
INCREMENT 1
MINVALUE  1
MAXVALUE 2147483647
START 1
),
  "username" varchar(100) COLLATE "pg_catalog"."default",
  "password" varchar(100) COLLATE "pg_catalog"."default",
  "name" varchar(100) COLLATE "pg_catalog"."default",
  "role" int4,
  "status" int4,
  "deviceid" varchar(255) COLLATE "pg_catalog"."default",
  "accessToken" varchar(255) COLLATE "pg_catalog"."default",
  "create_dtm" timestamp(6),
  "retries" varchar(10) COLLATE "pg_catalog"."default",
  "update_date" timestamp(6),
  "email" varchar(50) COLLATE "pg_catalog"."default",
  "authKey" varchar(255) COLLATE "pg_catalog"."default",
  "nik" varchar(100) COLLATE "pg_catalog"."default",
  "lokasi_p" varchar(100) COLLATE "pg_catalog"."default",
  "domain_p" varchar(100) COLLATE "pg_catalog"."default",
  "regional_id" int2,
  "witel_id" varchar(50) COLLATE "pg_catalog"."default",
  "last_update" timestamp(6)
)
;
COMMENT ON COLUMN "public"."user_data_header"."role" IS 'RELATION WITH TB: USER_DATA_ROLE';
COMMENT ON COLUMN "public"."user_data_header"."status" IS 'SET STATUS USER: ';

-- ----------------------------
-- Table structure for user_data_map
-- ----------------------------
DROP TABLE IF EXISTS "public"."user_data_map";
CREATE TABLE "public"."user_data_map" (
  "map_id" int4 NOT NULL,
  "access_code" int4,
  "role_code" int4,
  "access_status" varchar(255) COLLATE "pg_catalog"."default",
  "last_update" timestamp(6)
)
;

-- ----------------------------
-- Table structure for user_data_role
-- ----------------------------
DROP TABLE IF EXISTS "public"."user_data_role";
CREATE TABLE "public"."user_data_role" (
  "access_role_id" int4 NOT NULL,
  "name" varchar(50) COLLATE "pg_catalog"."default",
  "access_role_code" int4,
  "description" varchar(50) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for user_data_session
-- ----------------------------
DROP TABLE IF EXISTS "public"."user_data_session";
CREATE TABLE "public"."user_data_session" (
  "session_id" varchar(500) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(200) COLLATE "pg_catalog"."default",
  "modified" numeric(20),
  "lifetime" numeric(20),
  "data" varchar(4000) COLLATE "pg_catalog"."default",
  "owner" varchar(200) COLLATE "pg_catalog"."default"
)
;

-- ----------------------------
-- Table structure for waktu
-- ----------------------------
DROP TABLE IF EXISTS "public"."waktu";
CREATE TABLE "public"."waktu" (
  "id_waktu" int4 NOT NULL,
  "start_time" time(6),
  "end_time" time(6)
)
;

-- ----------------------------
-- Function structure for get_antrian_self
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."get_antrian_self"();
CREATE OR REPLACE FUNCTION "public"."get_antrian_self"()
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   antrian_count integer;
begin

SELECT antrian.no_antrian
 into antrian_count FROM antrian 
INNER JOIN pasien 
ON antrian.id_pasien = pasien.id_pasien
WHERE pasien.create_date= CURRENT_DATE AND pasien.kode_antrian ='1' ORDER BY no_antrian DESC;

   
   return antrian_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Function structure for get_antriann
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."get_antriann"("kode_antrian" int4);
CREATE OR REPLACE FUNCTION "public"."get_antriann"("kode_antrian" int4)
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   antrian_count integer;
begin

	INSERT INTO antrian(no_antrian,kode_antrian) VALUES ($1, $2);

   select count(*) 
   into antrian_count
   from antrian;
   
   return antrian_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Function structure for get_film_count
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."get_film_count"("len_from" int4, "len_to" int4);
CREATE OR REPLACE FUNCTION "public"."get_film_count"("len_from" int4, "len_to" int4)
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   film_count integer;
begin
   select count(*) 
   into film_count
   from film
   where length between len_from and len_to;
   
   return film_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Function structure for get_no_mobile
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."get_no_mobile"();
CREATE OR REPLACE FUNCTION "public"."get_no_mobile"()
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   antrian_count integer;
begin

SELECT count(antrian.no_antrian)
 into antrian_count FROM antrian 
INNER JOIN pasien 
ON antrian.id_pasien = pasien.id_pasien
WHERE pasien.create_date= CURRENT_DATE AND pasien.kode_antrian ='2' ;

   
   return antrian_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Function structure for get_no_web
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."get_no_web"();
CREATE OR REPLACE FUNCTION "public"."get_no_web"()
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   antrian_count integer;
begin

SELECT count(antrian.no_antrian)
 into antrian_count FROM antrian 
INNER JOIN pasien 
ON antrian.id_pasien = pasien.id_pasien
WHERE pasien.create_date= CURRENT_DATE AND pasien.kode_antrian ='1' ;

   
   return antrian_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Function structure for insert_data
-- ----------------------------
DROP FUNCTION IF EXISTS "public"."insert_data"("input_id_pasien" int4, "input_id_poli" int4);
CREATE OR REPLACE FUNCTION "public"."insert_data"("input_id_pasien" int4, "input_id_poli" int4)
  RETURNS "pg_catalog"."int4" AS $BODY$
declare
   antrian_count integer;
	 input_id_pasien INTEGER ;
	 input_id_poli INTEGER;
	 
begin

SELECT no_antrian into antrian_count FROM antrian WHERE "id_poli" = input_id_poli AND "id_pasien" IS NULL LIMIT 1 ;

UPDATE antrian SET id_pasien=input_id_pasien , kode_antrian='1' WHERE no_antrian=antrian_count AND id_poli=input_id_poli ;

   
   return antrian_count;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."antrian_id_antrian"
OWNED BY "public"."antrian"."id_antrian";
SELECT setval('"public"."antrian_id_antrian"', 1726, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."dokter\_id_dokter_seq"
OWNED BY "public"."dokter"."id_dokter";
SELECT setval('"public"."dokter\_id_dokter_seq"', 13, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."id_antrian_seq"
OWNED BY "public"."register_dokter"."id_register";
SELECT setval('"public"."id_antrian_seq"', 211, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."id_antrian_seq2"
OWNED BY "public"."antrian_pasien"."id_antrian";
SELECT setval('"public"."id_antrian_seq2"', 1726, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."pasien_id_pasien_seq"
OWNED BY "public"."antrian_pasien"."id_pasien";
SELECT setval('"public"."pasien_id_pasien_seq"', 33, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."poli_id_poli_seq"
OWNED BY "public"."poli"."id_poli";
SELECT setval('"public"."poli_id_poli_seq"', 4, false);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."register_antrian_id_register"
OWNED BY "public"."register_antrian"."id_register";
SELECT setval('"public"."register_antrian_id_register"', 206, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."user_data_header_iduser_seq"
OWNED BY "public"."user_data_header"."iduser";
SELECT setval('"public"."user_data_header_iduser_seq"', 13, true);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."user_data_header_iduser_seq1"
OWNED BY "public"."user_data_header"."iduser";
SELECT setval('"public"."user_data_header_iduser_seq1"', 4, false);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."user_data_header_iduser_seq2"
OWNED BY "public"."user_data_header"."iduser";
SELECT setval('"public"."user_data_header_iduser_seq2"', 3, false);

-- ----------------------------
-- Alter sequences owned by
-- ----------------------------
ALTER SEQUENCE "public"."user_data_header_iduser_seq3"
OWNED BY "public"."user_data_header"."iduser";
SELECT setval('"public"."user_data_header_iduser_seq3"', 2, false);

-- ----------------------------
-- Primary Key structure for table condition
-- ----------------------------
ALTER TABLE "public"."condition" ADD CONSTRAINT "condition_pkey" PRIMARY KEY ("id_condition");

-- ----------------------------
-- Primary Key structure for table counter_status
-- ----------------------------
ALTER TABLE "public"."counter_status" ADD CONSTRAINT "counter_status_pkey" PRIMARY KEY ("id_status");

-- ----------------------------
-- Indexes structure for table divisi_witel
-- ----------------------------
CREATE INDEX "idx_divisi_witel" ON "public"."divisi_witel" USING btree (
  "divisi_witel_id" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table divisi_witel
-- ----------------------------
ALTER TABLE "public"."divisi_witel" ADD CONSTRAINT "divisi_witel_pkey" PRIMARY KEY ("divisi_witel_id");

-- ----------------------------
-- Primary Key structure for table dokter
-- ----------------------------
ALTER TABLE "public"."dokter" ADD CONSTRAINT "dokter\_pkey" PRIMARY KEY ("id_dokter");

-- ----------------------------
-- Foreign Keys structure for table dokter
-- ----------------------------
ALTER TABLE "public"."dokter" ADD CONSTRAINT "dokter to poli" FOREIGN KEY ("id_poli") REFERENCES "public"."poli" ("id_poli") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Indexes structure for table master_parameter
-- ----------------------------
CREATE INDEX "index2" ON "public"."master_parameter" USING btree (
  "idm_parameter" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "index3" ON "public"."master_parameter" USING btree (
  "param_type" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "index4" ON "public"."master_parameter" USING btree (
  "param_val1" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "index5" ON "public"."master_parameter" USING btree (
  "param_val2" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "index6" ON "public"."master_parameter" USING btree (
  "param_val3" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "index7" ON "public"."master_parameter" USING btree (
  "param_parent" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table master_parameter
-- ----------------------------
ALTER TABLE "public"."master_parameter" ADD CONSTRAINT "master_parameter_pkey" PRIMARY KEY ("idm_parameter");

-- ----------------------------
-- Foreign Keys structure for table master_parameter
-- ----------------------------
ALTER TABLE "public"."master_parameter" ADD CONSTRAINT "master_parameter_ibfk_1" FOREIGN KEY ("param_parent") REFERENCES "public"."master_parameter" ("idm_parameter") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Primary Key structure for table poli
-- ----------------------------
ALTER TABLE "public"."poli" ADD CONSTRAINT "poli_pkey" PRIMARY KEY ("id_poli");

-- ----------------------------
-- Primary Key structure for table regional
-- ----------------------------
ALTER TABLE "public"."regional" ADD CONSTRAINT "regional_pkey" PRIMARY KEY ("id_regional");

-- ----------------------------
-- Primary Key structure for table ruang
-- ----------------------------
ALTER TABLE "public"."ruang" ADD CONSTRAINT "ruang_pkey" PRIMARY KEY ("id_ruang");

-- ----------------------------
-- Primary Key structure for table user_data_access
-- ----------------------------
ALTER TABLE "public"."user_data_access" ADD CONSTRAINT "user_data_access_pkey" PRIMARY KEY ("access_id");

-- ----------------------------
-- Indexes structure for table user_data_header
-- ----------------------------
CREATE INDEX "xiduser" ON "public"."user_data_header" USING btree (
  "iduser" "pg_catalog"."int4_ops" ASC NULLS LAST
);
CREATE INDEX "xrole" ON "public"."user_data_header" USING btree (
  "role" "pg_catalog"."int4_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table user_data_header
-- ----------------------------
ALTER TABLE "public"."user_data_header" ADD CONSTRAINT "user_data_header_pkey" PRIMARY KEY ("iduser");

-- ----------------------------
-- Primary Key structure for table user_data_map
-- ----------------------------
ALTER TABLE "public"."user_data_map" ADD CONSTRAINT "user_data_map_pkey" PRIMARY KEY ("map_id");

-- ----------------------------
-- Primary Key structure for table user_data_role
-- ----------------------------
ALTER TABLE "public"."user_data_role" ADD CONSTRAINT "user_data_role_pkey" PRIMARY KEY ("access_role_id");

-- ----------------------------
-- Primary Key structure for table user_data_session
-- ----------------------------
ALTER TABLE "public"."user_data_session" ADD CONSTRAINT "user_data_session_pkey" PRIMARY KEY ("session_id");

-- ----------------------------
-- Primary Key structure for table waktu
-- ----------------------------
ALTER TABLE "public"."waktu" ADD CONSTRAINT "waktu_pkey" PRIMARY KEY ("id_waktu");
