<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Application\Master;
use Zend\View\Model\ViewModel;
use Khansia\Generic\Result;

class ApiController extends \Application\Master\GlobalActionController {

    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }
    
    public function loginAction(){

        $this->loadUseri();
        
        // generate token if valid user
        $payload = ['email' => 'danirsdan@gmail.com', 'name' => 'dani'];

        //print_r($payload);die;
        $this->apiResponse['token'] = $this->generateJwtToken($payload);

        $this->apiResponse['message'] = 'Logged in successfully.';
        return $this->createResponse();
    }
	
	public function testAction(){
        $result     = new Result();
        $data       = $this->getData();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Test\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Test($storage);

        $getDataRes = $test->getDataTest();

        $payload    = $this->tokenPayload;

        $result->guid = $this->generateJwtToken($payload);
        $result->code = $result::CODE_SUCCESS;
        $result->info = $result::INFO_SUCCESS;
        $result->data = $payload;

        return $this->getOutput($result->toJson());
    }

	public function savedataAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
                
            $table_pasien= 'pasien';

			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
                
                
				try{
                    $nama    = $post->inama;
                    $tempat_lahir = $post->itempat_lahir;
                    $tanggal_lahir = $post->itanggal_lahir;
                    $alamat = $post->ialamat;
                    $no_hp = $post->ino_hp;
                    $poli = $post->ipoli;
                    $dokter = $post->idokter;
                    $ktp = $post->iktp;
                    $no_antrian = $post->ino_antrian;
                    
                  
                    $counter= $param->getMaxCounter();
                    // print_r($counter);die;

                     $dataArrayAntrianPasien =  array (
                        'id_pasien'     => $counter->data,
                        'create_date'    => gmdate("Y-m-d H:i:s", time()+60*60*7),
                        'nama'          => $nama,
                        'tempat_lahir'  => $tempat_lahir,
                        'tanggal_lahir' => $tanggal_lahir,
                        'alamat'        => $alamat,
                        'no_hp'         => $no_hp,
                        'ktp'           => $ktp,
                        'status_code'   => 10,
                    );
                     $dataArrayPasien =  array (
                     
                        'create_date'    => gmdate("Y-m-d H:i:s", time()+60*60*7),
                        'nama'          => $nama,
                        'tempat_lahir'  => $tempat_lahir,
                        'tanggal_lahir' => $tanggal_lahir,
                        'alamat'        => $alamat,
                        'no_hp'         => $no_hp,
                        'ktp'           => $ktp,
                       
                    );

                   
                 
                    $table_antrianpasien       = 'antrian_pasien'; 
                    $where                     = 'id_dokter='.$dokter.' and no_antrian='.$no_antrian;
                    // print_r ();die;
                     $param->updateGlobal($table_antrianpasien, $dataArrayAntrianPasien , $where);
              
                    $param->saveGlobal( $dataArrayPasien, $table_pasien);
                    
                   
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $dataArrayAntrianPasien;
                           
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    
    public function saveregisterAction(){
        $result 	= new Result();
        $request 	= $this->getRequest();
        $post 		= $request->getPost();
        
        $tb_register_antrian     ='register_antrian';
        $tb_register_dokter      ='register_dokter';
        $tb_dokter               ='dokter';
        $tb_ruang                ='ruang';   
        $tb_antrian              ='antrian';
        $tb_antrian_pasien       ='antrian_pasien';

  
        if ($request->isPost()) {

            
            $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            $param    	= new \Application\Model\Param($storage);
            $db     = $this->getDb();
            $conn     = $db->getDriver()->getConnection();
            $conn->beginTransaction();
    
            /* generate counter number */
            $counter = $param->getMaxCounter();

            try{
                $ruang    = $post->iruang;
                $poli = $post->ipoli;
                $dokter = $post->idokter;
                $antrian_all = $post->iantrian_all;
                $antrian_awal = $post->iantrian_awal;
                $antrian_akhir = $post->iantrian_akhir;
                $waktu_antrian = $post->iwaktu_antrian;
                $jam_mulai = $post->ijam_mulai;


                $array = array();
             
                $seqBefore1     = $param->getLastSeqPostgree($tb_register_dokter ,'id_register');

             
                 $dataArrayRegisterDokter=  array (
                    'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                    'id_ruang'    => $ruang,
                    'id_poli'     => $poli,
                    'id_dokter'  => $dokter,
                    'antrian_all'       => $antrian_all,
                    'antrian_awal'    => $antrian_awal,
                    'antrian_akhir'    => $antrian_akhir,
                    'waktu_antrian'    => $waktu_antrian,
                    'id_condition'     =>1,
                    'jam_mulai' => $jam_mulai,

                 );

                 
                 $dataArrayRegisterAntrian=  array (
                    'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                    'antrian_all'       => $antrian_all,
                    'antrian_awal'    => $antrian_awal,
                    'antrian_akhir'    => $antrian_akhir,
                    'waktu_antrian'    => $waktu_antrian,
                    'jam_mulai' => $jam_mulai,
                 );
                 
                 $dataArrayDokter = array(
                     'id_condition' => 2,
                 );

                 $dataArrayRuang = array(
                    'id_condition' => 2,
                );


                 if($dokter){
                   $array_merge = array_merge($dataArrayDokter, array('id_dokter=' => $dokter));
                 
                   $where = 'id_dokter='.$dokter;
                   $x           = $param->updateGlobal($tb_dokter, $dataArrayDokter, $where);
                    

                   $result->code = $result::CODE_SUCCESS; // code 0
                   $result->info = $result::INFO_SUCCESS;
                   $result->data = $dokter;
                 }

                 if($ruang){
                    $array_merge = array_merge($dataArrayDokter, array('id_ruang=' => $ruang));
                  
                    $where = 'id_ruang='.$ruang;
                    $x           = $param->updateGlobal($tb_ruang, $dataArrayRuang, $where);
                     

                    $result->code = $result::CODE_SUCCESS; // code 0
                    $result->info = $result::INFO_SUCCESS;
                    $result->data = $ruang;
                  }

                 $param->saveGlobal($dataArrayRegisterDokter, $tb_register_dokter);
                 $param->saveGlobal($dataArrayRegisterAntrian, $tb_register_antrian);
                
                 $seqAfter1     = $param->getLastSeqPostgree($tb_register_dokter, 'id_register');

        
                 if($seqAfter1->data['total']  > $seqBefore1->data['total']){

                    $seqBefore2 = $param->getLastSeqPostgree($tb_antrian_pasien,'id_antrian');
                    //untuk load data id register di table antrian register lalu menambahkan pada table pasien
                    for ($no_web=1; $no_web <= $antrian_all;){
                    
                  
                        if($no_web == $antrian_awal){
                            for ($no_mob=$antrian_awal; $no_mob <= $antrian_akhir;){
                                
                                $dataArrayAntrianPasien =  array (
                                    'id_register' => $seqAfter1->data['total'],
                                    'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                                    'no_antrian'    => $no_mob,
                                    'id_poli'       => $poli,
                                    'kode_antrian' => 2,
                                    'id_dokter'    => $dokter,
                                    'id_ruang'    => $ruang,

                                    
                                );

                                
                                $dataArrayAntrian =  array (
                                    'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                                    'no_antrian'    => $no_mob,
                                    'kode_antrian' => 2,
                                    
                                );

                    
                            
                                $param->saveGlobal($dataArrayAntrianPasien, $tb_antrian_pasien);
                                $param->saveGlobal($dataArrayAntrian, $tb_antrian);
                                $no_mob++;
                            }
                            $no_web=$antrian_akhir;
                        }else{
                            $dataArrayAntrianPasien =  array (
                                'id_register' => $seqAfter1->data['total'],
                                'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                                'no_antrian'    => $no_web,
                                'id_poli'       => $poli,
                                'kode_antrian' => 1,
                                'id_dokter'    => $dokter,
                                'id_ruang'    => $ruang,
                                       
                                );
                                
                                $dataArrayAntrian =  array (
                                    'create_date'   => gmdate("Y-m-d H:i:s", time()+60*60*7),
                                    'no_antrian'    => $no_web,
                                    'kode_antrian' => 1,
                                    
                                );

                                $param->saveGlobal($dataArrayAntrianPasien, $tb_antrian_pasien);
                                $param->saveGlobal($dataArrayAntrian, $tb_antrian);
                        }
                        $no_web++;
                        
                    } 

                    $seqAfter2 = $param->getLastSeqPostgree($tb_antrian_pasien, 'id_antrian');

                    if($seqAfter2->data['total'] > $seqBefore2->data['total']){
                            array_push($array ,  array('info'=>'sukses', 'id_antrian'=> $seqAfter1->data));
                    }else{
                        $conn->rollback();
                        array_push($array ,  array('info'=>'gagal antrian pasien'));
                    
                    }

                 }else{
                     $conn->rollback();
                     array_push($array ,  array('info'=>'gagal register dokter'));
                 }
                
               
                 //print_r($array);die;
                if('sukses' == $array[0]['info']) {
                    $conn->commit();
                    $result->code = 0;
                    $result->info = 'ok';
                    $result->data = array(
                        'id_register'=> $array[0]['id_antrian']['total'],
                        
                        
                    );
                }else{
                    $result->code = 1;
                    $result->info = 'gagal total';
                }
               // echo '<pre>';
              //print_r($result->data['id_re']['ui']['k'] );die;
            

                    // if($seqAfter1->data['total'] > $seqBefore1->data['total']){
                    //     $result->code = $result::CODE_SUCCESS; // code 0
                    //     $result->info = $result::INFO_SUCCESS;
                    //     $result->data = $seqAfter1->data['total'];
                    // }else{
                    //     $result->code = 1; 
                    //     $result->info = 'Gagal insert';
                    // }

            }catch (\Exception $exc) {
                $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
            }
        
    }
    return $this->getOutput($result->toJson());
}

    public function loadantrianregisterAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        $load       = $test->loadRegister($post->id);
        
        
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function editdataregisterAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
 
            $tb_dokter               ='dokter';
            $tb_ruang                ='ruang';             


			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
             
				try{
                    $id_register = $post->id;
                    $antrian_all = $post->iantrial_all;
                    $antrian_awal = $post->iantrian_awal;
                    $antrian_akhir = $post->iantrian_akhir;
                    $waktu_antrian = $post->iwaktu_antrian;
                    $jam_mulai = $post->ijam_mulai;
                    
  
                    $dataArrayRegister =  array (
                        
                        'id_poli'       =>$poli,
                        'id_dokter'     =>$dokter,
                        'id_ruang'      =>$ruang,
                        'antrian_all'   =>$antrian_all,
                        'antrian_awal'  =>$antrian_awal,
                        'antrian_akhir' =>$antrian_akhir,
                        'waktu_antrian' =>$waktu_antrian,
                        'jam_mulai'   =>$jam_mulai,
                        
                      
                    );

                    //         $dataArrayDokter = array(
                    //             'id_condition' => 2,
                    //         );
        
                    //         $dataArrayRuang = array(
                    //         'id_condition' => 2,
                    //     );
        
        
                    //         if($dokter){      
                    //         $where = 'id_dokter='.$dokter;
                    //         $x           = $param->updateGlobal($tb_dokter, $dataArrayDokter, $where);
                            
        
                    //         $result->code = $result::CODE_SUCCESS; // code 0
                    //         $result->info = $result::INFO_SUCCESS;
                    //         $result->data = $dokter;
                    //         }
        
                    //         if($ruang){
                    //         $where = 'id_ruang='.$ruang;
                    //         $x           = $param->updateGlobal($tb_ruang, $dataArrayRuang, $where);
                                
        
                    //         $result->code = $result::CODE_SUCCESS; // code 0
                    //         $result->info = $result::INFO_SUCCESS;
                    //         $result->data = $ruang;
                    //         }
   

                    $load       = $param->loadRegister($post->id);
                    //  print_r($dataArrayRegister);die;
                    $table_register= 'register_dokter';
                    $where            = 'id_register='.$id_register;
                    //  print_r ($where);die;
                     $param->updateGlobal($table_register, $dataArrayRegister, $where);
            
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $load->data;
                                     
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }


    
    public function deletedataregisterAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);


        $tabel     = 'register_dokter';
        $where     = 'id_register='.$post->id;
        $res        = $test->deleteGlobal($tabel, $where);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    public function loadkelolapoliAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        // print_r($post->id);die;
        $load       = $test->loadkelolapoli($post->id);
      
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    public function savekelolapoliAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
                
            $table_poli= 'poli';
            
            

			if ($request->isPost()) {

                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
                    
				try{
                    $nama_poli    = $post->inama_poli;
                    $kode_poli = $post->ikode_poli;
                    $deskripsi_poli = $post->ideskripsi_poli;
  
                    $dataArrayPoli =  array (
                        
                        'nama_poli'     => $nama_poli,
                        'kode_poli'     =>$kode_poli,
                        'deskripsi_poli'=>$deskripsi_poli,

                      
                    );
                    // print_r($dataArrayPoli);die;

            
                    $param->saveGlobal($dataArrayPoli, $table_poli);
                    
               
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $dataArrayPoli->data;
                   
                           
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }
    
    public function editkelolapoliAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
 
			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
             
				try{
                    $id_poli = $post->id;
                    $nama_poli    = $post->inama_poli;
                    $kode_poli = $post->ikode_poli;
                    $deskripsi_poli = $post->ideskripsi_poli;
  
                    $dataArrayPoli =  array (
                        
                        'nama_poli'     => $nama_poli,
                        'kode_poli'     =>$kode_poli,
                        'deskripsi_poli'=>$deskripsi_poli,

                      
                    );
                    $load       = $param->loadkelolapoli($post->id);
                    //  print_r($load);die;
                    $table_poli= 'poli';
                    $where            = 'id_poli='.$id_poli;
                    //  print_r ($where);die;
                     $param->updateGlobal($table_poli, $dataArrayPoli, $where);
            
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $load->data;
                                     
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    public function deletekelolapoliAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        
        $tabel     = 'dokter';
        $where     = 'id_poli='.$post->id;
        $res        = $test->deleteGlobal($tabel, $where);
        $tabel     = 'ruang';
        $where     = 'id_poli='.$post->id;
        $res        = $test->deleteGlobal($tabel, $where);
        $tabel     = 'poli';
        $where     = 'id_poli='.$post->id;
        $res        = $test->deleteGlobal($tabel, $where);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function loadkeloladokterAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        //  print_r($load);die;
        $load       = $test->loadkeloladokter($post->id);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    
    public function savekeloladokterAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
                
            $table_dokter= 'dokter';
 
			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
                
                
				try{
                    $nama_dokter    = $post->inama_dokter;
                    $kode_dokter    = $post->ikode_dokter;
                    $poli           = $post->ipoli;
                  
                    //print_r($poli);die;
  
                    $dataArraydokter =  array (
                        
                        'nama_dokter'     => $nama_dokter,
                        'kode_dokter'     =>$kode_dokter,
                        'id_poli'       =>$poli,
                        'id_condition'  => 1
                 
                    );
                   
                    // print_r($dataArraydokter);die;
            
                    $param->saveGlobal($dataArraydokter, $table_dokter);
                    
               
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $dataArraydokter->data;
                   
                           
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    public function editkeloladokterAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
 
			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
             
				try{
                    $id_dokter = $post->id;
                    $nama_dokter    = $post->inama_dokter;
                    $kode_dokter  = $post->ikode_dokter;
                    $poli = $post->ipoli;
                    $condition = $post->icondition;
  
                    $dataArraydokter =  array (
                        
                        'nama_dokter'     => $nama_dokter,
                        'kode_dokter'     =>$kode_dokter,
                        'id_poli'         =>$poli,
                        'id_condition'         =>$condition,

                      
                    );
                    $load       = $param->loadkeloladokter($post->id);
                    //   print_r($dataArraydokter);die;
                    $table_dokter= 'dokter';
                    $where            = 'id_dokter='.$id_dokter;
                    //  print_r ($where);die;
                     $param->updateGlobal($table_dokter, $dataArraydokter, $where);
            
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $load->data;
                                     
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    public function deletekeloladokterAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        
        $tabel     = 'dokter';
        $where     = 'id_dokter='.$post->id;
  
        $res        = $test->deleteGlobal($tabel, $where);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }


    public function loadkelolaruangAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        //   print_r($load);die;
        $load       = $test->loadkelolaruang($post->id);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function savekelolaruangAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();
                
            $table_ruang= 'ruang';
 
			if ($request->isPost()) {

                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
                
				try{
                    $nama_ruang    = $post->inama_ruang;
                    $poli           = $post->ipoli;
                    //print_r($poli);die;
                    $dataArrayruang =  array (
                        
                        'nama_ruang'     =>$nama_ruang,
                        'id_poli'       =>$poli,
                        'id_condition'  => 1
                   );

                    //  print_r($dataArrayruang);die;
            
                    $param->saveGlobal($dataArrayruang, $table_ruang);
                    
               
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $dataArrayruang;
                   
                           
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    public function editkelolaruangAction(){
        if($this->isLoggedIn()){
			$result 	= new Result();
			$request 	= $this->getRequest();
            $post 		= $request->getPost();

			if ($request->isPost()) {


                $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                $param    	= new \Application\Model\Param($storage);
            
				try{
                    $id_ruang = $post->id;
                    $nama_ruang    = $post->inama_ruang;
                    $poli           = $post->ipoli;
                    
                    
                    $dataArrayruang =  array (
                        
                        'nama_ruang'     =>$nama_ruang,
                        'id_poli'       =>$poli,

                    );
                    
                    $load       = $param->loadkelolaruang($post->id);
                    
                    //  print_r($post->id);die;
                    $table_ruang= 'ruang';
                    $where            = 'id_ruang='.$id_ruang;
                    // print_r ($where);die;
                     $param->updateGlobal($table_ruang, $dataArrayruang, $where);
            
                        $result->code = 0;
                        $result->info = 'ok';
                        $result->data = $load->data;
                   
                           
				}catch (\Exception $exc) {
					$result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
				}
			}else{
				$result = new Result(0,401,'Silahkan masuk untuk melanjutkan');
			}
		}
		return $this->getOutput($result->toJson());
    }

    public function deletekelolaruangAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        $tabel     = 'ruang';
        $where     = 'id_ruang='.$post->id;
  
        $res        = $test->deleteGlobal($tabel, $where);

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function loadkelolaantrianAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

        // print_r($load);die;
        $load       = $test->loadkelolaantrian($post->id);
      
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function loadRegisterEditAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $poli   	= new \Application\Model\Param($storage);
        
        
        $load       = $poli->loadRegisterPoli();
        $loadc      = $poli->loadCondition();        

        $listdata= array();

        $listdata = array(
            'poli'      =>$load->data,
            'condition' =>$loadc->data
        );
        // print_r($listdata);die;

        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $listdata;
        }else{
            $result->code = 1;
            $result->info = 'Not Found poli';
        }

        return $this->getOutput($result->toJson());
    }


    public function loadRegisterPoliAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $poli   	= new \Application\Model\Param($storage);
        
        
        $load       = $poli->loadRegisterPoli();
        

     
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found poli';
        }

        return $this->getOutput($result->toJson());
    }
    
    
    public function loadRegisterDokterAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $dokter   	= new \Application\Model\Param($storage);
        
        
        $load       = $dokter->loadRegisterDokter($post->id_poli);

     
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found dokter';
              

        }

        return $this->getOutput($result->toJson());
    }


    public function loadRegisterRuangAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $ruang   	= new \Application\Model\Param($storage);
        
        
        $load       = $ruang->loadRegisterRuang($post->id_poli);

     
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function loadAntrianAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $antrian   	= new \Application\Model\Param($storage);
        
        
        $load       = $antrian->loadAntrian();
        
        
        
        
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
           
        }
        else{
            $result->code = 1;
            $result->info = 'Not Found';
              
        }

        return $this->getOutput($result->toJson());
    }

    public function loadConditionAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $poli   	= new \Application\Model\Param($storage);
        
        
        $load       = $poli->loadCondition();

     
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found poli';
        }

        return $this->getOutput($result->toJson());
    }

    public function loadPoliAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $poli   	= new \Application\Model\Param($storage);
        
        
        $load       = $poli->loadPoli();


        
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    
    public function loadDokterAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $dokter   	= new \Application\Model\Param($storage);
        
        // print_r($post->id_poli);die;
        $load       = $dokter->loadDokter($post->id_poli);

     
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $load->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
   
    public function loadPilihAntrianAction(){
        $result = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $dokter   	= new \Application\Model\Param($storage);
        
        

        $iddokter = $post->iddok;
        
        $load       = $dokter->loadPilihAntrian($iddokter);

        $listdata = array();

        foreach($load->data as $val){

            array_push($listdata, $val);

        }
        // print_r($listdata);die;
        if($load->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $listdata;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function LoadAntrianAdminAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);
    
        $idokter = $post->id;

        $loadAntrianAdmin           = $test->loadAntrianAdmin($idokter);
        // print_r( $idokter);die;

       
        
        if($loaddokter->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $loadAntrianAdmin->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    public function LoadNoAntrianAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);
    
        // $idokter = $post->idokter;

        $loadNoAntrian         = $test->loadNoAntrian($post->id_dokter, $post->istatus);
             
        if($loaddokter->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $loadNoAntrian->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }

    public function nextantrianAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        
        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

    

        $noantrian = $post->inoantrian;
        $iddok = $post->idok;
        $status = $post->istatus;

        $dataarray = array(
            'status_code'   => $status,        
        );
            
        $loadAntrianAdmin     = $test->loadAntrianAdmin($iddok);

            $table = 'antrian_pasien'; 
            $where = 'id_dokter='.$iddok.' and no_antrian='.$noantrian;
            $test->updateGlobal($table, $dataarray, $where);
            
        if($loaddokter->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $loadAntrianAdmin->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    public function updateantrianmissAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        
        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);

    

        $iddok = $post->iddok;
        $idpasien= $post->iidpasien;

        $dataarray = array(
            'status_code'   => 10,        
        );
            
        $loadAntrianAdmin     = $test->updatekelolaantrian($idpasien,$iddok);

            $table = 'antrian_pasien'; 
            $where = 'id_dokter='.$iddok.' and id_pasien='.$idpasien;
            $test->updateGlobal($table, $dataarray, $where);

            // print_r($where);
            
        if($loaddokter->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $loadAntrianAdmin->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }
    
    public function tampildokterAction(){
        $result     = new Result();
        $request 	= $this->getRequest();
		$post 		= $request->getPost();
        
        //$name       = $this->isFieldMandatory(@$data['name'], 'name');

        $storage 	= \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
        $test    	= new \Application\Model\Param($storage);


        $loaddokter           = $test->tampildokter();

        // print_r($loaddokter);die;


        if($loaddokter->code == 0){
            $result->code = $result::CODE_SUCCESS;
            $result->info = $result::INFO_SUCCESS;
            $result->data = $loaddokter->data;
        }else{
            $result->code = 1;
            $result->info = 'Not Found';
        }

        return $this->getOutput($result->toJson());
    }    
 }