$(document).ready(function(){
    
    $('.datatable-basic').DataTable({
        
        autoWidth: false,
        columnDefs: [{ 
            orderable: false,
            "width": "2%", "targets": 0,
            "width": "20%", "targets": 1,
            "width": "30%", "targets": 2,
            "width": "40%", "targets": 3,
            "width": "5%", "targets": 4,
            
            
        }],
        dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            searchPlaceholder: 'Type to filter...',
            lengthMenu: '<span>Show:</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        drawCallback: function () {
            $(this).find('tbody tr').slice(-1).find('.dropdown, .btn-group').addClass('dropup');
        },
        preDrawCallback: function() {
            $(this).find('tbody tr').slice(-1).find('.dropdown, .btn-group').removeClass('dropup');
        }
    });


    $("#addPopUp").on("click", function(){
        $('#modal-add').modal("show");
    })


})

$("#submitmhs").on("click", function(e){
    e.preventDefault();
    // var namamhs     = $("#mhsname").val();
    // var nimmhs      = $("#mhsnim").val();
    // var facultas    = $("#faculty").val();
    // var jurusan     = $("#mhsmajor").val();
    // var gender      = $('input[name="gender"]:checked').val();

    // console.log(facultas);
    // console.log(jurusan);
    // console.log(nimmhs);
    // console.log(namamhs);
    // console.log(gender);

    saveMahasiswa()
    // validatenim();
})

function validatenim(){
    let isObject = {};
    isObject.param = iduser;
    var nim     = $("#mhsnim").val();
    var exist   = false;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadmahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            // $("tbody").empty();
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                // console.log(result.data);
                let data    = result.data;
                // console.log(data);
                for(i in data){
                    if(nim == data[i].nim){
                        exist = true;
                    }
                }
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

    return exist;
}

function saveMahasiswa(){
    var isObject    = {};
    var nimpattern  = /^[0-9]{10}$/;
    var namapattern = /^[a-zA-Z ]{2,30}$/;
    isObject.namamhs    = $("#mhsname").val();
    isObject.nimmhs     = $("#mhsnim").val();
    isObject.facultas   = $("#faculty").val();
    isObject.jurusan    = $("#mhsmajor").val();
    isObject.gender     = $('input[name="gender"]:checked').val();

    // console.log(isObject);
    if(isObject.namamhs == ""){
        swal({
            title: "Peringatan!",
            text:" Nama tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!namapattern.test(isObject.namamhs)){
        swal({
            title: "Peringatan!",
            text:" Format nama salah!",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.nimmhs == ""){
        swal({
            title: "Peringatan!",
            text:" NIM tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!nimpattern.test(isObject.nimmhs)){
        swal({
            title: "Peringatan!",
            text:" NIM harus terdiri dari 10 karakter:)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(validatenim()){
        swal({
            title: "Alert",
            text:  " NIM tidak tersedia!",
            confirmButtonColor: "#2196F3",
            type: "error"
        });  
        return false
    }

    if(isObject.gender == ""){
        swal({
            title: "Peringatan!",
            text:" Jenis Kelamin tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } 

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/savemahasiswa',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Mahasiswa telah ditambahkan ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    loadElementsMhs();
                    // location.reload()
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

// loadMahasiswa();
function loadMahasiswa(){
    let isObject = {};
    isObject.param = iduser;
    // console.log(isObject)

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadmahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            $("tbody").empty();
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                // console.log(result.data);
                let data    = result.data;
                let counter = 1;

                for (i in data){
                    var row = "";
                    
                    
                    row     += `<tr>
                                    <td>`+counter+`</td>
                                    <td>`+data[i].nim+`</td>
                                    <td>`+data[i].nama+`</a></td>
                                    <td>`+data[i].jurusan+`</td>`;
                    row     +=      `<td class="text-center">
                                        <ul class="icons-list">
                                            <li class="dropdown">
                                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="icon-menu9"></i>
                                                </a>
                    
                                                <ul class="dropdown-menu dropdown-menu-right">
                                                    <li><a onclick="validatedelete('`+data[i].nim+`')"><i class="icon-user-cancel"></i> Delete Mahasiswa</a></li>
                                                    <li><a href="`+baseURL+`/admin/berkas?nim=`+encodeURIComponent(btoa(data[i].nim))+`"><i class=" icon-user-check"></i> Check Berkas</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>` ;
                    $("tbody").append(row);
                    counter++;  
                }

                // Alternative pagination
                $('.datatable-pagination').DataTable({
                    pagingType: "simple",
                    language: {
                        paginate: {'next': 'Next &rarr;', 'previous': '&larr; Prev'}
                    }
                });


                // Datatable with saving state
                $('.datatable-save-state').DataTable({
                    stateSave: true
                });


                // Scrollable datatable
                $('.datatable-scroll-y').DataTable({
                    autoWidth: true,
                    scrollY: 300
                });



                // External table additions
                // ------------------------------

                // Enable Select2 select for the length option
                $('.dataTables_length select').select2({
                    minimumResultsForSearch: 10,
                    width: 'auto'
                });
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}


function validatedelete(uname){
    event.preventDefault();
    swal({
        title: "Hapus data mahasiswa?",
        text: "once you remove this data, you wont be able to retrieve this file.",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Ya",
        cancelButtonText: "Tidak",
        cancelButtonColor: "#DD6B55",
        closeOnConfirm: false,
        closeOnCancel: false
      },
      function(isConfirm){
        if (isConfirm) {
            deleteuser(uname);
            // console.log(uname);
            // // submitting the form when user press yes
        } else {
          swal("Mahasiswa tidak dihapus", "", "error");
        }
    });
}

function deleteuser(uname){
    var isObject    = {}

    isObject.id = uname;
    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/deletemahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            
            if(response.code == CODE_SUCCESS){
                swal({
                    title: "Alert",
                    text:  " Mahasiswa berhasil dihapus!",
                    confirmButtonColor: "#2196F3",
                    type: "success",
                    icon: "success"
                }, function(){
                    // $("tbody").empty();
                    // loadMahasiswa();  
                    // Alternative pagination
                    loadElementsMhs();     
                    loaderPage(false);
                });  
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }    
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

    // console.log(id)
}

//load serverside
loadElementsMhs()
function loadElementsMhs(clicksc){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;

    var dtpr = $('#mahasiswalist').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/mahasiswalist',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    // var datas;
                    // var dataada=[];
                    // // datas.push(data[0])
                    // // console.log(datas);
                    // for(i in data){
                    //     datas = {
                    //         "id_mhs": data[i].id_mhs,
                    //         "nim": data[i].nim,
                    //         "nama": data[i].nama,
                    //         "jurusan": data[i].jurusan,
                    //         "jeniskelamin": data[i].jeniskelamin,
                    //         "fakultas": data[i].fakultas,
                    //         "create_date": data[i].create_date,
                    //         // "status": statusberkas(data[i].nim)
                    //     }
                    //     dataada.push(datas)
                    // }
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'nim', 'sClass':'','sWidth':'10px'},
            { 'data': 'nim', 'sClass':''},
            { 'data': 'nama', 'sClass':''},
            { 'data': 'nama_prodi', 'sClass':''},
            { 'data': 'statusvalid', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        // buttons: {            
        //     buttons: [
        //         {
        //             extend: 'colvis',
        //             className: 'btn btn-default'
        //         },
        //     ]
        // },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            {   


                // render: function (data, type, row){
                //     // var $rowData = '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt" style="cursor: pointer;">';
                //     let isIcon = ' icon-file-download2';

                //     var $rowData = '<div class="thumb img-rounded img-preview showAtt" style="width: 70px;">'+
                //         '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt">'+
                //         '<div class="caption-overflow">'+
                //             '<span>'+
                //                 '<p  class="btn showAtt bg-success-400 btn-icon btn-lg" style="font-variant: all-petite-caps;background-color: #0e0e0e33 !important;border-color: #25252591 !important;">'+
                //                     '<i class="'+isIcon+'"></i> '
                //                 '</p>'+
                //             '</span>'+
                //         '</div>'+
                //     '</div>';

                //     return $rowData;
                // },
                // visible: true,
                // targets: 1,
            },  
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    if(row.statusvalid == "VALID"){
                        $rowData ='<span style="min-width: 70px" class="label label-success">'+row.statusvalid+'</span>';
                    }else if(row.statusvalid == "MENUNGGU VALIDASI"){
                        $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                    } else if(row.statusvalid == "BELUM UPLOAD"){
                        $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                    }else if(row.statusvalid == "TIDAK VALID"){
                        $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                    }
                    return $rowData;
                },
                visible: true,
                targets: 4,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    console.log(row.nim)
                    var action = '';
                    if(row.approve_proses_bimbingan == null || row.approve_proses_bimbingan == ""){
                        action = `<li><a onclick="alertprobimbingan()"><i class=" icon-file-plus2"></i> Upload Berkas</a></li>`;
                    } else {
                        action = `<li><a href="`+baseURL+`/admin/uploadberkas?nim=`+encodeURIComponent(btoa(row.nim))+`"><i class=" icon-file-plus2"></i> Upload Berkas</a></li>`;
                    }
                    console.log(row.nama_prodi);

                    if(row.statusvalid == "VALID"){
                        $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                             
                                                <li class=""><a onclick="alertupload()"><i class=" icon-file-plus2"></i> Upload Berkas</a></li>
                                                <li class=""><a onclick="berkaslist(`+row.idberkas+`, '`+row.file_foto+`', '`+row.nama+`', '`+row.nim_mhs+`', '`+row.nama_prodi+`', '`+row.statusvalid+`')" class=""><i class="icon-file-eye2"></i> Lihat Berkas</a></li>                                               
                                                
                                            </ul>
                                        </li>
                                    </ul>`;
                    }
                    else if(row.statusvalid == "MENUNGGU VALIDASI"){
                        $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                
                                                <li><a href="`+baseURL+`/admin/updateberkas?nim=`+encodeURIComponent(btoa(row.nim))+`"><i class=" icon-file-plus2"></i> Update Berkas</a></li>
                                                <li class=""><a onclick="berkaslist(`+row.idberkas+`, '`+row.file_foto+`', '`+row.nama+`', '`+row.nim_mhs+`', '`+row.nama_prodi+`', '`+row.statusvalid+`')"class=""><i class="icon-file-eye2"></i> Lihat Berkas</a></li>
                                                
                                            </ul>
                                        </li>
                                    </ul>`
                    } else if(row.statusvalid == "BELUM UPLOAD"){
                        $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li><a href="`+baseURL+`/admin/uploadberkas?nim=`+encodeURIComponent(btoa(row.nim))+`"><i class=" icon-file-plus2"></i> Upload Berkas</a></li>
                                                <li class=""><a onclick="alertnotupload()"><i class="   icon-file-eye2"></i> Lihat Berkas</a></li>
                                            </ul>
                                        </li>
                                    </ul>`
                    } else if(row.statusvalid == "TIDAK VALID"){
                        //ini nanti gas pendings
                        $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                
                                                <li><a href="`+baseURL+`/admin/uploadberkas?nim=`+encodeURIComponent(btoa(row.nim))+`"><i class=" icon-file-plus2"></i> Upload Berkas</a></li>
                                                <li class=""><a onclick="berkaslist(`+row.idberkas+`, '`+row.file_foto+`', '`+row.nama+`', '`+row.nim_mhs+`', '`+row.nama_prodi+`', '`+row.statusvalid+`')"class=""><i class="icon-file-eye2"></i> Lihat Berkas</a></li>
                                                
                                            </ul>
                                        </li>
                                    </ul>`
                    }
                    console.log(baseURL+`/admin/uploadberkas?nim=`+row.nim);
                    return $rowData;
                },
                visible: true,
                targets: 5,
                className: 'dt-center'
            }, 
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');
            // $(this).find('tbody tr').slice(-3).find('.icons-list, .btn-group').addClass('position-absolute')
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

function statusberkas(nim){
    // loaderPage(true)
    var complete;
    var isObject = {};
    isObject.nim = nim;
    console.log(isObject.nim)
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadstatusberkas',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
                
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                let data    = result.data;
                // if (data[0] != 0 ){
                //     complete = true;
                // }
                complete=data[0];
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    return complete;
    // return complete;

}

function alertupload(){
    swal({
        title: "Peringatan",
        text:" Berkas sudah di upload, silahkan ke halaman Buat Jadwal untuk membuat jadwal",
        confirmButtonColor: "#2196F3",
        type: "warning"
    });
}

function alertnotupload(){
    swal({
        title: "Peringatan!",
        text:" Berkas belum di upload! silahkan upload berkas terlebih dahulu!",
        confirmButtonColor: "#2196F3",
        // type: "warning"
    });
}

function alertprobimbingan(){
    swal({
        title: "Peringatan!",
        text:" Tidak dapat mengupload berkas, proses bimbingan mahasiswa belum selesai.",
        confirmButtonColor: "#2196F3",
        type: "warning"
    });
}

function listberkas(nim){
    var isObject = {};
    isObject.param = nim;
    loaderPage(true)
    // $(".normpoint > img").attr(src);
    $("#modalberkas").modal("show");
    
    
    // $("#nimberkas").html(nim);
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadberkasattach',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                let data    = result.data;
                
                console.log(data);
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });
            }
            
            loaderPage(false)
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    
}

function loadberkas(idberkas, status){
    var isObject = {}
    isObject.idberkas = idberkas;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadlistberkas',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            let result  = cryptoDecrypt(PHRASE, response.data);
        
            if(response.code == CODE_SUCCESS){ 
                let data    = result.data;         
                var cont = `<h5 class="headlist">List Berkas Mahasiswa</h5><hr>`;
                for(i in data){
                    cont += `<ul class="media-list">`;
                    cont += `<li class="media" >
                                <div class="media-left media-middle medhov" onclick="modalattach('`+data[i].file_dir+`','`+data[i].file_name+`')">
                                    <a href="#">
                                        <img src="`+baseURL+`/img/pdfp.png" class="img-circle img-md" alt="">
                                    </a>
                                </div>

                                <div class="media-body medhov media-bodys" onclick="modalattach('`+data[i].file_dir+`','`+data[i].file_name+`')">
                                <div class="media-heading text-semibold">`+data[i].file_name+`</div>
                                    <span class="text-muted __web-inspector-hide-shortcut__">File size : `+data[i].file_size+` Mb</span>
                                </div>

                                
                            </li>
                            `;  
                }
                var buttonf = '';

                if(status == "VALID" || status == "TIDAK VALID"){
                    buttonf += `<button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                    <button onclick="berkasvalid('`+data[0].nim+`', `+0+`)" id="notvalid" type="button" class="btn btn-danger" disabled>Tidak Valid</button>
                    <button onclick="berkasvalid('`+data[0].nim+`', `+1+`)" id="valid" type="button" class="btn btn-success" disabled>Validasi</button>`;
                }else{
                    cont += `<h5 class="headlist" id="containerket">Keterangan validasi</h5><hr>`;
                    cont += `<div class="form-group" id="containerket" >
                                    <label>Keterangan:</label>
                                    <textarea id="keterangan" rows="5" cols="5" class="form-control" placeholder="Contoh : file 1 tidak valid karena...."></textarea>
                                </div>`;
                    buttonf += `<button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                    <button onclick="berkasvalid('`+data[0].nim+`', `+0+`)" id="notvalid" type="button" class="btn btn-danger">Tidak Valid</button>
                    <button onclick="berkasvalid('`+data[0].nim+`', `+1+`)"id="valid" type="button" class="btn btn-success">Validasi</button>`;
                }

                $("#mbody").append(cont);
                $("#modfoot").append(buttonf)
                $("#modalberkas").modal("show");
            

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

}

function berkaslist(idberkas, filefoto, nama, nim, jurusan, status){
    var buttonf = "";
    console.log(idberkas);
    
    
    var dirs = baseURL+'/data/profilepicture/'+filefoto;
    if(!fileExists(dirs)){
        $(".normpoint > img").attr('src', baseURL+'/data/profilepicture/defaultpics.png');
    }else{
        $(".normpoint > img").attr('src', baseURL+'/data/profilepicture/'+filefoto);
    }
    

    $("#namamBerkas").html(": "+nama);
    $("#nimmberkas").html(": "+nim);
    $("#prodimberkas").html(": "+jurusan);
    $("#statusberkas").html(": "+status);
    $("#modfoot").empty();
    $("#mbody").empty();
    $("#mdtitle").html("Lihat Berkas")
    
    loadberkas(idberkas, status);

    
}

function modalattach(dir, file){
    $("#modalberkas").modal("hide");
        $('.isv').append(`<embed src="`+baseURL+dir+``+file+`" type="application/pdf"   style="width: 100%; height: 100%; min-height: 480px;">`);
    $("#modal-video").modal("show");
}

$("#modal-video").on("hidden.bs.modal", function(){
    $(".isv").empty();
    $("#modalberkas").modal("show");
})

$("#notvalid").on("click", function(e){
    e.preventDefault();
})

$("#valid").on("click", function(e){
    e.preventDefault();
})

function berkasvalid(nim, isvalid){

    var isObject = {};
    isObject.nim        = nim;
    isObject.isvalid    = isvalid;
    isObject.keterangan = $("#keterangan").val();
    console.log(isvalid);
    

    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/validasiberkas',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            $('#modalberkas').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Berkas telah di validasi! ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    
                    loadElementsMhs();
                    // location.reload()
                    loaderPage(false);
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    
}