<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Application\Master;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// use TCPDF\asdadasd;


class JsondataController extends \Application\Master\GlobalActionController
{   
    const INPUTEXT  = 1;
    const TEXTAREA  = 2;
    const SELECTOPT = 3;
    const RADIONBTN = 4;
    
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }
    
    public function loadprofilepartialAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $count          = self::antiInjection($isData->param ?? null);
                        $judul          = self::antiInjection($isData->judul ?? null);
                        $publish        = self::antiInjection($isData->publish ?? null);
                        $order          = self::antiInjection($isData->order ?? null);
                        $sort           = self::antiInjection($isData->sort ?? null);
                        $start          = self::antiInjection($isData->start ?? null);
                        $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadSurveyProfilePartialAdmin($judul, $publish, $start, $limit, $count, $order, $sort);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadmahasiswaAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadMahasiswa($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function selectMhsAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->selectmhs($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadmhsbyprodiAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id             = self::antiInjection($isData->kodeprodi ?? null);
                        
                        $result         = $model->loadmhsbyprodi($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadperusahaanAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadperusahaan($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaddashboardadminAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        
                        $result         = $model->loaddashboardadmin($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaddashboarddosenAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        
                        $result         = $model->loaddashboarddosen($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaddashboardmahasiswaAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        
                        $result         = $model->loaddashboardmahasiswa($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function updatestatustenggatAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        // $dataArr        = array(
                        //     'bobot'   => self::antiInjection($isData->newVal ?? null),
                        // );
                        
                        // $where          = 'id_bobot ='.$isData->id;
                        
                        $resHeader      = $model->updatestatustenggat();

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadparambobotAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $code         = self::antiInjection($isData->code ?? null);
                        $table        = 'sipenkp_bobot_penilaian';
                        $from         = '*';

                        if($code){
                            $where        = "code_penilaian = ".$code;
                        }
                        
                        $result         = $model->loadGlobal($table, $from, $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadparambobotsAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $code         = self::antiInjection($isData->code ?? null);
                        $table        = 'sipenkp_bobot_penilaian';
                        $from         = '*';
                        $where        = "code_penilaian = ".$code;
                        
                        $result         = $model->loadGlobal($table, $from, $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }


    public function loadcalendarAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData->tanggal);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadCalendarData($isData->tanggal);
                        // $datajadaw;
                        // $i = 0;
                        // foreach($result->data as $val){
                            
                        //     $endTime = strtotime("+45 minutes", strtotime($val['jam']));
                        //     $endless = date('h:i:s', $endTime);
                        //     // print_r($endTime.", ");
                        //     // print_r($endless.", ");
                        //     // array_push($result->data,'jam_habis' => $endless);
                        //     $arrayMerge = array_merge($result->data[$i], array('jam_habis' => $endless));
                        //     $i++;
                        // }
                        // print_r($result->data[0]);die;   
                        // print_r($endTime);die;
                        // $datakal = $result->data;
                        // for($i = 0; $i <= count($datakal); $i++ ){
                        //     $endTime = strtotime("+45 minutes", strtotime($datakal[$i]));
                        //     $endless = date('h:i:s', $endTime);
                        //     $arrayMerge = array_merge($datakal[$i], array('jam_habis' => $endless));
                        //     // 
                        // }
                        // print_r($arrayMerge);die;
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function sendemailAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData->tanggal);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = self::antiInjection($isData->param ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        
                        $urlbase    = $this->urlLedakan();
                        // print_r($urlbase);die;
                        $tgl        = $this->STORAGE_NOW();
                        $result     = $model->sendemail($idkp, $tgl, $urlbase);
                        
                        /* encrypt dan return data */
                        if($result->code == 0){
                            $result->info = 'Send Email Success';
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function sendemailsAction($nims){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData->tanggal);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = self::antiInjection($isData->param ?? null);
                        $wherekp        = "nim = '$nims' ORDER BY create_date DESC LIMIT 1";
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        
                        $urlbase    = $this->urlLedakan();
                        // print_r($urlbase);die;
                        $tgl        = $this->STORAGE_NOW();
                        $result     = $model->sendemail($idkp, $tgl, $urlbase);
                        
                        /* encrypt dan return data */
                        if($result->code == 0){
                            $result->info = 'Send Email Success';
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaddatajadwalAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData->tanggal);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                  
                        $result         = $model->loaddatajadwal($id);
                        
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    

    public function loaddsnAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loaddsn($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadpembimbingAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadpembimbing($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function detailpengajuanAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->detailPengajuan($id);
                        // print_r($result->data[0]['id_pengajuan']);die;
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadberkasattachAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // print_r($id);die;
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadAttach($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadstatusberkasAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        // print_r($nim);die;
                        $result         = $model->loadStatusBerkas($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadstatusberkasmAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->loadStatusBerkasM($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaddatakpAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->loaddatakp($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadproseskpAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->loadproseskp($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadpengajuansAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->loadpengajuans($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadtopikAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        
                        $idkp           = self::antiInjection($isData->idkp);
                        $table          = "sipenkp_topik";
                        $wheres         = "id_kp = $idkp";
                        $result         = $model->loadGlobal($table, "*", $wheres);
                        // print_r($result);die;
                        
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function savetopikAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            'id_kp'             => self::antiInjection($isData->id_kp ?? null),
                            'topik'             => self::antiInjection($isData->topik ?? null),
                            'create_date'       => $this->STORAGE_NOW(),
                        );
                        
                        $result         = $model->saveGlobal($dataArr, 'sipenkp_topik', true);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaddatakpsAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->loaddatakps($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function nilaiperusahaanAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $idkp             = self::antiInjection($isData->idkp);
                    //    print_r($nim);die;
                        $result         = $model->nilaiperusahaan($idkp);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function nilaipengujiAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $idkp             = self::antiInjection($isData->idkp);
                    //    print_r($nim);die;
                        $result         = $model->nilaipenguji($idkp);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function nilaipembimbingAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $idkp             = self::antiInjection($isData->idkp);
                    //    print_r($nim);die;
                        $result         = $model->nilaipembimbing($idkp);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadfilebimbinganAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                        $nopeg           = self::antiInjection($isData->nopeg);
                    //    print_r($nim);die;
                        $result         = $model->loadfilebimbingan($nim, $nopeg);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function ishavepembimbingAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = self::antiInjection($isData->nim);
                    //    print_r($nim);die;
                        $result         = $model->ishavepembimbing($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadbobotAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadbobot($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaduserAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData->param ?? null);
                        // $judul          = self::antiInjection($isData->judul ?? null);
                        // $publish        = self::antiInjection($isData->publish ?? null);
                        // $order          = self::antiInjection($isData->order ?? null);
                        // $sort           = self::antiInjection($isData->sort ?? null);
                        // $start          = self::antiInjection($isData->start ?? null);
                        // $limit          = self::antiInjection($isData->limit ?? null);
                        
                        $result         = $model->loadUser($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function deleteuserAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $paramid        = self::antiInjection($isData->id ?? null);

                        $where          = "iduser=$paramid";
                        // print_r($where);die;
                        
                        $result         = $model->deleteGlobal('user_data_header', $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function deletemahasiswaAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $paramid        = self::antiInjection($isData->id ?? null);

                        $where          = "nim='$paramid'";
                        // print_r($where);die;
                        
                        $result         = $model->deleteGlobal('mahasiswa', $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function changestatusAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            self::antiInjection($isData->columns ?? null)   => self::antiInjection($isData->status ?? null),
                        );
                        
                        $where          = 'iduser ='.$isData->id;
                        
                        $resHeader      = $model->updateGlobal('user_data_header', $dataArr, $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function editbobotAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            'bobot'   => self::antiInjection($isData->newVal ?? null),
                        );
                        
                        $where          = 'id_bobot ='.$isData->id;
                        
                        $resHeader      = $model->updateGlobal('bobot_penilaian', $dataArr, $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function editbobotbatchAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                   
                    
                    // print_r($arrayData);die;

                    
                   
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        // $dataArr        = array(
                        //     1   => self::antiInjection($isData->param1 ?? null),
                        //     2   => self::antiInjection($isData->param2 ?? null),
                        //     3   => self::antiInjection($isData->param3 ?? null),
                        //     4   => self::antiInjection($isData->param4 ?? null),
                        //     5   => self::antiInjection($isData->param5 ?? null),
                        //     6   => self::antiInjection($isData->param6 ?? null),
                        //     7   => self::antiInjection($isData->param7 ?? null),
                        // );
                        $arrayData      = array();
                        foreach ($isData as $key => $value) {
                            // echo "$key => $value\n";
                            
                            if($key != 'totalbobot'){
                                $arrayData[$key] = $value;
                            }
                            
                        }
                        
                        // print_r($arrayData);die;
                        
                        $resHeader      = $model->editbobotbatch('bobot_penilaian', $arrayData);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function ngaco(){
        return 11;
    }

    public function submitnilaiperusahaanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        $results      = new Result();
        // print_r($this->ngaco());die;
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    $isData2         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam2') ?? null); // buka bukaan
                    
                    // print_r($isData2);die;

                    if($isData){ // is true / istri
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');
                        

                        /* begin */
                        
                        $idkp       = $isData2->idkp;
                        //load table kp
                        $wheres     = 'id_kp = '.$idkp;
                        $table      = 'sipenkp_kerja_praktik';
                        $result     = $model->loadGlobal($table, "*", $wheres);
                        $reskp      = $result->data[0];
                        $nim        = $reskp['nim'];
                        $nimdum     = '13105014';
                        // print_r($nim);die;
                        
                        $wheres     = "nim = '$nim'";
                        $table      = 'sipenkp_nilai_mahasiswa';
                        $results    = $model->loadGlobal($table, "*", $wheres);
                        $tblnilai   = $results->data[0];
                        // print_r($tblnilai['id_nilai']);die;
                        // print_r('disini');die;
                        $connect->beginTransaction();
                        if($results->code == $result::CODE_SUCCESS && $tblnilai['id_kp']){ //kalo belom ada nilai mhs di tabel nilai
                            // print_r('hi');die;
                            $datas = array (
                                'stat_penilaian_perusahaan' => 1,
                                // 'update_date'               => $this->STORAGE_NOW(),
                            );
                            $where          = 'id_kp = '.$idkp;
                            $result         = $model->updateGlobal('sipenkp_nilai_mahasiswa', $datas, $where);

                            $idnilai = $tblnilai['id_nilai'];
                            if($result->code == $result::CODE_SUCCESS){
                                $arrayData      = array();
                                foreach ($isData as $key => $value) {
                                    // echo "$key => $value\n";
                                    
                                    if($key != 'totalbobot'){
                                        $arrayData[$key] = $value;
                                    }
                                    
                                }
                                
                                $result      = $model->submitnilaiperusahaan('sipenkp_penilaian_perusahaan', $arrayData, $idnilai, $user_id);
                            }
                            
                            if($result->code == $result::CODE_SUCCESS){

                                $datan = array (
                                    'id_nilai'                  => $idnilai,
                                    'update_date'               => $this->STORAGE_NOW(),
                                    'status_nilai_perusahaan'   => 1,
                                );

                                $where          = 'id_kp = '.$idkp;
                                $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                            }

                        } else {
                            // print_r('disini');die;
                            $datas = array (
                                'id_kp'                     => $idkp,
                                'nim'                       => $nim,
                                'stat_penilaian_perusahaan' => 1,
                                // 'create_date'               => $this->STORAGE_NOW(),
                            );

                            $result         = $model->saveGlobal($datas, 'sipenkp_nilai_mahasiswa', true);
                            // print_r($result);die;
                            $idnilai = $result->data;
                            if($result->code == $result::CODE_SUCCESS){
                                $arrayData      = array();
                                foreach ($isData as $key => $value) {
                                    // echo "$key => $value\n";
                                    
                                    if($key != 'totalbobot'){
                                        $arrayData[$key] = $value;
                                    }
                                    
                                }
                                
                                $result      = $model->submitnilaiperusahaan('sipenkp_penilaian_perusahaan', $arrayData, $idnilai, $user_id);
                            }
                            
                            if($result->code == $result::CODE_SUCCESS){

                                $datan = array (
                                    'id_nilai'                  => $idnilai,
                                    'update_date'               => $this->STORAGE_NOW(),
                                    'status_nilai_perusahaan'   => 1,
                                );

                                $where          = 'id_kp = '.$idkp;
                                $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                            }
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                            // 
                        }else{
                            $connect->rollback();
                        }   //didieu guys

                        // 0. load table kp, cek status 3 penilaian
                        // $table       = 'sipenkp_kerja_praktik';
                        // $wheres      = "id_kp = $idkp"; 
                        // $checkstatus = $model->loadGlobal($table, "*", $wheres);
                        // if($checkstatus->data['status_nilai_perusahaan'] == 1 && $checkstatus->data['status_nilai_pembimbing'] == 1 && $checkstatus->data['status_nilai_penguji'] == 1){
                        //     print_r('kondisi full');
                        // } else {
                        //     print_r('kondisi da full');
                        // }
                        // die;
                        // print_r($checkstatus->data);die;
                        // print_r($idkp);die;
                        // 1. load tbl n perusahaan
                        // 2. load tbl n penguji, pembimbing
                        // 3. load tbl n bobot
                        // 4. rumus masukin, hitung nilai, nilai akhir
                        // 5. hasil input ke tabel n_mahasiswa
                        // 6. status kp selesai

                        

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function submitnilaipengujiAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        $results      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    $isData2         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam2') ?? null); // buka bukaan
                    
                    // print_r($isData2);die;

                    if($isData){ // is true / istri
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');
                        

                        /* begin */
                        
                        $idkp       = $isData2->idkp;
                        //load table kp
                        $wheres     = 'id_kp = '.$idkp;
                        $table      = 'sipenkp_kerja_praktik';
                        $result     = $model->loadGlobal($table, "*", $wheres);
                        $reskp      = $result->data[0];
                        $nim        = $reskp['nim'];
                        $nimdum     = '13105014';
                        // print_r($nim);die;
                        
                        $wheres     = "nim = '$nim'";
                        $table      = 'sipenkp_nilai_mahasiswa';
                        $results    = $model->loadGlobal($table, "*", $wheres);
                        $tblnilai   = $results->data[0];
                        // print_r($tblnilai['id_nilai']);die;
                        // print_r('disini');die;
                        $connect->beginTransaction();
                        if($results->code == $result::CODE_SUCCESS && $tblnilai['id_kp']){ //kalo udah ada id kp di tbl nilai
                            
                            if($isData2->identitas == 'pembimbing'){//penilaian pembimbing
                                $datas = array (
                                    'stat_penilaian_pembimbing' => 1,
                                );

                                $where          = 'id_kp = '.$idkp;
                                $result         = $model->updateGlobal('sipenkp_nilai_mahasiswa', $datas, $where);
                                
                                if($result->code == $result::CODE_SUCCESS){
                                    $arrayData      = array();
                                    foreach ($isData as $key => $value) {
                                        // echo "$key => $value\n";
                                        
                                        if($key != 'totalbobot'){
                                            $arrayData[$key] = $value;
                                        }
                                        
                                    }

                                    $tables      = 'sipenkp_penilaian_pembimbing';
                                    $ididentity  = self::antiInjection($isData2->ididentitas ?? null);
                                    $identity    = self::antiInjection($isData2->identitas ?? null);
                                    $idnilai     = $tblnilai['id_nilai'];
                                    // print_r($identity);die;
                                    $result      = $model->submitnilaipenguji($tables, $arrayData, $idnilai, $user_id, $ididentity, $identity);
                                    // $model->submitnilaiperusahaan('sipenkp_penilaian_perusahaan', $arrayData, $idnilai, $user_id);
                                    // print_r($result->code);die;
                                }

                                if($result->code == $result::CODE_SUCCESS){

                                    $datan = array (
                                        // 'id_nilai'                  => $idnilai,
                                        'update_date'               => $this->STORAGE_NOW(),
                                        'status_nilai_pembimbing'   => 1,
                                    );
    
                                    $where          = 'id_kp = '.$idkp;
                                    $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                                }
                                


                            }else if($isData2->identitas == 'penguji'){ //penilaian penguji
                                $datas = array (
                                    'stat_penilaian_penguji' => 1,
                                );

                                $where          = 'id_kp = '.$idkp;
                                $result         = $model->updateGlobal('sipenkp_nilai_mahasiswa', $datas, $where);
                                // print_r($result);die;
                                if($result->code == $result::CODE_SUCCESS){
                                    $arrayData      = array();
                                    foreach ($isData as $key => $value) {
                                        // echo "$key => $value\n";
                                        
                                        if($key != 'totalbobot'){
                                            $arrayData[$key] = $value;
                                        }
                                        
                                    }

                                    $tables      = 'sipenkp_penilaian_penguji';
                                    $ididentity  = self::antiInjection($isData2->ididentitas ?? null);
                                    $identity    = self::antiInjection($isData2->identitas ?? null);
                                    $idnilai     = $tblnilai['id_nilai'];
                                    // print_r($identity);die;
                                    $result      = $model->submitnilaipenguji($tables, $arrayData, $idnilai, $user_id, $ididentity, $identity);
                                    // $model->submitnilaiperusahaan('sipenkp_penilaian_perusahaan', $arrayData, $idnilai, $user_id);
                                    // print_r($result->code);die;
                                }

                                if($result->code == $result::CODE_SUCCESS){

                                    $datan = array (
                                        // 'id_nilai'                  => $idnilai,
                                        'update_date'               => $this->STORAGE_NOW(),
                                        'status_nilai_penguji'      => 1,
                                    );
    
                                    $where          = 'id_kp = '.$idkp;
                                    $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                                }
                            }

                           

                        } else { //kalo blm ada id kp di tabel nilai
                            // print_r('disini');die;

                            if($isData2->identitas == 'pembimbing'){
                                $datas = array (
                                    'id_kp'                     => $idkp,
                                    'nim'                       => $nim,
                                    'stat_penilaian_pembimbing' => 1,
                                    // 'create_date'               => $this->STORAGE_NOW(),
                                );
    
                                $result         = $model->saveGlobal($datas, 'sipenkp_nilai_mahasiswa', true);
                                // print_r($result);die;
                                
                                if($result->code == $result::CODE_SUCCESS){
                                    $arrayData      = array();
                                    foreach ($isData as $key => $value) {
                                        // echo "$key => $value\n";
                                        
                                        if($key != 'totalbobot'){
                                            $arrayData[$key] = $value;
                                        }
                                        
                                    }
                                    $tables      = 'sipenkp_penilaian_pembimbing';
                                    $ididentity  = self::antiInjection($isData2->ididentitas ?? null);
                                    $identity    = self::antiInjection($isData2->identitas ?? null);
                                    $idnilai     = $result->data;
                                    // $idnilai     = $tblnilai['id_nilai'];
                                    // print_r($identity);die;
                                    $result      = $model->submitnilaipenguji($tables, $arrayData, $idnilai, $user_id, $ididentity, $identity);
                                    // $result      = $model->submitnilaiperusahaan('sipenkp_penilaian_pembimbing', $arrayData, $idnilai, $user_id);
                                }
                                
                                if($result->code == $result::CODE_SUCCESS){
    
                                    $datan = array (
                                        'id_nilai'                  => $idnilai,
                                        'update_date'               => $this->STORAGE_NOW(),
                                        'status_nilai_pembimbing'   => 1,
                                    );
    
                                    $where          = 'id_kp = '.$idkp;
                                    $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                                }

                            } else if($isData2->identitas == 'penguji'){
                                $datas = array (
                                    'id_kp'                     => $idkp,
                                    'nim'                       => $nim,
                                    'stat_penilaian_penguji' => 1,
                                    // 'create_date'               => $this->STORAGE_NOW(),
                                );
    
                                $result         = $model->saveGlobal($datas, 'sipenkp_nilai_mahasiswa', true);
                                // print_r($result);die;
                                
                                if($result->code == $result::CODE_SUCCESS){
                                    $arrayData      = array();
                                    foreach ($isData as $key => $value) {
                                        // echo "$key => $value\n";
                                        
                                        if($key != 'totalbobot'){
                                            $arrayData[$key] = $value;
                                        }
                                        
                                    }
                                    $tables      = 'sipenkp_penilaian_penguji';
                                    $ididentity  = self::antiInjection($isData2->ididentitas ?? null);
                                    $identity    = self::antiInjection($isData2->identitas ?? null);
                                    $idnilai     = $result->data;
                                    // $idnilai     = $tblnilai['id_nilai'];
                                    // print_r($identity);die;
                                    $result      = $model->submitnilaipenguji($tables, $arrayData, $idnilai, $user_id, $ididentity, $identity);
                                    // $result      = $model->submitnilaiperusahaan('sipenkp_penilaian_pembimbing', $arrayData, $idnilai, $user_id);
                                }
                                
                                if($result->code == $result::CODE_SUCCESS){
    
                                    $datan = array (
                                        'id_nilai'                  => $idnilai,
                                        'update_date'               => $this->STORAGE_NOW(),
                                        'status_nilai_penguji'   => 1,
                                    );
    
                                    $where          = 'id_kp = '.$idkp;
                                    $result         = $model->updateGlobal('sipenkp_kerja_praktik', $datan, $where);
                                }
                            }
                            
                        }

                        // 0. load tbl kp, cek status 3 nilai.
                        // 1. load tbl n perusahaan
                        // 2. load tbl n penguji, pembimbing
                        // 3. load tbl n bobot
                        // 4. rumus masukin, hitung nilai, nilai akhir
                        // 5. hasil input ke tabel n_mahasiswa
                        // 6. status kp selesai

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function deletebobotAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                   
                    
                    // print_r($isData);die;

                    
                   
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $arrayData      = array();
                        foreach ($isData as $id) {
                            // echo "$key => $value\n";
                            array_push($arrayData, $id);
                            
                        }
                        
                        // print_r($arrayData);die;
                        
                        $resHeader      = $model->deletebobot('bobot_penilaian', $arrayData);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function resetpassworduserAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            'password'   => self::antiInjection(md5($isData->id ?? null)),
                        );
                        // print_r($dataArr);die;
                        $where          = "username='$isData->id'";
                        
                        $resHeader      = $model->updateGlobal('user_data_header', $dataArr, $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

   

    public function saveprofileAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            'judul'             => ucwords(self::antiInjection($isData->judul ?? null)),
                            'deskripsi'         => self::antiInjection($isData->desk ?? null),
                            'userid'            => $userID,
                            'publish'           => 3,
                            'masa_aktif'        => 2,
                            'batas_isi'         => 1,
                            'limitx'            => 5,
                            'privasix'          => 2,
                            'header_view'       => 1,
                            'header_color'      => '#f9fafb',
                            'back_color'        => '#f5f5f5',   
                            'judul_view'        => 1,
                            'deskripsi_view'    => 1,
                            'layout_size'       => 1,
                            'mandatori'         => 1,
                            'tipe_bobot'        => 1,
                            'bobot_value'       => 100,
                            'sort_data'         => 1,
                            'materi_view'       => 1,
                            'status_soal'       => 2,
                            'type_content'      => self::antiInjection($isData->tpForm ?? null),
                            'end_date'          => $this->STORAGE_NOW(),
                            'update_date'       => $this->STORAGE_NOW(),
                            'create_date'       => $this->STORAGE_NOW(),
                        );
                        
                       
                        $result         = $model->saveGlobal($dataArr, 'order_profile', true);

                        if($result->code == $result::CODE_SUCCESS){
                            
                            $numsL          = 1;
                            $arrLevel       = ['VERY EASY', 'EASY', 'NORMAL', 'HARD', 'VERY HARD'];
                            
                            foreach($arrLevel as $lvl){
                                
                                $isLevelArr = array(
                                    'profileid'     => $result->data,
                                    'level_name'    => $lvl,
                                    'level_value'   => 1,
                                    'level_code'    => $numsL * 10,
                                    'create_date'   => $this->STORAGE_NOW(),
                                );

                                $numsL++;

                                $model->saveGlobal($isLevelArr, 'order_level', true);
                            }

                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadsettingAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);

                        $where          = "id_profile=".$ipoly;
                       
                        $result         = $model->loadGlobal("*", 'order_profile', $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadstatuskpAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim          = self::antiInjection($isData->param ?? null);

                        $where          = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                       
                        $result         = $model->loadGlobal("sipenkp_kerja_praktik", '*', $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function generateformAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* tipe load */
                        $loadtype       = $isData->loadtype ?? 1;

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);


                        if($loadtype == 1){

                            $where          = "profile_id=".$ipoly." ORDER BY sortingx ASC";

                        }else{

                            $where          = "profile_id=".$ipoly." ";

                            // if($isData->status_soal == 1){ // soal active
                            //     $where      .= " AND x_status=1 ";
                            // }

                            if($isData->sort_data == 1){ // sorting
                                $where .= "  ORDER BY  RANDOM()";
                            }else{
                                $where .= "  ORDER BY sortingx ASC";
                            }

                        }
    
                        $result         = $model->loadGlobal("*", 'management_parameter', $where);
                        // print_r($where);die;
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadelequeAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);
                        $lvl            = self::antiInjection($isData->ilvl ?? 0);

                        $result         = $model->getElementQue($ipoly, $lvl);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    private function sort_arr_of_obj($array, $sortby, $direction='asc') {
        
        $sortedArr = array();
        $tmp_Array = array();
        
        foreach($array as $k => $v) {
           
            $tmp_Array[] = strtolower($v->$sortby);
        }
       
        if($direction=='asc'){
            asort($tmp_Array);
        }else{
            arsort($tmp_Array);
        }
    
        foreach($tmp_Array as $k=>$tmp){
            $sortedArr[] = $array[$k];
        }
        
        return $sortedArr;
    
    }

    public function insertmanagementparamAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($adapter, $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $idata          = $isData->idata;
                        $typepoly       = $isData->ipoly;
                        
                        $status         = array();
                        $statusChild    = array();
                        $statusFinal    = array();

                        /* sorting data */
                        $sorted      = $this->sort_arr_of_obj($idata,'position','asc');

                        /* begin */
                        $connect->beginTransaction();

                        $n          = 1;
                        foreach($idata as $item){

                            /* save header */
                            switch ((int) $item->parenttype){
                                case self::INPUTEXT:
                                    
                                    /* cek jenis inputan nya apah */
                                    if((int) $item->parenttyped == 'texts'){ 
                                        $typedatas = 1;
                                    }else if((int) $item->parenttyped == 'numbers'){
                                        $typedatas = 2;
                                    }

                                    $headArray  = array(
                                        'profile_id'        => $typepoly,
                                        'object_type'       => $item->parenttype,
                                        'object_label'      => $item->parentlabel,
                                        'data_type'         => $typedatas,
                                        'sortingx'          => $n,
                                        'has_parent'        => 0, 
                                        'x_status'          => $item->x_status,
                                    );       

                    
                                    if($item->paramsend){ // is update
                                        $arrayMerge = array_merge($headArray, array('update_date' => $this->STORAGE_NOW()));
                                        $where      = "paramid = ".$item->paramsend;
                                        $resHeader  = $model->updateGlobal('management_parameter', $arrayMerge, $where);
                                    }else{
                                        $arrayMerge = array_merge($headArray, array('create_date' => $this->STORAGE_NOW()));
                                        $resHeader  = $model->saveGlobal($arrayMerge, 'management_parameter', true);
                                    }
                                    
                                    if($resHeader->code == $result::CODE_SUCCESS){
                                        $status = array('success');
                                    }else{
                                        $connect->rollback();
                                        array_push($status, array(
                                            'code'  => $resHeader->code,
                                            'info'  => $resHeader->info.' # Terjadi kesalahan insert Header case Input',
                                        ));
                                        break;
                                    }

                                break;

                                case self::TEXTAREA:

                                    $headArray  = array(
                                        'profile_id'        => $typepoly,
                                        'object_type'       => $item->parenttype,
                                        'object_label'      => $item->parentlabel,
                                        'data_type'         => 1,    
                                        'has_parent'        => 0,  
                                        'sortingx'          => $n,    
                                        'x_status'          => $item->x_status,                             
                                    );    
                                
                                    if($item->paramsend){ // is update
                                        $arrayMerge = array_merge($headArray, array('update_date' => $this->STORAGE_NOW()));
                                        $where      = "paramid = ".$item->paramsend;
                                        $resHeader  = $model->updateGlobal('management_parameter', $arrayMerge, $where);
                                    }else{
                                        $arrayMerge = array_merge($headArray, array('create_date' => $this->STORAGE_NOW()));
                                        $resHeader  = $model->saveGlobal($arrayMerge, 'management_parameter', true);
                                    }

                                    if($resHeader->code == $result::CODE_SUCCESS){
                                        $status = array('success');
                                        
                                    }else{
                                        $connect->rollback();
                                        array_push($status, array(
                                            'code'  => $resHeader->code,
                                            'info'  => $resHeader->info.' # Terjadi kesalahan insert Header case Textarea',
                                        ));
                                        break;
                                    }

                                break;
                                
                                case (self::SELECTOPT || RADIONBTN):

                                    $headArray  = array(
                                        'profile_id'        => $typepoly,
                                        'object_type'       => $item->parenttype,
                                        'object_label'      => $item->parentlabel,
                                        'data_type'         => 1,   
                                        'has_parent'        => 0,       
                                        'sortingx'          => $n,      
                                        'x_status'          => $item->x_status,                       
                                    );  
                                
                                
                                    if($item->paramsend){ // is update
                                        $arrayMerge = array_merge($headArray, array('update_date' => $this->STORAGE_NOW()));
                                        $where      = "paramid = ".$item->paramsend;
                                        $resHeader  = $model->updateGlobal('management_parameter', $arrayMerge, $where);
                                    }else{
                                        $arrayMerge = array_merge($headArray, array('create_date' => $this->STORAGE_NOW()));
                                        $resHeader  = $model->saveGlobal($arrayMerge, 'management_parameter', true);
                                    }

                                    if($resHeader->code == $result::CODE_SUCCESS){
                                        $status = array('success');
                                    }else{
                                        $connect->rollback();
                                        array_push($status, array(
                                            'code'  => $resHeader->code,
                                            'info'  => $resHeader->info.' # Terjadi kesalahan insert Header select option',
                                        ));
                                        break;
                                    }
                                    
                                    if($resHeader->code == $result::CODE_SUCCESS){
                                        
                                        if(isset($item->option)){

                                            foreach($item->option as $valSelect){
                                                
                                                if($item->paramsend!= null && $valSelect->paramsendank == ''){
                                                    $headerOptArray = array(
                                                        'profile_id'        => $typepoly,
                                                        'object_type'       => $item->parenttype,
                                                        'object_label'      => $valSelect->optionlabel,
                                                        'object_value'      => $valSelect->optionvalue,
                                                        'has_parent'        => $item->paramsend,
                                                        'data_type'         => 1,
                                                        'create_date'       => $this->STORAGE_NOW(),
                                                        'update_date'       => $this->STORAGE_NOW(),
                                                    );
                                                }else if( $valSelect->paramsendank== '' ){
                                                    $headerOptArray = array(
                                                        'profile_id'        => $typepoly,
                                                        'object_type'       => $item->parenttype,
                                                        'object_label'      => $valSelect->optionlabel,
                                                        'object_value'      => $valSelect->optionvalue,
                                                        'has_parent'        => $resHeader->data,
                                                        'data_type'         => 1,
                                                        'create_date'       => $this->STORAGE_NOW(),
                                                        'update_date'       => $this->STORAGE_NOW(),
                                                    );
                                                }else{
                                                    $headerOptArray = array(
                                                        'paramid'           => $valSelect->paramsendank,
                                                        'profile_id'        => $typepoly,
                                                        'object_type'       => $item->parenttype,
                                                        'object_label'      => $valSelect->optionlabel,
                                                        'object_value'      => $valSelect->optionvalue,
                                                        'has_parent'        => $item->paramsend,
                                                        'data_type'         => 1,
                                                        'create_date'       => $this->STORAGE_NOW(),
                                                        'update_date'       => $this->STORAGE_NOW(),
                                                    );
                                                }


                                                if($valSelect->paramsendank){
                                                    $where         = "paramid = ".$valSelect->paramsendank;
                                                    $resHeaderopt  = $model->updateGlobal('management_parameter', $headerOptArray, $where);
                                                    
                                                }else{
                                                    $resHeaderopt  = $model->saveGlobal($headerOptArray, 'management_parameter', true);
                                                }

                                                if($resHeaderopt->code == $result::CODE_SUCCESS){
                                                    $status = array('success');
                                                }else{
                                                    $connect->rollback();
                                                    array_push($status, array(
                                                        'code'  => $resHeaderopt->code,
                                                        'info'  => $resHeaderopt->info.' # Terjadi kesalahan insert case option/radio',
                                                        'data'  => null
                                                    ));
                                                    break;
                                                }
                                            }
                                        }

                                    }
                                    
                                break;
                                
                                default:
                                    array_push($status, array(
                                        'code'  => 901,
                                        'info'  => '# Terjadi kesalahan TYPE KOSONG',
                                        'data'  => null
                                    ));
                                break;
                            }

                            $n++;
                        }

                        /* sukses save header */
                        if (in_array("success", $status)) {  
                            $connect->commit();                  
                            $result->code = $result::CODE_SUCCESS;
                            $result->info = $result::INFO_SUCCESS;
                            $result->data = 'MANTAPSX';
                            
                        }else{
                            $result->code = $status[0]['code'];
                            $result->info = $status[0]['info'];
                            $result->data = $status[0]['data'];
                        }
                        
                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function deleteparameterAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $paramid        = self::antiInjection($isData->paramid ?? null);

                        $where          = "paramid in (".$paramid.")";
                        
                        $result         = $model->deleteGlobal('management_parameter', $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadquelevelAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);
                        $result         = $model->getQueSort($ipoly);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saverulesoptAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            self::antiInjection($isData->columns ?? null)   => self::antiInjection($isData->isvalue ?? null),
                        );

                        $where          = 'paramid = '.$isData->paramid;
                        
                        $resHeader      = $model->updateGlobal('management_parameter', $dataArr, $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savesortinglevelAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($adapter, $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();
                        
                        $status         = array();
                        foreach($isData->idata as $item){
                            
                            $dataArr = array(
                                'sortingx'  => $item->position + 1,
                            );
                           
                            $where      = "paramid = ".$item->idcategory;
                           
                            $res        = $model->updateGlobal('management_parameter', $dataArr, $where);
                            
                            if($res->code == $result::CODE_SUCCESS){
                                $status = array('success');
                            }else{
                                $connect->rollback();
                                array_push($status, array(
                                    'code'  => $res->code,
                                    'info'  => $res->info.' # Terjadi kesalahan update data',
                                ));
                                break;
                            }

                        }

                        /* sukses save header */
                        if (in_array("success", $status)) {  
                            $connect->commit();                  
                            $result->code = $result::CODE_SUCCESS;
                            $result->info = $result::INFO_SUCCESS;
                            
                        }else{
                            $result->code = $status[0]['code'];
                            $result->info = $status[0]['info'];
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadlevelAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);

                        $where          = "profileid=".$ipoly." ORDER BY levelid ASC";

                        $result         = $model->loadGlobal("*", 'order_level', $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savepointbobotsAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ 

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($adapter, $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);
                        
                        /* begin */
                        $connect->beginTransaction();
                        
                        $status         = array();

                        /* update profile header */
                        $dataArr = array(
                            'bobot_value'  => self::antiInjection($isData->DefaultVal ?? 0),
                            'update_date'  => $this->STORAGE_NOW(),
                        );
                       
                        $where      = "id_profile = ".self::antiInjection($isData->ProfileID ?? null);
                       
                        $res        = $model->updateGlobal('order_profile', $dataArr, $where);

                        if($res->code == $result::CODE_SUCCESS){
                            
                            /* save level poin bobot */
                            foreach($isData->actPoinLevel as $poin){
                                
                                $arrLevel = array(
                                    'level_value'   => self::antiInjection($poin->this_val ?? 0),
                                    'update_date'   => $this->STORAGE_NOW(),
                                );

                                $where   = "levelid = ".self::antiInjection($poin->level_id ?? null);

                                $resPoin = $model->updateGlobal('order_level', $arrLevel, $where);

                                if($resPoin->code == $result::CODE_SUCCESS){

                                    $status = array('success');

                                }else{

                                    $connect->rollback();
                                    array_push($status, array(
                                        'code'  => $res->code,
                                        'info'  => $res->info.' # Terjadi kesalahan update level',
                                    ));
                                    break;

                                }

                            }

                        }else{
                            $connect->rollback();
                            array_push($status, array(
                                'code'  => $res->code,
                                'info'  => $res->info.' # Terjadi kesalahan update profile',
                            ));
                        }
                        

                        /* sukses save header */
                        if (in_array("success", $status)) {  
                            $connect->commit();                  
                            $result->code = $result::CODE_SUCCESS;
                            $result->info = $result::INFO_SUCCESS;
                            
                        }else{
                            $result->code = $status[0]['code'];
                            $result->info = $status[0]['info'];
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saverulesetupAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($adapter, $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);
                        
                        /* begin */
                        $connect->beginTransaction();
                        
                        $statusOne      = array('success');
                        $statusTwo      = array('success');
                        $statusTri      = array('success');
                        
                        /* set status soal */
                        if($isData->actSoalArr){

                            foreach($isData->actSoalArr as $item){

                                $dataArr = array(
                                    'x_status'      => self::antiInjection($item->status ?? 2),
                                    'update_date'   => $this->STORAGE_NOW(),
                                );
                               
                                $where      = "paramid = ".self::antiInjection($item->paramid ?? null);
                               
                                $res        = $model->updateGlobal('management_parameter', $dataArr, $where);

                                if($res->code == $result::CODE_SUCCESS){

                                    $statusOne = array('success');

                                }else{

                                    $connect->rollback();
                                    array_push($statusOne, array(
                                        'code'  => $res->code,
                                        'info'  => $res->info.' # Terjadi kesalahan update status',
                                    ));
                                    break;

                                }
                            }

                        }

                        /* set jawaban */
                        if($isData->ansSoalArr){

                            foreach($isData->ansSoalArr as $item){

                                $dataArr = array(
                                    'x_answer'      => self::antiInjection($item->has_parent ?? null),
                                    'update_date'   => $this->STORAGE_NOW(),
                                );
                               
                                $where      = "paramid = ".self::antiInjection($item->paramid ?? null);
                               
                                $res        = $model->updateGlobal('management_parameter', $dataArr, $where);

                                if($res->code == $result::CODE_SUCCESS){

                                    $statusTwo = array('success');

                                }else{

                                    $connect->rollback();
                                    array_push($statusTwo, array(
                                        'code'  => $res->code,
                                        'info'  => $res->info.' # Terjadi kesalahan update jawaban',
                                    ));
                                    break;

                                }
                            }

                        }

                        /* set level */
                        if($isData->levSoalArr){

                            foreach($isData->levSoalArr as $item){

                                $dataArr = array(
                                    'x_difficult'   => self::antiInjection($item->levelcode ?? null),
                                    'update_date'   => $this->STORAGE_NOW(),
                                );
                               
                                $where      = "paramid = ".self::antiInjection($item->paramid ?? null);
                               
                                $res        = $model->updateGlobal('management_parameter', $dataArr, $where);

                                if($res->code == $result::CODE_SUCCESS){

                                    $statusTri = array('success');

                                }else{

                                    $connect->rollback();
                                    array_push($statusTri, array(
                                        'code'  => $res->code,
                                        'info'  => $res->info.' # Terjadi kesalahan update jawaban',
                                    ));
                                    break;

                                }
                            }

                        }
                        
                        /* check status update */
                        $newStatus = array('succcess');

                        if($isData->actSoalArr){
                            if (in_array("success", $statusOne)) { 
                                $newStatus = array('success'); 
                            }else{
                                array_push($newStatus, array(
                                    'code'  => $statusOne[0]['code'],
                                    'info'  => $statusOne[0]['info'],
                                ));
                            }
                        }

                        if($isData->ansSoalArr){
                            if (in_array("success", $statusTwo)) { 
                                $newStatus = array('success'); 
                            }else{
                                array_push($newStatus, array(
                                    'code'  => $statusTwo[0]['code'],
                                    'info'  => $statusTwo[0]['info'],
                                ));
                            }
                        }

                        if($isData->levSoalArr){
                            if (in_array("success", $statusTri)) { 
                                $newStatus = array('success'); 
                            }else{
                                array_push($newStatus, array(
                                    'code'  => $statusTri[0]['code'],
                                    'info'  => $statusTri[0]['info'],
                                ));
                            }
                        }

                        /* sukses save header */
                        if (in_array("success", $newStatus)) {  
                            $connect->commit();                  
                            $result->code = $result::CODE_SUCCESS;
                            $result->info = $result::INFO_SUCCESS;
                            
                        }else{
                            $result->code = $newStatus[0]['code'];
                            $result->info = $newStatus[0]['info'];
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    private function generateRandomCharacter($len = 10){
        $charset    = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        $base       = strlen($charset);
        $result     = '';
      
        $now        = explode(' ', microtime())[1];
        
        while ($now >= $base){
          $i        = $now % $base;
          $result   = $charset[$i] . $result;
          $now     /= $base;
        }
        $ran        = bin2hex(random_bytes(10));
        $stbh       = substr($result, -5);
        
        return $ran.$stbh;
    }

    public function savemateriAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload      = $_FILES['fileupload']['tmp_name'];   
                    
                    if (!empty($fileupload)){
                        
                        /* data upload */
                        $ImageName       = $_FILES['fileupload']['name'];
                        $tipes           = $_FILES['fileupload']['type'];
                        $size            = $_FILES['fileupload']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::generateRandomCharacter();
                        
                        if($tipes == 'video/mp4' || $tipes == 'video/x-matroska'){
                            $uploaddir = './public/data/materi/video/'; // directory file
                            $uploaddis = '/data/materi/video/'; // directory file
                        }else{
                            $uploaddir = './public/data/materi/other/'; // directory file
                            $uploaddis = '/data/materi/other/'; // directory file
                        }
                        
                        $alamatfile    = $uploaddir.$createRanName.$NewImageName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        $dataArr        = array(
                            'createid'      => $user_id,
                            'titles'        => self::antiInjection($this->antiStealth('titleMater') ?? null),
                            'ex_char'       => $this->antiStealth('ex_char') ?? null,
                            'status_ma'     => 1,
                            'create_date'   => $this->STORAGE_NOW(),
                        );

                        $result         = $model->saveGlobal($dataArr, 'materi_data', true);
                        
                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    'idmateri'      => $result->data,
                                    'file_name'     => $createRanName.$NewImageName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                );

                                $result = $model->saveGlobal($dataAtt, 'materi_attachments', true);

                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'MOHON MASUKAN FILE ATTACHMENTS!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    $fileupload2      = $_FILES['fileupload2']['tmp_name'];
                    $fileupload3      = $_FILES['fileupload3']['tmp_name'];
                    $fileupload4      = $_FILES['fileupload4']['tmp_name'];  
                    
                    // print_r(fileup)
                    

                    if (!empty($fileupload1) && !empty($fileupload2) &&  !empty($fileupload3) &&!empty($fileupload4)){
                        
                        /* data upload 1*/
                        $ImageName       = $_FILES['fileupload1']['name'];
                        
                        $tipes           = $_FILES['fileupload1']['type'];
                        $size            = $_FILES['fileupload1']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);
                        // print_r($ImageExt);die;
                        // $createRanName  = self::generateRandomCharacter();
                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file1.'.$ImageExt;
                        // print_r($createRanName);die;

                        $uploaddir = './public/data/berkas/'; // directory file
                        $uploaddis = '/data/berkas/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        // $dataArr        = array(
                        //     'createid'      => $user_id,
                        //     'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                        //     'create_date'   => $this->STORAGE_NOW(),
                        //     'tipe_berkas'   => 'File 1'
                        // );

                        // $result         = $model->saveGlobal($dataArr, 'berkas_mahasiswa', true);

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload1']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
                                // print_r($result);die;
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 2*/
                        $ImageName       = $_FILES['fileupload2']['name'];
                        
                        $tipes           = $_FILES['fileupload2']['type'];
                        $size            = $_FILES['fileupload2']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file2.'.$ImageExt;
                        $alamatfile    = $uploaddir.$createRanName;

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload2']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_2', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 3*/
                        $ImageName       = $_FILES['fileupload3']['name'];
                        
                        $tipes           = $_FILES['fileupload3']['type'];
                        $size            = $_FILES['fileupload3']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file3.'.$ImageExt;
                        $alamatfile    = $uploaddir.$createRanName;

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload3']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_3', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 4*/
                        $ImageName       = $_FILES['fileupload4']['name'];
                        
                        $tipes           = $_FILES['fileupload4']['type'];
                        $size            = $_FILES['fileupload4']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file4.'.$ImageExt;
                        $alamatfile    = $uploaddir.$createRanName;

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload4']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'      => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_4', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){

                            /* jika upload berhasil ke folder sever */
                            $dataAtt = array(
                                // 'nim_mhs'            => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                // 'create_date'    => $this->STORAGE_NOW(),
                                // 'status_upload'  => self::antiInjection( 61 ?? null), //
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 51 ?? null),
                                'isjadwal'      => self::antiInjection( 72 ?? null), //
                            );
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."'";
                            // $result = $model->saveGlobal($dataAtt, 'berkas_mahasiswa', true);
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkassAction(){ // ini bug
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    
                    $laporan = self::antiInjection($this->antiStealth('judul'));
                    // print_r($laporan);die;
                    

                    if (!empty($fileupload1)){
                        
                        /* data upload 1*/
                        $ImageName       = $_FILES['fileupload1']['name'];
                        
                        $tipes           = $_FILES['fileupload1']['type'];
                        $size            = $_FILES['fileupload1']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);
                        // print_r($ImageExt);die;
                        // $createRanName  = self::generateRandomCharacter();
                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file1.'.$ImageExt;
                        // print_r($createRanName);die;

                        $uploaddir = './public/data/berkas/'; // directory file
                        $uploaddis = '/data/berkas/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload1']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
                              
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){

                            /* jika upload berhasil ke folder sever */
                            $dataAtt = array(
                             
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 51 ?? null),
                                'isjadwal'      => self::antiInjection( 72 ?? null), //
                            );
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."'";
   
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){

                           
                            $dataAttr = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'judul_laporan'  => self::antiInjection($this->antiStealth('judul')),
                               
                            );
                            $where = "nim = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."'";
                            // print_r($dataAttr);die;
                            $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataAttr, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasssAction(){ // ini save berkas baru
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    
                    $laporan = self::antiInjection($this->antiStealth('judul'));
                    // print_r($laporan);die;
                    

                    if (!empty($fileupload1)){
                        
                        /* data upload 1*/
                        $ImageName       = $_FILES['fileupload1']['name'];
                        
                        $tipes           = $_FILES['fileupload1']['type'];
                        $size            = $_FILES['fileupload1']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);
                        // print_r($ImageExt);die;
                        // $createRanName  = self::generateRandomCharacter();
                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file1.'.$ImageExt;
                        // print_r($createRanName);die;

                        $uploaddir = './public/data/berkas/'; // directory file
                        $uploaddis = '/data/berkas/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = self::antiInjection($this->antiStealth('nimMhs') ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];

                        
                        // print_r($idberkas);die;
                        /* begin */ //disini gann
                        $connect->beginTransaction();

                        

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload1']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    'idberkas'      => $idberkas,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
                              
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){

                            /* jika upload berhasil ke folder sever */
                            $dataAtt = array(
                             
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 51 ?? null),
                                'isjadwal'      => self::antiInjection( 72 ?? null), //
                            );
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND idberkas = $idberkas";
   
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){

                           
                            $dataAttr = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'judul_laporan'  => self::antiInjection($this->antiStealth('judul')),
                               
                            );
                            $where = "nim = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' and id_kp = $idkp";
                            // print_r($dataAttr);die;
                            $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataAttr, $where);
    
                        }
                        // print_r($result->code);die;

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function updateberkassAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    
                    $laporan = self::antiInjection($this->antiStealth('judul'));
                    // print_r($laporan);die;
                    

                    if (!empty($fileupload1)){
                        
                        /* data upload 1*/
                        $ImageName       = $_FILES['fileupload1']['name'];
                        
                        $tipes           = $_FILES['fileupload1']['type'];
                        $size            = $_FILES['fileupload1']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);
                        // print_r($ImageExt);die;
                        // $createRanName  = self::generateRandomCharacter();
                        $createRanName  =   self::antiInjection($this->antiStealth('nimMhs')).'_file1.'.$ImageExt;
                        // print_r($createRanName);die;

                        $uploaddir = './public/data/berkas/'; // directory file
                        $uploaddis = '/data/berkas/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = $this->antiStealth('nimMhs');
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];

                        // print_r($loadidkp);die;
                        /* begin */
                        $connect->beginTransaction();

                        

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload1']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    // 'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'update_date'   => $this->STORAGE_NOW(),
                                    // 'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
                                
                                $nim   = $this->antiStealth('nimMhs');
                                $where = "nim = '$nim' AND idberkas = $idberkas";
                                // $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
                                $result = $model->updateGlobal( 'sipenkp_berkas', $dataAtt, $where);
                                // print_r($result->code);die;
                              
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){

                            /* jika upload berhasil ke folder sever */
                            $dataAtt = array(
                             
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 51 ?? null),
                                // 'isjadwal'      => self::antiInjection( 72 ?? null), //
                            );
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND idberkas = $idberkas";
   
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){

                           
                            $dataAttr = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                // 'judul_laporan'  => self::antiInjection($this->antiStealth('judul')),
                               
                            );
                            $where = "nim = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND id_kp = $idkp";
                            // print_r($dataAttr);die;
                            $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataAttr, $where);
    
                        }
                        

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasmahasiswaAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    $fileupload2      = $_FILES['fileupload2']['tmp_name'];
                    $fileupload3      = $_FILES['fileupload3']['tmp_name'];
                    $fileupload4      = $_FILES['fileupload4']['tmp_name'];  
                    // print_r("File 2".$fileupload2."File 3".$fileupload3."File 4".$fileupload4);die;

                    if (!empty($fileupload1) && !empty($fileupload2) &&  !empty($fileupload3) &&!empty($fileupload4)){
                        
                        /* data upload 1*/
                        $ImageName       = $_FILES['fileupload1']['name'];
                        
                        $tipes           = $_FILES['fileupload1']['type'];
                        $size            = $_FILES['fileupload1']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_file1.'.$ImageExt;
                        
                        $uploaddir = './public/data/berkas/'; // directory file
                        $uploaddis = '/data/berkas/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName;

                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        // $dataArr        = array(
                        //     'createid'      => $user_id,
                        //     'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                        //     'create_date'   => $this->STORAGE_NOW(),
                        //     'tipe_berkas'   => 'File 1'
                        // );

                        // $result         = $model->saveGlobal($dataArr, 'berkas_mahasiswa', true);

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload1']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
                                // print_r($dataAtt);die;
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 2*/
                        $ImageName       = $_FILES['fileupload2']['name'];
                        
                        $tipes           = $_FILES['fileupload2']['type'];
                        $size            = $_FILES['fileupload2']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_file2.'.$ImageExt;
                        $alamatfile    = $uploaddir.$createRanName;
                        // $dataArr        = array(
                        //     'createid'      => $user_id,
                        //     'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                        //     'create_date'   => $this->STORAGE_NOW(),
                        //     'tipe_berkas'   => 'File 2'
                        // );

                        // $result         = $model->saveGlobal($dataArr, 'berkas_mahasiswa', true);

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload2']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_2', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 3*/
                        $ImageName       = $_FILES['fileupload3']['name'];
                        
                        $tipes           = $_FILES['fileupload3']['type'];
                        $size            = $_FILES['fileupload3']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_file3.'.$ImageExt;
                        $alamatfile     = $uploaddir.$createRanName;
                        // $dataArr        = array(
                        //     'createid'      => $user_id,
                        //     'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                        //     'create_date'   => $this->STORAGE_NOW(),
                        //     'tipe_berkas'   => 'File 3'
                        // );

                        // $result         = $model->saveGlobal($dataArr, 'berkas_mahasiswa', true);

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload3']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_3', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        /* data upload 4*/
                        $ImageName       = $_FILES['fileupload4']['name'];
                        
                        $tipes           = $_FILES['fileupload4']['type'];
                        $size            = $_FILES['fileupload4']['size'];

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        // print_r($ImageName);die;
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_file4.'.$ImageExt;
                        $alamatfile    = $uploaddir.$createRanName;
                        // $dataArr        = array(
                        //     'createid'      => $user_id,
                        //     'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                        //     'create_date'   => $this->STORAGE_NOW(),
                        //     'tipe_berkas'   => 'File 4'
                        // );

                        // $result         = $model->saveGlobal($dataArr, 'berkas_mahasiswa', true);

                        if($result->code == $result::CODE_SUCCESS){

                            if (move_uploaded_file($_FILES['fileupload4']['tmp_name'],$alamatfile)){

                                /* jika upload berhasil ke folder sever */
                                $dataAtt        = array(
                                    'createid'      => $user_id,
                                    // 'idberkas'      => $result->data,
                                    'file_name'     => $createRanName,
                                    'file_type'     => $tipes,
                                    'file_size'     => $size / 1000000, // as mb
                                    'file_dir'      => $uploaddis,
                                    'file_dir_c'    => $alamatfile,
                                    'file_ext'      => $ImageExt,
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'nim'      => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                );
    
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas_4', true);
    
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }

                        }

                        if($result->code == $result::CODE_SUCCESS){
                            
                            $dataAtt = array(
                                // 'nim_mhs'        => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                // 'create_date'    => $this->STORAGE_NOW(),
                                // 'status_upload'  => self::antiInjection( 61 ?? null), //
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 53 ?? null), //
                            );
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."'";
                            // $result = $model->saveGlobal($dataAtt, 'berkas_mahasiswa', true);
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
                            // print_r()
    
                        }

                        

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasmahasiswaaAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   
                    // print_r($this->antiStealth('role'));die;
                    $arrayName        = ['Laporan KP', 'Daftar Hadir', 'Penilaian Perusahaan'];
                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; 
                    $fileupload2      = $_FILES['fileupload2']['tmp_name']; 
                    $fileupload3      = $_FILES['fileupload3']['tmp_name']; 

                    $role             = $this->antiStealth('role');
                    if (!empty($fileupload1) && !empty($fileupload2) && !empty($fileupload3)){
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $connect->beginTransaction();
                        for($i = 0; $i < count($arrayName); $i++ ){
                            /* data upload 1*/
                            $ImageName       = $_FILES['fileupload'.($i+1)]['name'];
                            $tipes           = $_FILES['fileupload'.($i+1)]['type'];
                            $size            = $_FILES['fileupload'.($i+1)]['size'];

                            $userSession    = $this->getSession();
            
                            $user_id 		= $userSession->get('user_id');

                            $timeName       = microtime(true);
                            $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                                
                            $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                            $ImageExt       = str_replace('.','',$ImageExt); // Extension
                            $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                            // print_r($ImageName);die;
                            $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                            $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_'.$arrayName[$i].'.'.$ImageExt;
                            
                            $uploaddir = './public/data/berkas/'; // directory file
                            $uploaddis = '/data/berkas/'; // directory file
                            
                            $alamatfile    = $uploaddir.$createRanName;

                            /* save data ke db */
                            $nim            = self::antiInjection($this->antiStealth('nimMhs') ?? null);
                            $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                            
                            $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                            $idkp           = $loadidkp->data[0]['id_kp'];
                            $idberkas       = $loadidkp->data[0]['id_berkas'];

                            if($result->code == $result::CODE_SUCCESS){

                                if (move_uploaded_file($_FILES['fileupload'.($i+1)]['tmp_name'],$alamatfile)){

                                    /* jika upload berhasil ke folder sever */
                                    $dataAtt        = array(
                                        'createid'      => $user_id,
                                        'idberkas'      => $idberkas,
                                        'file_name'     => $createRanName,
                                        'file_type'     => $tipes,
                                        'file_size'     => $size / 1000000, // as mb
                                        'file_dir'      => $uploaddis,
                                        'file_dir_c'    => $alamatfile,
                                        'file_ext'      => $ImageExt,
                                        'create_date'   => $this->STORAGE_NOW(),
                                        'nim'           => self::antiInjection($this->antiStealth('nimMhs') ?? null),
                                    );
                                    
                                    $result = $model->saveGlobal($dataAtt, 'sipenkp_berkas', true);
        
                                }else{
                                    $result->code = 17;
                                    $result->info = 'FAILED UPLOAD FILE to SERVER';
                                }
                            }
                        }
                        // print_r($result);die;

                        if($result->code == $result::CODE_SUCCESS){
                            
                            if($role == 10){ // admin
                                $dataAtt = array(
                                    'update_date'    => $this->STORAGE_NOW(),
                                    'isvalidtu'      => self::antiInjection( 51 ?? null),
                                    'isjadwal'      => self::antiInjection( 72 ?? null), //
                                );
                            }else{ // mahasiswa
                                $dataAtt = array(
                                    'update_date'    => $this->STORAGE_NOW(),
                                    'isvalidtu'      => self::antiInjection( 53 ?? null), //
                                );
                            }
                            

                            
                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND idberkas = $idberkas";
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
    
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $dataAttr = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'judul_laporan'  => self::antiInjection($this->antiStealth('judul')),
                               
                            );
                            $where = "nim = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND id_kp = $idkp";
                            $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataAttr, $where);
    
                        }

                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function updateberkasmahasiswaAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   
                    
                    $role             = $this->antiStealth('role');
                    // print_r($role);die;
                    $arrayName        = array();
                    $numbfile         = array();
                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; //Laporan KP
                    $fileupload2      = $_FILES['fileupload2']['tmp_name']; //Daftar Hadir
                    $fileupload3      = $_FILES['fileupload3']['tmp_name']; //Penilaian Perusahaan
                    
                    if(!empty($fileupload1)){
                        array_push($arrayName, "Laporan KP");
                        array_push($numbfile, 1);
                    }
                    if(!empty($fileupload2)){
                        array_push($arrayName, "Daftar Hadir");
                        array_push($numbfile, 2);
                    }
                    if(!empty($fileupload3)){
                        array_push($arrayName, "Penilaian Perusahaan");
                        array_push($numbfile, 3);
                    }

                    
                    if (!empty($fileupload1) || !empty($fileupload2) || !empty($fileupload3)){
                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $connect->beginTransaction();

                        for($i = 0; $i < count($arrayName); $i++){
                            $ImageName       = $_FILES['fileupload'.$numbfile[$i]]['name'];
                            $tipes           = $_FILES['fileupload'.$numbfile[$i]]['type'];
                            $size            = $_FILES['fileupload'.$numbfile[$i]]['size'];

                            $userSession    = $this->getSession();
            
                            $user_id 		= $userSession->get('user_id');

                            $timeName       = microtime(true);
                            $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                                
                            $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                            $ImageExt       = str_replace('.','',$ImageExt); // Extension
                            $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                            
                            $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                            $createRanName  = self::antiInjection($this->antiStealth('nimMhs')).'_'.$arrayName[$i].'.'.$ImageExt;
                            
                            $uploaddir = './public/data/berkas/'; // directory file
                            $uploaddis = '/data/berkas/'; // directory file
                            
                            $alamatfile    = $uploaddir.$createRanName;

                            
                            $nim            = self::antiInjection($this->antiStealth('nimMhs') ?? null);
                            $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                            
                            $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                            $idkp           = $loadidkp->data[0]['id_kp'];
                            $idberkas       = $loadidkp->data[0]['id_berkas'];
                            
                            /* begin */

                            if($result->code == $result::CODE_SUCCESS){

                                if (move_uploaded_file($_FILES['fileupload'.$numbfile[$i]]['tmp_name'],$alamatfile)){

                                    /* jika upload berhasil ke folder sever */
                                    $dataAtt        = array(
                                        'file_name'     => $createRanName,
                                        'file_type'     => $tipes,
                                        'file_size'     => $size / 1000000, // as mb
                                        'file_dir'      => $uploaddis,
                                        'file_dir_c'    => $alamatfile,
                                        'file_ext'      => $ImageExt,
                                        'update_date'   => $this->STORAGE_NOW(),
                                        
                                    );
                                    
                                    $nim = self::antiInjection($this->antiStealth('nimMhs'));
                                    $where  = "nim = '$nim' AND idberkas = $idberkas AND file_name ILIKE '%".$arrayName[$i]."%'"; 
                                    $result = $model->updateGlobal( 'sipenkp_berkas', $dataAtt, $where);
        
                                }else{
                                    $result->code = 17;
                                    $result->info = 'FAILED UPLOAD FILE to SERVER';
                                }

                            }
                        }
                        
                        if($result->code == $result::CODE_SUCCESS){
                            if($role == 10){ // admin
                                $dataAtt = array(
                                    'update_date'    => $this->STORAGE_NOW(),
                                    'isvalidtu'      => self::antiInjection( 51 ?? null),
                                    'isjadwal'      => self::antiInjection( 72 ?? null), //
                                );
                            }else{ // mahasiswa
                                $dataAtt = array(
                                    'update_date'    => $this->STORAGE_NOW(),
                                    'isvalidtu'      => self::antiInjection( 53 ?? null), //
                                );
                            }

                            $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND idberkas = $idberkas";
                            $result = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $dataAttr = array(
                                'update_date'    => $this->STORAGE_NOW(),
                            );

                            $where = "nim = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."' AND id_kp = $idkp";
                            $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataAttr, $where);
    
                        }

                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function savemahasiswaAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
 
                         /* begin */
                        $connect->beginTransaction();

                    
                        $dataArr        = array(
                            'create_date'       => $this->STORAGE_NOW(),
                            'nim'               => self::antiInjection($isData->nimmhs ?? null),
                            'nama'              => self::antiInjection($isData->namamhs ?? null),
                            'jurusan'           => self::antiInjection($isData->jurusan ?? null),
                            'jeniskelamin'      => self::antiInjection($isData->gender ?? null),
                            'email'             => self::antiInjection($isData->email ?? null),
                        );
                        
                        // save ke tbl mahasiswa
                        $result         = $model->saveGlobal($dataArr, 'mahasiswa', true);
                        
                        if($result->code == $result::CODE_SUCCESS){
                            // save ke tbl user
                            $dataArrUser    = array(
                                'create_dtm'        => $this->STORAGE_NOW(),
                                'username'          => self::antiInjection($isData->nimmhs ?? null),
                                'name'              => self::antiInjection($isData->namamhs ?? null),
                                'password'          => self::antiInjection(md5($isData->nimmhs ?? null)),
                                'status'            => 10,
                                'role'              => 20,
                            );
                            $result         = $model->saveGlobal($dataArrUser, 'user_data_header', true);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            // save ke tbl user
                            $tabel = 'berkas_mahasiswa';
                            $dataAtt = array(
                                'nim_mhs'        => self::antiInjection($isData->nimmhs?? null),
                                'create_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 62 ?? null), //
                            );
                            
                            $result = $model->saveGlobal($dataAtt, $tabel, true);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function updatepembimbingAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
 
                         /* begin */
                        $connect->beginTransaction();

                    
                        $dataArr        = array(
                            'update_date'       => $this->STORAGE_NOW(),
                            'no_peg'            => self::antiInjection($isData->nope ?? null),
                        );
                        // print_r($dataArr);die;
                        
                        // save ke tbl mahasiswa
                        $where  = "nim = '$isData->nim'";
                        $result = $model->updateGlobal('sipenkp_pembimbing', $dataArr, $where);
                        
                        // $result         = $model->saveGlobal($dataArr, 'sipenkp_pembimbing', true);

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function pilihpembimbingAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = self::antiInjection($isData->nim ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];
                        // print_r($idkp);die;
 
                         /* begin */
                        $connect->beginTransaction();

                    
                        $dataArr        = array(
                            'create_date'       => $this->STORAGE_NOW(),
                            'nim'               => self::antiInjection($isData->nim ?? null),
                            'no_peg'            => self::antiInjection($isData->nope ?? null),
                            'status_pembimbing' => self::antiInjection(130 ?? null),
                        );
                        // print_r($dataArr);die;
                        
                        // save ke tbl mahasiswa
                        $result         = $model->saveGlobal($dataArr, 'sipenkp_pembimbing', true);
                        // print_r($result->code);die;
                        //disini tambahin table kp/

                        if($result->code == $result::CODE_SUCCESS){
                            // save ke tbl kerja praktik
                            $tabel = 'sipenkp_kerja_praktik';
                            $dataAtt = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'id_pembimbing'  => $result->data, //
                            );
                            // print_r($dataAtt);die;
                            $where  = "nim = '$isData->nim' AND id_kp = $idkp";
                            // print_r($where);die;
                            $result = $model->updateGlobal($tabel, $dataAtt, $where);
                            // $result = $model->saveGlobal($dataAtt, $tabel, true);
                            // print_r($result);die;
                            // print_r($result->code);die;
                        }
                        // print_r($result->code);die;
                        
                        if($result->code == $result::CODE_SUCCESS){
                            // save ke tbl berkas mhsw
                            $tabel = 'sipenkp_berkas_mahasiswa';
                            $dataAtt = array(
                                'nim_mhs'        => self::antiInjection($isData->nim?? null),
                                'create_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 62 ?? null), //
                            );
                            
                            $result = $model->saveGlobal($dataAtt, $tabel, true);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            // save ke tbl kerja praktik
                            $tabel = 'sipenkp_kerja_praktik';
                            $dataAtt = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'id_berkas'      => $result->data, //
                            );

                            $where  = "nim = '$isData->nim' AND id_kp = $idkp";
                            $result = $model->updateGlobal($tabel, $dataAtt, $where);
                            // print_r($result);die;
                            // $result = $model->saveGlobal($dataAtt, $tabel, true);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }


    public function savemahasiswabymAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
 
                         /* begin */
                        $connect->beginTransaction();
                    
                        $dataArr        = array(
                            
                            'create_date'       => $this->STORAGE_NOW(),
                            'nim'               => self::antiInjection($isData->nimmhs ?? null),
                            'nama'              => self::antiInjection($isData->namamhs ?? null),
                            'jurusan'           => self::antiInjection($isData->jurusan ?? null),
                            'jeniskelamin'      => self::antiInjection($isData->gender ?? null),
                            
                        );
                        // print_r($dataArr);die;  
                        // save ke tbl mahasiswa
                        $result         = $model->saveGlobal($dataArr, 'mahasiswa', true);

                        
                        if($result->code == $result::CODE_SUCCESS){
                            /* jika upload berhasil ke folder sever */
                            $tabel = 'berkas_mahasiswa';
                            $dataAtt = array(
                                'nim_mhs'            => self::antiInjection($isData->nimmhs?? null),
                                'create_date'    => $this->STORAGE_NOW(),
                                
                                'isvalidtu'      => self::antiInjection( 62 ?? null), //
                            );
                            // $where = "nim_mhs = '".self::antiInjection($this->antiStealth('nimMhs') ?? null)."'";
                            // $result = $model->saveGlobal($dataAtt, 'berkas_mahasiswa', true);
                            $result = $model->saveGlobal($dataAtt, $tabel, true);
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savebobotAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        $dataArr        = array(
                            'create_date'       => $this->STORAGE_NOW(),
                            'nama_bobot'        => self::antiInjection($isData->nama_bobot ?? null),
                            'code_penilaian'    => self::antiInjection($isData->jenis_bobot ?? null),
                            'bobot'             => self::antiInjection($isData->jumlah_bobot ?? null),
                        );
                        
                        // save ke tbl bobot_penilaian
                        $result         = $model->saveGlobal($dataArr, 'sipenkp_bobot_penilaian', true);

                       

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savenilaiakhirAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        
                        $connect->beginTransaction();
                        // $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        // $model   	    = new \Application\Model\Param($storage);
                        
                        $nilaimutu = '';

                        if($isData->nilai_akhir >= 80){
                            $nilaimutu = "A";
                        } else if($isData->nilai_akhir >= 75 && $isData->nilai_akhir < 80){
                            $nilaimutu = "AB";
                        } else if($isData->nilai_akhir >= 68 && $isData->nilai_akhir < 75){
                            $nilaimutu = "B";
                        } else if($isData->nilai_akhir >= 64 && $isData->nilai_akhir < 68){
                            $nilaimutu = "BC";
                        }else {
                            $nilaimutu = "C";
                        } 

                        $dataArr        = array(
                            'nilai_akhir'       => self::antiInjection($isData->nilai_akhir ?? null),
                            'nilai_mutu'        => self::antiInjection($nilaimutu ?? null),
                            'isnilaicount'      => self::antiInjection(1 ?? null),
                            
                        );
                        
                        // save ke tbl bobot_penilaian
                        $where  = "id_kp = ".$isData->idkp;
                        $result = $model->updateGlobal('sipenkp_nilai_mahasiswa', $dataArr, $where);

                        if($result->code == $result::CODE_SUCCESS){
                            $dataup = array(
                                'status_kp' => self::antiInjection(122 ?? null),
                                'update_date' => $this->STORAGE_NOW(),
                            ); //kumahasia
                            $where  = "id_kp = ".$isData->idkp;
                            $result = $model->updateGlobal('sipenkp_kerja_praktik', $dataup, $where);

                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saveuserAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    
                        // $dataArr        = array(
                        //     // 'judul'             => ucwords(self::antiInjection($isData->judul ?? null)),
                        //     // 'deskripsi'         => self::antiInjection($isData->desk ?? null),
                        //     // 'userid'            => $userID,
                        //     'create_date'       => $this->STORAGE_NOW(),
                        //     'nim'               => self::antiInjection($isData->nimmhs ?? null),
                        //     'nama'              => self::antiInjection($isData->namamhs ?? null),
                        //     'jurusan'           => self::antiInjection($isData->jurusan ?? null),
                        //     'jeniskelamin'      => self::antiInjection($isData->gender ?? null),
                        //     'fakultas'          => self::antiInjection($isData->facultas ?? null),
                        // );
                        
                        // save ke tbl mahasiswa
                        // $result         = $model->saveGlobal($dataArr, 'mahasiswa', true);

                        // save ke tbl user
                        $dataArrUser    = array(
                            'create_dtm'        => $this->STORAGE_NOW(),
                            'username'          => self::antiInjection($isData->username ?? null),
                            'name'              => self::antiInjection($isData->nama ?? null),
                            'password'          => self::antiInjection(md5($isData->username ?? null)),
                            'status'            => 10,
                            
                        );
                        //ckuaks
                        if($isData->role == 10){
                            $array_merge = array_merge($dataArrUser, array('role'   => 10));
                        } else if ($isData->role == 20){
                            $array_merge = array_merge($dataArrUser, array('role'   => 20));
                        } else if ($isData->role == 30){
                            $array_merge = array_merge($dataArrUser, array('role'   => 30));
                        }

                        $result         = $model->saveGlobal($array_merge, 'user_data_header', true);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saveketAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);
                    

                        // save ke tbl user
                        $dataArr    = array( 
                            'keterangan'        => self::antiInjection($isData->keterangan ?? null),
                            'update_date'       => $this->STORAGE_NOW(),
                        );
                        //ckuaks disini
                        
                        $where  = "id_kp = ".self::antiInjection($isData->idkp);
                        // print_r($where);die;
                        $result = $model->updateGlobal('sipenkp_kerja_praktik', $dataArr, $where);
                        // $result         = $model->saveGlobal($array_merge, 'sipenkp_kerja_praktik', true);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadpartialmateriAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        $col =  array(
                            0   	=>  'md.idmateri',
                            1   	=>  'file_name',
                            2   	=>  'titles',
                            3   	=>  'file_size',
                            4   	=>  'create_date',
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->getMateriPartial($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function dosenlistAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'id_dosen',
                            1   	=>  'nama_dosen',
                            2   	=>  'fakultas',
                            3   	=>  'jurusan',
                            4   	=>  'jenis_kelamin',
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loaddosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function mahasiswalistAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'nim',
                            2   	=>  'nama',
                            3       =>  'jurusan', 
                            4       =>  'statusvalid', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loadMahasiswaS($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function daftarmahasiswaAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'nim',
                            1   	=>  'nim',
                            2   	=>  'nama',
                            3       =>  'nama_prodi', 
                            4       =>  'email', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->daftarMahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listbimbinganAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'kp.nim',
                            1   	=>  'kp.nim',
                            2   	=>  'm.nama',
                            3       =>  'kp.judul_laporan', 
                            4       =>  'approve_proses_bimbingan'
                            
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        $nopeg          = $isData->nopeg;
                        

                        
                        $result         = $model->listbimbingan($nopeg, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaduserlistAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'iduser',
                            1   	=>  'name',
                            2   	=>  'username',
                            3       =>  'role', 
                            4       =>  'status', 
                            5       =>  'iduser', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loaduserlist($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listpengajuanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = $userSession->get('usernamed');
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'id_pengajuan',
                            1   	=>  'nama_perusahaan',
                            2   	=>  'alamat_perusahaan',
                            3       =>  'nama_penerima_perusahaan', 
                            4       =>  'status', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->listpengajuan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listperusahaanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = $userSession->get('usernamed');
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'COUNT(p.nama_perusahaan_kp)',
                            1   	=>  'nama_perusahaan_kp',
                            2   	=>  'alamat',
                            3       =>  'no_telp', 
                            4       =>  'jumlah_mahasiswa', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($order);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->listperusahaan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listpengajuanfadmAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = null;
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'id_pengajuan',
                            1       =>  'nama',
                            2   	=>  'nama_perusahaan',
                            3   	=>  'alamat_perusahaan',
                            4       =>  'nama_penerima_perusahaan', 
                            5       =>  'status', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->listpengajuan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                // print_r(json_encode($result->data));die;
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listpilihpembimbingAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = null;
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    $iskoordinator  = $userSession->get('koordinator');
                    // print_r($userSession->get('koordinator'));die;

                    // if($iskoordinator != null){
                    //     print_r("adaan gan");
                    // }else{
                    //     print_r("gaadaan gan");
                    // }
                    // die;
                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        // print_r($isData->kodeprodi);die;
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;
                        $kodeprodi = self::antiInjection($isData->kodeprodi ?? null);
                        // print_r($kodeprodi);die;

                        $col =  array(
                            0   	=>  'id_kp',
                            1       =>  'nim',
                            2   	=>  'nama',
                            3   	=>  'nama_prodi',
                            4       =>  'nama_dosen', 
                            5       =>  'status_pembimbing', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->listpilihpembimbing($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function reviewpengajuanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = null;
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'id_pengajuan',
                            1       =>  'nama',
                            2   	=>  'nama_perusahaan',
                            3   	=>  'alamat_perusahaan',
                            4       =>  'nama_penerima_perusahaan', 
                            5       =>  'status', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->reviewpengajuan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function jadwallistAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        $kodeprodi  = self::antiInjection($isData->kodeprodi ?? null);
                        // print_r($kodeprodi);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nama',
                            // 2       =>  'jurusan',
                            2   	=>  'namapenguji1',
                            3       =>  'dosen_pembimbing', 
                            4       =>  'tanggal', 
                            5       =>  'jam',
                            6       =>  'ruangan', 
                            // 8       =>  'id_mhs'
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loadjadwallist($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;
                                
                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function datanilaiperusahaanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nama',
                            2       =>  'm.nama',
                            3   	=>  'spm.nama_perusahaan_kp',
                            4       =>  'kp.status_nilai_perusahaan', 
                            5       =>  'm.nim', 

                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loadnilaiperusahaan($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function datanilaipengujiAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nim',
                            2       =>  'm.nama',
                            3   	=>  'p2.dosen_pembimbing',
                            // 4       =>  'kp.status_nilai_pembimbing',
                            4       =>  'dp2.namapenguji1',
                            5       =>  'kp.status_nilai_penguji',
                            6   	=>  'm.nim',

                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loadnilaipenguji($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function datanilaipengujiasdsnAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nim',
                            2       =>  'm.nama',
                            3   	=>  'kp.judul_laporan',
                            4       =>  'j.tanggal', 
                            5       =>  'j.jam', 
                            6       =>  'dp2.namapenguji1',
                            7       =>  'kp.status_nilai_penguji',
                            8       =>  'snm.isnilaicount',
                            9       =>  'm.nim',

                        );

                       

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        $peran = $isData->as;
                        $nopeg = $isData->nopeg;
                        $result         = $model->loadnilaipengujiasdsn($peran, $nopeg, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function datanilaipembimbingasdsnAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nim',
                            2       =>  'm.nama',
                            3   	=>  'kp.judul_laporan',
                            4       =>  'j.tanggal', 
                            5       =>  'j.jam', 
                            6       =>  'p2.dosen_pembimbing',
                            7       =>  'kp.status_nilai_pembimbing',
                            8       =>  'm.nim',

                        );

                        

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        // print_r($isData->nopeg);die;
                        $peran = $isData->as;
                        $nopeg = $isData->nopeg;
                        $result         = $model->loadnilaipengujiasdsn($peran, $nopeg, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function datanilaiakhirAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        $kodeprodi  = self::antiInjection($isData->kodeprodi ?? null);
                        // print_r($kodeprodi);die;

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nim',
                            2       =>  'm.nama',
                            3   	=>  'dosen_pembimbing',
                            4       =>  'dosen_penguji', 
                            5       =>  'kp.mulai_kp',
                            6       =>  'j.tanggal', 
                            7       =>  'nm.nilai_akhir', 
                            8       =>  'nm.nilai_mutu', 
                            9       =>  'm.nim', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->datanilaiakhir($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadmhsvalidAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;
                        $kodeprodi  = self::antiInjection($isData->kodeprodi ?? null);

                        $col =  array(
                            0   	=>  'm.nim',
                            1   	=>  'm.nim',
                            2   	=>  'm.nama',
                            3       =>  'jurusan', 
                            4       =>  'isjadwal', 
                            // 5       =>  'jurusan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->loadmhsvalid($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    

    public function savemapmateriAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($adapter, $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $isProfileID    = self::antiInjection($isData->profileid ?? 0);
                        $isIdMateri     = self::antiInjection($isData->idmateri ?? 0);
                        $istatus        = self::antiInjection($isData->istatus ?? 0);
                        
                        if($istatus == 1){ // dia insert

                            /* check data di mapping  materi jika ada maka jangan insert */
                            $whereArr       = array(
                                'profileid' => $isProfileID,
                                'idmateri'  => $isIdMateri,
                            );
    
                            $result         = $model->checkDuplicateData('order_materi', $whereArr, '# Materi sudah dimappingkan. ');
                            
                            /* jika tidak ada yang sama maka insert data */
                            if($result->code == $result::CODE_SUCCESS){
    
                                $dataArr = array(
                                    'profileid'      => $isProfileID,
                                    'idmateri'       => $isIdMateri,
                                    'create_date'    => $this->STORAGE_NOW(),
                                );
                                
                                $result  = $model->saveGlobal($dataArr, 'order_materi', true);
                            }

                        }elseif($istatus == 2){ // dia delete

                            $result = $model->deleteGlobal('order_materi', 'profileid='.$isProfileID.' AND idmateri='.$isIdMateri);

                        }else{
                            $result->code == 999;
                            $result->info == 'Status tidak diketahui';
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadmappingmateriAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);

                        $result         = $model->getMappingMateri($ipoly);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }


    

    public function updateprofilesettingAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);

                        $dataArr        = array(
                            'id_profile'    => $isData->ipoly,
                            'judul'         => $isData->juduls,
                            'deskripsi'     => $isData->deskripsid,
                            'publish'       => $isData->publish,
                            'masa_aktif'    => $isData->masaAktif,
                            'end_date'      => $isData->dateAktif,
                            'batas_isi'     => $isData->batasIsi,
                            'limitx'        => $isData->bLimitx,
                            'privasix'      => $isData->privasi,
                            'header_view'   => $isData->viewheader,
                            'header_color'  => $isData->warnaHead,
                            'back_color'    => $isData->warnaBack,
                            'judul_view'    => $isData->view_judul,
                            'deskripsi_view'=> $isData->view_deskripsi,
                            'layout_size'   => $isData->layoutSize,
                            'tipe_bobot'    => $isData->tipe_bobot,
                            'status_soal'   => $isData->status_soal,
                            'sort_data'     => $isData->sort_data,
                            'materi_view'   => $isData->materi_view,
                            'tipe_kuiz'     => $isData->tipe_kuiz,
                            'update_date'   => $this->STORAGE_NOW(),
                        );
                        
                        $where  = "id_profile = ".$isData->ipoly;
                        
                        $result = $model->updateGlobal('order_profile', $dataArr, $where);

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function checkuserisisurveyAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);
                        
                        $where          = "profile_id=".$ipoly." AND  create_id=".$isUserid." LIMIT 1";
                       
                        $from           = "order_survey ";

                        $result         = $model->loadGlobal("param_id", $from, $where);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savejadwalAction(){
        // die;
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $nim            = self::antiInjection($isData->nim ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];
                        
                        
                        $connect->beginTransaction();

                        $dataArr        = array(
                            'nim_mhs'       => self::antiInjection($isData->nim ?? null),
                            'penguji_1'     => self::antiInjection($isData->penguji1 ?? null),
                            'tanggal'       => self::antiInjection($isData->tanggal ?? null),
                            'jam'           => self::antiInjection($isData->jam ?? null),
                            'ruang'         => self::antiInjection($isData->ruang ?? null),
                            'create_date'   => $this->STORAGE_NOW(),
                        );
                        
                        $result         = $model->saveGlobal($dataArr, 'sipenkp_jadwal', true);
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $dataAttr = array(
                                'update_date'   => $this->STORAGE_NOW(),
                                'id_jadwal'     => $result->data,
                            );
                            $where  = "nim = '".self::antiInjection($isData->nim ?? null)."' AND id_kp = $idkp";
                            $result = $model->updateGlobal('sipenkp_kerja_praktik', $dataAttr, $where); 
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $dataAtt = array(
                                'update_date'   => $this->STORAGE_NOW(),
                                'isjadwal'      => self::antiInjection(71 ?? null),
                            );

                            $where  = "nim_mhs = '".self::antiInjection($isData->nim ?? null)."' AND idberkas = $idberkas";
                            $result = $model->updateGlobal('sipenkp_berkas_mahasiswa', $dataAtt, $where); 
                        }

                        $tglnow = $this->STORAGE_NOW();
                        $urlbase    = $this->urlLedakan();
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                            
                            $result     = $model->sendemail($idkp, $tglnow, $urlbase);
                            
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savejadwalnewAction(){
        // die;
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $connect->beginTransaction();
                        $datamhs        = $isData->allData;
                        // print_r($datamhs);die;
                        $dataAdditional = $isData->allAdditional ?? null;
                        // print_r($dataAdditional);die;
                        $allidkp        = array();
                        for($i = 0; $i < count($datamhs); $i++){
                            // print_r($datamhs[$i]);die;
                            // $nim            = self::antiInjection($isData->nim ?? null);s
                            
                            
                            $timesmin       = 45*$i;
                            $jam            = date('H:i',strtotime('+'.$timesmin.' minutes',strtotime($isData->jam)));

                            // print_r($jam);die;
                            $nim            = $datamhs[$i]->nim_mhs;
                            
                            $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                            
                            $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                            $idkp           = $loadidkp->data[0]['id_kp'];
                            $idberkas       = $loadidkp->data[0]['id_berkas'];
                            
                            array_push($allidkp, $idkp);

                            $dataArr        = array(
                                'nim_mhs'       => self::antiInjection($nim ?? null),
                                'penguji_1'     => self::antiInjection($isData->penguji1 ?? null),
                                'tanggal'       => self::antiInjection($isData->tanggal ?? null),
                                'jam'           => self::antiInjection($jam ?? null),
                                'ruang'         => self::antiInjection($isData->ruang ?? null),
                                'create_date'   => $this->STORAGE_NOW(),
                            );
                            
                            $result         = $model->saveGlobal($dataArr, 'sipenkp_jadwal', true);

                            //save additional penguji
                            if($result->code == $result::CODE_SUCCESS){
                                
                                for($x = 0; $x < count($dataAdditional); $x++){
                                    $dataAttrs = array(
                                        'id_jadwal'       => $result->data,
                                        'create_date'     => $this->STORAGE_NOW(),
                                        'nopeg'           => $dataAdditional[$x]->nopeg_peng_add,
                                    );

                                    $resun = $model->saveGlobal($dataAttrs, "sipenkp_penguji", true);
                                }
                            }
                            
                            if($result->code == $result::CODE_SUCCESS && $resun->code == $result::CODE_SUCCESS){
                                $dataAttr = array(
                                    'update_date'   => $this->STORAGE_NOW(),
                                    'id_jadwal'     => $result->data,
                                );
                                $where  = "nim = '".self::antiInjection($nim ?? null)."' AND id_kp = $idkp";
                                $result = $model->updateGlobal('sipenkp_kerja_praktik', $dataAttr, $where); 
                            }

                            if($result->code == $result::CODE_SUCCESS){
                                $dataAtt = array(
                                    'update_date'   => $this->STORAGE_NOW(),
                                    'isjadwal'      => self::antiInjection(71 ?? null),
                                );

                                $where  = "nim_mhs = '".self::antiInjection($nim ?? null)."' AND idberkas = $idberkas";
                                $result = $model->updateGlobal('sipenkp_berkas_mahasiswa', $dataAtt, $where); 
                            }
                        }

                        $tglnow = $this->STORAGE_NOW();
                        $urlbase    = $this->urlLedakan();
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                            
                            $result     = $model->sendemail($allidkp, $tglnow, $urlbase, "notupdate");
                            
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function updatejadwalAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $nim            = self::antiInjection($isData->nim ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas, id_jadwal', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];
                        // print_r($idkp);die;

                        // print_r($isData->penguji1);die;
                        // $tanggal        =
                        $connect->beginTransaction();

                        $dataArr        = array(
                            'tanggal'       => self::antiInjection($isData->tanggal ?? null),
                            'jam'           => self::antiInjection($isData->jam ?? null),
                            'ruang'         => self::antiInjection($isData->ruang ?? null),
                            'update_date'   => $this->STORAGE_NOW(),   
                            'penguji_1'     => self::antiInjection($isData->penguji1 ?? null)    
                        );

                        
                        $where  = " id_jadwal ='$isData->idjadwal'";
                        
                        $result = $model->updateGlobal('sipenkp_jadwal', $dataArr, $where); 
                        // print_r($result);die;
                        $tglnow = $this->STORAGE_NOW();
                        $urlbase    = $this->urlLedakan();
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();

                            $result = $model->sendemail($idkp, $tglnow, $urlbase, "update");
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function savepengajuanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                   
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        

                        if(count($isData->jmlpengajuan) != 0){
                            $jumlahMahasiswa = $isData->jmlpengajuan;
                            array_push($jumlahMahasiswa, $isData->nim);
                        }else{
                            $jumlahMahasiswa = array();
                            array_push($jumlahMahasiswa, $isData->nim);
                        }

                        $tembusanRaw    = $model->loadGlobal("master_parameter", "param_val1", "param_type = 'TEMBUSAN SURAT'");
                        $tembusan       = $tembusanRaw->data[0]['param_val1'];
			
			$dateAwal  = date_create($isData->tanggalAwal);
			$dateAkhir = date_create($isData->tanggalAkhir); 

                        $connect->beginTransaction();
                        
                        foreach($jumlahMahasiswa as $row){
                            $dataArr        = array(
                                'nim'                           => self::antiInjection($row ?? null),
                                'status_pengajuan'              => self::antiInjection(91 ?? null),
                                'nama_perusahaan'               => self::antiInjection($isData->nama_perusahaan ?? null),  
                                'alamat_perusahaan'             => self::antiInjection($isData->alamat_perusahaan ?? null),
                                'no_telp'                       => self::antiInjection($isData->telp_perusahaan ?? null),
                                'nama_penerima_perusahaan'      => self::antiInjection($isData->penerima_surat ?? null),
                                'tanggal_kerja_praktik_awal'    => self::antiInjection(date_format($dateAwal,"Y/m/d") ?? null),
                                'tanggal_kerja_praktik_akhir'   => self::antiInjection(date_format($dateAkhir ,"Y/m/d") ?? null),
                                'create_date_pengajuan'         => $this->STORAGE_NOW(),
                                'kode_pos'                      => self::antiInjection($isData->pos ?? null),
                                'divisi_penerima'               => self::antiInjection($isData->divisi ?? null),
                                'tembusan'                      => self::antiInjection($tembusan ?? null),
                            );
                            // print_r($dataArr);die;asd
                            $result         = $model->saveGlobal($dataArr, 'sipenkp_pengajuan_mahasiswa', true);
                        }
                        
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function updatepengajuanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $where  = "nim = '$isData->nim' ORDER BY create_date_pengajuan DESC";
                        $datapengajuan  = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "id_pengajuan",$where);
                        $pengajuanmhs   = $datapengajuan->data[0];
                        // print_r($pengajuanmhs);die;
                        // $tanggal        =

			$dateAwal  = date_create($isData->tanggalAwal);
			$dateAkhir = date_create($isData->tanggalAkhir);

                        $connect->beginTransaction();

                        $dataArr        = array(
                            // 'status_pengajuan'              => self::antiInjection(92 ?? null),
                            'nama_perusahaan'               => self::antiInjection($isData->nama_perusahaan ?? null),  
                            'alamat_perusahaan'             => self::antiInjection($isData->alamat_perusahaan ?? null),
                            'no_telp'                       => self::antiInjection($isData->telp_perusahaan ?? null),
                            'nama_penerima_perusahaan'      => self::antiInjection($isData->penerima_surat ?? null),
                            'tanggal_kerja_praktik_awal'    => self::antiInjection(date_format($dateAwal,"Y/m/d") ?? null),
                            'tanggal_kerja_praktik_akhir'   => self::antiInjection(date_format($dateAkhir,"Y/m/d") ?? null),
                            'update_date'                   => $this->STORAGE_NOW(),
                            'kode_pos'                      => self::antiInjection($isData->pos ?? null),
                            'divisi_penerima'               => self::antiInjection($isData->divisi ?? null),
                            
                        );

                        // print_r($dataArr);die;
                        $where = "nim = '$isData->nim' AND id_pengajuan = ".$pengajuanmhs['id_pengajuan'];
                        // save ke tbl mahasiswa
                        // $result         = $model->saveGlobal($dataArr, 'sipenkp_pengajuan_mahasiswa', true);
                        $result         = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataArr, $where);

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function generatesuratAction(){
	
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');
                    $uri     = $this->getRequest()->getUri();
                    $baseurl = sprintf('//%s', $uri->getHost());
                    $urlbase = $this->urlLedakan();
                    
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                    
                        //load mahasiswa batch perusahan sama
                        $where          = "nama_perusahaan = '$isData->perusahaan' AND status_pengajuan = 91 AND tanggal_kerja_praktik_awal = '$isData->tglawal' AND tanggal_kerja_praktik_akhir = '$isData->tglakhir'  limit 6";
                        $databatch      = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "*", $where);
                        $pengajuanbatch = $databatch->data;

                        //load data kpmhs
                        $where          = "id_pengajuan = $isData->id_pengajuan";
                        $datapengajuan  = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "*",$where);
                        $pengajuanmhs   = $datapengajuan->data[0];
                        
                        //load nama mhs
                        $where      = "nim = '$isData->nim'";
                        $datamhs    = $model->loadGlobal("t_mahasiswa", "*",$where);
                        $mahasiswa  = $datamhs->data[0];
                        
                        //load data pegawai kaprodei
                        $code         = substr($isData->nim, 0, 3);
                        $datakpr      = $model->loadataKaprodi($code);
                        $datapegawai  = $datakpr->data[0];

                        //input nosurat
                        $nosurat        = $isData->nomorsurat;
                        $wheresurat     = "nomor_surat = '$nosurat'";
                        $loadnomor      = $model->countGlobal('sipenkp_nomor_surat', '*', $wheresurat);
                        $countnomor     = $loadnomor->data[0]['count'];
                        
                        // $tembusanraw    = $model->loadGlobal("master_parameter", "param_val1", "param_type = 'TEMBUSAN SURAT'");
                        // $tembusan       = $tembusanraw->data[0]['param_val1'];
                        $tembusan       = $isData->tembusan;
                        
                        $letterdate     = $this->STORAGE_NOW();
                        $connect->beginTransaction();
                        if($countnomor == 0){
                            
                            $qrcode  = $model->generatesurat($pengajuanmhs, $datapegawai, $letterdate, $nosurat, $mahasiswa, $pengajuanbatch, $urlbase, $tembusan);
                            // print_r($qrcode);die;
                            $date    = $this->STORAGE_NOW();
                            $tenggat = date('Y-m-d', strtotime($date. ' + 1 month'));
                            $sqlda   = '';
                            if($qrcode->code == $result::CODE_SUCCESS){ // disini di loopbuat update stat pengajuan
                                for($i = 0; $i < count($pengajuanbatch); $i++){
                                    $nim = $pengajuanbatch[$i]['nim'];
                                    $id  = $pengajuanbatch[$i]['id_pengajuan'];
                                    
                                    $dataArr = array(
                                        'status_pengajuan'              => self::antiInjection(92 ?? null),
                                        'update_date'                   => $this->STORAGE_NOW(),
                                        'tenggat_pengajuan'             => $tenggat,
                                        'file_name'                     => $qrcode->data,
                                        'tembusan'                      => $tembusan,
                                    );
                                    
                                    $where      = "nim = '$nim' AND id_pengajuan = '$id'";
                                    $result = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataArr, $where);
                                }
                                
                            } else {
                                $result->code = 4;
                                $result->info = "Gagal Generate Surat";
                            }
                            
                            if($result->code == $result::CODE_SUCCESS){
                                $dataSurat    = array(
                                    'nomor_surat'              => self::antiInjection($isData->nomorsurat ?? null),
                                    'create_date'              => $this->STORAGE_NOW(),
                                );

                                $result     = $model->saveGlobal($dataSurat, 'sipenkp_nomor_surat', true);
                                $id_nosurat = $result->data;
                                if($result->code == $result::CODE_SUCCESS){

                                    for($s = 0; $s < count($pengajuanbatch); $s++){
                                        $nim = $pengajuanbatch[$s]['nim'];
                                        $id  = $pengajuanbatch[$s]['id_pengajuan'];

                                        $arrayUpdate = array(
                                            "id_nosurat" => $id_nosurat,
                                        );

                                        $where      = "nim = '$nim' AND id_pengajuan = '$id'";
                                        $result = $model->updateGlobal("sipenkp_pengajuan_mahasiswa", $arrayUpdate, $where);
                                    }
                                  
                                }
                            }
                        } else {
                            $result->info = 'Nomor Surat Tidak Tersedia';
                            $result->code = 4;
                        }
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function approvalseminarAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        // $tanggal        =
                        $connect->beginTransaction();
                        $date = $this->STORAGE_NOW();
                        //load param(+ param. month)
                        $tenggat = date('Y-m-d', strtotime($date. ' + 1 month'));

                        // print_r($tenggat);die;
                        // // date_format($date,"Y/m/d H:i:s");
                        // $tenggat_pengajuan = $tenggat;
                        $dataArr    = array(
                            'approve_proses_bimbingan'   => self::antiInjection(1 ?? null),
                            'update_date'                => $this->STORAGE_NOW(),
                        );

                        $where      = "nim = '$isData->nim' AND id_kp = '$isData->idkp'";

                        // print_r($where);die;

                        // save ke tbl mahasiswa
                        // $result         = $model->saveGlobal($dataArr, 'sipenkp_pengajuan_mahasiswa', true);
                        $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataArr, $where);
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function konfirmasiperusahaanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;

                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        // $tanggal        =
                        $connect->beginTransaction();
                        

                        if($isData->status == 102){
                            // print_r('102');die;
                            $dataArr    = array(
                                'status_pengajuan'    => self::antiInjection(102 ?? null),
                                'update_date'         => $this->STORAGE_NOW(),
                            );

                            $where      = "nim = '$isData->nim' AND nama_perusahaan = '$isData->perusahaan'";
                            // print_r($where);die;
                            $result     = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataArr, $where);
                        }
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function konfirmasivalidAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   
                    $arrAccStr    = $this->antiStealth('arrAcc');
                    $arrDenyStr   = $this->antiStealth('arrDeny');
                    
                    if($arrDenyStr == null || $arrDenyStr == ""){
                        $arrDeny = array();
                    }else{
                        $arrDeny = explode(",", $arrDenyStr);
                    }
                    
                    
                    if($arrAccStr == null || $arrAccStr == ""){
                        $arrAcc = array();
                    }else{
                        $arrAcc = explode(",", $arrAccStr);
                    }
                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();

                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);

                    $where          = "nama_perusahaan = '".$this->antiStealth('namaper')."' AND status_pengajuan = 92 AND to_char(tanggal_kerja_praktik_awal, 'yyyy-mm-dd') = '".$this->antiStealth('tglawalh')."' AND to_char(tanggal_kerja_praktik_akhir, 'yyyy-mm-dd') = '".$this->antiStealth('tglakhirh')."' AND to_char(create_date_pengajuan, 'yyyy-mm-dd') = '".$this->antiStealth('createdh')."' AND sipenkp_pengajuan_mahasiswa.nim = t_mahasiswa.nim  limit 6";
                    $result         = $model->loadGlobal("sipenkp_pengajuan_mahasiswa, t_mahasiswa", "*", $where);
                    
		    $dateAw         = date_create($this->antiStealth('tglawal'));
		    $dateAk	    = date_create($this->antiStealth('tglakhir'));
		    
		    $dateAwal       = date_format($dateAw, "Y/m/d");
		    $dateAkhir      = date_format($dateAk, "Y/m/d");
		    
                    $connect->beginTransaction();

                    if(count($arrAcc) != 0){
                        $fileupload      = $_FILES['file']['tmp_name'];   
                        
                        /* data upload */
                        $ImageName       = $_FILES['file']['name'];
                        $tipes           = $_FILES['file']['type'];
                        $size            = $_FILES['file']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::generateRandomCharacter();
                        // $tglfolder = date_format($this->STORAGE_NOW(),"d-m-Y");
                        $uploaddir = './public/data/buktiperusahaan/'; // directory file
                        $uploaddis = '/data/buktiperusahaan/'; // directory file
                        
                        
                        $alamatfile    = $uploaddir.$createRanName.".".$ImageExt;
                        $alamatfileC   = $uploaddis.$createRanName.".".$ImageExt;
                        
                        $counter = 0;
                        for($i = 0; $i < count($arrAcc); $i++){
                            $nim            = $arrAcc[$i];
                            $wherekp        = "nim = '$nim' ORDER BY create_date_pengajuan DESC LIMIT 1";
                            
                            $loadidpengajuan       = $model->loadGlobal('sipenkp_pengajuan_mahasiswa', '*', $wherekp);
                            $datapengajuan         = $loadidpengajuan->data[0];
                            $idpengajuan           = $loadidpengajuan->data[0]['id_pengajuan'];
                            
                            $params = $this->antiStealth('paramtype');
                            
                            if ($params == 'admin'){
                                $dataArr = array(
                                    'nama_perusahaan_kp'    => self::antiInjection($this->antiStealth('namaper') ?? null),
                                    'kode_pos'              => self::antiInjection($datapengajuan['kode_pos'] ?? null),
                                    'alamat'                => self::antiInjection($datapengajuan['alamat_perusahaan'] ?? null),
                                    'tanggal_kp_awal'       => self::antiInjection($dateAwal ?? null),
                                    'tanggal_kp_akhir'      => self::antiInjection($dateAkhir ?? null),
                                    'no_telp'               => self::antiInjection($datapengajuan['no_telp'] ?? null),
                                    'create_date' => $this->STORAGE_NOW(),
                                );
                            }
                            
                            $result = $model->saveGlobal($dataArr, 'sipenkp_perusahaan', true);
                            
                            if($result->code == $result::CODE_SUCCESS){
                                
                                if($i == 0){
                                    if (move_uploaded_file($_FILES['file']['tmp_name'],$alamatfile)){
                                        $dataAtt        = array(
                                            'id_perusahaan' => $result->data,
                                            'nim'           => self::antiInjection($nim ?? null),
                                            'create_date'   => $this->STORAGE_NOW(),
                                            'file_path'     => $alamatfileC,
                                            'file_path_c'   => $alamatfile,  
                                        );
                                        
                                        $result = $model->saveGlobal($dataAtt, 'sipenkp_perusahaan_mahasiswa', true);
                                        
                                    }else{
                                        $result->code = 17;
                                        $result->info = 'FAILED UPLOAD FILE to SERVER';
                                    }
                                }else{
                                    $dataAtt        = array(
                                        'id_perusahaan' => $result->data,
                                        'nim'           => self::antiInjection($nim ?? null),
                                        'create_date'   => $this->STORAGE_NOW(),
                                        'file_path'     => $alamatfileC,
                                        'file_path_c'   => $alamatfile,  
                                    );
                                    
                                    $result = $model->saveGlobal($dataAtt, 'sipenkp_perusahaan_mahasiswa', true);
                                    
                                }
                            }  
                            
                            // print_r("Teu asup gan");die;
    
                            if($result->code == $result::CODE_SUCCESS){
                                // print_r("hi");die;
                                if($params == 'admin'){
                                    $dataUpd = array(
                                        'tanggal_kerja_praktik_awal'       => self::antiInjection($dateAwal ?? null),
                                        'tanggal_kerja_praktik_akhir'      => self::antiInjection($dateAkhir ?? null),
                                        'status_pengajuan'                 => 104,
                                        'update_date'                      => $this->STORAGE_NOW(),
                                        'id_perusahaanmhs'                 => $result->data,
                                    );
                                } else {
                                    $dataUpd = array(
                                        'tanggal_kerja_praktik_awal'       => self::antiInjection($dateAwal ?? null),
                                        'tanggal_kerja_praktik_akhir'      => self::antiInjection($dateAkhir ?? null),
                                        'status_pengajuan' => 103,
                                        'update_date'      => $this->STORAGE_NOW(),
                                        'id_perusahaanmhs' => $result->data,
                                    );
                                }
                                
                                $nim        = $arrAcc[$i];
                                $perusahaan = $this->antiStealth('namaper');
                                // print_r($perusahaan);die;
                                $where  = "nim = '$nim' and nama_perusahaan = '$perusahaan'";
                                $result = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataUpd, $where);
                                
                            }
    
                            
                            if($result->code == $result::CODE_SUCCESS){
                                $date   = $this->STORAGE_NOW();
                                $datetest = self::antiInjection($this->antiStealth('tglawal') ?? null);
                                $tenggat = date('Y-m-d', strtotime($datetest. ' + 6 month'));
                      
                                if($params = 'admin'){
                                    $datakp = array(
                                        'nim'           => $arrAcc[$i],
                                        'status_kp'     => self::antiInjection('121'),
                                        'create_date'   => $this->STORAGE_NOW(),
                                        'mulai_kp'      => self::antiInjection($dateAwal ?? null),
                                        'akhir_kp'      => self::antiInjection($dateAkhir ?? null),
                                        'tenggat_kp'    => $tenggat,
                                        'id_pengajuan'  => self::antiInjection($idpengajuan ?? null),
                                        
                                        
                                    );
                                    $result = $model->saveGlobal($datakp, 'sipenkp_kerja_praktik', true);
                                    // print_r($result);die;
                                }
                            }
                        }

                        // print_r($result);die;
                        // foreach($arrAcc as $dMhs){
                            
                        //     $nim            = $dMhs;
                        //     $wherekp        = "nim = '$nim' ORDER BY create_date_pengajuan DESC LIMIT 1";
                            
                        //     $loadidpengajuan       = $model->loadGlobal('sipenkp_pengajuan_mahasiswa', '*', $wherekp);
                        //     $datapengajuan         = $loadidpengajuan->data[0];
                        //     $idpengajuan           = $loadidpengajuan->data[0]['id_pengajuan'];
                            
                        //     $params = $this->antiStealth('paramtype');
                            
                        //     if ($params == 'admin'){
                        //         $dataArr = array(
                        //             'nama_perusahaan_kp'    => self::antiInjection($this->antiStealth('namaper') ?? null),
                        //             'kode_pos'              => self::antiInjection($datapengajuan['kode_pos'] ?? null),
                        //             'alamat'                => self::antiInjection($datapengajuan['alamat_perusahaan'] ?? null),
                        //             'tanggal_kp_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                        //             'tanggal_kp_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                        //             'no_telp'               => self::antiInjection($datapengajuan['no_telp'] ?? null),
                        //             'create_date' => $this->STORAGE_NOW(),
                        //         );
                        //     }
                            
                        //     $result = $model->saveGlobal($dataArr, 'sipenkp_perusahaan', true);
                        //     // print_r($result->code);die;
                        //     if($result->code == $result::CODE_SUCCESS){
                        //         // print_r(" asup gan");die;
                        //         if (move_uploaded_file($_FILES['file']['tmp_name'],$alamatfile)){
                        //             $dataAtt        = array(
                        //                 'id_perusahaan' => $result->data,
                        //                 'nim'           => self::antiInjection($nim ?? null),
                        //                 'create_date'   => $this->STORAGE_NOW(),
                        //                 'file_path'     => $alamatfileC,
                        //                 'file_path_c'   => $alamatfile,  
                        //             );
                                    
                        //             $result = $model->saveGlobal($dataAtt, 'sipenkp_perusahaan_mahasiswa', true);
                        //             // print_r($result->code);die;
                        //         }else{
                        //             $result->code = 17;
                        //             $result->info = 'FAILED UPLOAD FILE to SERVER';
                        //         }
                        //     }  
                            
                        //     // print_r("Teu asup gan");die;
    
                        //     if($result->code == $result::CODE_SUCCESS){
                        //         // print_r("hi");die;
                        //         if($params == 'admin'){
                        //             $dataUpd = array(
                        //                 'tanggal_kerja_praktik_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                        //                 'tanggal_kerja_praktik_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                        //                 'status_pengajuan'                 => 104,
                        //                 'update_date'                      => $this->STORAGE_NOW(),
                        //                 'id_perusahaanmhs'                 => $result->data,
                        //             );
                        //         } else {
                        //             $dataUpd = array(
                        //                 'tanggal_kerja_praktik_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                        //                 'tanggal_kerja_praktik_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                        //                 'status_pengajuan' => 103,
                        //                 'update_date'      => $this->STORAGE_NOW(),
                        //                 'id_perusahaanmhs' => $result->data,
                        //             );
                        //         }
                                
                        //         $nim        = $dMhs;
                        //         $perusahaan = $this->antiStealth('namaper');
                        //         // print_r($perusahaan);die;
                        //         $where  = "nim = '$nim' and nama_perusahaan = '$perusahaan'";
                        //         $result = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataUpd, $where);
    
                        //     }
    
                            
                        //     if($result->code == $result::CODE_SUCCESS){
                        //         $date   = $this->STORAGE_NOW();
                        //         $datetest = self::antiInjection($this->antiStealth('tglawal') ?? null);
                        //         $tenggat = date('Y-m-d', strtotime($datetest. ' + 6 month'));
                      
                        //         if($params = 'admin'){
                        //             $datakp = array(
                        //                 'nim'           => "$dMhs",
                        //                 'status_kp'     => self::antiInjection('121'),
                        //                 'create_date'   => $this->STORAGE_NOW(),
                        //                 'mulai_kp'      => self::antiInjection($this->antiStealth('tglawal') ?? null),
                        //                 'akhir_kp'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                        //                 'tenggat_kp'    => $tenggat,
                        //                 'id_pengajuan'  => self::antiInjection($idpengajuan ?? null),
                                        
                                        
                        //             );
                        //             $result = $model->saveGlobal($datakp, 'sipenkp_kerja_praktik', true);
                        //         }
                        //     }
                        //     $counter++;
                        // }  
                        // print_r($counter);die; 
                    }
                    
                    if(count($arrDeny) != 0){
                        $dataArr    = array(
                            'status_pengajuan'    => self::antiInjection(102 ?? null),
                            'update_date'         => $this->STORAGE_NOW(),
                        );
                        
                        for($i = 0; $i < count($arrDeny); $i++){
                            if($result->code == $result::CODE_SUCCESS){
                                $where      = "nim = '".$arrDeny[$i]."' AND nama_perusahaan = '".$this->antiStealth('namaper')."'";
                                $result     = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataArr, $where);
                                
                            }
                        }  
                        
                    }
                    
                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                    }else{
                        $connect->rollback();
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function konfirmasivalidOldAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   
                    $arrAccStr    = $this->antiStealth('arrAcc');
                    $arrDenyStr   = $this->antiStealth('arrDeny');
                    $arrAcc       = explode(",", $arrAccStr);
                    $arrDeny      = explode(",", $arrDenyStr);

                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();

                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);

                    $where          = "nama_perusahaan = '".$this->antiStealth('namaper')."' AND status_pengajuan = 92 AND to_char(tanggal_kerja_praktik_awal, 'yyyy-mm-dd') = '".$this->antiStealth('tglawalh')."' AND to_char(tanggal_kerja_praktik_akhir, 'yyyy-mm-dd') = '".$this->antiStealth('tglakhirh')."' AND to_char(create_date_pengajuan, 'yyyy-mm-dd') = '".$this->antiStealth('createdh')."' AND sipenkp_pengajuan_mahasiswa.nim = t_mahasiswa.nim  limit 6";
                    $result         = $model->loadGlobal("sipenkp_pengajuan_mahasiswa, t_mahasiswa", "*", $where);
                    // print_r($result);die;
                    $connect->beginTransaction();

                    if(count($arrAcc) != 0){
                        $fileupload      = $_FILES['file']['tmp_name'];   
                        
                        /* data upload */
                        $ImageName       = $_FILES['file']['name'];
                        $tipes           = $_FILES['file']['type'];
                        $size            = $_FILES['file']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::generateRandomCharacter();
                        // $tglfolder = date_format($this->STORAGE_NOW(),"d-m-Y");
                        $uploaddir = './public/data/buktiperusahaan/'; // directory file
                        $uploaddis = '/data/buktiperusahaan/'; // directory file
                        
                        
                        $alamatfile    = $uploaddir.$createRanName.".".$ImageExt;
                        $alamatfileC   = $uploaddis.$createRanName.".".$ImageExt;
                        // print_r($uploaddis);die;
                        /* save data ke db */
                        foreach($arrAcc as $dMhs){
                            print_r($dMhs);
                        }
                        die;

                        $nim            = self::antiInjection($this->antiStealth('nim') ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidpengajuan       = $model->loadGlobal( 'sipenkp_pengajuan_mahasiswa', '*', $wherekp);
                        $datapengajuan         = $loadidpengajuan->data[0];
                        $idpengajuan           = $loadidpengajuan->data[0]['id_pengajuan'];
                        
                             
                        $params = $this->antiStealth('paramtype');
                        // print_r($params);die;
                        if ($params == 'admin'){
                            $dataArr = array(
                                'nama_perusahaan_kp'    => self::antiInjection($this->antiStealth('namaper') ?? null),
                                'kode_pos'              => self::antiInjection($datapengajuan['kode_pos'] ?? null),
                                'alamat'                => self::antiInjection($datapengajuan['alamat_perusahaan'] ?? null),
                                'tanggal_kp_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                                'tanggal_kp_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                                'no_telp'               => self::antiInjection($datapengajuan['no_telp'] ?? null),
                                'create_date_pengajuan' => $this->STORAGE_NOW(),
                            );
                        } else {
                            $dataArr = array(
                                'nama_perusahaan_kp'    => self::antiInjection($this->antiStealth('namaper') ?? null),
                                // 'no_referensi'          => self::antiInjection($this->antiStealth('noref') ?? null),
                                // 'nama_kontak'           => self::antiInjection($this->antiStealth('staff') ?? null),
                                // 'nomor_kontak'          => self::antiInjection($this->antiStealth('kontakstaff') ?? null),
                                // 'alamat'                => self::antiInjection($this->antiStealth('alamat') ?? null),
                                'tanggal_kp_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                                'tanggal_kp_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                                // 'syarat_perusahaan'     => self::antiInjection($this->antiStealth('syarat') ?? null),
                                // 'jumlah_mahasiswa'      => self::antiInjection($this->antiStealth('jumlahmhsw') ?? null),
                                // 'uang_transport'        => self::antiInjection($this->antiStealth('transpot') ?? null),
                                // 'penginapan_perusahaan' => self::antiInjection($this->antiStealth('penginapan') ?? null),
                                // 'uang_makan'            => self::antiInjection($this->antiStealth('makan') ?? null),
                                // 'asuransi_perusahaan'   => self::antiInjection($this->antiStealth('asuransi') ?? null),
                                // 'lainnya'               => self::antiInjection($this->antiStealth('lainnya') ?? null),
                                'create_date_pengajuan' => $this->STORAGE_NOW(),
                            );
                        }
                        
                        // print_r($dataArr);die;
                        $result = $model->saveGlobal($dataArr, 'sipenkp_perusahaan', true);
          
                        if($result->code == $result::CODE_SUCCESS){
                            if (move_uploaded_file($_FILES['file']['tmp_name'],$alamatfile)){
                                $dataAtt        = array(
                                    'id_perusahaan' => $result->data,
                                    'nim'           => self::antiInjection($this->antiStealth('nim') ?? null),
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'file_path'     => $alamatfileC,
                                    'file_path_c'   => $alamatfile,  
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_perusahaan_mahasiswa', true);
                                // print_r($result->code);die;
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }
                        }   

                        if($result->code == $result::CODE_SUCCESS){
                            // print_r("hi");die;
                            if($params == 'admin'){
                                $dataUpd = array(
                                    'tanggal_kerja_praktik_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                                    'tanggal_kerja_praktik_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                                    'status_pengajuan'                 => 104,
                                    'update_date'                      => $this->STORAGE_NOW(),
                                    'id_perusahaanmhs'                 => $result->data,
                                );
                            } else {
                                $dataUpd = array(
                                    'tanggal_kerja_praktik_awal'       => self::antiInjection($this->antiStealth('tglawal') ?? null),
                                    'tanggal_kerja_praktik_akhir'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                                    'status_pengajuan' => 103,
                                    'update_date'      => $this->STORAGE_NOW(),
                                    'id_perusahaanmhs' => $result->data,
                                );
                            }
                            
                            $nim        = $this->antiStealth('nim');
                            $perusahaan = $this->antiStealth('namaper');
                            // print_r($perusahaan);die;
                            $where  = "nim = '$nim' and nama_perusahaan = '$perusahaan'";
                            $result = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataUpd, $where);

                        }

                        
                        if($result->code == $result::CODE_SUCCESS){
                            $date   = $this->STORAGE_NOW();
                            $datetest = self::antiInjection($this->antiStealth('tglawal') ?? null);
                            $tenggat = date('Y-m-d', strtotime($datetest. ' + 6 month'));
                  
                            if($params = 'admin'){
                                $datakp = array(
                                    'nim'           => self::antiInjection($nim),
                                    'status_kp'     => self::antiInjection('121'),
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'mulai_kp'      => self::antiInjection($this->antiStealth('tglawal') ?? null),
                                    'akhir_kp'      => self::antiInjection($this->antiStealth('tglakhir') ?? null),
                                    'tenggat_kp'    => $tenggat,
                                    'id_pengajuan'  => self::antiInjection($idpengajuan ?? null),
                                    
                                    
                                );
                                $result = $model->saveGlobal($datakp, 'sipenkp_kerja_praktik', true);
                            }
                            

                            
                        }   
                    }

                    if(count($arrDeny) != 0){
                        $dataArr    = array(
                            'status_pengajuan'    => self::antiInjection(102 ?? null),
                            'update_date'         => $this->STORAGE_NOW(),
                        );

                        for($i = 0; $i < count($arrDeny); $i++){
                            if($result->code == $result::CODE_SUCCESS){
                                $where      = "nim = '".$arrDeny[$i]."' AND nama_perusahaan = '".$this->antiStealth('namaper')."'";
                                $result     = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataArr, $where);
                                
                            }
                        }
                        print_r($result);die;
                    }

                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                    }else{
                        $connect->rollback();
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    

    public function submitfilebimbinganAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload      = $_FILES['file']['tmp_name'];   
                    // print_r($fileupload);die;
                    if (!empty($fileupload)){
                        
                        /* data upload */
                        $ImageName       = $_FILES['file']['name'];
                        $tipes           = $_FILES['file']['type'];
                        $size            = $_FILES['file']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::generateRandomCharacter();
                        // $tglfolder = date_format($this->STORAGE_NOW(),"d-m-Y");
                        $uploaddir = './public/data/bimbingan/'; // directory file
                        $uploaddis = '/data/bimbingan/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName.$NewImageName;
                        // $alamatfile    = $uploaddir.$this->antiStealth('nim').".".$ImageExt;
                        $alamatfileC   = $uploaddis.$createRanName.$NewImageName;
                        // print_r($uploaddis);die;
                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        
                        if($result->code == $result::CODE_SUCCESS){
                            if (move_uploaded_file($_FILES['file']['tmp_name'],$alamatfile)){
                                $dataAtt        = array(
                                    'nopeg'                 => self::antiInjection($this->antiStealth('nopeg') ?? null),
                                    'nim'                   => self::antiInjection($this->antiStealth('nim') ?? null),
                                    'tanggal_bimbingan'     => $this->STORAGE_NOW(),
                                    'file_bimbingan'        => $createRanName.$NewImageName,
                                    'dir_file'              => $uploaddis,
                                    'uploaded'              => 200,
                                    'id_kp'                 => self::antiInjection($this->antiStealth('idkp') ?? null),
                                    
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_bimbingan', true);
                                // print_r($result->code);die;
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }
                        }   

                        

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'MOHON MASUKAN FILE ATTACHMENTS!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function submitfilebimbingandsnAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $fileupload      = $_FILES['file']['tmp_name'];   
                    // print_r($fileupload);die;
                    if (!empty($fileupload)){
                        
                        /* data upload */
                        $ImageName       = $_FILES['file']['name'];
                        $tipes           = $_FILES['file']['type'];
                        $size            = $_FILES['file']['size'];

                        $userSession    = $this->getSession();
		
                        $user_id 		= $userSession->get('user_id');

                        $timeName       = microtime(true);
                        $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                            
                        $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                        $ImageExt       = str_replace('.','',$ImageExt); // Extension
                        $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                        $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                        $createRanName  = self::generateRandomCharacter();
                        // $tglfolder = date_format($this->STORAGE_NOW(),"d-m-Y");
                        $uploaddir = './public/data/bimbingan/'; // directory file
                        $uploaddis = '/data/bimbingan/'; // directory file
                        
                        $alamatfile    = $uploaddir.$createRanName.$NewImageName;
                        // $alamatfile    = $uploaddir.$this->antiStealth('nim').".".$ImageExt;
                        $alamatfileC   = $uploaddis.$createRanName.$NewImageName;
                        // print_r($uploaddis);die;
                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        /* begin */
                        $connect->beginTransaction();

                        
                        if($result->code == $result::CODE_SUCCESS){
                            if (move_uploaded_file($_FILES['file']['tmp_name'],$alamatfile)){
                                $dataAtt        = array(
                                    'nopeg'                 => self::antiInjection($this->antiStealth('nopeg') ?? null),
                                    'nim'                   => self::antiInjection($this->antiStealth('nim') ?? null),
                                    'tanggal_bimbingan'     => $this->STORAGE_NOW(),
                                    'file_bimbingan'        => $createRanName.$NewImageName,
                                    'dir_file'              => $uploaddis,
                                    'uploaded'              => 50,
                                    'id_kp'                 => self::antiInjection($this->antiStealth('idkp') ?? null),
                                    'keterangan_bimbingan'  => self::antiInjection($this->antiStealth('keterangan') ?? null),
                                    
                                );
                                
                                $result = $model->saveGlobal($dataAtt, 'sipenkp_bimbingan', true);
                                // print_r($result->code);die;
                            }else{
                                $result->code = 17;
                                $result->info = 'FAILED UPLOAD FILE to SERVER';
                            }
                        }   

                        

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'MOHON MASUKAN FILE ATTACHMENTS!';
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function validasiberkasAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
            
                        $model   	    = new \Application\Model\Param($storage);

                        $nim            = self::antiInjection($isData->nim ?? null);
                        $wherekp        = "nim = '$nim' ORDER BY create_date DESC LIMIT 1";
                        
                        $loadidkp       = $model->loadGlobal( 'sipenkp_kerja_praktik', 'id_kp, id_berkas', $wherekp);
                        $idkp           = $loadidkp->data[0]['id_kp'];
                        $idberkas       = $loadidkp->data[0]['id_berkas'];

                        if($isData->isvalid == true){
                            $dataAtt = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 51 ?? null),
                                'isjadwal'       => self::antiInjection( 72 ?? null),
                                'keterangan'     => self::antiInjection( $isData->keterangan ?? null),
                            );
                        } else {
                            $dataAtt = array(
                                'update_date'    => $this->STORAGE_NOW(),
                                'isvalidtu'      => self::antiInjection( 52 ?? null), //
                                'keterangan'     => self::antiInjection( $isData->keterangan ?? null),
                               
                            );
                        }

                        $where = "nim_mhs = '".self::antiInjection($isData->nim ?? null)."' AND idberkas = $idberkas";
                        $result         = $model->updateGlobal( 'sipenkp_berkas_mahasiswa', $dataAtt, $where);
                        

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function validasiperusahaanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $user_id 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);

                        $tgl            = $model->detailPengajuan($isData->nim);
                        // print_r($tgl->data[0]['tanggal_kerja_praktik_awal']);die;
                        
                        if($isData->isvalid == true){
                            $dataAtt = array(
                                'update_date'           => $this->STORAGE_NOW(),
                                'status_pengajuan'      => self::antiInjection( 104 ?? null),
                            );
                        } else {
                            $dataAtt = array(
                                'update_date'           => $this->STORAGE_NOW(),
                                'status_pengajuan'      => self::antiInjection( 105 ?? null), //
                            );
                        }

                        $where = "nim = '".self::antiInjection($isData->nim ?? null)."'";
                        $result         = $model->updateGlobal( 'sipenkp_pengajuan_mahasiswa', $dataAtt, $where);


                        if($result->code == $result::CODE_SUCCESS){
                            $date = $this->STORAGE_NOW();
                            $tenggat = date('Y-m-d', strtotime($date. ' + 6 month'));
                            if($isData->isvalid == true){
                                $datakp = array(
                                    'nim'           => self::antiInjection($isData->nim ?? null),
                                    'status_kp'     => self::antiInjection('121'),
                                    'create_date'   => $this->STORAGE_NOW(),
                                    'tenggat_kp'    => $tenggat,
                                    'mulai_kp'      => $tgl->data[0]['tanggal_kerja_praktik_awal'],
                                    'akhir_kp'      => $tgl->data[0]['tanggal_kerja_praktik_akhir'],
                                    
                                );
                                $result = $model->saveGlobal($datakp, 'sipenkp_kerja_praktik', true);
                            } 

                            
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function dataforqrAction(){
        // $this->checkCsrf(); // jika false return code error

        $result      = new Result();

            $request     = $this->getRequest();
           
            

                try{   
                    
                    // $userSession    = $this->getSession();		
                    // $isUserid 		= $userSession->get('user_id');
                    $request        = $this->getRequest();
                    $post           = $request->getPost();
                   
                    $isData         = $post->iparam;
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $id         = self::antiInjection($isData ?? null);
                        $where      = "nopeg = '$id'";
                        $dataheader = $model->loadGlobal("user_data_header", 'nim', $where);
                        $code       = $dataheader->data[0]['nim'];

                        $result     = $model->loadataKaprodi($code);
                        // print_r($result);die;
                        // $result         = $model->loadbobot($id);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = $result->data;
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function reportingnilaiAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        // print_r($isData);die;
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        // $tanggal        =
                        $connect->beginTransaction();

                        // save ke tbl mahasiswa
                        $result         = $model->loadnilaiperprodi($isData);
                        

                        if($result->code == $result::CODE_SUCCESS){
                            $result->code = $result::CODE_SUCCESS;
                            $result->data = $model->generatereport($result->data, $isData->tglawal, $isData->tglakhir, $isData->kodeprodi, $this->urlLedakan());
                        } else if($result->code == 4 || $result->code == 1){
                            $result->info = "Tidak ada data pada range tanggal tersebut";
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function reportingnilaiexcelAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        // print_r($isData);die;
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        // $tanggal        =
                        $connect->beginTransaction();

                        // save ke tbl mahasiswa
                        $result         = $model->loadnilaiperprodi($isData);
                        // print_r($result);die;

                        if($result->code == $result::CODE_SUCCESS){
                            $result->code = $result::CODE_SUCCESS;
                            $result->data = $model->generatereportexcel($result->data, $isData->tglawal, $isData->tglakhir, $isData->kodeprodi, $this->urlLedakan());
                        } else if($result->code == 4 || $result->code == 1){
                            $result->info = "Tidak ada data pada range tanggal tersebut";
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadbatchpengajuanAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);

                        $where          = "nama_perusahaan = '$isData->perusahaan' 
                                           AND status_pengajuan = 92 
                                           AND to_char(tanggal_kerja_praktik_awal, 'yyyy-mm-dd') = '$isData->tglawal' 
                                           AND to_char(tanggal_kerja_praktik_akhir, 'yyyy-mm-dd') = '$isData->tglakhir' 
                                           AND to_char(create_date_pengajuan, 'yyyy-mm-dd') = '$isData->create' 
                                           AND sipenkp_pengajuan_mahasiswa.nim = t_mahasiswa.nim  
                                           AND sipenkp_pengajuan_mahasiswa.id_nosurat = ".$isData->id_nosurat." limit 6";
                        $result         = $model->loadGlobal("sipenkp_pengajuan_mahasiswa, t_mahasiswa", "*", $where);

                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function tembusandefaultAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $ipoly          = self::antiInjection($isData->ipoly ?? null);

                        $result     = $model->loadGlobal("master_parameter", "*", "param_type = 'TEMBUSAN SURAT'");
            
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaddatamahasiswaAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                        $filter  = self::antiInjection($isData->filter ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'nim',
                            1       =>  'nim',
                            2   	=>  'nama',
                            3   	=>  'nama_prodi',
                            4   	=>  'email',
                            5   	=>  'sks',
                            6   	=>  'ip',                     
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getdatamahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search, $filter);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadprodiAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);
                        $where          = "jenjang = 'S1'";
                        $result         = $model->loadGlobal('t_prodi ', '*', $where );
                        
                        // print_r($result);die;
                                                
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadusermahasiswaAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);
                                                                        
                        $col =  array(
                            0       =>  'nim',
                            1       =>  'username',
                            2   	=>  'nama',
                            3   	=>  'nama_prodi',
                            4   	=>  'file_foto',
                            5   	=>  'email',
                            6   	=>  'update_date',
                            7   	=>  'status',                    
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;

                        $search     = $isearch['value'] ?? null;

                        $filter  = self::antiInjection($isData->filter ?? null);
                                                
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getusermahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search, $filter);

                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saveadduserAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $nim    = self::antiInjection($isData->nim ?? null);
                        $nama   = self::antiInjection($isData->nama ?? null);
                        $status = self::antiInjection($isData->status ?? null);
                        $uname  = self::antiInjection($isData->uname ?? null);
                        $passwd = self::antiInjection($isData->passwd ?? null);
                        // print_r($isData);die;
                        /* dosen */
                        if($status == 10){ 
                            $dataArr = array(
                                'password' => md5($nim),
                                'username' => $nim,
                                'nopeg' => $nim,
                                'name' => $nama,
                                'role' => 50,
                                'status' => 10,
                                'retries' => 'NULL',
                            );
                        } else if($status == 20 ){ /* akademik */
                            $dataArr = array(
                                'password' => $passwd,
                                'username' => $uname,
                                'nopeg' => $nim,
                                'name' => $nama,
                                'role' => 10,
                                'status' => 10,
                                'retries' => 'NULL',
                            );
                        }else{ /* mahasiswa */
                            $dataArr = array(
                                'password' => md5($nim),
                                'username' => $nim,
                                'nim' => $nim,
                                'name' => $nama,
                                'role' => 200,
                                'status' => 10,
                                'retries' => 'NULL',
                            );
                        }
                        
                        $result = $model->saveGlobal($dataArr,'user_data_header', true);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function deleteusersAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $iduser = self::antiInjection($isData->iduser ?? null);
                       

                        $where = 'iduser = '.$iduser;
                        $result = $model->deleteGlobal('user_data_header', $where);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function activateduserAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $iduser = self::antiInjection($isData->iduser ?? null);
                        $status = self::antiInjection($isData->status ?? null);
                        
                        if($status == 10){
                            $statussave = 20;
                        }else{
                            $statussave = 10;
                        }

                        $dataArr = array(
                            'status' =>$statussave
                        );

                        $where = 'iduser = '.$iduser;
                        $result = $model->updateGlobal('user_data_header', $dataArr, $where);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function resetpasswordusersAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $iduser = self::antiInjection($isData->iduser ?? null);
                        $nim = self::antiInjection($isData->nim ?? null);

                        $dataArr = array(
                            'password' => md5($nim)
                        );

                        $where = 'iduser = '.$iduser;
                        
                        $result = $model->updateGlobal('user_data_header', $dataArr, $where);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saveberkasmhsAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   
                    
                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();

                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);

                    /* begin */
                    $connect->beginTransaction();

                    $fileupload     = $_FILES['berkas-mhs']['tmp_name'];
                    // print_r($fileupload);die;   
                    $file = fopen($fileupload,"r");
                    $all_rows = array();
                    $header = fgetcsv($file);
                    
                    while ($row = fgetcsv($file)) {
                        $all_rows[] = array_combine($header, $row);
                    }
                    // print_r($all_rows);die;
                    // print_r($all_rows);die;
                    $dataArr = array();
                    $y = 0;
                    foreach($all_rows as $val){
                        foreach($val as $key=>$value){
                            if($value == ''){
                                unset($val[$key]);
                            }
                        }
                        if(!empty($val)){
                            array_push($dataArr, $val);
                        }
                        $y++;
                    }

                    print_r($dataArr);die;
                    
                    $result = $model->hardSaveGlobalMahasiswa($dataArr, 't_mahasiswa', 'nim');
                   
                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                    }else{
                        $connect->rollback();
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasmhsxlsxAction(){ //didieu nya rey

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{

                    $fileupload      = $_FILES['berkas-mhs']['tmp_name']; 
		    //print_r(getcwd().DIRECTORY_SEPARATOR);die;
                    //print_r($fileupload);die;
                    /* data upload */
                    $ImageName       = $_FILES['berkas-mhs']['name'];
                    $tipes           = $_FILES['berkas-mhs']['type'];
                    $size            = $_FILES['berkas-mhs']['size'];

                    $userSession    = $this->getSession();
    

                    $timeName       = microtime(true);
                    $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                        
                    $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                    $ImageExt       = str_replace('.','',$ImageExt); // Extension
                    $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                    $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                    $createRanName  = self::generateRandomCharacter();
                    
                    $uploaddir = './public/data/xlsx/'; // directory file
                    $uploaddis = '/data/xlsx/'; // directory file
                
                    
                    $alamatfile    = getcwd().DIRECTORY_SEPARATOR.'public/data/xlsx/'.$createRanName.$NewImageName;
                    //print_r($alamatfile);die;
                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();
                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);
			
		            $connect->beginTransaction();
                    if (move_uploaded_file($_FILES['berkas-mhs']['tmp_name'],$alamatfile)){
                        
                        /* jika upload berhasil ke folder sever */
                        $reader      = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                        $spreadsheet = $reader->load($alamatfile);
                        $worksheet   = $spreadsheet->getActiveSheet();
                        $isHeader    = 0;
                        $dataArr     = [];
                        foreach($worksheet->getRowIterator() as $row){
                            $cellIterator = $row->getCellIterator();
                            $cellIterator->setIterateOnlyExistingCells(false);
                            $data = [];
                            foreach ($cellIterator as $cell) { 
                                $data[] = $cell->getValue();
                            }
                            array_push($dataArr, $data);
                        }
                        
                        $newdata = array();
                        foreach($dataArr as $val){
                            if($val[0] != '' || $val[0] != NULL){
                                array_push($newdata, $val);
                            } 
                        }
                        
                        // print_r($newdata);die;
                        $result = $model->hardSaveGlobalMahasiswaxlsx($newdata, 't_mahasiswa', 'nim');

                    }else{
                        $result->code = 4;
                        $result->info = 'Failed upload file to server';
                    }

                                                           
                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                        unlink($alamatfile);
                    }else{
                        $connect->rollback();
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveberkasdsnxlsxAction(){ //didieu nya rey

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{

                    $fileupload      = $_FILES['berkas-dsn']['tmp_name'];   
                    
                    /* data upload */
                    $ImageName       = $_FILES['berkas-dsn']['name'];
                    $tipes           = $_FILES['berkas-dsn']['type'];
                    $size            = $_FILES['berkas-dsn']['size'];

                    $userSession    = $this->getSession();
    

                    $timeName       = microtime(true);
                    $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                        
                    $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                    $ImageExt       = str_replace('.','',$ImageExt); // Extension
                    $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                    $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);

                    $createRanName  = self::generateRandomCharacter();
                    
                    $uploaddir = './public/data/xlsx/'; // directory file
                    $uploaddis = '/data/xlsx/'; // directory file
                
                    
                    $alamatfile    = getcwd().DIRECTORY_SEPARATOR.'public/data/xlsx/'.$createRanName.$NewImageName;
                    
                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();
                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);

                    if (move_uploaded_file($_FILES['berkas-dsn']['tmp_name'],$alamatfile)){
                        
                        /* jika upload berhasil ke folder sever */
                        $reader      = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                        $spreadsheet = $reader->load($alamatfile);
                        $worksheet   = $spreadsheet->getActiveSheet();
                        $isHeader    = 0;
                        $dataArr     = [];
                        foreach($worksheet->getRowIterator() as $row){
                            $cellIterator = $row->getCellIterator();
                            $cellIterator->setIterateOnlyExistingCells(false);
                            $data = [];
                            foreach ($cellIterator as $cell) { 
                                $data[] = $cell->getValue();
                            }
                            array_push($dataArr, $data);
                        }
                        
                        $newdata = array();
                        foreach($dataArr as $val){
                            if($val[0] != '' || $val[0] != NULL){
                                array_push($newdata, $val);
                            } 
                        }
                        // print_r($newdata);die;
                        $connect->beginTransaction();
                        $result = $model->hardSaveGlobalMahasiswaxlsx($newdata, 't_peg_itb', 'nopeg');

                    }
                    
                                       
                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                        unlink($alamatfile);
                    }else{
                        $connect->rollback();
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaduserdosenAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        // print_r('modarsia');die;
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'iduser',
                            1   	=>  'username',
                            2   	=>  'nama',
                            3   	=>  'file_foto',
                            4   	=>  'inisial',
                            // 5   	=>  'pembimbing_ta',                  
                            5    	=>  'update_date',                      
                            6    	=>  'status',                      
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getuserdosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaduserakademikAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        // print_r('modarsia');die;
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'iduser',
                            1   	=>  'username',
                            2   	=>  'nama',
                            3   	=>  'file_foto',
                            4   	=>  'inisial',
                            // 5   	=>  'pembimbing_ta',                  
                            5    	=>  'update_date',                      
                            6    	=>  'status',                      
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getuserakademik($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaddatadosenAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'nopeg',
                            1   	=>  'nopeg',
                            2   	=>  'nama',
                            3   	=>  'inisial',
                            4   	=>  'pembimbing_ta',
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getdatadosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loaddataakademikAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'nopeg',
                            1   	=>  'nopeg',
                            2   	=>  'nama',
                            3   	=>  'inisial',
                            4   	=>  'pembimbing_ta',
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getdataakademik($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function saveberkasdsnAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        if($this->isLoggedIn()){

            $request     = $this->getRequest();

            if ($request->isPost()) {

                try{   

                    $adapter 	    = $this->getDb();
                    $connect        = $adapter->getDriver()->getConnection();

                    $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                    $model   	    = new \Application\Model\Param($storage);

                    /* begin */
                    $connect->beginTransaction();

                    $fileupload     = $_FILES['berkas-dsn']['tmp_name'];

                    $file = fopen($fileupload,"r");
                    $all_rows = array();
                    $header = fgetcsv($file);
                    
                    while ($row = fgetcsv($file)) {
                        $all_rows[] = array_combine($header, $row);
                    }

                    $dataArr = array();
                    
                    foreach($all_rows as $val){
                        foreach($val as $key=>$value){
                            if($value == ''){
                                unset($val[$key]);
                            }
                        }
                        if(!empty($val)){
                            array_push($dataArr, $val);
                        }
                    }
                   
                    $result = $model->hardSaveGlobalMahasiswa($dataArr, 't_peg_itb', 'nopeg');
                   
                    if($result->code == $result::CODE_SUCCESS){
                        $connect->commit();
                    }else{
                        $connect->rollback();
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaduserkaprodiAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'iduser',
                            1   	=>  'username',
                            2   	=>  'nama',        
                            3   	=>  'nama_prodi',        
                            4    	=>  'update_date',                      
                            5    	=>  'status',                      
                        );

                        
                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getuserkaprodi($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadselectkaprodiAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $where          = "LEFT(id_sta_peg, 5) = 'Dosen'";
                        $select         = "nopeg, CONCAT(gelar_dpn, ' ', nama, ' ', gelar_blk) as nama";                   
                        
                        $result         = $model->loadGlobal('t_peg_itb',$select,  $where);     
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function savekaprodiAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $iduser = self::antiInjection($isData->iduser ?? null);
                        $nopeg = self::antiInjection($isData->nopeg ?? null);
                                                
                        $dataArr = array(
                            'nopeg' => $nopeg,
                        );

                        $where = 'iduser = '.$iduser;
                        
                        $result = $model->updateGlobal('user_data_header', $dataArr, $where);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadmasteremailAction(){
        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $where          = "param_type = 'EMAILPARAM'";
                        $select         = "*";                   
                        
                        $result         = $model->loadGlobal('master_parameter', $select,  $where);     
                        // print_r($result);die;
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function saveemailAction(){
        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $host           = 'smtp.gmail.com';
                        $port           = 587;
                        $email          = $isData->email;
                        $password       = $isData->pass;
                        
                        $result     = $model->testconnection($host, $port, $email, $password);
                        
                        // print_r($checkemail);die;
                        if($result->code == $result::CODE_SUCCESS){
                            $where          = "param_type = 'EMAILPARAM'";

                            $datArr         = array(
                                'param_val1'    => self::antiInjection($isData->email ?? null)
                            );                   
                            
                            $result         = $model->updateGlobal('master_parameter', $datArr,  $where);  
                        }
                           
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loadlistberkasAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData->idberkas);die;
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $where          = "idberkas = ".$isData->idberkas;
                        $select         = "*";                   
                        
                        $result         = $model->loadGlobal('sipenkp_berkas',$select,  $where);     
                        // print_r($result);die;
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function parameterformsAction(){
        $this->checkCsrf(); // jika false return code error
    
        $result      = new Result();
    
        if($this->isLoggedIn()){
    
            $request     = $this->getRequest();
    
            if ($request->isPost()) {
    
                try{   
                    
                    $role             = $this->antiStealth('role');
                    // print_r($role);die;
                    $arrayName        = array();
                    $numbfile         = array();
                    $fileupload1      = $_FILES['fileupload1']['tmp_name']; //Daftar Hadir
                    $fileupload2      = $_FILES['fileupload2']['tmp_name']; //Penilaian Perusahaan
                    
                    if(!empty($fileupload1)){
                        array_push($arrayName, "daftarhadir");
                        array_push($numbfile, 1);
                    }
                    if(!empty($fileupload2)){
                        array_push($arrayName, "nilaiperusahaan");
                        array_push($numbfile, 2);
                    }
                    
                    if (!empty($fileupload1) || !empty($fileupload2)){
                        /* save data ke db */
                        $adapter 	    = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
    
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        $connect->beginTransaction();
    
                        for($i = 0; $i < count($arrayName); $i++){
                            $ImageName       = $_FILES['fileupload'.$numbfile[$i]]['name'];
                            $tipes           = $_FILES['fileupload'.$numbfile[$i]]['type'];
                            $size            = $_FILES['fileupload'.$numbfile[$i]]['size'];
    
                            $userSession    = $this->getSession();
            
                            $user_id 		= $userSession->get('user_id');
    
                            $timeName       = microtime(true);
                            $micro          = sprintf("%06d", ($timeName - floor($timeName)) * 1000000);
                                
                            $ImageExt       = substr($ImageName, strrpos($ImageName, '.'));
                            $ImageExt       = str_replace('.','',$ImageExt); // Extension
                            $ImageName      = preg_replace("/\.[^.\s]{3,4}$/", "", $ImageName);
                            
                            $NewImageName   = str_replace(' ', '', $micro.'.'.$ImageExt);
    
                            $createRanName  = $arrayName[$i].'.'.$ImageExt;
                            
                            $uploaddir = './public/data/forms/'; // directory file
                            $uploaddis = '/data/forms/'; // directory file
                            
                            $alamatfile    = $uploaddir.$createRanName;
                            // print_r($alamatfile);die;
                            /* begin */
    
                            if($result->code == $result::CODE_SUCCESS){
                                
                                if (move_uploaded_file($_FILES['fileupload'.$numbfile[$i]]['tmp_name'],$alamatfile)){
    
                                    $result->code = $result::CODE_SUCCESS;
                                    $result->info = "Success Upload File";
        
                                }else{
                                    $result->code = 17;
                                    $result->info = 'FAILED UPLOAD FILE to SERVER';
                                }
    
                            }
                        }
                        
                    } else {
                        $result->code = 11;
                        $result->info = 'Berkas Tidak Boleh Kosong!';
                    }
    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      
    
        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function editsuratAction(){
	
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');
                    $uri     = $this->getRequest()->getUri();
                    $baseurl = sprintf('//%s', $uri->getHost());
                    $urlbase = $this->urlLedakan();

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    // print_r($isData);die;
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        $arrAcc         = $isData->arrAcc;
                        $arrDeny        = $isData->arrDeny;
                        $arrAll         = $isData->arrAll;

                        //load mahasiswa batch perusahan sama
                        $where          = "nama_perusahaan = '$isData->nama_perusahaan' AND status_pengajuan = 92 AND tanggal_kerja_praktik_awal = '$isData->tanggal_awal' AND tanggal_kerja_praktik_akhir = '$isData->tanggal_akhir'  limit 6";
                        $databatch      = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "*", $where);
                        $pengajuanbatch = $databatch->data;
                      
                        //load data kpmhs
                        $where          = "id_pengajuan = $isData->idpengajuan";
                        $datapengajuan  = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "*",$where);
                        $pengajuanmhs   = $datapengajuan->data[0];
                        
                        //load nama mhs
                        $where      = "nim = '$isData->nim'";
                        $datamhs    = $model->loadGlobal("t_mahasiswa", "*",$where);
                        $mahasiswa  = $datamhs->data[0];
                        
                        //load data pegawai kaprodei
                        $code         = substr($isData->nim, 0, 3);
                        $datakpr      = $model->loadataKaprodi($code);
                        $datapegawai  = $datakpr->data[0];

                        //input nosurat
                        $loadsurat     = $model->loadGlobal("sipenkp_nomor_surat", 'nomor_surat', "id_nomor = ".$pengajuanmhs['id_nosurat']);
                        $nosurat       = $loadsurat->data[0]['nomor_surat'];
                        
                        $letterdate     = $this->STORAGE_NOW();
                        $connect->beginTransaction();

                        if(count($arrAcc) != 0){
                            //generate surat 
                            $qrcode  = $model->generatesuratedt($isData, $datapegawai, $letterdate, $nosurat, $mahasiswa, $pengajuanbatch, $urlbase, $arrAcc);
                            
                            //save edit data
                            for($i = 0; $i < count($arrAcc); $i++){
                                $nim        = $arrAcc[$i];
                                $wherekp    = "nim = '$nim' ORDER BY create_date_pengajuan DESC LIMIT 1";

                                $loadidpengajuan       = $model->loadGlobal('sipenkp_pengajuan_mahasiswa', '*', $wherekp);
                                $datapengajuan         = $loadidpengajuan->data[0];
                                $idpengajuan           = $loadidpengajuan->data[0]['id_pengajuan'];
                                
                                $dataUpdate = array(
                                    "status_pengajuan"          => self::antiInjection(92 ?? null),
                                    "alamat_perusahaan"         => self::antiInjection($isData->alamat_perusahaan ?? null),
                                    "nama_penerima_perusahaan"  => self::antiInjection($isData->penerima_surat ?? null),
                                    "kode_pos"                  => self::antiInjection($isData->kode_pos ?? null),
                                    "divisi_penerima"           => self::antiInjection($isData->divisi_penerima ?? null),
                                    "tembusan"                  => $isData->tembusan,
                                    "update_date"               => $this->STORAGE_NOW(),
                                    "file_name"                 => $qrcode->data,
                                );

                                $where  = "id_pengajuan = $idpengajuan";
                                $result = $model->updateGlobal("sipenkp_pengajuan_mahasiswa", $dataUpdate, $where);
                                // print_r($result);die;
                            }
                        } 
                        
                        // die;
                        
                        if(count($arrDeny) != 0){
                            $dataDeny = array(
                                'status_pengajuan'      => self::antiInjection(91 ?? null),
                                'update_date'           => $this->STORAGE_NOW(),
                                'file_name'             => self::antiInjection(null),
                            );

                            for($i = 0; $i < count($arrDeny); $i++){
                                if($result->code == $result::CODE_SUCCESS){
                                    $nims              = $arrDeny[$i];
                                    
                                    $wherekp           = "nim = '$nims' ORDER BY create_date_pengajuan DESC LIMIT 1";
                                    $loadidpengajuan   = $model->loadGlobal("sipenkp_pengajuan_mahasiswa", "*", $wherekp);
                                   
                                    $datapengajuan     = $loadidpengajuan->data[0];
                                    $idpengajuan       = $loadidpengajuan->data[0]['id_pengajuan'];
                                    // print_r($loadidpengajuan);die;
                                    $where             = "id_pengajuan = $idpengajuan";
                                    $result            = $model->updateGlobal("sipenkp_pengajuan_mahasiswa", $dataDeny, $where);
                                }
                            }
                        }

                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function rejectsuratAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $idpengajuan = self::antiInjection($isData->id_pengajuan ?? null);
                                        
                        $dataArr = array(
                            'status_pengajuan' => 105,
                        );

                        $where = 'id_pengajuan = '.$idpengajuan;
                        
                        $result = $model->updateGlobal('sipenkp_pengajuan_mahasiswa', $dataArr, $where);  
                        
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function updatenilaiAction(){

        $this->checkCsrf(); // jika false return code error
        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                try{   
                    
                    $userSession    = $this->getSession();		
                    $userid 		    = $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    $isData2        = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam2') ?? null); // buka bukaan
                    if($isData){ // is true / istri

                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        $id_nilai   = self::antiInjection($isData2->idnilai ?? null);
                        $role_dosen = self::antiInjection($isData2->role_dosen ?? null);

                        $connect->beginTransaction();

                        if($role_dosen == 'penguji'){
                            $tabel = 'sipenkp_penilaian_penguji';
                        }else{
                            $tabel = 'sipenkp_penilaian_pembimbing';
                        }
                        
                        
                        foreach($isData as $key => $value){


                            $dataArr = array(
                                "nilai_$role_dosen"     => self::antiInjection($value ?? null)
                            ); 
                            $where   = "nama_nilai_$role_dosen = '$key' AND id_nilai = $id_nilai"; 
                            $result  = $model->updateGlobal($tabel, $dataArr, $where);
                        }
                        
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function listapprovalAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');
                    $nim            = null;
                    // print_r($nim);die;
                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri

                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        // print_r($isData->kodeprodi);die;
                        $search  = self::antiInjection($isData->search ?? null);
                        // print_r($search);die;
                        $kodeprodi = self::antiInjection($isData->kodeprodi ?? null);
                        // print_r($kodeprodi);die;

                        $col =  array(
                            0   	=>  'id_kp',
                            1       =>  'nim',
                            2   	=>  'nama',
                            3   	=>  'nama_prodi',
                            4       =>  'nama_dosen', 
                            5       =>  'approve_proses_bimbingan', 
                        );

                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        // print_r($isearch);die;
                        $search     = $isearch['value'] ?? null;
                        

                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];

                        
                        $result         = $model->getlistapproval($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function approvalseminarkoorAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();
        
        
        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{     
                  
                    $userSession    = $this->getSession();
		
                    $userID 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    
                    if($isData){ // is true / istri
                        
                        $adapter        = $this->getDb();
                        $connect        = $adapter->getDriver()->getConnection();
                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());
                        $model   	    = new \Application\Model\Param($storage);
                        
                        // $tanggal        =
                        $connect->beginTransaction();
                        $date = $this->STORAGE_NOW();
                        //load param(+ param. month)
                        $tenggat = date('Y-m-d', strtotime($date. ' + 1 month'));

                        if($isData->isapprove == true){
                            $dataArr    = array(
                                'approve_proses_bimbingan'   => NULL,
                                'update_date'                => $this->STORAGE_NOW(),
                            );
                        }else{
                            $dataArr    = array(
                                'approve_proses_bimbingan'   => self::antiInjection(1 ?? null),
                                'update_date'                => $this->STORAGE_NOW(),
                            );
                        }
                        

                        $where      = "id_kp = '$isData->idkp'";

                        // print_r($where);die;

                        // save ke tbl mahasiswa
                        // $result         = $model->saveGlobal($dataArr, 'sipenkp_pengajuan_mahasiswa', true);
                        $result = $model->updateGlobal( 'sipenkp_kerja_praktik', $dataArr, $where);
                        
                        if($result->code == $result::CODE_SUCCESS){
                            $connect->commit();
                        }else{
                            $connect->rollback();
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }

                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

    public function loadmforjAction(){
        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {

                try{   
                    
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan
                    
                    if($isData){ // is true / istri

                        $storage 	    = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   	    = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $nim             = $isData->nim;
                        // print_r($nim);die;


                        $result         = $model->getmahasiswaforjadwal($nim);
                        
                        /* encrypt dan return data */
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){
                                $result->data  = $isEncrypt;
                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());
    }

    public function loaduserkoordinatorAction(){

        $this->checkCsrf(); // jika false return code error

        $result      = new Result();

        if($this->isLoggedIn()){

            $request     = $this->getRequest();
           
            if ($request->isPost()) {
                
                try{   
                  
                    $userSession    = $this->getSession();		
                    $isUserid 		= $userSession->get('user_id');

                    $isData         = self::cryptoJsAesDecrypt(self::PHRASE, $this->antiStealth('iparam') ?? null); // buka bukaan

                    if($isData){ // is true / istri
                        $storage = \Application\Model\Param\Storage::factory($this->getDb(), $this->getConfig());            
                        $model   = new \Application\Model\Param($storage);

                        /* check injeksi bisi karbu */
                        $search  = self::antiInjection($isData->search ?? null);

                        // print_r($nopeg);die;
                        $col =  array(
                            0       =>  'iduser',
                            1   	=>  'username',
                            2   	=>  'nama',        
                            3   	=>  'nama_prodi',        
                            4    	=>  'update_date',                      
                            5    	=>  'status',                      
                        );

                        
                        $order      = $this->antiStealth('order');
                        $start      = $this->antiStealth('start');
                        $length     = $this->antiStealth('length');
                        $draw       = $this->antiStealth('draw');
                        
                        $isearch    = $this->antiStealth('search') ?? null;
                        $search     = $isearch['value'] ?? null;
                        
                        $orderCol       = $col[$order[0]['column']];

                        $orderDir       = $order[0]['dir'];
                        
                        $result         = $model->getuserkoordinator($col, $orderCol, $orderDir, $start, $length, $draw, $search);
                        // print_r($result);die;
                        if($result->code == $result::CODE_SUCCESS){

                            $isEncrypt  = self::cryptoJsAesEncrypt(self::PHRASE, $result->toJson());
                            
                            if($isEncrypt){

                                $dataArray = array(
                                    "draw"              =>  intval($result->data['draw']),
                                    "recordsTotal"      =>  intval($result->data['recordsTotal']),
                                    "recordsFiltered"   =>  intval($result->data['recordsFiltered']),
                                    "data"              =>  $isEncrypt,
                                    "code"              =>  $result->code,
                                );

                                $result->data   = $dataArray;

                                return $this->getOutput(json_encode($result->data));
                                exit();

                            }else{
                                $result->code = $result::CENC_FAILED;
                                $result->info = $result::IENC_FAILED;
                            }
                        }

                    }else{
                        $result->code = $result::CDEC_FAILED;
                        $result->info = $result::IDEC_FAILED;
                    }
            
                    
                }catch (\Exception $exc) {
                    $result = new Result(0,1,$exc->getMessage() .'-'.$exc->getTraceAsString());
                }
            }else{
                $result = new Result(0,401, self::DEFAULT_ERROR);
            }
        }else{
            $result = new Result(0,401, self::DEFAULT_ERROR);
        }      

        /* return data */
        return $this->getOutput($result->toJson());

    }

}