<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class MahasiswaController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){

            //print_r($result);die;
            $view->setVariable('namaste', $userSession->get('name'));
            $view->setVariable('dataa', $sessionArray);
            
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var nopeg;');
            $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');
            $this->headScript->appendFile($baseurl.'/action-js/global-js/sipenkp-global-action.js');
            $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/index-mahasiswa-action.js');
            // $this->layout()->name = $userSession->get('usernamed');
            // $this->layout()->name1 = $userSession->get('name');
            $this->layout("layout/layout_mahasiswa");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function pendaftaranAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pendaftaran_mhs.js');

        
        $this->layout("layout/layout_mahasiswa");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function uploadberkasAction(){
        $this->isLoggedIn();
       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();

        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendScript(' var role          = "' .$role.'"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pendaftaran_mhs.js');

        
        $this->layout("layout/layout_mahasiswa");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function pengajuankpAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pengajuan-mhs.js');

        
        $this->layout("layout/layout_mahasiswa");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function listperusahaanAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        // $this->headScript->appendFile('/action-js/mahasiswa-js/action-pengajuan-mhs.js');

        
        $this->layout("layout/layout_mahasiswa");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function prosesbimbinganAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-proses-bimbingan.js');

        
        $this->layout("layout/layout_mahasiswa");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }
}
