<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class PenilaianController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            // print_r($baseurl);die;

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');
            // $this->layout()->name = $userSession->get('usernamed');
            // $this->layout()->name1 = $userSession->get('name');
            $this->layout("layout/layout_mahasiswa");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function penilaianperusahaanAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            // $this->headScript->appendScript(' var iduser = null');
            // $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

            $this->headScript->appendFile($baseurl.'/action-js/penilaian-js/action-penilaian-perusahaan.js');
            
            $this->layout("layout/layout_admin");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function penilaianpengujiAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            // $this->headScript->appendScript(' var iduser = null');
            // $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

            $this->headScript->appendFile($baseurl.'/action-js/penilaian-js/action-penilaian-penguji.js');
            
            $this->layout("layout/layout_admin");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function nilaikpAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            // $this->headScript->appendScript(' var iduser = null');
            // $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

            $this->headScript->appendFile($baseurl.'/action-js/penilaian-js/action-penilaian-nilaikp.js');
            
            if($userSession->get('role') == 300){
                $this->layout("layout/layout_koordinator");
            }else{
                $this->layout("layout/layout_admin");
            }
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function nilaiperusahaanAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $urlvar  = base64_decode(urldecode($_GET['nim']));
            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            // $this->headScript->appendScript(' var iduser = null');
            $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

            $this->headScript->appendFile($baseurl.'/action-js/penilaian-js/action-nilai-perusahaan.js');
            
            $this->layout("layout/layout_admin");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function nilaipengujiAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        // print_r('')
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $urlvar  = base64_decode(urldecode($_GET['nim']));
            $urlid  = base64_decode(urldecode($_GET['param']));
            // print_r($urlid);die;
            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            // $this->headScript->appendScript(' var iduser = null');
            $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var identitas = "' . $urlid . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

            $this->headScript->appendFile($baseurl.'/action-js/penilaian-js/action-nilai-penguji.js');
            
            $this->layout("layout/layout_admin");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

}
