<?php
namespace Application\Model;

use Khansia\Generic\Objects\Map;
use Khansia\Generic\Objects\Mapper;
use Khansia\Generic\Set;
use Khansia\Generic\Result as Result;
use Dompdf\Dompdf;
use Dompdf\Options;
use PHPQRCode\PHPQRCode;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;



class Param extends Mapper {
	
	private $_storage;

    public function __construct(\Application\Model\Param\Storage\Skeleton $storage) {
		$this->_storage = $storage;
        $this->_result = new Result();

		parent::__construct(
                array(),
                array(
					// this mapper table on db
                ),
				parent::CASE_INSENSITIVE
			);
	}	
	
	
    public function getParam($paramtype = null, $param_val3 = null, $param_parent = null){
        $data = $this->_storage->loadParam($paramtype, $param_val3, $param_parent);
        return $data;
    }

    public function loadGlobal($table, $from, $where = null){
        $data = $this->_storage->loadTable($table, $from, $where);
        return $data;
    }

    public function countGlobal($table, $from, $where = null){
        $data = $this->_storage->countTable($table, $from, $where);
        return $data;
    }

    public function loadnilaiperprodi($param){
        $data = $this->_storage->loadnilaiperprodi($param);
        return $data;
    }

    public function loadataKaprodi($code = null){
        $data = $this->_storage->loadataKaprodi($code);
        return $data;
    }

    public function getDateNow(){
        $data = $this->_storage->loadDateNow();
        return $data->data;
    }
    

    public function checkDuplicateData($table, $column, $msg){
        $data = $this->_storage->checkDuplicateData($table, $column, $msg);
        return $data;
    }

    public function saveGlobal($param, $table, $seq = null){
        $data = $this->_storage->saveGlobal($param, $table, $seq);
        return $data;
    }

    public function dateformatter($date){
        $dateformats = date('d F Y', strtotime($date));
        return $dateformats;
    }

    public function dateformatterih($date){
        $dateformats = date('j/n/Y', strtotime($date));
        return $dateformats;
    }

    public function getindoday($days){
        switch($days){
            case 'Sunday':
                $days = "Minggu";
            break;
     
            case 'Monday':			
                $days = "Senin";
            break;
     
            case 'Tuesday':
                $days = "Selasa";
            break;
     
            case 'Wednesday':
                $days = "Rabu";
            break;
     
            case 'Thursday':
                $days = "Kamis";
            break;
     
            case 'Friday':
                $days = "Jumat";
            break;
     
            case 'Saturday':
                $days = "Sabtu";
            break;
            
            default:
                $days = "Tidak di ketahui";		
            break;
        }

        return $days;
    }

    public function bulanindo($bln){
        $bulan = $bln;
        $bulanstr = array (
            1 =>   'Januari',
            2 =>   'Februari',
            3 =>   'Maret',
            4 =>   'April',
            5 =>   'Mei',
            6 =>   'Juni',
            7 =>   'Juli',
            8 =>   'Agustus',
            9 =>   'September',
            10 =>  'Oktober',
            11 =>  'November',
            12 =>  'Desember'
        );

        $bulanform = $bulanstr[$bulan];
        return $bulanform;
    }

    public function dateformatterdays($date){
        $dateformats = date('l, d n Y', strtotime($date));
        $dateindo    = explode(',', $dateformats);
        
        $bulanpecah  = explode(' ', $dateindo[1]);
        $bulan       = $this->bulanindo($bulanpecah[2]);
        // print_r($bulan);die; 
        $hari        = $this->getindoday($dateindo[0]);
        

        $datefix     = $hari.", ". $bulanpecah[1]." ".$bulan." ".$bulanpecah[3];
        return $datefix;
    }

    public function generatesurat($data, $sign, $date, $nosurat, $mahasiswa, $batchdata, $urlbase, $tembusan){
        $result   = new Result();
        $exploded = explode("/", $urlbase);
        $projname = $exploded[3];
        $arrBatch = [];
        $number   = 1;
        $identits = '';

        // $arrTembusan = explode("<br>", $tembusan);

        // print_r($tembusan);die;
        
        foreach($batchdata as $vals){
            $nim      = $vals['nim'];
            $where    = "nim = '$nim'";
            $loadid   = $this->loadGlobal('t_mahasiswa', 'nama, nim', $where);
            array_push($arrBatch, $loadid->data[0]);
        }

        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        
        $tglsurat    = $this->dateformatter($date);
        $tglawal     = $this->dateformatter($data['tanggal_kerja_praktik_awal']. "+ 1 day");
        $tglakhir    = $this->dateformatter($data['tanggal_kerja_praktik_akhir']. "+ 1 day");
        $periods     = $tglakhir.' - '.$tglakhir;
        
        
        $nopeg       = $sign['nopeg'];
        $dir         = './public/data/qrcode/'.$nopeg.'.png';
        
        if(!file_exists($dir)){
            \PHPQRCode\QRcode::png($actual_link."/index/qr?nopeg=".$nopeg, "$dir", 'L', 4, 2);
            
        }else{
           
        }
        
        $namagelar = $sign['nama'];
        if(isset($sign['gelar_dpn'])){
            $namagelar = $sign['gelar_dpn']." ".$namagelar;
        }

        if(isset($sign['gelar_blk'])){
            $namagelar .= ', '.$sign['gelar_blk'];
        }
        
        // print_r($namagelar);die;
        // $tst = '<div style="position:absolute;top: 270px;left: 78px;font-size: 15.5px;color: #313131 ">'.$data['divisi_penerima'].'</div>
        //                         <div style="position:absolute;top: 289px;left: 78px;font-size: 15.5px;color: #313131; font-weight: bold">'.$data['nama_perusahaan'].'</div>
        //                         <div style="position:absolute;top: 309px;left: 78px;font-size: 15.5px;color: #313131 ">'.$data['alamat_perusahaan'].'</div>
        //                         <div style="position:absolute;top: 329px;left: 78px;font-size: 15.5px;color: #313131 ">'.$data['kode_pos'].'</div>'
        // print_r($this->basePath());die;
        // print_r($sign['nama_prodi']);die; 
        switch($sign['nama_prodi']){
            case "Teknik Mesin":
                $identits = '';
                $rowpos  = 950;
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 100px;font-size: 14px;color: #313131; ">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod      = $rowpos +20;
                $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 14px;color: #313131; font-weight: bold">Program studi: '.$sign['nama_prodi'].'</div>';
                
                $html = '
                    <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                                width: 210mm;
                                height: 297mm;
                   		        margin: 0px;
                		    }
                                                    
			            </style>
                    </head>
                        <body>
                            
                            <img src="'.$actual_link.'/data/surat/0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                                <div style="position:absolute;top: 143px;left: 170px;font-size: 15.5px;color: #313131 ">'.$nosurat.'</div>
                                <div style="position:absolute;top: 150px;right: 60px;font-size: 14px;color: #313131">Bandung, '.$tglsurat.'</div>
                                <div style=" border: 1px;position: absolute; top: 260px; left: 76px; width: 350px; font-size:15px">
                                    <div style="color: #313131 ">'.$data['divisi_penerima'].'</div>
                                    <div style="color: #313131; font-weight: bold">'.$data['nama_perusahaan'].'</div>
                                    <div style="color: #313131 ">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                                    <div style="color: #313131 "></div>
                                    
                                </div>
                                
                                <div style="width:280px;position:absolute;top: 870px;left: 475px;font-size: 16px;color: #313131">Ketua Program Studi</div>
                                <div style="width:280px;position:absolute;top: 890px;left: 475px;font-size: 16px;color: #313131">'.$sign['nama_prodi'].'</div>
                                <div style="width:280px;position:absolute;top: 1010px;left: 475px;font-size: 15.5px;color: #313131">
                                    <div style="font-size: 15.5px;color: #313131">'.$namagelar.'</div>
                                    <div style="font-size: 15.5px;color: #313131">NIP : '.$sign['nip'].'</div>
                                </div>
                                
                                <div style="width:280px;position:absolute;top: 1074.5px;left: 76px;font-size: 16px;color: #313131"> '.$tembusan.'</div>
                                <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 910px;right: 150px; width: 100px; height: 100px" id="capture">
                    
                                </img>
                            </img>
                            <div style="page-break-after: always;"></div>
                            <img src="'.$actual_link.'/data/surat/0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                                <div style="position:absolute;top: 172px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">'.$tglawal.'</div>
                                <div style="position:absolute;top: 190px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">- '.$tglakhir.'</div>
                                <div style="position:absolute;top: 335px;left: 420px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                                <div style="position:absolute;top: 335px;left: 80px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data['nama_perusahaan'].'</div>
                                '.
                                $identits
                            .'</img>
                        </body>
                    </html>
                   
                ';
                break;
            
            case "Teknik Dirgantara":

                $identits = '';
                $rowpos  = 800;
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 100px;font-size: 14px;color: #313131; ">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod      = $rowpos +20;
                $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 14px;color: #313131; font-weight: bold">Program studi: '.$sign['nama_prodi'].'</div>';

                $html = '
                <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                                width: 210mm;
                                height: 297mm;
                                margin: 0px;
                            }
                                                    
                        </style>
                    </head>
                    <body>
                        
                        <img src="'.$actual_link.'/data/surat/template/3f97474895ff443cb75fa179bf74cf13-0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                            <div style="position:absolute;top: 155px;left: 187px;font-size: 15.5px;color: #313131 ">'.$nosurat.'</div>
                            <div style="position:absolute;top: 150px;right: 80px;font-size: 14px;color: #313131">Bandung, '.$tglsurat.'</div>
                            <div style=" border: 1px;position: absolute; top: 260px; left: 76px; width: 350px; font-size:15px">
                                <div style="color: #313131; font-weight: bold">Kepada Yth : </div>
                                <div style="color: #313131 ">'.$data['divisi_penerima'].'</div>
                                <div style="color: #313131; font-weight: bold">'.$data['nama_perusahaan'].'</div>
                                <div style="color: #313131 ">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                                <div style="color: #313131 "></div>
                                
                            </div>
                            
                            <div style="width:280px;position:absolute;top: 1010px;left: 510px;font-size: 15.5px;color: #313131"><div style="font-size: 15.5px;color: #313131; text-decoration: underline; font-weight: bold">'.$namagelar.'</div><div style="font-size: 15.5px;color: #313131">NIP : '.$sign['nip'].'</div></div>
                            
                            <div style="width:280px;position:absolute;top: 1045.5px;left: 76px;font-size: 16px;color: #313131">'.$tembusan.'</div>
                            <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 930px;right: 150px; width: 80px; height: 80px" id="capture">
                
                            </img>
                        </img>
                        <div style="page-break-after: always;"></div>
                        <img src="'.$actual_link.'/data/surat/template/3f97474895ff443cb75fa179bf74cf13-0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                            <div style="position:absolute;top: 165px;left: 470px;font-size: 14px;color: #313131; font-weight: bold ">'.$tglawal." - ".$tglakhir.'</div>
                            
                            <div style="position:absolute;top: 255px;left: 395px;font-size: 14px; width: 300px; height: 62px; padding: 5px">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                            <div style="position:absolute;top: 255px;left: 80px;font-size: 14px; width: 300px; height: 62px; padding: 5px">'.$data['nama_perusahaan'].'</div>
                            '.
                            $identits
                        .'</img>
                    </body>
                </html>
                
                ';
                // print_r("kesini");die;
                break;

            case "Teknik Material":
                $identits = '';
                $rowpos  = 970;
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 150px;font-size: 14px;color: #000000; font-family: tahoma, sans-serif">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod      = $rowpos +20;
                // $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 14px;color: #313131; font-weight: bold">Program studi: '.$sign['nama_prodi'].'</div>';
                $html = '
                <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                                width: 210mm;
                                height: 297mm;
                                margin: 0px;
                            }
                                                    
                        </style>
                    </head>
                    <body>
                        
                        <img src="'.$actual_link.'/data/surat/template/material_0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                            <div style="position:absolute;top: 175px;left: 260px;font-size: 15.5px;color: #000000;">'.$nosurat.'</div>
                            
                            <div style=" border: 1px;position: absolute; top: 260px; left: 85px; width: 350px; font-size:15px; font-weight: bold;  font-family: tahoma, sans-serif ">
                                <div style="color: #000000;">Kepada Yth.</div>
                                <div style="color: #000000 ">'.$data['divisi_penerima'].'</div>
                                <div style="color: #000000;">'.$data['nama_perusahaan'].'</div>
                                <div style="color: #000000 ">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                                <div style="color: #000000 "></div>
                                
                            </div>
                            
                            <div style="width:280px; position: absolute; top: 940px; left: 475px; font-size: 15.5px; color: #313131">
                                <div style="font-size: 15.5px;color: #000000">Bandung, 5 Juli 2021</div>
                                <div style="font-size: 15.5px;color: #000000">Ketua Program Studi Teknik Material</div>
                            </div>
                            <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 980px;right: 150px; width: 70px; height: 70px" id="capture">
                            <div style="width:280px;position:absolute;top: 1050px;left: 475px;font-size: 15.5px;color: #313131;">
                                <div style="font-size: 15.5px;color: #000000; text-decoration: underline">'.$namagelar.'</div>
                                <div style="font-size: 15.5px;color: #000000">NIP : '.$sign['nip'].'</div>
                            </div>
                            
                            <div style="width:280px;position:absolute;top: 1040.5px;left: 76px;font-size: 14px;color: #313131; font-family: tahoma, sans-serif">Tembusan Yth:<br>'.$tembusan.'</div>
                            
                
                            </img>
                        </img>
                        <div style="page-break-after: always;"></div>
                        <img src="'.$actual_link.'/data/surat/template/material_0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                            <div style="position:absolute;top: 283px;left: 250px;font-size: 14px;color: #000000; font-weight: bold; font-family: tahoma, sans-serif ">'.$tglawal."<br>- ".$tglakhir.'</div>
                            
                            <div style="position:absolute;top: 370px;left: 420px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data['alamat_perusahaan'].' '.$data['kode_pos'].'</div>
                            <div style="position:absolute;top: 370px;left: 150px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data['nama_perusahaan'].'</div>
                            '.$identits.'
                        </img>
                    </body>
                </html>
                
                ';
                break;
        }

        
	   
        $options = new Options();
        $options->setIsRemoteEnabled(true);
        $options->setisHtml5ParserEnabled(true);
	    $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'potrait');
        
        $dompdf->render();
        $output = $dompdf->output();
        
        $randomname = self::generateRandomCharacter();
        $dirSurat   = './public/data/surat/'.$data['nama_perusahaan']."_".self::generateRandomCharacter().'.pdf';
        // $dirSurat   = './public/data/surat/testDirgantara.pdf';
        file_put_contents($dirSurat, $output);
        
        if(file_exists($dirSurat)){
            $result->code = 0;
            $result->info = "Sukses Generate Surat";
            $result->data = $dirSurat;
        } else {
            $result->code = 1;
            $result->info = "Gagal Generate Surat";
	    }
        // print_r($result);die;
        return $result;
    }

    public function generatesuratedt($data, $sign, $date, $nosurat, $mahasiswa, $batchdata, $urlbase, $arrAcc){
        $result   = new Result();
        $exploded = explode("/", $urlbase);
        $projname = $exploded[3];
        $arrBatch = [];
        $number   = 1;
       
        
       
        foreach($batchdata as $vals){
            $nim      = $vals['nim'];

            if(in_array($nim, $arrAcc)){
                $where    = "nim = '$nim'";
                $loadid   = $this->loadGlobal('t_mahasiswa', 'nama, nim', $where);
                array_push($arrBatch, $loadid->data[0]);
            }
           
        }
        
        // print_r($identits);die;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        
        
        $tglsurat    = $this->dateformatter($date);
        $tglawal     = $this->dateformatter($data->tanggal_awal. "+ 1 day");
        $tglakhir    = $this->dateformatter($data->tanggal_akhir. "+ 1 day");
        $periods     = $tglakhir.' - '.$tglakhir;
        
        
        $nopeg       = $sign['nopeg'];
        $dir         = './public/data/qrcode/'.$nopeg.'.png';
        
        if(!file_exists($dir)){
            \PHPQRCode\QRcode::png($actual_link."/index/qr?nopeg=".$nopeg, "$dir", 'L', 4, 2);
        }
        
        $namagelar = $sign['nama'];
        if(isset($sign['gelar_dpn'])){
            $namagelar = $sign['gelar_dpn']." ".$namagelar;
        }

        if(isset($sign['gelar_blk'])){
            $namagelar .= ', '.$sign['gelar_blk'];
        }

        switch($sign['nama_prodi']){
            case "Teknik Mesin":
                $identits = '';
       
                $rowpos  = 950;
                
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 100px;font-size: 15.5px;color: #313131; ">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod = $rowpos +20;
                $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 15.5px;color: #313131; ">Program studi: '.$sign['nama_prodi'].'</div>';
                
                $html = '
                    <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                    		width: 210mm;
                    		height: 297mm;
                    
                   		margin: 0px;
                		}
                                                    
			            </style>
                    </head>
                        <body>
                            
                            <img src="'.$actual_link.'/data/surat/0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                                <div style="position:absolute;top: 143px;left: 170px;font-size: 15.5px;color: #313131 ">'.$nosurat.'</div>
                                <div style="position:absolute;top: 150px;right: 60px;font-size: 14px;color: #313131">Bandung, '.$tglsurat.'</div>
                                <div style=" border: 1px;position: absolute; top: 260px; left: 76px; width: 350px; font-size:15px">
                                    <div style="color: #313131 ">'.$data->divisi_penerima.'</div>
                                    <div style="color: #313131; font-weight: bold">'.$data->nama_perusahaan.'</div>
                                    <div style="color: #313131 ">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                    <div style="color: #313131 "></div>
                                </div>
                                
                                <div style="width:280px;position:absolute;top: 870px;left: 475px;font-size: 16px;color: #313131">Ketua Program Studi</div>
                                <div style="width:280px;position:absolute;top: 890px;left: 475px;font-size: 16px;color: #313131">'.$sign['nama_prodi'].'</div>
                                <div style="width:280px;position:absolute;top: 1010px;left: 475px;font-size: 16px;color: #313131">
                                    <div style="font-size: 15.5px;color: #313131">'.$namagelar.'</div>
                                    <div style="font-size: 15.5px;color: #313131">NIP : '.$sign['nip'].'</div>
                                </div>

                                <div style="width:280px;position:absolute;top: 1074.5px;left: 76px;font-size: 16px;color: #313131">- '.$data->tembusan.'</div>
                                <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 910px;right: 150px; width: 100px; height: 100px" id="capture">
                    
                                </img>
                            </img>
                            <div style="page-break-after: always;"></div>
                            <img src="'.$actual_link.'/data/surat/0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                                <div style="position:absolute;top: 172px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">'.$tglawal.'</div>
                                <div style="position:absolute;top: 190px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">- '.$tglakhir.'</div>
                                <div style="position:absolute;top: 335px;left: 420px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                <div style="position:absolute;top: 335px;left: 80px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->nama_perusahaan.'</div>
                                '.
                                $identits
                            .'</img>
                        </body>
                    </html>
                   
                ';
                break;
            
            case "Teknik Dirgantara":
                $identits = '';
                $rowpos  = 800;
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 100px;font-size: 14px;color: #313131; ">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod      = $rowpos +20;
                $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 14px;color: #313131; font-weight: bold">Program studi: '.$sign['nama_prodi'].'</div>';

                $html = '
                <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                                width: 210mm;
                                height: 297mm;
                                margin: 0px;
                            }
                                                    
                        </style>
                    </head>
                    <body>
                        
                        <img src="'.$actual_link.'/data/surat/template/3f97474895ff443cb75fa179bf74cf13-0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                            <div style="position:absolute;top: 155px;left: 187px;font-size: 15.5px;color: #313131 ">'.$nosurat.'</div>
                            <div style="position:absolute;top: 150px;right: 80px;font-size: 14px;color: #313131">Bandung, '.$tglsurat.'</div>
                            <div style=" border: 1px;position: absolute; top: 260px; left: 76px; width: 350px; font-size:15px">
                                <div style="color: #313131; font-weight: bold">Kepada Yth : </div>
                                <div style="color: #313131 ">'.$data->divisi_penerima.'</div>
                                <div style="color: #313131; font-weight: bold">'.$data->nama_perusahaan.'</div>
                                <div style="color: #313131 ">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                <div style="color: #313131 "></div>
                                
                            </div>
                            
                            <div style="width:280px;position:absolute;top: 1010px;left: 510px;font-size: 15.5px;color: #313131"><div style="font-size: 15.5px;color: #313131; text-decoration: underline; font-weight: bold">'.$namagelar.'</div><div style="font-size: 15.5px;color: #313131">NIP : '.$sign['nip'].'</div></div>
                            
                            <div style="width:280px;position:absolute;top: 1045.5px;left: 76px;font-size: 16px;color: #313131">'.$data->tembusan.'</div>
                            <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 930px;right: 150px; width: 80px; height: 80px" id="capture">
                
                            </img>
                        </img>
                        <div style="page-break-after: always;"></div>
                        <img src="'.$actual_link.'/data/surat/template/3f97474895ff443cb75fa179bf74cf13-0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                            <div style="position:absolute;top: 165px;left: 470px;font-size: 14px;color: #313131; font-weight: bold ">'.$tglawal." - ".$tglakhir.'</div>
                            
                            <div style="position:absolute;top: 255px;left: 395px;font-size: 14px; width: 300px; height: 62px; padding: 5px">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                            <div style="position:absolute;top: 255px;left: 80px;font-size: 14px; width: 300px; height: 62px; padding: 5px">'.$data->nama_perusahaan.'</div>
                            '.
                            $identits
                        .'</img>
                    </body>
                </html>
                
                ';
                break;

            case "Teknik Material":
                $identits = '';
                $rowpos  = 970;
                foreach($arrBatch as $mhs){
                    
                    $identits .= '<div style="position:absolute;top:'. $rowpos.'px;left: 150px;font-size: 14px;color: #000000; font-family: tahoma, sans-serif">'.$number.'. '.$mhs['nama'].' / NIM. '.$mhs['nim'].'</div>';
                    $number++;
                    $rowpos += 20;
                }

                $rowprod      = $rowpos +20;
                // $identits    .= '<div style="position:absolute;top: '.$rowprod.'px;left: 78px;font-size: 15.5px;color: #313131; ">Program studi: '.$sign['nama_prodi'].'</div>';
                
                $html = '
                    <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                    		width: 210mm;
                    		height: 297mm;
                    
                   		margin: 0px;
                		}
                                                    
			            </style>
                    </head>
                        <body>
                            
                            <img src="'.$actual_link.'/data/surat/0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                                <div style="position:absolute;top: 143px;left: 170px;font-size: 15.5px;color: #313131 ">'.$nosurat.'</div>
                                <div style="position:absolute;top: 150px;right: 60px;font-size: 14px;color: #313131">Bandung, '.$tglsurat.'</div>
                                <div style=" border: 1px;position: absolute; top: 260px; left: 76px; width: 350px; font-size:15px">
                                    <div style="color: #313131 ">'.$data->divisi_penerima.'</div>
                                    <div style="color: #313131; font-weight: bold">'.$data->nama_perusahaan.'</div>
                                    <div style="color: #313131 ">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                    <div style="color: #313131 "></div>
                                </div>
                                
                                <div style="width:280px;position:absolute;top: 870px;left: 475px;font-size: 16px;color: #313131">Ketua Program Studi</div>
                                <div style="width:280px;position:absolute;top: 890px;left: 475px;font-size: 16px;color: #313131">'.$sign['nama_prodi'].'</div>
                                <div style="width:280px;position:absolute;top: 1010px;left: 475px;font-size: 16px;color: #313131">
                                    <div style="font-size: 15.5px;color: #313131">'.$namagelar.'</div>
                                    <div style="font-size: 15.5px;color: #313131">NIP : '.$sign['nip'].'</div>
                                </div>

                                <div style="width:280px;position:absolute;top: 1074.5px;left: 76px;font-size: 16px;color: #313131">- '.$data->tembusan.'</div>
                                <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 910px;right: 150px; width: 100px; height: 100px" id="capture">
                    
                                </img>
                            </img>
                            <div style="page-break-after: always;"></div>
                            <img src="'.$actual_link.'/data/surat/0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                                <div style="position:absolute;top: 172px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">'.$tglawal.'</div>
                                <div style="position:absolute;top: 190px;left: 540px;font-size: 15.5px;color: #313131; font-weight: bold ">- '.$tglakhir.'</div>
                                <div style="position:absolute;top: 335px;left: 420px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                <div style="position:absolute;top: 335px;left: 80px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->nama_perusahaan.'</div>
                                '.
                                $identits
                            .'</img>
                        </body>
                    </html>
                   
                ';

                $html = '
                <html>
                    <head>
                        <style>
                            @page { margin: 0px; }
                            body{
                                width: 210mm;
                                height: 297mm;
                                margin: 0px;
                            }
                                                    
                        </style>
                    </head>
                    <body>
                        
                        <img src="'.$actual_link.'/data/surat/template/material_0001.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                            <div style="position:absolute;top: 175px;left: 260px;font-size: 15.5px;color: #000000;">'.$nosurat.'</div>
                            
                            <div style=" border: 1px;position: absolute; top: 260px; left: 85px; width: 350px; font-size:15px; font-weight: bold;  font-family: tahoma, sans-serif ">
                                <div style="color: #000000;">Kepada Yth.</div>
                                <div style="color: #000000 ">'.$data->divisi_penerima.'</div>
                                <div style="color: #000000;">'.$data->nama_perusahaan.'</div>
                                <div style="color: #000000 ">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                                <div style="color: #000000 "></div>
                                
                            </div>
                            
                            <div style="width:280px; position: absolute; top: 940px; left: 475px; font-size: 15.5px; color: #313131">
                                <div style="font-size: 15.5px;color: #000000">Bandung, 5 Juli 2021</div>
                                <div style="font-size: 15.5px;color: #000000">Ketua Program Studi Teknik Material</div>
                            </div>
                            <img src="'.$actual_link.'/data/qrcode/'.$nopeg.'.png" style=" position:absolute;top: 980px;right: 150px; width: 70px; height: 70px" id="capture">
                            <div style="width:280px;position:absolute;top: 1050px;left: 475px;font-size: 15.5px;color: #313131;">
                                <div style="font-size: 15.5px;color: #000000; text-decoration: underline">'.$namagelar.'</div>
                                <div style="font-size: 15.5px;color: #000000">NIP : '.$sign['nip'].'</div>
                            </div>
                            
                            <div style="width:280px;position:absolute;top: 1040.5px;left: 76px;font-size: 14px;color: #313131; font-family: tahoma, sans-serif">Tembusan Yth:<br>'.$data->tembusan.'</div>
                            
                
                            </img>
                        </img>
                        <div style="page-break-after: always;"></div>
                        <img src="'.$actual_link.'/data/surat/template/material_0002.jpg" style=" background-size:cover;width: 210mm;height: 297mm;" id="capture">
                            <div style="position:absolute;top: 283px;left: 250px;font-size: 14px;color: #000000; font-weight: bold; font-family: tahoma, sans-serif ">'.$tglawal."<br>- ".$tglakhir.'</div>
                            
                            <div style="position:absolute;top: 370px;left: 420px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->alamat_perusahaan.' '.$data->kode_pos.'</div>
                            <div style="position:absolute;top: 370px;left: 150px;font-size: 15.5px; width: 300px; height: 62px; padding: 5px">'.$data->nama_perusahaan.'</div>
                            '.$identits.'
                        </img>
                    </body>
                </html>
                
                ';
                break;
        }
	    
        
        $options = new Options();
        $options->setIsRemoteEnabled(true);
        $options->setisHtml5ParserEnabled(true);
	    $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'potrait');
        $dompdf->render();
        $output = $dompdf->output();
        
        $randomname = self::generateRandomCharacter();
        $dirSurat   = './public/data/surat/'.$data->nama_perusahaan."_".self::generateRandomCharacter().'.pdf';
        // $dirSurat   = './public/data/surat/'.$data->nama_perusahaan.'.pdf';

        file_put_contents($dirSurat, $output);
        
        if(file_exists($dirSurat)){
            $result->code = 0;
            $result->info = "Sukses Generate Surat";
            $result->data = $dirSurat;
        } else {
            $result->code = 1;
            $result->info = "Gagal Generate Surat";        
        }

        return $result;
    }

    private function generateRandomCharacter($len = 10){
        $charset    = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        $base       = strlen($charset);
        $result     = '';
      
        $now        = explode(' ', microtime())[1];
        
        while ($now >= $base){
          $i        = $now % $base;
          $result   = $charset[$i] . $result;
          $now     /= $base;
        }
        $ran        = bin2hex(random_bytes(10));
        $stbh       = substr($result, -5);
        
        return $ran.$stbh;
    }

    public function urlbase(){
    
		$uri         = $this->getRequest()->getUri();
		/* ledakan */
		$seni       = explode('/', $uri->getPath());
		$path       =  substr(sprintf('//%s:%s%s', $uri->getHost(), $uri->getPort(), $uri->getPath()), 0, -1);
		if(count($seni) > 3){
		  $path     = sprintf('//%s:%s%s', $uri->getHost(), $uri->getPort(), $seni[1]);
		}else{
			// $path     = '';
		}
		$path    = $uri->getPath();
		$baseurl = sprintf('//%s', $uri->getHost()).':'.$uri->getPort().$path;
		$cunt = explode("/",$baseurl);
		
		if(count($cunt) > 6){
		    $baseurl = substr($baseurl, 0, -1);
			$tes = explode("/",$baseurl);
		    $removed = array_splice($tes, -2);
		    $baseurl = join("/",$tes);
		}else{
		    $baseurl = substr($baseurl, 0, -1);
        }
        
		return $baseurl;
	  }
    
    public function urlChecker($url){
        $url = "www.s.id/ruangpersentasi12";
        $result  = false;

        if (!preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i",$url)) {
            $result = false;
        }else{
            $result = true;
        }

        return $result;
    }

    public function generatepengumuman($datareal, $datakaprodi, $tglnow, $urlbase){
        $exploded = explode("/", $urlbase);
        $projname = $exploded[3];

        $qrdir       = $this->qrmaker($datakaprodi['nopeg'], $urlbase);
        // print_r($datareal['id_jadwal']);die;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        $tanggal     = $this->dateformatterdays($datareal['tanggal']);
        $tanggalsek  = $this->dateformatterdays($tglnow);
        $tangalskrg  = explode(',', $tanggalsek);
        // print_r($tanggalsek);die;
        $namagelar = $datakaprodi['nama'];
        if(isset($datakaprodi['gelar_dpn'])){
            $namagelar = $datakaprodi['gelar_dpn']." ".$namagelar;
        }

        if(isset($datakaprodi['gelar_blk'])){
            $namagelar .= ', '.$datakaprodi['gelar_blk'];
        }

        $namapembimbing = $datareal['dosen_pembimbing'];
        $namapenguji = $datareal['namapenguji1'];

        if(isset($datareal['dpembimbing'])){
            $namapembimbing = $datareal['dpembimbing']." ".$namapembimbing;
        }

        if(isset($datakaprodi['bpembimbing'])){
            $namapembimbing .= ', '.$datareal['bpembimbing'];
        }

        if(isset($datareal['dpenguji'])){
            $namapenguji = $datareal['dpenguji']." ".$namapenguji;
        }

        if(isset($datakaprodi['bpenguji'])){
            $namapenguji .= ', '.$datareal['bpenguji'];
        }

        /* REGEX URL */
        
        if( $this->urlChecker($datareal['ruang']) ){
            $ruang = "Via Zoom (Link dapat dilihat di email)";
        } else {
            $ruang = $datareal['ruang'];
        }


        //print_r($qrdir);die;
        // print_r($tanggal);die;
        $html = '
        <html>
            <head>
                <style>
                    @page { margin: 0px; }
                    body { margin: 0px; }

                    .attendance-table table{
                        width: 100%;
                        border-collapse: collapse;
                        border: 1px solid #000;
                      }
                      
                      .blank-cell{
                      
                        min-width: 50px;
                      
                      
                      }
                      
                      .attendance-cell{
                      
                        padding: 8px;
                      
                      
                      }
                      
                      .attendance-table table th.attendance-cell, .attendance-table table td.attendance-cell {
                          border: 1px solid #000;
                      }

                      table{
                        border-collapse: collapse;
                      }
                                    
        
                </style>
            </head>
                <body>
                    
                    <img src="'.$actual_link.'/data/template/pengumumann.jpg" style=" background-repeat: no-repeat;width: 210mm;height: 297mm; position: relative;top: 0px;left: 0px;" id="capture">
                        <div style="position:absolute;top: 245px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Hari / Tanggal</div>
                        <div style="position:absolute;top: 245px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: <span style="font-weight: bold">'.$tanggal.'</span></div>    
                        <div style="position:absolute;top: 264px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Pukul </div>
                        <div style="position:absolute;top: 264px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: '.substr($datareal['jam'], 0, 5).' - selesai</div>
                        <div style="position:absolute;top: 283px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Tempat </div>
                        <div style="position:absolute;top: 283px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: '.$ruang.'</div>
                        <div style="position:absolute;top: 302px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Nama Mahasiswa</div>
                        <div style="position:absolute;top: 302px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: '.$datareal['nim_mhs'].' / '.$datareal['nama'].'</div>
                        <div style="position:absolute;top: 321px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Pembimbing </div>
                        <div style="position:absolute;top: 321px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: '.$namapembimbing.'</div>
                        <div style="position:absolute;top: 341px;left: 148px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">Penguji </div>
                        <div style="position:absolute;top: 341px;left: 293px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">: '.$namapenguji.'</div>

                        <div style="position:absolute;top: 542px;left: 560px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">'.$tangalskrg[1].'</div>
                        <div style="position:absolute;top: 559px;left: 630px;font-size: 16px;color: #313131; font-family: "Times New Roman", Times, serif; ">'. $datakaprodi['nama_prodi'] .'</div>
                        <div style="width:280px;position:absolute;top: 680px;left: 492px;font-size: 15.5px;color: #313131"><div style="font-size: 16px;color: #313131" text-decoration: underline;>'.$namagelar.'</div><div style="font-size: 16px;color: #313131">NIP : '.$datakaprodi['nip'].'</div></div>
                        
                        <img src="'.$qrdir.'" style=" position:absolute;top: 580px;right: 150px; width: 100px; height: 100px" id="capture"></img>
                    </img>
                    
                    
                </body>
            </html>
        
        ';
	
        $options = new Options();
        $options->setIsRemoteEnabled(true);
        $options->setisHtml5ParserEnabled(false);
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'potrait');

        $dompdf->render();
        $output = $dompdf->output();
        $filename = $datareal['id_jadwal'].'_'.$datareal['nim_mhs'].'.pdf';
        file_put_contents('./public/data/pengumuman/'.$filename, $output);
        
        if(file_exists('./public/data/pengumuman/'.$filename)){
            $where       = "id_jadwal = ".$datareal['id_jadwal'];
            $dataArray   = array(
                'file_jadwal'     => $filename
            );
            $result      = $this->updateGlobal('sipenkp_jadwal', $dataArray, $where);
        }
        // print_r($result);
        return $filename;
    } 

    public function generatereport($data, $tglawal, $tglakhir, $kodeprodi, $urlbase){

        $exploded    = explode("/", $urlbase);
        $projname    = $exploded[3];
        $datas       = $data[0];
        $loadkaprodi = $this->loadataKaprodi($kodeprodi);
        $datakaprodi = $loadkaprodi->data[0];
        $tglreport   = $this->dateformatter($tglawal)."-".$this->dateformatter($tglakhir);
        $tglaw       = $this->dateformatterih($tglawal);
        $tglak       = $this->dateformatterih($tglakhir);
        
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        $rowcount    = 37;
        
        $namagelar = $datakaprodi['nama'];
        if(isset($datakaprodi['gelar_dpn'])){
            $namagelar = $datakaprodi['gelar_dpn']." ".$datakaprodi['nama'];
        }

        if(isset($datakaprodi['gelar_blk'])){
            $namagelar .= ', '.$datakaprodi['gelar_blk'];
        }


        $qrdir = $this->qrmaker($datakaprodi['nopeg'], $urlbase);
        // print_r($qrdir);die;
        $maxpageone = 14;
        $maxpagen   = 23;
        // print_r(count($data));die;
        $html = '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <style>
                @page { margin-top: 30px;
                        margin-left: 0px;
                        margin-right:0px;
                        margin-bottom:0px; }
                body{
                    width: 210mm;
                    height: 297mm;
                    
                    margin: 0px;
                }
        
                table{
                    position: relative;
                    left:20px;
                    border-spacing: -1px;
                    border: 1px;
                    width: 95%;
                    border-left: 1px solid #ccc;
                    border-right: 1px solid #ccc;
                    border-top: 1px solid #ccc;
                    border-bottom: 1px solid #ccc;
                    border-collapse: collapse;
                    margin-top: 20px;
                    
                }

              
                table td,
                table th {
                    border: 1px;
                    border-left: 1px solid #black;
                    border-right: 1px solid #black;
                    border-top: 1px solid #black;
                    border-bottom: 1px solid #black;
                    border-collapse: collapse;
                }
        
                td{
                    text-align: center;
                    padding: 5px;
                    font-size: 10px;
                }

                .left{
                    text-align: left;
                    padding: 5px;
                    font-size: 10px;
                }
		
                th{
                    font-size: 12px;
                }

                .sign{
                    margin-top: 20px;
                    position: relative;
                    left: 550px;
                }
            </style>
        </head>
        <body>
            <center>
                <h1>Nilai Kerja Praktik</h1>
                <h2 style="margin-top:0px">Program Studi '.$datas['nama_prodi'].'</h2>
            </center>

            <div style="float: right; margin-right:20px; margin-top:40px; font-size: 14px">Tanggal : '.$tglaw.' - '.$tglak.'</div>
            <table style="">
                <tr>
                    <th width="25px">No</th>
                    <th width="90px">Nim</th>
                    <th>Nama</th>
                    <th>Pembimbing</th>
                    <th>Penguji</th>
                    <th width="80px">Persentasi</th>
                    <th width="40px">Total Nilai</th>
                    <th width="40px">Nilai Akhir</th>
                </tr>';
        $rowttd = 5;
        $page = 1;
        $number = 1;
        foreach($data as $i){
           
            $html   .=  '<tr>
                            <td>'.$number++.'</td>
                            <td>'.$i['nim'].'</td>
                            <td class="left">'.$i['nama'].'</td>
                            <td class="left">'.$i['dosen_pembimbing'].'</td>
                            <td class="left">'.$i['dosen_penguji'].'</td>
                            <td>'. $this->dateformatterih($i["tanggal"]) .'</td>
                            <td >'.$i['nilai_akhir'].'</td>
                            <td >'.$i['nilai_mutu'].'</td>
                        </tr>';
            
            
           
           
        }
        $html   .=' </table>
                        <div class="sign" style="width: 220px; ">
                        <div>Ketua Program Studi</div>
                        <div>'.$datakaprodi['nama_prodi'].'</div>
                        <img src="'.$qrdir.'" style=" width: 100px; height: 100px; margin-top:15px; margin-left: 65px" id="capture"></img>
                        <div>
                            <div>'.$namagelar.'</div>
                            <div>NIP. '.$datakaprodi['nip'].'</div>
                        </div>
                    </div>
                </body>
                </html>';
        
        $options = new Options();
        $options->setIsRemoteEnabled(true);
        $options->setisHtml5ParserEnabled(true);
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'potrait');

        $dompdf->render();
        // $dompdf->stream('my.pdf',array('Attachment'=>false));
        // exit(0);
        // $dompdf->save();
        $output = $dompdf->output();
        $filename = "Report Kerja Praktik ".$datakaprodi['nama_prodi']."_$tglreport.pdf";
        file_put_contents('./public/data/reporting/'.$filename, $output);
            
        return $filename;
    }

    public function generatereportexcel($data, $tglawal, $tglakhir, $kodeprodi, $urlbase){
        $loadkaprodi = $this->loadataKaprodi($kodeprodi);
        $datakaprodi = $loadkaprodi->data[0];
        $tglreport   = $this->dateformatter($tglawal)."-".$this->dateformatter($tglakhir);
        
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('B2', 'No');
        $sheet->setCellValue('C2', 'Nim');
        $sheet->setCellValue('D2', 'Nama');
        $sheet->setCellValue('E2', 'Pembimbing');
        $sheet->setCellValue('F2', 'Penguji');
        $sheet->setCellValue('G2', 'Periode Kerja Praktik');
        $sheet->setCellValue('H2', 'Tanggal Persentasi');
        $sheet->setCellValue('I2', 'Nilai Akhir');
        $sheet->setCellValue('J2', 'Nilai Mutu');

        $i = 3;
        $no = 1;
        foreach($data as $row){
            $sheet->setCellValue('B'.$i, $no++);
            $sheet->setCellValue('C'.$i, $row['nim_mhs']);
            $sheet->setCellValue('D'.$i, $row['nama']);
            $sheet->setCellValue('E'.$i, $row['dosen_pembimbing']);	
            $sheet->setCellValue('F'.$i, $row['dosen_penguji']);
            $sheet->setCellValue('G'.$i, $row['mulai_kp']." / ".$row['akhir_kp']);
            $sheet->setCellValue('H'.$i, $row['tanggal']);
            $sheet->setCellValue('I'.$i, $row['nilai_akhir']);
            $sheet->setCellValue('J'.$i, $row['nilai_mutu']);
            $i++;
        }

        $styleArray = [
			'borders' => [
				'allBorders' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
			],
		];
        $i = $i - 1;
        $sheet->getStyle('B2:J'.$i)->applyFromArray($styleArray);
        
        $sheet->getColumnDimension('B')->setAutoSize(true);
        $sheet->getColumnDimension('C')->setAutoSize(true);
        $sheet->getColumnDimension('D')->setAutoSize(true);
        $sheet->getColumnDimension('E')->setAutoSize(true);
        $sheet->getColumnDimension('F')->setAutoSize(true);
        $sheet->getColumnDimension('G')->setAutoSize(true);
        $sheet->getColumnDimension('H')->setAutoSize(true);
        $sheet->getColumnDimension('I')->setAutoSize(true);
        $sheet->getColumnDimension('J')->setAutoSize(true);

        $filename   = "Report Kerja Praktik ".$datakaprodi['nama_prodi']."_$tglreport.xlsx";
        $writer     = new Xlsx($spreadsheet);
        $writer->save('./public/data/reporting/'.$filename);

        return $filename;
    }

    public function loadjadwalperm($idkp){
        $data = $this->_storage->loadjadwalperm($idkp);
        return $data;
    }

    public function qrmaker($nomor, $urlbase){
        $exploded = explode("/", $urlbase);
        $projname = $exploded[3];
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        $nopeg       = $nomor;
        // print_r($nopeg);die;
        $dir         = './public/data/qrcode/'.$nopeg.'.png';
        if(!file_exists($dir)){
            \PHPQRCode\QRcode::png($actual_link."/index/qr?nopeg=".$nopeg, "$dir", 'L', 4, 2);
        }

        return $actual_link.'/data/qrcode/'.$nopeg.'.png';
    }

    public function sendemail($idkp, $tglnow, $urlbase, $from){
        $result = new Result();                         
        //print_r(!extension_loaded('openssl')?"Not Available":"Available");die;
        $exploded = explode("/", $urlbase);
        $projname = $exploded[3];
        
        // print_r($idkp);die;
        $listdata      = array();

        

        if($from == "update"){
                $data                = $this->loadjadwalperm($idkp);
                $datareal            = $data->data[0];
                $datakapr            = $this->loadataKaprodi(substr($datareal['nim'], 0, 3));
                $datakaprodi         = $datakapr->data[0];
                $ispengumumansuccess = $this->generatepengumuman($datareal, $datakaprodi, $tglnow, $urlbase);
    
                array_push($listdata, array(
                    "attachment"   => $ispengumumansuccess,
                    "email_penguji"    => $datareal['emailpenguji'],
                    "email_pembimbing" => $datareal['emailpembimbing'],
                    "email_mahasiswa"  => $datareal['email']
                ));
        }else{
            for($i = 0; $i < count($idkp); $i++){

                $data                = $this->loadjadwalperm($idkp[$i]);
                $datareal            = $data->data[0];
                $datakapr            = $this->loadataKaprodi(substr($datareal['nim'], 0, 3));
                $datakaprodi         = $datakapr->data[0];
                $ispengumumansuccess = $this->generatepengumuman($datareal, $datakaprodi, $tglnow, $urlbase);
    
                array_push($listdata, array(
                    "attachment"   => $ispengumumansuccess,
                    "email_penguji"    => $datareal['emailpenguji'],
                    "email_pembimbing" => $datareal['emailpembimbing'],
                    "email_mahasiswa"  => $datareal['email']
                ));
            }
        }
        
        $emails      = $this->loadGlobal('master_parameter', '*', "param_type = 'EMAILPARAM'");
        $email       = $emails->data[0]['param_val1'];
        $passwd      = $emails->data[0]['param_val3'];
        
        $mail = new PHPMailer();
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        $links       = $_SERVER['DOCUMENT_ROOT'];
	
        try {
            //Server settings
            $mail->SMTPDebug = SMTP::DEBUG_OFF;                      // Enable verbose debug output
            $mail->isSMTP();                                            // Send using SMTP
            $mail->Host       = 'smtp.gmail.com';                    // Set the SMTP server to send through
            $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
            // $mail->Username   = 'reynaldi.adriantama@gmail.com';                     // SMTP username
            // $mail->Password   = 'rey14nal14di14';                               // SMTP password

            $mail->Username   = $email;
            $mail->Password   = $passwd;
            //$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
            $mail->Port       = 587;                                    // TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above
        	
            //Recipients
            $mail->setFrom('tu@ftmd.itb.ac.id', 'Jadwal Seminar Kerja Praktik ');
            // $mail->addAddress('ramadhanprtma04@gmail.com', 'Ramadhan Pratama');     // Add a recipient
            $mail->addAddress('reynaldi.adriantama@gmail.com');               // Name is optional
            // $mail->addReplyTo('info@example.com', 'Information');
            // $mail->addCC('cc@example.com');
            // $mail->addBCC('bcc@example.com');
            
            // if(isset($datareal['email'])){
            //     $mail->addAddress($datareal['email']);
            // }

            // if(isset($datareal['emailpenguji'])){
            //     $mail->addAddress($datareal['emailpenguji']);
            // }

            // if(isset($datareal['emailpembimbing'])){
            //     $mail->addAddress($datareal['emailpembimbing']);
            // }
            // Attachments
            // $mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
            for($x = 0; $x < count($listdata); $x++){
                // $mail->addAddress($listdata[$x]['email_penguji']);
                // $mail->addAddress($listdata[$x]['email_pembimbing']);
                // $mail->addAddress($listdata[$x]['email_mahasiswa']);
                $mail->addAttachment($links.'data/pengumuman/'.$listdata[$x]['attachment'], 'jadwal.pdf');    // Optional name
            }
            
        	// print_r($mail);die;
            // Content
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = 'Pelaksanaan Seminar Kerja Praktik ';
            $mail->Body    = 'Sehubungan dengan akan diadakannya seminar Kerja Praktik untuk mahasiswa
                              maka kami lampirkan detail pelaksanaan seminar kerja praktik dibawah.<br> dan untuk url zoom meeting sebagai berikut : '.$datareal['ruang'].'';
            
            if($mail->send() == true){
                $result->code = 0;
                $result->info = "Send Email Success";
            } else {
                $result->code = 1;
                $result->info = $mail->ErrorInfo;
            }
            
        } catch (Exception $e) {
            $result->info = $mail->ErrorInfo;
            $result->code = 4;
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }

       return $result;
    }
   
    public function updateGlobal($tabel, $data, $where){
        $data = $this->_storage->updateGlobal($tabel, $data, $where);
        return $data;
    }

    public function editbobotbatch($tabel, $data){
        $data = $this->_storage->editbobotbatch($tabel, $data);
        return $data;
    }

    public function updatestatustenggat(){
        $data = $this->_storage->updatestatustenggat();
        return $data;
    }

    public function submitnilaiperusahaan($tabel, $data, $idnilai, $iduser){
        $data = $this->_storage->submitnilaiperusahaan($tabel, $data, $idnilai, $iduser);
        return $data;
    }

    public function submitnilaipenguji($tabel, $data, $idnilai , $iduser , $ididentity , $identity ){
        // print_r($ididentity.$identity);die;
        $data = $this->_storage->submitnilaipenguji($tabel, $data, $idnilai, $iduser, $ididentity, $identity);
        return $data;
    }

    public function deletebobot($tabel, $data){
        $data = $this->_storage->deletebobot($tabel, $data);
        return $data;
    }

    public function getLastSeqPostgree($tabel, $column){
        $data = $this->_storage->getLastSeqPostgree($tabel, $column);
        return $data;
    }

    public function deleteGlobal($tabel, $where){
        $data = $this->_storage->deleteGlobal($tabel, $where);
        return $data;
    }

    public function insertCoordinate($param, $type){
        $data = $this->_storage->saveCoordinate($param, $type);
        return $data;
    }

    public function getMaxParamVal($_long){
        $data = $this->_storage->loadMaxParamVal($_long);
        return $data;
    }

    public function getElementQue($param, $lvl){
        $data = $this->_storage->loadElementQue($param, $lvl);
        return $data;
    }

    public function getQueSort($param){
        $data = $this->_storage->loadQueSort($param);
        return $data;
    }

    public function loadSurveyProfilePartialAdmin($judul = null, $publish = null, $start = null, $limit = null, $count = null, $order = null, $sort = null){
        $data = $this->_storage->loadSurveyProfilePartialAdmin($judul, $publish, $start, $limit, $count, $order, $sort);
        return $data;
    }

    public function loadUser($id = null){
        $data = $this->_storage->loadUser($id);
        return $data;
    }

    public function loadMahasiswa($id = null){
        $data = $this->_storage->loadMahasiswa($id);
        return $data;
    }

    public function selectmhs($id = null){
        $data = $this->_storage->selectmhs($id);
        return $data;
    }

    public function loadmhsbyprodi($id = null){
        $data = $this->_storage->loadmhsbyprodi($id);
        return $data;
    }

    public function loadperusahaan($id = null){
        $data = $this->_storage->loadperusahaan($id);
        return $data;
    }

    public function loaddashboardadmin($id = null){
        $data = $this->_storage->loaddashboardadmin($id);
        return $data;
    }

    public function loaddashboarddosen($id = null){
        $data = $this->_storage->loaddashboarddosen($id);
        return $data;
    }

    public function loaddashboardmahasiswa($id = null){
        $data = $this->_storage->loaddashboardmahasiswa($id);
        return $data;
    }

    public function loadCalendarData($tgl = null){
        $data = $this->_storage->loadCalendarData($tgl);
        return $data;
    }

    public function loaddatajadwal($nim = null){
        $data = $this->_storage->loaddatajadwal($nim);
        return $data;
    }

    public function loaddsn($id = null){
        $data = $this->_storage->loaddsn($id);
        return $data;
    }

    public function loadpembimbing($id = null){
        $data = $this->_storage->loadpembimbing($id);
        return $data;
    }

    public function detailPengajuan($id = null){
        $data = $this->_storage->detailPengajuan($id);
        return $data;
    }

    public function loadAttach($id = null){
        $data = $this->_storage->loadAttach($id);
        return $data;
    }

    public function loadbobot($id = null){
        $data = $this->_storage->loadbobot($id);
        return $data;
    }

    public function getMateriPartial($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadMateriPartial($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loaddosen($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadDosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadMahasiswaS($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadMahasiswaS($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function daftarMahasiswa($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->daftarMahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function listbimbingan($nopeg = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->listbimbingan($nopeg, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loaduserlist($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaduserlist($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function listpengajuan($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $nim){
        $data = $this->_storage->listpengajuan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
        return $data;
    }

    public function listperusahaan($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $nim){
        $data = $this->_storage->listperusahaan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
        return $data;
    }

    public function listpilihpembimbing($kodeprodi = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $nim){
        $data = $this->_storage->listpilihpembimbing($kodeprodi ,$col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
        return $data;
    }

    public function reviewpengajuan($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $nim){
        $data = $this->_storage->reviewpengajuan($col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
        return $data;
    }

    public function loadjadwallist($kodeprodi ,$col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadjadwallist($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadnilaiperusahaan($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadnilaiperusahaan($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadnilaipenguji($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadnilaipenguji($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadnilaipengujiasdsn($peran = null, $nopeg = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadnilaipengujiasdsn($peran, $nopeg, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function datanilaiakhir($kodeprodi = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->datanilaiakhir($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadmhsvalid($kodeprodi = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loadmhsvalid($kodeprodi, $col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }
    public function buatjadwallist($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->buatjadwallist($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function loadStatusBerkas($nim = null){
        $data = $this->_storage->loadStatusBerkas($nim);
        return $data;
    }

    public function loadStatusBerkasM($nim = null){
        $data = $this->_storage->loadStatusBerkasM($nim);
        return $data;
    }

    public function loaddatakp($nim = null){
        $data = $this->_storage->loaddatakp($nim);
        return $data;
    }

    public function loadproseskp($nim = null){
        $data = $this->_storage->loadproseskp($nim);
        return $data;
    }

    public function loadpengajuans($nim = null){
        $data = $this->_storage->loadpengajuans($nim);
        return $data;
    }

    public function loaddatakps($nim = null){
        $data = $this->_storage->loaddatakps($nim);
        return $data;
    }

    public function nilaiperusahaan($idkp = null){
        $data = $this->_storage->nilaiperusahaan($idkp);
        return $data;
    }

    public function nilaipenguji($idkp = null){
        $data = $this->_storage->nilaipenguji($idkp);
        return $data;
    }

    public function nilaipembimbing($idkp = null){
        $data = $this->_storage->nilaipembimbing($idkp);
        return $data;
    }

    public function loadfilebimbingan($nim = null, $nopeg = null){
        $data = $this->_storage->loadfilebimbingan($nim, $nopeg);
        return $data;
    }

    public function ishavepembimbing($nim = null){
        $data = $this->_storage->ishavepembimbing($nim);
        return $data;
    }
    
    public function getMappingMateri($param){
        $data = $this->_storage->loadMappingMateri($param);
        return $data;
    }

    public function getdatamahasiswa($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $filter = null){
        $data = $this->_storage->loaddatamahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search, $filter);
        return $data;
    }

    public function getusermahasiswa($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $filter=null){
        $data = $this->_storage->loadusermahasiswa($col, $orderCol, $orderDir, $start, $length, $draw, $search, $filter);
        return $data;
    }

    public function hardSaveGlobal($dataarr=null, $table=null){
        $data = $this->_storage->hardSaveGlobal($dataarr, $table);
        return $data;
    }

    public function hardSaveGlobalMahasiswa($dataarr=null, $table=null, $conflict=null){
        $data = $this->_storage->hardSaveGlobalMahasiswa($dataarr, $table, $conflict);
        return $data;
    }

    public function hardSaveGlobalMahasiswaxlsx($dataarr=null, $table=null, $conflict=null){
        $data = $this->_storage->hardSaveGlobalMahasiswaxlsx($dataarr, $table, $conflict);
        return $data;
    }

    public function getuserdosen($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaduserdosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function getuserakademik($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaduserakademik($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function getdatadosen($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaddatadosen($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function getdataakademik($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaddataakademik($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function getuserkaprodi($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaduserkaprodi($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function getuserkoordinator($col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null){
        $data = $this->_storage->loaduserkoordinator($col, $orderCol, $orderDir, $start, $length, $draw, $search);
        return $data;
    }

    public function testconnection($host , $port = null , $email , $password)
	{
        $result = new Result();
		//Create a new SMTP instance
		$smtp = new SMTP;

		//Enable connection-level debug output
		$smtp->do_debug = SMTP::DEBUG_OFF;

		try {
			//Connect to an SMTP server
			if (!$smtp->connect($host, $port)) {
                $result->code = 4;
                $result->info = 'Connect failed';
				throw new Exception('Connect failed');
			}

			//Say hello
			if (!$smtp->hello(gethostname())) {
                $result->code = 4;
                $result->info = 'EHLO failed: ' . $smtp->getError()['error'];
				//throw new Exception('EHLO failed: ' . $smtp->getError()['error']);
			}

    	    //Get the list of ESMTP services the server offers
			$e = $smtp->getServerExtList();

    	    //If server can do TLS encryption, use it
			if (is_array($e) && array_key_exists('STARTTLS', $e)) {
				$tlsok = $smtp->startTLS();
				if (!$tlsok) {
                    $result->code = 4;
                    $result->info = 'Failed to start encryption: ' . $smtp->getError()['error'];
					//throw new Exception('Failed to start encryption: ' . $smtp->getError()['error']);
				}
				
            //Repeat EHLO after STARTTLS
				if (!$smtp->hello(gethostname())) {
                    $result->code = 4;
                    $result->info = 'EHLO (2) failed: ' . $smtp->getError()['error'];
					//throw new Exception('EHLO (2) failed: ' . $smtp->getError()['error']);
				}
            //Get new capabilities list, which will usually now include AUTH if it didn't before
				$e = $smtp->getServerExtList();
			}

    	    //If server supports authentication, do it (even if no encryption)
			if (is_array($e) && array_key_exists('AUTH', $e)) {
				if ($smtp->authenticate( $email , $password)) {
                    $result->code = 0;
                    $result->info = "Email Verified";
					// echo "Connected ok!";
				} else {
                    $result->code = 4;
                    $result->info = "Authentication failded: ".$smtp->getError()['error'];
					// throw new Exception('Authentication failed: ' . $smtp->getError()['error']);
				}
			}
		} catch (Exception $e) {
			echo 'SMTP error: ' . $e->getMessage(), "\n";
		}
		//Whatever happened, close the connection.
		$smtp->quit(true);
		return $result;
	}

    public function getlistapproval($kodeprodi = null, $col = null, $orderCol = null, $orderDir = null, $start = null, $length = null, $draw = null, $search = null, $nim){
        $data = $this->_storage->loadlistapproval($kodeprodi ,$col, $orderCol, $orderDir, $start, $length, $draw, $search, $nim);
        return $data;
    }

    public function getmahasiswaforjadwal($nim = null){
        // print_r($nim." this is spartan");die;
        $data = $this->_storage->getmahasiswaforjadwal($nim);
        return $data;
    }
   
}
