<?php
/**
 * @var Laminas\View\Renderer\PhpRenderer $this
 */
?>

<?= $this->doctype() ?>

<!DOCTYPE html>
<html  lang="en">
  <head>
        <meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
        <?= $this->headTitle('Laminas MVC Skeleton')->setSeparator(' - ')->setAutoEscape(false) ?>

        <?= $this->headMeta()
            ->appendName('viewport', 'width=device-width, initial-scale=1.0')
            ->appendHttpEquiv('X-UA-Compatible', 'IE=edge')
        ?>

        <!-- Le styles -->
        <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
		<?= $this->headLink(['rel' => 'shortcut icon', 'type' => 'image/vnd.microsoft.icon', 'href' => $this->basePath() . '/img/favicon.ico'])
           
        ?>
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/icons/icomoon/styles.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/bootstrap.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/components.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/core.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/colors.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/extras/animate.min.css" rel="stylesheet" type="text/css">
        <link href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/assets/css/jquery-confirm.min.css" rel="stylesheet" type="text/css">
		<link rel="stylesheet" href="<?php echo '//'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].$this->basePath();?>/distro/colorpick/jquery.minicolors.css">

    </head>

    <style>
      /* width */
      ::-webkit-scrollbar {
        width: 5px;
      }

      /* Track */
      ::-webkit-scrollbar-track {
        background: #f1f1f1;
      }

      /* Handle */
      ::-webkit-scrollbar-thumb {
        background: #888;
      }

      /* Handle on hover */
      ::-webkit-scrollbar-thumb:hover {
        background: #555;
      }

      .page_loader {
				position: fixed;  
        background-size: 150px !important;
				background: url('../../img/loadingtwo.gif') 50% 50% no-repeat rgb(249,249,249);
				left: 0px;
				top: 0px;
				width: 100%;
				height: 100%;
				z-index: 9999;
				opacity: .5;
			}

      
    </style>

    <body class="sidebar-main-hidden" style="overflow-x: hidden;">
        <div class="page_loader"></div>

        <?= $content ?>

        
        <?php $this->endBody() ?>
    </body>
</html>
<?php $this->endPage() ?>

