$(document).ready(function(){
    $('.pickatime-disabled').pickatime({
        // format: 'yyyy, mm dd',
        disable: [
           [12,0],
           [12,30]
        ],
        min: [13,0],
        max: [17,0],
       
    });

    $('.pickadate').pickadate({
        // Escape any “rule” characters with an exclamation mark (!).
        // minDate: new Date.now(),
        // minDate: '22/10/2020',
        format: 'dd mmmm yyyy',
        formatSubmit: 'yyyy/mm/dd',
        // monthsFull: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
        hiddenPrefix: 'prefix__',
        hiddenSuffix: '__suffix'
    });

    $('.daterange-basic').daterangepicker({
        applyClass: 'bg-slate-600',
        cancelClass: 'btn-default'
    });

    $(".btn-modal").on("click", function(){
        $("#modal-add").modal("show");
    })

    $("#submitpengajuan").on("click", function(){
        savepengajuan();
    })

    
})

const CODE_VALID = 104;
const CODE_NOTVALID = 105;

function savepengajuan(){
    var isObject = {};

    isObject.nama_perusahaan    = $("#nama_perusahaan").val();
    isObject.penerima_surat     = $("#penerima_surat").val();
    isObject.telp_perusahaan    = $("#telp_perusahaan").val();
    isObject.tanggalAwal        = dateformats($("#tanggalAwal").val());
    isObject.tanggalAkhir       = dateformats($("#tanggalAkhir").val());
    isObject.alamat_perusahaan  = $("#alamat_perusahaan").val();
    isObject.nim                = $("#nim_mhs").val();
    
    console.log(isObject);

    if(isObject.nama_perusahaan == "" || isObject.nama_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Nama perusahaan tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.penerima_surat == "" || isObject.penerima_surat == null){
        swal({
            title: "Alert",
            text:  "Penerima tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.telp_perusahaan == "" || isObject.telp_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Telepon perusahaan tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.tanggalAwal == "" || isObject.tanggalAwal == null){
        swal({
            title: "Alert",
            text:  "Tanggal Mulai tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.tanggalAkhir == "" || isObject.tanggalAkhir == null){
        swal({
            title: "Alert",
            text:  "Tanggal Berhenti tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.alamat_perusahaan == "" || isObject.alamat_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Tanggal Berhenti tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(!isFutureDate(isObject.tanggalAwal)){
        swal({
            title: "Peringatan!",
            text:" Tanggal tidak valid",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!daterangeCheck(isObject.tanggalAwal, isObject.tanggalAkhir)){
        swal({
            title: "Peringatan!",
            text:" Tanggal akhir tidak boleh kurang dari tanggal awal",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    


    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/savepengajuan',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat pengantar KP telah diajukan ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

}

function dateformats(date){
    var dateNew     = new Date(date);
    var dateString  = 
        ("0" + (1 + dateNew.getUTCDate())).slice(-2) + "-" +
        ("0" + (dateNew.getUTCMonth()+1)).slice(-2) + "-" +
        dateNew.getUTCFullYear();

    return dateString;
}

function isFutureDate(idate){
    var today = new Date().getTime();
    var idate = idate.split("-");

    idate = new Date(idate[2], idate[1] - 1, idate[0]).getTime();
    return (today - idate) < 0;
}

function daterangeCheck(idateAW, idateAK){
    var idateAK = idateAK.split("-");
    var idateAW = idateAW.split("-");

    idateAW = new Date(idateAW[2], idateAW[1] - 1, idateAW[0]).getTime();
    idateAK = new Date(idateAK[2], idateAK[1] - 1, idateAK[0]).getTime()
    return (idateAW - idateAK) < 0;
}

loadElementspembimbing(kodeprodi);
function loadElementspembimbing(kodeprodi){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;
    isObject.kodeprodi = kodeprodi

    var dtpr = $('#list_pengajuan').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/listpilihpembimbing',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    // var datas;
                    // var dataada=[];
                    // // datas.push(data[0])
                    // // console.log(datas);
                    // for(i in data){
                    //     datas = {
                    //         "id_mhs": data[i].id_mhs,
                    //         "nim": data[i].nim,
                    //         "nama": data[i].nama,
                    //         "jurusan": data[i].jurusan,
                    //         "jeniskelamin": data[i].jeniskelamin,
                    //         "fakultas": data[i].fakultas,
                    //         "create_date": data[i].create_date,
                    //         // "status": statusberkas(data[i].nim)
                    //     }
                    //     dataada.push(datas)
                    // }
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'id_kp', 'sClass':'','sWidth':'10px'},
            { 'data': 'nim', 'sClass':''},
            { 'data': 'nama', 'sClass':''},
            { 'data': 'nama_prodi', 'sClass':''},
            { 'data': 'nama_dosen', 'sClass':''},
            { 'data': 'status_pembimbing', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        // buttons: {            
        //     buttons: [
        //         {
        //             extend: 'colvis',
        //             className: 'btn btn-default'
        //         },
        //     ]
        // },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            {   


                render: function (data, type, row){
                    // var $rowData = '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt" style="cursor: pointer;">';
                    var $rowData = ``;
                    console.log(row.nama_dosen);
                    if(row.nama_dosen == null || row.nama_dosen == ""){
                        $rowData += '<span class="text-center">-</span>';
                    } else {
                        $rowData += row.nama_dosen;
                    }

                    return $rowData;
                },
                visible: true,
                targets: 4,
            },  
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    // if(row.status_pengajuan == 91){
                    //     $rowData ='<span style="min-width: 70px" class="label bg-grey-400">'+row.status+'</span>';
                    // }else if(row.status_pengajuan == 92){
                    //     $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    // }else if(row.status_pengajuan == 102){
                    //     $rowData ='<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    // }else if(row.status_pengajuan == 103){
                    //     $rowData ='<span style="min-width: 70px" class="label label-primary">'+row.status+'</span>';
                    // }else if(row.status_pengajuan == 101){
                    //     $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    // }
                    // else if(row.status_pengajuan == 104){
                    //     $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    // }
                    // else if(row.status_pengajuan == 105){
                    //     $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    // }
                    console.log(row.status_pembimbing)
                    if(row.status_pembimbing == null || row.status_pembimbing == ""){
                        $rowData = '<span style="min-width: 70px" class="label label-danger">BELUM MEMILIKI PEMBIMBING</span>';
                    } else {
                        if(row.status_pembimbing == '130'){
                            $rowData = '<span style="min-width: 70px" class="label label-success">SUDAH MEMILIKI PEMBIMBING</span>';
                        }else {
                            $rowData = '<span style="min-width: 70px" class="label label-warning">'+row.param_type+'</span>';
                        }
                    }

                    return $rowData;
                    // return $rowData;
                },
                visible: true,
                targets: 5,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;


                        if(row.status_pembimbing == null || row.status_pembimbing == ""){
                            $rowData = `<ul class="icons-list">
                                            <li class="dropdown">
                                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="icon-menu9"></i>
                                                </a>

                                                <ul class="dropdown-menu dropdown-menu-right">
                                                    <li  onclick="modalpembimbing('`+row.nim+`','`+row.nama+`','`+row.id_kp+`')"class=""><a><i class=" icon-file-eye2"></i>Pilih Pembimbing</a></li>
                                                </ul>
                                            </li>
                                        </ul>`;
                        } else {
                            if(row.status_pembimbing == '130'){
                                $rowData = `<ul class="icons-list">
                                            <li class="dropdown">
                                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="icon-menu9"></i>
                                                </a>

                                                <ul class="dropdown-menu dropdown-menu-right">
                                                <li  onclick="alertnotupload()"class=""><a><i class=" icon-file-eye2"></i>Pilih Pembimbing</a></li>
                                                </ul>
                                            </li>
                                        </ul>`;
                                        // modalupdate('`+row.nim+`','`+row.nama+`','`+row.nama_dosen+`')
                            }else {
                                $rowData = `<ul class="icons-list">
                                            <li class="dropdown">
                                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="icon-menu9"></i>
                                                </a>

                                                
                                            </li>
                                        </ul>`;
                            }
                            
                        }

                    return $rowData;
                },
                visible: true,
                targets: 6,
                className: 'dt-center'
            },
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');

            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

// loadElementspengajuanreview();
function loadElementspengajuanreview(clicksc){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;

    var dtpr = $('#list_review').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/reviewpengajuan',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    // var datas;
                    // var dataada=[];
                    // // datas.push(data[0])
                    // // console.log(datas);
                    // for(i in data){
                    //     datas = {
                    //         "id_mhs": data[i].id_mhs,
                    //         "nim": data[i].nim,
                    //         "nama": data[i].nama,
                    //         "jurusan": data[i].jurusan,
                    //         "jeniskelamin": data[i].jeniskelamin,
                    //         "fakultas": data[i].fakultas,
                    //         "create_date": data[i].create_date,
                    //         // "status": statusberkas(data[i].nim)
                    //     }
                    //     dataada.push(datas)
                    // }
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'id_pengajuan', 'sClass':'','sWidth':'10px'},
            { 'data': 'nama', 'sClass':''},
            { 'data': 'nama_perusahaan', 'sClass':''},
            { 'data': 'alamat_perusahaan', 'sClass':''},
            { 'data': 'nama_penerima_perusahaan', 'sClass':''},
            { 'data': 'status', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        // buttons: {            
        //     buttons: [
        //         {
        //             extend: 'colvis',
        //             className: 'btn btn-default'
        //         },
        //     ]
        // },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            {   


                // render: function (data, type, row){
                //     // var $rowData = '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt" style="cursor: pointer;">';
                //     let isIcon = ' icon-file-download2';

                //     var $rowData = '<div class="thumb img-rounded img-preview showAtt" style="width: 70px;">'+
                //         '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt">'+
                //         '<div class="caption-overflow">'+
                //             '<span>'+
                //                 '<p  class="btn showAtt bg-success-400 btn-icon btn-lg" style="font-variant: all-petite-caps;background-color: #0e0e0e33 !important;border-color: #25252591 !important;">'+
                //                     '<i class="'+isIcon+'"></i> '
                //                 '</p>'+
                //             '</span>'+
                //         '</div>'+
                //     '</div>';

                //     return $rowData;
                // },
                // visible: true,
                // targets: 1,
            },  
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    if(row.status_pengajuan == 91){
                        $rowData ='<span style="min-width: 70px" class="label bg-grey-400">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 92){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 102){
                        $rowData ='<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 103){
                        $rowData ='<span style="min-width: 70px" class="label label-primary">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 101){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }
                    return $rowData;
                    // return $rowData;
                },
                visible: true,
                targets: 5,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;

                    
                        if(row.status_pengajuan == 91){ //menunggu surat dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="generatesurat('`+row.nim+`', '`+row.nama_perusahaan+`')" class=""><a "><i class=" icon-file-eye2"></i> Generate Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        } else if (row.status_pengajuan == 92){ //surat telah dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 101){ //diterima di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 102){ //ditolak di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                        else if (row.status_pengajuan == 103){ //menunggu validasi berkas
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a "><i class=" icon-file-eye2"></i>Validasi Persetujuan</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                    

                    return $rowData;
                },
                visible: true,
                targets: 6,
                className: 'dt-center'
            },
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');

            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

function generatesurat(nim, perusahaan){
    var isObject = {}

    isObject.nim           = nim;
    isObject.perusahaan    = perusahaan;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/generatesurat',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat Pengantar KP telah digenerate",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function showfile(aData, nim){  
    var cols = `<input id="nim_mhs" value="`+nim+`" type="hidden" class="form-control" placeholder="Nama Perusahaan..">`;
    $('.modal-body').empty();
    $('.modal-body').append(cols)
    $('.modal-body').append(`<embed src="`+aData+`" type="application/pdf"   style="width: 100%; height: 100%; min-height: 480px;">`);
    $("#modal-review").modal('show');
   
}


$("#valid").on("click", function(){
    checkberkas(true);
})


$("#notvalid").on("click", function(){
    checkberkas(false);
})

function checkberkas(code){
    var isObject = {};
    isObject.nim   = $("#nim_mhs").val();
    isObject.isvalid = code;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/validasiperusahaan',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat konfirmasi telah di validasi, silahkan memilih dosen pembimbing",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function modalpembimbing(nim, nama, idkp){
    $("#nama_mhs").val(nama);
    $("#nim").val(nim);
    loadtopik(idkp);
    $("#modal-pembimbing").modal('show');
}

function modalupdate(nim, nama, dosen){
    $("#nama_mhsedt").val(nama);
    $("#nimedt").val(nim);
    $("#pembimbingedt").val(dosen);

    $("#modal-update").modal('show');

}

function alertnotupload(){
    swal({
        title: "Peringatan!",
        text:" Mahasiswa sudah memiliki pembimbing!",
        confirmButtonColor: "#2196F3",
        type: "warning"
    });
}

loaddosen();
function loaddosen(){
    let isObject = {};
    isObject.param = iduser;
    // console.log(isObject)

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loaddsn',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            $("tbody").empty();
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                // console.log(result.data);
                let data    = result.data;
                let counter = 1;
                console.log(data)

                var cols = "";
                for(i in data){
                    if(data[i].gelar_dpn != null && data[i].gelar_blk != null){
                        cols += '<option value="'+data[i].nopeg+'">'+data[i].gelar_dpn+" "+data[i].nama+", "+data[i].gelar_blk+'</option> ';
                    }else if(data[i].gelar_dpn == null && data[i].gelar_blk != null){
                        cols += '<option value="'+data[i].nopeg+'">'+data[i].nama+", "+data[i].gelar_blk+'</option> ';
                    }else if(data[i].gelar_dpn != null && data[i].gelar_blk == null){
                        cols += '<option value="'+data[i].nopeg+'">'+data[i].gelar_dpn+" "+data[i].nama+'</option> ';
                    } else {
                        cols += '<option value="'+data[i].nopeg+'">'+data[i].nama+'</option> ';
                    }
                    
                }

                $("#pembimbing").empty();
                $("#pembimbing").append(cols);
                $("#pembimbings").empty();
                $("#pembimbings").append(cols);


            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}


$("#btn-pembimbing").on("click",function(){
    // var isObject = {};
    // isObject.nim    = $("#nim").val();
    // isObject.nope   = $("#pembimbing").val();

    setPembimbing();
})

$("#btn-pembimbingedt").on("click",function(){
    // var isObject = {};
    // isObject.nim    = $("#nim").val();
    // isObject.nope   = $("#pembimbing").val();

    updatePembimbing();
})

function updatePembimbing(){
    var isObject = {};
    isObject.nim    = $("#nimedt").val();
    isObject.nope   = $("#pembimbings").val();
    console.log(isObject.nope);
    

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/updatepembimbing',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){


            if(response.code == CODE_SUCCESS){
                
                swal({
                    title: "Alert",
                    text:  " Pembimbing telah dipilih!",
                    confirmButtonColor: "#2196F3",
                    type: "success"
                }, function(){
                    location.reload();
                });  
                // console.log(result.data)
                location.reload();

            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function setPembimbing(){
    var isObject = {};
    isObject.nim    = $("#nim").val();
    isObject.nope   = $("#pembimbing").val();
    
    loaderPage(true);
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/pilihpembimbing',
        // async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){


            if(response.code == CODE_SUCCESS){
                
                swal({
                    title: "Alert",
                    text:  " Pembimbing telah dipilih!",
                    confirmButtonColor: "#2196F3",
                    type: "success"
                }, function(){
                    location.reload();
                });  
                // console.log(result.data)
                // location.reload();
                loaderPage(false);
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function loadtopik(idkp){
    var isObject = {};
    isObject.idkp = idkp;
    
    var status;
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadtopik',
        // async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
                
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                let data    = result.data;
                console.log(data);
                $("#topik").val(data[0].topik);
                
            } else {
                $("#topik").val(" ");
            }

            
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}