<?php

    /* @var $this \yii\web\View */
    /* @var $content string */

    use app\widgets\Alert;
    use yii\helpers\Html;
    use app\assets\AppAssetCostumHeaderFront;


    AppAssetCostumHeaderFront::register($this);

?>

<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    
	<!-- Global stylesheets -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
    <?php $this->head() ?>
</head>

<style>
    .frame-container iframe {
        top:0;
        left: 0;
        width: 100%;
        height: 100%;
        overflow-x:hidden;
		position: absolute;
        overflow-y:scroll;
        margin-left: 0.1px;
    }

    /* width */
	::-webkit-scrollbar {
	width: 5px;
	}

	/* Track */
	::-webkit-scrollbar-track {
	background: #f1f1f1;
	}

	/* Handle */
	::-webkit-scrollbar-thumb {
	background: #888;
	}

	/* Handle on hover */
	::-webkit-scrollbar-thumb:hover {
		background: #555;
	}

	.navbar-inverse {
		background-color: #e11931 !important;
		background: url(../img/reds.jpg);
    	background-position: bottom;
		border: 1px solid #e71000 !important;
	}

	.navbar-brand {
		float: left;
		padding: 13px 20px !important;
		font-size: 14px !important;
		line-height: 20px !important;
		height: 46px !important;
	}

	@media (min-width: 769px){
		.navbar-text + .navbar-nav {
			margin-left: 100px;
		}
	}



</style>

<body class="navbar-top pace-done" style="overflow-x: hidden;">

<?php $this->beginBody() ?>
	<!-- Main navbar -->
	<div class="navbar navbar-inverse navbar-fixed-top header-highlight">
		<!-- <div class="navbar-header"> -->
			<!-- <a class="navbar-brand" href="#"><img src="../img/logo_light9.png" alt="" style="margin-top: -5px; height: 30px;"></a> -->
			<a class="navbar-brand" href="#"onClick="openIndexHome()" ><i class="icon icon-earth"></i> <!--img src="assets/images/logo_light.png" alt=""-->i@Smart</a>
			<ul class="nav navbar-nav pull-right visible-xs-block">
				<li><a data-toggle="collapse" data-target="#navbar-mobile"><i class="icon-tree5"></i></a></li>
				<!-- <li><a class="sidebar-mobile-main-toggle"><i class="icon-paragraph-justify3"></i></a></li>
				<li><a class="sidebar-mobile-detached-toggle"><i class="icon-grid7"></i></a></li> -->
			</ul>
		<!-- </div> -->

		<div class="navbar-collapse collapse" id="navbar-mobile">
			<!-- <ul class="nav navbar-nav">
				<li>
					<a class="sidebar-control sidebar-main-toggle hidden-xs">
						<i class="icon-paragraph-justify3"></i>
					</a>
				</li>
			</ul> -->

			<p class="navbar-text">
				<span class="label bg-primary" style="background-color: #af004f; border-color: #c1014e00; color: #fff;">survey online</span>
			</p>

			<ul class="nav navbar-nav">
				<li>
					<a href="#" onClick="openIndexHome()" class="" style="font-weight: 500;">
						<i class="icon-home position-left"></i> Home 
					</a>
				</li>
				<li>
					<a href="#" onClick="openMySurvey()" style="font-weight: 500;">
						<i class="icon-quill4 position-left"></i> MySurvey 
					</a>
				</li>

				<!-- <li class="dropdown">
					<a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
						<i class="icon-dots position-left"></i> Levels <span class="caret"></span>
					</a>

					<ul class="dropdown-menu dropdown-menu-right">
						<li><a href="#"><i class="icon-IE"></i> Second level</a></li>
						<li class="dropdown-submenu">
							<a href="#"><i class="icon-firefox"></i> Has child</a>
							<ul class="dropdown-menu">
								<li><a href="#"><i class="icon-android"></i> Third level</a></li>
								<li class="dropdown-submenu">
									<a href="#"><i class="icon-apple2"></i> Has child</a>
									<ul class="dropdown-menu">
										<li><a href="#"><i class="icon-html5"></i> Fourth level</a></li>
										<li><a href="#"><i class="icon-css3"></i> Fourth level</a></li>
									</ul>
								</li>
								<li><a href="#"><i class="icon-windows"></i> Third level</a></li>
							</ul>
						</li>
						<li><a href="#"><i class="icon-chrome"></i> Second level</a></li>
					</ul>
				</li> -->

			</ul>

			<div class="navbar-right">
				<ul class="nav navbar-nav">
					<li class="dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown">
							<i class="icon-people"></i>
							<span class="visible-xs-inline-block position-right">Users</span>
						</a>
						
					</li>
					<li class="dropdown dropdown-user">
						<a class="dropdown-toggle" data-toggle="dropdown">
							<img src="assets/images/placeholder.jpg" alt="">
							<span><?= Yii::$app->user->identity->name ?></span>
							<i class="caret"></i>
						</a>

						<ul class="dropdown-menu dropdown-menu-right">
							<li><a href="/site/logout"><i class="icon-switch2"></i> Logout</a></li>
						</ul>
					</li>
				</ul>
			</div>

		</div>
	</div>
	<!-- /main navbar -->


	<!-- Page container -->
	<div class="page-container text-size-small">

		<!-- Page content -->
		<div class="page-content">

			



            <div class="frame-container ">
                <span id="thisFrame"></span>
            </div>

		<!-- /page content -->

	</div>
	<!-- /page container -->


    <!-- <script type="text/javascript" src=" /action-js/global-js/javaScriptGlobal.js"></script> -->
    
    <script type="text/javascript">


        function openHome(){
            var id_li = 'infoui';
            var id_content = 'infoui_tab';
            var label_tab = 'Setup Running Text';
            var src = '/index/homescreen';
            addtab(id_li,id_content,label_tab,src);
        }

		function openTicketListdata(){    
            var id_li = 'infoui';
            var id_content = 'infoui_tab';
            var label_tab = 'Setup Running Text';
            var src = 'index.php?r=site%2Fabout';
            addtab(id_li,id_content,label_tab,src);
		}
		
        function openListdata(){    
            var id_li = 'infoui';
            var id_content = 'infoui_tab';
            var label_tab = 'Setup Running Text';
			var src = '/ticket/dashboard';
            addtab(id_li,id_content,label_tab,src);
        }

        function openUserManagement(){    
            var id_li = 'infoui';
            var id_content = 'infoui_tab';
            var label_tab = 'Setup Running Text';
			var src = '/user/usermanagement';
            addtab(id_li,id_content,label_tab,src);
		}
		
        function openIndexHome(){    
            var id_li = 'indexsurvey';
            var id_content = 'indexsurvey_tab';
            var label_tab = 'Setup Running Text';
			var src = '/magic/indexsurvey';
            addtab(id_li,id_content,label_tab,src);
		}

        function openMySurvey(){    
            var id_li = 'mysurvey';
            var id_content = 'mysurvey_tab';
            var label_tab = 'Setup Running Text';
			var src = '/magic/mysurvey';
            addtab(id_li,id_content,label_tab,src);
		}
		

    </script>
    <!-- Scripts -->
    

    <?php $this->endBody() ?>
    </body>
</html>
<?php $this->endPage() ?>
