<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class ContentController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        // $userSession = $this->getSession();
        // $owner       = $userSession->owner();
        // echo($owner);die;
        $this->redirect()->toRoute('home');
    }

    public function listcontentAction(){
        $this->isLoggedIn();

        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = $this->urlLedakan();

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/content-js/action-content-listcontent.js');

        
        $this->layout("layout/layout_admin_body");
        

        return $view;
    }

    public function setupcontentAction(){
        
        $this->isLoggedIn();
     
        $view   = new ViewModel();
        $result = new Result();

        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
       
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = $this->urlLedakan();

        $conID   = $uri->getQuery();
        
        $eplo    = explode('=', $conID);

        if(!$conID){
            return $this->redirect()->toRoute('login');
            exit();
        }        

        /* encrpt id */                        
        $thisEncyID = self::url_encryptd($conID, self::PHRASE, self::SKEY); 

        $actionName = $this->params('action');

        $this->headScript->appendScript(' var thisIdProfile = "' . $conID . '"');
        $this->headScript->appendScript(' var thisEncyIDProfile = "' . $thisEncyID . '"');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/content-js/action-content-setupcontent.js');

        
        $this->layout("layout/layout_admin_body");
        

        return $view;
    }

    public function listmateriAction(){
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();

        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
       
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = $this->urlLedakan();

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/content-js/action-content-listmateri.js');

        
        $this->layout("layout/layout_admin_body");
        

        return $view;
    }

    public function cobainAction(){
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();

        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
       
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = $this->urlLedakan();

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/content-js/action-content-listmateri.js');

        
        $this->layout("layout/layout_admin_body");
        

        return $view;
    }

    public function nikanschsweishAction(){
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();

        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
       
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = $this->urlLedakan();

        $urlExp  = explode('/', $uri->getPath());

        /* decrpyt id */                        
        $thisDecryptID = self::url_decryptd($urlExp[3], self::PHRASE, self::SKEY); 

        $this->headScript->appendScript(' var thisIdProfile = "' . $thisDecryptID . '"');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/content-js/action-content-nikanschsweish.js');

        
        $this->layout("layout/layout_admin_body");
        

        return $view;
    }
    public function ssoAction(){
        $cas    =  new \Khansia\Access\MyCas();
        $cas->force_auth();
        $data = array();
        print_r('masuk view');die;
        // return $cas;
        return view('welcome_message', $data);
    }
    public function ssologoutAction(){
        $cas    =  new \Khansia\Access\MyCas();
        $cas->logout();
        print_r($cas);die;
        $data = array();
        
        // return view('welcome_message', $data);
    }
    public function ssoTestAction(){
        $view   = new ViewModel();
        
        $this->cas = new \phpCAS();
		$this->cas_server_url = "https://login.itb.ac.id/cas";
		$defaults = array('path' => '', 'port' => 443);
		$cas_url = array_merge($defaults, parse_url($this->cas_server_url));
								$this->cas::client(CAS_VERSION_2_0,
								$cas_url['host'],
								$cas_url['port'],
								$cas_url['path'],false);
        $this->cas::setNoCasServerValidation();
			$this->cas->forceAuthentication();
		
		$userProfile = $this->cas->getAttributes();
        
        echo "<pre>".print_r($userProfile ,1)."</pre>";die;

        $message = $this->param()->fromQuery('message', 'hello');
        
        return new ViewModel(['message'=>$message, 'UserProfile' => json_decode($userProfile)]);
        
    }

    public function getattributAction(){
        $this->cas = new \phpCAS();
        $this->cas_server_url = "https://login.itb.ac.id/cas";
        $defaults = array('path'=> '', 'port'=>443);
        $cas_url = array_merge($defaults, parse_url($this->cas_server_url));
        
        $this->cas::client(CAS_VERSION_2_0,
                        $cas_url['host'],
                        $cas_url['port'],
                        $cas_url['path']);
        
        print_r($this->cas);die;
        $userProfile = $this->cas->getAttributes();
    }
}
