<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class DosenController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){

            //print_r($result);die;
            $view->setVariable('namaste', $userSession->get('name'));
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
            $this->headScript->appendScript(' var nim;');
            // $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');
            $this->headScript->appendFile($baseurl.'/action-js/global-js/sipenkp-global-action.js');
            // $this->layout()->name = $userSession->get('usernamed');
            // $this->layout()->name1 = $userSession->get('name');
            $this->layout("layout/layout_dosen");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function pendaftaranAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pendaftaran_mhs.js');

        
        $this->layout("layout/layout_dosen");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function uploadberkasAction(){
        $this->isLoggedIn();
       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();

        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pendaftaran_mhs.js');

        
        $this->layout("layout/layout_dosen");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function pengajuankpAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $userSession->get('usernamed') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/mahasiswa-js/action-pengajuan-mhs.js');

        
        $this->layout("layout/layout_dosen");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function listmahasiswaAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var id = "' . $userSession->get('nopeg') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-list-bimbingan.js');

        
        $this->layout("layout/layout_dosen");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function bimbinganAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $$_GET['nim'];die;
        // print_r($userSession->get('usernamed'));die;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-bimbingan-mahasiswa.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_dosen");
        

        return $view;
    }

    public function bimbingangroupAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $$_GET['nim'];die;
        // print_r($userSession->get('usernamed'));die;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-bimbingan-mahasiswa-group.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_dosen");
        

        return $view;
    }

    public function penilaianpengujiAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        // print_r($userSession->get('nopeg'));die;
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
            // $this->headScript->appendScript(' var iduser = null');
            // $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-penilaian-penguji.js');
            
            $this->layout("layout/layout_dosen");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function penilaianpembimbingAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
            // $this->headScript->appendScript(' var iduser = null');
            // $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-penilaian-penguji.js');
            
            $this->layout("layout/layout_dosen");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function nilaipengujiAction()
    {
        
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri        = $this->getRequest()->getUri();
            $baseurl    = sprintf('//%s', $uri->getHost());
            $urlvar     = base64_decode(urldecode($_GET['nim']));
            $urlid      = base64_decode(urldecode($_GET['param']));
            $penguji_ke = base64_decode(urldecode($_GET['penguji_ke']));
            $actionName = $this->params('action');

            // print_r($penguji_ke);die;
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var nopeg = "' . $userSession->get('nopeg') . '"');
            $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
            $this->headScript->appendScript(' var penguji_ke = "' . $penguji_ke . '"');
            $this->headScript->appendScript(' var identitas = "' . $urlid . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/dosen-js/action-nilai-penguji.js');
            
            $this->layout("layout/layout_dosen");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    
}
