<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class AdminController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        // print_r("here");die;
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        // print_r("here");die;
        /* redirect by role */
        if($userSession->get('role') == 200){
            $this->redirect()->toRoute('mahasiswa');
        } else if($userSession->get('role') == 50){
            $this->layout('layout/layout_dosen');
        } else if($userSession->get('role') == 210){
            $this->layout('layout/layout_kaprodi');
        } else if($userSession->get('role') == 1){
            $this->layout('layout/layout_superadmin');
        } else if($userSession->get('role') == 300){
            $this->layout('layout/layout_koordinator');
        }  else if($userSession->get('role') == 500){
            $this->layout('layout/layout_admin');
        }else {
            $this->layout('layout/layout_admin');
        }

        $owner       = $userSession->owner();
        // print_r($this->layout)
        // print_r($owner);die;
        if($owner){

            $view->setVariable('namaste', $userSession->get('name'));
            

            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
            // print_r($baseurl);die;
            $actionName = $this->params('action');
            $this->headScript->appendScript(' var nopeg;');
            $this->headScript->appendScript(' var nim;');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/global-js/sipenkp-global-action.js'); 
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');            
            // $this->layout("layout/layout_admin");s
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    // public function superadminidx(){
    //     $this->isLoggedIn();

    //     $view   = new ViewModel();
    //     $result = new Result();
        
    //     /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
    //     $userSession = $this->getSession();

    //     $owner       = $userSession->owner();
        
    //     if($owner){

    //         $view->setVariable('namaste', $userSession->get('name'));
            

    //         $uri     = $this->getRequest()->getUri();
    //         $baseurl = sprintf('//%s', $uri->getHost());
// $port    = $uri->getPort();
//             $baseurl = $baseurl.":".$port;

    //         $actionName = $this->params('action');
    //         $this->headScript->appendScript(' var nopeg;');
    //         $this->headScript->appendScript(' var nim;');
    //         $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
    //         $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
    //         $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
    //         $this->headScript->appendFile($baseurl.'/action-js/global-js/sipenkp-global-action.js'); 
    //         $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');            
            
    //         return $view;
    //     }else{
    //         return $this->redirect()->toRoute('login');
    //     }
    // }



    public function userlistAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        // $getpath     = explode("/",$uri->getPath()); 
        // $decodeid    = base64_decode($getpath[3]);

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-list.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        $view->setVariables(array(
            // 'controller'    => $this->params('controller'),
            'action'        => $this->params('action'),
        ));
        

        return $view;
    }

    public function mahasiswalistAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-mahasiswa.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function daftarmahasiswaAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
        $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-daftar-mahasiswa.js');        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function dosenlistAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
               $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-dosen.js');        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function uploadberkasAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $urlvar  = base64_decode(urldecode($_GET['nim']));
        
        $role    = $userSession->get('role');

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var role          = "' .$role.'"');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        // $this->layout()->role  = $role;
        $this->layout("layout/layout_admin");

        return $view;
    } 

    public function updateberkasAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $urlvar  = base64_decode(urldecode($_GET['nim']));
        
        $role    = $userSession->get('role');

        $this->headScript->appendScript(' var baseURL       = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser        = null');
        $this->headScript->appendScript(' var role          = "' .$role.'"');
        $this->headScript->appendScript(' var nim           = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE        = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS  = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function lihatberkasAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $$_GET['nim'];die;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function pilihpengujiAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $urlvar;die;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
       
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-penguji.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $role = $userSession->get('role');

        if($role == 300){
            $this->layout("layout/layout_koordinator");
        }else{
            $this->layout("layout/layout_admin");
        }
        
        

        return $view;
    }

    public function updatejadwalAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $$_GET['nim'];die;
        // print_r($baseurl.'/action-js/admin-js/action-pilih-penguji.js');die;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-penguji.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    }

    public function settingbobotAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-bobot-nilai.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
       
        $this->layout("layout/layout_admin");
        

        return $view;
    } 

    public function tambahmahasiswaAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        // $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-mahasiswa.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_admin");
        

        return $view;
    }

    public function generatesuratAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendScript(' var thisProdi = "' . $userSession->get('prodi'). '"');
        
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-generate-surat.js');
        
        $this->layout("layout/layout_admin");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function pilihpembimbingAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var kodeprodi = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-pembimbing.js');

        
        $this->layout("layout/layout_admin");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function usermahasiswaAction(){
        $this->isLoggedIn();

        
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-mahasiswa.js');
        
        if($userSession->get('role') == 1){
            $this->layout("layout/layout_superadmin");
        } else {
            $this->layout("layout/layout_admin");
        }

        $view->setVariables(array(
            'action'        => $this->params('action'),
        ));
        

        return $view;
    }

    public function userdosenAction(){
        $this->isLoggedIn();

        
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-dosen.js');
        
        if($userSession->get('role') == 1){
            $this->layout("layout/layout_superadmin");
        } else {
            $this->layout("layout/layout_admin");
        }

        $view->setVariables(array(
            'action'        => $this->params('action'),
        ));
        

        return $view;
    }

    public function userakademikAction(){
        $this->isLoggedIn();

        
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $role    = $userSession->get('role');

        $visibleAction = false;
        if($role == 1 || $role == 500){
            $visibleAction = true;
        }

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendScript(' var visibleAction = "' . $visibleAction . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-akademik.js');
        
        if($userSession->get('role') == 1){
            $this->layout("layout/layout_superadmin");
        } else {
            $this->layout("layout/layout_admin");
        }

        $view->setVariables(array(
            'action'        => $this->params('action'),
        ));
        

        return $view;
    }

    public function userkaprodiAction(){
        $this->isLoggedIn();

        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-kaprodi.js');
        
        if($userSession->get('role') == 1){
            $this->layout("layout/layout_superadmin");
        } else {
            $this->layout("layout/layout_admin");
        }
        
        $view->setVariables(array(
            'action'        => $this->params('action'),
        ));
        
        return $view;
    }

    public function userkoordinatorAction(){
        $this->isLoggedIn();

        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        
        $baseurl = sprintf('//%s', $uri->getHost());
        $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-user-koordinator.js');
        
        if($userSession->get('role') == 1){
            $this->layout("layout/layout_superadmin");
        } else {
            $this->layout("layout/layout_admin");
        }
        
        $view->setVariables(array(
            'action'        => $this->params('action'),
        ));
        
        return $view;
    }
}
