<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class IndexController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){

            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');

            $this->layout("layout/layout_admin_header");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function qrAction(){
        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();

        //print_r($result);die;
        $view->setVariable('dataa', $sessionArray);
        
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        $urlvar  = $_GET['nopeg'];
        
        $view->setVariable('qrcode', $urlvar);
        $actionName = $this->params('action');
        
        // $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var nopeg = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/index-js/action-qr.js');

        $this->layout("layout/layout_qr");
        return $view;
        
    }
}
