<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class JadwalController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();
        // $this->isHaveAccess();
        // $controllerName = $this->params('controller');
        // // print_r($controllerName);die;

        $view   = new ViewModel();
        $result = new Result();
        
        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){

            //print_r($result);die;
            $view->setVariable('dataa', $sessionArray);
            
            /* get url */
            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');            // $this->layout()->name = $userSession->get('usernamed');
            // $this->layout()->name1 = $userSession->get('name');
            $this->layout("layout/layout_admin");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function jadwalpersentasiAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        // $getpath     = explode("/",$uri->getPath()); 
        // $decodeid    = base64_decode($getpath[3]);

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/jadwal-js/action-jadwal-list.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        
        if($userSession->get('role') == 300){
            $this->layout("layout/layout_koordinator");
        }else{
            $this->layout("layout/layout_admin");
        }

        $view->setVariables(array(
            // 'controller'    => $this->params('controller'),
            'action'        => $this->params('action'),
        ));
        

        return $view;
    }

    public function buatjadwalAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        // print_r($userSession->get('role'));die;;
        $role        = $userSession->get('role');


        if($role == 300){
            $this->layout("layout/layout_koordinator");
            $this->headScript->appendScript(' var kodeprodi = "' . $userSession->get('koordinator') . '"');
        }else{
            $this->layout("layout/layout_admin");
            $this->headScript->appendScript(' var kodeprodi = null');
        }
        /* get url */
        $uri         = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;
        // $getpath     = explode("/",$uri->getPath()); 
        // $decodeid    = base64_decode($getpath[3]);

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/jadwal-js/action-buat-jadwal.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        
        $view->setVariables(array(
            // 'controller'    => $this->params('controller'),
            'action'        => $this->params('action'),
        ));
        
        return $view;
    }

    
}
