<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Khansia\Generic\Result;

class KoordinatorController extends \Application\Master\GlobalActionController
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
    }

    public function indexAction()
    {
        
        $this->isLoggedIn();

        $view   = new ViewModel();
        $result = new Result();
        

        /* ini hanya contoh return dari factory IndexControllerFactory gan, dani tamvan */
        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        if($owner){

            $view->setVariable('namaste', $userSession->get('name'));
            

            $uri     = $this->getRequest()->getUri();
            $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

            $actionName = $this->params('action');
            $this->headScript->appendScript(' var nopeg = "' . $userSession->get('usernamed') . '"');
            $this->headScript->appendScript(' var nim;');
            $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
            $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
            $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
            $this->headScript->appendFile($baseurl.'/action-js/global-js/sipenkp-global-action.js'); 
            $this->headScript->appendFile($baseurl.'/action-js/index-js/action-index.js');            
            $this->layout("layout/layout_koordinator");
            return $view;
        }else{
            return $this->redirect()->toRoute('login');
        }
    }

    public function pilihpengujiAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $urlvar;die;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
       
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-penguji.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_koordinator");
        

        return $view;
    }

    public function updatejadwalAction(){
        $this->isLoggedIn();

        // echo $this->userdata();
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri     = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $urlvar  = base64_decode(urldecode($_GET['nim']));
        // echo $$_GET['nim'];die;
        // print_r($baseurl.'/action-js/admin-js/action-pilih-penguji.js');die;
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var nim = "' . $urlvar . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');

        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-upload-berkas.js');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-penguji.js');
        // $this->layout()->name  = $userSession->get('usernamed');
        // $this->layout()->name1 = $userSession->get('name');
        
        $this->layout("layout/layout_koordinator");
        

        return $view;
    }

    public function pilihpembimbingAction(){
        $this->isLoggedIn();

       
        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var kodeprodi = "' . $userSession->get('koordinator') . '"');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/admin-js/action-pilih-pembimbing.js');

        
        $this->layout("layout/layout_koordinator");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function approvalseminarAction(){
        $this->isLoggedIn();

        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();

        $uri         = $this->getRequest()->getUri();
        $baseurl     = sprintf('//%s', $uri->getHost());

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = null');
        $this->headScript->appendScript(' var kodeprodi = "' . $userSession->get('koordinator') . '"');
        // $this->headScript->appendScript(' var nim = "' . $decodeid . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/koordinator-js/action-approval-seminar.js');

        
        $this->layout("layout/layout_koordinator");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    public function prosesmahasiswaAction(){
        $this->isLoggedIn();

        $view        = new ViewModel();
        $result      = new Result();

        $userSession = $this->getSession();
        $owner       = $userSession->owner();
        
        /* get url */
        $uri         = $this->getRequest()->getUri();

        $baseurl = sprintf('//%s', $uri->getHost());
            $port    = $uri->getPort();
            $baseurl = $baseurl.":".$port;

        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');
        $this->headScript->appendScript(' var iduser = "'.$userSession->get("user_id").'"');
        $this->headScript->appendScript(' var kodeprodi = "' . $userSession->get('koordinator') . '"');
        $this->headScript->appendScript(' var PHRASE = "' . self::PHRASE . '"');
        $this->headScript->appendScript(' var CODE_SUCCESS = "' . $result::CODE_SUCCESS . '"');
        $this->headScript->appendFile($baseurl.'/action-js/koordinator-js/action-proses-kp.js');

        
        $this->layout("layout/layout_koordinator");
        $view->setVariables(array(
            'action'        => $this->params('action'),
            'nim'           => $userSession->get('usernamed'),
            'name'          => $userSession->get('name'),
        ));
        
        return $view;
    }

    
}
