$(document).ready(function(){
    
    $('.datatable-basic').DataTable({
        
        autoWidth: false,
        columnDefs: [{ 
            orderable: false,
            "width": "2%", "targets": 0,
            "width": "20%", "targets": 1,
            "width": "30%", "targets": 2,
            "width": "40%", "targets": 3,
            "width": "5%", "targets": 4,
            
            
        }],
        dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            searchPlaceholder: 'Type to filter...',
            lengthMenu: '<span>Show:</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        drawCallback: function () {
            $(this).find('tbody tr').slice(-1).find('.dropdown, .btn-group').addClass('dropup');
        },
        preDrawCallback: function() {
            $(this).find('tbody tr').slice(-1).find('.dropdown, .btn-group').removeClass('dropup');
        }
    });


    $("#addPopUp").on("click", function(){
        $("#mhsname").val("");
        $("#mhsnim").val("");
        
        $("#mhsemail").val("");
        $('#modal-add').modal("show");
    })


})

$("#submitmhs").on("click", function(e){
    e.preventDefault();
    // var namamhs     = $("#mhsname").val();
    // var nimmhs      = $("#mhsnim").val();
    
    // var facultas    = $("#faculty").val();
    // var jurusan     = $("#mhsmajor").val();
    // var gender      = $('input[name="gender"]:checked').val();

    // console.log(facultas);
    // console.log(jurusan);
    // console.log(nimmhs);
    // console.log(namamhs);
    // console.log(gender);
    // if(validatenim() == true){

    // }
    
    saveMahasiswa()
})

function validatenim(){
    let isObject = {};
    isObject.param = iduser;
    var nim     = $("#mhsnim").val();
    var exist   = false;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadmahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            // $("tbody").empty();
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                // console.log(result.data);
                let data    = result.data;
                // console.log(data);
                for(i in data){
                    if(nim == data[i].nim){
                        exist = true;
                    }
                }
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

    return exist;
}

function saveMahasiswa(){
    var isObject    = {};
    var nimpattern  = /^[0-9]{8}$/;
    var namapattern = /^[a-zA-Z ]{2,30}$/;
    var emailpattern = /^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$/;
    isObject.namamhs    = $("#mhsname").val();
    isObject.nimmhs     = $("#mhsnim").val();
    isObject.facultas   = $("#faculty").val();
    isObject.jurusan    = $("#mhsmajor").val();
    isObject.gender     = $('input[name="gender"]:checked').val();
    isObject.email      = $("#mhsemail").val();

    // console.log(isObject);



    if(isObject.namamhs == ""){
        swal({
            title: "Peringatan!",
            text:" Nama tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!namapattern.test(isObject.namamhs)){
        swal({
            title: "Peringatan!",
            text:" Format nama salah!",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.nimmhs == ""){
        swal({
            title: "Peringatan!",
            text:" NIM tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!nimpattern.test(isObject.nimmhs)){
        swal({
            title: "Peringatan!",
            text:" NIM harus terdiri dari 8 karakter:)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(validatenim()){
        swal({
            title: "Alert",
            text:  " NIM Tidak tersedia",
            confirmButtonColor: "#2196F3",
            type: "error"
        });  
        return false
    }

    if(isObject.gender == ""){
        swal({
            title: "Peringatan!",
            text:" Jenis Kelamin tidak boleh kosong. Silahkan coba kembali :)",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } 

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/savemahasiswa',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Mahasiswa telah ditambahkan ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    loadElementsMhs();
                    // location.reload()
                    loaderPage(false);
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

// loadMahasiswa();
function loadMahasiswa(){
    let isObject = {};
    isObject.param = iduser;
    // console.log(isObject)

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadmahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            $("tbody").empty();
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                // console.log(result.data);
                let data    = result.data;
                let counter = 1;

                for (i in data){
                    var row = "";
                    
                    
                    row     += `<tr>
                                    <td>`+counter+`</td>
                                    <td>`+data[i].nim+`</td>
                                    <td>`+data[i].nama+`</a></td>
                                    <td>`+data[i].jurusan+`</td>`;
                    row     +=      `<td class="text-center">
                                        <ul class="icons-list">
                                            <li class="dropdown">
                                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="icon-menu9"></i>
                                                </a>
                    
                                                <ul class="dropdown-menu dropdown-menu-right">
                                                    <li><a onclick="validatedelete('`+data[i].nim+`')"><i class="icon-user-cancel"></i> Delete Mahasiswa</a></li>
                                                    <li><a href="`+baseURL+`/admin/berkas?nim=`+encodeURIComponent(btoa(data[i].nim))+`"><i class=" icon-user-check"></i> Check Berkas</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>` ;
                    $("tbody").append(row);
                    counter++;  
                }

                // Alternative pagination
                $('.datatable-pagination').DataTable({
                    pagingType: "simple",
                    language: {
                        paginate: {'next': 'Next &rarr;', 'previous': '&larr; Prev'}
                    }
                });


                // Datatable with saving state
                $('.datatable-save-state').DataTable({
                    stateSave: true
                });


                // Scrollable datatable
                $('.datatable-scroll-y').DataTable({
                    autoWidth: true,
                    scrollY: 300
                });



                // External table additions
                // ------------------------------

                // Enable Select2 select for the length option
                $('.dataTables_length select').select2({
                    minimumResultsForSearch: 10,
                    width: 'auto'
                });
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}


function validatedelete(uname){
    event.preventDefault();
    swal({
        title: "Hapus data mahasiswa?",
        text: "once you remove this data, you wont be able to retrieve this file.",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Ya",
        cancelButtonText: "Tidak",
        cancelButtonColor: "#DD6B55",
        closeOnConfirm: false,
        closeOnCancel: false
      },
      function(isConfirm){
        if (isConfirm) {
            deleteuser(uname);
            // console.log(uname);
            // // submitting the form when user press yes
        } else {
          swal("Mahasiswa tidak dihapus", "", "error");
        }
    });
}

function deleteuser(uname){
    var isObject    = {}

    isObject.id = uname;
    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/deletemahasiswa',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            // console.log(response.code)
            
            if(response.code == CODE_SUCCESS){
                swal({
                    title: "Alert",
                    text:  " Mahasiswa berhasil dihapus!",
                    confirmButtonColor: "#2196F3",
                    type: "success",
                    icon: "success"
                }, function(){
                    // $("tbody").empty();
                    // loadMahasiswa();  
                    // Alternative pagination
                    loadElementsMhs();     
                    loaderPage(false);
                });  
                
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }    
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

    // console.log(id)
}

//load serverside
loadElementsMhs()
function loadElementsMhs(clicksc){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;

    var dtpr = $('#mahasiswalist').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/daftarmahasiswa',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'nim', 'sClass':'','sWidth':'10px'},
            { 'data': 'nim', 'sClass':''},
            { 'data': 'nim', 'sClass':''},
            { 'data': 'nama_prodi', 'sClass':''},
            { 'data': 'email', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        buttons: {            
            buttons: [
                {
                    extend: 'colvis',
                    className: 'btn btn-default'
                },
            ]
        },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            {   


                // render: function (data, type, row){
                //     // var $rowData = '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt" style="cursor: pointer;">';
                //     let isIcon = ' icon-file-download2';

                //     var $rowData = '<div class="thumb img-rounded img-preview showAtt" style="width: 70px;">'+
                //         '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt">'+
                //         '<div class="caption-overflow">'+
                //             '<span>'+
                //                 '<p  class="btn showAtt bg-success-400 btn-icon btn-lg" style="font-variant: all-petite-caps;background-color: #0e0e0e33 !important;border-color: #25252591 !important;">'+
                //                     '<i class="'+isIcon+'"></i> '
                //                 '</p>'+
                //             '</span>'+
                //         '</div>'+
                //     '</div>';

                //     return $rowData;
                // },
                // visible: true,
                // targets: 1,
            },  
            {   
                // render: function (data, type, row){
                //     // console.log(row);
                //     var $rowData = ``;
                //     if(row.statusvalid == "VALID"){
                //         $rowData ='<span style="min-width: 70px" class="label label-success">'+row.statusvalid+'</span>';
                //     }else if(row.statusvalid == "MENUNGGU VALIDASI"){
                //         $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                //     } else if(row.statusvalid == "BELUM UPLOAD"){
                //         $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                //     }else if(row.statusvalid == "TIDAK VALID"){
                //         $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.statusvalid+'</span>';
                //     }
                //     return $rowData;
                // },
                // visible: true,
                // targets: 4,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;

                    
                        $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                             
                                                <li class=""><a "><i class=" icon-file-eye2"></i> Lihat Mahasiswa</a></li>
                                                <li class=""><a class=""><i class="icon-user-plus"></i> Edit Mahasiswa</a></li>                                               
                                                <li><a ><i class="icon-user-cancel"></i> Delete Mahasiswa</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                    

                    return $rowData;
                },
                visible: true,
                targets: 5,
                className: 'dt-center'
            }, 
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');

            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

function statusberkas(nim){
    // loaderPage(true)
    var complete;
    var isObject = {};
    isObject.nim = nim;
    console.log(isObject.nim)
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadstatusberkas',
        async: false,
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
                
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                let data    = result.data;
                // if (data[0] != 0 ){
                //     complete = true;
                // }
                complete=data[0];
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });
            }
            
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    return complete;
    // return complete;

}

function alertupload(){
    swal({
        title: "Peringatan!",
        text:" Berkas sudah di upload! silahkan pilih penguji atau lihat berkas untuk update!",
        confirmButtonColor: "#2196F3",
        // type: "warning"
    });
}

function alertnotupload(){
    swal({
        title: "Peringatan!",
        text:" Berkas belum di upload! silahkan upload berkas terlebih dahulu!",
        confirmButtonColor: "#2196F3",
        // type: "warning"
    });
}

function listberkas(nim){
    var isObject = {};
    isObject.param = nim;
    loaderPage(true)
    $("#modalberkas").modal("show");
    
    
    // $("#nimberkas").html(nim);
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadberkasattach',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function(response){
            
            if(response.code == CODE_SUCCESS){
                let result  = cryptoDecrypt(PHRASE, response.data);
                let data    = result.data;
                
                console.log(data);
            } else {
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });
            }
            
            loaderPage(false)
        },
        error: function(xhr) {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Galat",
                    text:  xhr.status+"-"+xhr.statusText+"<br> Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    
}

function berkaslist(file1, dir1, file2, dir2, file3, dir3, file4, dir4, nim, nama, status, jurusan, size1, size2, size3, size4){
    var buttonf = "";
    
    if(status == "VALID" || status == "TIDAK VALID"){
        buttonf += `<button type="button" class="btn btn-link" data-dismiss="modal">Close</button>`;
    }else{
        buttonf += `<button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
        <button onclick="berkasvalid('`+nim+`', false)" id="notvalid" type="button" class="btn btn-danger">Tidak Valid</button>
        <button onclick="berkasvalid('`+nim+`', true)"id="valid" type="button" class="btn btn-success">Validasi</button>`;
    }
    // $("#berkas1").attr("href", ""+dir1+file1+"")
    $("#namamBerkas").html(": "+nama);
    $("#nimmberkas").html(": "+nim);
    $("#prodimberkas").html(": "+jurusan);
    $("#statusberkas").html(": "+status);
    $("#modfoot").empty();
    $("#mbody").empty();
    $("#mdtitle").html("Lihat Berkas")
    // $("#berkas1").on("click", function)
    var cont = `<h5 class="headlist">List Berkas Mahasiswa</h5><hr>`;

    
    cont += `<ul class="media-list">
            `;

    cont += `<li class="media" >
                <div class="media-left media-middle medhov" onclick="modalattach('`+dir1+`','`+file1+`')">
                    <a href="#">
                        <img src="`+baseURL+`/img/pdfp.png" class="img-circle img-md" alt="">
                    </a>
                </div>

                <div class="media-body medhov media-bodys" onclick="modalattach('`+dir1+`','`+file1+`')">
                <div class="media-heading text-semibold">`+nim+`-`+nama+`-file 1.pdf</div>
                    <span class="text-muted __web-inspector-hide-shortcut__">File size : `+size1+` Mb</span>
                </div>

                <div class="media-right media-middle">
                    <ul class="icons-list text-nowrap">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="icon-menu9"></i></a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" data-toggle="modal" data-target="#call"><i class="icon-phone2"></i> Make a call</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#chat"><i class="icon-comment"></i> Start chat</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#video"><i class="icon-video-camera"></i> Video call</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </li>
            `;

            cont += `<li class="media">
            <div class="media-left media-middle" onclick="modalattach('`+dir2+`','`+file2+`')">
                <a href="#">
                    <img src="`+baseURL+`/img/pdfp.png" class="img-circle img-md" alt="">
                </a>
            </div>

            <div class="media-body media-bodys" onclick="modalattach('`+dir2+`','`+file2+`')">
            <div class="media-heading text-semibold">`+nim+`-`+nama+`-file2.pdf</div>
                <span class="text-muted __web-inspector-hide-shortcut__">File size : `+size2+` Mb</span>
            </div>

            <div class="media-right media-middle">
                <ul class="icons-list text-nowrap">
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="icon-menu9"></i></a>

                        <ul class="dropdown-menu dropdown-menu-right">
                            <li><a href="#" data-toggle="modal" data-target="#call"><i class="icon-phone2"></i> Make a call</a></li>
                            <li><a href="#" data-toggle="modal" data-target="#chat"><i class="icon-comment"></i> Start chat</a></li>
                            <li><a href="#" data-toggle="modal" data-target="#video"><i class="icon-video-camera"></i> Video call</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </li>
        `;

        cont += `<li class="media">
                <div class="media-left media-middle" onclick="modalattach('`+dir3+`','`+file3+`')">
                    <a href="#">
                        <img src="`+baseURL+`/img/pdfp.png" class="img-circle img-md" alt="">
                    </a>
                </div>

                <div class="media-body media-bodys" onclick="modalattach('`+dir3+`','`+file3+`')">
                    <div class="media-heading text-semibold">`+nim+`-`+nama+`-file3.pdf</div>
                    <span class="text-muted __web-inspector-hide-shortcut__">File size : `+size3+` Mb</span>
                </div>

                <div class="media-right media-middle">
                    <ul class="icons-list text-nowrap">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="icon-menu9"></i></a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" data-toggle="modal" data-target="#call"><i class="icon-phone2"></i> Make a call</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#chat"><i class="icon-comment"></i> Start chat</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#video"><i class="icon-video-camera"></i> Video call</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </li>`;

            cont += `<li class="media">
                <div class="media-left media-middle" onclick="modalattach('`+dir4+`','`+file4+`')">
                    <a href="#">
                        <img src="`+baseURL+`/img/pdfp.png" class="img-circle img-md" alt="">
                    </a>
                </div>

                <div class="media-body media-bodys" onclick="modalattach('`+dir4+`','`+file4+`')">
                <div class="media-heading text-semibold">`+nim+`-`+nama+`-file4.pdf</div>
                    <span class="text-muted __web-inspector-hide-shortcut__">File size : `+size1+` Mb</span>
                </div>

                <div class="media-right media-middle">
                    <ul class="icons-list text-nowrap">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="icon-menu9"></i></a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" data-toggle="modal" data-target="#call"><i class="icon-phone2"></i> Make a call</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#chat"><i class="icon-comment"></i> Start chat</a></li>
                                <li><a href="#" data-toggle="modal" data-target="#video"><i class="icon-video-camera"></i> Video call</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </li>
            `;

    $("#mbody").append(cont);
    $("#modfoot").append(buttonf)
    $("#modalberkas").modal("show");
}

function modalattach(dir, file){
    $("#modalberkas").modal("hide");
    // $('#modalattach').modal("show");
        // $('#isv').append(`<embed class="kv-preview-data file-zoom-detail" src="`+dir+``+file+`" type="application/pdf" style="width: 100%; height: 100%; min-height: 480px;">`)
        $('.isv').append(`<embed src="`+dir+``+file+`" type="application/pdf"   style="width: 100%; height: 100%; min-height: 480px;">`);
    $("#modal-video").modal("show");
}

$("#modal-video").on("hidden.bs.modal", function(){
    $(".isv").empty();
    $("#modalberkas").modal("show");
})

// $("#modalberkas").on("hidden.bs.modal", function(){
//     $("#mbody").empty();
// })

$("#notvalid").on("click", function(e){
    e.preventDefault();
})

$("#valid").on("click", function(e){
    e.preventDefault();
})

function berkasvalid(nim, isvalid){
    // console.log(nim);
    // console.log(isvalid);

    var isObject = {};
    isObject.nim = nim;
    isObject.isvalid = isvalid;
    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/validasiberkas',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            $('#modalberkas').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Berkas telah di validasi! ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    
                    loadElementsMhs();
                    // location.reload()
                    loaderPage(false);
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    
}