var tembusan = '';
var isAddTembusan = 0;

$(document).ready(function(){
    $('.pickatime-disabled').pickatime({
        // format: 'yyyy, mm dd',
        disable: [
           [12,0],
           [12,30]
        ],
        min: [13,0],
        max: [17,0],
       
    });

    $('.pickadate').pickadate({
        // Escape any “rule” characters with an exclamation mark (!).
        // minDate: new Date.now(),
        // minDate: '22/10/2020',
        format: 'dd mmmm yyyy',
        formatSubmit: 'yyyy/mm/dd',
        // monthsFull: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
        hiddenPrefix: 'prefix__',
        hiddenSuffix: '__suffix'
    });

    $('.daterange-basic').daterangepicker({
        applyClass: 'bg-slate-600',
        cancelClass: 'btn-default'
    });

    $(".btn-modal").on("click", function(){
        $("#modal-add").modal("show");
    })

    $("#submitpengajuan").on("click", function(){
        savepengajuan();
    })
    $(".alertno").hide()
    $('input[name="konfirmasi"]').change(function(){
        var isconf = $('input[name="konfirmasi"]:checked').val();
        
        if(isconf == 101){
            $(".panel-body > fieldset").show();
            $(".alertno").hide()
        }else {
            $(".panel-body > fieldset").hide();
            $(".alertno").show()
        }
    })

    $("#btn-mgenerate").on("click", function(){
        generatesurat();
    });
    
    $("[name = 'all']").on("click", function(){
        alert('mashook')
        if(this.checked){
            $.each($("#mhsw"), function(){
                // favorite.push($(this).val());
                $("#mhsw").prop("checked", true);
            });
        }else{
            $.each($("#mhsw"), function(){
                // favorite.push($(this).val());
                $("#mhsw").attr("checked", false);
            });
        }
    })
    
})

const CODE_VALID = 104;
const CODE_NOTVALID = 105;

function checkAll(ele) {
    var elmts = $("[name = 'all']").parent();
    // console.log(elmts.attr('class'));
    var cek = elmts.attr('class');
    // var azg = cek.toString()
    // console.log($("span[name = 'all']").parent().attr('class'))
    var checkboxes    = $("[name = 'mhsw[]'")
    var checkboxespar = checkboxes.parent();
    
    // console.log(checkboxespar.addClass("checked"))
    if (cek != 'checked') {
        // alert('dank')
        for (var i = 0; i < checkboxes.length; i++) {
            
        }
        checkboxespar.addClass("checked")
    } else {
        for (var i = 0; i < checkboxes.length; i++) {
            // alert("ehe")
        }
        checkboxespar.removeClass("checked")
    }
}

function savepengajuan(){
    var isObject = {};

    isObject.nama_perusahaan    = $("#nama_perusahaan").val();
    isObject.penerima_surat     = $("#penerima_surat").val();
    isObject.telp_perusahaan    = $("#telp_perusahaan").val();
    isObject.tanggalAwal        = dateformats($("#tanggalAwal").val());
    isObject.tanggalAkhir       = dateformats($("#tanggalAkhir").val());
    isObject.alamat_perusahaan  = $("#alamat_perusahaan").val();
    isObject.nim                = $("#nim_mhs").val();
    
    console.log(isObject);

    if(isObject.nama_perusahaan == "" || isObject.nama_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Nama perusahaan tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.penerima_surat == "" || isObject.penerima_surat == null){
        swal({
            title: "Alert",
            text:  "Penerima tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.telp_perusahaan == "" || isObject.telp_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Telepon perusahaan tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.tanggalAwal == "" || isObject.tanggalAwal == null){
        swal({
            title: "Alert",
            text:  "Tanggal Mulai tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.tanggalAkhir == "" || isObject.tanggalAkhir == null){
        swal({
            title: "Alert",
            text:  "Tanggal Berhenti tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(isObject.alamat_perusahaan == "" || isObject.alamat_perusahaan == null){
        swal({
            title: "Alert",
            text:  "Tanggal Berhenti tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    if(!isFutureDate(isObject.tanggalAwal)){
        swal({
            title: "Peringatan!",
            text:" Tanggal tidak valid",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    } else if(!daterangeCheck(isObject.tanggalAwal, isObject.tanggalAkhir)){
        swal({
            title: "Peringatan!",
            text:" Tanggal akhir tidak boleh kurang dari tanggal awal",
            confirmButtonColor: "#2196F3",
            type: "warning"
        });
        return false;
    }

    


    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/savepengajuan',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat pengantar KP telah diajukan ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    loadElementspengajuan();
                    // location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });

}

function dateformats(date){
    var dateNew     = new Date(date);
    var dateString  = 
        ("0" + (1 + dateNew.getUTCDate())).slice(-2) + "-" +
        ("0" + (dateNew.getUTCMonth()+1)).slice(-2) + "-" +
        dateNew.getUTCFullYear();

    return dateString;
}

function isFutureDate(idate){
    var today = new Date().getTime();
    var idate = idate.split("-");

    idate = new Date(idate[2], idate[1] - 1, idate[0]).getTime();
    return (today - idate) < 0;
}

function daterangeCheck(idateAW, idateAK){
    var idateAK = idateAK.split("-");
    var idateAW = idateAW.split("-");

    idateAW = new Date(idateAW[2], idateAW[1] - 1, idateAW[0]).getTime();
    idateAK = new Date(idateAK[2], idateAK[1] - 1, idateAK[0]).getTime()
    return (idateAW - idateAK) < 0;
}

loadElementspengajuan();
function loadElementspengajuan(clicksc){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;

    var dtpr = $('#list_pengajuan').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/listpengajuanfadm',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'id_pengajuan', 'sClass':'','sWidth':'10px'},
            { 'data': 'nama', 'sClass':''},
            { 'data': 'nama_prodi', 'sClass':''},
            { 'data': 'nama_perusahaan', 'sClass':''},
            { 'data': 'alamat_perusahaan', 'sClass':''},
            { 'data': 'nama_penerima_perusahaan', 'sClass':''},
            { 'data': 'status', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        // buttons: {            
        //     // buttons: [
        //     //     {
        //     //         extend: 'colvis',
        //     //         className: 'btn btn-default'
        //     //     },
        //     // ]
        // },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            {   


                // render: function (data, type, row){
                //     // var $rowData = '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt" style="cursor: pointer;">';
                //     let isIcon = ' icon-file-download2';

                //     var $rowData = '<div class="thumb img-rounded img-preview showAtt" style="width: 70px;">'+
                //         '<img src="/distro/assets/images/placeholder.jpg" alt="" class="img-rounded img-preview showAtt">'+
                //         '<div class="caption-overflow">'+
                //             '<span>'+
                //                 '<p  class="btn showAtt bg-success-400 btn-icon btn-lg" style="font-variant: all-petite-caps;background-color: #0e0e0e33 !important;border-color: #25252591 !important;">'+
                //                     '<i class="'+isIcon+'"></i> '
                //                 '</p>'+
                //             '</span>'+
                //         '</div>'+
                //     '</div>';

                //     return $rowData;
                // },
                // visible: true,
                // targets: 1,
            },  
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    if(row.status_pengajuan == 91){
                        $rowData ='<span style="min-width: 70px" class="label bg-grey-400">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 92){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 102){
                        $rowData ='<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 103){
                        $rowData ='<span style="min-width: 70px" class="label label-primary">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 101){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }
                    else if(row.status_pengajuan == 104){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }
                    else if(row.status_pengajuan == 105){
                        $rowData = '<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    }
                    return $rowData;
                    // return $rowData;
                },
                visible: true,
                targets: 6,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    var tglawals  = row.tanggal_kerja_praktik_awal.split(" ");
                    var tglakhirs = row.tanggal_kerja_praktik_akhir.split(" ");
                    var creates  = row.create_date_pengajuan.split(" ");
                    
                    var tglawal  = tglawals[0];
                    var tglakhir = tglakhirs[0];
                    var create   = creates[0];

                        console.log(row.id_pengajuan);
                        if(row.status_pengajuan == 91){ //menunggu surat dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="modalgenerate('`+row.nim+`', '`+row.nama_perusahaan+`',`+row.id_pengajuan+`, '`+row.tanggal_kerja_praktik_awal+`', '`+row.tanggal_kerja_praktik_akhir+`')" class=""><a "><i class=" icon-file-eye2"></i> Generate Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        } else if (row.status_pengajuan == 92){ //surat telah dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="downloadsurat(`+row.id_pengajuan+`, '`+row.nim+`', '`+row.file_name+`')" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                                <li onclick="modalconf('`+row.nama+`','`+row.nim+`', '`+row.nama_perusahaan+`', '`+tglawal+`', '`+tglakhir+`', '`+create+`','KONFIRMASI',`+row.id_pengajuan+`, `+row.id_nosurat+`)" class=""><a "><i class="  icon-file-check2"></i> Konfirmasi Perusahaan</a></li> 
                                                <li onclick="modalconf('`+row.nama+`','`+row.nim+`', '`+row.nama_perusahaan+`', '`+tglawal+`', '`+tglakhir+`', '`+create+`','EDIT',`+row.id_pengajuan+`, `+row.id_nosurat+`)" class=""><a><i class="  icon-pencil5"></i> Edit Surat</a></li>
                                                <li onclick="rejectedByTU(`+row.id_pengajuan+`)"><a><i class="icon-blocked"></i>Tolak Surat</a></li> 
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 101){ //diterima di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="downloadsurat(`+row.id_pengajuan+`, '`+row.nim+`', '`+row.file_name+`')" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 102){ //ditolak di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="downloadsurat(`+row.id_pengajuan+`, '`+row.nim+`', '`+row.file_name+`')" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                        else if (row.status_pengajuan == 103){ //menunggu validasi berkas
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="showfile('`+row.file_path+`','`+row.nim+`')" class=""><a "><i class="  icon-file-check2"></i>Validasi Persetujuan</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 104){ //menunggu validasi berkas
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="showfile('`+row.file_path+`','`+row.nim+`')" class=""><a "><i class=" icon-file-eye2"></i>Surat Perusahaan</a></li>
                                                <li  class=""><a href="`+baseURL+`/admin/pilihpembimbing"><i class="  icon-user-tie"></i>Pilih Pembimbing</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 105){ //menunggu validasi berkas
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                            <li onclick="downloadsurat(`+row.id_pengajuan+`, '`+row.nim+`', '`+row.file_name+`')" class=""><a "><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                        console.log(row);

                    return $rowData;
                },
                visible: true,
                targets: 7,
                className: 'dt-center'
            },
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');

            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            $(this).find('.dt-buttons').addClass('hidden')

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

// loadElementspengajuanreview();
function loadElementspengajuanreview(clicksc){
    loaderPage(true)
    let isObject     = {}; 
    isObject.ipoly   = 1;

    var dtpr = $('#list_review').DataTable({
        serverSide	: true,
        destroy		: true,
        bFilter		: true,
        responsive	: true,
        searching   : true,
        pagingType  : 'full',
        lengthMenu  : [[1, 25, 50, -1], [1, 25, 50, "All"]],
        pageLength  : 25,
        ajax		: {
            url: baseURL + '/jsondata/reviewpengajuan',
            type: 'POST',
            // async: false,
            data : function (d) {         
                return $.extend( {}, d, {
                    iparam	    : cryptoEncrypt(PHRASE, isObject),
                });
            },
            dataSrc: function(response) {
                
                if(response.code == CODE_SUCCESS){
                    response = cryptoDecrypt(PHRASE, response.data);
                    // console.log(response.data.data);
                    var data = response.data.data;
                    // var datas;
                    // var dataada=[];
                    // // datas.push(data[0])
                    // // console.log(datas);
                    // for(i in data){
                    //     datas = {
                    //         "id_mhs": data[i].id_mhs,
                    //         "nim": data[i].nim,
                    //         "nama": data[i].nama,
                    //         "jurusan": data[i].jurusan,
                    //         "jeniskelamin": data[i].jeniskelamin,
                    //         "fakultas": data[i].fakultas,
                    //         "create_date": data[i].create_date,
                    //         // "status": statusberkas(data[i].nim)
                    //     }
                    //     dataada.push(datas)
                    // }
                    console.log(data)
                    return data;
                }else{
                    return response;
                }
               
            }
        },	
        columns: [
            { 'data': 'id_pengajuan', 'sClass':'','sWidth':'10px'},
            { 'data': 'NAMA', 'sClass':''},
            { 'data': 'nama_perusahaan', 'sClass':''},
            { 'data': 'alamat_perusahaan', 'sClass':''},
            { 'data': 'nama_penerima_perusahaan', 'sClass':''},
            { 'data': 'status', 'sClass':'text-center'},
            { 'data': '', 'sClass':'text-center','sWidth':'10px'}
        ],
        // buttons: {            
        //     // buttons: [
        //     //     {
        //     //         extend: 'colvis',
        //     //         className: 'btn btn-default'
        //     //     },
        //     // ]
        // },
        processing: true,
        stateSave: false,
        autoWidth: false,
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            processing: "<div class='table-loading'><img src='../../img/loadingtwo.gif' /></div>",

            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        columnDefs: [
            {
                width: '20px',
                targets: 0,
                visible: true
            },
            
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                    if(row.status_pengajuan == 91){
                        $rowData ='<span style="min-width: 70px" class="label bg-grey-400">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 92){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 102){
                        $rowData ='<span style="min-width: 70px" class="label label-danger">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 103){
                        $rowData ='<span style="min-width: 70px" class="label label-primary">'+row.status+'</span>';
                    }else if(row.status_pengajuan == 101){
                        $rowData = '<span style="min-width: 70px" class="label label-success">'+row.status+'</span>';
                    }
                    return $rowData;
                    // return $rowData;
                },
                visible: true,
                targets: 5,
            }, 
            {   
                render: function (data, type, row){
                    // console.log(row);
                    var $rowData = ``;
                        // console.log(row.nim)
                    
                        if(row.status_pengajuan == 91){ //menunggu surat dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="generatesurat('`+row.nim+`', '`+row.nama_perusahaan+`')" class=""><a "><i class=" icon-file-eye2"></i> Generate Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                            // console.log(row.tanggal_kerja_praktik_awal);
                        } else if (row.status_pengajuan == 92){ //surat telah dibuat
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" ><a  ><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 101){ //diterima di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a href="../data/permohonan/surat_permohonan.pdf" download><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }else if (row.status_pengajuan == 102){ //ditolak di perusahaan
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a href="../data/permohonan/surat_permohonan.pdf" download><i class=" icon-file-eye2"></i> Lihat Surat</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                        else if (row.status_pengajuan == 103){ //menunggu validasi berkas
                            $rowData = `<ul class="icons-list">
                                        <li class="dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="icon-menu9"></i>
                                            </a>

                                            <ul class="dropdown-menu dropdown-menu-right">
                                                <li onclick="" class=""><a "><i class=" icon-file-eye2"></i>Validasi Persetujuan</a></li>
                                            </ul>
                                        </li>
                                    </ul>`;
                        }
                    

                    return $rowData;
                },
                visible: true,
                targets: 6,
                className: 'dt-center'
            },
        ],
        fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull){ 
            var index = iDisplayIndexFull + 1; 
            $('td:eq(0)', nRow).html('#'+index); 
            return  index;
        },
        drawCallback: function (settings) {
            // console.log(settings.json);
            
            var api  = this.api();
            var rows = api.rows({page:'current'}).nodes();
            var last = null;

            // console.log(rows)
            // Reverse last 3 dropdowns orientation
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');

            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            this.$('.showAtt').on('click', function(){

                var tr      = $(this).parents('tr')
                var aData   = dtpr.row( tr ).data();

                // loadAttachments(aData);

            });

            $(this).find('.dt-buttons').addClass('hidden')

            
        },
        fnInitComplete: function (oSettings, json) {
            var that = this;
            var td ;
            var tr ;

            this.$('td').click( function () {
                td = this;
            });
            this.$('tr').click( function () {
                tr = this;
            });

            

            $('#mahasiswalist input').bind('keyup', function (e) {
                return this.value;
            });

            setIFrameSize();

        }
    });

}

function generatesurat(){
    var isObject = {}
    loaderPage(true);

    let tembusanelement =  document.querySelectorAll('[id^="tembusaninp"]');
    let tembusanData    = '';

    for($i = 0; $i < tembusanelement.length; $i++){
        tembusanData += "- "+tembusanelement[$i].value+"<br>";
    }
   
    isObject.nim           = $("#nimgen").val();
    isObject.perusahaan    = $("#namapergen").val();
    isObject.id_pengajuan  = $("#idpengajuan").val();
    isObject.nomorsurat    = $("#nosurat").val();
    isObject.url           = baseURL;
    isObject.tglawal       = $("#tglawal").val();
    isObject.tglakhir      = $("#tglakhir").val();
    isObject.tembusan      = tembusanData;
    
    if(isObject.tembusan == "" || isObject.tembusan == null){
        swal({
            title: "Alert",
            text:  " Tembusan surat tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "error"
        }); loaderPage(false);
        return false
    }

    if(isObject.nomorsurat == "" || isObject.nomorsurat == null){
        swal({
            title: "Alert",
            text:  " Nomor surat tidak boleh kosong",
            confirmButtonColor: "#2196F3",
            type: "error"
        }); loaderPage(false);
        return false
    }

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/generatesurat',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat Pengantar KP telah digenerate",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function showfile(aData, nim){  
    // console.log(baseURL+aData);

    var cols = `<input id="nim_mhs" value="`+nim+`" type="hidden" class="form-control" placeholder="Nama Perusahaan..">`;
    $('.modalbodys').empty();
    $('.modalbodys').append(cols)
    $('.modalbodys').append(`<embed src="`+baseURL+aData+`" type="application/pdf"   style="width: 100%; height: 100%; min-height: 480px; ">`);
    $("#modal-review").modal('show');
   
}

function modalgenerate(nim, namaper, idpengajuan, tglawal, tglakhr){  
    var cols ;
    console.log(nim)
    $("#nimgen").val(nim);
    $("#namapergen").val(namaper);
    $("#idpengajuan").val(idpengajuan);
    $("#tglawal").val(tglawal);
    $("#tglakhir").val(tglakhr);
    $("#modal-generate").modal('show');
}


$("#valid").on("click", function(){
    checkberkas(true);
})


$("#notvalid").on("click", function(){
    checkberkas(false);
})

function checkberkas(code){
    var isObject = {};
    loaderPage(true);
    isObject.nim   = $("#nim_mhs").val();
    isObject.isvalid = code;

    console.log(isObject)
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/validasiperusahaan',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            // $('#modal-add').modal("hide");
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Surat konfirmasi telah di validasi, silahkan memilih dosen pembimbing",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){ 
                    // $("tbody").empty();
                    // loadElementsMhs();
                    location.reload()
                    
                });

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function modaledit(){
    $("#modal-edit").modal('show');
}

function modalconf(nama, nim, perusahaan, tglawal, tglakhir, create, modal, idpengajuan, isnosurat){
    var identity = nim + ' / ' + nama;
    var isObject = {};
    loaderPage(true)
    
    $("#tglawalh").val(tglawal)
    $("#tglakhirh").val(tglakhir)
    $("#createdh").val(create)
    $('#nimnama').val(identity);
    $('#nim').val(nim);
    $("#namaper").val(perusahaan);
    $('#nimedt').val(nim);
    $("#idpengajuanedt").val(idpengajuan)
   
    isObject.tglawal     = tglawal;
    isObject.tglakhir    = tglakhir;
    isObject.create      = create;
    isObject.perusahaan  = perusahaan; 
    isObject.id_nosurat  = isnosurat;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/loadbatchpengajuan',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            response = cryptoDecrypt(PHRASE, response.data);
            var data = response.data;
            console.log(data);
            if(response.code == CODE_SUCCESS){
                if(modal == "KONFIRMASI"){
                    $("#checkboxcontainer").empty();
                    var counter = 1;
                    $res = `<label class="display-block text-semibold" >Mahasiswa Diterima
                                
                            </label>
                            <hr style="margin: 5px">`
                            ;
                    
                    for(mhsw in data){
                        $res += `<div class="checkbox checkbox-right">
                                    <label class="text-semibold">
                                        <input type="checkbox" class="styled" value="`+data[mhsw].nim+`" name="mhsw[]">
                                        `+counter+`. `+data[mhsw].nim+` / `+data[mhsw].nama+`
                                    </label>
                                </div>`;
                        counter++;
                    } 

                    $res += `<hr style="margin: 5px">
                            <code style="margin-top: -20px; text-align: justify">*pilih mahasiswa yang diterima di perusahaan, jika tidak ada mahasiswa yang diterima biarkan checkbox kosong kemudian klik submit agar mahasiswa dapat membuat pengajuan ke perusahaan lain.</code> `;

                    $("#checkboxcontainer").html($res);
                    $('#modal-conf').modal('show');
                } else if(modal == "EDIT"){
                    $("#checkboxcontainers").empty();

                    var counter = 1;
                    $res = `<label class="display-block text-semibold" >List Mahasiswa
                                
                            </label>
                            <hr style="margin: 5px">`
                            ;
                    
                    for(mhsw in data){
                        if(counter-1 == 0){
                            $("#namaperedt").val(data[mhsw].nama_perusahaan);
                            $("#alamatedt").val(data[mhsw].alamat_perusahaan);
                            $("#posedt").val(data[mhsw].kode_pos);
                            $("#penerimaedt").val(data[mhsw].nama_penerima_perusahaan);
                            $("#divisiedt").val(data[mhsw].divisi_penerima);
                            
                            if(data[mhsw].tembusan == null || data[mhsw].tembusan == ""){
                                $("#tembusanedt").val(tembusan); // global var master parameter
                            }else{
                                $("#tembusanedt").val(data[mhsw].tembusan);
                            }
                        }
                        $res += `<div class="checkbox checkbox-right">
                                    <label class="text-semibold">
                                        <input type="checkbox" class="styled" value="`+data[mhsw].nim+`" name="mhswedt[]" checked>
                                        `+counter+`. `+data[mhsw].nim+` / `+data[mhsw].nama+`
                                    </label>
                                </div>`;
                        counter++;
                    } 

                    $res += `<hr style="margin: 5px">
                            <code style="margin-top: -20px; text-align: justify">*pilih mahasiswa yang akan dimasukkan pada surat pengajuan</code> `;

                    $("#checkboxcontainers").html($res);
                    $('#modal-edit').modal('show');
                }
                
            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

$("#submitconf").on("click",function(e){
    e.preventDefault();
    var arrAcc  = [];
    var arrAll  = [];
    var arral   = [];
    var counta  = 0;
    var countd  = 0;
    $.each($("input[name='mhsw[]']:checked"), function(){
        // favorite.push($(this).val());
        arrAcc[counta] = $(this).val();
        counta++
    });

    $.each($("input[name='mhsw[]']"), function(){
        // favorite.push($(this).val());
        arrAll[countd] = $(this).val();
        countd++
    });

    // alert($('#tglawalh').val());
    var arrDeny = arrAll.filter(function(obj) { return arrAcc.indexOf(obj) == -1; });
    requestconfirmation(arrAcc, arrDeny, arrAll);
})

function wrongvalidation(msg){
    swal({
        title: "Alert",
        text:  msg,
        confirmButtonColor: "#2196F3",
        type: "warning"
    }); 

    return false;
}

function requestconfirmation(arrAcc, arrDeny, arrAll){
    loaderPage(true)
    const file = $('#file').prop('files')[0];
    var isObject = {};
    let formdata = new FormData();

    //-----tgl group----///
    isObject.tglawalh  = $('#tglawalh').val();
    isObject.tglakhirh = $('#tglakhirh').val();
    isObject.createdh  = $('#createdh').val();

    isObject.status = $('input[name="konfirmasi"]:checked').val();
    isObject.nim    = $("#nim").val();
    isObject.perusahaan         = $("#namaper").val();
    isObject.bukti              = file;
    isObject.tanggalAwal        = dateformats($("#tanggalAwalconf").val());
    isObject.tanggalAkhir       = dateformats($("#tanggalAkhirconf").val());
    console.log(isObject);  

    if(arrAcc.length != 0){
        isObject.status = '101';
        if(isObject.perusahaan == null || isObject.perusahaan ==""){
            wrongvalidation("Nama Perusahaan Tidak Boleh Kosong");
            loaderPage(false)
            return false;
    
        }
    
        if(!isFutureDate(isObject.tanggalAwal)){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:" Tanggal tidak valid",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        } else if(!daterangeCheck(isObject.tanggalAwal, isObject.tanggalAkhir)){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:" Tanggal akhir tidak boleh kurang dari tanggal awal",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        } else if(minimalkp(isObject.tanggalAwal, isObject.tanggalAkhir) < 30){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:   "Waktu pelaksanaan kerja praktik minimal 30 hari, silahkan ubah tanggal",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        }
    
    
        if(document.getElementById("file").files.length == 0 ){
            loaderPage(false)
            wrongvalidation("File Tidak Boleh Kosong");
            
            
            return false;
        } else {
            var regexpattern = /[\/.](pdf)$/i;
            // let nimMhs = nim;
            let namefile = isObject.bukti.name;
            console.log(namefile)
            if(!regexpattern.test(namefile)){
                loaderPage(false)
                wrongvalidation('File Harus Berupa PDF!');
                return false;
            } 
        }
    }

    if(arrDeny != 0){
        isObject.status = 102;
    }

    
    formdata.append('arrAcc', arrAcc);
    formdata.append('arrDeny', arrDeny);
    formdata.append('tglawalh', isObject.tglawalh);
    formdata.append('tglakhirh', isObject.tglakhirh);
    formdata.append('createdh', isObject.createdh);

    formdata.append('file', isObject.bukti);
    formdata.append('namaper', isObject.perusahaan);
    formdata.append('tglawal', isObject.tanggalAwal);
    formdata.append('tglakhir', isObject. tanggalAkhir);
    formdata.append('nim', isObject.nim);
    formdata.append('status', isObject.status);
    formdata.append('paramtype', 'admin');

    $.ajax({
        type        : 'POST',
        url         : baseURL + '/jsondata/konfirmasivalid',
        data        : formdata,
        cache       : false,
        processData : false,
        contentType : false,
        success: function (response) {

            if(response.code == CODE_SUCCESS){
                loaderPage(false)
                // document.getElementById("form-data").reset();

                swal({
                    title:"Alert",
                    text: "Surat Perusahaan telah di validasi",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                },function(){ 
                //    didie gan
                    // $("#modal-conf").modal('hide');
                    // $("#modal-conf").modal('hide');
                    // loadElementspengajuan();
                    window.location.reload();
                    loaderPage(false)
                });

            }else{
                loaderPage(false)
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
    
}

function requestconfirmation_(){
    loaderPage(true)
    const file = $('#file').prop('files')[0];
    var isObject = {};
    let formdata = new FormData();
    
    isObject.status = $('input[name="konfirmasi"]:checked').val();
    isObject.nim    = $("#nim").val();
    isObject.perusahaan         = $("#namaper").val();

   
    if(isObject.status == 102){ //ditolak

        

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: baseURL + '/jsondata/konfirmasiperusahaan',
            data: {
                iparam	    : cryptoEncrypt(PHRASE, isObject),
            },
            success: function (response) {
                // $('#modal-add').modal("hide");
                if(response.code == CODE_SUCCESS){
    
                    // document.getElementById("form-data").reset();
                    var object2 = isObject.nimmhs;
                    swal({
                        title: "Alert",
                        text: "Surat permohonan ditolak, silahkan buat surat permohonan kembali",
                        confirmButtonColor: "#66BB6A",
                        type: "success"
                    }, function(){ 
                        // $("tbody").empty();
                        // loadElementsMhs();
                        location.reload()
                        
                    });
                    loaderPage(false)
                }else{
                    loaderPage(false)
                    swal({
                        title: "Alert",
                        text:  response.info+ " Silahkan coba kembali :)",
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });  
                };
    
                loaderPage(false);
                
            },
            error: function () {
                loaderPage(false);
                if(xhr.status != 200){
                    swal({
                        title: "Alert",
                        text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });                        
                }
            }
        });


    } else if (isObject.status == 101){ //diterima
        loaderPage(true)
        // isObject.noref              = $("#noref").val();
        isObject.perusahaan         = $("#namaper").val();
        // isObject.staff              = $("#staff").val();
        // isObject.staffkontak        = $("#kontak").val();
        // isObject.alamat_perusahaan  = $("#alamatper").val();
        // isObject.syarat             = $("#syarat").val();
        // isObject.jumlahmhsw         = $("#jmlmhsw").val();
        // isObject.transport          = $('input[name="transport"]:checked').val();
        // isObject.penginapan         = $('input[name="penginapan"]:checked').val();
        // isObject.makan              = $("#makan").val();
        // isObject.asuransi           = $("#asuransi").val();
        // isObject.lainnya            = $("#lain").val();
        isObject.bukti              = file;
        isObject.tanggalAwal        = dateformats($("#tanggalAwalconf").val());
        isObject.tanggalAkhir       = dateformats($("#tanggalAkhirconf").val());
        console.log(isObject);  


        // if(isObject.noref == null || isObject.noref == ""){
        //     wrongvalidation("No Referensi Tidak Boleh Kosong");
        //     return false;
        // }

        if(isObject.perusahaan == null || isObject.perusahaan ==""){
            wrongvalidation("Nama Perusahaan Tidak Boleh Kosong");
            loaderPage(false)
            return false;

        }

        // if(isObject.staff == null || isObject.staff ==""){
        //     wrongvalidation("Staff Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.staffkontak == null || isObject.staffkontak ==""){
        //     wrongvalidation("Kontak Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.alamat_perusahaan == null || isObject.alamat_perusahaan ==""){
        //     wrongvalidation("Alamat Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.transport == null || isObject.transport ==""){
        //     wrongvalidation("Transport Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.penginapan == null || isObject.penginapan ==""){
        //     wrongvalidation("Penginapan Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.makan == null || isObject.makan ==""){
        //     wrongvalidation("Uang Makan Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.asuransi == null || isObject.asuransi ==""){
        //     wrongvalidation("Asuransi Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        // if(isObject.asuransi == null || isObject.asuransi ==""){
        //     wrongvalidation("Nama Perusahaan Tidak Boleh Kosong");
        //     return false;
        // }

        if(!isFutureDate(isObject.tanggalAwal)){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:" Tanggal tidak valid",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        } else if(!daterangeCheck(isObject.tanggalAwal, isObject.tanggalAkhir)){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:" Tanggal akhir tidak boleh kurang dari tanggal awal",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        } else if(minimalkp(isObject.tanggalAwal, isObject.tanggalAkhir) < 30){
            loaderPage(false)
            swal({
                title: "Peringatan!",
                text:   "Waktu pelaksanaan kerja praktik minimal 30 hari, silahkan ubah tanggal",
                confirmButtonColor: "#2196F3",
                type: "warning"
            });
            return false;
        }


        if(document.getElementById("file").files.length == 0 ){
            loaderPage(false)
            wrongvalidation("File Tidak Boleh Kosong");
            
            
            return false;
        } else {

            var regexpattern = /[\/.](pdf)$/i;
            // let nimMhs = nim;
            let namefile = isObject.bukti.name;
            console.log(namefile)
            if(!regexpattern.test(namefile)){
                loaderPage(false)
                wrongvalidation('File Harus Berupa PDF!');
                return false;
            } 
        }

        formdata.append('file', isObject.bukti);
        // formdata.append('noref', isObject.noref);
        formdata.append('namaper', isObject.perusahaan);
        // formdata.append('staff', isObject.staff);
        // formdata.append('kontakstaff', isObject.staffkontak);
        // formdata.append('alamat', isObject.alamat_perusahaan);
        // formdata.append('syarat', isObject.syarat);
        // formdata.append('jumlahmhsw', isObject.jumlahmhsw);
        // formdata.append('transpot', isObject.transport);
        // formdata.append('penginapan', isObject.penginapan);
        // formdata.append('makan', isObject.makan);
        // formdata.append('asuransi', isObject.asuransi);
        // formdata.append('lainnya', isObject.lainnya);
        formdata.append('tglawal', isObject.tanggalAwal);
        formdata.append('tglakhir', isObject. tanggalAkhir);
        formdata.append('nim', isObject.nim);
        formdata.append('status', isObject.status);
        formdata.append('paramtype', 'admin');

        $.ajax({
            type        : 'POST',
            url         : baseURL + '/jsondata/konfirmasivalid',
            data        : formdata,
            cache       : false,
            processData : false,
            contentType : false,
            success: function (response) {
    
                if(response.code == CODE_SUCCESS){
                    loaderPage(false)
                    // document.getElementById("form-data").reset();
    
                    swal({
                        title:"Alert",
                        text: "Surat konfirmasi telah di validasi, silahkan memilih dosen pembimbing",
                        confirmButtonColor: "#66BB6A",
                        type: "success"
                    },function(){ 
                        // $("#file1").prop("disabled", true);
                        // $("#file1").prop("disabled", true);
                        // $("#file1").prop("disabled", true);
                        // $("#file1").prop("disabled", true);
                        window.location.reload();
                    });
    
                }else{
                    loaderPage(false)
                    swal({
                        title: "Alert",
                        text:  response.info+ " Silahkan coba kembali :)",
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });  
                };
    
                loaderPage(false);
                
            },
            error: function () {
                loaderPage(false);
                if(xhr.status != 200){
                    swal({
                        title: "Alert",
                        text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });                        
                }
            }
        });
    }
}

function downloadsurat(id, nim, dir){
    // window.open(baseURL+"/data/permohonan/surat_permohonan.pdf");
    var exploded = dir.split('/');
    // console.log(exploded[4]);
    // console.log(baseURL+'/data/surat/'+exploded[4]);
    window.open(baseURL+'/data/surat/'+exploded[4]);

}

function minimalkp(tglawal, tglakhir){
    // var tgl1 = tglawal.replaceAll("-", "/"); 
    // var tgl2 = tglakhir.replaceAll("-", "/");
    var tgl1 = convertime(tglawal);
    var tgl2 = convertime(tglakhir);
    
    console.log(tgl1);
    // var date1 = new Date(tgl1); 
    // var date2 = new Date(tgl2); 
    // console.log(date1);
    
    // To calculate the time difference of two dates 
    var Difference_In_Time = tgl2 - tgl1; 
    
    // To calculate the no. of days between two dates 
    var Difference_In_Days = Difference_In_Time / (1000 * 3600 * 24); 
    console.log(Difference_In_Days);
    return Difference_In_Days;
}

function convertime(idate){
   
    var idate = idate.split("-");

    idate = new Date(idate[2], idate[1] - 1, idate[0]).getTime();
    console.log(idate);
    return idate;
}

function dateformats(date){
    var months    = {
        'January': 1,
        'February': 2,
        'March': 3,
        'April': 4,
        'May': 5,
        'June': 6,
        'July': 7,
        'August': 8,
        'September': 9,
        'October': 10,
        'November': 11,
        'December': 12
    };

    var datesplit = date.split(' ')
    var tanggal   = datesplit[0];
    var bulan     = months[datesplit[1]];
    var tahun     = datesplit[2];

    var datestring = tanggal +"-"+bulan+"-"+tahun;
    console.log(datestring)
    // var dateNew     = new Date(date);
    // var dateString  = 
    //     ("0" + (dateNew.getUTCDate()+1)).slice(-2) + "-" +
    //     ("0" + (dateNew.getUTCMonth()+1)).slice(-2) + "-" +
    //     dateNew.getUTCFullYear();

    return datestring;
}

function dateformatss(date){
    var dateNew     = new Date(date);
    var dateString  = 
        ("0" + (1 + dateNew.getUTCDate())).slice(-2) + "-" +
        ("0" + (dateNew.getUTCMonth()+1)).slice(-2) + "-" +
        dateNew.getUTCFullYear();

    return dateString;
}

function isFutureDate(idate){
    var today = new Date().getTime();
    var idate = idate.split("-");

    idate = new Date(idate[2], idate[1] - 1, idate[0]).getTime();
    console.log(idate);
    return (today - idate) < 0;
}

function daterangeCheck(idateAW, idateAK){
    var idateAK = idateAK.split("-");
    var idateAW = idateAW.split("-");

    idateAW = new Date(idateAW[2], idateAW[1] - 1, idateAW[0]).getTime();
    idateAK = new Date(idateAK[2], idateAK[1] - 1, idateAK[0]).getTime()
    return (idateAW - idateAK) < 0;
}

function mhswforgenerate(code){
    var isObject = {};
    loaderPage(true);
    isObject.nim   = $("#nim_mhs").val();
    isObject.isvalid = code;

    console.log(isObject)
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/mhswforgenerate',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            
            
            if(response.code == CODE_SUCCESS){

                // document.getElementById("form-data").reset();
                

            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

loadtembusan();
function loadtembusan(){
    var isObject = {};

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/tembusandefault',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            response = cryptoDecrypt(PHRASE, response.data);
            var data = response.data;
            console.log(data);
            if(response.code == CODE_SUCCESS){
                tembusan = data[0].param_val1;
            }else{
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            }

            loaderPage(false);
            
        },
        error: function () {
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

$("#submitedt").on("click",function(e){
    $(this).attr("disabled",true);
    e.preventDefault();
    var arrAcc  = [];
    var arrAll  = [];
    var arral   = [];
    var counta  = 0;
    var countd  = 0;
    $.each($("input[name='mhswedt[]']:checked"), function(){
        // favorite.push($(this).val());
        arrAcc[counta] = $(this).val();
        counta++
    });

    $.each($("input[name='mhswedt[]']"), function(){
        // favorite.push($(this).val());
        arrAll[countd] = $(this).val();
        countd++
    });

    // alert($('#tglawalh').val());
    var arrDeny = arrAll.filter(function(obj) { return arrAcc.indexOf(obj) == -1; });
    editsurat(arrAcc, arrDeny, arrAll);
})

function editsurat(arrAcc, arrDeny, arrAll){
    var isObject = {};
    isObject.nama_perusahaan    = $("#namaperedt").val();
    isObject.alamat_perusahaan  = $("#alamatedt").val();
    isObject.kode_pos           = $("#posedt").val();
    isObject.penerima_surat     = $("#penerimaedt").val();
    isObject.tembusan           = $("#tembusanedt").val();
    isObject.tanggal_awal       = $("#tglawalh").val();
    isObject.tanggal_akhir      = $("#tglakhirh").val();
    isObject.idpengajuan        = $("#idpengajuanedt").val();
    isObject.create_date        = $("#createdh").val();
    isObject.nim                = $("#nim").val();
    isObject.divisi_penerima    = $("#divisiedt").val();
    isObject.arrAcc             = arrAcc;
    isObject.arrDeny            = arrDeny;
    isObject.arrAll             = arrAll;

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/editsurat',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            if(response.code == CODE_SUCCESS){
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Update surat pengantar Kerja Praktik Berhasil! ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){
                    location.reload();
                });

            }else{
                $("#submitedt").attr("disabled", false);
                swal({
                    title: "Alert",
                    text:  response.info+ " Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });  
            };

            loaderPage(false);
            
        },
        error: function () {
            $("#submitedt").attr("disabled", false);
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}

function rejectedByTU(params){
    swal({
        title: "Peringatan!",
        text: "Tolak surat pengajuan mahasiswa?",
        type: "info",
        showCancelButton: true,
        confirmButtonText: "Ya, Yakin",
        cancelButtonText: "Tidak",
        closeOnConfirm: false,
        closeOnCancel: false
      },
        function (isConfirm) {
          if (isConfirm) {
            rejectsurat(params);
        } else {    
            swal("Pemberitahuan", "Penolakan surat mahasiswa dibatalkan", "error");
        }
    });
}

function rejectsurat(params){
    let isObject = {};

    isObject.id_pengajuan = params;
    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/jsondata/rejectsurat',
        data: {
            iparam	    : cryptoEncrypt(PHRASE, isObject),
        },
        success: function (response) {
            if(response.code == CODE_SUCCESS){
                var object2 = isObject.nimmhs;
                swal({
                    title: "Alert",
                    text: "Tolak surat pengantar Kerja Praktik Berhasil! ",
                    confirmButtonColor: "#66BB6A",
                    type: "success"
                }, function(){
                    location.reload();
                });

            }else{
                swal({
                    title: "Alert",
                    text: "Update surat pengantar Kerja Praktik Berhasil! ",
                    confirmButtonColor: "#66BB6A",
                    type: "error"
                });
            }

            loaderPage(false);
            
        },
        error: function () {
            $("#submitedt").attr("disabled", false);
            loaderPage(false);
            if(xhr.status != 200){
                swal({
                    title: "Alert",
                    text:  xhr.status+"-"+xhr.statusText+" Silahkan coba kembali :)",
                    confirmButtonColor: "#2196F3",
                    type: "error"
                });                        
            }
        }
    });
}



$("#addTembusan").on("click", function(e){
    e.preventDefault();
    

    if(isAddTembusan == 0){
        $html = `<div class="form-group">
                    
                    <input id="tembusaninp`+isAddTembusan+`" type="text" class="form-control" placeholder="Input Tembusan Surat..." >

                </div>`;

        isAddTembusan += 1;
        $("#tembusanExt").append($html);
    }else if(isAddTembusan > 0 && isAddTembusan < 2){
        $html = `<div class="form-group">
                    
                    <input id="tembusaninp`+isAddTembusan+`" type="text" class="form-control" placeholder="Input Tembusan Surat..." >

                </div>`;
        isAddTembusan += 1;
        $("#tembusanExt").append($html);
    }else if(isAddTembusan == 2){
        $html = `<div style="color: red" class="temalrt">Tembusan surat maksimal 3</div>`;
        $("#tembusanExt").append($html);
        isAddTembusan += 1;
        setTimeout(function(){
            $('.temalrt').remove();
            isAddTembusan -= 1;
          }, 3000);

    }
    
    
    
});