Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';


loaddatabrowser(validasiToken);
var ctx = document.getElementById("myPieChart").getContext("2d");
window.myPie = getNewChart(ctx, configpiebw);


window.setInterval(function(){
  
  let province = $('#selectprovince').val();
  let country = $('#selectcountry').val();
  let city =  $('#selectcity').val();
  
  changedata(country, province, city);

},6000); 

function loaddatabrowser(tokeni){
  dates = new Date();
  year = dates.getFullYear();

  var label = [];
  var total = [];

  $.ajax({
    type  : "post",
    data  : "JSON",
    url   : baseURL + "/api/loadpiebrowser",
    async : false,
    data : {
      token : tokeni
    },
    success: function(result){
      // console.log(result);
      let data = result.data;
      // console.log(data[0]['total']);
      for (x in data){
        label[x] = data[x]['browser_name'];
        total[x] = data[x]['total'];
      }
    },  
  });
  configpiebw = {
    type: 'pie',
      data: {
        labels: label,
        datasets: [{
          data: total,
          backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', "#c5c5c5"],
          hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#f6c23e', "#c5c5c5"],
          hoverBorderColor: "rgba(234, 236, 244, 1)",
        }],
      },
      options: {
        maintainAspectRatio: false,
        tooltips: {
          backgroundColor: "rgb(255,255,255)",
          bodyFontColor: "#858796",
          borderColor: '#dddfeb',
          borderWidth: 1,
          xPadding: 15,
          yPadding: 15,
          displayColors: false,
          caretPadding: 10,
        },
        legend: {
          display: false
        },
        cutoutPercentage: 80,
      },
    }    
  
    var colour = ['primary','success','info','warning','secondary'];
    var cols = "";
    for(y in label){
      cols += '<span class="mr-2"><i class="fas fa-circle text-'+colour[y]+'"></i> '+label[y]+'</span>';
    }
    $('#infoChartBrowser').html(cols);
}


 
function getNewChart(canvas, configpiebw) {
  return new Chart(canvas, configpiebw);
}


loadselectfirst(validasiToken);
function loadselectfirst(tokeni){
  option = '';
  $.ajax({
    type  : "post",
    dataType  : "JSON",
    url   : baseURL + "/api/loadcountry",
    data : {
      token : tokeni
    },
    success:function(result){
      let data = result.data;
      option = '';
      option += `<option value=''>All Country</option>`
      for (x in data){  
        option += `<option value = `+data[x]['country']+`>`+data[x]['country']+`</option>`
      }
      $('#selectcountry').html(option);
    }
  }); 
 
    optionprov = `<option value=''>All Province</option>`
    $('#selectprovince').html(optionprov);
  
    optioncity = `<option value=''>All City</option>`
    $('#selectcity').html(optioncity);
  
}

$('#selectcountry').change(function(){
  let country = $('#selectcountry').val();
  let province =  $('#selectprovince').val();
  let city =  $('#selectcity').val();
 
  $.ajax({
    type  : "post",
    dataType  : "JSON",
    url   : baseURL + "/api/loadprovince",
    data : {
      token : validasiToken,
      country : country
    },success:function(result){
      let data = result.data;
      optionprov = '';
      optionprov = `<option value=''>All Province</option>`;

      for (x in data){
        optionprov += `<option value = '`+data[x]['province']+`'>`+data[x]['province']+`</option>`
      }
      $('#selectprovince').html(optionprov);
    }
  });

  optionprov = `<option value=''>All Province</option>`
  $('#selectprovince').html(optionprov);

  optioncity = `<option value=''>All City</option>`
  $('#selectcity').html(optioncity);

  changedata(country, null, null);

});

$('#selectprovince').change(function(){
  let province = $('#selectprovince').val();
  let country = $('#selectcountry').val();
  let city =  $('#selectcity').val();

  $.ajax({
    type  : "post",
    dataType  : "JSON",
    url   : baseURL + "/api/loadcity",
    data : {
      token : validasiToken,
      country : country,
      province : province
    },success:function(result){
      let data = result.data;

      optioncity = '';
      optioncity += `<option value=''>All City</option>`;

      for (x in data){
        optioncity += `<option value = `+data[x]['city']+`>`+data[x]['city']+`</option>`
      }
      $('#selectcity').html(optioncity);
    }
  });

  changedata(country, province, city);

});


$('#selectcity').change(function(){
  let province = $('#selectprovince').val();
  let country = $('#selectcountry').val();
  let city =  $('#selectcity').val();
  

  changedata(country, province, city);
  

})

function changedata(country, province, city){
    // console.log(country+province+city)
  $.ajax({
    type  : "post",
    dataType  : "JSON",
    url   : baseURL + "/api/loadbrowserbylocat",
    data : {
      token : validasiToken,
      country : country,
      province : province,
      city : city
    },success:function(result){
      let data = result.data;

      var label = [];
      var total = [];
      
      for(x in data){
        label[x] = data[x]['browser_name'];
        total[x] = data[x]['total'];
      }

      configpiebwnew = {
        labels: label,
            datasets: [{
              data: total,
              backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', "#c5c5c5"],
              hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#f6c23e', "#c5c5c5"],
              hoverBorderColor: "rgba(234, 236, 244, 1)",
            }],
        }
      myPie.data = configpiebwnew;
      window.myPie.update();

      let colour = ['primary','success','info','warning','secondary'];
      var cols = "";
      for(y in label){
        cols += '<span class="mr-2"><i class="fas fa-circle text-'+colour[y]+'"></i> '+label[y]+'</span>';
      }
      $('#infoChartBrowser').html(cols);
    }
  });
}


