// Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';
$("#websiteName").html(websitetitle);

LoadDadta(validasiToken);
function LoadDadta(token){
    /* save data */
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/api/loadchartimage',
        data: {
            token   : token,
            country : null,
            province: null,
            city    : null
        },
        success: function(result){
            // console.log(result);
          
            let data = result.data;            
            
            var image_name = [];
            let jumlah = [];
            for(x in data){
                image_name[x] = data[x].nodeimage;
                jumlah[x] = data[x].count;
            }
                    
            var configimage = {
                type: 'pie',
                data: {
                    labels: image_name,
                    datasets: [{
                        data: jumlah,
                        backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', "#c5c5c5"],
                        hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#ffd700', '#c5c5c5'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                    },
                    legend: {
                        display: false
                    },
                    cutoutPercentage: 0,
                },
            };

            var ctx = document.getElementById("myPieChart4").getContext("2d");
            window.myPieImage = getNewChart(ctx, configimage);

            let colour = ['primary','success','info','warning','secondary'];
                        
            for(y in data){
                var cols = "";
                cols += '<span class="mr-2"><i class="fas fa-circle text-'+colour[y]+'"></i> '+image_name[y]+'</span>';
                $('#infoChartImage').append(cols);
            }
        }
        
    });
}

function getNewChart(canvas, configpiebw) {
    return new Chart(canvas, configpiebw);
}


loadselectfirstimage(validasiToken);
function loadselectfirstimage(tokeni){
  option = '';
  $.ajax({
    type  : "post",
    dataType  : "JSON",
    url   : baseURL + "/api/loadcountry",
    data : {
      token : tokeni
    },
    success:function(result){
      let data = result.data;
      option = '';
      option += `<option value=''>All Country</option>`
      for (x in data){  
        option += `<option value = `+data[x]['country']+`>`+data[x]['country']+`</option>`
      }
      $('#selectcountryimage').html(option);
    }
  }); 
 
    optionprov = `<option value=''>All Province</option>`
    $('#selectprovinceimage').html(optionprov);
  
    optioncity = `<option value=''>All City</option>`
    $('#selectcityimage').html(optioncity);
  
}

$('#selectcountryimage').change(function(){
    let country = $('#selectcountryimage').val();
    let province =  $('#selectprovinceimage').val();
    let city =  $('#selectcityimage').val();
   
    $.ajax({
      type  : "post",
      dataType  : "JSON",
      url   : baseURL + "/api/loadprovince",
      data : {
        token : validasiToken,
        country : country
      },success:function(result){
        let data = result.data;
        optionprov = '';
        optionprov = `<option value=''>All Province</option>`;
  
        for (x in data){
          optionprov += `<option value = '`+data[x]['province']+`'>`+data[x]['province']+`</option>`
        }
        $('#selectprovinceimage').html(optionprov);
      }
    });
  
    optionprov = `<option value=''>All Province</option>`
    $('#selectprovinceimage').html(optionprov);
  
    optioncity = `<option value=''>All City</option>`
    $('#selectcityimage').html(optioncity);
  
    changedataimage(country, province, city);
  
});

$('#selectprovinceimage').change(function(){
    let country = $('#selectcountryimage').val();
    let province =  $('#selectprovinceimage').val();
    let city =  $('#selectcityimage').val();
  
    $.ajax({
      type  : "post",
      dataType  : "JSON",
      url   : baseURL + "/api/loadcity",
      data : {
        token : validasiToken,
        country : country,
        province : province
      },success:function(result){
        let data = result.data;
  
        optioncity = '';
        optioncity += `<option value=''>All City</option>`;
  
        for (x in data){
          optioncity += `<option value = `+data[x]['city']+`>`+data[x]['city']+`</option>`
        }
        $('#selectcityimage').html(optioncity);
      }
    });
  
    changedataimage(country, province, city);
  
});


$('#selectcityimage').change(function(){
    let country = $('#selectcountryimage').val();
    let province =  $('#selectprovinceimage').val();
    let city =  $('#selectcityimage').val();
  
    changedataimage(country, province, city);
});

function changedataimage($country, $province, $city){
    
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: baseURL + '/api/loadchartimage',
        data: {
            token   : validasiToken,
            country : $country,
            province: $province,
            city    : $city
        },
        success: function(result){
            // console.log(result);
            let data = result.data;
                        
            let image_name = [];            
            let jumlah = [];
               
            for(x in data){
                image_name[x] = data[x].nodeimage;
                jumlah[x] = data[x].count;
            }

            configimagenew = {
                labels: image_name,
                datasets: [{
                    data: jumlah,
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', "#c5c5c5"],
                    hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#ffd700', '#c5c5c5'],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            }
            
            myPieImage.data = configimagenew;
            window.myPieImage.update();

            let colour = ['primary','success','info','warning','secondary'];
                        
            for(y in data){
                var cols = "";
                cols += '<span class="mr-2"><i class="fas fa-circle text-'+colour[y]+'"></i> '+image_name[y]+'</span>';
                $('#infoChartImage').append(cols);
            }           
        }
    });
}