loadUserWebsite(validasiToken);

var tableToExcel = (function() {
    var uri = 'data:application/vnd.ms-excel;base64,'
      , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>'
      , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
      , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
    return function(table, name) {
      if (!table.nodeType) table = document.getElementById(table)
      var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
      window.location.href = uri + base64(format(template, ctx))
    }
  })();


    function loadUserWebsite(token){
        $(document).ready(function(){
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: baseURL + '/api/loaduserweb',
                data: {
                    token  : token,
                },
                success: function(result){
                    
                    if(result){
                        let data = result.data;
                        let counter = 1;
                        for(z in data){
                            var cols = "";
                            cols += '<tr>'
                            cols += '<td>'+counter+'</td>'
                            cols += '<td>'+data[z].ip_address_client+'</td>';
                            cols += '<td>'+data[z].mac_address+'</td>';
                            cols += '<td>'+data[z].city+'</td>';
                            cols += '<td>'+data[z].browser_name+'</td>';
                            cols += '<td>'+data[z].ip_address_public+'</td>';
                            cols += '<td>'+data[z].date_first_visit+'</td>';
                            cols += '</tr>'
                            $("#tbluserwebinfo").append(cols);
                            counter++;
                        }
                        $('#dataTable').DataTable({  
                            scrollY:        '350px',
                            scrollX:        false,
                            fixedHeader: true,
                            scrollCollapse: true,
                            autoWidth: false,
                            paging:         true,
                            columnDefs: [
                              {width: 30, targets: 0},
                              {width: 200, targets: 1},
                              { width: 200, targets: 2 },
                              { width: 150, targets: 3 },  
                              { width: 150, targets: 4 },
                              { width: 200, targets: 5 },
                              { width: 150, targets: 6 },   
                            ],
                        });

                    }else{
                        alert(result.info);
                    }
                },
                error: function(xhr){
                    alert(xhr.status+'-'+xhr.statusText); 
                }
            });
        });
    }