// Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';
$("#websiteName").html(websitetitle);

LoadDadta(validasiToken);
    function LoadDadta(token){
        $(document).ready(function(){
            /* save data */
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: baseURL + '/api/loadchart',
                data: {
                    token   : validasiToken,
                },
                success: function(result){
                    if(result.code == 0){
                        
                        let data = result.data;
                        
                        var nama_kota = [];
                        let jumlah = [];
                        //let counter = 0;
                        for(x in data){
                            nama_kota[x] = data[x].city;
                            jumlah[x] = data[x].sumlocation;
                        }
                        
                        // console.log(nama_kota);
                        // console.log(jumlah);

                        var ctx = document.getElementById("myPieChart2");
                        var myPieChart = new Chart(ctx, {
                        type: 'pie',
                        data: {
                            labels: nama_kota,
                            datasets: [{
                            data: jumlah,
                            backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', "#c5c5c5"],
                            hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#ffd700', '#c5c5c5'],
                            hoverBorderColor: "rgba(234, 236, 244, 1)",
                            }],
                        },
                        options: {
                            maintainAspectRatio: false,
                            tooltips: {
                            backgroundColor: "rgb(255,255,255)",
                            bodyFontColor: "#858796",
                            borderColor: '#dddfeb',
                            borderWidth: 1,
                            xPadding: 15,
                            yPadding: 15,
                            displayColors: false,
                            caretPadding: 10,
                            },
                            legend: {
                            display: false
                            },
                            cutoutPercentage: 0,
                        },
                        });

                        let colour = ['primary','success','info','warning','secondary'];
                        
                        for(y in data){
                            var cols = "";
                            cols += '<span class="mr-2"><i class="fas fa-circle text-'+colour[y]+'"></i> '+nama_kota[y]+'</span>';
                            $('#infoChartLokasi').append(cols);
                        }

                    }else{
                        alert(result.info);
                    }
                },
                error: function(xhr) {
                    alert(xhr.status+'-'+xhr.statusText);            
                }
            });
        });
    }
