<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application;

use Zend\Router\Http\Literal;
use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
			'404' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/:*',
                    'defaults' => [
                        'controller' => Master\RouteNotFoundController::class,
                        'action' => 'routenotfound',
                    ],
                ],
                'priority' => -1000,
            ],
            'home' => [
                'type' => Literal::class,
                'options' => [
                    'route'    => '/',
                    'defaults' => [
                        'controller' => Controller\UseranalyticsController::class,
                        'action'     => 'menu',
                    ],
                ],
            ],
            'application' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/application[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'admin' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/admin',
                    'defaults' => [
                        'controller' => Controller\UserController::class,
                        'action'     => 'adminpage',
                    ],
                ],
            ],
			'api' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/api[/][:action][/:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '[0-9]+',
                    ),
                    'defaults' => [
                        'controller' => Controller\ApiController::class,
                        'action'     => 'index',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
            'signin' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/api/login',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => [
                        'controller' => Controller\ApiController::class,
                        'action'     => 'login',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
            'login' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/login[/][:action][/:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => [
                        'controller' => Controller\UserController::class,
                        'action'     => 'login',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
            'user' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/user[/][:action][/:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => [
                        'controller' => Controller\UserController::class,
                        'action'     => 'login',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
            'useranalytics' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/useranalytics[/][:action][/:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => [
                        'controller' => Controller\UseranalyticsController::class,
                        'action'     => 'menu',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
            'pluginuser' => [
                'type'    => Segment::class,
                'options' => [
                    'route' => '/pluginuser[/][:action][/:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => [
                        'controller' => Controller\PluginuserController::class,
                        'action'     => 'index',
                        'isAuthorizationRequired' => false
                    ],
                ],
            ],
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => Factory\IndexControllerFactory::class,
            Controller\UserController::class => Factory\UserControllerFactory::class,
            Controller\UseranalyticsController::class => Factory\UseranalyticsControllerFactory::class,
            Controller\PluginuserController::class => Factory\PluginuserControllerFactory::class,
            // Master\GlobalActionController::class => Factory\GlobalActionControllerFactory::class,
            Controller\ApiController::class => Factory\ApiControllerFactory::class,
            // Controller\ApiController::class => InvokableFactory::class,
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions'       => true,
        'doctype'                  => 'HTML5',
        'not_found_template'       => 'error/404',
        'exception_template'       => 'error/index',
        'template_map' => [
            'layout/layout'           => __DIR__ . '/../view/layout/login.phtml',
            'application/index/index' => __DIR__ . '/../view/application/index/index.phtml',
            'error/404'               => __DIR__ . '/../view/error/404.phtml',
            'error/index'             => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
    ],

    'databases' => array(
        'primary'     => array(
            'driver'    => 'pgsql',
            'host'      => '103.126.28.66',
            'username'  => 'postgres',
            'password'  => 'khansia215758',
            'port'      => 5432,
            'schema'    => 'boasql',
        ),
    ),

    'php' => array(
        'display_errors'         => false,
        'error_reporting'        => E_ALL,
        'max_execution_time'     => 200,
        'session.gc_maxlifetime' => 86400, //24 jam
    ),
];
