<?php
/**
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Khansia\Generic\Result;

class UseranalyticsController extends \Application\Master\GlobalActionController 
{
    public function __construct($headScript)
    {
        $this->headScript = $headScript;
        
    }

    public function indexAction()
    {
        // $view =  new ViewModel();
        // $result = new Result();

        // return $view;
    }

    public function listdataAction()
    {
        $this->isLoggedIn();
        //$this->layout("layout/dashboardLayout");
        
        $view   = new ViewModel();
        $result = new Result();
        //$this->layout("layout/dashboardLayout");
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        
        
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');        
        $this->headScript->appendFile('/action-js/index-js/action-listdata.js');        
        
        return $view;
        
    }

    public function dashboardAction(){
        $this->isLoggedIn();
        
        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }

        $view = new ViewModel();
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        $request = $this->getRequest(); //$this should refer to a controller
        $session_data   =   $this->getSession();
        $urlwebname = $_GET['webname'];
        $urltoken = $_GET['token'];


        $session_data->put(null, array(
            'token'         => $urltoken,
            'websitename'   => $urlwebname,
        
        ));

        //$session_data->flush();

        $view->setVariables(array(
            'user_id'       => $session_data->get('user_id'),
            'username'      => $session_data->get('usernamed'),
        ));

        
        //document.title = "Lihat Token";
        //  $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');        
        //  $this->headScript->appendFile('/template/js/demo/chart-pie2-demo.js');
        //  $this->headScript->appendFile('/template/js/demo/chart-bar-demo.js');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');
        $this->headScript->appendScript(' var websitetitle = "' . $urlwebname . '"');     
        $this->headScript->appendScript(' document.title = "Dashboard"');  
        //Load Chart
        $this->headScript->appendFile('/template/js/demo/chart-pie2-demo.js');
        $this->headScript->appendFile('/template/js/demo/chart-pie-demo.js');
        $this->headScript->appendFile('/template/js/demo/chart-pie3-demo.js');
        $this->headScript->appendFile('/template/js/demo/table-user-info.js');
        $this->headScript->appendFile('/template/js/demo/chart-area-demo.js');
        $this->headScript->appendFile('/template/js/demo/chart-bar-demo.js');
        $this->headScript->appendFile('/template/js/demo/chart-bar2-demo.js');
        $this->headScript->appendFile('/action-js/index-js/action-language.js');
        $this->headScript->appendFile('/action-js/index-js/confdb-action.js');
        //$this->headScript->appendFile('/template/js/demo/datatables-demo.js');
        $this->layout()->myParameter = $session_data->get('usernamed');
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname= $session_data->get('websitename');
        $this->layout("layout/menu");
        return $view;
    }

    
    // public function registrasiAction(){
    //     $view = new ViewModel();
    //     $uri     = $this->getRequest()->getUri();
    //     $baseurl = sprintf('//%s', $uri->getHost());

    //     $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"'); 
    //     $this->headScript->appendFile('/action-js/index-js/register-user-action.js');
        
    //     $this->layout("layout/login");
    //     return $view;
    // }

    public function menuAction(){
        $this->isLoggedIn();
        $view = new ViewModel();
        $session_data   =   $this->getSession();
        
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        //include js load token
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"'); 
        $this->headScript->appendFile('/action-js/index-js/action-websitelist.js');
        // $dataSession = array(
        //     'user_id'       => $session_data->get('user_id'),
        // );

        $view->setVariables(array(
            'user_id'       => $session_data->get('user_id'),
            'username'      => $session_data->get('usernamed'),
            'email'         => $session_data->get('email'),
            'token'         => $session_data->get('token'),
        ));
        //print_r($session_data->get('token'));die;
        $this->layout()->myParameter = $session_data->get('usernamed');
        $this->layout()->token= $session_data->get('token');
        $this->layout()->webname= $session_data->get('websitename');
        $this->layout("layout/menu");
        return $view;
    }

    public function tambahAction(){
        $this->isLoggedIn();
        $view = new ViewModel();
        $session_data   =   $this->getSession();

        $cek = hash_hmac('sha512', uniqid(mt_rand(), true), 'Useranalytics');
        
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        $iduser  = $session_data->get('user_id');

        //include js load token
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"'); 
        $this->headScript->appendScript(' var iduser = "' . $iduser . '"'); 
        $this->headScript->appendFile('/action-js/index-js/generate-website-token.js');
        $view->setVariables(array(
            'token'     => $cek,
            'id_user'   => $session_data->get('user_id'),
        ));

        $this->layout()->myParameter = $session_data->get('usernamed');
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname     = $session_data->get('websitename');
        $this->layout("layout/menu");
        return $view;
    }

    public function cobainAction(){
        $view   = new ViewModel();
        $result = new Result();
     
        /* get url */
        $uri     = $this->getRequest()->getUri();
        $baseurl = sprintf('//%s', $uri->getHost());
        
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');        
        $this->headScript->appendFile('/template/js/demo/website-list-action.js');
        //$this->headScript->appendFile('/action-js/index-js/action-listdata2.js');
        // $this->headScript->appendFile('/template/js/demo/chart-bar-demo.js');

        $this->layout('layout/newlayout');
        return $view;
    }

    public function lihattokenAction(){
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
        ));
        
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');        
        $this->headScript->appendFile('/template/js/demo/website-list-action.js');
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname= $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function othertableAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');         
        $this->headScript->appendFile('/template/js/demo/table-user-other.js');
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebinfoAction(){
        $pagename = 'info user';
        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        $session_data->put(null, array(
            'pagename'         => $pagename,
        ));
        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        //$this->headScript->appendFile('/template/js/demo/other-list-action.js');//js nya ganti lagi
        $this->headScript->appendFile('/template/js/demo/table-user-info.js');//js nya ganti lagi
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebpageAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        $this->headScript->appendFile('/template/js/demo/table-user-page.js');//js nya ganti lagi
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebbuttonAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        $this->headScript->appendFile('/template/js/demo/table-user-button.js');//js nya ganti lagi
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebbrowserAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        $this->headScript->appendFile('/template/js/demo/table-user-browser.js');//js nya ganti lagi

        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebimageAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }
        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   =   $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));
        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        $this->headScript->appendFile('/template/js/demo/table-user-image.js');//js nya ganti lagi
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

    public function userwebvideoAction(){

        if($_GET['token'] == null){
            $this->redirect()->toRoute('home');
        }

        $view           = new ViewModel();
        $uri            = $this->getRequest()->getUri();
        $baseurl        = sprintf('//%s', $uri->getHost());
        $session_data   = $this->getSession();
        // $session_data->set()
        $urltoken       = $_GET['token'];

        
        $view->setVariables(array(
            'id_user'   => $session_data->get('user_id'),
            'token'     => $urltoken,
        ));

        // print_r($urltoken);
        $this->layout()->myParameter = $session_data->get('usernamed');
        //$this->headLink->appendStyleSheet('/template/vendor/fontawesome-free/css/fonts.css');
        $this->headScript->appendScript(' var baseURL = "' . $baseurl . '"');   
        $this->headScript->appendScript(' var validasiToken = "' . $urltoken . '"');    

        $this->headScript->appendFile('/template/js/demo/table-user-video.js');//js nya ganti lagi
        //print_r($baseurl);die;
        $this->layout()->token       = $session_data->get('token');
        $this->layout()->webname    = $session_data->get('websitename');
        $this->layout('layout/menu');
        return $view;
    }

  


}
