<?php
namespace Application\Model;

use Khansia\Generic\Objects\Map;
use Khansia\Generic\Objects\Mapper;
use Khansia\Generic\Set;
use Khansia\Generic\Result as Result;

class Param extends Mapper {
	
	private $_storage;

    public function __construct(\Application\Model\Param\Storage\Skeleton $storage) {
		$this->_storage = $storage;
        $this->_result = new Result();

		parent::__construct(
                array(),
                array(
					// this mapper table on db
                ),
				parent::CASE_INSENSITIVE
			);
	}	
	
	
    public function getParam($paramtype = null, $param_val3 = null, $param_parent = null){
        $data = $this->_storage->loadParam($paramtype, $param_val3, $param_parent);
        return $data;
    }

    public function saveGlobal($param, $table){
        $data = $this->_storage->saveGlobal($param, $table);
        return $data;
    }
   
    public function updateGlobal($tabel, $data, $where){
        $data = $this->_storage->updateGlobal($tabel, $data, $where);
        return $data;
    }

    public function getLastSeqPostgree($tabel, $column){
        $data = $this->_storage->getLastSeqPostgree($tabel, $column);
        return $data;
    }

    public function loadUser($id = null){
        $data = $this->_storage->loadUserData($id);
        return $data;
    }

    public function loadChart($id){
        $data = $this->_storage->loadChartData($id);
        return $data;
    }
    public function loadChartimage($idweb, $country, $province, $city){
        $data = $this->_storage->loadChartDataimage($idweb, $country, $province, $city);
        return $data;
    }
    public function loadChartbutton($idweb, $country, $province, $city){
        $data = $this->_storage->loadBarButtonData($idweb, $country, $province, $city);
        return $data;
    }

    public function getpiebrowserdata($idweb){
        $data = $this->_storage->loadPieBrowserData($idweb);
        return $data;
    }
    public function getbrowserbylocat($idweb, $city, $province, $country){
        $data = $this->_storage->loadbrowserbylocat($idweb, $city, $province, $country);
        return $data;
    }
    public function getpagebylocat($idweb, $city, $province, $country){
        $data = $this->_storage->loadpagebylocat($idweb, $city, $province, $country);
        return $data;
    }
    public function getvisitorbytime($idweb, $year, $month, $province, $country){
        $data = $this->_storage->loadvisitorbytime($idweb, $year, $month, $province, $country);
        return $data;
    }

    public function loadTableUser($id){
        $data = $this->_storage->loadTableUserData($id);
        return $data;
    }

    public function loadChartPengunjung($id = null){
        $data = $this->_storage->loadAreaPengunjungData($id);
        return $data;
    }

    public function loadChartHalaman($id){
        $data = $this->_storage->loadBarHalamanData($id);
        return $data;
    }



    public function loadUserLogin($id = null){
        $data = $this->_storage->userLoginData($id);
    }
    
    public function deleteGlobal($tabel, $where){
        $data = $this->_storage->deleteGlobal($tabel, $where);
        return $data;
    }

    public function loadWebsiteUser($id){
        $data = $this->_storage->loadWebsiteUser($id);
        return $data;
    }

    public function loadUsername($id){
        $data = $this->_storage->loadUsername($id);
        return $data;
    }

        
    public function validateWebToken($websiteName, $token){
        $data = $this->_storage->validateWebToken($websiteName, $token);
        return $data;
    }

    public function loadtokenid($token){
        $data = $this->_storage->loadtokenid($token);
        return $data;
    }

    public function loadkey($key){
        $data = $this->_storage->loadkey($key);
        return $data;
    }

    public function setuserdb($dataarray, $location, $browser, $nameweb, $page){
        $data = $this->_storage->setuserdb($dataarray, $location, $browser, $nameweb, $page);
        return $data;
    }
    public function setLocationdb($city, $province, $country, $where){
        $data = $this->_storage->setLocationdb($city, $province, $country, $where);
        return $data;
    }
    public function getinsertlocation($location){
        $data = $this->_storage->insertlocation($location);
        return $data;
    }
    public function getnameweb($token){
        $data = $this->_storage->namewebsite($token);
        return $data;
    }
    
    public function getweb($token){
        $data = $this->_storage->getweb($token);
        return $data;
    }

    public function setbehavbtn($behavbtn, $page, $web, $user, $browser){
        $data = $this->_storage->setbehavbtn($behavbtn, $page, $web, $user, $browser);
        return $data;
    }
    public function setbehavimg($behavimg, $page, $web, $user, $browser){
        $data = $this->_storage->setbehavimg($behavimg, $page, $web, $user, $browser);
        return $data;
    }
    public function setbehavother($behavother, $page, $web, $user,  $browser){
        $data = $this->_storage->setbehavother($behavother, $page, $web, $user,  $browser);
        return $data;
    }
    public function setbehavideo($behavideo, $page, $web, $user, $browser){
        $data = $this->_storage->setbehavideo($behavideo, $page, $web, $user, $browser);
        return $data;
    }
    public function gettotalvisitor($idweb){
        $data = $this->_storage->totalvisitor($idweb);
        return $data;
    }
    public function gettotalocation($idweb){
        $data = $this->_storage->totallocation($idweb);
        return $data;
    }
    public function getpageviews($idweb){
        $data = $this->_storage->pageviews($idweb);
        return $data;
    }
    public function getnewvisitor($idweb){
        $data = $this->_storage->newvisitor($idweb);
        return $data;
    }
    public function getyearvisitor($idweb){
        $data = $this->_storage->loadyearvisitor($idweb);
        return $data;
    }

    public function getTablePage($idweb){
        $data = $this->_storage->loadtablepage($idweb);
        return $data;
    }

    public function getTableButton($idweb){
        $data = $this->_storage->loadtablebutton($idweb);
        return $data;
    }
    public function getTableBrowser($idweb){
        $data = $this->_storage->loadtablebrowser($idweb);
        return $data;
    }
    public function getTableVideo($idweb){
        $data = $this->_storage->loadtablevideo($idweb);
        return $data;
    }
    public function getTableImage($idweb){
        $data = $this->_storage->loadtableimage($idweb);
        return $data;
    }
    public function getTableOther($idweb){
        $data = $this->_storage->loadtableother($idweb);
        return $data;
    }
    public function getcountry($idweb){
        $data = $this->_storage->loadcountry($idweb);
        return $data;
    }
    public function getprovince($idweb, $country){
        $data = $this->_storage->loadprovince($idweb, $country);
        return $data;
    }
    public function getcity($idweb, $country, $province){
        $data = $this->_storage->loadcity($idweb, $country, $province);
        return $data;
    }
    public function getnumbervisitor($idweb, $year){
        $data = $this->_storage->loadnumbervisitor($idweb, $year);
        return $data;
    }

    public function getmonthvisitor($idweb, $year){
        $data = $this->_storage->loadmonthvisitor($idweb, $year);
        return $data;
    }

    public function getvisitorbymonth($idweb, $year, $month){
        $data = $this->_storage->loadvisitorbymonth($idweb, $year, $month);
        return $data;
    }

    public function loadmaxweb($iduser){
        $data = $this->_storage->loadmaxweb($iduser);
        return $data;
    }

}
